"""
* Copyright 2019 -  Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.md" file in the SDK.
"""
from __future__ import print_function

import sys
import os
import paramiko

if hasattr(__builtins__, 'raw_input'):
  input=raw_input

class Unbuffered(object):
   def __init__(self, stream):
       self.stream = stream
   def write(self, data):
       self.stream.write(data)
       self.stream.flush()
   def writelines(self, datas):
       self.stream.writelines(datas)
       self.stream.flush()
   def __getattr__(self, attr):
       return getattr(self.stream, attr)

def yes_no_prompt(prompt, isNoDefault=False):
    while True:
        user_in = input(prompt)
        if user_in.strip() == 'y' or user_in.strip() == 'Y':
            return True
            break
        elif user_in.strip() == 'n' or user_in.strip() == 'N':
            return False
            break
        elif user_in.strip() == '':
                if isNoDefault:
                    return False
                else:
                    return True
                break
        else:
            if not invertLogic:
                print('Please select ([y]/n).\n')
            else:
                print('Please select (y/[n]).\n')
            continue

def sendCommand(client, command):
    stdin, stdout, stderr = client.exec_command(command)
    while True:
        text = stdout.read()
        if len(text) > 0:
            print(text)
        if stdout.channel.exit_status_ready():
            break

def mkdir_p(sftp, remote_directory):
    """Change to this directory, recursively making new folders if needed.
    Returns True if any folders were created."""
    if remote_directory == '/':
        # absolute path so change directory to root
        sftp.chdir('/')
        return
    if remote_directory == '':
        # top-level relative directory must exist
        return
    try:
        sftp.chdir(remote_directory) # sub-directory exists
    except IOError:
        dirname, basename = os.path.split(remote_directory.rstrip('/'))
        mkdir_p(sftp, dirname) # make parent directories
        sftp.mkdir(basename) # sub-directory missing, so created it
        sftp.chdir(basename)
        return True

def copyFolderToPlatform(client, localFolder, extensions=[]):
    #Copies folder and all contents to deployment directory with same folder name
    for (dirpath, dirnames, filenames) in os.walk(localFolder):
        for f in filenames:
            if os.path.basename(__file__) in f:
                break

            local_filepath = os.path.abspath(os.path.join(dirpath, f))

            doCopy = True
            if len(extensions) > 0:
                _, extension = os.path.splitext(local_filepath)
                doCopy = extension[1:] in extensions

            #print('{0}, {1}'.format(local_filepath, doCopy))
            if doCopy:
                remote_filepath = deployment_dir + local_filepath.replace(cwd,'').replace('\\', '/')
                remote_folderpath = deployment_dir + dirpath.replace(cwd,'').replace('\\', '/')
                mkdir_p(client, remote_folderpath)
                client.put(local_filepath, remote_filepath)

#Unbuffered output
sys.stdout = Unbuffered(sys.stdout)

#Getting Necessary Directories
cwd = os.path.dirname(os.path.realpath(__file__))
c_src_dir = os.path.join(cwd, 'c_src')

#Choose Build Folder Containing Generated C File
print("\nList of folders in current working directory:")
for d in next(os.walk('.'))[1]:
    print(d)

valid_dir = False
while not valid_dir:
    build_folder_name = input('\nPlease specify local folder to deploy to the platform and build [test1]: ').strip()
    if build_folder_name == '':
        build_folder_name = 'test1'
    if not os.path.isdir(os.path.join(cwd, build_folder_name)):
        print("Not a valid directory\n")
        continue
    elif build_folder_name == "":
        print("Build folder cannot be current directory\n")
        continue
    valid_dir = True
    local_build_dir = os.path.join(cwd, build_folder_name)

#Choose Deployement Directory Containing Generated C File
deployment_dir = '/home/analog/src/example/'
if not yes_no_prompt("\n\nCurrent deployment directory is: /home/analog/src/example/\nContinue?([y]/n)"):
    deployment_dir = '/home/analog/' + input('\nPlease specify deployment directory: ' + '/home/analog/').strip() + '/'
remote_build_dir = os.path.join(deployment_dir, build_folder_name)

# Get connection info
host_ip = '192.168.1.10'
user = 'root'
pw = 'analog'
port = 22
if not yes_no_prompt("\n\nCurrent connection info: \nIP: 192.168.1.10 \nUsername: root \nPassword: analog \nPort Number: 22\nContinue?([y]/n)"):
    host_ip = input('\nPlease specify ip address: ').strip()
    user = input('\nPlease specify username: ').strip()
    pw = input('\nPlease specify password: ').strip()
    port = input('\nPlease specify port number: ').strip()

#Connecting to Platform
print("Connecting to platform...")
client = paramiko.SSHClient()
client.load_system_host_keys()
client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
client.connect(host_ip, port, user, pw)
print("Done")

#Starting File Transfer Instance
ftp_client = client.open_sftp()

#Deleting C_SRC and Build Folder from Platform in case of changes made
sendCommand(client, 'cd ' + remote_build_dir + '; rm -r ./c_src')
sendCommand(client, 'cd ' + remote_build_dir + '; rm -r ./' + build_folder_name)

#Copying the C API, Build Folder, and Makefile to the Platform
print("Copying source code to platform...")
copyFolderToPlatform(ftp_client, c_src_dir)
print("Done\n")

print("Copying build folder to platform...")
copyFolderToPlatform(ftp_client, local_build_dir, extensions=['c', 'h'])
print("Done\n")

print("Copying makefile to platform...")
c_src_makefile = os.path.join(c_src_dir, 'makefile')
remote_build_makefile = remote_build_dir + '/makefile'
print('{0}, {1}'.format(c_src_makefile, remote_build_makefile))
ftp_client.put(c_src_makefile, remote_build_makefile)
print("Done\n")

print("Copying memory_profile.py to platform...")
ftp_client.put(os.path.join(cwd, 'memory_profile.py'), os.path.join(deployment_dir, 'memory_profile.py'))
print("Done\n")

#Closing File Transfer Instance
ftp_client.close()
print('\n\n')

proceed_with_make = yes_no_prompt('Do you want to a with building the source on the platform using this script (not recommended)? (y/[n])', True)
if proceed_with_make:
    manual_make = yes_no_prompt('Warning: Automatically compiling using the makefile can be very slow. \nManually compile through PuTTY? ([y]/n)')
    if manual_make:
        print('\nUse the following commands and then close PuTTY:\ncd ' + remote_build_dir + '\nmake clean\nmake\nexit\n')      #Make clean probably not necessary
        try:
            os.system("putty.exe -ssh %s@%s %s -pw %s") % (user, host_ip, port, pw)     #Opening PuTTY through command prompt
        except:
            print('Failed to run PuTTY command.  Check to make sure it is on the path.  The code has been copied so you can manually PuTTY in and procoeed to build the code on the platform.')
    else:
        print("\nCompiling makefile on platform...\n\n")
        sendCommand(client, 'cd ' + os.path.join(deployment_dir, build_folder_name) + '; make clean; make')     #Make clean probably not necessary
        print("\nDone")

    print("\nRunning executable on platform...\n\n")
    sendCommand(client, 'cd ' + remote_build_dir + '; ./example;')       #Running executable on platform
    print("\nDone")
    print('\n\n')
else:
    print("\nTo build please use PuTTY to cd into '%s' and run 'make'." % remote_build_dir)

print("Completed.")
client.close()
