/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/
#ifdef __KERNEL__
#ifndef __LINUX_TIMER_H__
#define __LINUX_TIMER_H__

#include <linux/types.h>
/**
 * \brief Function to open/allocate any necessary resources for the timer wait
 *        functions below. Always returns ADI_HAL_OK.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 *
 * \retval ADI_HAL_OK Function completed successfully
 */
int32_t linux_TimerOpen(void *devHalCfg);
/**
 * \brief Function to close any necessary resources for the timer wait
 *        functions below. Always returns ADI_HAL_OK.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 *
 * \retval ADI_HAL_OK Function completed successfully
 */
int32_t linux_TimerClose(void *devHalCfg);
/**
 * \brief Function to initialize any necessary resources for the timer wait
 *        functions below. Always returns ADI_HAL_OK.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 *
 * \retval ADI_HAL_OK Function completed successfully
 */
int32_t linux_TimerInit(void *devHalCfg);
/**
 * \brief Provides a blocking delay of the current thread.
 * 	  Always returns ADI_HAL_OK.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 * \param time_us the time to delay in mico seconds
 *
 * \retval ADI_HAL_OK Function completed successfully
 */
int32_t linux_TimerWait_us(void *devHalCfg, uint32_t time_us);
/**
 * \brief Provides a blocking delay of the current thread
 * 	  Always returns ADI_HAL_OK.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 * \param time_ms the Time to delay in milli seconds
 *
 * \retval ADI_HAL_OK Function completed successfully
 */
int32_t linux_TimerWait_ms(void *devHalCfg, uint32_t time_ms);

#endif /*__LINUX_TIMER_H__*/
#endif