/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/

#ifdef __KERNEL__
#include <linux/spi/spi.h>

#include "linux_spi.h"
#include "adi_platform_types.h"

int32_t linux_SpiOpen(void *devHalCfg)
{
    return ADI_HAL_OK;
}

int32_t linux_SpiClose(void *devHalCfg)
{
    return ADI_HAL_OK;
}

int32_t linux_SpiInit(void *devHalCfg)
{
    return ADI_HAL_OK;
}

int32_t linux_SpiWrite(void *devHalCfg, const uint8_t txData[], uint32_t numTxBytes)
{
    static const uint32_t MAX_SIZE = 4096;
    uint32_t toWrite = 0;
    int32_t remaining = numTxBytes;
    adi_hal_Cfg_t *halCfg = devHalCfg;

    if (!halCfg)
        return ADI_HAL_NULL_PTR;

    if (halCfg->spiCfg.spiActionDisable == 0)
    {
        int32_t result = 0;
        do
        {
            toWrite = (remaining > MAX_SIZE) ? MAX_SIZE : remaining;
            result = spi_write(halCfg->spi, &txData[numTxBytes - remaining], toWrite);
            if (result < 0)
                return ADI_HAL_SPI_FAIL;

            remaining -= toWrite;
	} while (remaining > 0);
    }

    return ADI_HAL_OK;
}

int32_t linux_SpiRead(void *devHalCfg, const uint8_t txData[], uint8_t rxData[],
                      uint32_t numTxRxBytes)
{
    static const uint32_t MAX_SIZE = 4096;
    int32_t remaining = numTxRxBytes;
    int32_t result = 0;
    adi_hal_Cfg_t *halCfg = devHalCfg;

    if (!halCfg)
        return ADI_HAL_NULL_PTR;

    if(halCfg->spiCfg.spiActionDisable == 0)
    {
        do
        {
            struct spi_transfer	t = {
                .tx_buf	= &txData[numTxRxBytes - remaining],
                .rx_buf	= &rxData[numTxRxBytes - remaining],
                .len = (remaining > MAX_SIZE) ? MAX_SIZE : remaining,
            };

	    result = spi_sync_transfer(halCfg->spi, &t, 1);
	    if (result < 0)
	        return ADI_HAL_SPI_FAIL;

	    remaining -= t.len;
	} while (remaining > 0);
    }

    return ADI_HAL_OK;
}
#endif
