/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/

#ifdef __KERNEL__
#include <linux/kernel.h>
#include <linux/string.h>

#include "linux_logging.h"
#include "adi_platform_types.h"

int32_t linux_LogFileOpen(void *devHalCfg, const char *filename)
{
    return ADI_HAL_OK;
}

int32_t linux_LogFileFlush(void *devHalCfg)
{
    return ADI_HAL_OK;
}

int32_t linux_LogFileClose(void *devHalCfg)
{
    return ADI_HAL_OK;
}

int32_t linux_LogLevelSet(void *devHalCfg, int32_t logLevel)
{
    adi_hal_Cfg_t *halCfg = devHalCfg;

    if (!halCfg)
        return ADI_HAL_NULL_PTR;

    halCfg->logCfg.logLevel = logLevel & ADI_HAL_LOG_ALL;

    return ADI_HAL_OK;
}

int32_t linux_LogLevelGet(void *devHalCfg, int32_t *logLevel)
{
    adi_hal_Cfg_t *halCfg = devHalCfg;

    if (!halCfg)
        return ADI_HAL_NULL_PTR;

    *logLevel = halCfg->logCfg.logLevel;

    return ADI_HAL_OK;
}

int32_t linux_LogWrite(void *devHalCfg, int32_t logLevel, const char *comment, va_list argp)
{
    int32_t result = 0;
    adi_hal_Cfg_t *halCfg = devHalCfg;
    char logMessage[ADI_HAL_MAX_LOG_LINE] = { 0 };
    const char *logLevelChar = NULL;
    logMessage[0] = 0;

    if (!halCfg)
        return ADI_HAL_NULL_PTR;

    if (halCfg->logCfg.logLevel == ADI_HAL_LOG_NONE)
        /* If logging disabled, exit gracefully */
        return ADI_HAL_OK;
    else if (logLevel > ADI_HAL_LOG_ALL)
        return ADI_HAL_LOGGGING_LEVEL_FAIL;
    else if (!(logLevel & halCfg->logCfg.logLevel))
        /* Nothing to log - exit cleanly */
        return ADI_HAL_OK;

    /* Print Log type */
    if (logLevel == ADI_HAL_LOG_MSG)
        logLevelChar = "MESSAGE:";
    else if (logLevel == ADI_HAL_LOG_WARN)
        logLevelChar = "WARNING:";
    else if (logLevel == ADI_HAL_LOG_ERR)
        logLevelChar = "ERROR:";
    else if (logLevel == ADI_HAL_LOG_API)
        logLevelChar = "API_LOG:";
    else if (logLevel == ADI_HAL_LOG_BF)
        logLevelChar = "BF_LOG:";
    else if (logLevel == ADI_HAL_LOG_HAL)
        logLevelChar = "ADI_HAL_LOG:";
    else if (logLevel == ADI_HAL_LOG_SPI)
        logLevelChar = "SPI_LOG:";
    else if (logLevel == ADI_HAL_LOG_API_PRIV)
        logLevelChar = "API_PRIV_LOG:";
    else
        /* should never happen */
        return ADI_HAL_LOGGGING_LEVEL_FAIL;

    result = snprintf(logMessage, ADI_HAL_MAX_LOG_LINE, "%s", logLevelChar);
    if (result < 0)
        return ADI_HAL_LOGGING_FAIL;

    result = vsnprintf(logMessage + strlen(logMessage), ADI_HAL_MAX_LOG_LINE, comment, argp) ;
    if (result < 0)
        return ADI_HAL_LOGGING_FAIL;

    result = printk("%s\n", logMessage);
    if (result < 0)
        return ADI_HAL_LOGGING_FAIL;

    return ADI_HAL_OK;
}
#endif
