/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/
#ifdef __KERNEL__
#ifndef __LINUX_INIT_H__
#define __LINUX_INIT_H__

#include <linux/types.h>
/**
 * \brief Opens all neccessary files and device drivers for a specific device
 *	  Always returns ADI_HAL_OK.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 *
 * \retval ADI_HAL_OK Function completed successfully, no action required
 */
int32_t linux_HwOpen(void *devHalCfg);
/**
 * \brief Gracefully shuts down the the hardware closing any open resources
 *        such as log files, I2C, SPI, GPIO drivers, timer resources, etc.
 *	  Always returns ADI_HAL_OK.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 *
 * \retval ADI_HAL_OK Function completed successfully, no action required
 */
int32_t linux_HwClose(void *devHalCfg);
/**
 * \brief This function control a BBIC GPIO pin that connects to the reset pin
 *        of each device.
 *
 *  This function is called by each device API giving access to the Reset pin
 *  connected to each device.
 *
 * \param devHalCfg Pointer to device instance specific platform settings
 * \param pinLevel The desired pin logic level 0=low, 1=high to set the GPIO pin to.
 *
 * \retval ADI_HAL_OK Function completed successfully, no action required
 * \retval ADI_HAL_NULL_PTR The function has been called with a null pointer
 */
int32_t linux_HwReset(void *devHalCfg, uint8_t pinLevel);

#endif /*__LINUX_INIT_H__*/
#endif

