/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/

#ifdef __KERNEL__
#include <linux/gpio/consumer.h>

#include "linux_init.h"
#include "adi_platform_types.h"

int32_t linux_HwOpen(void *devHalCfg)
{
    return ADI_HAL_OK;
}

int32_t linux_HwClose(void *devHalCfg)
{
    return ADI_HAL_OK;
}

int32_t linux_HwReset(void *devHalCfg, uint8_t pinLevel)
{
    adi_hal_Cfg_t *halCfg = devHalCfg;

    if (!halCfg)
        return ADI_HAL_NULL_PTR;
    /*
     * The API just passes @pinLevel with the desired level. However,
     * the pin is active low, so the logic must be inverted before calling
     * the gpio API's. Hence if we receive 0 from the API, we want to pass
     * 1 to the GPIO API since we want our pin to be active!
     */
    gpiod_set_value_cansleep(halCfg->reset_gpio, !pinLevel);

    return ADI_HAL_OK;
}

#endif
