/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/
#ifdef __KERNEL__
#ifndef __LINUX_FW_H__
#define __LINUX_FW_H__

#include <linux/types.h>

int32_t linux_ImagePageGet(void *devHalCfg, const char *ImagePath, uint32_t pageIndex,
                           uint32_t pageSize, uint8_t *rdBuff);
int32_t linux_RxGainTableEntryGet(void *devHalCfg, const char *rxGainTablePath, uint16_t lineCount,
                                  uint8_t *gainIndex, uint8_t *rxFeGain, uint8_t *tiaControl,
                                  uint8_t *adcControl, uint8_t *extControl, uint16_t *phaseOffset,
                                  int16_t *digGain);
int32_t linux_TxAttenTableEntryGet(void *devHalCfg, const char *txAttenTablePath,
                                   uint16_t lineCount, uint16_t *attenIndex, uint8_t *txAttenHp,
                                   uint16_t *txAttenMult);
#endif /* __LINUX_FW_H__ */
#endif
