// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       AXI ADRV9001 Driver
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef AXI_ADRV9001_REGS_H
#define AXI_ADRV9001_REGS_H

/* Top level registers */

#define AXI_ADRV9001_VERSION_ADDR 0x0000
#define AXI_ADRV9001_INSTANCE_ID_ADDR 0x0004
#define AXI_ADRV9001_SCRATCH_ADDR 0x0008
#define AXI_ADRV9001_TIMER_ADDR 0x000c
#define AXI_ADRV9001_RESETB_ADDR 0x0020
#define AXI_ADRV9001_MODE_ADDR 0x0024
#define AXI_ADRV9001_GPINT_ADDR 0x0028
#define AXI_ADRV9001_GPINT_MODE_ADDR 0x002c
#define AXI_ADRV9001_GPINT_MODE_HIGH 0x0
#define AXI_ADRV9001_GPINT_MODE_LOW 0x1
#define AXI_ADRV9001_GPINT_MODE_RISING_EDGE 0x2
#define AXI_ADRV9001_GPINT_MODE_FALLING_EDGE 0x2

/* USER GPIO registers */

#define AXI_ADRV9001_USR_GPIO_IN_ADDR 0x0100
#define AXI_ADRV9001_USR_GPIO_OUT_ADDR 0x0104

/* MCS registers */

#define AXI_ADRV9001_MCS_REQUEST_ADDR 0x0200
#define AXI_ADRV9001_MCS_CONTROL_ADDR 0x0204
#define AXI_ADRV9001_MCS_PERIOD_GET(d) ((d >> 0) & 0xff)
#define AXI_ADRV9001_MCS_PERIOD_SET(d) ((d & 0xff) << 0)
#define AXI_ADRV9001_MCS_WIDTH_GET(d) ((d >> 8) & 0x7)
#define AXI_ADRV9001_MCS_WIDTH_SET(d) ((d & 0x7) << 8)
#define AXI_ADRV9001_MCS_NUM_GET(d) ((d >> 12) & 0xf)
#define AXI_ADRV9001_MCS_NUM_SET(d) ((d & 0xf) << 12)
#define AXI_ADRV9001_MCS_EDGE_FALL1_RISE0_GET(d) ((d >> 16) & 0x1)
#define AXI_ADRV9001_MCS_EDGE_FALL1_RISE0_SET(d) ((d & 0x1) << 16)
#define AXI_ADRV9001_MCS_SELECT_ADDR 0x0208
#define AXI_ADRV9001_MCS_SELECT_SW 0x0
#define AXI_ADRV9001_MCS_SELECT_HW 0x1
#define AXI_ADRV9001_MCS_CLK_MON_ADDR 0x0240

/* MMCM registers */

#define AXI_ADRV9001_MMCM_ACCESS_ADDR 0x0300
#define AXI_ADRV9001_MMCM_REQUEST_GET(d) ((d >> 0) & 0x1)
#define AXI_ADRV9001_MMCM_REQUEST_SET(d) ((d & 0x1) << 0)
#define AXI_ADRV9001_MMCM_RD1_WR0_GET(d) ((d >> 1) & 0x1)
#define AXI_ADRV9001_MMCM_RD1_WR0_SET(d) ((d & 0x1) << 1)
#define AXI_ADRV9001_MMCM_ADDR_ADDR 0x0304
#define AXI_ADRV9001_MMCM_WRDATA_ADDR 0x0308
#define AXI_ADRV9001_MMCM_RDDATA_ADDR 0x030c
#define AXI_ADRV9001_MMCM_RESET_ADDR 0x0310
#define AXI_ADRV9001_MMCM_STATUS_ADDR 0x0314
#define AXI_ADRV9001_MMCM_BUSY_GET(d) ((d >> 0) & 0x1)
#define AXI_ADRV9001_MMCM_LOCKED_GET(d) ((d >> 1) & 0x1)
#define AXI_ADRV9001_MMCM_REF_CLK_MON_ADDR 0x0340
#define AXI_ADRV9001_MMCM_POWER_ID 0x28
#define AXI_ADRV9001_MMCM_REF_DIV_ID 0x16
#define AXI_ADRV9001_MMCM_VCO_DIV_ID 0x14
#define AXI_ADRV9001_MMCM_OUT_DIV_ID 0x08
#define AXI_ADRV9001_MMCM_LOCK_ID 0x18
#define AXI_ADRV9001_MMCM_FILTER_ID 0x4e

/* External trigger registers */

#define AXI_ADRV9001_TRIG_EXT_CTL_ADDR 0x0400
#define AXI_ADRV9001_TRIG_EXT_CTL_DISABLE 0x0
#define AXI_ADRV9001_TRIG_EXT_CTL_ENABLE 0x1

/* GPIO offsets */

#define AXI_ADRV9001_GPIO_DATA_IN_OFFSET 0x00
#define AXI_ADRV9001_GPIO_DATA_OUT_OFFSET 0x04
#define AXI_ADRV9001_GPIO_DATA_OUT_ENABLE_OFFSET 0x08
#define AXI_ADRV9001_GPIO_DATA_OUT_MODE_OFFSET 0x0c
#define AXI_ADRV9001_GPIO_DATA_OUT_SEL_OFFSET 0x10
#define AXI_ADRV9001_GPIO_DATA_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_DATA_SET(d, n) ((d & 0x1) << n)

/* GPIO (DGPIO) registers */

#define AXI_ADRV9001_GPIO_TIMER_ADDR 0x1000
#define AXI_ADRV9001_GPIO_PIO_DATA_ADDR 0x1100
#define AXI_ADRV9001_GPIO_PIO_DATA_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_ADDR 0x1104
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_ENB_ADDR 0x1108
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_ENB_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_ENB_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_DISABLE 0x0
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_ENABLE 0x1
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_MODE_ADDR 0x110c
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_MODE_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_MODE_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_MODE_SW 0x0
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_MODE_HW 0x1
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_SEL_ADDR 0x1110
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_TX0_ENB 0x0
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_RX0_ENB 0x1
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_ORX0_ENB 0x2
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_AUX0_ENB 0x3
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_TX1_ENB 0x4
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_RX1_ENB 0x5
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_ORX1_ENB 0x6
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_AUX1_ENB 0x7
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_CTL0_ENB 0x8
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_CTL1_ENB 0x9
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_CTL2_ENB 0xa
#define AXI_ADRV9001_GPIO_PIO_DATA_OUT_TDD_CTL3_ENB 0xb

/* GPIO (RX SSI) registers */

#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_ADDR 0x1200
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ADDR 0x1204
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ENB_ADDR 0x1208
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ENB_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_RX0_PIO_DATA_OUT_ENB_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_ADDR 0x1300
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ADDR 0x1304
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ENB_ADDR 0x1308
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ENB_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_RX1_PIO_DATA_OUT_ENB_SET(d, n) ((d & 0x1) << n)

/* GPIO (TX SSI) registers */

#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_ADDR 0x1400
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ADDR 0x1404
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ENB_ADDR 0x1408
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ENB_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_TX0_PIO_DATA_OUT_ENB_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_ADDR 0x1500
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ADDR 0x1504
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_SET(d, n) ((d & 0x1) << n)
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ENB_ADDR 0x1508
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ENB_GET(d, n) ((d >> n) & 0x1)
#define AXI_ADRV9001_GPIO_TX1_PIO_DATA_OUT_ENB_SET(d, n) ((d & 0x1) << n)

/* GPIO trigger, gain index, and clock monitor registers */

#define AXI_ADRV9001_GPIO_PIO_ID 0x1
#define AXI_ADRV9001_GPIO_RX0_PIO_ID 0x4
#define AXI_ADRV9001_GPIO_RX1_PIO_ID 0x5
#define AXI_ADRV9001_GPIO_TX0_PIO_ID 0x6
#define AXI_ADRV9001_GPIO_TX1_PIO_ID 0x7
#define AXI_ADRV9001_GPIO_TRIG_SRC_GROUP_ADDR 0x1600
#define AXI_ADRV9001_GPIO_TRIG_SRC_PIN_ADDR 0x1604
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_GROUP_ADDR 0x1700
#define AXI_ADRV9001_GPIO_GAININDEX_SRC_PIN_ADDR 0x1704
#define AXI_ADRV9001_GPIO_CLK_MON_ADDR 0x1800

/* SSI mode selects */

#define CMOS_1L_PS_02X1 0x00
#define CMOS_1L_PS_02X2 0x01
#define CMOS_1L_PS_02X4 0x02
#define CMOS_1L_PS_02X8 0x03
#define CMOS_1L_PS_08X1 0x04
#define CMOS_1L_PS_08X2 0x05
#define CMOS_1L_PS_08X4 0x06
#define CMOS_1L_PS_08X8 0x07
#define CMOS_1L_PS_16X1 0x08
#define CMOS_1L_PS_16X2 0x09
#define CMOS_1L_PS_16X4 0x0a
#define CMOS_1L_PS_16X8 0x0b
#define CMOS_1L_PS_32X1 0x0c
#define CMOS_1L_PS_32X2 0x0d
#define CMOS_1L_PS_32X4 0x0e
#define CMOS_1L_PS_32X8 0x0f
#define CMOS_1L_LS_32X1 0x10
#define CMOS_1L_LS_32X2 0x11
#define CMOS_1L_LS_32X4 0x12
#define CMOS_1L_LS_32X8 0x13
#define CMOS_1L_PS_64X1 0x14
#define CMOS_1L_PS_64X2 0x15
#define CMOS_1L_PS_64X4 0x16
#define CMOS_1L_PS_64X8 0x17
#define CMOS_1L_LS_64X1 0x18
#define CMOS_1L_LS_64X2 0x19
#define CMOS_1L_LS_64X4 0x1a
#define CMOS_1L_LS_64X8 0x1b
#define CMOS_4L_PS_32X1 0x1c
#define CMOS_4L_PS_64X1 0x1d
#define LVDS_1L_PS_24X1 0x1e
#define LVDS_1L_LS_24X1 0x1f
#define LVDS_1L_PS_32X1 0x20
#define LVDS_1L_LS_32X1 0x21
#define LVDS_1L_PS_64X1 0x22
#define LVDS_1L_LS_64X1 0x23
#define LVDS_2L_PS_24X1 0x24
#define LVDS_2L_PS_32X1 0x25
#define LVDS_2L_PS_64X1 0x26
#define SSI_MODE_UNDEFINED 0x27

/* SSI mode registers */

#define AXI_ADRV9001_SSI_CMOS_LVDS_ID_ADDR 0x0
#define AXI_ADRV9001_SSI_CMOS 0x434d4f53
#define AXI_ADRV9001_SSI_LVDS 0x4c564453
#define AXI_ADRV9001_SSI_GPIO 0x4750494f
#define AXI_ADRV9001_SSI_CONTROL_ADDR 0x4
#define AXI_ADRV9001_SSI_CLK_RATE_GET(d) ((d >> 0) & 0x3)
#define AXI_ADRV9001_SSI_CLK_RATE_SET(d) ((d & 0x3) << 0)
#define AXI_ADRV9001_SSI_CLK_RATE_X1 0x0
#define AXI_ADRV9001_SSI_CLK_RATE_X2 0x1
#define AXI_ADRV9001_SSI_CLK_RATE_X4 0x2
#define AXI_ADRV9001_SSI_CLK_RATE_X8 0x3
#define AXI_ADRV9001_SSI_NUM_OF_BITS_GET(d) ((d >> 4) & 0x7)
#define AXI_ADRV9001_SSI_NUM_OF_BITS_SET(d) ((d & 0x7) << 4)
#define AXI_ADRV9001_SSI_NUM_OF_BITS_02 0x0
#define AXI_ADRV9001_SSI_NUM_OF_BITS_08 0x1
#define AXI_ADRV9001_SSI_NUM_OF_BITS_16 0x2
#define AXI_ADRV9001_SSI_NUM_OF_BITS_24 0x3
#define AXI_ADRV9001_SSI_NUM_OF_BITS_32 0x4
#define AXI_ADRV9001_SSI_NUM_OF_BITS_64 0x5
#define AXI_ADRV9001_SSI_LSTRB1_PSTRB0_GET(d) ((d >> 8) & 0x1)
#define AXI_ADRV9001_SSI_LSTRB1_PSTRB0_SET(d) ((d & 0x1) << 8)
#define AXI_ADRV9001_SSI_MLANE1_SLANE0_GET(d) ((d >> 9) & 0x1)
#define AXI_ADRV9001_SSI_MLANE1_SLANE0_SET(d) ((d & 0x1) << 9)
#define AXI_ADRV9001_SSI_SDR1_DDR0_GET(d) ((d >> 10) & 0x1)
#define AXI_ADRV9001_SSI_SDR1_DDR0_SET(d) ((d & 0x1) << 10)
#define AXI_ADRV9001_SSI_LSB1_MSB0_GET(d) ((d >> 11) & 0x1)
#define AXI_ADRV9001_SSI_LSB1_MSB0_SET(d) ((d & 0x1) << 11)
#define AXI_ADRV9001_SSI_Q1_I0_GET(d) ((d >> 12) & 0x1)
#define AXI_ADRV9001_SSI_Q1_I0_SET(d) ((d & 0x1) << 12)
#define AXI_ADRV9001_SSI_FALL1_RISE0_GET(d) ((d >> 13) & 0x1)
#define AXI_ADRV9001_SSI_FALL1_RISE0_SET(d) ((d & 0x1) << 13)
#define AXI_ADRV9001_SSI_CMOS1_LVDS0_GET(d) ((d >> 14) & 0x1)
#define AXI_ADRV9001_SSI_IO_CONTROL_ADDR 0x8
#define AXI_ADRV9001_SSI_BUF_ENABLE_GET(d) ((d >> 0) & 0x1)
#define AXI_ADRV9001_SSI_BUF_ENABLE_SET(d) ((d & 0x1) << 0)
#define AXI_ADRV9001_SSI_CLK_SEL_GET(d) ((d >> 1) & 0x1)
#define AXI_ADRV9001_SSI_CLK_SEL_SET(d) ((d & 0x1) << 1)
#define AXI_ADRV9001_SSI_CLK_MSB_GET(d) ((d >> 2) & 0x1)
#define AXI_ADRV9001_SSI_CLK_MSB_SET(d) ((d & 0x1) << 2)
#define AXI_ADRV9001_SSI_INIT_ADDR 0xc

/* SSI data registers */

#define AXI_ADRV9001_SSI_RX_ORX_DEC_CONTROL_ADDR 0x10
#define AXI_ADRV9001_SSI_RX_DEC_RATIO_GET(d) ((d >> 0) & 0xf)
#define AXI_ADRV9001_SSI_RX_DEC_RATIO_SET(d) ((d & 0xf) << 0)
#define AXI_ADRV9001_SSI_ORX_DEC_RATIO_GET(d) ((d >> 4) & 0xf)
#define AXI_ADRV9001_SSI_ORX_DEC_RATIO_SET(d) ((d & 0xf) << 4)
#define AXI_ADRV9001_SSI_DATA_SEL_ADDR 0x20
#define AXI_ADRV9001_SSI_DATA_SEL_DMA 0x0
#define AXI_ADRV9001_SSI_DATA_SEL_RX2TX_LB 0x1
#define AXI_ADRV9001_SSI_DATA_SEL_ZERO 0x2
#define AXI_ADRV9001_SSI_DATA_SEL_PATTERN 0x3
#define AXI_ADRV9001_SSI_DATA_SEL_NIBBLE_RAMP 0x4
#define AXI_ADRV9001_SSI_DATA_SEL_RAMP 0x5
#define AXI_ADRV9001_SSI_DATA_SEL_PRBS15 0x6
#define AXI_ADRV9001_SSI_DATA_SEL_PRBS7 0x7
#define AXI_ADRV9001_SSI_DATA_SEL_FS_X8 0x8
#define AXI_ADRV9001_SSI_DATA_PAT_ADDR 0x30
#define AXI_ADRV9001_SSI_DATA_PAT1_ADDR 0x34
#define AXI_ADRV9001_SSI_DATA_RECV_ADDR 0x40
#define AXI_ADRV9001_SSI_DATA_RECV1_ADDR 0x44

/* SSI status registers */

#define AXI_ADRV9001_SSI_STATUS_ADDR 0x60
#define AXI_ADRV9001_SSI_FRM_OOS_GET(d) ((d >> 0) & 0x1)
#define AXI_ADRV9001_SSI_FRM_OOS_CLEAR(d) ((d & 0x1) << 0)
#define AXI_ADRV9001_SSI_FRM_ERR_GET(d) ((d >> 1) & 0x1)
#define AXI_ADRV9001_SSI_FRM_ERR_CLEAR(d) ((d & 0x1) << 1)
#define AXI_ADRV9001_SSI_MON_OOS_GET(d) ((d >> 2) & 0x1)
#define AXI_ADRV9001_SSI_MON_OOS_CLEAR(d) ((d & 0x1) << 2)
#define AXI_ADRV9001_SSI_MON_ERR_GET(d) ((d >> 3) & 0x1)
#define AXI_ADRV9001_SSI_MON_ERR_CLEAR(d) ((d & 0x1) << 3)
#define AXI_ADRV9001_SSI_OVF_ERR_GET(d) ((d >> 8) & 0x1)
#define AXI_ADRV9001_SSI_OVF_ERR_CLEAR(d) ((d & 0x1) << 8)
#define AXI_ADRV9001_SSI_UNF_ERR_GET(d) ((d >> 9) & 0x1)
#define AXI_ADRV9001_SSI_UNF_ERR_CLEAR(d) ((d & 0x1) << 9)

/* SSI delay registers */

#define AXI_ADRV9001_SSI_DELAY_LOCKED_ADDR 0x70
#define AXI_ADRV9001_SSI_DELAY_CONTROL_ADDR 0x80
#define AXI_ADRV9001_SSI_IN_DELAY_CONTROL_ADDR 0xa0
#define AXI_ADRV9001_SSI_DELAY_GET(d) ((d >> 8) & 0x1f)

/* SSI timer and clock monitor registers */

#define AXI_ADRV9001_SSI_TIMER_ADDR 0x100
#define AXI_ADRV9001_SSI_CLK_MON_ADDR 0x104
#define AXI_ADRV9001_SSI_RESET_ADDR 0x200
#define AXI_ADRV9001_SSI_RX0_ID 0x4000
#define AXI_ADRV9001_SSI_RX1_ID 0x5000
#define AXI_ADRV9001_SSI_TX0_ID 0x6000
#define AXI_ADRV9001_SSI_TX1_ID 0x7000

/* TDD registers */

#define AXI_ADRV9001_TDD_FRAME_PERIOD_ADDR 0x8000
#define AXI_ADRV9001_TDD_NUM_OF_FRAMES_ADDR 0x8004
#define AXI_ADRV9001_TDD_FRAME_SWITCH_PERIOD_ADDR 0x8008
#define AXI_ADRV9001_TDD_FRAME_SWITCH_NUMBER_ADDR 0x800c
#define AXI_ADRV9001_TDD_TRIGGER_MODE_ADDR 0x8010
#define AXI_ADRV9001_TDD_TRIGGER_MODE_GET(n, d) ((d >> (n * 4)) & 0x3)
#define AXI_ADRV9001_TDD_TRIGGER_MODE_SET(n, d) ((d & 0x3) << (n * 4))
#define AXI_ADRV9001_TDD_TRIGGER_DISABLED 0x0
#define AXI_ADRV9001_TDD_TRIGGER_RISING_EDGE 0x1
#define AXI_ADRV9001_TDD_TRIGGER_FALLING_EDGE 0x2
#define AXI_ADRV9001_TDD_SEQUENCE_CONTROL_ADDR 0x8020
#define AXI_ADRV9001_TDD_START_GET(d) ((d >> 0) & 0x1)
#define AXI_ADRV9001_TDD_START_SET(d) ((d & 0x1) << 0)
#define AXI_ADRV9001_TDD_STOP_GET(d) ((d >> 1) & 0x1)
#define AXI_ADRV9001_TDD_STOP_SET(d) ((d & 0x1) << 1)
#define AXI_ADRV9001_TDD_SEQUENCE_REPEAT_GET(d) ((d >> 2) & 0x1)
#define AXI_ADRV9001_TDD_SEQUENCE_REPEAT_SET(d) ((d & 0x1) << 2)
#define AXI_ADRV9001_TDD_FRAME_SWITCH_ENABLE_GET(d) ((d >> 3) & 0x1)
#define AXI_ADRV9001_TDD_FRAME_SWITCH_ENABLE_SET(d) ((d & 0x1) << 3)
#define AXI_ADRV9001_TDD_SWRESET_ADDR 0x8024
#define AXI_ADRV9001_TDD_TIMER_ADDR 0x8028
#define AXI_ADRV9001_TDD_CLK_MON_ADDR 0x8030

/* TDD enable registers */

#define AXI_ADRV9001_TDD_PRIMARY_ASSERT_ADDR 0x00
#define AXI_ADRV9001_TDD_PRIMARY_DEASSERT_ADDR 0x04
#define AXI_ADRV9001_TDD_SECONDARY_ASSERT_ADDR 0x08
#define AXI_ADRV9001_TDD_SECONDARY_DEASSERT_ADDR 0x0c
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_ASSERT_ADDR 0x10
#define AXI_ADRV9001_TDD_PRIMARY_FRAME_DEASSERT_ADDR 0x14
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_ASSERT_ADDR 0x18
#define AXI_ADRV9001_TDD_SECONDARY_FRAME_DEASSERT_ADDR 0x1c
#define AXI_ADRV9001_TDD_MODE_ADDR 0x20
#define AXI_ADRV9001_TDD_ENABLE_AUTO 0x2
#define AXI_ADRV9001_TDD_ENABLE_HIGH 0x1
#define AXI_ADRV9001_TDD_ENABLE_LOW 0x0
#define AXI_ADRV9001_TDD_SYNC_ADDR 0x24
#define AXI_ADRV9001_TDD_CLK_RATIO_ADDR 0x30

/* TDD selects */

#define AXI_ADRV9001_TDD_RX0_DEVICE_ID 0x8100
#define AXI_ADRV9001_TDD_TX0_DEVICE_ID 0x8200
#define AXI_ADRV9001_TDD_RX1_DEVICE_ID 0x8300
#define AXI_ADRV9001_TDD_TX1_DEVICE_ID 0x8400
#define AXI_ADRV9001_TDD_ORX0_DEVICE_ID 0x8500
#define AXI_ADRV9001_TDD_ORX1_DEVICE_ID 0x8600
#define AXI_ADRV9001_TDD_AUX0_DEVICE_ID 0x8700
#define AXI_ADRV9001_TDD_AUX1_DEVICE_ID 0x8800
#define AXI_ADRV9001_TDD_CTL0_DEVICE_ID 0x8900
#define AXI_ADRV9001_TDD_CTL1_DEVICE_ID 0x8a00
#define AXI_ADRV9001_TDD_CTL2_DEVICE_ID 0x8b00
#define AXI_ADRV9001_TDD_CTL3_DEVICE_ID 0x8c00
#define AXI_ADRV9001_TDD_TRIG1_DEVICE_ID 0x8d00
#define AXI_ADRV9001_TDD_TRIG2_DEVICE_ID 0x8e00
#define AXI_ADRV9001_TDD_RX0_DMA_ID 0x9100
#define AXI_ADRV9001_TDD_TX0_DMA_ID 0x9200
#define AXI_ADRV9001_TDD_RX1_DMA_ID 0x9300
#define AXI_ADRV9001_TDD_TX1_DMA_ID 0x9400
#define AXI_ADRV9001_TDD_ORX0_DMA_ID 0x9500
#define AXI_ADRV9001_TDD_ORX1_DMA_ID 0x9600

#endif

// **********************************************************************************
// **********************************************************************************
