/**
 * \file
 * \brief Contains ADRV9001 API macro definitions and global structure declarations for adi_adrv9001_user.c
 *
 * ADRV9001 API Version: $ADI_ADRV9001_API_VERSION$
 */

 /**
 * Copyright 2015 - 2018 Analog Devices Inc.
 * Released under the ADRV9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_ADRV9001_USER_H_
#define _ADI_ADRV9001_USER_H_

#include "adi_adrv9001_types.h"

/*
*****************************************
* Interface Macros
******************************************
*/

#ifndef ADI_ADRV9001_LOGGING
#define ADI_ADRV9001_LOGGING     ADI_COMMON_LOG_MSG | \
                                 ADI_COMMON_LOG_WARN | \
                                 ADI_COMMON_LOG_ERR | \
                                 ADI_COMMON_LOG_API /*LogLevel Set to API, Messages, Warnings, Error*/
#endif /* !ADI_ADRV9001_LOGGING */

#define ADI_ADRV9001_RESET_ON_ERR  1                 /*API Reset on Severe Errors*/

#define ADI_ADRV9001_NUMBER_SPI_RETRY   2
#define ADI_ADRV9001_ARM_MEM_AUTO_INCR 1
#define ADI_ADRV9001_ARM_MEM_CACHE_ENABLE 1
#define ADI_ADRV9001_PRE_MCS_BROADCAST_DISABLE 1    /* Set to 0 for SPI Write only (Broadcasting) */

#define ADI_ADRV9001_FRONT_END_GPIO_DOWNLOAD 0      /* Set this to '1' to download front end GPIO */
#define	ADI_ADRV9001_SLEWRATE_CONFIG    1           /* Set this to '1' to enable slew rate configuration */
#define ADI_ADRV9001_SW_TEST 0
#define ADI_ADRV9001_PROFILE_CHECKSUM_ENABLE 0

#define ADRV9001_BITFIELD_LOG 0
#define ADRV9001_BITFIELD_HAL_LOG 0
#define ADI_ADRV9001_HAL_LOG 0

#define ADI_ADRV9001_TX_ATTEN_TABLE_CACHE_MAX   256  /*Cache value: up to 1024, multiple of 4 */

#define ADI_ADRV9001_MEM_DUMP_CHUNK_SIZE 256         /*Cache value: up to 1024, multiple of 4 */

#define ADI_ADRV9001_STREAM_BINARY_IMAGE_LOAD_CHUNK_SIZE_BYTES (1024) /*Please ensure that the Stream bin size is perfectly divisible by the chunk size*/

#define ADI_ADRV9001_ARM_BINARY_IMAGE_LOAD_CHUNK_SIZE_BYTES (1024) /*Please ensure that the ARM bin size is perfectly divisible by the chunk size*/

/* Theses values can be modified by the end user to adjust how active the SPI reads are
 * to help prevent over using the SPI resource */
#define ADI_ADRV9001_VERIFY_ARM_CHKSUM_TIMEOUT_US  200000
#define ADI_ADRV9001_VERIFY_ARM_CHKSUM_INTERVAL_US   5000
#define ADI_ADRV9001_CLKPLL_CPCAL_TIMEOUT_US      1000000
#define ADI_ADRV9001_CLKPLL_CPCAL_INTERVAL_US        1000
#define ADI_ADRV9001_CLKPLL_LOCK_TIMEOUT_US       1000000
#define ADI_ADRV9001_CLKPLL_LOCK_INTERVAL_US         1000
#define ADI_ADRV9001_CLKPLL_POWERUP_US             200000
#define ADI_ADRV9001_CLKPLL_LOCK_US                100000
#define ADI_ADRV9001_SETARMGPIO_TIMEOUT_US        1000000
#define ADI_ADRV9001_SETARMGPIO_INTERVAL_US          1000
#define ADI_ADRV9001_GETARMGPIO_TIMEOUT_US        1000000
#define ADI_ADRV9001_GETARMGPIO_INTERVAL_US          1000
#define ADI_ADRV9001_SETTXTOORXMAP_TIMEOUT_US     1000000
#define ADI_ADRV9001_SETTXTOORXMAP_INTERVAL_US       1000
#define ADI_ADRV9001_GETTXTOORXMAP_TIMEOUT_US     1000000
#define ADI_ADRV9001_GETTXTOORXMAP_INTERVAL_US       1000
#define ADI_ADRV9001_GETTEMPERATURE_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETTEMPERATURE_INTERVAL_US      1000
#define ADI_ADRV9001_SETCARRIER_FREQUENCY_TIMEOUT_US    1000000
#define ADI_ADRV9001_SETCARRIER_FREQUENCY_INTERVAL_US      1000
#define ADI_ADRV9001_GETCARRIER_FREQUENCY_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETCARRIER_FREQUENCY_INTERVAL_US      1000       
#define ADI_ADRV9001_SETLOOPFILTER_TIMEOUT_US     1000000
#define ADI_ADRV9001_SETLOOPFILTER_INTERVAL_US       1000
#define ADI_ADRV9001_GETLOOPFILTER_TIMEOUT_US     1000000
#define ADI_ADRV9001_GETLOOPFILTER_INTERVAL_US       1000
#define ADI_ADRV9001_SETEXTDPDCAPTURETRIG_TIMEOUT_US 1000000
#define ADI_ADRV9001_SETEXTDPDCAPTURETRIG_INTERVAL_US 1000
#define ADI_ADRV9001_SETEXTDPDCAPTUREDONE_INTERVAL_US 1000
#define ADI_ADRV9001_SETEXTDPDCAPTUREDONE_TIMEOUT_US  1000000
#define ADI_ADRV9001_GETEXTDPDCAPTUREDONE_INTERVAL_US 1000
#define ADI_ADRV9001_GETEXTDPDCAPTUREDONE_TIMEOUT_US  1000000
#define ADI_ADRV9001_SETEXTDPDENABLE_INTERVAL_US      1000
#define ADI_ADRV9001_SETEXTDPDENABLE_TIMEOUT_US       1000000
#define ADI_ADRV9001_SETEXTDMODELSELECT_INTERVAL_US   1000
#define ADI_ADRV9001_SETEXTDMODELSELECT_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETEXTDMODELSELECT_INTERVAL_US   1000
#define ADI_ADRV9001_GETEXTDMODELSELECT_TIMEOUT_US    1000000
#define ADI_ADRV9001_SENDARMCMD_TIMEOUT_US        2000000
#define ADI_ADRV9001_SENDARMCMD_INTERVAL_US          1000
#define ADI_ADRV9001_SENDARMCMD_TIMEOUT_US        2000000
#define ADI_ADRV9001_READARMCFG_TIMEOUT_US        1000000
#define ADI_ADRV9001_READARMCFG_INTERVAL_US          1000
#define ADI_ADRV9001_WRITEARMCFG_TIMEOUT_US       1000000
#define ADI_ADRV9001_WRITEARMCFG_INTERVAL_US         1000
#define ADI_ADRV9001_GETARMBOOTUP_TIMEOUT_US      5000000
#define ADI_ADRV9001_GETARMBOOTUP_INTERVAL_US      100000
#define ADI_ADRV9001_SETARMBOOTUPMCS_TIMEOUT_US   1000000
#define ADI_ADRV9001_SETARMBOOTUPMCS_INTERVAL_US     1000
#define ADI_ADRV9001_WRITEARMEXCEPTION_TIMEOUT_US 5000000
#define ADI_ADRV9001_WRITEARMEXCEPTION_INTERVAL_US   1000      
#define ADI_ADRV9001_SETARMPROFILE_TIMEOUT_US     1000000
#define ADI_ADRV9001_SETARMPROFILE_INTERVAL_US       1000        
#define ADI_ADRV9001_SETARMSYSTEM_TIMEOUT_US     10000000
#define ADI_ADRV9001_SETARMSYSTEM_INTERVAL_US        1000
#define ADI_ADRV9001_SETARMCLOCK_TIMEOUT_US       1000000
#define ADI_ADRV9001_SETARMCLOCK_INTERVAL_US         1000
#define ADI_ADRV9001_SETARMGPIO_TIMEOUT_US        1000000
#define ADI_ADRV9001_SETARMGPIO_INTERVAL_US          1000        
#define ADI_ADRV9001_GETARMGPIO_TIMEOUT_US        1000000
#define ADI_ADRV9001_GETARMGPIO_INTERVAL_US          1000
#define ADI_ADRV9001_RX_INTERFACE_CONTROL_TIMEOUT_US  1000000
#define ADI_ADRV9001_RX_INTERFACE_CONTROL_INTERVAL_US    1000
#define ADI_ADRV9001_SETBBDCREJECTION_ENABLE_TIMEOUT_US    1000000
#define ADI_ADRV9001_SETBBDCREJECTION_ENABLE_INTERVAL_US      1000
#define ADI_ADRV9001_SETDYNAMICPROFILE_TIMEOUT_US   10000
#define ADI_ADRV9001_SETDYNAMICPROFILE_INTERVAL_US    100
#define ADI_ADRV9001_SETFH_TIMEOUT_US              100000
#define ADI_ADRV9001_SETFH_INTERVAL_US               1000

#define ADI_ADRV9001_INITCALSWAIT_INTERVAL_US        1000
#define ADI_ADRV9001_INITCALSABORT_TIMEOUT_US     1000000
#define ADI_ADRV9001_INITCALSABORT_INTERVAL_US       1000
#define ADI_ADRV9001_INITCALSTATUSGET_TIMEOUT_US  1000000
#define ADI_ADRV9001_INITCALSTATUSGET_INTERVAL_US    1000
#define ADI_ADRV9001_ENTRACKINGCALS_TIMEOUT_US    1000000
#define ADI_ADRV9001_ENTRACKINGCALS_INTERVAL_US      1000

#define ADI_ADRV9001_SETSRLCONFIG_TIMEOUT_US      1000000
#define ADI_ADRV9001_SETSRLCONFIG_INTERVAL_US        1000
#define ADI_ADRV9001_GETSRLCONFIG_TIMEOUT_US      1000000
#define ADI_ADRV9001_GETSRLCONFIG_INTERVAL_US        1000


#define ADI_ADRV9001_GETTXLOLSTATUS_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETTXLOLSTATUS_INTERVAL_US      1000
#define ADI_ADRV9001_GETTXQECSTATUS_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETTXQECSTATUS_INTERVAL_US      1000
#define ADI_ADRV9001_GETRXQECSTATUS_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETRXQECSTATUS_INTERVAL_US      1000
#define ADI_ADRV9001_GETORXQECSTATUS_TIMEOUT_US   1000000
#define ADI_ADRV9001_GETORXQECSTATUS_INTERVAL_US     1000
#define ADI_ADRV9001_GETTXVSWRSTATUS_TIMEOUT_US   1000000
#define ADI_ADRV9001_GETTXVSWRSTATUS_INTERVAL_US     1000
#define ADI_ADRV9001_GETTXCLGCSTATUS_TIMEOUT_US   1000000
#define ADI_ADRV9001_GETTXCLGCSTATUS_INTERVAL_US     1000
#define ADI_ADRV9001_GETTXDPDSTATUS_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETTXDPDSTATUS_INTERVAL_US      1000
#define ADI_ADRV9001_GETRXHD2STATUS_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETRXHD2STATUS_INTERVAL_US      1000
#define ADI_ADRV9001_GETTCALS_STATE_TIMEOUT_US    1000000
#define ADI_ADRV9001_GETTCALS_STATE_INTERVAL_US      1000

#define ADI_ADRV9001_READ_TEMP_SENSOR_TIMEOUT_US  1000000
#define ADI_ADRV9001_READ_TEMP_SENSOR_INTERVAL_US    1000
#define ADI_ADRV9001_READ_RSSI_TIMEOUT_US         1000000
#define ADI_ADRV9001_READ_RSSI_INTERVAL_US           1000

#define ADI_ADRV9001_RADIOONOFF_TIMEOUT_US        1000000
#define ADI_ADRV9001_RADIOONOFF_INTERVAL_US        100000
#define ADI_ADRV9001_STANDBY_TIMEOUT_US           1000000
#define ADI_ADRV9001_STANDBY_INTERVAL_US           100000
#define ADI_ADRV9001_DEFAULT_TIMEOUT_US           1000000
#define ADI_ADRV9001_DEFAULT_INTERVAL_US           100000

#define ADI_ADRV9001_TEMPERATURE_WAIT_US          (20000U)     
#define ADI_ADRV9001_SYNTH_CAL_WAIT_US            (100000U)    
#define ADI_ADRV9001_SYNTH_LOCK_WAIT_US           (10000U)     

/*
 *****************************************
 * Rx and ObsRx gain tables
 ******************************************
 */
#define ADI_ADRV9001_MAX_GAIN_TABLE_INDEX            255
#define ADI_ADRV9001_MIN_GAIN_TABLE_INDEX            0
#define ADI_ADRV9001_GAIN_TABLE_ARRAY_SIZE           ((ADI_ADRV9001_MAX_GAIN_TABLE_INDEX - ADI_ADRV9001_MIN_GAIN_TABLE_INDEX) + 1) * 8

#define ADI_ADRV9001_START_RX_GAIN_INDEX             255
#define ADI_ADRV9001_MIN_RX_GAIN_TABLE_INDEX         0

#define ADI_ADRV9001_START_ORX_GAIN_INDEX            255
#define ADI_ADRV9001_MIN_ORX_GAIN_TABLE_INDEX        0

#endif
