/**
 * \file
 * \brief BitField accessors for vco_adc_mem_map
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_VCO_ADC_MEM_MAP_H__
 #define __ADRV9001_BF_VCO_ADC_MEM_MAP_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfVcoAdcMemMap_e
{
    ADRV9001_BF_RX1_ADC_LP    =   0x3c00,
    ADRV9001_BF_RX2_ADC_LP    =   0x3e00
} adrv9001_BfVcoAdcMemMap_e;

static const adrv9001_BfVcoAdcMemMap_e vcoAdcMemMapInstances[] = {
    ADRV9001_BF_RX1_ADC_LP,
    ADRV9001_BF_RX2_ADC_LP
};


/**
 * acc0 data from the analog. changes every clock cycle.
 */
static inline int32_t adrv9001_VcoAdcMemMap_Acc0Data_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * acc1 data from analog. changes every clock cycle.
 */
static inline int32_t adrv9001_VcoAdcMemMap_Acc1Data_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x130), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * cal center
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bcalcenter_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13), (value >> 0));

    return status;
}

/**
 * cal center
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bcalcenter_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * bcap adjustment
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bcap_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * bcap adjustment
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bcap_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * samples to accumulate for bcenter cal --0x0 corresponds to 16*8 samples, 0x1 is 64*8, 0x2 is 128*8, 0x3 is 256*8, 0x4 is 512*8
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAccCntVal_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x122), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * samples to accumulate for bcenter cal --0x0 corresponds to 16*8 samples, 0x1 is 64*8, 0x2 is 128*8, 0x3 is 256*8, 0x4 is 512*8
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAccCntVal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x122), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * setting this to 1 decreases the mu for bcenter adaptation. this should never need to be used. if used, value of 1 corresponds to 2^-13
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAdaptDecrease_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x122), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * setting this to 1 decreases the mu for bcenter adaptation. this should never need to be used. if used, value of 1 corresponds to 2^-13
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAdaptDecrease_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x122), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * setting this to 1 increases mu by a factor of 8. we should never need to use this.
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAdaptIncrease_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x122), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * setting this to 1 increases mu by a factor of 8. we should never need to use this.
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAdaptIncrease_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x122), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * setting this to 1 changes number of bcenter steps from 32 to 16
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAdaptSteps_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x122), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * setting this to 1 changes number of bcenter steps from 32 to 16
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterAdaptSteps_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x122), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable bcenter cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterCalEn_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x123), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * enable bcenter cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterCalEn_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x123), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * initial value for bcenter (out of reset initial bcenter value is 10'h0 -- this control allows us to load in different bcenter initial value once we are out of reset)
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterInitVal_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x121), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x120), (value >> 0));

    return status;
}

/**
 * initial value for bcenter (out of reset initial bcenter value is 10'h0 -- this control allows us to load in different bcenter initial value once we are out of reset)
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterInitVal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x121), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x120), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * setting this to anything other than 0 scales adaptation coefficient. This only takes effect when bcenter_adapt_decrease is set to 1.
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterScaleShift_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x121), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * setting this to anything other than 0 scales adaptation coefficient. This only takes effect when bcenter_adapt_decrease is set to 1.
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterScaleShift_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x121), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * setting this to "1" loads bcenter_start_init_val as initial bcenter value prior to bcenter cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterStartInitVal_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x122), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * setting this to "1" loads bcenter_start_init_val as initial bcenter value prior to bcenter cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterStartInitVal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x122), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * bcenter value
 */
static inline int32_t adrv9001_VcoAdcMemMap_BcenterValue_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x133), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x132), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * bdither DAC1
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bdithdac1_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8), (value >> 0));

    return status;
}

/**
 * bdither DAC1
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bdithdac1_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * bdither DAC2
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bdithdac2_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9), (value >> 0));

    return status;
}

/**
 * bdither DAC2
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bdithdac2_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * bgain adjustment
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bgain_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * bgain adjustment
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bgain_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * disable vcoadc bias low-pass filter.  Used for faster startup from power down.
 */
static inline int32_t adrv9001_VcoAdcMemMap_BiasDisLpf_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * disable vcoadc bias low-pass filter.  Used for faster startup from power down.
 */
static inline int32_t adrv9001_VcoAdcMemMap_BiasDisLpf_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * vti amp current 1
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiamp1_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe), (value >> 0));

    return status;
}

/**
 * vti amp current 1
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiamp1_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * vti amp current 2
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiamp2_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf), (value >> 0));

    return status;
}

/**
 * vti amp current 2
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiamp2_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * vti input common mode level
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiampcm_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd), (value >> 0));

    return status;
}

/**
 * vti input common mode level
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiampcm_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * vti amp mirror current
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiamps_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10), (value >> 0));

    return status;
}

/**
 * vti amp mirror current
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtiamps_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * bvti center
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvticenter_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa), (value >> 0));

    return status;
}

/**
 * bvti center
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvticenter_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * vti shift current
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtishift_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11), (value >> 0));

    return status;
}

/**
 * vti shift current
 */
static inline int32_t adrv9001_VcoAdcMemMap_Bvtishift_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * vco adc is calibrated every 2^(cal_duty_cycle+14+8) clock cycles
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalDutyCycle_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x121), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * vco adc is calibrated every 2^(cal_duty_cycle+14+8) clock cycles
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalDutyCycle_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x121), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * force cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalForce_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * force cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalForce_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * control for calibration modes: 2'b0 -- foreground cal 2'b1 -- duty cycle background cal (re-runs every cal_duty_cycle clock (fs) samples), otherwise continuous background cal.
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalFreqControl_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x123), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * control for calibration modes: 2'b0 -- foreground cal 2'b1 -- duty cycle background cal (re-runs every cal_duty_cycle clock (fs) samples), otherwise continuous background cal.
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalFreqControl_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x123), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset cal, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalRst_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * reset cal, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalRst_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * calibration sequence load mode, set to 0
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalRz_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * calibration sequence load mode, set to 0
 */
static inline int32_t adrv9001_VcoAdcMemMap_CalRz_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * calibration DAC shift clock divide rate (00=div-by-2, 01=div-by-4, 1x=div-by-8)
 */
static inline int32_t adrv9001_VcoAdcMemMap_Clkshift_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * calibration DAC shift clock divide rate (00=div-by-2, 01=div-by-4, 1x=div-by-8)
 */
static inline int32_t adrv9001_VcoAdcMemMap_Clkshift_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * In kgain calculation, one of the codes used is 128 and the other code used is 128+dacval_kgain
 */
static inline int32_t adrv9001_VcoAdcMemMap_DacvalKgain_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x128), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * In kgain calculation, one of the codes used is 128 and the other code used is 128+dacval_kgain
 */
static inline int32_t adrv9001_VcoAdcMemMap_DacvalKgain_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x128), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * resets all digital blocks except memory map - self clearing
 */
static inline int32_t adrv9001_VcoAdcMemMap_DigCalRst_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x123), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * resets all digital blocks except memory map - self clearing
 */
static inline int32_t adrv9001_VcoAdcMemMap_DigCalRst_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x123), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * disable bias amplifier
 */
static inline int32_t adrv9001_VcoAdcMemMap_DisBiasAmp_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * disable bias amplifier
 */
static inline int32_t adrv9001_VcoAdcMemMap_DisBiasAmp_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * disable slope-based over-range correction
 */
static inline int32_t adrv9001_VcoAdcMemMap_DisOrc_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * disable slope-based over-range correction
 */
static inline int32_t adrv9001_VcoAdcMemMap_DisOrc_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * dither auto disable, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithDisAuto_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * dither auto disable, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithDisAuto_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * dither clock divide
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithDiv_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * dither clock divide
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithDiv_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * dither mode
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithMode_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * dither mode
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithMode_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset dither clock gen, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithRstClkgen_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * reset dither clock gen, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithRstClkgen_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset dither dac, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithRstDac_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * reset dither dac, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithRstDac_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset dither lfsr, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithRstLfsr_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * reset dither lfsr, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_DithRstLfsr_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * read only bit that indicates bcenter cal is completed
 */
static inline int32_t adrv9001_VcoAdcMemMap_DoneBcenterCal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x122), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * read bit only indicating kgain cal is done.
 */
static inline int32_t adrv9001_VcoAdcMemMap_DoneKgainCal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x128), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * read only bit indicating ramp cal is complete
 */
static inline int32_t adrv9001_VcoAdcMemMap_DoneRampCal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x129), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable additional two signal channels for 3dB noise improvement
 */
static inline int32_t adrv9001_VcoAdcMemMap_En34_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * enable additional two signal channels for 3dB noise improvement
 */
static inline int32_t adrv9001_VcoAdcMemMap_En34_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable channel i adc clock, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnAdcclkI_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * enable channel i adc clock, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnAdcclkI_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable channel q adc clock, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnAdcclkQ_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * enable channel q adc clock, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnAdcclkQ_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable for adc bias block, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnBias_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * enable for adc bias block, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnBias_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable calibration analog blocks, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnCalAna_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * enable calibration analog blocks, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnCalAna_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable calibration clock and digital blocks, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnCalClk_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * enable calibration clock and digital blocks, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnCalClk_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable channel i analog front end, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnVtiI_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * enable channel i analog front end, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnVtiI_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable channel q analog front end, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnVtiQ_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * enable channel q analog front end, set to 0 for power-down
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnVtiQ_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * clock enable for the VCO ADC digital
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnableClock_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x123), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * clock enable for the VCO ADC digital
 */
static inline int32_t adrv9001_VcoAdcMemMap_EnableClock_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x123), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * set this to 1 if we want to force a dac level.
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceDacLevel_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12d), (value >> 0));

    return status;
}

/**
 * set this to 1 if we want to force a dac level.
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceDacLevel_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * set this to 1 in order to force dac level.
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceDacLevelEn_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * set this to 1 in order to force dac level.
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceDacLevelEn_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * use over-range correction counter method 2
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceOrc1_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * use over-range correction counter method 2
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceOrc1_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * use over-range correction counter method 2
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceOrc2_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * use over-range correction counter method 2
 */
static inline int32_t adrv9001_VcoAdcMemMap_ForceOrc2_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * value of gain_bcenter that multiplies accumulated value for bcenter calculation. Can range from 1/64 to (2^7-1)/2^4 (how these bits are interpreted by hardware depends on gain_range bits in bcenter_cal register.
 */
static inline int32_t adrv9001_VcoAdcMemMap_GainBcenter_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x126), (value >> 0));

    return status;
}

/**
 * value of gain_bcenter that multiplies accumulated value for bcenter calculation. Can range from 1/64 to (2^7-1)/2^4 (how these bits are interpreted by hardware depends on gain_range bits in bcenter_cal register.
 */
static inline int32_t adrv9001_VcoAdcMemMap_GainBcenter_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x126), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * instead of computing kgain value, enter it via regmap. the format is 4.17
 */
static inline int32_t adrv9001_VcoAdcMemMap_GainValue_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x136), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x135), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x134), (value >> 0));

    return status;
}

/**
 * instead of computing kgain value, enter it via regmap. the format is 4.17
 */
static inline int32_t adrv9001_VcoAdcMemMap_GainValue_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x136), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x135), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x134), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * set this to 1 in order to use kgain value from the regmap.
 */
static inline int32_t adrv9001_VcoAdcMemMap_GainValueRegmapEn_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * set this to 1 in order to use kgain value from the regmap.
 */
static inline int32_t adrv9001_VcoAdcMemMap_GainValueRegmapEn_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * samples to accumulate for kgain cal -- entry 0x0 is 16*8 samples, 0x1 is 32*8, 0x2 is 64*8, 0x3 is 128*8, 0x4 is 256*8, 0x5 is 512*8, 0x6 is 1024*8, 0x7 is 2048*8.
 */
static inline int32_t adrv9001_VcoAdcMemMap_KgainAccCntVal_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x128), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * samples to accumulate for kgain cal -- entry 0x0 is 16*8 samples, 0x1 is 32*8, 0x2 is 64*8, 0x3 is 128*8, 0x4 is 256*8, 0x5 is 512*8, 0x6 is 1024*8, 0x7 is 2048*8.
 */
static inline int32_t adrv9001_VcoAdcMemMap_KgainAccCntVal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x128), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable kgain cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_KgainCalEn_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x123), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * enable kgain cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_KgainCalEn_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x123), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this is kgain value from Gerry's matlab code that is used as a constant for ramp calculation. it is (1/16)*(1/vmax)*(1/Kvti)*2^13. Enter this floating point value as 21 bit value with 9 integer bits and 12 subLSB bits.
 */
static inline int32_t adrv9001_VcoAdcMemMap_KgainVal_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12c), (value >> 16), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12a), (value >> 0));

    return status;
}

/**
 * this is kgain value from Gerry's matlab code that is used as a constant for ramp calculation. it is (1/16)*(1/vmax)*(1/Kvti)*2^13. Enter this floating point value as 21 bit value with 9 integer bits and 12 subLSB bits.
 */
static inline int32_t adrv9001_VcoAdcMemMap_KgainVal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12c), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * lut coefficients 128x16 bits
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutData_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x20 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * lut coefficients 128x16 bits
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutData_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x20 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable LUT clock gate, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutEnClkgate_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * enable LUT clock gate, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutEnClkgate_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LUT load edge
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutLoadedge_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LUT load edge
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutLoadedge_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * this bit will flag high if we are trying to write to the lut regmap when matrix_data_en is high
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutRegmapAccessInvalid_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset lut, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutRst_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * reset lut, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_LutRst_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable writes to lut regmap from the dig accum block
 */
static inline int32_t adrv9001_VcoAdcMemMap_MatrixDataEn_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * enable writes to lut regmap from the dig accum block
 */
static inline int32_t adrv9001_VcoAdcMemMap_MatrixDataEn_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * output enables for clocks
 */
static inline int32_t adrv9001_VcoAdcMemMap_OutCtrl_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * output enables for clocks
 */
static inline int32_t adrv9001_VcoAdcMemMap_OutCtrl_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * disable demux output, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_OutDisDemux_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * disable demux output, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_OutDisDemux_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * disable over-range, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_OvrDis_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * disable over-range, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_OvrDis_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset over-range, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_OvrRst_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * reset over-range, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_OvrRst_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * number of wait cycles for powerup (these are clk cycles with respect to fs/8 clock). The number of clock cycles is 1 <<< this reg entry -- so it can be 1,2,4,8,16 up to 32768
 */
static inline int32_t adrv9001_VcoAdcMemMap_PwrupWaitClk_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x129), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * number of wait cycles for powerup (these are clk cycles with respect to fs/8 clock). The number of clock cycles is 1 <<< this reg entry -- so it can be 1,2,4,8,16 up to 32768
 */
static inline int32_t adrv9001_VcoAdcMemMap_PwrupWaitClk_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x129), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * samples to accumulate for ramp cal. 0x0 is 16*8, 0x1 is 64*8, 0x2 is 128*8, 0x3 is 256*8, 0x4 is 512*8, 0x5 is 1024*8, 0x6 is 2048*8, 0x7 is 4096*8
 */
static inline int32_t adrv9001_VcoAdcMemMap_RampAccCntVal_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x129), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * samples to accumulate for ramp cal. 0x0 is 16*8, 0x1 is 64*8, 0x2 is 128*8, 0x3 is 256*8, 0x4 is 512*8, 0x5 is 1024*8, 0x6 is 2048*8, 0x7 is 4096*8
 */
static inline int32_t adrv9001_VcoAdcMemMap_RampAccCntVal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x129), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable ramp cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_RampCalEn_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x123), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * enable ramp cal
 */
static inline int32_t adrv9001_VcoAdcMemMap_RampCalEn_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x123), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * calibration DAC bit shift value (00=shift-by-4, 01=shift-b- 8, 1x=shift-by-16)
 */
static inline int32_t adrv9001_VcoAdcMemMap_Regshift_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * calibration DAC bit shift value (00=shift-by-4, 01=shift-b- 8, 1x=shift-by-16)
 */
static inline int32_t adrv9001_VcoAdcMemMap_Regshift_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset cal, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_RstCal_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * reset cal, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_RstCal_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * adc reset mode, set to 0
 */
static inline int32_t adrv9001_VcoAdcMemMap_SelRst_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * adc reset mode, set to 0
 */
static inline int32_t adrv9001_VcoAdcMemMap_SelRst_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * reset adc when LP ADC enters deep saturation
 */
static inline int32_t adrv9001_VcoAdcMemMap_SelShort_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * reset adc when LP ADC enters deep saturation
 */
static inline int32_t adrv9001_VcoAdcMemMap_SelShort_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg017_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg017_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg025_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg025_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg026_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg026_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg027_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg027_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg036_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg036_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg037_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg037_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg045_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg045_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg046_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg046_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg047_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg047_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg050_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg050_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg051_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg051_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg052_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg052_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg053_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg053_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg054_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg054_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg055_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg055_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg056_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg056_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg057_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg057_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg063_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg063_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg067_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg067_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg076_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg076_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg077_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg077_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B3_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B3_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B4_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B4_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B5_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B5_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B6_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B6_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B7_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0B7_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C0_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C0_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C1_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C1_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C2_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C2_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C3_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C3_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C4_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C4_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C5_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C5_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C6_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C6_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C7_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg0C7_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg123_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg123_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg124_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg124_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg125_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg125_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg126_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg126_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg127_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg127_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg143_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg143_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg144_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg144_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg145_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg145_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg146_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg146_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg147_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg147_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg157_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_VcoAdcMemMap_SpareReg157_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * load lut data from lut regmap into the LUT
 */
static inline int32_t adrv9001_VcoAdcMemMap_SpiLoad_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * load lut data from lut regmap into the LUT
 */
static inline int32_t adrv9001_VcoAdcMemMap_SpiLoad_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * state of vco_fsm
 */
static inline int32_t adrv9001_VcoAdcMemMap_VState_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * disable vti shift, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_VtiDisShift_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * disable vti shift, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_VtiDisShift_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * force vti, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_VtiForce_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * force vti, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_VtiForce_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * short vti, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_VtiShort_Set(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * short vti, active high
 */
static inline int32_t adrv9001_VcoAdcMemMap_VtiShort_Get(void *device,
    adrv9001_BfVcoAdcMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_VCO_ADC_MEM_MAP_H__