/**
 * \file
 * \brief BitField accessors for txdac_mem_map
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_TXDAC_MEM_MAP_H__
 #define __ADRV9001_BF_TXDAC_MEM_MAP_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfTxdacMemMap_e
{
    ADRV9001_BF_TX1_DAC    =   0x2c00,
    ADRV9001_BF_TX2_DAC    =   0x2e00
} adrv9001_BfTxdacMemMap_e;

static const adrv9001_BfTxdacMemMap_e txdacMemMapInstances[] = {
    ADRV9001_BF_TX1_DAC,
    ADRV9001_BF_TX2_DAC
};


/**
 * IDAC Calibration status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalActiveI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC Calibration status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalActiveQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * IDAC Address for CALDAC read and write operations.  Also address for debug mode.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalAddrI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * IDAC Address for CALDAC read and write operations.  Also address for debug mode.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalAddrI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * QDAC Address for CALDAC read and write operations.  Also address for debug mode.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalAddrQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * QDAC Address for CALDAC read and write operations.  Also address for debug mode.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalAddrQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: IDAC Calibration debug mode.  Changes behavior of calibration state machine.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDebugI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * DEBUG: IDAC Calibration debug mode.  Changes behavior of calibration state machine.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDebugI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: QDAC Calibration debug mode.  Changes behavior of calibration state machine.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDebugQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * DEBUG: QDAC Calibration debug mode.  Changes behavior of calibration state machine.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDebugQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * SPI initialize ISB calibration reference
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDoIsbref_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * SPI initialize ISB calibration reference
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDoIsbref_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables Calibration Machine to correct for Comparator Offsets
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDoOffsetCal_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enables Calibration Machine to correct for Comparator Offsets
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDoOffsetCal_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * IDAC Calibration status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDoneI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC Calibration status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalDoneQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Loop on ISB calibration to center ISB cal codes
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalIsbLoop_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Loop on ISB calibration to center ISB cal codes
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalIsbLoop_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * IDAC Count of ISB CALDACS that saturated to 0 or 15.  Count saturates at 7.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalIsbSatI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC Count of ISB CALDACS that saturated to 0 or 15.  Count saturates at 7.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalIsbSatQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Initial value for ISB REF CALDAC.  See also txdac_cal_skip_isbref.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalIsbrefInit_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * DEBUG: Initial value for ISB REF CALDAC.  See also txdac_cal_skip_isbref.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalIsbrefInit_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Loop on MSB calibration to center MSB cal codes (priority over ISB loop)
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalMsbLoop_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Loop on MSB calibration to center MSB cal codes (priority over ISB loop)
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalMsbLoop_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * IDAC Count of MSB CALDACS that saturated to 0 or 127.  Count saturates at 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalMsbSatI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC Count of MSB CALDACS that saturated to 0 or 127.  Count saturates at 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalMsbSatQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * IDAC Flag indicating one of the Offset CALDACS saturated to 127.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalOffsetSatI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC Flag indicating one of the Offset CALDACS saturated to 127.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalOffsetSatQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * IDAC CALDAC read data.  Valid range for MSB CALDACs is 0 to 127.  Valid range for ISB CALDACs is 0 to 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalRdDataI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC CALDAC read data.  Valid range for MSB CALDACs is 0 to 127.  Valid range for ISB CALDACs is 0 to 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalRdDataQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Amount of time to wait for signals to settle before performing SAR calibration on a CALDAC.  Units are calibration clocks.  0=no delay 31=maximum delay
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalSettleDelay_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0xf8, 0x3);

    return status;
}

/**
 * Amount of time to wait for signals to settle before performing SAR calibration on a CALDAC.  Units are calibration clocks.  0=no delay 31=maximum delay
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalSettleDelay_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0xf8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * I DAC Calibration Start
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalStartI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * I DAC Calibration Start
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalStartI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Q DAC Calibration Start
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalStartQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Q DAC Calibration Start
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalStartQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Select cell for calibration debug: 0 = off, 1=driven according to TXDAC_CAL_ADDR_I/ TXDAC_CAL_ADDR_Q
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalUseSelect_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * DEBUG: Select cell for calibration debug: 0 = off, 1=driven according to TXDAC_CAL_ADDR_I/ TXDAC_CAL_ADDR_Q
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalUseSelect_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * I DAC CALDAC write operation.  0 to 1 transition will save txdac_cal_wr_data to txdac_cal_addr.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWeI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * I DAC CALDAC write operation.  0 to 1 transition will save txdac_cal_wr_data to txdac_cal_addr.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWeI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Q DAC CALDAC write operation.  0 to 1 transition will save txdac_cal_wr_data to txdac_cal_addr.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWeQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Q DAC CALDAC write operation.  0 to 1 transition will save txdac_cal_wr_data to txdac_cal_addr.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWeQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * IDAC CALDAC write data.  Valid range for MSB CALDACs is 0 to 127.  Valid range for ISB CALDACs is 0 to 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWrDataI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * IDAC CALDAC write data.  Valid range for MSB CALDACs is 0 to 127.  Valid range for ISB CALDACs is 0 to 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWrDataI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * QDAC CALDAC write data.  Valid range for MSB CALDACs is 0 to 127.  Valid range for ISB CALDACs is 0 to 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWrDataQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * QDAC CALDAC write data.  Valid range for MSB CALDACs is 0 to 127.  Valid range for ISB CALDACs is 0 to 15.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalWrDataQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DAC clock divide ratio for calibration clock.  Set to 3-6 MHz
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalclkDiv_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * DAC clock divide ratio for calibration clock.  Set to 3-6 MHz
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalclkDiv_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * I DAC calibration clock enable.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalclkEnI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * I DAC calibration clock enable.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalclkEnI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Q DAC calibration clock enable.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalclkEnQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Q DAC calibration clock enable.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCalclkEnQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration DAC's Fullscale Current Setting
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCaldacFsc_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Calibration DAC's Fullscale Current Setting
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCaldacFsc_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration MSB DAC's offset
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCaldacOffset_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Calibration MSB DAC's offset
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCaldacOffset_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Assumed DAC Output Common Mode Level.  Needs to match BBF Common Mode
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCmCtrl_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * Assumed DAC Output Common Mode Level.  Needs to match BBF Common Mode
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCmCtrl_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * IDAC Average Value of all 32 MSB CALDAC codes
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompAvgmsbI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC Average Value of all 32 MSB CALDAC codes
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompAvgmsbQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: comparator powerdown value to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompBiaspd_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * DEBUG: comparator powerdown value to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompBiaspd_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Disable Comparator Settling Speed up
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompFastcmEnb_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Disable Comparator Settling Speed up
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompFastcmEnb_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ISB Comparator: Trade off Comparator Settling Time for Accuracy.  Larger value is higher gain/slower settling.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompGainIsb_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * ISB Comparator: Trade off Comparator Settling Time for Accuracy.  Larger value is higher gain/slower settling.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompGainIsb_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * MSB Comparator: Trade off Comparator Settling Time for Accuracy.  Larger value is higher gain/slower settling.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompGainMsb_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * MSB Comparator: Trade off Comparator Settling Time for Accuracy.  Larger value is higher gain/slower settling.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompGainMsb_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Number of SAR runs to average for each ISB CALDAC measurement.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompIsbavg_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Number of SAR runs to average for each ISB CALDAC measurement.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompIsbavg_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: comparator powerdown value to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompIsbpd_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * DEBUG: comparator powerdown value to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompIsbpd_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Number of SAR runs to average for each MSB CALDAC measurement.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompMsbavg_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Number of SAR runs to average for each MSB CALDAC measurement.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompMsbavg_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: comparator powerdown value to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompMsbpd_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * DEBUG: comparator powerdown value to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompMsbpd_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Disable Comparator Settling Speed Up
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompOneshotEnb_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Disable Comparator Settling Speed Up
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompOneshotEnb_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * IDAC Comparator raw output value.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompOutI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * QDAC Comparator raw output value.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacCompOutQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set amplitude of dither
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacDitherAmplitude_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0xf8, 0x3);

    return status;
}

/**
 * Set amplitude of dither
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacDitherAmplitude_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0xf8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable DAC MSB dither
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacDitherEnable_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable DAC MSB dither
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacDitherEnable_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Update rate of triangle waveform used to dither the thermometer code start pointer.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacDitherPeriod_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1), (value >> 0));

    return status;
}

/**
 * Update rate of triangle waveform used to dither the thermometer code start pointer.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacDitherPeriod_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Bring IDAC Currents to a Test Port.  Current selection driven by txdac_cal_debug, txdac_cal_address, and txdac_sel_cal_to_pin
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacExtcalEnableI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * DEBUG: Bring IDAC Currents to a Test Port.  Current selection driven by txdac_cal_debug, txdac_cal_address, and txdac_sel_cal_to_pin
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacExtcalEnableI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Bring QDAC Currents to a Test Port.  Current selection driven by txdac_cal_debug, txdac_cal_address, and txdac_sel_cal_to_pin
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacExtcalEnableQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * DEBUG: Bring QDAC Currents to a Test Port.  Current selection driven by txdac_cal_debug, txdac_cal_address, and txdac_sel_cal_to_pin
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacExtcalEnableQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Boost IDAC Output Power by 3dB
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscBoostI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Boost IDAC Output Power by 3dB
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscBoostI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Boost QDAC Output Power by 3dB
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscBoostQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Boost QDAC Output Power by 3dB
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscBoostQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Fine tune IDAC full scale current between [-256uA,240uA) in 16uA steps.  Offset binary format.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscTuneI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * Fine tune IDAC full scale current between [-256uA,240uA) in 16uA steps.  Offset binary format.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscTuneI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Fine tune QDAC full scale current between [-256uA,240uA) in 16uA steps.  Offset binary format.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscTuneQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * Fine tune QDAC full scale current between [-256uA,240uA) in 16uA steps.  Offset binary format.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacFscTuneQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable random shuffle for DAC ISBs
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacIsbShuffleEnable_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable random shuffle for DAC ISBs
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacIsbShuffleEnable_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable random shuffle for DAC MSBs
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacMsbShuffleEnable_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable random shuffle for DAC MSBs
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacMsbShuffleEnable_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Forces DAC Output to 0.2-0.3V in case BBF is not setting common mode
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacOutputProtect0p2v_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Forces DAC Output to 0.2-0.3V in case BBF is not setting common mode
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacOutputProtect0p2v_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Forces DAC Output to ground in case BBF is not setting common mode
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacOutputProtectGnd_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Forces DAC Output to ground in case BBF is not setting common mode
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacOutputProtectGnd_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Force Masterbias to stay on
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPdMbiasOverride_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Force Masterbias to stay on
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPdMbiasOverride_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Power down Driver Control when txdac_powerdown_override==1.  Needed for Comparator or DAC Manual Powerup/Powerdown
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPddriverEnable_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * DEBUG: Power down Driver Control when txdac_powerdown_override==1.  Needed for Comparator or DAC Manual Powerup/Powerdown
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPddriverEnable_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DAC clock divide ratio for powerdown state machine clock. Set to 200kHz - 400kHz
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownClkdiv_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * DAC clock divide ratio for powerdown state machine clock. Set to 200kHz - 400kHz
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownClkdiv_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: dac powerdown control to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownCtrl_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * DEBUG: dac powerdown control to use when txdac_powerdown_override==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownCtrl_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * I DAC Powerdown Control
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownI_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * I DAC Powerdown Control
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: manual override of txdac_powerdown_i and txdac_powerdown_q signals
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownOverride_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * DEBUG: manual override of txdac_powerdown_i and txdac_powerdown_q signals
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownOverride_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Q DAC powerdown Control
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownQ_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Q DAC powerdown Control
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * I DAC Powerdown Status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownStatI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Q DAC Powerdown Status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerdownStatQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * I DAC Powerup Status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerupStatI_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Q DAC Powerup Status
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacPowerupStatQ_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Selects which current branch to bring out
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacSelCalToPin_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * DEBUG: Selects which current branch to bring out
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacSelCalToPin_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set amplitude of random shuffle
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacShuffleAmplitude_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Set amplitude of random shuffle
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacShuffleAmplitude_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LOW resets the decoder shuffle state
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacShuffleResetb_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LOW resets the decoder shuffle state
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacShuffleResetb_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Currently Unassigned Bits
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacSpareCtrl_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x24), (value >> 0));

    return status;
}

/**
 * Currently Unassigned Bits
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacSpareCtrl_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: SPI driven Clock for poweron state machine when txdac_startup_mansel==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacStartupManclk_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * DEBUG: SPI driven Clock for poweron state machine when txdac_startup_mansel==1
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacStartupManclk_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: poweron state machine clock bypass
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacStartupMansel_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * DEBUG: poweron state machine clock bypass
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacStartupMansel_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DAC is ready to be taken out of powerdown
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacStartupReady_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Performance vs Power tradeoff
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacThrowIsbCtrl_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x27), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * DEBUG: Performance vs Power tradeoff
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacThrowIsbCtrl_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x27), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Performance vs Power tradeoff
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacThrowLsbCtrl_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x27), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * DEBUG: Performance vs Power tradeoff
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacThrowLsbCtrl_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x27), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Use Calibrated FSC
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacUseGain_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Use Calibrated FSC
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacUseGain_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG: Set Current Source Headroom.  margin = 60mV + code*30mV
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacVdsMargin_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * DEBUG: Set Current Source Headroom.  margin = 60mV + code*30mV
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacVdsMargin_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable MSB start pointer to slowly increment over time.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacWalkEnable_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable MSB start pointer to slowly increment over time.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacWalkEnable_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Start pointer for the MSB thermometer code will slowly increase over time.  This sets the pointer update rate.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacWalkPeriod_Set(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Start pointer for the MSB thermometer code will slowly increase over time.  This sets the pointer update rate.
 */
static inline int32_t adrv9001_TxdacMemMap_TxdacWalkPeriod_Get(void *device,
    adrv9001_BfTxdacMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_TXDAC_MEM_MAP_H__