/**
 * \file
 * \brief BitField accessors for nvs_regmap_txb
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_TXB_H__
 #define __ADRV9001_BF_NVS_REGMAP_TXB_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfNvsRegmapTxb_e
{
    ADRV9001_BF_TXB1_CORE    =   0x800,
    ADRV9001_BF_TXB2_CORE    =   0xc00
} adrv9001_BfNvsRegmapTxb_e;

static const adrv9001_BfNvsRegmapTxb_e nvsRegmapTxbInstances[] = {
    ADRV9001_BF_TXB1_CORE,
    ADRV9001_BF_TXB2_CORE
};


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcCnt0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcImagAcc0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertXi_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertXi_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertXq_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertXq_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertYi_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertYi_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertYq_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcInvertYq_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutI0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutI1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x33), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x32), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x31), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x30), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutI2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x37), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x36), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x35), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x34), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutI3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x39), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x38), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutQ0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutQ1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x43), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x42), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x41), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x40), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutQ2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x47), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x46), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x45), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x44), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcOutQ3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x49), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x48), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcCcRealAcc0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmAcc0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmCnt0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowExp0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x22), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowExp1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowExp2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowExp3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowMan0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x21), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x20), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowMan1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x23), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowMan2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x27), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x26), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmPowMan3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x29), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_ClgcPmStatusOut_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcCnt0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x69), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcImagAcc0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x68), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x67), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x66), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x65), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x64), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x63), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x62), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x61), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertXi_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x99), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertXi_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x99), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertXq_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x99), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertXq_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x99), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertYi_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x99), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertYi_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x99), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertYq_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x99), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 1: invert, 0: do not invert
 */
static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcInvertYq_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x99), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutI0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x79), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x78), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutI1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutI2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x83), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x82), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x81), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x80), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutI3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x87), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x86), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x85), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x84), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutQ0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x89), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x88), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutQ1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutQ2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x93), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x92), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x91), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x90), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcOutQ3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x97), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x96), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x95), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x94), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaCcRealAcc0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x60), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x59), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmAcc0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x54), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x53), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x52), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x51), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x50), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmCnt0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x58), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x57), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x56), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowExp0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowExp1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x71), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowExp2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x74), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowExp3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x77), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowMan0_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowMan1_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x70), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowMan2_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x73), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x72), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmPowMan3_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x76), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x75), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTxb_GanPaPmStatusOut_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4d), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup10ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup10ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup11ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup11ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup2ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb3), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup2ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup3ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup3ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup3ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb3), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup3ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb3), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup4ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup4ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup4ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb4), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup4ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb4), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup5ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup5ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup5ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb4), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup5ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb4), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup6ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup6ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup6ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb5), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup6ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb5), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup7ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup7ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup7ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb5), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup7ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb5), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup8ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup8ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup8ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb6), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup8ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb6), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup9ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup9ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup9ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb6), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1AlgGroup9ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb6), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1CssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1CssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1CssiClkgenDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9d), (value >> 0));

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1CssiClkgenDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpDucEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xae), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpDucEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xae), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt212En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt212En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt214En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt214En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt216En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt216En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt218En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt218En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt220En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt220En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt2221En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt2221En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt222En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt222En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt224En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt224En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt226En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt226En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt228En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt228En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt230En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt230En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt236En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt236En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt238En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt238En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt28En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt28En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt310En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt310En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt340En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt340En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt3441En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpInt3441En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpIqdmEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xae), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpIqdmEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xae), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpModemMode_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa5), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpModemMode_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpModemModeDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa7), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa6), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpModemModeDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa7), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpSinc242En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpSinc242En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpSinc344En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpSinc344En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTscic32DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa5), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTscic32DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTscic32En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTscic32En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxFreqDevMapper47En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxFreqDevMapper47En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxPreproc2DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa9), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxPreproc2DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa9), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxPreproc2En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa8), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxPreproc2En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa8), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxRound46En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1DpTxRound46En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiClkgenDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa0), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9f), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiClkgenDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiDataDestClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x122), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x121), (value >> 0));

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiDataDestClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x122), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x121), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiDataDestClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x127), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1LssiDataDestClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x127), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1Pfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xad), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1Pfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xad), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1Pfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xab), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xac), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1Pfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xab), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xac), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirIEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirIEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirQEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirQEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXISelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXISelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXISelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12f), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXISelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12f), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXQSelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXQSelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXQSelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12f), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1PfirXQSelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12f), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1ProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1ProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1ProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx1ProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup10ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcd), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup10ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup11ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcd), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup11ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup2ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup2ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup3ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup3ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup3ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup3ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup4ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup4ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup4ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcf), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup4ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcf), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup5ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup5ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup5ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcf), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup5ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcf), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup6ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup6ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup6ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup6ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup7ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup7ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup7ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup7ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup8ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcc), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup8ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup8ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup8ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup9ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup9ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup9ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2AlgGroup9ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2CssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2CssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2CssiClkgenDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb8), (value >> 0));

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2CssiClkgenDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpDucEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpDucEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt212En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbc), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt212En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt214En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbc), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt214En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt216En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbc), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt216En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbc), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt218En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbc), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt218En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt220En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt220En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt2221En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt2221En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt222En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt222En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt224En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt224En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt226En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt226En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt228En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt228En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt230En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt230En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt236En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbe), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt236En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt238En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbe), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt238En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbe), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt28En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbc), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt28En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt310En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbc), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt310En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbc), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt340En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbe), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt340En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbe), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt3441En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbe), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpInt3441En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbe), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpIqdmEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpIqdmEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpModemMode_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpModemMode_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpModemModeDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc1), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpModemModeDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpSinc242En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbe), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpSinc242En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbe), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpSinc344En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbe), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpSinc344En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbe), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xca), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xca), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTscic32DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc0), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTscic32DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTscic32En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTscic32En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxFreqDevMapper47En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbf), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxFreqDevMapper47En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxPreproc2DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc4), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxPreproc2DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc4), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxPreproc2En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxPreproc2En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxRound46En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2DpTxRound46En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiClkgenDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xba), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiClkgenDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xba), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiDataDestClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x124), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x123), (value >> 0));

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiDataDestClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x124), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x123), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiDataDestClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x127), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2LssiDataDestClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x127), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2Pfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2Pfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2Pfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc7), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2Pfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirIEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirIEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirQEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirQEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXISelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXISelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXISelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXISelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXQSelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXQSelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXQSelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2PfirXQSelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2ProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2ProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2ProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcb), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx2ProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup10ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup10ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup11ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup11ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup2ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe9), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup2ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe9), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup3ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup3ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup3ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe9), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup3ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe9), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup4ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup4ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup4ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xea), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup4ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xea), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup5ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup5ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup5ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xea), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup5ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xea), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup6ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup6ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup6ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xeb), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup6ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xeb), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup7ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup7ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup7ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xeb), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup7ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xeb), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup8ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup8ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup8ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xec), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup8ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xec), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup9ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup9ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup9ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xec), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3AlgGroup9ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xec), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3CssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3CssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3CssiClkgenDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd3), (value >> 0));

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3CssiClkgenDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpDucEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpDucEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt212En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt212En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt214En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt214En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt216En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt216En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt218En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt218En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt220En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt220En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt2221En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt2221En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt222En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt222En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt224En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt224En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt226En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt226En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt228En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt228En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt230En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt230En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt236En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt236En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt238En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt238En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt28En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt28En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt310En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt310En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt340En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt340En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt3441En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpInt3441En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpIqdmEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpIqdmEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpModemMode_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdb), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpModemMode_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdb), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpModemModeDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdd), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdc), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpModemModeDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdd), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpSinc242En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpSinc242En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpSinc344En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpSinc344En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTscic32DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdb), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTscic32DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdb), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTscic32En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTscic32En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxFreqDevMapper47En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxFreqDevMapper47En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxPreproc2DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdf), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxPreproc2DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdf), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxPreproc2En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xde), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxPreproc2En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xde), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxRound46En_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3DpTxRound46En_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiClkgenDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd5), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiClkgenDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiDataDestClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x126), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x125), (value >> 0));

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiDataDestClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x126), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x125), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiDataDestClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x127), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3LssiDataDestClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x127), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3Pfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3Pfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3Pfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe2), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3Pfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirIEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirIEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirQEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirQEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXISelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x131), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXISelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXISelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x131), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXISelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXQSelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x131), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXQSelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXQSelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x131), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3PfirXQSelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3ProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3ProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3ProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_Otx3ProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: TX profile selected, 1: OTX1/OTX2/OTX3 profile selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxProfileSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: TX profile selected, 1: OTX1/OTX2/OTX3 profile selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxProfileSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: OTX1 selected, 1: OTX2_selected, 2: OTX3_selected, 3: OTX3_selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New) 0: OTX1 selected, 1: OTX2_selected, 2: OTX3_selected, 3: OTX3_selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: TX profile selected, 1: OTX1/OTX2/OTX3 profile selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxSsiProfileSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: TX profile selected, 1: OTX1/OTX2/OTX3 profile selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxSsiProfileSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: OTX1 selected, 1: OTX2_selected, 2: OTX3_selected, 3: OTX3_selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxSsiSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New) 0: OTX1 selected, 1: OTX2_selected, 2: OTX3_selected, 3: OTX3_selected
 */
static inline int32_t adrv9001_NvsRegmapTxb_OtxSsiSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgArmOrGroup11ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgArmOrGroup11ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11CgClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11CgClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11CgClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11CgClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11GdcPreClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11GdcPreClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11GdcPreClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11GdcPreClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11LolbClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11LolbClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11LolbClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11LolbClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11Mc21ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11Mc21ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11PaProtClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11PaProtClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11PaProtClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11PaProtClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11SrlClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11SrlClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11SrlClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11SrlClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxAttenDpathClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxAttenDpathClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxAttenDpathClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxAttenDpathClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxbbfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x106), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxbbfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x106), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxbbfClkReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x107), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxbbfClkReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x107), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxbbfClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup11TxbbfClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Fifo2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x102), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Fifo2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x102), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1GanPaClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x102), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1GanPaClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x102), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1GanPaResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1GanPaResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Intp2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x102), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Intp2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x102), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Nco2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x102), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Nco2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x102), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Pfir2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x102), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup1Pfir2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x102), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup2ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup2ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3DpdTopClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3DpdTopClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3DpdTopClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3DpdTopClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Fifo1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Fifo1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Intp1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Intp1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3LolClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3LolClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Mc13ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Mc13ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Nco1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Nco1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Pfir1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup3Pfir1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4CorrClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4CorrClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4CorrClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4CorrClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Fifo0ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Fifo0ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Intp0ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Intp0ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Nco0ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Nco0ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Pfir0ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4Pfir0ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4TwinfirClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup4TwinfirClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup5ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup5ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup7ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup7ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup8ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup8ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup9ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgGroup9ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco0FreeClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x103), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco0FreeClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x103), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco0FreeReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x107), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco0FreeReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x107), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco1FreeClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x103), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco1FreeClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x103), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco1FreeReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x107), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco1FreeReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x107), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco2FreeClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x103), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco2FreeClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x103), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco2FreeReset_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x107), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAlgNco2FreeReset_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x107), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAttenTableSramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfc), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxAttenTableSramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfc), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from Divider, 1: data destination clock inherit from datapath preproc clock
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiDataDestClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from Divider, 1: data destination clock inherit from datapath preproc clock
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiDataDestClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear the CSSI Fifo for variable strobe mode only
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiFifoVariableStrobeClear_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear the CSSI Fifo for variable strobe mode only
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiFifoVariableStrobeClear_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Fifo Status for variable strobe mode
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiFifoVariableStrobeEmpty_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Fifo Status for variable strobe mode
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiFifoVariableStrobeFull_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to lssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiMaskStrobeEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x128), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to lssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiMaskStrobeEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x128), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiMaskStrobeValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12a), (value >> 0));

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiMaskStrobeValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Variable Strobe mode in CSSI TX interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiVariableStrobeModeEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x128), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Enable Variable Strobe mode in CSSI TX interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxCssiVariableStrobeModeEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x128), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpIqdmInClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x108), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpIqdmInClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x108), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpIqdmNcoClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x108), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpIqdmNcoClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x108), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc0SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc0SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc1SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc1SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc2SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfa), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc2SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfa), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc3SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfa), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdAcc3SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfa), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdCrossaccSram0NapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdCrossaccSram0NapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut0SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xef), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut0SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xef), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut1SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xef), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut1SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xef), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut2SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf0), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut2SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut3SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf0), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut3SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf0), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut4SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf1), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut4SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut5SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf1), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut5SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf1), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut6SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf2), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut6SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut7SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf2), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut7SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf2), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut8SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt1Lut8SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut0SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf4), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut0SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut1SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf4), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut1SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf4), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut2SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf5), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut2SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut3SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf5), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut3SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf5), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut4SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut4SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut5SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf6), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut5SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf6), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut6SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut6SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut7SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf7), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut7SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut8SramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdExt2Lut8SramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdTxsbufSram0NapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfb), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdTxsbufSram0NapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfb), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdTxsbufSram1NapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfb), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxDpdTxsbufSram1NapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfb), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiDataDestClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x120), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11f), (value >> 0));

    return status;
}

/**
 * (B0 New) LVDS SSI data destiantion Clock div value for Decimation/Interpolation of the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiDataDestClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x120), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiDataDestClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x127), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: data destination clock inherit from datapath, 1: data destimation clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiDataDestClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x127), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: In DEBUG mode, destination clock inherit from Divider, 1: in DEBUG mode, destination clock inherit from Datapath Preproc clock
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiDataDestDbgModeClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: In DEBUG mode, destination clock inherit from Divider, 1: in DEBUG mode, destination clock inherit from Datapath Preproc clock
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiDataDestDbgModeClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) LSSI TX Fifo Empty Flag. Cleared on Read
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiFifoEmpty_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) LSSI TX Fifo Full Flag. Cleared on Read
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiFifoFull_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to lssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiMaskStrobeEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x128), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to lssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiMaskStrobeEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x128), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiMaskStrobeValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x129), (value >> 0));

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiMaskStrobeValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x129), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Variable Strobe mode in LSSI TX interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiVariableStrobeModeEnable_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x128), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Enable Variable Strobe mode in LSSI TX interface
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxLssiVariableStrobeModeEnable_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x128), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12DcI_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11a), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x119), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x118), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12DcI_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x119), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x118), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12DcQ_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11d), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11b), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12DcQ_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11d), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12DcUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12DcUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12PhaseOffsetWord_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x117), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x116), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco12PhaseOffsetWord_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x117), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x116), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1DcI_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x111), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x110), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10f), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1DcI_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x111), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x110), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1DcQ_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x114), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x113), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x112), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1DcQ_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x114), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x113), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x112), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1DcUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x115), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1DcUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x115), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1PhaseOffsetWord_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10d), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxNco1PhaseOffsetWord_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXISelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXISelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXISelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXISelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXQSelForce_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXQSelForce_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXQSelForceValue_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxPfirXQSelForceValue_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram0NapARetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfe), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram0NapARetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfe), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram0NapBRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x100), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram0NapBRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x100), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram1NapARetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfe), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram1NapARetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfe), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram1NapBRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x100), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram1NapBRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x100), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram2NapARetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xff), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram2NapARetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xff), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram2NapBRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x101), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTxb_TxQecFifoSram2NapBRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapTxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x101), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_TXB_H__