/**
 * \file
 * \brief BitField accessors for nvs_regmap_tx
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_TX_H__
 #define __ADRV9001_BF_NVS_REGMAP_TX_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfNvsRegmapTx_e
{
    ADRV9001_BF_TX1_CORE    =   0x600,
    ADRV9001_BF_TX2_CORE    =   0xa00
} adrv9001_BfNvsRegmapTx_e;

static const adrv9001_BfNvsRegmapTx_e nvsRegmapTxInstances[] = {
    ADRV9001_BF_TX1_CORE,
    ADRV9001_BF_TX2_CORE
};

static inline int32_t adrv9001_NvsRegmapTx_TGCaptureISel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGCaptureISel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGCaptureIq16bitSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12a), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGCaptureIq16bitSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGCaptureSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12a), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGCaptureSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGDriveIZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x86), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGDriveIZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x86), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGDriveQZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x86), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGDriveQZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x86), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGDriveSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TGDriveSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_AllTxEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x51), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_AllTxEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x51), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTx_AnaDigDelayPre_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Disable TX LVDS clock from analog, 1: Enable TX LVDS clock from analog
 */
static inline int32_t adrv9001_NvsRegmapTx_AnaLssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Disable TX LVDS clock from analog, 1: Enable TX LVDS clock from analog
 */
static inline int32_t adrv9001_NvsRegmapTx_AnaLssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Spare o2a bits
 */
static inline int32_t adrv9001_NvsRegmapTx_AnalogSpare_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc3), (value >> 0));

    return status;
}

/**
 * Spare o2a bits
 */
static inline int32_t adrv9001_NvsRegmapTx_AnalogSpare_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This starts ramping down gain (increasing attenuation) on the TX

 * ch1 path. Useful for slowly reducing PA power before shutting off the TX

 * upconverter. This bit is cleared automatically when the procedure is complete.
 */
static inline int32_t adrv9001_NvsRegmapTx_AttenRampDown_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * This starts ramping down gain (increasing attenuation) on the TX

 * ch1 path. Useful for slowly reducing PA power before shutting off the TX

 * upconverter. This bit is cleared automatically when the procedure is complete.
 */
static inline int32_t adrv9001_NvsRegmapTx_AttenRampDown_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This starts ramping up gain (decreasing attenuation) on the TX

 * ch1 path. Useful for slowly increasing PA power after powering on the TX. This

 * bit is cleared automatically when the procedure is complete. Must have

 * previously used the "atten_ramp_down_tx1" bit for this to be useful.
 */
static inline int32_t adrv9001_NvsRegmapTx_AttenRampUp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This starts ramping up gain (decreasing attenuation) on the TX

 * ch1 path. Useful for slowly increasing PA power after powering on the TX. This

 * bit is cleared automatically when the procedure is complete. Must have

 * previously used the "atten_ramp_down_tx1" bit for this to be useful.
 */
static inline int32_t adrv9001_NvsRegmapTx_AttenRampUp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTLAvgExp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x139), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTLAvgExp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x139), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTLAvgMan_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x138), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x137), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTLAvgMan_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x138), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x137), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTLInst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x141), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x140), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTLInst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x141), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x140), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTUAvgExp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x136), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTUAvgExp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x136), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTUAvgMan_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x135), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x134), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTUAvgMan_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x135), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x134), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTUInst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13d), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13c), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmTUInst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x144), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x143), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x142), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x144), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x143), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x142), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0NumB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x147), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x146), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x145), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0NumB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x147), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x146), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x145), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x14a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x149), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x148), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x149), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x148), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0NumRecipB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x14d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x14c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x14b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc0NumRecipB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc1Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x150), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x14f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x14e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc1Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x150), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc1NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x153), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x152), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x151), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc1NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x153), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x152), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x151), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc2Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x156), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x155), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x154), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc2Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x156), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x155), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x154), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc2NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x159), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x158), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x157), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc2NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x159), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x158), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x157), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc3Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15c), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc3Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15c), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc3NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15f), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15d), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAcc3NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x160), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x160), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccOvr_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x163), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccOvr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x163), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccOvrVal_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x164), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccOvrVal_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x164), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x166), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x166), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccSelB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x167), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmAccSelB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x167), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmClearMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x161), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmClearMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x161), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x165), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x165), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmReadStrobe_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x162), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmReadStrobe_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x162), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmXSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x168), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcPmXSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x168), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcRssiCcDataCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12d), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ClgcRssiCcDataCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When high the CLKGEN sample and interface clock buffers for this slice is enabled.
 */
static inline int32_t adrv9001_NvsRegmapTx_ClkgenOutputBufferEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbc), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When high the CLKGEN sample and interface clock buffers for this slice is enabled.
 */
static inline int32_t adrv9001_NvsRegmapTx_ClkgenOutputBufferEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainBypass_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainBypass_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1af), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ae), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1af), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ae), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b0), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainUpdateSingle_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ComplexGainUpdateSingle_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * step size for constant step mode in increments of .05 dB. Value

 * should be greater than zero when using constant step mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_ConstStepModeStepSize_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe5), (value >> 0), 0xfc, 0x2);

    return status;
}

/**
 * step size for constant step mode in increments of .05 dB. Value

 * should be greater than zero when using constant step mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_ConstStepModeStepSize_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe5), &register_value, 0xfc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Wait duration (in tx_atten_clk cycles) between consecutive steps
 */
static inline int32_t adrv9001_NvsRegmapTx_ConstStepModeWaitDuration_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Wait duration (in tx_atten_clk cycles) between consecutive steps
 */
static inline int32_t adrv9001_NvsRegmapTx_ConstStepModeWaitDuration_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register selects which set of bits will be monitored by the control output bits when they are assigned to GPIO pins. See the document for Control output pins for more information on the signals.
 */
static inline int32_t adrv9001_NvsRegmapTx_ControlOutMuxSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12c), (value >> 0));

    return status;
}

/**
 * This register selects which set of bits will be monitored by the control output bits when they are assigned to GPIO pins. See the document for Control output pins for more information on the signals.
 */
static inline int32_t adrv9001_NvsRegmapTx_ControlOutMuxSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX clear_ddr_strobe_align_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxClearDdrStrobeAlignError_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * CMOS TX clear_ddr_strobe_align_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxClearDdrStrobeAlignError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX clear_ramp_shift_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxClearRampShiftError_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * CMOS TX clear_ramp_shift_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxClearRampShiftError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX clear_strobe_align_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxClearStrobeAlignError_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * CMOS TX clear_strobe_align_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxClearStrobeAlignError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX data_format
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDataFormat_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * CMOS TX data_format
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDataFormat_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX data_format_four_lanes
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDataFormatFourLanes_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS TX data_format_four_lanes
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDataFormatFourLanes_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrClkInv_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrClkInv_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrNegStrobeSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrNegStrobeSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrPosClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrPosClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTx_CssiTxDdrStrobeAlignError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * CMOS TX debug_captured_data
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugCapturedData_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * CMOS TX debug_captured_data_second
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugCapturedDataSecond_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: 16 bits RAMP & SHIFT debug mode, 1: 4 bits RAMP & SHIFT mode
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugLoad4bitsMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: 16 bits RAMP & SHIFT debug mode, 1: 4 bits RAMP & SHIFT mode
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugLoad4bitsMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS TX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX debug_nibble_sel
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugNibbleSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * CMOS TX debug_nibble_sel
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugNibbleSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugQSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * CMOS TX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugQSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * CMOS TX debug_ramp_shift_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugRampShiftError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX debug_start_capture
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugStartCapture_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * CMOS TX debug_start_capture
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugStartCapture_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugStartRamp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * CMOS TX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugStartRamp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugStartShift_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * CMOS TX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxDebugStartShift_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX enable
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS TX enable
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX fifo_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * CMOS TX fifo_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX fifo_clk_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * CMOS TX fifo_clk_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * CMOS TX fifo_empty
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoEmpty_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX fifo_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * CMOS TX fifo_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * CMOS TX fifo_full
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxFifoFull_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX force_mcs
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxForceMcs_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS TX force_mcs
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxForceMcs_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxInvertClk_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxInvertClk_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxLongStrobe_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * CMOS TX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxLongStrobe_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxLsbFirst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * CMOS TX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxLsbFirst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS TX q_first
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxQFirst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * CMOS TX q_first
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxQFirst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxRdFifoEnableDelay_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxRdFifoEnableDelay_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * CMOS TX strobe_align_error
 */
static inline int32_t adrv9001_NvsRegmapTx_CssiTxStrobeAlignError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxdpIntfSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_CssiTxdpIntfSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DacClockEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DacClockEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DataCaptureDriveEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12b), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DataCaptureDriveEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModAnalogClkdivValue_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModAnalogClkdivValue_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModClkPolarity_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc9), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModClkPolarity_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModFifoEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModFifoEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModNumClkCycles_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc8), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModNumClkCycles_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModRdFifoEnableDelay_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc7), (value >> 0), 0xe, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_DirectModRdFifoEnableDelay_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc7), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_EnConstStepMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_EnConstStepMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Update attenuation word only when CSB signal goes HIGH
 */
static inline int32_t adrv9001_NvsRegmapTx_EnableSpiCsbUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Update attenuation word only when CSB signal goes HIGH
 */
static inline int32_t adrv9001_NvsRegmapTx_EnableSpiCsbUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_FlushPeriod_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a2), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a0), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_FlushPeriod_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a1), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanAmpRssiCcDataCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12d), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanAmpRssiCcDataCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTLAvgExp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16e), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTLAvgExp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16e), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTLAvgMan_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16c), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTLAvgMan_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTLInst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x176), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x175), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x174), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x173), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTLInst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x176), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x175), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x174), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x173), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTUAvgExp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16b), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTUAvgExp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16b), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTUAvgMan_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x169), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTUAvgMan_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x169), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTUInst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x172), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x171), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x170), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmTUInst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x172), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x171), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x170), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x179), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x178), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x177), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x179), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x178), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x177), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0NumB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17c), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0NumB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17c), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17f), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17d), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0NumRecipB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x182), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x181), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x180), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc0NumRecipB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x182), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x181), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x180), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc1Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x184), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x183), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc1Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x184), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x183), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc1NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x188), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x187), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x186), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc1NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x188), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x187), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x186), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc2Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18b), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x189), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc2Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x189), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc2NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18c), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc2NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc3Num_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x191), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x190), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc3Num_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x191), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x190), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc3NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x194), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x193), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x192), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAcc3NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x194), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x193), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x192), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x195), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x195), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccOvr_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccOvr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccOvrVal_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccOvrVal_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19b), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccSelB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19c), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmAccSelB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmClearMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x196), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmClearMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x196), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmReadStrobe_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x197), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmReadStrobe_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x197), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmXSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GanPaPmXSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the initial analog attenuation for Tx1/Tx2 gain delay calibrations, and the intial Rx Fe Gain for the Rx1/Rx2 gain delay calibrations

 * HP Atten = Gain Delay Cal Analog Gain 1[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 1[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 1[5:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalAnaGain1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf2), (value >> 0));

    return status;
}

/**
 * This sets the initial analog attenuation for Tx1/Tx2 gain delay calibrations, and the intial Rx Fe Gain for the Rx1/Rx2 gain delay calibrations

 * HP Atten = Gain Delay Cal Analog Gain 1[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 1[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 1[5:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalAnaGain1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the final analog attenuation for Tx1/Tx2 gain delay calibrations, and the final Rx Fe Gain for the Rx1/Rx2 gain delay calibrations.

 * HP Atten = Gain Delay Cal Analog Gain 2[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 2[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 2[5:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalAnaGain2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf3), (value >> 0));

    return status;
}

/**
 * This register sets the final analog attenuation for Tx1/Tx2 gain delay calibrations, and the final Rx Fe Gain for the Rx1/Rx2 gain delay calibrations.

 * HP Atten = Gain Delay Cal Analog Gain 2[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 2[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 2[5:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalAnaGain2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the initial digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 1[6:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalDigGain1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf4), (value >> 0));

    return status;
}

/**
 * This register sets the initial digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 1[6:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalDigGain1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the final digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 2[6:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalDigGain2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf5), (value >> 0));

    return status;
}

/**
 * This register sets the final digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 2[6:0]
 */
static inline int32_t adrv9001_NvsRegmapTx_GdcalDigGain2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTx_GdcalStatePre_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19f), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GdcalTxStartCal_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19f), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GdcalTxStartCal_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GdcalWindowSize_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19f), (value >> 0), 0x38, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_GdcalWindowSize_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19f), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_IntDelay0Enable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_IntDelay0Enable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_IntDelay1Enable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12f), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_IntDelay1Enable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_IntTxEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_IntTxEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit restricts asserting the attenuation change interrupt (for both channels) to differences in the attenuation HP readback word and current value. When this bit is not set an interrupt will be asserted if any change to the attenuation HP or 10 bit digital attenuation word is detected
 */
static inline int32_t adrv9001_NvsRegmapTx_InterruptArmOnlyForAttenHpChanges_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This bit restricts asserting the attenuation change interrupt (for both channels) to differences in the attenuation HP readback word and current value. When this bit is not set an interrupt will be asserted if any change to the attenuation HP or 10 bit digital attenuation word is detected
 */
static inline int32_t adrv9001_NvsRegmapTx_InterruptArmOnlyForAttenHpChanges_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LdoResLoad_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f1), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LdoResLoad_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f1), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LoLdoBypass_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LoLdoBypass_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LoLdoGmBoost_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f1), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LoLdoGmBoost_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f1), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LoLdoPd_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LoLdoPd_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear LVDS TX early_strobe_detected_flag
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxClearEarlyStrobeDetectedFlag_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear LVDS TX early_strobe_detected_flag
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxClearEarlyStrobeDetectedFlag_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX rd_strobe_align_error
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxClearStrobeAlignError_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * LVDS TX rd_strobe_align_error
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxClearStrobeAlignError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX data_format_12bit
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDataFormat12bit_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS TX data_format_12bit
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDataFormat12bit_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX data_one_lane
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDataOneLane_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS TX data_one_lane
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDataOneLane_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_after_fifo_error_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugAfterFifoErrorClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS TX debug_after_fifo_error_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugAfterFifoErrorClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX debug captured_data
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugCapturedData_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x27), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x26), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) LVDS TX debug captured_data_second
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugCapturedDataSecond_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ca), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX debug error (DO NOT use it for PRBS and RAMP mode; check error_counter instead)
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_error_counter_read
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugErrorCounterRead_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * LVDS TX debug_error_counter_read
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugErrorCounterRead_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS TX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_prbs15_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs15Enable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS TX debug_prbs15_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs15Enable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX debug prbs15_ramp_shift_error_count
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs15RampShiftErrorCount_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x22), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_prbs15_restart
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs15Restart_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS TX debug_prbs15_restart
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs15Restart_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_prbs7_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7Enable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS TX debug_prbs7_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7Enable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_prbs7_error_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7ErrorClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS TX debug_prbs7_error_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7ErrorClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX debug prbs7_error_count
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7ErrorCount_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_prbs7_restart
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7Restart_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS TX debug_prbs7_restart
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7Restart_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_prbs7_swap_odd_even
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7SwapOddEven_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LVDS TX debug_prbs7_swap_odd_even
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugPrbs7SwapOddEven_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugQSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * LVDS TX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugQSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_start_capture
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartCapture_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LVDS TX debug_start_capture
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartCapture_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_start_error_check
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartErrorCheck_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * LVDS TX debug_start_error_check
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartErrorCheck_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartRamp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS TX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartRamp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartShift_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS TX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDebugStartShift_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX div_value
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e), (value >> 0));

    return status;
}

/**
 * LVDS TX div_value
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX early_strobe_detected_flag
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxEarlyStrobeDetectedFlag_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS TX enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX fifo_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LVDS TX fifo_clear
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX fifo_clk_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS TX fifo_clk_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX fifo_empty
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoEmpty_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX fifo_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS TX fifo_enable
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX fifo_full
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoFull_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoReadReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x29), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoReadReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x29), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoWriteReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x29), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxFifoWriteReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x29), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX force_mcs
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxForceMcs_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * LVDS TX force_mcs
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxForceMcs_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFullRefclkClkGatingEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFullRefclkClkGatingEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 new)
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFullRefclkDutyCycleHighLonger_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 new)
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxFullRefclkDutyCycleHighLonger_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxFullRefclkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxFullRefclkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX i_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxIBitInversion_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * LVDS TX i_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxIBitInversion_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX load_divider
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxLoadDivider_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * LVDS TX load_divider
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxLoadDivider_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxLongStrobe_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * LVDS TX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxLongStrobe_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxLsbFirst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS TX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxLsbFirst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX q_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxQBitInversion_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * LVDS TX q_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxQBitInversion_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX q_first
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxQFirst_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LVDS TX q_first
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxQFirst_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX rd_fifo_enable_delay
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxRdFifoEnableDelay_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * LVDS TX rd_fifo_enable_delay
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxRdFifoEnableDelay_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxRefclkEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxRefclkEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LVDS TX Strobe Align Error
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxStrobeAlignError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS TX strobe_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxStrobeBitInversion_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * LVDS TX strobe_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapTx_LssiTxStrobeBitInversion_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxdpIntfSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_LssiTxdpIntfSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Average To Peak Power Measurement Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAprEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcb), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Average To Peak Power Measurement Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAprEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * write pa_protection_power bitfield to update
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAveragePeakRatio_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * PA protection average power for readback.
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAveragePower_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Average Power Threshold
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgThreshold_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcd), (value >> 8), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xcc), (value >> 0));

    return status;
}

/**
 * PA Protection Average Power Threshold
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgThreshold_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcd), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xcc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Average Power Measurement/Protection Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgpowerEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xca), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Average Power Measurement/Protection Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgpowerEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xca), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * PA Protection Average Power Error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgpowerError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Clear Average power error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgpowerErrorClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Clear Average power error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgpowerErrorClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection avg power error clearing required
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgpowerErrorClearRequired_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xca), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * PA Protection avg power error clearing required
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvgpowerErrorClearRequired_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xca), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Average Power Measurement Duration
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvrgDur_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xca), (value >> 0), 0xf8, 0x3);

    return status;
}

/**
 * PA Protection Average Power Measurement Duration
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionAvrgDur_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xca), &register_value, 0xf8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * PA Protection Error Power
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionErrorPower_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Gain ramp Down Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionGainRampDownEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * PA Protection Gain ramp Down Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionGainRampDownEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) PA Protection Gain ramp Up Enable.This bit enables the automatic Tx attenuation control when a PA protection error clears. When set, upon clearing a PA error flag, the tx attenuation control block ramps up the gain. This applies to PLL events as well. Clearing this bit clears "state" information related to auto ramp up and ramp down mechanisms related to protection events.
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionGainRampUpEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) PA Protection Gain ramp Up Enable.This bit enables the automatic Tx attenuation control when a PA protection error clears. When set, upon clearing a PA error flag, the tx attenuation control block ramps up the gain. This applies to PLL events as well. Clearing this bit clears "state" information related to auto ramp up and ramp down mechanisms related to protection events.
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionGainRampUpEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Gain Step Down Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionGainStepDownEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * PA Protection Gain Step Down Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionGainStepDownEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Input Select
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionInputSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xca), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Input Select
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionInputSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xca), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Peak Count Causing PA Error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakCount_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcf), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * Peak Count Causing PA Error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakCount_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcf), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Peak Power Measurement Duration
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakDur_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcb), (value >> 0), 0xf8, 0x3);

    return status;
}

/**
 * PA Protection Peak Power Measurement Duration
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakDur_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcb), &register_value, 0xf8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakPower_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1cf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ce), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) PA Protection Peak Power Threshold
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakThreshold_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 8), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xce), (value >> 0));

    return status;
}

/**
 * (B0 New) PA Protection Peak Power Threshold
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakThreshold_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xce), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Peak Power Measurement/Protection Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakpowerEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Peak Power Measurement/Protection Enable
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakpowerEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * PA Protection Peak Power Error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakpowerError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Clear peak power error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakpowerErrorClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Clear peak power error
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakpowerErrorClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection peak power error clearing required
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakpowerErrorClearRequired_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * PA Protection peak power error clearing required
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionPeakpowerErrorClearRequired_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PA Protection Ramp Down In progress.PA protection Ramp down in progress
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampDownInProgress_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Ramp Max Attenuation
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampMaxAttenuation_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0xfe, 0x1);

    return status;
}

/**
 * PA Protection Ramp Max Attenuation
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampMaxAttenuation_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0xfe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Ramp Step duration
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampStepDuration_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * PA Protection Ramp Step duration
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampStepDuration_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Ramp Step Size
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampStepSize_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * PA Protection Ramp Step Size
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampStepSize_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PA Protection Ramp Up In progress.PA protection Ramp up in progress
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionRampUpInProgress_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * PA Protection Attenuation gain step
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionTxAttenStep_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0xfe, 0x1);

    return status;
}

/**
 * PA Protection Attenuation gain step
 */
static inline int32_t adrv9001_NvsRegmapTx_PaProtectionTxAttenStep_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0xfe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_PdIDist_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f3), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_PdIDist_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_Pdbias2bit04bit1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f3), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_Pdbias2bit04bit1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_Pdbias4bitCtrl_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_Pdbias4bitCtrl_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear sticky pll unlock event.self-cleared
 */
static inline int32_t adrv9001_NvsRegmapTx_PllProtClr_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Clear sticky pll unlock event.self-cleared
 */
static inline int32_t adrv9001_NvsRegmapTx_PllProtClr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear required for pll gain ramp down events.If pll_prot_clr_reqd is set, the "pll unlock event" will become sticky. When sticky, the ramp down will be in effect till pll_prot_clr is set.
 */
static inline int32_t adrv9001_NvsRegmapTx_PllProtClrReqd_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Clear required for pll gain ramp down events.If pll_prot_clr_reqd is set, the "pll unlock event" will become sticky. When sticky, the ramp down will be in effect till pll_prot_clr is set.
 */
static inline int32_t adrv9001_NvsRegmapTx_PllProtClrReqd_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) pll gain ramp down event active.This is the " pll unlock event". It becomes sticky if pll_prot_clr_reqd is set. The ramp down will be in effect till this bit/event is HIGH. When sticky, this bit can be cleared by writing 1 to pll_jesd_prot_clr bit.
 */
static inline int32_t adrv9001_NvsRegmapTx_PllProtEvent_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_PowerThreshold_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_PowerThreshold_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved0_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x132), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved0_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x132), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x133), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x133), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved3_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ac), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Reserved3_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ac), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_RxToTxDatapathLoopback_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_RxToTxDatapathLoopback_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare0_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b5), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare0_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b6), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare10_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1bf), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare10_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1bf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare11_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c0), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare11_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare12_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c1), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare12_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare13_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c2), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare13_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare14_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c3), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare14_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare15_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c4), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare15_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare16_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c5), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare16_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare17_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c6), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare17_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare18_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c7), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare18_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare19_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c8), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare19_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b7), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare3_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b8), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare3_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare4_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b9), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare4_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare5_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ba), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare5_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ba), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare6_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1bb), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare6_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1bb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare7_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1bc), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare7_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1bc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare8_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1bd), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare8_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1bd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare9_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1be), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SoftwareSpare9_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1be), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the slew rate limiter block for Tx1. When enabled, SRL adds three TIN clocks of latency to the path. All other settings can be adjusted before or simultaneously with enabling the SRL block.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x87), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit enables the slew rate limiter block for Tx1. When enabled, SRL adds three TIN clocks of latency to the path. All other settings can be adjusted before or simultaneously with enabling the SRL block.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x87), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Slew rate limiter IRQ status. 1 indicates that the slew rate limit has been tripped. sticky until srl_irq_en is cleared.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlIrq_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Slew rate limiter IRQ enable. 1: IRQ is enabled when SRL limit is tripped. 0: IRQ cleared (used for interrupt ack)
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlIrqEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x88), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Slew rate limiter IRQ enable. 1: IRQ is enabled when SRL limit is tripped. 0: IRQ cleared (used for interrupt ack)
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlIrqEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits se the offset (threshold) for the slew factor. (0 = straight table, 1 = 15/16 -- 1.0, 2 = 15/16 and 14/16 -- 1.0, etc.)
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlSlewOffset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x87), (value >> 0), 0x1e, 0x1);

    return status;
}

/**
 * These bits se the offset (threshold) for the slew factor. (0 = straight table, 1 = 15/16 -- 1.0, 2 = 15/16 and 14/16 -- 1.0, etc.)
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlSlewOffset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x87), &register_value, 0x1e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * slew rate limiter statistics readback register.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlStat_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Slew rate limiter statistics enable. 1: statistics are updated. 0: statistics gathering is disable and statistics are cleared.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlStatEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x88), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Slew rate limiter statistics enable. 1: statistics are updated. 0: statistics gathering is disable and statistics are cleared.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlStatEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Controls the statistics gathered by the slew rate limiter. 00 = Record the minimum slew factor observed. Range = 1-16. 16 indicates that no slew rate limiting has happened. 01 = Record the number of samples which have been slew rate limited. (Maximum = 65536 sample count.) 10, 11 = Clear statistics to zero.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlStatMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x88), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * Controls the statistics gathered by the slew rate limiter. 00 = Record the minimum slew factor observed. Range = 1-16. 16 indicates that no slew rate limiting has happened. 01 = Record the number of samples which have been slew rate limited. (Maximum = 65536 sample count.) 10, 11 = Clear statistics to zero.
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlStatMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits select one of four different slew limit tables for Tx2 according to the following settings. Table 3 (2'b11) limits slew the least, while table 0 (2'b00) limits slew the most. Slew Limit (as a % of full scale) 00 -- 10% 01 -- 20% 10 -- 30% 11 -- 50%
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlTableSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x87), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * These bits select one of four different slew limit tables for Tx2 according to the following settings. Table 3 (2'b11) limits slew the least, while table 0 (2'b00) limits slew the most. Slew Limit (as a % of full scale) 00 -- 10% 01 -- 20% 10 -- 30% 11 -- 50%
 */
static inline int32_t adrv9001_NvsRegmapTx_SrlTableSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x87), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SwStatus0_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x130), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SwStatus0_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x130), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SwStatus1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x131), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SwStatus1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x131), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SysArm0Enable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SysArm0Enable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SysArm1Enable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_SysArm1Enable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Attenuation index at which the ramp down concludes (for TDD mode of operation). Must be higher than current attenuation index.
 */
static inline int32_t adrv9001_NvsRegmapTx_TddRampMaxAttenIndex_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe9), (value >> 0));

    return status;
}

/**
 * Attenuation index at which the ramp down concludes (for TDD mode of operation). Must be higher than current attenuation index.
 */
static inline int32_t adrv9001_NvsRegmapTx_TddRampMaxAttenIndex_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Step size for TDD ramp  = (val+1)*0.5dB. Will not exceed 6dB.
 */
static inline int32_t adrv9001_NvsRegmapTx_TddRampStepSize_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe8), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Step size for TDD ramp  = (val+1)*0.5dB. Will not exceed 6dB.
 */
static inline int32_t adrv9001_NvsRegmapTx_TddRampStepSize_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Wait duration (in clock cycles) between consecutive steps in the TDD ramp. Zero is not valid.
 */
static inline int32_t adrv9001_NvsRegmapTx_TddRampWaitDurationBwSteps_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe8), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Wait duration (in clock cycles) between consecutive steps in the TDD ramp. Zero is not valid.
 */
static inline int32_t adrv9001_NvsRegmapTx_TddRampWaitDurationBwSteps_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Threshold_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a7), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_Threshold_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ThresholdShift_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_ThresholdShift_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Update DC offset (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TpnxxSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Update DC offset (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TpnxxSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits provide 10-bit control of a capacitor array that generates a passive pole in the Tx DAC image rejection filter. The final value of this setting is based on use cases that are determined after ADC tuning is complete.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfC1QecTrim_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb8), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb9), (value >> 0));

    return status;
}

/**
 * These bits provide 10-bit control of a capacitor array that generates a passive pole in the Tx DAC image rejection filter. The final value of this setting is based on use cases that are determined after ADC tuning is complete.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfC1QecTrim_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb8), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits provide 10-bit control of a capacitor array that generates a passive pole in the Tx DAC image rejection filter. The final value of this setting is based on use cases that are determined after ADC tuning is complete.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfC2QecTrim_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xba), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbb), (value >> 0));

    return status;
}

/**
 * These bits provide 10-bit control of a capacitor array that generates a passive pole in the Tx DAC image rejection filter. The final value of this setting is based on use cases that are determined after ADC tuning is complete.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfC2QecTrim_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xba), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit forces clocks on in the digital calibration block. This is necessary for manual tuning mode only. When clear, clocks are started automatically whenever the calibration is run.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfForceClockEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit forces clocks on in the digital calibration block. This is necessary for manual tuning mode only. When clear, clocks are started automatically whenever the calibration is run.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfForceClockEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register contains the attenuation for the I channel, used during the offset cal and FC cal steps.  It is also used for the Q channel during the offset cal steps. Resolution is 0.05dB steps. For example 120decimal = 6dB.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalAiFc_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa5), (value >> 0));

    return status;
}

/**
 * This register contains the attenuation for the I channel, used during the offset cal and FC cal steps.  It is also used for the Q channel during the offset cal steps. Resolution is 0.05dB steps. For example 120decimal = 6dB.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalAiFc_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register contains the attenuation for the I channel, used during the Q cal step. Resolution is0.05dB steps.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalAiQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa6), (value >> 0));

    return status;
}

/**
 * This register contains the attenuation for the I channel, used during the Q cal step. Resolution is0.05dB steps.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalAiQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Attenuation for Q channel for Fc and Q steps of cal in 0.05dB steps.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalAq_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa7), (value >> 0));

    return status;
}

/**
 * Attenuation for Q channel for Fc and Q steps of cal in 0.05dB steps.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalAq_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * C1 capacitor word for TXBBF
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalC1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb4), (value >> 2));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb5), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * C1 capacitor word for TXBBF
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalC1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb5), &register_value, 0x3, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set a limit for the maximum value of C2 during the calibration relative to C1. This prevents a calibration failure mode in which the calibration could converge to the wrong value for C2. Setting this register to the default value of 0x01 prevents this failure. The following settings are available: 00 --   C2   = C1 01 --   C2   = 1.25 X C1 10 --   C2   = 1.5 X C1 11 --   C2   = 2.0 X C1
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalC2Cutoff_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * These bits set a limit for the maximum value of C2 during the calibration relative to C1. This prevents a calibration failure mode in which the calibration could converge to the wrong value for C2. Setting this register to the default value of 0x01 prevents this failure. The following settings are available: 00 --   C2   = C1 01 --   C2   = 1.25 X C1 10 --   C2   = 1.5 X C1 11 --   C2   = 2.0 X C1
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalC2Cutoff_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it performs a calibration of Q during each calibration cycle. The first step (peak detector offset calibration), and second step (frequency calibration, which adjusts both C1 and C2) are always performed during each pass. The Q calibration adjusts C2 only, and happens as the third step.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalCalEnQCal_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set, it performs a calibration of Q during each calibration cycle. The first step (peak detector offset calibration), and second step (frequency calibration, which adjusts both C1 and C2) are always performed during each pass. The Q calibration adjusts C2 only, and happens as the third step.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalCalEnQCal_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Number of passes to perform during Fc and Q cal.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalCalMultpass_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * Number of passes to perform during Fc and Q cal.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalCalMultpass_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register contains the NCO frequency used for the high frequency tone in the Fc step. The frequency is determined using the equation Freq = N/512 *184.32MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFFc_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa8), (value >> 0));

    return status;
}

/**
 * This register contains the NCO frequency used for the high frequency tone in the Fc step. The frequency is determined using the equation Freq = N/512 *184.32MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFFc_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register contains the NCO low frequency used in all steps. The frequency is determined using the equation F= N/4096 * 184.32MHZ
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFLow_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa9), (value >> 0));

    return status;
}

/**
 * This register contains the NCO low frequency used in all steps. The frequency is determined using the equation F= N/4096 * 184.32MHZ
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFLow_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register contains the NCO frequency used for the high frequency tone in the Q step. The frequency is determined using the equation F=N/4096 * 184.32MHz.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 8), 0x70, 0x4);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xab), (value >> 0));

    return status;
}

/**
 * This register contains the NCO frequency used for the high frequency tone in the Q step. The frequency is determined using the equation F=N/4096 * 184.32MHz.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xab), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the amount of time allowed for the attenuation word to be returned and latched in the BBF according to the following settings. 000 -- >  1us, 001 -->   2us, 010 -->   4us, 011 -->   8us, 100 -- >  16us, 101 -->   32us, 110 --   64us, 111 -->   128us
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFiltertime_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * These bits set the amount of time allowed for the attenuation word to be returned and latched in the BBF according to the following settings. 000 -- >  1us, 001 -->   2us, 010 -->   4us, 011 -->   8us, 100 -- >  16us, 101 -->   32us, 110 --   64us, 111 -->   128us
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalFiltertime_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is clear, search offsets start large and progress to small when performing binary searches for both C and Qtrim. When this bit is set, search offsets progress from small to large to small. This often converges more quickly when running multiple pass calibrations.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalGentle_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * When this bit is clear, search offsets start large and progress to small when performing binary searches for both C and Qtrim. When this bit is set, search offsets progress from small to large to small. This often converges more quickly when running multiple pass calibrations.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalGentle_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the NCO override mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalNcoEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit enables the NCO override mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalNcoEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * I path frequency tuning word for TX NCO used in override mode when tx_abbf_freqcal_nco_enable =1. These are msbs of 32 bit word.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalNcoI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xae), (value >> 16), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xaf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb0), (value >> 0));

    return status;
}

/**
 * I path frequency tuning word for TX NCO used in override mode when tx_abbf_freqcal_nco_enable =1. These are msbs of 32 bit word.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalNcoI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xae), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xaf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Q path frequency tuning word for TX NCO during override mode when tx_abbf_freqcal_nco_enable=1.  These are the msbs of 32 bit word.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalNcoQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb1), (value >> 16), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb3), (value >> 0));

    return status;
}

/**
 * Q path frequency tuning word for TX NCO during override mode when tx_abbf_freqcal_nco_enable=1.  These are the msbs of 32 bit word.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalNcoQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb2), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Offset discovered offset during the pre-cal stage of the tuning.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalOffset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xad), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit sets the peak detector into forced power-up mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetForcePowerup_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * This bit sets the peak detector into forced power-up mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetForcePowerup_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is the Tx peak detector latch signal. It is only valid in pkdet override mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetLatch_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * This bit is the Tx peak detector latch signal. It is only valid in pkdet override mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetLatch_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This bit is the read-only Tx peak detector output.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetOut_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit sets the peak detector override mode. This allows direct SPI register control of the peak detector signals: reset, latch, and output.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetOverride_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit sets the peak detector override mode. This allows direct SPI register control of the peak detector signals: reset, latch, and output.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetOverride_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is the Tx peak detector reset signal. It forces a reset on the Tx1 peak detector when set, but only valid in pkdet override mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * This bit is the Tx peak detector reset signal. It forces a reset on the Tx1 peak detector when set, but only valid in pkdet override mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalPkdetReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the amount of time allowed for the NCO Settings to go through filters according to the following settings. 000 -->   1/8us, 001 -->   1/4us, 010 -->   1/2us, 011 -->   1us, 100 -- >  2us, 101 -->   4us, 110 -->   8us, 111 -- >  16us
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalResettime_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa4), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * These bits set the amount of time allowed for the NCO Settings to go through filters according to the following settings. 000 -->   1/8us, 001 -->   1/4us, 010 -->   1/2us, 011 -->   1us, 100 -- >  2us, 101 -->   4us, 110 -->   8us, 111 -- >  16us
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalResettime_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa4), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the amount of time allowed for the peak detector to make a measurement according to the following settings. 000 -->   1/8us, 001 -- >  1/4us, 010 -->   1/2us, 011 -->   1us, 100 -->   2us, 101 -->   4us, 110 -- >  8us, 111 -->   16us
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalSettletime_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * These bits set the amount of time allowed for the peak detector to make a measurement according to the following settings. 000 -->   1/8us, 001 -- >  1/4us, 010 -->   1/2us, 011 -->   1us, 100 -->   2us, 101 -->   4us, 110 -- >  8us, 111 -->   16us
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalSettletime_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These are added to make the C2 cap word to the TX BBF.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalTrimq_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb6), (value >> 2));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb7), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These are added to make the C2 cap word to the TX BBF.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfFreqcalTrimq_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb7), &register_value, 0x3, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfNco2UseIOut_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAbbfNco2UseIOut_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup10ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup10ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup11ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup11ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup1ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup1ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup2ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup2ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RSSI / Cross Correlator 1 (GLGC) group ==> 3'b000: 184MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup2ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9d), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * RSSI / Cross Correlator 1 (GLGC) group ==> 3'b000: 184MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup2ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup3ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup3ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * NCO1 / Phase Interp / PFIR24 / DPD cap / TX FIFOA / RXMagComp ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup3ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9d), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * NCO1 / Phase Interp / PFIR24 / DPD cap / TX FIFOA / RXMagComp ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup3ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9d), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup4ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup4ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX twinFIR / NCO 0 / Phase Interp / PFIR 24 / TXQEC/LOL Corr / TX FIFOB / TX twinFIR ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup4ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9e), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * RX twinFIR / NCO 0 / Phase Interp / PFIR 24 / TXQEC/LOL Corr / TX FIFOB / TX twinFIR ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup4ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup5ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup5ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * NCO1, NCO2 ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011:serial interface rate
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup5ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9e), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * NCO1, NCO2 ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011:serial interface rate
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup5ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9e), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup6ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup6ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup6ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9f), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup6ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9f), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup7ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup7ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Ch Est Pngen ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup7ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9f), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Ch Est Pngen ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup7ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9f), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup8ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup8ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DPD Act, Threshold Mon, PN Adder A ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup8ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa0), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * DPD Act, Threshold Mon, PN Adder A ==> 3'b000: 184.32MHz, 3'b001: 46.08MHz, 3'b010: 2.304MHz, 3'b011: 1.152MHz, 3'b100: 0.576MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup8ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa0), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup9ClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup9ClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TXLOL, TXQEC, PN Adder C ==> 2'b00: 184.32MHz, 2'b01: 46.08MHz, 2'b10<=>2'b11: 2.304MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup9ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa0), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * TXLOL, TXQEC, PN Adder C ==> 2'b00: 184.32MHz, 2'b01: 46.08MHz, 2'b10<=>2'b11: 2.304MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgGroup9ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa0), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: tx_lol_pn, 1: txchest_pn
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux401BSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 0: tx_lol_pn, 1: txchest_pn
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux401BSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402_out, 1: pn_adder_a_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux401CSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: mux_402_out, 1: pn_adder_a_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux401CSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: TC, 1: TA, 2: nbdpdi_0, 3: nbdpdi_0A, 4: nbdpdi_1, 5: nbdpdi_1A, 6: nbdpdi_2, others: 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux401Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * 0: TC, 1: TA, 2: nbdpdi_0, 3: nbdpdi_0A, 4: nbdpdi_1, 5: nbdpdi_1A, 6: nbdpdi_2, others: 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux401Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402A_TB2_out, 1: nbdpdi_0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402ANBDPDI0Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: mux_402A_TB2_out, 1: nbdpdi_0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402ANBDPDI0Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: 0, 1: TB2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402ATB2Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: 0, 1: TB2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402ATB2Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402B_TC_out, 1: TA
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402BTASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mux_402B_TC_out, 1: TA
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402BTASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402A_out, 1: TC
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402BTCSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 0: mux_402A_out, 1: TC
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402BTCSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402A_out, 1: pn_adder_c_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402CPNAdderCSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: mux_402A_out, 1: pn_adder_c_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402CPNAdderCSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402_from_401_out, 1: dpd_actuator_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402DpdActSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 0: mux_402_from_401_out, 1: dpd_actuator_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402DpdActSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: TF, 1: mux_401_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402From401Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: TF, 1: mux_401_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux402From401Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_403_out, 1: mag_comp_pfir13
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux403BMagCompfir13Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: mux_403_out, 1: mag_comp_pfir13
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux403BMagCompfir13Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402A_out, 1: mux_402C_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux403From402cSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: mux_402A_out, 1: mux_402C_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux403From402cSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_403_from_402C_out, 1: txdig_qec_data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux403TxlolQecSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mux_403_from_402C_out, 1: txdig_qec_data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux403TxlolQecSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: TB2, 1: TB4
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux404TB4Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 0: TB2, 1: TB4
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux404TB4Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_407_out, 1: twinfir_dout
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux405ASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: mux_407_out, 1: twinfir_dout
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux405ASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux406Nco2Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux406Nco2Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0:mux_407A_fifo_B_out, 1: txdig_qec_delay_fifo_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407AFifoASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0:mux_407A_fifo_B_out, 1: txdig_qec_delay_fifo_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407AFifoASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: txdig_qec_delay_fifo_C, 1: txdig_qec_delay_fifo_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407AFifoBSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: txdig_qec_delay_fifo_C, 1: txdig_qec_delay_fifo_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407AFifoBSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_407B_fifo_B_out, 1: txdig_qec_delay_fifo_A_MSB
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407BFifoASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mux_407B_fifo_B_out, 1: txdig_qec_delay_fifo_A_MSB
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407BFifoASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: txdig_qec_delay_fifo_C_MSB, 1: txdig_qec_delay_fifo_B_MSB
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407BFifoBSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 0: txdig_qec_delay_fifo_C_MSB, 1: txdig_qec_delay_fifo_B_MSB
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407BFifoBSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: txdig_qec_delay_fifo_A, 1: txdig_qec_delay_fifo_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407CFifoBSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: txdig_qec_delay_fifo_A, 1: txdig_qec_delay_fifo_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407CFifoBSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_402C_out, 1: TB4
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 0: mux_402C_out, 1: TB4
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux407Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_408A_nco_B_out, 1: nco_phase_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408ANcoASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: mux_408A_nco_B_out, 1: nco_phase_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408ANcoASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: nco_phase_C, 1: nco_phase_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408ANcoBSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: nco_phase_C, 1: nco_phase_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408ANcoBSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_408B_nco_B_out, 1: nco_phase_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408BNcoASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mux_408B_nco_B_out, 1: nco_phase_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408BNcoASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: nco_phase_C, 1: nco_phase_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408BNcoBSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 0: nco_phase_C, 1: nco_phase_B
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408BNcoBSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: nco_phase_B, 1: nco_phase_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408CNcoASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: nco_phase_B, 1: nco_phase_A
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux408CNcoASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: twin_fir_A, 1: RAR
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux409ASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 0: twin_fir_A, 1: RAR
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux409ASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mag_comp_fir13, 1: RAQ
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux409BSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: mag_comp_fir13, 1: RAQ
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux409BSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mag_comp_fir21, 1: TG
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux410BTGSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: mag_comp_fir21, 1: TG
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux410BTGSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_410B_out, 1: tx_atten_dp_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux410Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: mux_410B_out, 1: tx_atten_dp_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux410Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_410B_out, 1: tx_srl_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux411SrlSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mux_410B_out, 1: tx_srl_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux411SrlSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: tx_atten_dp_out, 1: tx_srl_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux412SrlSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 0: tx_atten_dp_out, 1: tx_srl_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux412SrlSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: tx_atten_dp_out, 1: mux_411_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux413Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: tx_atten_dp_out, 1: mux_411_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux413Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_412_out, 1: complex_gain_dout
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux414Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 0: mux_412_out, 1: complex_gain_dout
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux414Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: tx_atten_dp_out, 1: mux_410B_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux415From410BSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: tx_atten_dp_out, 1: mux_410B_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux415From410BSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_415_from_410B_out, 1: tx_srl_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux415SrlSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: mux_415_from_410B_out, 1: tx_srl_out
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux415SrlSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux416ASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux416ASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux416BSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux416BSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux417Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux417Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux418Sel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d4), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgMux418Sel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgObsTwinFirAClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgObsTwinFirAClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgObsTwinFirBClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgObsTwinFirBClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgRxmux301ObsSourceSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgRxmux301ObsSourceSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgRxmux302ObsSourceSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAlgRxmux302ObsSourceSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgTwinFirAClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgTwinFirAClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgTwinFirBClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAlgTwinFirBClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the step size for the SPI mode attenuation. 

 * 00 --  .05 dB steps

 * 01 --  .10 dB steps

 * 10 --  .20 dB steps

 * 11 --  .40 dB steps
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenConfig_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * These bits set the step size for the SPI mode attenuation. 

 * 00 --  .05 dB steps

 * 01 --  .10 dB steps

 * 10 --  .20 dB steps

 * 11 --  .40 dB steps
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenConfig_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * These bits provide the Tx digital attenuation value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenDigitalRead_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) tx_atten SRAM ECC error address
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenEccErrAddr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d1), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) write to 1 clear the ECC error flag, error address, self-cleared.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenEccErrClr_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) write to 1 clear the ECC error flag, error address, self-cleared.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenEccErrClr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) tx_atten SRAM ECC error flag
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenEccErrFlag_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: interrupt for uncorrectable error  1: interrupt for both correctable and uncorrectable error
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenEccErrIrqSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: interrupt for uncorrectable error  1: interrupt for both correctable and uncorrectable error
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenEccErrIrqSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select whether to force on/off delaying of the analog gain change to match the latency of digital gain changes
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceAnalogDelays_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdb), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Select whether to force on/off delaying of the analog gain change to match the latency of digital gain changes
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceAnalogDelays_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdb), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Value ignored unless force_analog_delays is 1. 1 for forcing off the delay, 0 for forcing on the delay. If not forcing, the delays will be turned off automatically when constant step mode is enabled, when table 1 is selected, or when ramping up and down for TDD.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceAnalogDelaysOffNotOn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdb), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Value ignored unless force_analog_delays is 1. 1 for forcing off the delay, 0 for forcing on the delay. If not forcing, the delays will be turned off automatically when constant step mode is enabled, when table 1 is selected, or when ramping up and down for TDD.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceAnalogDelaysOffNotOn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdb), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Forced digital attenuation value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceDigital_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe2), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * Forced digital attenuation value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceDigital_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe2), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Forced analog HP attenuation Value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceHp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe3), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Forced analog HP attenuation Value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenForceHp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe3), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Assert HP latch enable
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenHpLatenOverride_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Assert HP latch enable
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenHpLatenOverride_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Tx analog attenuation HP readback
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenHpRead_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xef), &register_value, 0xfc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Reference HP gain value for TXQEC. LOL updates after a gain change
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenHpRef_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xec), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Reference HP gain value for TXQEC. LOL updates after a gain change
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenHpRef_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xec), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits are used to set the TPC mode according to the following settings: 

 * 00 --  Bypass: zero total attenuation 

 * 01 --  SPI: 10-bit attenuation index used to determine total attenuation 

 * 10 --  SPI Direct: attenuation values are set manually 

 * 11 --  Incr/Decr: total attenuation is altered incrementally using pin control
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits are used to set the TPC mode according to the following settings: 

 * 00 --  Bypass: zero total attenuation 

 * 01 --  SPI: 10-bit attenuation index used to determine total attenuation 

 * 10 --  SPI Direct: attenuation values are set manually 

 * 11 --  Incr/Decr: total attenuation is altered incrementally using pin control
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register specifies an offset to the Tx attenuation words

 * when the TPC mode is set to SPI mode. The resolution is 0.4 dB steps.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenOffset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe1), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * This register specifies an offset to the Tx attenuation words

 * when the TPC mode is set to SPI mode. The resolution is 0.4 dB steps.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenOffset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe1), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable hardware updates of txqec, LOL correction registers
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenQeclolUpdEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdb), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable hardware updates of txqec, LOL correction registers
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenQeclolUpdEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdb), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Disable SRAM ECC correction
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenTableEccDisable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Disable SRAM ECC correction
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenTableEccDisable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAttenTableRf1PllLockMask_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAttenTableRf1PllLockMask_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAttenTableRf2PllLockMask_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxAttenTableRf2PllLockMask_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the value of Tx1 10bit digital attenuation word when in SPI mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuation_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xde), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdd), (value >> 0));

    return status;
}

/**
 * These bits set the value of Tx1 10bit digital attenuation word when in SPI mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuation_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xde), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdd), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the value of Tx1 10bit digital attenuation word when in SPI mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe0), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdf), (value >> 0));

    return status;
}

/**
 * These bits set the value of Tx1 10bit digital attenuation word when in SPI mode.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe0), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) These bits specify the cycle delay (at the Tx input rate) for a decrease in digital attenuation. The value should be set such that the digital gain change happens in close succession to any change in analog gain, which should still be allowed to happen first.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationEarlyDelayCounterForAnalog_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xea), (value >> 0));

    return status;
}

/**
 * (B0 New) These bits specify the cycle delay (at the Tx input rate) for a decrease in digital attenuation. The value should be set such that the digital gain change happens in close succession to any change in analog gain, which should still be allowed to happen first.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationEarlyDelayCounterForAnalog_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xea), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) These bits specify the cycle delay for an analog gain increase. The value should be set large enough such that a simultaneous digital attenuation change is allowed to happen first.At the clktin rate. Digital gain change always happens instantaneously in TX datapath. Digital gain has to propagate through TX filters before reaching analog. This delay is applied to analog gain increment. This should be programmed such that, analog gain increment is applied LATER than any digital gain decrement, preventing gain overshoots.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationLateDelayCounterForAnalog_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xeb), (value >> 0));

    return status;
}

/**
 * (B0 New) These bits specify the cycle delay for an analog gain increase. The value should be set large enough such that a simultaneous digital attenuation change is allowed to happen first.At the clktin rate. Digital gain change always happens instantaneously in TX datapath. Digital gain has to propagate through TX filters before reaching analog. This delay is applied to analog gain increment. This should be programmed such that, analog gain increment is applied LATER than any digital gain decrement, preventing gain overshoots.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationLateDelayCounterForAnalog_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xeb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Tx digital attenuation index readback
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationRead_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xef), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xee), (value >> 0));

    return status;
}

/**
 * Tx digital attenuation index readback
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationRead_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xef), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xee), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationTableGainFifoReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ee), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationTableGainFifoReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ee), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationTableReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ee), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxAttenuationTableReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ee), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit starts the TX baseband filter tuner calibration. The bit self-clears when the calibration completes.

 *  Tx Bbf Tuner Cal Start
 */
static inline int32_t adrv9001_NvsRegmapTx_TxBbfTunerCalStart_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit starts the TX baseband filter tuner calibration. The bit self-clears when the calibration completes.

 *  Tx Bbf Tuner Cal Start
 */
static inline int32_t adrv9001_NvsRegmapTx_TxBbfTunerCalStart_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b0: bypass   1’b1: select calibration input
 */
static inline int32_t adrv9001_NvsRegmapTx_TxCalMuxSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 1’b0: bypass   1’b1: select calibration input
 */
static inline int32_t adrv9001_NvsRegmapTx_TxCalMuxSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) tx_clkgen_cssi_div_value (Extended to 16 bits)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxClkgenCssiDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x19), (value >> 0));

    return status;
}

/**
 * (B0 New) tx_clkgen_cssi_div_value (Extended to 16 bits)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxClkgenCssiDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxClkgenCssiLoadDivider_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapTx_TxClkgenCssiLoadDivider_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_cssi_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxCssiEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * tx_cssi_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxCssiEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDacOutIZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDacOutIZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDacOutQZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDacOutQZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDataRampDownOnPllUnlock_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDataRampDownOnPllUnlock_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDatapathIInputZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDatapathIInputZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 => Both: I and Q clocks for TX datapath are running; 1 => Only I clocks for TX datapath are running
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDatapathIOnlyEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0 => Both: I and Q clocks for TX datapath are running; 1 => Only I clocks for TX datapath are running
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDatapathIOnlyEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDatapathQInputZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDatapathQInputZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: bypass TXATTEN, 1'b1: enable TXATTEN data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpAttenSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: bypass TXATTEN, 1'b1: enable TXATTEN data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpAttenSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_dp_freq_dev_mapper_47_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpFreqDevMapper47En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * tx_dp_freq_dev_mapper_47_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpFreqDevMapper47En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) TX/OTX1/OTX2/OTX3 profiles DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) TX/OTX1/OTX2/OTX3 profiles DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX DP Global Reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * TX DP Global Reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 12, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt212En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable TX DP filter 12, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt212En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 14, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt214En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2b), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable TX DP filter 14, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt214En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 16, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt216En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2b), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable TX DP filter 16, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt216En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 18, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt218En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable TX DP filter 18, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt218En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 20, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt220En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable TX DP filter 20, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt220En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 22.1, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt2221En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable TX DP filter 22.1, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt2221En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 22, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt222En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable TX DP filter 22, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt222En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 24, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt224En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable TX DP filter 24, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt224En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 26, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt226En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable TX DP filter 26, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt226En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 28, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt228En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable TX DP filter 28, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt228En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 30, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt230En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable TX DP filter 30, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt230En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 36, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt236En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable TX DP filter 36, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt236En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 38, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt238En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable TX DP filter 38, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt238En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 8, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt28En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable TX DP filter 8, interpolation by 2
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt28En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 10, interpolation by 3
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt310En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2b), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable TX DP filter 10, interpolation by 3
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt310En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 40, interpolation by 3, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt340En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable TX DP filter 40, interpolation by 3, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt340En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP filter 44.1, interpolation by 3, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt3441En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable TX DP filter 44.1, interpolation by 3, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpInt3441En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: bypassed, 1: Divider 1/N selected
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpModemMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 0: bypassed, 1: Divider 1/N selected
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpModemMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_dp_modem_mode_div_value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpModemModeDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x30), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x31), (value >> 0));

    return status;
}

/**
 * tx_dp_modem_mode_div_value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpModemModeDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x30), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x31), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable DPD in TX narrow band datapath point 0, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNbdpd0En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x52), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable DPD in TX narrow band datapath point 0, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNbdpd0En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x52), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable DPD in TX narrow band datapath point 1, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNbdpd1En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x52), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable DPD in TX narrow band datapath point 1, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNbdpd1En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x52), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable DPD in TX narrow band datapath point 2, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNbdpd2En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x52), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable DPD in TX narrow band datapath point 2, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNbdpd2En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x52), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Tx datapath Channel - This sets a fixed phase offset for the NCO
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNcoAttenPhaseOffset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf7), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf8), (value >> 0));

    return status;
}

/**
 * Tx datapath Channel - This sets a fixed phase offset for the NCO
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpNcoAttenPhaseOffset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf7), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP SINC2 filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpSinc242En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable TX DP SINC2 filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpSinc242En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpSinc344En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable TX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpSinc344En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpSpectralInvertI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpSpectralInvertI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpSpectralInvertQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpSpectralInvertQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * TXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX DP tpfir_i_3 Reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTpfirI3Reset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * TX DP tpfir_i_3 Reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTpfirI3Reset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX DP tpfir_q_5 Reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTpfirQ5Reset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * TX DP tpfir_q_5 Reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTpfirQ5Reset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX DP SCIC interpolation factor, set between 1~9, the real interpolation factor is 2~10(tx_dp_tscic_32_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2f), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * TX DP SCIC interpolation factor, set between 1~9, the real interpolation factor is 2~10(tx_dp_tscic_32_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP SCIC filter 32
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable TX DP SCIC filter 32
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) TX SCIC 32 reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32Reset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) TX SCIC 32 reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32Reset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * For debug purpose. default is ZERO
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32RippleSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * For debug purpose. default is ZERO
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTscic32RippleSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * symbol mapping divider factor, supports 1,2,3,4,5,19,16,20
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxPreproc2DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x33), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * symbol mapping divider factor, supports 1,2,3,4,5,19,16,20
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxPreproc2DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x33), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX DP pre-process block enable signal
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxPreproc2En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * TX DP pre-process block enable signal
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxPreproc2En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX DP tx round block
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxRound46En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable TX DP tx round block
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxRound46En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpTxqec34ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x54), (value >> 0), 0xe, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpTxqec34ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x54), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_dp_txqec_34_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxqec34En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx_dp_txqec_34_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpTxqec34En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable DPD in TX wide band datapath point 0, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpWbdpd0En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable DPD in TX wide band datapath point 0, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpWbdpd0En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable DPD in TX wide band datapath point 1, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpWbdpd1En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable DPD in TX wide band datapath point 1, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpWbdpd1En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable DPD in TX wide band datapath point 2, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpWbdpd2En_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable DPD in TX wide band datapath point 2, default 0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpWbdpd2En_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdDataCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdDataCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam0ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam0ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam1ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam1ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam2ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19e), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam2ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam3ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19e), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam3ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam4ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19e), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam4ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam5ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam5ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam6ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam6ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam7ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam7ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam8ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d3), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxDpdIslandRam8ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: selects dpd sampling clock, 1: selects ARM clock
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpdRamClkSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x99), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: selects dpd sampling clock, 1: selects ARM clock
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDpdRamClkSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x99), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DUC enable bit.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * DUC enable bit.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * NCO FTW when DUC mode is enabled.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucFtw_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x64), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x65), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x66), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x67), (value >> 0));

    return status;
}

/**
 * NCO FTW when DUC mode is enabled.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucFtw_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x64), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x65), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x66), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x67), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * NCO phase offset value.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucFtwOffset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x68), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x69), (value >> 0));

    return status;
}

/**
 * NCO phase offset value.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucFtwOffset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x68), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x69), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Update signal when FTW is configured.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucFtwUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Update signal when FTW is configured.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxDucFtwUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * frequency fraction multiplier
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperMPLL_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x41), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x42), (value >> 0));

    return status;
}

/**
 * frequency fraction multiplier
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperMPLL_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x41), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x42), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * frequency offset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperNch_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint64_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 32), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3c), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3f), (value >> 0));

    return status;
}

/**
 * frequency offset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperNch_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * frequency deviation
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperRrc2fracDevFac_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x38), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x39), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3a), (value >> 0));

    return status;
}

/**
 * frequency deviation
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperRrc2fracDevFac_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x38), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x39), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * threshold value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperThreshold_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x82), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x81), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x80), (value >> 0));

    return status;
}

/**
 * threshold value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxFreqDevMapperThreshold_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x82), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x81), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x80), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxFuseTxSLREnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x89), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxFuseTxSLREnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x89), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) indicates overflow on tx gain change fifo, It is write 1 to clear
 */
static inline int32_t adrv9001_NvsRegmapTx_TxGainChangeFifoOverflow_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) indicates overflow on tx gain change fifo, It is write 1 to clear
 */
static inline int32_t adrv9001_NvsRegmapTx_TxGainChangeFifoOverflow_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxGdcalPreSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5b), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxGdcalPreSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the change in Tx attenuation for each increment or decrement signal received in incr/decr mode. The resolution is 0.05 dB.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIncrDecrWord_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe4), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * These bits set the change in Tx attenuation for each increment or decrement signal received in incr/decr mode. The resolution is 0.05 dB.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIncrDecrWord_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe4), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * IQDM enable bit.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * IQDM enable bit.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * IQDM frequency deviation factor
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmFreqDev_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5f), (value >> 0));

    return status;
}

/**
 * IQDM frequency deviation factor
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmFreqDev_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * IQDM frequency offset value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmFreqOffset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x60), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x61), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x62), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x63), (value >> 0));

    return status;
}

/**
 * IQDM frequency offset value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmFreqOffset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x60), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x61), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x62), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x63), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * multi-chip sync SPI bit
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmNcoMultiChipSynced_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * multi-chip sync SPI bit
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmNcoMultiChipSynced_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * IQDM gain value.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmScaler_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6b), (value >> 0));

    return status;
}

/**
 * IQDM gain value.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmScaler_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * IQDM threshold value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmThreshold_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x85), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x84), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x83), (value >> 0));

    return status;
}

/**
 * IQDM threshold value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxIqdmThreshold_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x85), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x84), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x83), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc1), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc1), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrIB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrIB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc1), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc1), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrQB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCoarseCorrQB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCorrDac_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ab), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1aa), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayCorrDac_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ab), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1aa), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the Tx LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx Lo Delay Corr Dac
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayFineCorrDac_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbe), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Setting this bit powers down the Tx LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx Lo Delay Corr Dac
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayFineCorrDac_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x7, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the Tx LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx Lo Delay Corr Dac
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayFineCorrDacB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc0), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbf), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Setting this bit powers down the Tx LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx Lo Delay Corr Dac
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayFineCorrDacB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbf), &register_value, 0x7, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Toggling this bit latches the Tx LO delay correction DAC word.

 *  Tx Lo  Delay Latch En
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayLatchEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Toggling this bit latches the Tx LO delay correction DAC word.

 *  Tx Lo  Delay Latch En
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLoDelayLatchEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit resets the LOL module.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLolReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit resets the LOL module.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLolReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit selects the LOL module registers for read/write operations. Clearing this bit selects the TxQEC module registers.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLolSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Setting this bit selects the LOL module registers for read/write operations. Clearing this bit selects the TxQEC module registers.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLolSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_lssi_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLssiEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx_lssi_en
 */
static inline int32_t adrv9001_NvsRegmapTx_TxLssiEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_nco_ftw
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoFtw_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x55), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x56), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x57), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x58), (value >> 0));

    return status;
}

/**
 * tx_nco_ftw
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoFtw_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x55), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x56), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x57), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x58), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxNcoFtwUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5a), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxNcoFtwUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_nco_mcs_adj_amp
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoMcsAdjAmp_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x59), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * tx_nco_mcs_adj_amp
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoMcsAdjAmp_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x59), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_nco_mcs_adj_amp
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoMcsAdjAmp1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5b), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * tx_nco_mcs_adj_amp
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoMcsAdjAmp1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_nco_mcs_adj_amp
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoMcsAdjAmp2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5b), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * tx_nco_mcs_adj_amp
 */
static inline int32_t adrv9001_NvsRegmapTx_TxNcoMcsAdjAmp2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5b), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxOn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxOn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This is a self clear bit. This is to be used in conjunction with "pa_protection_error_clear_required" register. See that register for more details.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPaProtectionErrorClear_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This is a self clear bit. This is to be used in conjunction with "pa_protection_error_clear_required" register. See that register for more details.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPaProtectionErrorClear_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x37), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x37), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_pfir_4x_div_value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x35), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x36), (value >> 0));

    return status;
}

/**
 * tx_pfir_4x_div_value
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x35), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x36), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxPfirI3DontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxPfirI3DontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX PFIR_I
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfirIEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable TX PFIR_I
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfirIEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxPfirQ5DontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxPfirQ5DontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable TX PFIR_Q
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfirQEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable TX PFIR_Q
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPfirQEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select signal for the MUX. 1: select TXPFIR_I data,  0: select TX pulse shaping Q data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocMuxSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Select signal for the MUX. 1: select TXPFIR_I data,  0: select TX pulse shaping Q data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocMuxSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 00: I+Q out  01: I out only (for SRRC1),  10: I out only (for RRC2+InvSinc); 11: I out only(for HCPM)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocOutSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * 00: I+Q out  01: I out only (for SRRC1),  10: I out only (for RRC2+InvSinc); 11: I out only(for HCPM)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocOutSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * symbol 00 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym0_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x43), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x44), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x45), (value >> 0));

    return status;
}

/**
 * symbol 00 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym0_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x43), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x44), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x45), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * symbol 01 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x46), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x47), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x48), (value >> 0));

    return status;
}

/**
 * symbol 01 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x46), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x47), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x48), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * symbol 10 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x49), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4b), (value >> 0));

    return status;
}

/**
 * symbol 10 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x49), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * symbol 11 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym3_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4c), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4e), (value >> 0));

    return status;
}

/**
 * symbol 11 mapping result
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPreprocSym3_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) TX profiles DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) TX profiles DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) TX profiles CSSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) TX profiles CSSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapTx_TxProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Insert ZERO or repeat data for the pulse shaping.  0: insert ZERO; 1: repeat data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPulseShapingMode_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Insert ZERO or repeat data for the pulse shaping.  0: insert ZERO; 1: repeat data
 */
static inline int32_t adrv9001_NvsRegmapTx_TxPulseShapingMode_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: SSI clocks are gated by all_tx_enable, 1: SSI clocks are free running
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiFreeRunningClkEn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ef), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: SSI clocks are gated by all_tx_enable, 1: SSI clocks are free running
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiFreeRunningClkEn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ef), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Global reset for SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Global reset for SSI interface
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiIInvert_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiIInvert_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiISwap_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiISwap_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiQInvert_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiQInvert_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiQSwap_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxSsiQSwap_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxattenMultiplierI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8c), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8d), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxattenMultiplierI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxattenMultiplierQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8e), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxattenMultiplierQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxattenMultiplierSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x90), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxattenMultiplierSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x90), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_bypass_pn
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestBypassPn_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx_txchest_bypass_pn
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestBypassPn_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_enable_a
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestEnableA_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx_txchest_enable_a
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestEnableA_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_enable_b
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestEnableB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * tx_txchest_enable_b
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestEnableB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_pn_length
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPnLength_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x79), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7c), (value >> 0));

    return status;
}

/**
 * tx_txchest_pn_length
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPnLength_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x79), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_pn_repeat
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPnRepeat_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7e), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7f), (value >> 0));

    return status;
}

/**
 * tx_txchest_pn_repeat
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPnRepeat_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_pn_taps_i
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPnTapsI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x75), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x76), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x77), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x78), (value >> 0));

    return status;
}

/**
 * tx_txchest_pn_taps_i
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPnTapsI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x75), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x76), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x77), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x78), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_pos_val_i
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPosValI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6f), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x70), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x71), (value >> 0));

    return status;
}

/**
 * tx_txchest_pos_val_i
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPosValI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6f), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x70), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x71), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_pos_val_q
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPosValQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x72), (value >> 16), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x73), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x74), (value >> 0));

    return status;
}

/**
 * tx_txchest_pos_val_q
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestPosValQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x72), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x73), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x74), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_prog_dly
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestProgDly_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7d), (value >> 0));

    return status;
}

/**
 * tx_txchest_prog_dly
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestProgDly_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx_txchest_sel_pn_not0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestSelPnNot0_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx_txchest_sel_pn_not0
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxchestSelPnNot0_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This read-only bit goes high when an overrange occurs on the Rx1 QEC. The bit is cleared when this address is read.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxdigQecError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: use the scaler, 1: bypass the scaler
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorBypassScaler_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: use the scaler, 1: bypass the scaler
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorBypassScaler_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorError_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1db), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1da), (value >> 0));

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1db), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1da), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetIB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1dd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1dc), (value >> 0));

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetIB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1dd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1dc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1df), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1de), (value >> 0));

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1df), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1de), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetQB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e0), (value >> 0));

    return status;
}

/**
 * (B0 New) DC Offset for txlol datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetQB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Update DC offset (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Update DC offset (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorFilterDcOffsetUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0 : use the new scheme, 1: use the old scheme for DC offset correction
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorOldSettingSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0 : use the new scheme, 1: use the old scheme for DC offset correction
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorOldSettingSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorScaler_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d8), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorScaler_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorScalerB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d9), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorScalerB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorScalerUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxlolActuatorScalerUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Reserved for future use.

 *  Txqec Control
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecControl_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd), (value >> 22));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc), (value >> 14));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb), (value >> 6));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0xfc, 0x2);

    return status;
}

/**
 * Reserved for future use.

 *  Txqec Control
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecControl_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0xfc, 0x2);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterChPerterbUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1eb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterChPerterbUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1eb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterChScalerUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterChScalerUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI0_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x104), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI0_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x104), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI0B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x121), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x120), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI0B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x121), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x120), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x107), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x106), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x107), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x106), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI1B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x123), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x122), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI1B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x123), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x122), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x108), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x108), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI2B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x125), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x124), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI2B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x125), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x124), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI3_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10a), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10b), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI3_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10a), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI3B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x127), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x126), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI3B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x127), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x126), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI4_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10d), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10c), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI4_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10d), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI4B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x129), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x128), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffI4B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x129), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x128), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ0_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfa), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ0_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfa), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ0B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x117), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x116), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ0B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x117), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x116), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ1_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfc), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ1_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ1B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x119), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x118), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ1B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x119), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x118), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ2_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xff), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfe), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ2_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xff), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ2B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11a), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ2B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ3_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x101), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x100), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ3_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x101), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x100), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ3B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11c), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ3B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ4_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x103), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x102), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ4_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x103), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x102), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ4B_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11e), (value >> 0));

    return status;
}

/**
 * Coefficient for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffQ4B_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Update all coefficients at once (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Update all coefficients at once (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterCoeffUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Update DC offset (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterDcOffsetUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Update DC offset (self clear)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterDcOffsetUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10e), (value >> 0));

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetIB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x113), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x112), (value >> 0));

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetIB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x113), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x112), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x111), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x110), (value >> 0));

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x111), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x110), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetQB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x115), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x114), (value >> 0));

    return status;
}

/**
 * DC Offset for txqec datapath filter
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterOffsetQB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x115), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x114), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbI_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e3), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbI_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbIB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e5), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbIB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbQ_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e8), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e7), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbQ_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbQB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ea), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e9), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterPerterbQB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ea), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) default value changed
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterScaler_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf), (value >> 0));

    return status;
}

/**
 * (B0 New) default value changed
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterScaler_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) default value changed
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterScalerB_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ed), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ec), (value >> 0));

    return status;
}

/**
 * (B0 New) default value changed
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecFilterScalerB_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ed), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ec), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TXQEC Indirect address register.  This register may be used to address the correlator results and other TXQEC registers from the SPI bus.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecIaddr_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8), (value >> 0));

    return status;
}

/**
 * TXQEC Indirect address register.  This register may be used to address the correlator results and other TXQEC registers from the SPI bus.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecIaddr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * TXQEC Indirect data register.  This register may be used to read the correlator results and other TXQEC registers from the SPI bus.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecRdata_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit performs a register read of the address selected in txqec_iaddr and puts the data in registers txqec_rdata.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecRead_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit performs a register read of the address selected in txqec_iaddr and puts the data in registers txqec_rdata.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecRead_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit resets the Tx QEC module.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecReset_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit resets the Tx QEC module.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecReset_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TXQEC Indirect data register.  This register may be used to read the correlator results and other TXQEC registers from the SPI bus.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecWdata_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4), (value >> 0));

    return status;
}

/**
 * TXQEC Indirect data register.  This register may be used to read the correlator results and other TXQEC registers from the SPI bus.
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecWdata_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit performs a register write of data in txqec_iaddr to the address selected in txqec_wdata.

 *  Txqec Write
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecWrite_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Setting this bit performs a register write of data in txqec_iaddr to the address selected in txqec_wdata.

 *  Txqec Write
 */
static inline int32_t adrv9001_NvsRegmapTx_TxTxqecWrite_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxattenDpathUpdate_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxattenDpathUpdate_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTx_TxchestPnadderAErr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxchestPnadderASel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxchestPnadderASel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapTx_TxchestPnadderCErr_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxchestPnadderCSel_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a9), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxchestPnadderCSel_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxqecLolDataCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12d), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapTx_TxqecLolDataCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapTx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_TX_H__