/**
 * \file
 * \brief BitField accessors for nvs_regmap_rxb
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_RXB_H__
 #define __ADRV9001_BF_NVS_REGMAP_RXB_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfNvsRegmapRxb_e
{
    ADRV9001_BF_RXB1_CORE    =   0x1000,
    ADRV9001_BF_RXB2_CORE    =   0x1400
} adrv9001_BfNvsRegmapRxb_e;

static const adrv9001_BfNvsRegmapRxb_e nvsRegmapRxbInstances[] = {
    ADRV9001_BF_RXB1_CORE,
    ADRV9001_BF_RXB2_CORE
};


/**
 * TIA control readback for Ch1. Bit[0] is TIA gain and bit [1] is ADC gain.

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AdcControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x30), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This setting overrides the delayed update feature for setting Rx1 ADC gain. Setting this field allows new values of Rx1 ADC gains to be effective as soon as they are output from the gain table. This setting may cause spurious overloads on the ADC until gains to all block before the ADC (Rx1 FE, Rx1 TIA) have settled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AdcValidOverride_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * This setting overrides the delayed update feature for setting Rx1 ADC gain. Setting this field allows new values of Rx1 ADC gains to be effective as soon as they are output from the gain table. This setting may cause spurious overloads on the ADC until gains to all block before the ADC (Rx1 FE, Rx1 TIA) have settled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AdcValidOverride_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_Adcovrg2ndHighCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x90), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_Adcovrg2ndHighCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x90), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of times the ADC High Overrange threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the ADC high overrange threshold is triggered N times where N is the value configured in this register, a gain change can either occur immediately (agc_change_gain_if_adcovrg_high) or when the agc_gain_update_counter expires or in hybrid mode when a pulse is seen on the corresponding GPIO pin.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcHighOvrgExceededCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x64), (value >> 0));

    return status;
}

/**
 * This counter configures the number of times the ADC High Overrange threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the ADC high overrange threshold is triggered N times where N is the value configured in this register, a gain change can either occur immediately (agc_change_gain_if_adcovrg_high) or when the agc_gain_update_counter expires or in hybrid mode when a pulse is seen on the corresponding GPIO pin.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcHighOvrgExceededCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x64), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register can take any value from 1 through 255. If the ADC Low Overrange threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on ADC low overrange trigger. Consequently, at the termination of the agc_gain_update_counter, or in hybrid mode when a pulse is seen on the corresponding GPIO pin, if a gain increment is slated to occur based on power thresholds, and if agc_low_ths_prevent_gain_inc is 1, then the gain increment does not occur. If agc_peak_threshold_gain_control_mode is enabled and the flag is NOT set, the gain will increment.

 * When in multiple time constants in AGC loop mode, the flag is used to determine gain increments for the 3rd update interval. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcLowOvrgExceededCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x65), (value >> 0));

    return status;
}

/**
 * This register can take any value from 1 through 255. If the ADC Low Overrange threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on ADC low overrange trigger. Consequently, at the termination of the agc_gain_update_counter, or in hybrid mode when a pulse is seen on the corresponding GPIO pin, if a gain increment is slated to occur based on power thresholds, and if agc_low_ths_prevent_gain_inc is 1, then the gain increment does not occur. If agc_peak_threshold_gain_control_mode is enabled and the flag is NOT set, the gain will increment.

 * When in multiple time constants in AGC loop mode, the flag is used to determine gain increments for the 3rd update interval. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcLowOvrgExceededCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x65), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of gain steps to adjust agc_gain_index by a ADC Overload Reset condition.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcResetGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1bf), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (B0 New) Number of gain steps to adjust agc_gain_index by a ADC Overload Reset condition.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcResetGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1bf), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of times the ADC IP3 Overrange threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the ADC high overrange threshold is triggered N times where N is the value configured in this register, and agc_enable_ip3_optimization_threshold is enabled, a gain change occurs immediately based on the current gain index and the agc_optimal_ip3_index. See description for agc_enable_ip3_optimization_threshold regarding the Two-threshold AGC loop mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcovrgIp3HighCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7e), (value >> 0));

    return status;
}

/**
 * This counter configures the number of times the ADC IP3 Overrange threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the ADC high overrange threshold is triggered N times where N is the value configured in this register, and agc_enable_ip3_optimization_threshold is enabled, a gain change occurs immediately based on the current gain index and the agc_optimal_ip3_index. See description for agc_enable_ip3_optimization_threshold regarding the Two-threshold AGC loop mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcovrgIp3HighCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register can take any value from 1 through 255. If the ADC Low Overrange interval 0 threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on ADC low overrange interval 0 trigger. This flag is used to determine gain increments for the 1st update interval in multiple time constants in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcovrgLowInt0Counter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7f), (value >> 0));

    return status;
}

/**
 * This register can take any value from 1 through 255. If the ADC Low Overrange interval 0 threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on ADC low overrange interval 0 trigger. This flag is used to determine gain increments for the 1st update interval in multiple time constants in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcovrgLowInt0Counter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register can take any value from 1 through 255. If the ADC Low Overrange interval 1 threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on ADC low overrange interval 1 trigger. This flag is used to determine gain increments for the 2nd update interval in multiple time constants in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcovrgLowInt1Counter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x80), (value >> 0));

    return status;
}

/**
 * This register can take any value from 1 through 255. If the ADC Low Overrange interval 1 threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on ADC low overrange interval 1 trigger. This flag is used to determine gain increments for the 2nd update interval in multiple time constants in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAdcovrgLowInt1Counter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x80), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcApdLowFreqErrorMitigationMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x83), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcApdLowFreqErrorMitigationMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x83), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register is applicable to all the automatic gain control modes (AGC fast attack, AGC slow loop and AGC Hybrid mode). When this register is set to a non-zero value, the Rx1 AGC state machine is not enabled as soon as RXON goes high. The AGC state machine is held inactive for the duration of the value in this register. Each LSB in this register corresponds to a delay of 1s (determined by reference_clock_cycles).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAttackDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x50), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * This register is applicable to all the automatic gain control modes (AGC fast attack, AGC slow loop and AGC Hybrid mode). When this register is set to a non-zero value, the Rx1 AGC state machine is not enabled as soon as RXON goes high. The AGC state machine is held inactive for the duration of the value in this register. Each LSB in this register corresponds to a delay of 1s (determined by reference_clock_cycles).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAttackDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x50), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When agc_enable_gain_freeze is enabled and the agc_enable_auto_gain_lock mode is selected, the fast attack AGC for Rx1 freezes gain after an amount of time determined by this register (and reference_clock_cycles  reference clock cycles per s).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAutoGainLockDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4f), (value >> 0));

    return status;
}

/**
 * When agc_enable_gain_freeze is enabled and the agc_enable_auto_gain_lock mode is selected, the fast attack AGC for Rx1 freezes gain after an amount of time determined by this register (and reference_clock_cycles  reference clock cycles per s).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcAutoGainLockDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcCurrentMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14f), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcCurrentMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14f), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits determine the initial decimation of the input signal to the DC offset block before accumulation. The number of samples decimated is calculated as 2^i where i" is the decimate value. The maximum value that can be programmed is 21.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcDecimate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13e), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * These bits determine the initial decimation of the input signal to the DC offset block before accumulation. The number of samples decimated is calculated as 2^i where i" is the decimate value. The maximum value that can be programmed is 21.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcDecimate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13e), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcForceRoundPath_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x156), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcForceRoundPath_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x156), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcForceRoundPathSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x156), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcForceRoundPathSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x156), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in "bbdc_load_acc_i" and "bbdc_load_acc_q" registers are loaded in the digital DC offset accumulators for the I and Qpath. Once "bbdc_load_acc" is cleared, tracking continues from this loaded value. [0] - Ch1, [1] - Ch2.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcLoadAcc_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x147), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in "bbdc_load_acc_i" and "bbdc_load_acc_q" registers are loaded in the digital DC offset accumulators for the I and Qpath. Once "bbdc_load_acc" is cleared, tracking continues from this loaded value. [0] - Ch1, [1] - Ch2.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcLoadAcc_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x147), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the I path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcLoadAccI_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x147), (value >> 16), 0xc, 0x2);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x144), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x143), (value >> 0));

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the I path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcLoadAccI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x147), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x144), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x143), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the Q path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcLoadAccQ_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x147), (value >> 16), 0x30, 0x4);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x146), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x145), (value >> 0));

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the Q path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcLoadAccQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x147), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x146), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x145), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register controls the loop gain of the DC offset loop. The maximum value that can be programmed is 31.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13f), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This register controls the loop gain of the DC offset loop. The maximum value that can be programmed is 31.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG BIT. Pause BBDC manually.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcManualPause_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x148), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * DEBUG BIT. Pause BBDC manually.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcManualPause_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x148), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG BIT. Load accumulator with the last value stored in the LUT.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcManualRestoreAcc_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x148), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * DEBUG BIT. Load accumulator with the last value stored in the LUT.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcManualRestoreAcc_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x148), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the BBDC offset words going to the datapath

 * are masked (set to 0).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMaskOutput_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * When this bit is set, the BBDC offset words going to the datapath

 * are masked (set to 0).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMaskOutput_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_multiplier_enable" is set, the output of the decimate block gets multiplied by the value of this register before being accumulated.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMultiplier_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x142), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * When "bbdc_multiplier_enable" is set, the output of the decimate block gets multiplied by the value of this register before being accumulated.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMultiplier_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x142), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Dc Offset Multiplier Enable
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMultiplierEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x142), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Dc Offset Multiplier Enable
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcMultiplierEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x142), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the accumulator as well as decimate block are frozen. They retain the last values that were stored in the registers before the pause signal was set. The Rx1 channel DC offset correction word is also frozen to its last value and is not updated any further. When the pause bit is cleared, the tracking resumes from its previous state. If it is required to have zero DC correction word when paused, set the mask bits to do so.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcPause_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x141), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When this bit is set, the accumulator as well as decimate block are frozen. They retain the last values that were stored in the registers before the pause signal was set. The Rx1 channel DC offset correction word is also frozen to its last value and is not updated any further. When the pause bit is cleared, the tracking resumes from its previous state. If it is required to have zero DC correction word when paused, set the mask bits to do so.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcPause_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x141), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit resets the internal accumulator whenever a gain change occurs.  This action restarts the DC offset correction process from zero.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcResetAtGainchange_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x140), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit resets the internal accumulator whenever a gain change occurs.  This action restarts the DC offset correction process from zero.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcResetAtGainchange_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x140), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackInputI_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x152), (value >> 16), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x151), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x150), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackInputI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x152), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x151), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x150), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackInputQ_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x155), (value >> 16), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x154), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x153), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackInputQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x155), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x154), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x153), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable Digital Dc Offset Tracking Ch1
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackingEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x140), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable Digital Dc Offset Tracking Ch1
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackingEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x140), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackingISpi_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x149), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcTrackingQSpi_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14e), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcUpdateSpiReadback_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14f), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcUpdateSpiReadback_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set this self-clearing bit to update the registers that are available for digital DC offset readback.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcUpdateTrackingWord_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x140), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Set this self-clearing bit to update the registers that are available for digital DC offset readback.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcBbdcUpdateTrackingWord_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x140), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables immediate gain change if the ADC high threshold is exceeded (see description in agc_adc_high_ovrg_exceeded_counter).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcChangeGainIfAdcovrgHigh_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting this bit enables immediate gain change if the ADC high threshold is exceeded (see description in agc_adc_high_ovrg_exceeded_counter).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcChangeGainIfAdcovrgHigh_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables immediate gain change if the blocker high threshold is exceeded (see description in agc_ulb_threshold_exceeded_counter).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcChangeGainIfUlbthHigh_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Setting this bit enables immediate gain change if the blocker high threshold is exceeded (see description in agc_ulb_threshold_exceeded_counter).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcChangeGainIfUlbthHigh_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This configures the decrement in gain index that should be applied when the decrement gain pin (in MGC pin control mode) is pulsed high and none of the peak detector signals have triggered. If any combination of the peak detector signals are high, then the gain step that corresponds to that combination of peak detector signals is used as the decrement step size.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDecrGainStepSize_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x42), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * This configures the decrement in gain index that should be applied when the decrement gain pin (in MGC pin control mode) is pulsed high and none of the peak detector signals have triggered. If any combination of the peak detector signals are high, then the gain step that corresponds to that combination of peak detector signals is used as the decrement step size.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDecrGainStepSize_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x42), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcDelayCounterBaseRate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcDelayCounterBaseRate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * When high, this bit indicates a saturation occurred in the Rx1 digital gain block. Even a single saturation occurrence will make this bit go high and stay high. When this bit is read back by the BBP, the bit will be reset to 0.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDigSat_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of times the Digital Saturation threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the Digital saturation threshold is triggered N times where N is the value configured in this register, a gain change can occur when the agc_gain_update_counter expires or in hybrid mode when a pulse is seen on the corresponding GPIO pin .
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDigSaturationExceededCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x66), (value >> 0));

    return status;
}

/**
 * This counter configures the number of times the Digital Saturation threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the Digital saturation threshold is triggered N times where N is the value configured in this register, a gain change can occur when the agc_gain_update_counter expires or in hybrid mode when a pulse is seen on the corresponding GPIO pin .
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDigSaturationExceededCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x66), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: The gain control loop reduces the gain by the specified number of indices when either UL blocker triggers or the ADC High Ovrg block triggers or the ADC Low Ovrg triggers requesting a gain change. The gain index in that case is reduced by the value specified in this register.

 * AGC Slow Loop: In this mode, when the Digital Saturation triggers a programmable number of times (agc_dig_saturation_exceeded_counter) above its configured threshold, the slow loop will decrement gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be reduced by when a gain step change needs to be made due to Digital Saturation triggering. The digital saturation has a separate trigger than ADC or HB3 overload because this check for saturation is after the digital gain has been applied. It is possible that the signal exceeds FS after digital gain but not at the ADC output.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDigsatGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x46), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: The gain control loop reduces the gain by the specified number of indices when either UL blocker triggers or the ADC High Ovrg block triggers or the ADC Low Ovrg triggers requesting a gain change. The gain index in that case is reduced by the value specified in this register.

 * AGC Slow Loop: In this mode, when the Digital Saturation triggers a programmable number of times (agc_dig_saturation_exceeded_counter) above its configured threshold, the slow loop will decrement gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be reduced by when a gain step change needs to be made due to Digital Saturation triggering. The digital saturation has a separate trigger than ADC or HB3 overload because this check for saturation is after the digital gain has been applied. It is possible that the signal exceeds FS after digital gain but not at the ADC output.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDigsatGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x46), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable AGC operation for dualband receiver
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x83), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable AGC operation for dualband receiver
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x83), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rx1 AGC dual band operation - Indicates the gain table index above which the AGC prioritizes increasing gain through external LNA control over the Front-end gain
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandExtTableLowerIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x85), (value >> 0));

    return status;
}

/**
 * Rx1 AGC dual band operation - Indicates the gain table index above which the AGC prioritizes increasing gain through external LNA control over the Front-end gain
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandExtTableLowerIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x85), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rx1 AGC dual band operation - Indicates the gain table index below which the AGC prioritizes decreasing gain through external LNA control over the Front-end gain
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandExtTableUpperIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x84), (value >> 0));

    return status;
}

/**
 * Rx1 AGC dual band operation - Indicates the gain table index below which the AGC prioritizes decreasing gain through external LNA control over the Front-end gain
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandExtTableUpperIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x84), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AGC dualband mode - High threshold for band A or band B power above which the LNA index is decreased. Value is in 0.5db
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandHighLnaThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8e), (value >> 0));

    return status;
}

/**
 * AGC dualband mode - High threshold for band A or band B power above which the LNA index is decreased. Value is in 0.5db
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandHighLnaThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This select the index for the Rx1 Band A external LNA gain table when agc_ext_index_override is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandIndexBandA_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x54), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * This select the index for the Rx1 Band A external LNA gain table when agc_ext_index_override is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandIndexBandA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x54), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Override the index to the External LNA gain table. Use values from agc_rx<1/2>_ext_index_band_<a/b> to control the index to the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandIndexOverride_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Override the index to the External LNA gain table. Use values from agc_rx<1/2>_ext_index_band_<a/b> to control the index to the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandIndexOverride_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AGC dualband mode - Margin to compare Band A power versus Band B power ( for Pwr_A > Pwr_B + margin, and Pwr_B > Pwr_A + margin checks). The margin is used to compare the powers of the bands if LNA of one band needs to be changed so that powers of the bands match. Value is in 0.5db resolution.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandLnaStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8c), (value >> 0));

    return status;
}

/**
 * AGC dualband mode - Margin to compare Band A power versus Band B power ( for Pwr_A > Pwr_B + margin, and Pwr_B > Pwr_A + margin checks). The margin is used to compare the powers of the bands if LNA of one band needs to be changed so that powers of the bands match. Value is in 0.5db resolution.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandLnaStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AGC dualband mode - Low threshold for band A or band B power below which the LNA index is increased. Value is in 0.5db
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandLowLnaThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8f), (value >> 0));

    return status;
}

/**
 * AGC dualband mode - Low threshold for band A or band B power below which the LNA index is increased. Value is in 0.5db
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandLowLnaThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This select the maximum possible index for the Rx1 Band A and Band B external LNA gain table control from the AGC
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandMaxIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x86), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * This select the maximum possible index for the Rx1 Band A and Band B external LNA gain table control from the AGC
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandMaxIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x86), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AGC dualband mode - Margin for comparing total power against power of individual bands. If Pwr_tot > Pwr_A + Pwr_B +margin, the signal contains other components than A or B, and AGC should behave like a single band system. margin is in 0.5db steps.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandPwrMargin_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8b), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * AGC dualband mode - Margin for comparing total power against power of individual bands. If Pwr_tot > Pwr_A + Pwr_B +margin, the signal contains other components than A or B, and AGC should behave like a single band system. margin is in 0.5db steps.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcDualbandPwrMargin_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the automatic gain locking feature of the AGC. Clearing this bit requires the AGC to be manually locked by the user.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableAutoGainLock_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit enables the automatic gain locking feature of the AGC. Clearing this bit requires the AGC to be manually locked by the user.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableAutoGainLock_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables detection and correction of digital saturation overloads.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableDigsatOvrg_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit enables detection and correction of digital saturation overloads.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableDigsatOvrg_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * The multiple time constants in AGC loop allow for fast attack and fast recovery back to max gain for radar applications. For MC-GSM, this should also help in quick recovery of gain to alleviate degradation to a minimal number of time slots of the GSM signal.

 * This mode for AGC operations requires the following:

 *     - I^2 + Q^2 calculation on a sample basis (dec_overload_power_mode = 1) from decimated overload data detector (agc_adc_ovrg_sel = 1, enable_dec_overload = 1)

 *     - Common offset for peak/power thresholds across all thresholds (dec_threshold_config)

 *     - Single over-range level peak/power threshold: One peak required to trigger gain reduction (dec_overload_threshold_count = 1) within over-range window (dec_overload_duration_count). With agc_change_gain_if_adcovrg_high, the AGC can decrease gain rapidly if over-range.

 *     - Three under-range level peak/power thresholds (decimated_data_overload_int0_lower_threshold, decimated_data_overload_int1_lower_threshold, dec_overload_lower_threshold). Each one of these under-range peak thresholds is associated with one of the three update intervals, one of three threshold counters, and one of the three gain steps.

 *         - 1st update interval (agc_urange_interval0) is an 16-bit count value (at the AGC clock rate)

 *         - 1st counter (agc_adcovrg_low_int0_counter) counts the number of overloads within the 1st update interval.

 *         - 1st gain step (agc_ovrg_low_int0_gain_step) determines the gain increment if the overloads do not exceed the 1st counter within the 1st update interval

 *         - 2nd update interval is a multiple of the 1st update interval and a 6-bit agc_urange_interval1_mult.

 *         - 2nd counter (agc_adcovrg_low_int1_counter) counts the number of overloads within the 2nd update interval.

 *         - 2nd gain step (agc_ovrg_low_int1_gain_step) determines the gain increment if the overloads do not exceed the 2nd counter within the 2nd update interval

 *         - 3rd update interval is a multiple of 2nd update interval and a 6-bit agc_urange_interval2_mult

 *         - 3rd counter (agc_adc_low_ovrg_exceeded_counter) counts the number of overloads within the 2nd update interval.

 *         - 3rd gain step (agc_ovrg_low_gain_step) determines the gain increment if the overloads do not exceed the 2nd counter within the 2nd update interval

 *         - To allow the counters to correlate closer to the IQ sample rate, a 2-bit agc_mult_clk_rate_comp allows the 1st update interval to be multiplied by either 1, 2 or 4 to effectively allow for count duration to run at the IQ sample rate.

 *     - The priority for gain change when the update intervals occur is

 *         - Check if over-range flag was set, else

 *         - Check if flag was set for underrange update interval0, else

 *         - Check if flag was set for underrange update interval1, else

 *         - Check if flag was set for underrange update interval2
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableFastRecoveryLoop_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * The multiple time constants in AGC loop allow for fast attack and fast recovery back to max gain for radar applications. For MC-GSM, this should also help in quick recovery of gain to alleviate degradation to a minimal number of time slots of the GSM signal.

 * This mode for AGC operations requires the following:

 *     - I^2 + Q^2 calculation on a sample basis (dec_overload_power_mode = 1) from decimated overload data detector (agc_adc_ovrg_sel = 1, enable_dec_overload = 1)

 *     - Common offset for peak/power thresholds across all thresholds (dec_threshold_config)

 *     - Single over-range level peak/power threshold: One peak required to trigger gain reduction (dec_overload_threshold_count = 1) within over-range window (dec_overload_duration_count). With agc_change_gain_if_adcovrg_high, the AGC can decrease gain rapidly if over-range.

 *     - Three under-range level peak/power thresholds (decimated_data_overload_int0_lower_threshold, decimated_data_overload_int1_lower_threshold, dec_overload_lower_threshold). Each one of these under-range peak thresholds is associated with one of the three update intervals, one of three threshold counters, and one of the three gain steps.

 *         - 1st update interval (agc_urange_interval0) is an 16-bit count value (at the AGC clock rate)

 *         - 1st counter (agc_adcovrg_low_int0_counter) counts the number of overloads within the 1st update interval.

 *         - 1st gain step (agc_ovrg_low_int0_gain_step) determines the gain increment if the overloads do not exceed the 1st counter within the 1st update interval

 *         - 2nd update interval is a multiple of the 1st update interval and a 6-bit agc_urange_interval1_mult.

 *         - 2nd counter (agc_adcovrg_low_int1_counter) counts the number of overloads within the 2nd update interval.

 *         - 2nd gain step (agc_ovrg_low_int1_gain_step) determines the gain increment if the overloads do not exceed the 2nd counter within the 2nd update interval

 *         - 3rd update interval is a multiple of 2nd update interval and a 6-bit agc_urange_interval2_mult

 *         - 3rd counter (agc_adc_low_ovrg_exceeded_counter) counts the number of overloads within the 2nd update interval.

 *         - 3rd gain step (agc_ovrg_low_gain_step) determines the gain increment if the overloads do not exceed the 2nd counter within the 2nd update interval

 *         - To allow the counters to correlate closer to the IQ sample rate, a 2-bit agc_mult_clk_rate_comp allows the 1st update interval to be multiplied by either 1, 2 or 4 to effectively allow for count duration to run at the IQ sample rate.

 *     - The priority for gain change when the update intervals occur is

 *         - Check if over-range flag was set, else

 *         - Check if flag was set for underrange update interval0, else

 *         - Check if flag was set for underrange update interval1, else

 *         - Check if flag was set for underrange update interval2
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableFastRecoveryLoop_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the use of the GPIO pin to control hybrid mode operation.  If hybrid mode is used, this bit should be set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableGainChangeWithPinControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Setting this bit enables the use of the GPIO pin to control hybrid mode operation.  If hybrid mode is used, this bit should be set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableGainChangeWithPinControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables automatic/manual gain freeze of the AGC. In automatic gain freeze, the AGC can be stopped after a certain period of time. In manual freeze mode, the user asserts a GPIO to freeze the AGC.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableGainFreeze_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit enables automatic/manual gain freeze of the AGC. In automatic gain freeze, the AGC can be stopped after a certain period of time. In manual freeze mode, the user asserts a GPIO to freeze the AGC.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableGainFreeze_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit causes agc_rx1_gain_index and agc_rx2_gain_index registers to be updated with the latest value when they are written to (with some dummy data). The value can be read back after this. Clearing this bit will allow the value to be read back without writing to the register, but the user should be careful not to read back the value when it is changing.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableGainIndexUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit causes agc_rx1_gain_index and agc_rx2_gain_index registers to be updated with the latest value when they are written to (with some dummy data). The value can be read back after this. Clearing this bit will allow the value to be read back without writing to the register, but the user should be careful not to read back the value when it is changing.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableGainIndexUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This enables the two-threshold AGC loop mode. The two-threshold AGC loop can work as follows. It will have the first threshold (programmable - agc_optimal_ip3_index) at -17dBFS. When a signal exceeds -17dBFS, the gain is reduced by ~5dB (this improves IIP3 but only results in a 0.5dB degradation in NF). If FE attenuation is greater than 5dB below min attenuation, then this threshold does not reduce the gain further.

 * Therefore, if (gain_index  = max_gain) and (gain_index   (max_gain -5dB)), then the threshold is active. otherwise it is not.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableIp3OptimizationThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This enables the two-threshold AGC loop mode. The two-threshold AGC loop can work as follows. It will have the first threshold (programmable - agc_optimal_ip3_index) at -17dBFS. When a signal exceeds -17dBFS, the gain is reduced by ~5dB (this improves IIP3 but only results in a 0.5dB degradation in NF). If FE attenuation is greater than 5dB below min attenuation, then this threshold does not reduce the gain further.

 * Therefore, if (gain_index  = max_gain) and (gain_index   (max_gain -5dB)), then the threshold is active. otherwise it is not.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableIp3OptimizationThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When exiting an AGC gain lock, setting this bit enables the gain to be set to the max gain or to the optimize gain if opt max gain when agc_opt_max_gain_when_enlost is set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableResetToMaxgain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * When exiting an AGC gain lock, setting this bit enables the gain to be set to the max gain or to the optimize gain if opt max gain when agc_opt_max_gain_when_enlost is set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableResetToMaxgain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst when exiting Rx mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableSetGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst when exiting Rx mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableSetGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst when exiting the gain lock state.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableSetGainWGainFreezeExit_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst when exiting the gain lock state.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableSetGainWGainFreezeExit_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This enables the agc_gain_update_counter to be sync to the time-slot boundary. After setting the field to 1, set the corresponding GPIO high to re-sync the agc_gain_update_counter to the GPIO pulse (dee agc_gain_update_counter for more details).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableSyncPulseForGainCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This enables the agc_gain_update_counter to be sync to the time-slot boundary. After setting the field to 1, set the corresponding GPIO high to re-sync the agc_gain_update_counter to the GPIO pulse (dee agc_gain_update_counter for more details).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnableSyncPulseForGainCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Applies to the Fast AGC.  The AGC will move from state 1 to state 2 only if no overloads occur for the time specified in this register.  AGC clock clocks the counter.  Resolution is 1 AGC clock cycle/LSB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnergyDetectCount_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * Applies to the Fast AGC.  The AGC will move from state 1 to state 2 only if no overloads occur for the time specified in this register.  AGC clock clocks the counter.  Resolution is 1 AGC clock cycle/LSB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnergyDetectCount_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables exiting from gain lock when signal energy is lost.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnergyLostFreeze_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting this bit enables exiting from gain lock when signal energy is lost.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnergyLostFreeze_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Applies to the Fast AGC.  After gain lock, the AGC measures the signal power and uses it as a comparison value.  If a later power result is lower than the original value by an amount equal to or greater than this threshold, a counter starts running at the AGC clock rate.  If the counter exceeds twice the value of the agc_gainlock_exit_count, the gain may unlock depending on the AGC configuration bits.  Resolution is 1dB/LSB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnergyLostThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Applies to the Fast AGC.  After gain lock, the AGC measures the signal power and uses it as a comparison value.  If a later power result is lower than the original value by an amount equal to or greater than this threshold, a counter starts running at the AGC clock rate.  If the counter exceeds twice the value of the agc_gainlock_exit_count, the gain may unlock depending on the AGC configuration bits.  Resolution is 1dB/LSB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcEnergyLostThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Applies to both Slow and Fast AGC.  Before measuring power, the device waits for the RX signal path to settle.  This register holds the settling delay factor that is multiplied by 2 to produce the settling delay.  AGC clock clocks the counter.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcFastAttackSettlingDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * Applies to both Slow and Fast AGC.  Before measuring power, the device waits for the RX signal path to settle.  This register holds the settling delay factor that is multiplied by 2 to produce the settling delay.  AGC clock clocks the counter.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcFastAttackSettlingDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field is read back only.  If the fast attack AGC loop is enabled (agc_rx1_setup), this register indicates the current state of the state machine according to the following options:

 * 000	Reset peak detectors

 * 001	Settling delay state (wait for the gain transients to flush out of the Rx datapath)

 * 010	Slow measurement state (a power measurement is performed to determine power level of input signal)

 * 011	Gain change state (gain is changed based on the power measurement made in the previous state)

 * 101	Gain lock state

 * 110	Recovery from overload state
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcFastAttackState_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Applies to the Fast AGC.  These bits set the threshold for the number of allowable overloads.  If this value is exceeded, the AGC algorithm will restart.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcFinalOverrangeCount_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Applies to the Fast AGC.  These bits set the threshold for the number of allowable overloads.  If this value is exceeded, the AGC algorithm will restart.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcFinalOverrangeCount_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables overloads to be controlled solely by agc_ovrg_freeze in all states of the AGC. When disabled, the overloads are always observed if the AGC gain in not locked, and by agc_ovrg_freeze when locked.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcForceFreeze_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Setting this bit enables overloads to be controlled solely by agc_ovrg_freeze in all states of the AGC. When disabled, the overloads are always observed if the AGC gain in not locked, and by agc_ovrg_freeze when locked.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcForceFreeze_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit forces the analog peak detector from channel 1 to a value of 0.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcForcePdReset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit forces the analog peak detector from channel 1 to a value of 0.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcForcePdReset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field configures the number of gain indexes to reduce the gain by when overloads (UL blocker / ADC high / digital saturation) have been exceeded while the AGC is settling to the AGC locked gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcFullGainFinalSettlingStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x93), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * This field configures the number of gain indexes to reduce the gain by when overloads (UL blocker / ADC high / digital saturation) have been exceeded while the AGC is settling to the AGC locked gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcFullGainFinalSettlingStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x93), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * In slow loop mode, this bit can be used to synchronize the agc_gain_update_counter to a time-slot boundary if agc_enable_sync_pulse_for_gain_counter is enabled. In hybrid mode, the bit can be used to cause a gain change in the AGC if agc_enable_gain_change_with_pin_control is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainChangeSyncUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * In slow loop mode, this bit can be used to synchronize the agc_gain_update_counter to a time-slot boundary if agc_enable_sync_pulse_for_gain_counter is enabled. In hybrid mode, the bit can be used to cause a gain change in the AGC if agc_enable_gain_change_with_pin_control is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainChangeSyncUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register is read back only. When read back in Rx mode, it indicates the gain index selected by either the AGC loops or in manual gain mode, the index selected by the BBP for Rx1 at that time. The number of rows in the programmable gain table is 256 (0 through 255). The default gain table has valid entries from index 255 through index 236. When agc_enable_gain_index_update is set, the register must be written to (with some dummy data) before reading. The write latches the current index into the register. When the bit is not set, the register can be read from (without a write to it), but the user must ensure that that index is not being read while it is changing.

 * 

 *  In the Rx AGC `increment gain on peak threshold only' mode, when the LL blocker triggers a programmable number of times above its configured threshold (see 0x482, LL blocker exceeded counter), the slow loop will increment gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to LL blocker triggering.

 *  Rx1 AGC gain index
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3d), (value >> 0));

    return status;
}

/**
 * This register is read back only. When read back in Rx mode, it indicates the gain index selected by either the AGC loops or in manual gain mode, the index selected by the BBP for Rx1 at that time. The number of rows in the programmable gain table is 256 (0 through 255). The default gain table has valid entries from index 255 through index 236. When agc_enable_gain_index_update is set, the register must be written to (with some dummy data) before reading. The write latches the current index into the register. When the bit is not set, the register can be read from (without a write to it), but the user must ensure that that index is not being read while it is changing.

 * 

 *  In the Rx AGC `increment gain on peak threshold only' mode, when the LL blocker triggers a programmable number of times above its configured threshold (see 0x482, LL blocker exceeded counter), the slow loop will increment gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to LL blocker triggering.

 *  Rx1 AGC gain index
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This bit indicates that the gain control loop in Rx1 has locked the gain and no changes will occur to the gain unless very specific conditions are met. This bit is applicable to the AGC fast attack loop only.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainLock_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field indicates the step size of the gain table in 0.25dB resolution.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainTableStepSize_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x95), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * This field indicates the step size of the gain table in 0.25dB resolution.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainTableStepSize_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x95), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * It is only enabled in Slow AGC mode. Gain change can only occur on the termination of this counter, if agc_change_gain_if_ulbth_high or agc_change_gain_if_adcovrg_high are not set. When this counter expires, the overload and power based threshold conditions are evaluated for the Rx enabled, and a gain change is then performed (or not). This counter runs at the AGC rate and can be configured to run at an update rate commensurate with a timeslot (or multiple timeslots).  To sync this counter to the time-slot boundary, set agc_enable_sync_pulse_for_gain_counter to 1, and then set the corresponding GPIO high to re-sync the counter to the GPIO pulse. The total gain update duration is the sum of agc_slow_loop_settling_delay and the agc_gain_update_counter value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainUpdateCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6d), (value >> 16), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6b), (value >> 0));

    return status;
}

/**
 * It is only enabled in Slow AGC mode. Gain change can only occur on the termination of this counter, if agc_change_gain_if_ulbth_high or agc_change_gain_if_adcovrg_high are not set. When this counter expires, the overload and power based threshold conditions are evaluated for the Rx enabled, and a gain change is then performed (or not). This counter runs at the AGC rate and can be configured to run at an update rate commensurate with a timeslot (or multiple timeslots).  To sync this counter to the time-slot boundary, set agc_enable_sync_pulse_for_gain_counter to 1, and then set the corresponding GPIO high to re-sync the counter to the GPIO pulse. The total gain update duration is the sum of agc_slow_loop_settling_delay and the agc_gain_update_counter value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainUpdateCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6d), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits contain the threshold used by agc_energy_lost_threshold and agc_stronger_signal_threshold to determine at what point gain should unlock when in Fast AGC mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainlockExitCount_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x99), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * These bits contain the threshold used by agc_energy_lost_threshold and agc_stronger_signal_threshold to determine at what point gain should unlock when in Fast AGC mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcGainlockExitCount_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x99), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit causes the gain update counter (during slow loop / hybrid / manual using counters) to halt when the agc freeze is set ( by agc_rx<1/2>_slowloop_freeze_enable / GPIO / HSCP )
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcHaltGainUpdateCounterOnFreeze_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This bit causes the gain update counter (during slow loop / hybrid / manual using counters) to halt when the agc freeze is set ( by agc_rx<1/2>_slowloop_freeze_enable / GPIO / HSCP )
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcHaltGainUpdateCounterOnFreeze_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the change (increase) in gain index that is applied when the increment gain pin  (in MGC pin control mode) is pulsed.  A high pulse on the corresponding GPIO in pin control mode will increment the gain by the value in this register.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcIncrGainStepSize_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x42), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * This sets the change (increase) in gain index that is applied when the increment gain pin  (in MGC pin control mode) is pulsed.  A high pulse on the corresponding GPIO in pin control mode will increment the gain by the value in this register.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcIncrGainStepSize_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x42), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_AgcLastGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit allows LL blocker to freeze any gain increase.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLlBlockerFreezesGainIncr_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting this bit allows LL blocker to freeze any gain increase.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLlBlockerFreezesGainIncr_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * In the Rx AGC `increment gain on peak threshold only' mode, when the LL blocker triggers a programmable number of times above its configured threshold (agc_llb_threshold_exceeded_counter), the slow loop will increment gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to LL blocker triggering.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLlbGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x47), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * In the Rx AGC `increment gain on peak threshold only' mode, when the LL blocker triggers a programmable number of times above its configured threshold (agc_llb_threshold_exceeded_counter), the slow loop will increment gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to LL blocker triggering.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLlbGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x47), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register can take any value from 1 through 255. If the LL blocker threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on LL Blocker trigger. Consequently, at the termination of the agc_gain_update_counter, or in hybrid mode when a pulse is seen on the corresponding GPIO pin,  if a gain increment is slated to occur based on power thresholds, and if agc_low_ths_prevent_gain_inc is 1, then no increment in gain will occur. If agc_peak_threshold_gain_control_mode is enabled, then the gain would increment if this flag is NOT set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLlbThresholdExceededCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x63), (value >> 0));

    return status;
}

/**
 * This register can take any value from 1 through 255. If the LL blocker threshold is triggered N times where N is the value configured in this register, a flag is set indicating a HIGH on LL Blocker trigger. Consequently, at the termination of the agc_gain_update_counter, or in hybrid mode when a pulse is seen on the corresponding GPIO pin,  if a gain increment is slated to occur based on power thresholds, and if agc_low_ths_prevent_gain_inc is 1, then no increment in gain will occur. If agc_peak_threshold_gain_control_mode is enabled, then the gain would increment if this flag is NOT set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLlbThresholdExceededCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x63), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: This register allows the user to configure the power level at which the signal should be held after gain lock. The value in this register is specified as a (negative sign implied)dB value below full scale. Therefore, for an LTE signal with PAR = 10dB, and leaving a 4dB margin for signal variation, the AGC lock level should be written to 0x0E. This gain control closed loop algorithm will attempt to achieve this average power level for the signal during gain lock.

 * AGC Slow Loop: In this mode, there exist four thresholds. There are two inner thresholds and two outer thresholds as shown below. The value in this register specifies the inner High threshold in (negative sign implied) dBFS. If the average power of the signal goes above this level during normal RXON operation, the gain control loop will attempt to correct this situation by reducing the gain. The gain can only be reduced when the gain update counter expires. The gain in this case will be reduced by the value in agc_upper_0_threshold_exceeded_gain_step.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLockLevel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x43), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: This register allows the user to configure the power level at which the signal should be held after gain lock. The value in this register is specified as a (negative sign implied)dB value below full scale. Therefore, for an LTE signal with PAR = 10dB, and leaving a 4dB margin for signal variation, the AGC lock level should be written to 0x0E. This gain control closed loop algorithm will attempt to achieve this average power level for the signal during gain lock.

 * AGC Slow Loop: In this mode, there exist four thresholds. There are two inner thresholds and two outer thresholds as shown below. The value in this register specifies the inner High threshold in (negative sign implied) dBFS. If the average power of the signal goes above this level during normal RXON operation, the gain control loop will attempt to correct this situation by reducing the gain. The gain can only be reduced when the gain update counter expires. The gain in this case will be reduced by the value in agc_upper_0_threshold_exceeded_gain_step.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLockLevel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x43), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit prevents the gain index from incrementing under certain conditions. Gain will not increment when the power thresholds indicate a gain increment is required, but either the LL blocker thresholds or the ADC Low Ovrg thresholds are triggered. If 0, then the ADC Low Ovrg and LL blocker threshold triggering are a dont-care.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLowThsPreventGainInc_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit prevents the gain index from incrementing under certain conditions. Gain will not increment when the power thresholds indicate a gain increment is required, but either the LL blocker thresholds or the ADC Low Ovrg thresholds are triggered. If 0, then the ADC Low Ovrg and LL blocker threshold triggering are a dont-care.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLowThsPreventGainInc_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register, along with agc_lock_level, agc_lower_1_threshold and agc_lower_0_threshold, set the slow attack thresholds as in the figure.  No gain changes occur if the signal power remains between the inner thresholds.  If the signal power is higher than the upper threshold or lower than the lower threshold, the gain changes appropriately.  Field agc_low_ths_prevent_gain_inc prevents gain increases.  Gain changes occur when the agc_gain_update_counter expires (or when the GPIO transitions high if agc_enable_gain_change_with_pin_control is set).  Specified in dBFS.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower0Threshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * This register, along with agc_lock_level, agc_lower_1_threshold and agc_lower_0_threshold, set the slow attack thresholds as in the figure.  No gain changes occur if the signal power remains between the inner thresholds.  If the signal power is higher than the upper threshold or lower than the lower threshold, the gain changes appropriately.  Field agc_low_ths_prevent_gain_inc prevents gain increases.  Gain changes occur when the agc_gain_update_counter expires (or when the GPIO transitions high if agc_enable_gain_change_with_pin_control is set).  Specified in dBFS.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower0Threshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of gain indexes to increase the gain by when the inner low power threshold has been exceeded. This step is taken only at th termination of the gain update count. The value in this register specifies the number of indexes to increase the gain when this threshold is exceeded.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower0ThresholdExceededGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x68), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This counter configures the number of gain indexes to increase the gain by when the inner low power threshold has been exceeded. This step is taken only at th termination of the gain update count. The value in this register specifies the number of indexes to increase the gain when this threshold is exceeded.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower0ThresholdExceededGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x68), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This specifies the difference between outer and inner low thresholds in dB.See description in agc_lower_0_threshold for details on power threshold modes. 

 * Outer Low Power Threshold Offset = Outer Low Power threshold  Inner Low Power threshold (in dB).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower1Threshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x71), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This specifies the difference between outer and inner low thresholds in dB.See description in agc_lower_0_threshold for details on power threshold modes. 

 * Outer Low Power Threshold Offset = Outer Low Power threshold  Inner Low Power threshold (in dB).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower1Threshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x71), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of gain indexes to increase the gain by when the outer low power threshold has been exceeded. This step is taken only at th termination of the gain update count. The value in this register specifies the number of indexes to increase the gain when this threshold is exceeded.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower1ThresholdExceededGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6a), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This counter configures the number of gain indexes to increase the gain by when the outer low power threshold has been exceeded. This step is taken only at th termination of the gain update count. The value in this register specifies the number of indexes to increase the gain when this threshold is exceeded.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcLower1ThresholdExceededGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6a), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When SPI control mode is enabled (agc_rx1_manual_gain_pin_control = 0), this register allows the user to directly index the programmable Rx gain table for channel 1. The default gain table can take values between 0xEB and 0xFF, even though every index is accessible from 0x00 to 0xFF. When the index is written to this register, the analog FE gain is changed within 2 clkADC/16 cycles. The digital gain is updated after the count value for digital gain delay reaches 0.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4c), (value >> 0));

    return status;
}

/**
 * When SPI control mode is enabled (agc_rx1_manual_gain_pin_control = 0), this register allows the user to directly index the programmable Rx gain table for channel 1. The default gain table can take values between 0xEB and 0xFF, even though every index is accessible from 0x00 to 0xFF. When the index is written to this register, the analog FE gain is changed within 2 clkADC/16 cycles. The digital gain is updated after the count value for digital gain delay reaches 0.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When SPI control mode is enabled (agc_rx1_manual_gain_pin_control = 0), this register allows the user to directly index the programmable Rx gain table for channel 1. The default gain table can take values between 0xEB and 0xFF, even though every index is accessible from 0x00 to 0xFF. When the index is written to this register, the analog FE gain is changed within 2 clkADC/16 cycles. The digital gain is updated after the count value for digital gain delay reaches 0.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4d), (value >> 0));

    return status;
}

/**
 * When SPI control mode is enabled (agc_rx1_manual_gain_pin_control = 0), this register allows the user to directly index the programmable Rx gain table for channel 1. The default gain table can take values between 0xEB and 0xFF, even though every index is accessible from 0x00 to 0xFF. When the index is written to this register, the analog FE gain is changed within 2 clkADC/16 cycles. The digital gain is updated after the count value for digital gain delay reaches 0.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexElb_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexElb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexElbB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x60), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexElbB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x60), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexOrx_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5d), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexOrx_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexOrxB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainIndexOrxB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is set, pin control mode is enabled on channel 1.  If this bit is clear, then SPI control mode is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainPinControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * If this bit is set, pin control mode is enabled on channel 1.  If this bit is clear, then SPI control mode is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcManualGainPinControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This configures the maximum gain index in the programmable gain table that can be used by the various gain control modes. The maximum gain index register value is the maximum index that can be used by the pin control Manual Gain control mode. The direct SPI control mode is not limited by this register. For the default table, this value should be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMaximumGainIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x51), (value >> 0));

    return status;
}

/**
 * This configures the maximum gain index in the programmable gain table that can be used by the various gain control modes. The maximum gain index register value is the maximum index that can be used by the pin control Manual Gain control mode. The direct SPI control mode is not limited by this register. For the default table, this value should be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMaximumGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x51), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register puts a limit on the lowest index that the gain control algorithms can use.  For the default table, this value should be 0xEC.  The minimum gain index register value is the minium index that can be used by the pin control manual gain control mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMinimumGainIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x52), (value >> 0));

    return status;
}

/**
 * This register puts a limit on the lowest index that the gain control algorithms can use.  For the default table, this value should be 0xEC.  The minimum gain index register value is the minium index that can be used by the pin control manual gain control mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMinimumGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x52), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field allows the 1st update interval to be multiplied by either 1, 2, or 4 to effectively allow for count duration to run at the IQ sample rate. For details on using this field, see description in agc_enable_fast_recovery_loop.

 * 00      1

 * 01      2

 * 10      4

 * 11      8
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMultClkRateComp_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7b), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * This field allows the 1st update interval to be multiplied by either 1, 2, or 4 to effectively allow for count duration to run at the IQ sample rate. For details on using this field, see description in agc_enable_fast_recovery_loop.

 * 00      1

 * 01      2

 * 10      4

 * 11      8
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMultClkRateComp_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7b), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable gain index to jump to if current gain index is more than this index. See agc_enable_ip3_optimization_threshold for details on two-threshold AGC loop mode
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMultitoneIp3Index_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8a), (value >> 0));

    return status;
}

/**
 * Programmable gain index to jump to if current gain index is more than this index. See agc_enable_ip3_optimization_threshold for details on two-threshold AGC loop mode
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcMultitoneIp3Index_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set to 1, a gain increment due to under-range will only occur as long as the new gain is not greater than the ip3_index. If the new gain is greater than ip3_index, the gain is set to ip3_index and no gain increment occurs.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcNoUnrgGainIncAtMaxIp3_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x83), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set to 1, a gain increment due to under-range will only occur as long as the new gain is not greater than the ip3_index. If the new gain is greater than ip3_index, the gain is set to ip3_index and no gain increment occurs.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcNoUnrgGainIncAtMaxIp3_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x83), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When signal energy is lost, setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst plus the optimize max gain threshold than reverting the AGC gain to the max gain index. Disabling this bit causes the AGC to go to max gain index when signal energy is lost.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptMaxGainWhenEnlost_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * When signal energy is lost, setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst plus the optimize max gain threshold than reverting the AGC gain to the max gain index. Disabling this bit causes the AGC to go to max gain index when signal energy is lost.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptMaxGainWhenEnlost_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst plus the optimize max gain threshold rather than reverting the AGC gain to the max gain index when exiting Rx mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptimMaxGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit enables the gain to be set to the AGC gain lock index at the end of the previous burst plus the optimize max gain threshold rather than reverting the AGC gain to the max gain index when exiting Rx mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptimMaxGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable gain index to jump to if current gain index is more than this index. See agc_enable_ip3_optimization_threshold for details on two-threshold AGC loop mode
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptimalIp3Index_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7d), (value >> 0));

    return status;
}

/**
 * Programmable gain index to jump to if current gain index is more than this index. See agc_enable_ip3_optimization_threshold for details on two-threshold AGC loop mode
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptimalIp3Index_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field indicates the number of gain indexes to increase the gain by when the optimize gain is used ( agc_optim_max_gain, agc_opt_max_gain_when_enlost, or agc_enable_reset_to_maxgain)
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptimizeMaxGainThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x96), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This field indicates the number of gain indexes to increase the gain by when the optimize gain is used ( agc_optim_max_gain, agc_opt_max_gain_when_enlost, or agc_enable_reset_to_maxgain)
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOptimizeMaxGainThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x96), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables exiting from gain lock when overloads (UL blocker / ADC high / digital saturation) are detected.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgFreeze_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit enables exiting from gain lock when overloads (UL blocker / ADC high / digital saturation) are detected.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgFreeze_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: The gain control loop reduces the gain by the specified number of indices when either UL blocker triggers or the ADC High Ovrg block triggers requesting a gain change. The gain index in that case is reduced by the value specified in this register.

 * AGC Slow Loop: In this mode, when the ADC High Overrange triggers a programmable number of times (agc_adc_high_ovrg_exceeded_counter), ADC Ovrg Count Threshold) above its configured threshold, the slow loop will decrement gain either immediately (agc_change_gain_if_ulbth_high) or at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be reduced by when a gain step change needs to be made due to ADC High Ovrg triggering.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgHighGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x45), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: The gain control loop reduces the gain by the specified number of indices when either UL blocker triggers or the ADC High Ovrg block triggers requesting a gain change. The gain index in that case is reduced by the value specified in this register.

 * AGC Slow Loop: In this mode, when the ADC High Overrange triggers a programmable number of times (agc_adc_high_ovrg_exceeded_counter), ADC Ovrg Count Threshold) above its configured threshold, the slow loop will decrement gain either immediately (agc_change_gain_if_ulbth_high) or at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be reduced by when a gain step change needs to be made due to ADC High Ovrg triggering.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgHighGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x45), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * In the Rx AGC `increment gain on peak threshold only' mode, when the ADC Low Overrange triggers a programmable number of times above its configured threshold (agc_adc_low_ovrg_exceeded_counter), the slow loop will increment gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg triggering.

 * When in multiple time constants in AGC loop mode, the value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg interval 2 triggering for the 3rd update interval. For details on using this field in this mode, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgLowGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x48), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * In the Rx AGC `increment gain on peak threshold only' mode, when the ADC Low Overrange triggers a programmable number of times above its configured threshold (agc_adc_low_ovrg_exceeded_counter), the slow loop will increment gain at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg triggering.

 * When in multiple time constants in AGC loop mode, the value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg interval 2 triggering for the 3rd update interval. For details on using this field in this mode, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgLowGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x48), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * In multiple time constants in AGC loop mode, When the ADC Low Overrange interval 0 triggers a programmable number of times above its configured threshold (agc_adcovrg_low_int0_counter), the slow loop will increment gain at the termination of the 1st update interval. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg interval 0 triggering. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgLowInt0GainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x81), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * In multiple time constants in AGC loop mode, When the ADC Low Overrange interval 0 triggers a programmable number of times above its configured threshold (agc_adcovrg_low_int0_counter), the slow loop will increment gain at the termination of the 1st update interval. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg interval 0 triggering. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgLowInt0GainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x81), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * In multiple time constants in AGC loop mode, When the ADC Low Overrange interval 1 triggers a programmable number of times above its configured threshold (agc_adcovrg_low_int1_counter), the slow loop will increment gain at the termination of the 2nd update interval. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg interval 1 triggering. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgLowInt1GainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x82), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * In multiple time constants in AGC loop mode, When the ADC Low Overrange interval 1 triggers a programmable number of times above its configured threshold (agc_adcovrg_low_int1_counter), the slow loop will increment gain at the termination of the 2nd update interval. The value entered into this register should be the number of index values that the gain should be increased by when a gain step change needs to be made due to ADC Low Ovrg interval 1 triggering. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgLowInt1GainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x82), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits determine how long the resets for the ADC overrange detectors are asserted.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgResetpdHighCount_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x49), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits determine how long the resets for the ADC overrange detectors are asserted.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcOvrgResetpdHighCount_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x49), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This AGC mode enables gain change based only on the signal peak threshold over-ranges. Power based AGC changes are disabled. ULB high over-range, AGC high over-range and digital saturation cause gain to decrease, while ULB low under-range and AGC low under-range cause gain to increase.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcPeakThresholdGainControlMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * This AGC mode enables gain change based only on the signal peak threshold over-ranges. Power based AGC changes are disabled. ULB high over-range, AGC high over-range and digital saturation cause gain to decrease, while ULB low under-range and AGC low under-range cause gain to increase.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcPeakThresholdGainControlMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits configure the duration (in AGC clock cycles) that the gain control algorithms wait before enabling regular operation of the peak detectors.  These include the analog peak detector, ADC overrange detector and HB2 output peak detectors. If digital gain saturation is enabled, then the peak wait time needs to be increased to account for the location of the digital saturation block in the RX chain (after the PFIR).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcPeakWaitTime_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * These bits configure the duration (in AGC clock cycles) that the gain control algorithms wait before enabling regular operation of the peak detectors.  These include the analog peak detector, ADC overrange detector and HB2 output peak detectors. If digital gain saturation is enabled, then the peak wait time needs to be increased to account for the location of the digital saturation block in the RX chain (after the PFIR).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcPeakWaitTime_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enabling the setting resets all agc over/underrange counters in the Rx1 (ULB counters, LLB counters, ADC high, ADC low, digsat, IP3).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcResetCounters_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enabling the setting resets all agc over/underrange counters in the Rx1 (ULB counters, LLB counters, ADC high, ADC low, digsat, IP3).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcResetCounters_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit when written to 1 resets the AGC slow loop state machine to state 0 (and to max gain) when the Rx Enable is taken low. If 0, then the slow loop maintains its state when the Rx Enable is taken low and continues from its current value when Rx enable is back high.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcResetOnRxon_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * This bit when written to 1 resets the AGC slow loop state machine to state 0 (and to max gain) when the Rx Enable is taken low. If 0, then the slow loop maintains its state when the Rx Enable is taken low and continues from its current value when Rx enable is back high.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcResetOnRxon_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcResetOnRxonGainIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_AgcResetOnRxonGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits configure the gain control algorithm that is used on channel 1. The option are as follows: 

 *         Gain Control Mode                       Application

 *         -----------------                       -----------

 * 00      Manual Gain Mode Operation              FDD and TDD modes (but much slower

 *        (SPI control or pin control modes)       than the internal AGC loops)

 * 01      Fast Attack AGC Mode                    TDD mode

 * 10      Slow Loop AGC Mode                      FDD, TDD modes

 * 11      Hybrid AGC Mode                         FDD, TDD modes
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSetup_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits configure the gain control algorithm that is used on channel 1. The option are as follows: 

 *         Gain Control Mode                       Application

 *         -----------------                       -----------

 * 00      Manual Gain Mode Operation              FDD and TDD modes (but much slower

 *        (SPI control or pin control modes)       than the internal AGC loops)

 * 01      Fast Attack AGC Mode                    TDD mode

 * 10      Slow Loop AGC Mode                      FDD, TDD modes

 * 11      Hybrid AGC Mode                         FDD, TDD modes
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSetup_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register is specified in AGC clock cycles. The power measurement and all overload blocks are disabled for this duration after a gain change to allow the gain transients to flow through the Rx path before start of any measurements.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSlowLoopSettlingDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6f), (value >> 0));

    return status;
}

/**
 * This register is specified in AGC clock cycles. The power measurement and all overload blocks are disabled for this duration after a gain change to allow the gain transients to flow through the Rx path before start of any measurements.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSlowLoopSettlingDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field is read back only. If the slow AGC loop is enabled (agc_rx1_setup), this register indicates the current state of the state machine according to the settings below. This register should only be read back in RXON mode.

 * 00	Reset state of state machine

 * 01	Perform power measurements on signal

 * 10	Change gain based on power measurements and power thresholds defined by the BBP

 * 11	Clear all peak detectors
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSlowLoopState_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3e), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSlowloopFastGainChangeBlockEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1bf), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSlowloopFastGainChangeBlockEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1bf), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is written to 1, the Rx1 AGC state machine disregards all inputs into the AGC. It also stops updating the gain words. Effectively, the AGC state machine is frozen in this mode. This mode can be used for a TDD system when the device is used as a receiver in the BTS. If the ADC is enabled during a DL period, there will be no signal input at the ADC input. At this time, the gain should not increment because no signal is seen. This bit allows the AGC to stop gain ranging of the input signal.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSlowloopFreezeEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * If this bit is written to 1, the Rx1 AGC state machine disregards all inputs into the AGC. It also stops updating the gain words. Effectively, the AGC state machine is frozen in this mode. This mode can be used for a TDD system when the device is used as a receiver in the BTS. If the ADC is enabled during a DL period, there will be no signal input at the ADC input. At this time, the gain should not increment because no signal is seen. This bit allows the AGC to stop gain ranging of the input signal.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSlowloopFreezeEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit resets all state machines within the gain control block to state 0 and maximum gain (for slow, fast attack, and hybrid AGC loops).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSoftReset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Setting this bit resets all state machines within the gain control block to state 0 and maximum gain (for slow, fast attack, and hybrid AGC loops).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcSoftReset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables exit from gain lock when signal energy increases.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcStrongSignalFreeze_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Setting this bit enables exit from gain lock when signal energy increases.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcStrongSignalFreeze_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Applies to the Fast AGC.  After gain lock, the AGC measures the signal power and uses it as a comparison value.  If a later power result is higher than the original value by an amount equal to or greater than this threshold, a counter starts running at the AGC clock rate.  If the counter exceeds twice the value of agc_gainlock_exit_count, the gain may unlock depending on the AGC configuration bits.  Resolution is 1dB/LSB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcStrongerSignalThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Applies to the Fast AGC.  After gain lock, the AGC measures the signal power and uses it as a comparison value.  If a later power result is higher than the original value by an amount equal to or greater than this threshold, a counter starts running at the AGC clock rate.  If the counter exceeds twice the value of agc_gainlock_exit_count, the gain may unlock depending on the AGC configuration bits.  Resolution is 1dB/LSB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcStrongerSignalThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Combined with agc_rx1_ul_sig_power_meas_duration, these fields allow power detection of data for a specific slice of the gain update counter period as follows:

 *         - Gain update counter expires

 *         - A counter counts till agc_rx1_ul_sig_power_meas_delay

 *         - Power measurement starts

 *         - A counter counts till agc_rx1_ul_sig_power_meas_duration

 *         - Power measurement stops, and the last value of measured power during this time is used by AGC when the gain update counter expires the next time.

 * A value of 0 causes the power measuremt to start as soon as the gain counter expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlSigPowerMeasDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x73), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x72), (value >> 0));

    return status;
}

/**
 * Combined with agc_rx1_ul_sig_power_meas_duration, these fields allow power detection of data for a specific slice of the gain update counter period as follows:

 *         - Gain update counter expires

 *         - A counter counts till agc_rx1_ul_sig_power_meas_delay

 *         - Power measurement starts

 *         - A counter counts till agc_rx1_ul_sig_power_meas_duration

 *         - Power measurement stops, and the last value of measured power during this time is used by AGC when the gain update counter expires the next time.

 * A value of 0 causes the power measuremt to start as soon as the gain counter expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlSigPowerMeasDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x73), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x72), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Combined with agc_rx1_ul_sig_power_meas_delay, these fields allow power detection of data for a specific slice of the gain update counter period as follows:

 *         - Gain update counter expires

 *         - A counter counts till agc_rx1_ul_sig_power_meas_delay

 *         - Power measurement starts

 *         - A counter counts till agc_rx1_ul_sig_power_meas_duration

 *         - Power measurement stops, and the last value of measured power during this time is used by AGC when the gain update counter expires the next time.

 * A value of 0 causes the power measurement to run until the next gain update counter expiry.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlSigPowerMeasDuration_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x75), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x74), (value >> 0));

    return status;
}

/**
 * Combined with agc_rx1_ul_sig_power_meas_delay, these fields allow power detection of data for a specific slice of the gain update counter period as follows:

 *         - Gain update counter expires

 *         - A counter counts till agc_rx1_ul_sig_power_meas_delay

 *         - Power measurement starts

 *         - A counter counts till agc_rx1_ul_sig_power_meas_duration

 *         - Power measurement stops, and the last value of measured power during this time is used by AGC when the gain update counter expires the next time.

 * A value of 0 causes the power measurement to run until the next gain update counter expiry.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlSigPowerMeasDuration_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x75), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x74), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: The gain control loop reduces the gain by the specified number of indices when both UL blocker triggers and the ADC High Ovrg block triggers simultaneously. The gain index in that case is reduced by the value specified in this register.

 * AGC Slow Loop: In this mode, when the UL blocker triggers a programmable number of times (upper_level_blocker_threshold) above its configured threshold, the slow loop will decrement gain either immediately (agc_change_gain_if_ulbth_high) or at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be reduced by when a gain step change needs to be made due to UL Blocker triggering.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlbGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x44), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This register performs two functions (based on gain control mode used):

 * AGC Fast Attack Loop: The gain control loop reduces the gain by the specified number of indices when both UL blocker triggers and the ADC High Ovrg block triggers simultaneously. The gain index in that case is reduced by the value specified in this register.

 * AGC Slow Loop: In this mode, when the UL blocker triggers a programmable number of times (upper_level_blocker_threshold) above its configured threshold, the slow loop will decrement gain either immediately (agc_change_gain_if_ulbth_high) or at the termination of the gain update counter. The value entered into this register should be the number of index values that the gain should be reduced by when a gain step change needs to be made due to UL Blocker triggering.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlbGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x44), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of times the UL blocker threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the UL blocker threshold is triggered N times where N is the value configured in this register, a gain change can either occur immediately (agc_change_gain_if_ulbth_high)  or when the agc_gain_update_counter expires or in hybrid mode when a pulse is seen on the corresponding GPIO pin .
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlbThresholdExceededCounter_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x62), (value >> 0));

    return status;
}

/**
 * This counter configures the number of times the UL blocker threshold is triggered within one gain update interval before a gain change is mandated by the gain control loop. This register can take any value from 1 through 255. If the UL blocker threshold is triggered N times where N is the value configured in this register, a gain change can either occur immediately (agc_change_gain_if_ulbth_high)  or when the agc_gain_update_counter expires or in hybrid mode when a pulse is seen on the corresponding GPIO pin .
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUlbThresholdExceededCounter_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x62), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the AGC lock level index for a burst to be recorded even when the AGC gain is locked so that the AGC can set the gain to this value if it exits gain lock.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpdateSetgainLockLevelDuringBurst_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x92), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit enables the AGC lock level index for a burst to be recorded even when the AGC gain is locked so that the AGC can set the gain to this value if it exits gain lock.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpdateSetgainLockLevelDuringBurst_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x92), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of gain indexes to reduce the gain by when the inner upper threshold has been exceeded. This step is taken only at the termination of the gain update count. The value in this register specifies the number of indexes by which to reduce the gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpper0ThresholdExceededGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x67), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This counter configures the number of gain indexes to reduce the gain by when the inner upper threshold has been exceeded. This step is taken only at the termination of the gain update count. The value in this register specifies the number of indexes by which to reduce the gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpper0ThresholdExceededGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x67), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This specifies the difference between outer and inner high thresholds in dB. See description in agc_lower_0_threshold for details on power threshold modes.

 * Outer High Power Threshold Offset = Outer High Power threshold  Inner High Power threshold (in dB).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpper1Threshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8d), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This specifies the difference between outer and inner high thresholds in dB. See description in agc_lower_0_threshold for details on power threshold modes.

 * Outer High Power Threshold Offset = Outer High Power threshold  Inner High Power threshold (in dB).
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpper1Threshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8d), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This counter configures the number of gain indexes to reduce the gain by when the outer high power threshold has been exceeded. This step is taken only at th termination of the gain update count. The value in this register specifies the number of indexes to reduce the gain by when this threshold has been exceeded. This condition is only evaluated at the termination of the gain update counter.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpper1ThresholdExceededGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x69), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This counter configures the number of gain indexes to reduce the gain by when the outer high power threshold has been exceeded. This step is taken only at th termination of the gain update count. The value in this register specifies the number of indexes to reduce the gain by when this threshold has been exceeded. This condition is only evaluated at the termination of the gain update counter.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpper1ThresholdExceededGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x69), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Applies to Fast AGC.  These bits set the maximum gain index increase that the AGC can use for the lock level adjustment.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpperLimitOnGainIncreaseForLockLevel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Applies to Fast AGC.  These bits set the maximum gain index increase that the AGC can use for the lock level adjustment.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUpperLimitOnGainIncreaseForLockLevel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field the 1st update interval for the multiple time constant in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUrangeInterval0_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x79), (value >> 0));

    return status;
}

/**
 * This field the 1st update interval for the multiple time constant in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUrangeInterval0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x79), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field, sets the 2nd update interval for the multiple time constant in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUrangeInterval1Mult_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7b), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * This field, sets the 2nd update interval for the multiple time constant in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUrangeInterval1Mult_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7b), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field, sets the 3rd update interval for the multiple time constant in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUrangeInterval2Mult_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7c), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * This field, sets the 3rd update interval for the multiple time constant in AGC loop mode. For details on using this field, see description in agc_enable_fast_recovery_loop.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUrangeInterval2Mult_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7c), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables using the blocker, ADC, and digital saturation over-range counters in Rx1 when in manual gain control mode.  The overrange signals can be observed by the user through the GPIO to control the AGC in this mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUseCountersForMgc_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit enables using the blocker, ADC, and digital saturation over-range counters in Rx1 when in manual gain control mode.  The overrange signals can be observed by the user through the GPIO to control the AGC in this mode.
 */
static inline int32_t adrv9001_NvsRegmapRxb_AgcUseCountersForMgc_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ApdHighSrcSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ApdHighSrcSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ApdLowSrcSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ApdLowSrcSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_BandASlicerPosition_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits determine the initial decimation of the input signal to the DC offset block before accumulation. The number of samples decimated is calculated as 2^i where i" is the decimate value. The maximum value that can be programmed is 21.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcDecimate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * These bits determine the initial decimation of the input signal to the DC offset block before accumulation. The number of samples decimated is calculated as 2^i where i" is the decimate value. The maximum value that can be programmed is 21.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcDecimate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbDecimate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c8), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbDecimate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c8), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbMShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c9), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbMShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c9), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbMultiplier_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cb), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbMultiplier_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cb), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbMultiplierEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ca), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbMultiplierEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ca), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbPause_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ca), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbPause_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ca), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbTrackingEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ca), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcElbTrackingEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ca), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TO BE REMOVED??
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcForceRoundPath_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * TO BE REMOVED??
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcForceRoundPath_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TO BE REMOVED??
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcForceRoundPathSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * TO BE REMOVED??
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcForceRoundPathSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in "bbdc_load_acc_i" and "bbdc_load_acc_q" registers are loaded in the digital DC offset accumulators for the I and Qpath. Once "bbdc_load_acc" is cleared, tracking continues from this loaded value. [0] - Ch1, [1] - Ch2.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoadAcc_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in "bbdc_load_acc_i" and "bbdc_load_acc_q" registers are loaded in the digital DC offset accumulators for the I and Qpath. Once "bbdc_load_acc" is cleared, tracking continues from this loaded value. [0] - Ch1, [1] - Ch2.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoadAcc_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the I path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoadAccI_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 16), 0xc, 0x2);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa0), (value >> 0));

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the I path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoadAccI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the Q path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoadAccQ_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 16), 0x30, 0x4);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa2), (value >> 0));

    return status;
}

/**
 * When "bbdc_load_acc" is set, the value in this register is loaded

 * in the digital DC offset accumulator for the Q path. Once "bbdc_load_acc" is

 * cleared, tracking continues from this loaded value.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoadAccQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa1), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackDecimate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x171), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackDecimate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x171), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackMShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x172), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackMShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x172), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackMultiplier_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x173), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackMultiplier_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x173), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackMultiplierEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackMultiplierEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackPause_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackPause_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackTrackingEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcLoopbackTrackingEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register controls the loop gain of the DC offset loop. The maximum value that can be programmed is 31.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9b), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This register controls the loop gain of the DC offset loop. The maximum value that can be programmed is 31.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG BIT. Pause BBDC manually.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcManualPause_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * DEBUG BIT. Pause BBDC manually.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcManualPause_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DEBUG BIT. Load accumulator with the last value stored in the LUT.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcManualRestoreAcc_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * DEBUG BIT. Load accumulator with the last value stored in the LUT.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcManualRestoreAcc_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the BBDC offset words going to the datapath

 * are masked (set to 0).
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMaskOutput_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * When this bit is set, the BBDC offset words going to the datapath

 * are masked (set to 0).
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMaskOutput_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "bbdc_multiplier_enable" is set, the output of the decimate block gets multiplied by the value of this register before being accumulated.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMultiplier_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9e), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * When "bbdc_multiplier_enable" is set, the output of the decimate block gets multiplied by the value of this register before being accumulated.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMultiplier_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9e), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Dc Offset Multiplier Enable
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMultiplierEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Dc Offset Multiplier Enable
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcMultiplierEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxDecimate_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x175), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxDecimate_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x175), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxMShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x176), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxMShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x176), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxMultiplier_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x177), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxMultiplier_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x177), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxMultiplierEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x178), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxMultiplierEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x178), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxPause_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x178), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxPause_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x178), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxTrackingEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x178), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_BbdcOrxTrackingEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x178), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the accumulator as well as decimate block are frozen. They retain the last values that were stored in the registers before the pause signal was set. The Rx1 channel DC offset correction word is also frozen to its last value and is not updated any further. When the pause bit is cleared, the tracking resumes from its previous state. If it is required to have zero DC correction word when paused, set the mask bits to do so.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcPause_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When this bit is set, the accumulator as well as decimate block are frozen. They retain the last values that were stored in the registers before the pause signal was set. The Rx1 channel DC offset correction word is also frozen to its last value and is not updated any further. When the pause bit is cleared, the tracking resumes from its previous state. If it is required to have zero DC correction word when paused, set the mask bits to do so.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcPause_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable Digital Dc Offset Tracking Ch1
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcTrackingEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable Digital Dc Offset Tracking Ch1
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcTrackingEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit resets the internal accumulator whenever a gain change occurs.  This action restarts the DC offset correction process from zero.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcTrackingResetAccOnGainChange_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit resets the internal accumulator whenever a gain change occurs.  This action restarts the DC offset correction process from zero.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcTrackingResetAccOnGainChange_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set this self-clearing bit to update the registers that are available for digital DC offset readback.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcUpdateTrackingWord_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Set this self-clearing bit to update the registers that are available for digital DC offset readback.
 */
static inline int32_t adrv9001_NvsRegmapRxb_BbdcUpdateTrackingWord_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: CSSI data source clock for DEBUG mode inherit from datapath NBDEM stage, 1: CSSI data source clock for DEBUG mode inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_CssiRxDataSourceDbgModeClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: CSSI data source clock for DEBUG mode inherit from datapath NBDEM stage, 1: CSSI data source clock for DEBUG mode inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_CssiRxDataSourceDbgModeClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to cssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapRxb_CssiRxMaskStrobeEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to cssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapRxb_CssiRxMaskStrobeEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapRxb_CssiRxMaskStrobeValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d9), (value >> 0));

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapRxb_CssiRxMaskStrobeValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This register contains the readback value of the current Rx1 gain index. If "read gain table" is set, the value is "gt_addr" . If clear, the value is the gain index currently in use on the Rx1 channel.
 */
static inline int32_t adrv9001_NvsRegmapRxb_CurrentGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) SPI toggled bit to capture the slicer gain shift value calculated by rssi_pm or by number-of-sign-bits. If the SPI toggle occurs before rssi_pm or number-sign-bits completes the SPI toggle is placed on a queue. Upon completion of rssi_pm or number-sign-bits the slicer gain is captured and the queue is cleared 

 *  1 = capture slicer gain

 * 0 = no capture

 * 

 * Note: If by number-sign-bits and the slicer gain completed, the SPI toggle initiates a new slicer gain by sign-bits calculation.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgDpDoutShiftValid_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) SPI toggled bit to capture the slicer gain shift value calculated by rssi_pm or by number-of-sign-bits. If the SPI toggle occurs before rssi_pm or number-sign-bits completes the SPI toggle is placed on a queue. Upon completion of rssi_pm or number-sign-bits the slicer gain is captured and the queue is cleared 

 *  1 = capture slicer gain

 * 0 = no capture

 * 

 * Note: If by number-sign-bits and the slicer gain completed, the SPI toggle initiates a new slicer gain by sign-bits calculation.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgDpDoutShiftValid_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgDpOutShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15b), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgDpOutShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Masking bit to enable or disable the slicer gain to be captured by the falling edge of rxon (delay enable). This only applies when slicer gain is generated by rssi_pm or numder-of-sign-bits

 * 1 = slicer gain captured on falling edge rxon

 * 0 = slicer gain not captured on falling edge rxon
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgFallingRxonMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Masking bit to enable or disable the slicer gain to be captured by the falling edge of rxon (delay enable). This only applies when slicer gain is generated by rssi_pm or numder-of-sign-bits

 * 1 = slicer gain captured on falling edge rxon

 * 0 = slicer gain not captured on falling edge rxon
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgFallingRxonMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15c), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgNsbOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15a), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgNsbOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgNsbs_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x158), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x157), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgNsbs_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x158), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x157), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgNsbsDly_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x159), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgNsbsDly_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x159), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTLAvgExp_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x170), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTLAvgExp_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x170), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTLAvgMan_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTLAvgMan_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTUAvgExp_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16d), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTUAvgExp_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16d), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTUAvgMan_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmTUAvgMan_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t (*value)[10])
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x166), &register_value, 0x3, 0x0);
    (*value)[0] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x165), &register_value);
    (*value)[1] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x164), &register_value);
    (*value)[2] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x163), &register_value);
    (*value)[3] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x162), &register_value);
    (*value)[4] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x161), &register_value);
    (*value)[5] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x160), &register_value);
    (*value)[6] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15f), &register_value);
    (*value)[7] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15e), &register_value);
    (*value)[8] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15d), &register_value);
    (*value)[9] = register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0Num_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17b), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x179), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0Num_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x179), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0NumB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17c), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0NumB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0NumRecip_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x181), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x180), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0NumRecip_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x181), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x180), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0NumRecipB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x184), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x183), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x182), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAcc0NumRecipB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x184), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x183), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x182), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAccClear_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmAccClear_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmClearMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmClearMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmCnt0IntermVal_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x169), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x168), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x167), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmDsel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmDsel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmPowExp0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x186), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmPowMan0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x188), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x187), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmReadStrobe_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmReadStrobe_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_DcsgPmStatusOut_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x189), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15b), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DcsgShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15b), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Slicer gain shift right ceiling. Define the maximum shift right that can occur. Ceiling range is 9 to 0.

 * 4’h0 : shift right celing = 0

 * 4’h1 : shift right ceiling =1

 * …

 * 4’h9 : shift right ceiling = 9
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftCeiling_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Slicer gain shift right ceiling. Define the maximum shift right that can occur. Ceiling range is 9 to 0.

 * 4’h0 : shift right celing = 0

 * 4’h1 : shift right ceiling =1

 * …

 * 4’h9 : shift right ceiling = 9
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftCeiling_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Slicer gain shift floor for range from +9 to -5, Bit-4 defines the minimum shift right value when=0 and the maximum shift left value when=1. Bits[3:0] define either the minimum shift right value or the maximum shift left value.

 * 

 * Bit-4 = 1: bits[3:0] define maximum shift left value.

 * Bits[3:0] define shift value.

 * {0, 4;h9} : minimum shift right = 9

 * {0, 4’h8} : minimum shift right = 8

 * …

 * {0, 4’h0} : minimum shift right = 0

 * 

 * {1, 4’h1} : maximum shift left = 1

 * …

 * {1, 4’h5} : maximum shift left = 5
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftFloor_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c4), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (B0 New) Slicer gain shift floor for range from +9 to -5, Bit-4 defines the minimum shift right value when=0 and the maximum shift left value when=1. Bits[3:0] define either the minimum shift right value or the maximum shift left value.

 * 

 * Bit-4 = 1: bits[3:0] define maximum shift left value.

 * Bits[3:0] define shift value.

 * {0, 4;h9} : minimum shift right = 9

 * {0, 4’h8} : minimum shift right = 8

 * …

 * {0, 4’h0} : minimum shift right = 0

 * 

 * {1, 4’h1} : maximum shift left = 1

 * …

 * {1, 4’h5} : maximum shift left = 5
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftFloor_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c4), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)The slicer shift left value when forced by SPI. Range shift left 0 to 5
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftLeft_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c0), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)The slicer shift left value when forced by SPI. Range shift left 0 to 5
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftLeft_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c0), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable slicer gain from number sign bits or rssi_pm power measurement to shift left when number sign bits greater than 10

 * 0 = shift left not enabled (supports Navassa_A0 backwards compatibility)

 * 1 = shift left enabled (slicer gain can shift left or right based on sign-bits or power level)
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftLeftEn_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Enable slicer gain from number sign bits or rssi_pm power measurement to shift left when number sign bits greater than 10

 * 0 = shift left not enabled (supports Navassa_A0 backwards compatibility)

 * 1 = shift left enabled (slicer gain can shift left or right based on sign-bits or power level)
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftLeftEn_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) SPI select to shift slicer gain left or right when slicer gain being forced by SPI.

 * 0 = shift right

 * 1 = shift left
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftLeftSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) SPI select to shift slicer gain left or right when slicer gain being forced by SPI.

 * 0 = shift right

 * 1 = shift left
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgShiftLeftSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_DcsgSlicerDpOutShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) The slicer gain shift left value being used for digital gain compensation, calculated by rssi_pm, number-sign-bits or forced by SPI.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgSlicerDpOutShiftLeft_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Number of sign bits measured to derive slicer gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DcsgSlicerNsbsMeasured_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c5), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register contains the decimated power readback value for the Ch1 Rx datapath.  Resolution is 0.25dB. This register must be written (any value) to generate a strobe that will latch the value to be read back.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPower_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3), (value >> 0));

    return status;
}

/**
 * This register contains the decimated power readback value for the Ch1 Rx datapath.  Resolution is 0.25dB. This register must be written (any value) to generate a strobe that will latch the value to be read back.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPower_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set 0, digital gain will not be added in the dec power calculation.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerAddDigGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * When this bit is set 0, digital gain will not be added in the dec power calculation.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerAddDigGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Controls how the decimated power measurement is trigged. When set to 1, the AGC starts the power measurement. When 0, the decimated power measurement is trigged from SPI by setting "dec_power_enable_meas" register.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerEnSpiOrAgcSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Controls how the decimated power measurement is trigged. When set to 1, the AGC starts the power measurement. When 0, the decimated power measurement is trigged from SPI by setting "dec_power_enable_meas" register.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerEnSpiOrAgcSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is set, the Rx power measurement block is enabled. If the manual mode for gain control is enabled, the power measurement starts measuring as soon as this bit is set. If in one of the AGC modes, the start of power measurement depends on the current state of the state machine. This bit needs to be set for correct operation of the automatic gain control state machine.  The duration of the measurement can be configured by writing to "dec_power_measurement_duration".
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerEnableMeas_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * If this bit is set, the Rx power measurement block is enabled. If the manual mode for gain control is enabled, the power measurement starts measuring as soon as this bit is set. If in one of the AGC modes, the start of power measurement depends on the current state of the state machine. This bit needs to be set for correct operation of the automatic gain control state machine.  The duration of the measurement can be configured by writing to "dec_power_measurement_duration".
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerEnableMeas_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 00: RFIR, 01: HB1, 10: HB2, 11:HB2
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerInputSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * 00: RFIR, 01: HB1, 10: HB2, 11:HB2
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerInputSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the linear power is latched for readback. This bit must be set before reading linear power for proper readback operation. Auto clear.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerLatchLinearPower_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When set, the linear power is latched for readback. This bit must be set before reading linear power for proper readback operation. Auto clear.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerLatchLinearPower_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is the linear decimated power (not log power). In order to readback,set "dec_power_latch_linear_power" to latch the power. By default, this register reads power from Ch1. Set "dec_power_read_ch2_linear_power" to read power from Ch2.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerLinearPower_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the dynamic range of the power measurement increases from 40dB to ~60dB (that is, all signal levels from 0dBFS to -60dBFS are accurately detected.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerLogShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * When this bit is set, the dynamic range of the power measurement increases from 40dB to ~60dB (that is, all signal levels from 0dBFS to -60dBFS are accurately detected.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerLogShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits contain the power measurement duration used by the decimated power block. The power measurement duration in Rx sample periods is determined using the following equation:

 * dec power meas duration = 8 x 2^DPMD,  where DPMD  3:0   are the contents of these register bits.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerMeasurementDuration_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * These bits contain the power measurement duration used by the decimated power block. The power measurement duration in Rx sample periods is determined using the following equation:

 * dec power meas duration = 8 x 2^DPMD,  where DPMD  3:0   are the contents of these register bits.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerMeasurementDuration_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits contain the power measurement duration used for decimated power when AGC is in `state 5'. The power measurement duration in Rx sample periods is determined using the following equation: dec power meas duration = 8 x 2^DPS5MD, where DPS5MD  3:0   are the contents of these register bits.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerState5MeasurementDuration_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * These bits contain the power measurement duration used for decimated power when AGC is in `state 5'. The power measurement duration in Rx sample periods is determined using the following equation: dec power meas duration = 8 x 2^DPS5MD, where DPS5MD  3:0   are the contents of these register bits.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerState5MeasurementDuration_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register determines the number of cycles to wait between successive decimated power measurements. The number of cycles in Rx sample clocks are determined by: wait duration = dec_power_wait_delay * 32.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerWaitDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15), (value >> 0));

    return status;
}

/**
 * This register determines the number of cycles to wait between successive decimated power measurements. The number of cycles in Rx sample clocks are determined by: wait duration = dec_power_wait_delay * 32.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecPowerWaitDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecimatedDataOverloadSecondaryUpperThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c6), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5a), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_DecimatedDataOverloadSecondaryUpperThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c6), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpEn_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x134), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpEn_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x134), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpExponentBits_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x134), (value >> 0), 0x6, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpExponentBits_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x134), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpFloatDataFormat_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x134), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpFloatDataFormat_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x134), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpHideLeadingOnes_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x134), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpHideLeadingOnes_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x134), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpIntDataAtten_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x134), (value >> 0), 0xe0, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpIntDataAtten_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x134), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpNanEncEn_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x135), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpNanEncEn_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x135), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpRoundMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x135), (value >> 0), 0xe, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformFpRoundMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x135), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntDataFormat_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x135), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntDataFormat_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x135), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntDataResolution_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x135), (value >> 0), 0x60, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntDataResolution_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x135), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEmbedSlicer_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x136), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEmbedSlicer_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x136), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEmbedSlicerNumber_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x136), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEmbedSlicerNumber_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x136), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEmbedSlicerPos_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x136), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEmbedSlicerPos_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x136), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEvenParity_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntEvenParity_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntParitySupport_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformIntParitySupport_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformInvertRxI_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformInvertRxI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformInvertRxQ_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformInvertRxQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformMaskRxOutput_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x137), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformMaskRxOutput_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x137), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatI0_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x138), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatI0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x138), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatI1_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x139), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatI1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x139), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatI2_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13a), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatI2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatQ0_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13b), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatQ0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13b), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatQ1_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13c), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatQ1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13c), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatQ2_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13d), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DformRxMonFormatQ2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current digital DC offset words being used in the Rx datapath. Before reading this register, it is required to write "bbdc_update_tracking_word" to latch the readback data. By default, Ch1 words are available for readback. To read Ch2 words, "bbdc_readback_ch_select" must be set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DigitalDcOffsetTrackingCorrectionWordI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa9), &register_value, 0x3, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current digital DC offset words being used in the Rx datapath. Before reading this register, it is required to write "bbdc_update_tracking_word" to latch the readback data. By default, Ch1 words are available for readback. To read Ch2 words, "bbdc_readback_ch_select" must be set.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DigitalDcOffsetTrackingCorrectionWordQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa8), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa9), &register_value, 0xc, 0x2);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This register contains the readback value of the Ch1 digital gain. 

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DigitalGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x30), &register_value, 0xf, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DigitalPhaseDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a3), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_DigitalPhaseDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This register contains the readback value of the Ch1 Rx external control for band A. 

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DualbandControlBandA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x31), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Readback value of Ch1 Rx external gain for band A.

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_DualbandGainBandA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x31), &register_value, 0xfc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is decremented. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_EnableExtLnaSyncMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is decremented. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_EnableExtLnaSyncMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This register contains the readback value of the Ch1 external control.

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ExtControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2e), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ExtLnaSettlingDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x70), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ExtLnaSettlingDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x70), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is decremented. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_FeGainDelayDecr_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3a), (value >> 0));

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is decremented. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_FeGainDelayDecr_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is incremeneted. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_FeGainDelayIncr_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x39), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x38), (value >> 0));

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is incremeneted. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRxb_FeGainDelayIncr_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x39), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x38), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the the TIA control value in the gain table is ignored and the value from "gt_tia_control" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceAdcControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When set, the the TIA control value in the gain table is ignored and the value from "gt_tia_control" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceAdcControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the the digital gain value in the gain table is ignored and the value from "gt_digital_gain" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceDigitalGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When set, the the digital gain value in the gain table is ignored and the value from "gt_digital_gain" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceDigitalGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the dualband gain control and gain values in the gain table are ignored and the value from "gt_dualband_control_band_a"  and "gt_dualband_gain_band_a" registers are used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceDualbandControlAndGainBandA_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * When set, the dualband gain control and gain values in the gain table are ignored and the value from "gt_dualband_control_band_a"  and "gt_dualband_gain_band_a" registers are used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceDualbandControlAndGainBandA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the the ext control value in the gain table is ignored and the value from "gt_ext_control" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceExtControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * When set, the the ext control value in the gain table is ignored and the value from "gt_ext_control" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceExtControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the the phase offset value in the gain table is ignored and the value from "gt_phase_offset" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForcePhaseOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * When set, the the phase offset value in the gain table is ignored and the value from "gt_phase_offset" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForcePhaseOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the the Rx front end gain value in the gain table is ignored and the value from "gt_rx_front_end_gain" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceRxFeGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When set, the the Rx front end gain value in the gain table is ignored and the value from "gt_rx_front_end_gain" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceRxFeGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the the TIA control value in the gain table is ignored and the value from "gt_tia_control" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceTiaControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * When set, the the TIA control value in the gain table is ignored and the value from "gt_tia_control" register is used instead.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ForceTiaControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_FreqHopForceSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_FreqHopForceSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register allows a user to configure the duration of the high pulse generated when the gain on either the Rx1 or Rx2 channel is changed. The gain change pulse is generated when the gain on the respective channel is changed, either in automatic gain control mode or manual control. The pulse appears on the control out ports when the gain changes for either channel increases or decreases. The duration of the pulse is defined by this register, where one LSB corresponds to a single ADC divide-by-16 clock cycle.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GainChangePulseDuration_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x37), (value >> 0));

    return status;
}

/**
 * This register allows a user to configure the duration of the high pulse generated when the gain on either the Rx1 or Rx2 channel is changed. The gain change pulse is generated when the gain on the respective channel is changed, either in automatic gain control mode or manual control. The pulse appears on the control out ports when the gain changes for either channel increases or decreases. The duration of the pulse is defined by this register, where one LSB corresponds to a single ADC divide-by-16 clock cycle.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GainChangePulseDuration_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x37), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GainFifoMinWrIntvl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xea), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GainFifoMinWrIntvl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xea), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the initial analog attenuation for Tx1/Tx2 gain delay calibrations, and the intial Rx Fe Gain for the Rx1/Rx2 gain delay calibrations

 * HP Atten = Gain Delay Cal Analog Gain 1[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 1[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 1[5:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalAnaGain1_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16), (value >> 0));

    return status;
}

/**
 * This sets the initial analog attenuation for Tx1/Tx2 gain delay calibrations, and the intial Rx Fe Gain for the Rx1/Rx2 gain delay calibrations

 * HP Atten = Gain Delay Cal Analog Gain 1[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 1[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 1[5:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalAnaGain1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the final analog attenuation for Tx1/Tx2 gain delay calibrations, and the final Rx Fe Gain for the Rx1/Rx2 gain delay calibrations.

 * HP Atten = Gain Delay Cal Analog Gain 2[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 2[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 2[5:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalAnaGain2_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17), (value >> 0));

    return status;
}

/**
 * This register sets the final analog attenuation for Tx1/Tx2 gain delay calibrations, and the final Rx Fe Gain for the Rx1/Rx2 gain delay calibrations.

 * HP Atten = Gain Delay Cal Analog Gain 2[5:0]

 * LO Sel = Gain Delay Cal Analog Gain 2[7:6]

 * Fe Gain = Gain Delay Cal Analog Gain 2[5:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalAnaGain2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the initial digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 1[6:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalDigGain1_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18), (value >> 0));

    return status;
}

/**
 * This register sets the initial digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 1[6:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalDigGain1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the final digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 2[6:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalDigGain2_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x19), (value >> 0));

    return status;
}

/**
 * This register sets the final digital attenuation for Tx1/Tx2 gain delay calibrations. 

 * Tx attenuation = Gain delay cal digital gain 2[6:0]
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalDigGain2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the flush period of the gain delay calibration. The gain delay calibration data peak detectors are disabled during this period.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalFlushPeriod_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a), (value >> 0));

    return status;
}

/**
 * This register sets the flush period of the gain delay calibration. The gain delay calibration data peak detectors are disabled during this period.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalFlushPeriod_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GdcalInSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x60, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GdcalInSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables peak power detection I^2+Q^2 (=1) instead of I / Q peaks (=0) being compared against a threshold.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalPowerThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enables peak power detection I^2+Q^2 (=1) instead of I / Q peaks (=0) being compared against a threshold.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalPowerThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit starts Rx gain delay calibration. 

 * Setup:

 *     - Enable loopback mode from Tx1 to Rx1

 *     - Enable Tx1 NCO

 *     - Rx analog gain delay calibration

 *         o FE_GAIN = gdcal_ana_gain 1/2 

 *         o The data peak with gdcal_ana_gain1 should be below threshold

 *         o The data peak with gdcal_ana_gain2 should be above threshold

 *         o Digital attenuation should be minimum

 *  The calibration works as follows:

 *     1. FE_GAIN = gdcal_ana_gain1

 *     2. Wait for gdcal_flush_period

 *     3. FE_GAIN = gdcal_ana_gain2

 *     4. Start counter

 *     5. Wait for threshold to be met, incrementing counter

 *     6. When threshold is met, rx1_gdcal_ana_dig_delay = counter value.

 *     7. The bit is cleared when the calibration completes.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalStartRxCal_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit starts Rx gain delay calibration. 

 * Setup:

 *     - Enable loopback mode from Tx1 to Rx1

 *     - Enable Tx1 NCO

 *     - Rx analog gain delay calibration

 *         o FE_GAIN = gdcal_ana_gain 1/2 

 *         o The data peak with gdcal_ana_gain1 should be below threshold

 *         o The data peak with gdcal_ana_gain2 should be above threshold

 *         o Digital attenuation should be minimum

 *  The calibration works as follows:

 *     1. FE_GAIN = gdcal_ana_gain1

 *     2. Wait for gdcal_flush_period

 *     3. FE_GAIN = gdcal_ana_gain2

 *     4. Start counter

 *     5. Wait for threshold to be met, incrementing counter

 *     6. When threshold is met, rx1_gdcal_ana_dig_delay = counter value.

 *     7. The bit is cleared when the calibration completes.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalStartRxCal_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GdcalStartTxCal_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GdcalStartTxCal_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * number of samples that need to exceed threshold for gain delay cal, before threshold exceeded is asserted
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalStateReadback_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the peak detector threshold for the gain delay cal. For lower power inputs this value can be scaled down with gdcal_threshold_shift to get better resolution for the peak detect
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b), (value >> 0));

    return status;
}

/**
 * This register sets the peak detector threshold for the gain delay cal. For lower power inputs this value can be scaled down with gdcal_threshold_shift to get better resolution for the peak detect
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits can be used to shift the gain delay cal threshold to compare against lower power signals.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalThresholdShift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * These bits can be used to shift the gain delay cal threshold to compare against lower power signals.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalThresholdShift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_GdcalTxAnaDigDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x22), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x21), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_GdcalTxState_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * number of samples that need to exceed threshold for gain delay cal, before threshold exceeded is asserted
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalWindowSize_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * number of samples that need to exceed threshold for gain delay cal, before threshold exceeded is asserted
 */
static inline int32_t adrv9001_NvsRegmapRxb_GdcalWindowSize_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TIA control gain that is to be programmed in the gain table. Bit [0] is the TIA gain and bit [1] is the ADC gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtAdcControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * TIA control gain that is to be programmed in the gain table. Bit [0] is the TIA gain and bit [1] is the ADC gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtAdcControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Digital gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDigitalGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x27), (value >> 4), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Digital gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDigitalGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x27), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0xf, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandA_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a7), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Dualband external control gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x29), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Dualband external control gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x29), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Force value for band A dualband external control
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandControlBandA_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Force value for band A dualband external control
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandControlBandA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Dualband external gain that corresponds to the external control word. This information is used for RSSI, gain compensation etc. Resolution of 0.5db
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x29), (value >> 0), 0xfc, 0x2);

    return status;
}

/**
 * Dualband external gain that corresponds to the external control word. This information is used for RSSI, gain compensation etc. Resolution of 0.5db
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x29), &register_value, 0xfc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Force value for dualband band A external gain
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandGainBandA_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0xfc, 0x2);

    return status;
}

/**
 * Force value for dualband band A external gain
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtDualbandGainBandA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0xfc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * External control gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtExtControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * External control gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtExtControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Phase offset that is programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtPhaseOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2a), (value >> 0));

    return status;
}

/**
 * Phase offset that is programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtPhaseOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Front end gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtRxFeGain_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x25), (value >> 0));

    return status;
}

/**
 * Front end gain that is to be programmed in the gain table.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtRxFeGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x25), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TIA control gain that is to be programmed in the gain table. Bit [0] is the TIA gain and bit [1] is the ADC gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtTiaControl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * TIA control gain that is to be programmed in the gain table. Bit [0] is the TIA gain and bit [1] is the ADC gain.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtTiaControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this bit flags uncorrectable ecc errors in the gaintable ram. W1C
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtUncorrectableParityError_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * this bit flags uncorrectable ecc errors in the gaintable ram. W1C
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtUncorrectableParityError_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Gain Table Address captured where the ECC error occurred.
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtUncorrectableParityErrorAddr_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1be), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear the capture register for the AGC gain table parity error address. This is a self-clearing register.

 * 1= clear ECC address capture address

 * 0 = no operation
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtUncorrectableParityErrorAddrClear_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Clear the capture register for the AGC gain table parity error address. This is a self-clearing register.

 * 1= clear ECC address capture address

 * 0 = no operation
 */
static inline int32_t adrv9001_NvsRegmapRxb_GtUncorrectableParityErrorAddrClear_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_Hb2HighSrcSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_Hb2HighSrcSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_Hb2LowSrcSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0xe0, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_Hb2LowSrcSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_InvertApdLow_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_InvertApdLow_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx1DataSourceClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d0), (value >> 0));

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx1DataSourceClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherite from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx1DataSourceClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherite from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx1DataSourceClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx2DataSourceClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d2), (value >> 0));

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx2DataSourceClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherite from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx2DataSourceClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherite from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx2DataSourceClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx3DataSourceClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d5), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d4), (value >> 0));

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx3DataSourceClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherite from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx3DataSourceClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherite from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiOrx3DataSourceClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxDataSourceClkDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1cf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ce), (value >> 0));

    return status;
}

/**
 * (B0 New) Div ratio of the LVDS SSI data source clock from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxDataSourceClkDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1cf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ce), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxDataSourceClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock inherit from datapath, 1: LSSI data source clock inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxDataSourceClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock for DEBUG mode inherit from datapath, 1: LSSI data source clock for DEBUG mode inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxDataSourceDbgModeClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: LSSI data source clock for DEBUG mode inherit from datapath, 1: LSSI data source clock for DEBUG mode inherit from DivN from clk1105
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxDataSourceDbgModeClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to lssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxMaskStrobeEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable the Mask of the strobe according to lssi_rx_mask_strobe_value
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxMaskStrobeEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxMaskStrobeValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d8), (value >> 0));

    return status;
}

/**
 * (B0 New) N-1 Strobe over N will be masked (Used for SSI interpolation mode only)
 */
static inline int32_t adrv9001_NvsRegmapRxb_LssiRxMaskStrobeValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_NbdemCounter1ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_NbdemCounter1ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_NbdemNco50ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_NbdemNco50ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_NbdemResamplerClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_NbdemResamplerClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force ORX1 PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx1PfirXSelForce_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1da), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) force ORX1 PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx1PfirXSelForce_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1da), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx1PfirXSelValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1da), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx1PfirXSelValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1da), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force ORX2 PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx2PfirXSelForce_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1db), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) force ORX2 PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx2PfirXSelForce_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1db), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx2PfirXSelValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1db), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx2PfirXSelValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1db), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force ORX3 PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx3PfirXSelForce_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1db), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) force ORX3 PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx3PfirXSelForce_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1db), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx3PfirXSelValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1db), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_Orx3PfirXSelValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1db), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Ericsson Parallel Control Attenuator mode
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaGainControlMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x56), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Ericsson Parallel Control Attenuator mode
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaGainControlMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x56), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This 8-bit register selects the gain index based on target gain required. Can be varied for temperature compensation of gain (this is a shadow register and will only update front end attenuator on Talise when “Update Manual Mode Registers” is written to 1).
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaGainIndexOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x57), (value >> 0));

    return status;
}

/**
 * This 8-bit register selects the gain index based on target gain required. Can be varied for temperature compensation of gain (this is a shadow register and will only update front end attenuator on Talise when “Update Manual Mode Registers” is written to 1).
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaGainIndexOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x57), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This 5-bit register allows the user to configure the number of indices to jump by for every change in the LSB of the GPIO inputs. This register is also a shadow register and will only update internal digital logic when “Update Manual Mode Registers” is written to 1.
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaGainStep_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x58), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * This 5-bit register allows the user to configure the number of indices to jump by for every change in the LSB of the GPIO inputs. This register is also a shadow register and will only update internal digital logic when “Update Manual Mode Registers” is written to 1.
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaGainStep_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x58), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is a self-clearing bit. When written to 1, this bit will update the gain index offset and the gain step which will in turn update the GPIO selected gain. The front end attenuator will be updated at this time. This bit is provided for real time update of the gain offset due to temp compensation, or other reasons.
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaUpdateManualGainMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x56), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This bit is a self-clearing bit. When written to 1, this bit will update the gain index offset and the gain step which will in turn update the GPIO selected gain. The front end attenuator will be updated at this time. This bit is provided for real time update of the gain offset due to temp compensation, or other reasons.
 */
static inline int32_t adrv9001_NvsRegmapRxb_PcaUpdateManualGainMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x56), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This register contains the readback value of the Ch1 phase offset. 

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_PhaseOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x32), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x33), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, readback values are from the gain table. When clear, readback values are the current values being used in the datapath.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ReadGainTable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * When set, readback values are from the gain table. When clear, readback values are the current values being used in the datapath.
 */
static inline int32_t adrv9001_NvsRegmapRxb_ReadGainTable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RegLoadShadow_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RegLoadShadow_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ResetOnRxonGainIndex_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5c), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_ResetOnRxonGainIndex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcAdcRstMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcAdcRstMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcAdcovrldmask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcAdcovrldmask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcCalStart_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcCalStart_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcCorrDinI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10c), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcCorrDinQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcCorrDoutI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xae), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xad), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xac), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcCorrDoutQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb1), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb0), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xaf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcCorrWrDisable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x109), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcCorrWrDisable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcCtrlState_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcDcestDoutI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcDcestDoutQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcDecSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcDecSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrDoutIa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12a), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x129), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x128), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrDoutIb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrDoutQa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12d), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrDoutQb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x133), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x132), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x131), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrIa_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrIa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrIb_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfe), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfc), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrIb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfe), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfd), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrQa_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfb), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfa), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrQa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfb), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfa), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrQb_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x101), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x100), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xff), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcElpbckCorrQb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x101), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x100), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xff), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcEstBitselect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcEstBitselect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcEstBitselectLoid_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe6), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcEstBitselectLoid_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcEstDone_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFegainSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a5), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFegainSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a5), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFfhMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFfhMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceAhbA_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceAhbA_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceAhbB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18a), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceAhbB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceFsBitsel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceFsBitsel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceIdac_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForceIdac_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForgetFac_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xcf), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcForgetFac_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xcf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFreeze_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFreeze_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFsBitsel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFsBitsel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFsBitselB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcFsBitselB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcGainctrl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xba), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcGainindex_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xba), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcGtIndexOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x102), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcGtIndexOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x102), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIcal_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIcal_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIcalBypass_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIcalBypass_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIcalIndexSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbb), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIcalIndexSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbb), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacIForced_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd6), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd5), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacIForced_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd6), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacIForcedB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacIForcedB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbf), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacQForced_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd7), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacQForced_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacQForcedB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdb), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIdacQForcedB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcIirCorrI_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x104), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x103), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcIirCorrQ_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x108), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x107), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x106), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIndexOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIndexOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIndexSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a5), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcIndexSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcInitDone_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Invert I channel spectrum sent to idac_i. The 21-bit DC correction after the mux [rx, orx, ilb, elb] is 2s complemented.

 * 0 = no invert

 * 1 = invert I channel spectrum
 */
static inline int32_t adrv9001_NvsRegmapRxb_RfdcInvertISpectrum_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Invert I channel spectrum sent to idac_i. The 21-bit DC correction after the mux [rx, orx, ilb, elb] is 2s complemented.

 * 0 = no invert

 * 1 = invert I channel spectrum
 */
static inline int32_t adrv9001_NvsRegmapRxb_RfdcInvertISpectrum_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Invert Q channel spectrum sent to idac_q. The 21-bit DC correction after the mux [rx, orx, ilb, elb] is 2s complemented.

 * 0 = no invert

 * 1 = invert Q channel spectrum
 */
static inline int32_t adrv9001_NvsRegmapRxb_RfdcInvertQSpectrum_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Invert Q channel spectrum sent to idac_q. The 21-bit DC correction after the mux [rx, orx, ilb, elb] is 2s complemented.

 * 0 = no invert

 * 1 = invert Q channel spectrum
 */
static inline int32_t adrv9001_NvsRegmapRxb_RfdcInvertQSpectrum_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidEn_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidEn_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidFifoStatus_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidIntvl_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd4), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidIntvl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd4), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xec), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xed), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xee), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog3_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xef), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog4_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf0), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog5_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf1), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog6_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf2), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLog7_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf3), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLthld_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidLthld_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidUthld_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe8), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLoidUthld_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe8), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrDoutIa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11e), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrDoutIb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x124), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x123), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x122), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrDoutQa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x121), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x120), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrDoutQb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x127), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x126), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x125), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrIa_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18d), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrIa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18d), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrIb_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x190), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrIb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x190), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrQa_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x193), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x192), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x191), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrQa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x193), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x192), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x191), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrQb_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x196), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x195), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x194), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLpbckCorrQb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x196), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x195), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x194), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLthld_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdd), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcLthld_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMaxGainindx_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xde), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMaxGainindx_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xde), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMemrst_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd4), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMemrst_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMinGainindx_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdf), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMinGainindx_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdf), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMthld_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe0), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcMthld_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcNthld_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe1), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcNthld_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe1), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOpmode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd4), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOpmode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrDoutIa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x112), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x111), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x110), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrDoutIb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x118), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x117), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x116), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrDoutQa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x115), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x114), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x113), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrDoutQb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x119), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrIa_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x198), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x197), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrIa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x198), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x197), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrIb_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19c), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x19b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x19a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrIb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19c), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrQa_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19f), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x19e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x19d), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrQa_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrQb_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a2), (value >> 16), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1a0), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcOrxCorrQb_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a2), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a1), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1a0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcPauseResumeMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xeb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcPauseResumeMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xeb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSoftRst_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd4), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSoftRst_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiAccessSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiAccessSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiAccessSelB_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc7), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiAccessSelB_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiAddr_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc8), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiAddr_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc8), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiDataIn_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint64_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xce), (value >> 40));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xcd), (value >> 32));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xcc), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xcb), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xca), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiDataIn_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xce), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xcd), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xcc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xcb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xca), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiDataOut_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc5), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc2), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiRd_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiRd_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiWr_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcSpiWr_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcStart_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcStart_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Update mode to DC tables and/or [orx, ILB, ELB] correction registers. Note all update modes must be qualifies with LOID allowing write to occur.

 * 00 = only update immediate on DC estimation complete

 * 01 = only update when agc_gain_change

 * 10 = only update on falling edge rxon

 * 11=
 */
static inline int32_t adrv9001_NvsRegmapRxb_RfdcUpdateMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xeb), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * (B0 New) Update mode to DC tables and/or [orx, ILB, ELB] correction registers. Note all update modes must be qualifies with LOID allowing write to occur.

 * 00 = only update immediate on DC estimation complete

 * 01 = only update when agc_gain_change

 * 10 = only update on falling edge rxon

 * 11=
 */
static inline int32_t adrv9001_NvsRegmapRxb_RfdcUpdateMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xeb), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcUthld_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe2), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcUthld_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcViScaling_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe5), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe4), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcViScaling_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcWthld_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe3), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcWthld_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcoLoidBypass_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RfdcoLoidBypass_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, normal RSSI measurement duration is used.  When clear,

 * the extended measurement duration is triggered and the duration is determined

 * as described in registers "rssi_measurement_duration_0 through _3"
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiDefaultMode_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When set, normal RSSI measurement duration is used.  When clear,

 * the extended measurement duration is triggered and the duration is determined

 * as described in registers "rssi_measurement_duration_0 through _3"
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiDefaultMode_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register configures the RSSI block to wait for the configured duration

 * for before kicking off an RSSI measurement.  The RSSI measurement is enabled

 * by writing to "rssi_enable_meas" register.  The duration is specified in output sample rate clock cycles (clkRout rate).
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd), (value >> 0));

    return status;
}

/**
 * This register configures the RSSI block to wait for the configured duration

 * for before kicking off an RSSI measurement.  The RSSI measurement is enabled

 * by writing to "rssi_enable_meas" register.  The duration is specified in output sample rate clock cycles (clkRout rate).
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables RSSI measurement according to the mode set in "rssi_mode_select" register.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiEnableMeas_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enables RSSI measurement according to the mode set in "rssi_mode_select" register.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiEnableMeas_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 00: RFIR, 01: Dualband Band A 10: Dualband Band B 11: RFIR
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiInputSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * 00: RFIR, 01: Dualband Band A 10: Dualband Band B 11: RFIR
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiInputSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the log block input is shifted to give an accuracy over a greater range. This shift is corrected after the log block. Set this bit for improving accuracy below -40dB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiLogshift_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * When set, the log block input is shifted to give an accuracy over a greater range. This shift is corrected after the log block. Set this bit for improving accuracy below -40dB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiLogshift_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is set, these bits set the measurement

 * duration for the RSSI calculation.  In this case, the measurement duration is: RSSI duration=2^avrg0 where avrg0 is the value written in these bits.

 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  If the weighting is non zero, then the measurement duration is the sum of each measurement duration as a power of two.  That is, if all four weights are used, the duration will be:

 * RSSI duration=2^avrg0+2^avrg1+2^avrg2+2^avrg3

 * If any of the corresponding weights are set to zero, then that term is removed from the equation.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration0_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * When "rssi_default_mode" is set, these bits set the measurement

 * duration for the RSSI calculation.  In this case, the measurement duration is: RSSI duration=2^avrg0 where avrg0 is the value written in these bits.

 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  If the weighting is non zero, then the measurement duration is the sum of each measurement duration as a power of two.  That is, if all four weights are used, the duration will be:

 * RSSI duration=2^avrg0+2^avrg1+2^avrg2+2^avrg3

 * If any of the corresponding weights are set to zero, then that term is removed from the equation.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  See the description for "rssi_measurement_duration_0" for more details.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration1_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  See the description for "rssi_measurement_duration_0" for more details.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  See the description for "rssi_measurement_duration_0" for more details.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration2_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  See the description for "rssi_measurement_duration_0" for more details.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  See the description for "rssi_measurement_duration_0" for more details.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration3_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  See the description for "rssi_measurement_duration_0" for more details.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiMeasurementDuration3_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the method for enabling the RSSI measurement according to the following options. The RSSI Algorithm will (re)start when: 000 --  AGC in fast attack mode locks the gain 001 --  EN_AGC pin is pulled high 010 --  Device enters Rx mode 011 --  Gain change occurs 100 --  SPI write to 0x4C6[D1] 101 --  Gain change occurs OR EN_AGC pin pulled high
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiModeSelect_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * These bits set the method for enabling the RSSI measurement according to the following options. The RSSI Algorithm will (re)start when: 000 --  AGC in fast attack mode locks the gain 001 --  EN_AGC pin is pulled high 010 --  Device enters Rx mode 011 --  Gain change occurs 100 --  SPI write to 0x4C6[D1] 101 --  Gain change occurs OR EN_AGC pin pulled high
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiModeSelect_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This is the offset for RSSI power calculation. This value is subtracted from the power calculated. The net effect is to add a -ve offset (move the scale in negative direction). Resolution of 1dB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0xfe, 0x1);

    return status;
}

/**
 * This is the offset for RSSI power calculation. This value is subtracted from the power calculated. The net effect is to add a -ve offset (move the scale in negative direction). Resolution of 1dB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0xfe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * The first Ch1 RSSI calculated afther RSSI is enabled or the first RSSI after RXON goes high. It is the same as Ch1 RSSI Symbol except that it does not get updated during successive RSSI durations. Resolution is 0.25dB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiPreamble_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x4, 0x2);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Ch1 RSSI calculated for each RSSI duration.  This value is updated after every measurement interval.  Resolution is 0.25dB.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiSymbol_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x1, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register specifies the duration in output sample rate cycles between consecutive RSSI measurements.  The RSSI block makes measurements on a continuous basis.  The measurement may be required to start off at the start of a time slot or a half frame.  For example, a UMTS frame (2560 chipsx10 time slots) can be configured to provide an RSSI measurement every time slot boundary by configuring the RSSI measurement duration to 2048 samples and the wait time to 512 samples.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWaitTime_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 8), 0x18, 0x3);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe), (value >> 0));

    return status;
}

/**
 * This register specifies the duration in output sample rate cycles between consecutive RSSI measurements.  The RSSI block makes measurements on a continuous basis.  The measurement may be required to start off at the start of a time slot or a half frame.  For example, a UMTS frame (2560 chipsx10 time slots) can be configured to provide an RSSI measurement every time slot boundary by configuring the RSSI measurement duration to 2048 samples and the wait time to 512 samples.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWaitTime_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 0 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier0_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9), (value >> 0));

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 0 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 1 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier1_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa), (value >> 0));

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 1 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 2 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier2_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb), (value >> 0));

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 2 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 3 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier3_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc), (value >> 0));

    return status;
}

/**
 * When "rssi_default_mode" is clear, the extended measurement mode is triggered and the measurement length is set by averaging durations with weighted multipliers.  The weight for duration 3 is programmed into this register and is determined using the following equation:

 * Weight 0=2552^avrg0/(RSSI duration)

 * The total of all weights (rssi_weighted_multiplier_0 through _3) must be 0xFF.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RssiWeightedMultiplier3_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * First Band / Single band datapath - Enable
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxBandAEnable_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * First Band / Single band datapath - Enable
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxBandAEnable_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxDpGainComp9ResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxDpGainComp9ResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This register contains the readback value of the Ch1 Rx front end gain.

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxFeGain_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a read only field and returns the delay value of Rx1/Tx1 gain delay calibrations
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxGdcalAnaDigDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxNbwbSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxNbwbSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxNco13ClkReset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxNco13ClkReset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxNco13ClkResetbMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxNco13ClkResetbMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force RX PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxPfirXSelForce_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1da), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) force RX PFIR_X source selection 0: from datapath, 1: from SPI
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxPfirXSelForce_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1da), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxPfirXSelValue_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1da), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * (B0 New) Select RX_PFIR_X_SEL (0:1x, 1:2x, 2:4x, 3:4x)
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxPfirXSelValue_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1da), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxTiaProfile_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x59), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxTiaProfile_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x59), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxTiaProfileVal_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x59), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxTiaProfileVal_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x59), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 : 3 cycle delay for valid signal, 1: 2 cycle delay for valid signal
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxfeValidDelay_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0 : 3 cycle delay for valid signal, 1: 2 cycle delay for valid signal
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxfeValidDelay_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This setting overrides the delayed update feature for setting Rx1 FE gain. Setting this field allows new values of Rx1 FE gains to be effective as soon as they are output from the gain table. This setting may cause spurious overloads on the ADC until gains to all block before the ADC (Rx1 FE, Rx1 TIA) have settled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxfeValidOverride_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This setting overrides the delayed update feature for setting Rx1 FE gain. Setting this field allows new values of Rx1 FE gains to be effective as soon as they are output from the gain table. This setting may cause spurious overloads on the ADC until gains to all block before the ADC (Rx1 FE, Rx1 TIA) have settled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_RxfeValidOverride_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxfuncGainCompInSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxfuncGainCompInSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxfuncSlicerInSel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_RxfuncSlicerInSel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SlicerPositionOffset_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xab), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SlicerPositionOffset_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xab), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare0_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1aa), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare0_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1aa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare1_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ab), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare1_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ab), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare10_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b4), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare10_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare11_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b5), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare11_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare12_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b6), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare12_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare13_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b7), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare13_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare14_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b8), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare14_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare15_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b9), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare15_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare16_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ba), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare16_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ba), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare17_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1bb), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare17_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1bb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare18_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1bc), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare18_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1bc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare19_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1bd), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare19_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1bd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare2_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ac), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare2_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ac), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare3_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ad), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare3_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ad), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare4_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ae), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare4_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ae), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare5_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1af), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare5_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1af), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare6_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b0), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare6_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare7_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b1), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare7_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare8_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b2), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare8_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare9_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1b3), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SoftwareSpare9_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1b3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SpiRfdcLnapFreezeMask_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_SpiRfdcLnapFreezeMask_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * TIA control readback for Ch1. Bit[0] is TIA gain and bit [1] is ADC gain.

 * If "read_gain_table" is set, the value is read back from the gain table corresponding to the "gt_addr". If "read_gain_table" is clear,the value is the current gain being used.
 */
static inline int32_t adrv9001_NvsRegmapRxb_TiaControl_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x30), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This setting overrides the delayed update feature for setting Rx1 TIA gain. Setting this field allows new values of Rx1 TIA gains to be effective as soon as they are output from the gain table. This setting may cause spurious overloads on the ADC until gains to all block before the ADC (Rx1 FE, Rx1 TIA) have settled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_TiaValidOverride_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * This setting overrides the delayed update feature for setting Rx1 TIA gain. Setting this field allows new values of Rx1 TIA gains to be effective as soon as they are output from the gain table. This setting may cause spurious overloads on the ADC until gains to all block before the ADC (Rx1 FE, Rx1 TIA) have settled.
 */
static inline int32_t adrv9001_NvsRegmapRxb_TiaValidOverride_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_UseGainIndexFromAnotherChannel_Set(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRxb_UseGainIndexFromAnotherChannel_Get(void *device,
    adrv9001_BfNvsRegmapRxb_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_RXB_H__