/**
 * \file
 * \brief BitField accessors for nvs_regmap_rx
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_RX_H__
 #define __ADRV9001_BF_NVS_REGMAP_RX_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfNvsRegmapRx_e
{
    ADRV9001_BF_RX1_CORE    =   0xe00,
    ADRV9001_BF_RX2_CORE    =   0x1200
} adrv9001_BfNvsRegmapRx_e;

static const adrv9001_BfNvsRegmapRx_e nvsRegmapRxInstances[] = {
    ADRV9001_BF_RX1_CORE,
    ADRV9001_BF_RX2_CORE
};

static inline int32_t adrv9001_NvsRegmapRx_RCDriveIZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RCDriveIZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RCDriveQZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RCDriveQZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RCDriveSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x172), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RCDriveSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x172), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RKCaptureISel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x171), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RKCaptureISel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x171), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RKCaptureIq16bitSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x171), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RKCaptureIq16bitSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x171), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcCaptSampleSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcCaptSampleSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcCaptureISel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcCaptureISel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcCaptureEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcCaptureEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * adc1_clock_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcClockEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x170), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * adc1_clock_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcClockEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x170), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: clock ADC demux OFF, 1: clock ADC demux ON
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcDemuxClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: clock ADC demux OFF, 1: clock ADC demux ON
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcDemuxClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enables ADC overload reset detector accumulators and to generate adc_overlod_reset to ADC and AGC.

 * 1 = enabled

 * 0 = disabled, accumulators and overload_reset output held = zero
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcOverloadResetEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1eb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enables ADC overload reset detector accumulators and to generate adc_overlod_reset to ADC and AGC.

 * 1 = enabled

 * 0 = disabled, accumulators and overload_reset output held = zero
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcOverloadResetEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1eb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * adc_rx_sample_delay
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcRxSampleDelay_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3f), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * adc_rx_sample_delay
 */
static inline int32_t adrv9001_NvsRegmapRx_AdcRxSampleDelay_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3f), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AgcEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x175), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AgcEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x175), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDPinFIFODontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDPinFIFODontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDPinFIFOSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDPinFIFOSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDpDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd5), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDpDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDpSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd5), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemDpSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemRxpfir52DontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd5), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemRxpfir52DontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemRxpfir52SwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd5), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbdemRxpfir52SwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbficDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgNbficDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgRxChFuncsDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x164), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgRxChFuncsDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x164), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgSlicerRssiDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x164), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AlgSlicerRssiDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x164), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AllRxEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_AllRxEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Disable LVDS clock from analog, 1: Enable LVDS clock from analog
 */
static inline int32_t adrv9001_NvsRegmapRx_AnaLssiClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Disable LVDS clock from analog, 1: Enable LVDS clock from analog
 */
static inline int32_t adrv9001_NvsRegmapRx_AnaLssiClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Spare o2a bits
 */
static inline int32_t adrv9001_NvsRegmapRx_AnalogSpare_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15f), (value >> 0));

    return status;
}

/**
 * Spare o2a bits
 */
static inline int32_t adrv9001_NvsRegmapRx_AnalogSpare_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: group_1_184 clock , 1: ARM clock
 */
static inline int32_t adrv9001_NvsRegmapRx_ArmOrGroup1184ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ec), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: group_1_184 clock , 1: ARM clock
 */
static inline int32_t adrv9001_NvsRegmapRx_ArmOrGroup1184ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ec), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_BbdcEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x175), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_BbdcEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x175), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When high the CLKGEN sample and interface clock buffers for this slice is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRx_ClkgenOutputBufferEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x161), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When high the CLKGEN sample and interface clock buffers for this slice is enabled.
 */
static inline int32_t adrv9001_NvsRegmapRx_ClkgenOutputBufferEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x161), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register selects which set of bits will be monitored by the control output bits when they are assigned to GPIO pins. See the document for Control output pins for more information on the signals.
 */
static inline int32_t adrv9001_NvsRegmapRx_ControlOutMuxSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x173), (value >> 0));

    return status;
}

/**
 * This register selects which set of bits will be monitored by the control output bits when they are assigned to GPIO pins. See the document for Control output pins for more information on the signals.
 */
static inline int32_t adrv9001_NvsRegmapRx_ControlOutMuxSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x173), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bit[0]  1:  output correlator vector 1. 0: disable correlator vector 1

 * Bit[1]  1: output correlator vector 2, 0: disable correlator vector 2

 *         ….

 * Bit[15] 1: output correlator vector 16, 0: disable correlator vector 16
 */
static inline int32_t adrv9001_NvsRegmapRx_CorrCtrl_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9e), (value >> 0));

    return status;
}

/**
 * Bit[0]  1:  output correlator vector 1. 0: disable correlator vector 1

 * Bit[1]  1: output correlator vector 2, 0: disable correlator vector 2

 *         ….

 * Bit[15] 1: output correlator vector 16, 0: disable correlator vector 16
 */
static inline int32_t adrv9001_NvsRegmapRx_CorrCtrl_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX data_format
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDataFormat_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * CMOS RX data_format
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDataFormat_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX data_format_four_lanes
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDataFormatFourLanes_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS RX data_format_four_lanes
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDataFormatFourLanes_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxDdrClkInv_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxDdrClkInv_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxDdrPosClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxDdrPosClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxDdrSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxDdrSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_inject_error
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugInjectError_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * CMOS RX debug_inject_error
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugInjectError_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_load
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugLoad_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS RX debug_load
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugLoad_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: 16 bits RAMP & SHIFT debug mode, 1: 4 bits RAMP & SHIFT mode
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugLoad4bitsMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: 16 bits RAMP & SHIFT debug mode, 1: 4 bits RAMP & SHIFT mode
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugLoad4bitsMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_load_value
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugLoadValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * CMOS RX debug_load_value
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugLoadValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS RX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_nibble_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugNibbleSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * CMOS RX debug_nibble_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugNibbleSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugQSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * CMOS RX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugQSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugStartRamp_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * CMOS RX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugStartRamp_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugStartShift_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * CMOS RX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxDebugStartShift_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX enable
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * CMOS RX enable
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxForceDataValid_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxForceDataValid_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxInvertClk_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_CssiRxInvertClk_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxLongStrobe_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * CMOS RX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxLongStrobe_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX loopback from TX1
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxLoopbackFromTx_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * CMOS RX loopback from TX1
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxLoopbackFromTx_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxLsbFirst_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * CMOS RX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxLsbFirst_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * CMOS RX q_first
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxQFirst_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * CMOS RX q_first
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxQFirst_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable the strobe at the SSI interface for CMOS mode
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxStrobeEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable the strobe at the SSI interface for CMOS mode
 */
static inline int32_t adrv9001_NvsRegmapRx_CssiRxStrobeEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_DataCaptureDriveEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x172), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_DataCaptureDriveEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x172), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_DdcLoSyncEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x176), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_DdcLoSyncEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x176), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is incremeneted. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRx_DigGainCompOffset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16d), (value >> 0));

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is incremeneted. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRx_DigGainCompOffset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When the digital gain index is changed, the digital gain applied on the Rx datapath changes. The digital gain delay controls the duration after which the digital gain is applied on the Rx datapath once the gain index is changed. This delay is given in number of Rout clock cycles.
 */
static inline int32_t adrv9001_NvsRegmapRx_DigitalGainDelay_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x166), (value >> 0));

    return status;
}

/**
 * When the digital gain index is changed, the digital gain applied on the Rx datapath changes. The digital gain delay controls the duration after which the digital gain is applied on the Rx datapath once the gain index is changed. This delay is given in number of Rout clock cycles.
 */
static inline int32_t adrv9001_NvsRegmapRx_DigitalGainDelay_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x166), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable digital gain on the Rx datapath. The gain has a range of -18db to +41.95 dB in 0.05dB steps and is selected by the digital gain index for the desired receive channel based found in the Rx Gain Table registers
 */
static inline int32_t adrv9001_NvsRegmapRx_DigitalGainEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x167), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable digital gain on the Rx datapath. The gain has a range of -18db to +41.95 dB in 0.05dB steps and is selected by the digital gain index for the desired receive channel based found in the Rx Gain Table registers
 */
static inline int32_t adrv9001_NvsRegmapRx_DigitalGainEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x167), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: output armfifo data, 0: output datapath rxround data
 */
static inline int32_t adrv9001_NvsRegmapRx_DparmSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: output armfifo data, 0: output datapath rxround data
 */
static inline int32_t adrv9001_NvsRegmapRx_DparmSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: clear the DPinFIFO write/read pointer
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoClear_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 1: clear the DPinFIFO write/read pointer
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoClear_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: The signal is detected 0: non-detected.
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDetected_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 1: The signal is detected 0: non-detected.
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDetected_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 11bit unsigned data. Update the DPinFIFO read pointer. new read pointer value=write pointer - dpinfifo_diffabs_config. used with dpinfifo_diffabs_update
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffabsConfig_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb7), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb6), (value >> 0));

    return status;
}

/**
 * (B0 New) 11bit unsigned data. Update the DPinFIFO read pointer. new read pointer value=write pointer - dpinfifo_diffabs_config. used with dpinfifo_diffabs_update
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffabsConfig_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb7), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Read pointer location update signal
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffabsUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Read pointer location update signal
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffabsUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 11bit unsigned data. Update DPinFIFO read pointer. new read pointer value = read pointer + dpinfifo_diffbp_config. Used together with dpinfifo_diffbp_update
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffbpConfig_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb9), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb8), (value >> 0));

    return status;
}

/**
 * (B0 New) 11bit unsigned data. Update DPinFIFO read pointer. new read pointer value = read pointer + dpinfifo_diffbp_config. Used together with dpinfifo_diffbp_update
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffbpConfig_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb9), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Read pointer location update signal
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffbpUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Read pointer location update signal
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoDiffbpUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (in B0 only) DPinFIFO read address offset value compared to read address when the FIFO is full.

 *             When RDCLK=2x/4x/8x of WRCLK,  use default value.

 *             When RDCLK=WRCLK,  set this value to 5.
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoRdAddrOffset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb5), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * (in B0 only) DPinFIFO read address offset value compared to read address when the FIFO is full.

 *             When RDCLK=2x/4x/8x of WRCLK,  use default value.

 *             When RDCLK=WRCLK,  set this value to 5.
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoRdAddrOffset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb5), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: DPinFIFO read request  0: no read request
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoRdStartstop_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 1: DPinFIFO read request  0: no read request
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoRdStartstop_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rxnb_dem test pattern update, self cleared
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestDataUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Rxnb_dem test pattern update, self cleared
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestDataUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rxnb_dem test pattern I.
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestdataI_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb0), (value >> 24), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xaf), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xae), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xad), (value >> 0));

    return status;
}

/**
 * Rxnb_dem test pattern I.
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestdataI_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb0), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xaf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xae), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xad), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rxnb_dem test pattern Q. Write I data first, then write Q data, used together with dpinfifo_test_data_update
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestdataQ_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb4), (value >> 24), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb3), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb1), (value >> 0));

    return status;
}

/**
 * Rxnb_dem test pattern Q. Write I data first, then write Q data, used together with dpinfifo_test_data_update
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestdataQ_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb4), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb2), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: select test pattern. 0: select datapath data
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestdataSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb5), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 1: select test pattern. 0: select datapath data
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoTestdataSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: DpinFIFO write request  0: no write request
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoWrStartstop_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 1: DpinFIFO write request  0: no write request
 */
static inline int32_t adrv9001_NvsRegmapRx_DpinfifoWrStartstop_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is incremeneted. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRx_ExtLnaDigitalGainDelay_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16c), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16b), (value >> 0));

    return status;
}

/**
 * initializes the counter that needs to count down to 0 before the fe_gain is changed. this counter needs to run when a new fe_gain word is obtained from the gain table and the external lna gain is incremeneted. this new word triggers start of the fe_gain_delay counter. if the counter is currently running , then the counter gets re-initialized to the FE_gain_delay value and the new fe_gain is applied when the counter actually expires.
 */
static inline int32_t adrv9001_NvsRegmapRx_ExtLnaDigitalGainDelay_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_ExtlpbkRxqecObsCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_ExtlpbkRxqecObsCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * select different pipeline delay data for frequency discriminator input. 3'b000: one pipe delay. 3'b001: 2 pipe delay. 3'b010: 3 pipe delay. 3'b011: 4 pipe delay. 3'b100: 5 pipe delay. 3'b101: 6 pipe delay
 */
static inline int32_t adrv9001_NvsRegmapRx_FdInSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xba), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * select different pipeline delay data for frequency discriminator input. 3'b000: one pipe delay. 3'b001: 2 pipe delay. 3'b010: 3 pipe delay. 3'b011: 4 pipe delay. 3'b100: 5 pipe delay. 3'b101: 6 pipe delay
 */
static inline int32_t adrv9001_NvsRegmapRx_FdInSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xba), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 2'b00: diffarc 2'b01: arcdiff  2'b10: phdiff_out, 2'b11: diffarc
 */
static inline int32_t adrv9001_NvsRegmapRx_FdModeSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xba), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * 2'b00: diffarc 2'b01: arcdiff  2'b10: phdiff_out, 2'b11: diffarc
 */
static inline int32_t adrv9001_NvsRegmapRx_FdModeSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xba), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Frequency discriminator limiter threshold1. If the signal absolute value is greater than this threshold but less than threshold 2, limit the output value to threshold 1 or -threshold 1, depends on signal sign
 */
static inline int32_t adrv9001_NvsRegmapRx_Fdmax1_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 16), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbc), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbb), (value >> 0));

    return status;
}

/**
 * Frequency discriminator limiter threshold1. If the signal absolute value is greater than this threshold but less than threshold 2, limit the output value to threshold 1 or -threshold 1, depends on signal sign
 */
static inline int32_t adrv9001_NvsRegmapRx_Fdmax1_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Frequency discriminator limiter threshold 2, if signal absolute value is greater than this value, limit the output to ZERO
 */
static inline int32_t adrv9001_NvsRegmapRx_Fdmax2_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc0), (value >> 16), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbe), (value >> 0));

    return status;
}

/**
 * Frequency discriminator limiter threshold 2, if signal absolute value is greater than this value, limit the output to ZERO
 */
static inline int32_t adrv9001_NvsRegmapRx_Fdmax2_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc0), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_FicObsCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_FicObsCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_FlashClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_FlashClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Force ARM clock on Glitch free Mux arm_or_group_1_184_clk_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_ForceArmClkOnArmOrGroup1184ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ec), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Force ARM clock on Glitch free Mux arm_or_group_1_184_clk_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_ForceArmClkOnArmOrGroup1184ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ec), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * indicates overflow on gain change fifo, W1C
 */
static inline int32_t adrv9001_NvsRegmapRx_ForceDigGainStrobe_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x168), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * indicates overflow on gain change fifo, W1C
 */
static inline int32_t adrv9001_NvsRegmapRx_ForceDigGainStrobe_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x168), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Force group_1_184 Clock on Glitch free Mux arm_or_group_1_184_clk_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_ForceGroup1ClkOnArmOrGroup1184ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ec), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Force group_1_184 Clock on Glitch free Mux arm_or_group_1_184_clk_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_ForceGroup1ClkOnArmOrGroup1184ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ec), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits configure the number of clock cycles (clkRout cycles) for each step (set by gain_change_ramp_steps) in the ramp that is used to compensate for the Rx front end gain.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainChangeRampStepDuration_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x168), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * These bits configure the number of clock cycles (clkRout cycles) for each step (set by gain_change_ramp_steps) in the ramp that is used to compensate for the Rx front end gain.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainChangeRampStepDuration_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x168), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits configure the number of total steps in the ramp between initial and final gain that is generated according to the following settings.

 * 00      1 step          ( initial -  final )

 * 01      2 steps         ( initial -  intermediate   -  final )

 * 10      4 steps         ( initial -  intermediate 1 -  intermediate 2 -  intermediate 3 -  final )

 * 11      8 steps         ( initial -  intermediate 1 -      ....       -  intermediate 7 -  final )
 */
static inline int32_t adrv9001_NvsRegmapRx_GainChangeRampSteps_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x168), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * These bits configure the number of total steps in the ramp between initial and final gain that is generated according to the following settings.

 * 00      1 step          ( initial -  final )

 * 01      2 steps         ( initial -  intermediate   -  final )

 * 10      4 steps         ( initial -  intermediate 1 -  intermediate 2 -  intermediate 3 -  final )

 * 11      8 steps         ( initial -  intermediate 1 -      ....       -  intermediate 7 -  final )
 */
static inline int32_t adrv9001_NvsRegmapRx_GainChangeRampSteps_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x168), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * In dualband mode, setting this bit causes gain compensation to use the largest of 

 * the slicer values from both bands as the common slicer value, and slices both bands

 * with this value. The common slicer value can be observed on GPIO or in the data if

 * the slicer value has been embedded into the data stream.

 * 

 * If disabled, and both bands are enabled, the bands are compensated

 * independently but then they cannot be combined using rx_dualband_on_band_a or

 * rx_dualband_on_band_b since they may be normalized differently. GPIO's cannot

 * be used to observe slicer values here. The slicer values can be observed only

 * though the floating point format or through slicer values embedded in the data.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainCompDualbandCommon_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * In dualband mode, setting this bit causes gain compensation to use the largest of 

 * the slicer values from both bands as the common slicer value, and slices both bands

 * with this value. The common slicer value can be observed on GPIO or in the data if

 * the slicer value has been embedded into the data stream.

 * 

 * If disabled, and both bands are enabled, the bands are compensated

 * independently but then they cannot be combined using rx_dualband_on_band_a or

 * rx_dualband_on_band_b since they may be normalized differently. GPIO's cannot

 * be used to observe slicer values here. The slicer values can be observed only

 * though the floating point format or through slicer values embedded in the data.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainCompDualbandCommon_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables internal slicer gain compensation to also consider the compensation for dualband external LNA gain.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainCompForExtGain_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit enables internal slicer gain compensation to also consider the compensation for dualband external LNA gain.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainCompForExtGain_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables internal slicer gain compensation to also consider the compensation for temperature gain.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainCompForTempGain_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit enables internal slicer gain compensation to also consider the compensation for temperature gain.
 */
static inline int32_t adrv9001_NvsRegmapRx_GainCompForTempGain_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Hd2ObsCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Hd2ObsCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntDelay0Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x178), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntDelay0Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x178), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntDelay1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x178), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntDelay1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x178), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntOrxEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x178), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntOrxEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x178), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntRxEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x178), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntRxEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x178), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntlpbkRxqecObsCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_IntlpbkRxqecObsCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX clk_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxClkInversion_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * LVDS RX clk_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxClkInversion_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX data_format_12bit
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDataFormat12bit_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS RX data_format_12bit
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDataFormat12bit_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX data_one_lane
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDataOneLane_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS RX data_one_lane
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDataOneLane_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_inject_error
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugInjectError_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS RX debug_inject_error
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugInjectError_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_load
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugLoad_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS RX debug_load
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugLoad_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_load_value
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugLoadValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15), (value >> 0));

    return status;
}

/**
 * LVDS RX debug_load_value
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugLoadValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS RX debug_mode
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_prbs15_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs15Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS RX debug_prbs15_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs15Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_prbs15_restart
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs15Restart_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS RX debug_prbs15_restart
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs15Restart_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_prbs7_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs7Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS RX debug_prbs7_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs7Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_prbs7_restart
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs7Restart_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LVDS RX debug_prbs7_restart
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs7Restart_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_prbs7_swap_odd_even
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs7SwapOddEven_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * LVDS RX debug_prbs7_swap_odd_even
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugPrbs7SwapOddEven_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugQSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS RX debug_q_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugQSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugStartRamp_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS RX debug_start_ramp
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugStartRamp_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugStartShift_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS RX debug_start_shift
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDebugStartShift_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11), (value >> 0));

    return status;
}

/**
 * LVDS RX div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * LVDS RX enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX fifo_clear
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoClear_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LVDS RX fifo_clear
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoClear_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX fifo_clk_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * LVDS RX fifo_clk_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX fifo_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS RX fifo_enable
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoReadReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoReadReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoWriteReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxFifoWriteReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxForceDataValid_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxForceDataValid_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxForceMcs_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_LssiRxForceMcs_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Disable the Divider clock for profile switching, 1: Enable the divider clock for profile switching
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFullRefclkClkGatingEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 0: Disable the Divider clock for profile switching, 1: Enable the divider clock for profile switching
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFullRefclkClkGatingEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) In case of even lssi_rx_divider, the full RX refclk generated by Navassa is not 50% duty cycle. This bit let the user choose between: 0: low state longer, 1: high state longer
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFullRefclkDutyCycleHighLonger_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) In case of even lssi_rx_divider, the full RX refclk generated by Navassa is not 50% duty cycle. This bit let the user choose between: 0: low state longer, 1: high state longer
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFullRefclkDutyCycleHighLonger_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: DDR mode, 1: SDR mode
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFullRefclkEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: DDR mode, 1: SDR mode
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxFullRefclkEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX i_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxIBitInversion_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * LVDS RX i_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxIBitInversion_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX load_divider
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLoadDivider_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * LVDS RX load_divider
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLoadDivider_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLongStrobe_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * LVDS RX long_strobe
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLongStrobe_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX loopback from TX1
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLoopbackFromTx_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * LVDS RX loopback from TX1
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLoopbackFromTx_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLsbFirst_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * LVDS RX lsb_first
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxLsbFirst_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX q_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxQBitInversion_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * LVDS RX q_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxQBitInversion_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX q_first
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxQFirst_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * LVDS RX q_first
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxQFirst_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxRateCnt_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxRateCnt_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX rd_fifo_enable_delay
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxRdFifoEnableDelay_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * LVDS RX rd_fifo_enable_delay
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxRdFifoEnableDelay_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LVDS RX strobe_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxStrobeBitInversion_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * LVDS RX strobe_bit_inversion
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxStrobeBitInversion_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable the strobe at the SSI interface for LVDS mode
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxStrobeEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable the strobe at the SSI interface for LVDS mode
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxStrobeEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is used only in 12-bit mode. 0 : Most-significant 12 bits are used. 1: Least Significant 12 bits are used.
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxUseLsbIn12bitMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit is used only in 12-bit mode. 0 : Most-significant 12 bits are used. 1: Least Significant 12 bits are used.
 */
static inline int32_t adrv9001_NvsRegmapRx_LssiRxUseLsbIn12bitMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * left shift the output value before rounding and saturation to protect small signal
 */
static inline int32_t adrv9001_NvsRegmapRx_Magp2Lshift_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd3), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * left shift the output value before rounding and saturation to protect small signal
 */
static inline int32_t adrv9001_NvsRegmapRx_Magp2Lshift_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd3), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoBypass_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoBypass_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoGmBoost_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e8), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoGmBoost_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e8), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoPd_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoPd_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoResLoad_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e8), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_MixerLdoResLoad_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e8), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rxnb counter1 counter clear signal
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt1Clear_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Rxnb counter1 counter clear signal
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt1Clear_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Counter 1 block interrupt trigger value, used together with nbdem_cnt1_threshold_update
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt1Threshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd1), (value >> 0));

    return status;
}

/**
 * Counter 1 block interrupt trigger value, used together with nbdem_cnt1_threshold_update
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt1Threshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Counter 1 block threshold value update flag, self cleared
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt1ThresholdUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Counter 1 block threshold value update flag, self cleared
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt1ThresholdUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable rxnb counter3 block. 0: disable counter 3 block
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt3Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: enable rxnb counter3 block. 0: disable counter 3 block
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemCnt3Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Enable FSK demodulation mode. 0: disable FSK demod mode.
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemFskdemMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: Enable FSK demodulation mode. 0: disable FSK demod mode.
 */
static inline int32_t adrv9001_NvsRegmapRx_NbdemFskdemMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * L tx_scic dec
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpLRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x157), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * L tx_scic dec
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpLRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x157), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * M tx_scic intp
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpMRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x157), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * M tx_scic intp
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpMRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x157), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * N tx_scic intp
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpNRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x158), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * N tx_scic intp
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpNRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x158), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * O tx_scic intp
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpORatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x158), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * O tx_scic intp
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfDecintpORatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x158), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1= freq hop mode on, 0=off
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfFhMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x156), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 1= freq hop mode on, 0=off
 */
static inline int32_t adrv9001_NvsRegmapRx_NbfFhMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x156), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoDontUseGlobalClockGating_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoDontUseGlobalClockGating_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoFreeRunClkDiv_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoFreeRunClkDiv_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoFreeRunClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd8), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoFreeRunClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoLoSync0Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x176), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoLoSync0Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x176), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoLoSync1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x176), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoLoSync1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x176), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoLoSync2Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x176), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoLoSync2Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x176), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoTxloFreeRunClkDiv_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoTxloFreeRunClkDiv_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoTxloFreeRunClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd9), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_NcoTxloFreeRunClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable normalization block in frequency discriminator, 0: disable it
 */
static inline int32_t adrv9001_NvsRegmapRx_NormEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xba), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: enable normalization block in frequency discriminator, 0: disable it
 */
static inline int32_t adrv9001_NvsRegmapRx_NormEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xba), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainCompClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainCompClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainCompEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18e), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainCompEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainPhaseDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18e), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainPhaseDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18e), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainPhaseDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18e), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGainPhaseDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGroup1184En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgGroup1184En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgMagcompBbdcClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18d), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgMagcompBbdcClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgMagcompBbdcEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18d), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgMagcompBbdcEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDPinFIFODontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x192), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDPinFIFODontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x192), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDPinFIFOSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x192), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDPinFIFOSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x192), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDpDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x192), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDpDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x192), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDpSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x192), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemDpSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x192), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemRxpfir52DontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x192), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemRxpfir52DontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x192), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemRxpfir52SwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x192), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbdemRxpfir52SwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x192), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficCorrClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18c), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficCorrClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x184), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x184), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x184), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x184), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicMClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicMClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicMRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x185), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicMRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x185), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicNClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x186), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicNClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x186), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicNRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x186), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicNRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x186), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicOClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x187), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicOClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x187), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicORatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x187), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgNbficObsScicORatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x187), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgRfirAfterRxqecRoutEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x190), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgRfirAfterRxqecRoutEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x190), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgScic1Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x182), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgScic1Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x182), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgScic2Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x182), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgScic2Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x182), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgScicClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x183), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgScicClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x183), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgSlicerRssiEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18d), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgSlicerRssiEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgTxGainDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18b), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgTxGainDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18b), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgTxGainDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1AlgTxGainDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1ClkgenCssiDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7), (value >> 0));

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1ClkgenCssiDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1ClockUseRealign_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1ClockUseRealign_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1DataCaptureDriveEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x172), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1DataCaptureDriveEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x172), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DdcDataSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DdcDataSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (rx_dp_alg_scic_div_factor +1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpAlgScicDivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x182), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * rx_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (rx_dp_alg_scic_div_factor +1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpAlgScicDivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x182), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec225En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec225En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec227En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec227En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec229En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec229En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec231En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec231En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec2331En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec2331En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec233En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec233En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec235En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec235En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec237En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec237En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec239En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec239En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec241En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec241En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec243En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec243En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec247En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec247En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec315En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec315En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec345En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpDec345En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1DpGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1DpGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2171En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2171En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2172En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2172En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2191En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2191En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2192En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb2192En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb26En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb26En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb27En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb27En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb28En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpHb28En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * orx1_dp_scic_23_div_factor, set between 1~9, the real div factor is 2~10 (orx1_dp_scic_23_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpScic23DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x181), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * orx1_dp_scic_23_div_factor, set between 1~9, the real div factor is 2~10 (orx1_dp_scic_23_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpScic23DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x181), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpScic23En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpScic23En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSinc3En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSinc3En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSinc4En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSinc4En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSinc6En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x180), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSinc6En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x180), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x191), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x191), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpinfifoEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1DpinfifoEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) LVDS ORX1 div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1LssiRxDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d0), (value >> 0));

    return status;
}

/**
 * (B0 New) LVDS ORX1 div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1LssiRxDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemARMoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x193), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemARMoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x193), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemCORRoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x193), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemCORRoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x193), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemDpoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x193), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemDpoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x193), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemTEDFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x193), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemTEDFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x193), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemCounter1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x193), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemCounter1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x193), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc9), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc8), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc9), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemFreqDiscriminatorEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x193), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemFreqDiscriminatorEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x193), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemNco50Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x194), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemNco50Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x194), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemPulsePfirEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x194), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1NbdemPulsePfirEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x194), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1NbwbSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x196), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1NbwbSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x196), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1Nco1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x189), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1Nco1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x189), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1OverloadHb2Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x190), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1OverloadHb2Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x190), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1Pfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: Divider 1/N selected, 1: Divider 1/4.5 selected
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1Pfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1Pfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x34), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x35), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx1Pfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x34), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x35), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ORX1 profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1ProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) ORX1 profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1ProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ORX1 profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1ProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) ORX1 profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1ProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1RxqecClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x188), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1RxqecClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x188), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1nbResampEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x195), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1nbResampEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x195), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1nbRxpfir52InEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x194), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx1nbRxpfir52InEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x194), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainCompClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainCompClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainCompEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainCompEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainPhaseDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainPhaseDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainPhaseDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGainPhaseDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGroup1184En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgGroup1184En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgMagcompBbdcClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a7), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgMagcompBbdcClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgMagcompBbdcEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a7), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgMagcompBbdcEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDPinFIFODontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ac), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDPinFIFODontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ac), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDPinFIFOSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ac), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDPinFIFOSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ac), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDpDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ac), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDpDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ac), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDpSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ac), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemDpSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ac), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemRxpfir52DontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ac), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemRxpfir52DontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ac), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemRxpfir52SwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ac), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbdemRxpfir52SwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ac), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficCorrClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficCorrClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicMClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicMClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicMRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19f), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicMRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19f), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicNClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicNClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicNRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a0), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicNRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a0), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicOClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicOClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicORatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a1), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgNbficObsScicORatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a1), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgRfirAfterRxqecRoutEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1aa), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgRfirAfterRxqecRoutEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1aa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgScic1Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19c), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgScic1Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgScic2Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19c), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgScic2Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgScicClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgScicClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgSlicerRssiEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a7), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgSlicerRssiEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgTxGainDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a5), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgTxGainDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a5), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgTxGainDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2AlgTxGainDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2ClkgenCssiDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9), (value >> 0));

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2ClkgenCssiDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2ClockUseRealign_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2ClockUseRealign_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2DataCaptureDriveEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x172), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2DataCaptureDriveEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x172), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DdcDataSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DdcDataSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * orx2_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (orx2_dp_alg_scic_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpAlgScicDivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19c), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * orx2_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (orx2_dp_alg_scic_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpAlgScicDivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19c), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec225En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec225En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec227En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec227En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec229En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec229En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec231En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec231En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec2331En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec2331En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec233En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec233En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec235En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec235En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec237En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec237En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec239En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec239En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec241En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec241En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec243En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec243En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec247En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec247En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec315En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x197), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec315En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x197), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec345En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x199), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpDec345En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x199), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2DpGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2DpGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2171En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2171En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2172En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2172En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2191En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2191En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2192En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb2192En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb26En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x197), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb26En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x197), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb27En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb27En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb28En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x197), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpHb28En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x197), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * orx2_dp_scic_23_div_factor, set among 1~9, the real div factor is 2~10(orx2_dp_scic_23_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpScic23DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19b), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * orx2_dp_scic_23_div_factor, set among 1~9, the real div factor is 2~10(orx2_dp_scic_23_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpScic23DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpScic23En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x198), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpScic23En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x198), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSinc3En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSinc3En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSinc4En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSinc4En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSinc6En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSinc6En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ab), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ab), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpinfifoEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2DpinfifoEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) LVDS ORX2 div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2LssiRxDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d2), (value >> 0));

    return status;
}

/**
 * (B0 New) LVDS ORX2 div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2LssiRxDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemARMoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemARMoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemCORRoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemCORRoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemDpoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemDpoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemTEDFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemTEDFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemCounter1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemCounter1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcb), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xca), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcb), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xca), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemFreqDiscriminatorEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ad), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemFreqDiscriminatorEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ad), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemNco50Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ae), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemNco50Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ae), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemPulsePfirEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ae), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2NbdemPulsePfirEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ae), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2NbwbSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2NbwbSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2Nco1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2Nco1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2OverloadHb2Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1aa), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2OverloadHb2Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1aa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2Pfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2Pfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2Pfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x36), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x37), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx2Pfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x36), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x37), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ORX2 profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2ProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) ORX2 profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2ProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ORX2 profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2ProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) ORX2 profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2ProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2RxqecClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a2), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2RxqecClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a2), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2nbResampEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1af), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2nbResampEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1af), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2nbRxpfir52InEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ae), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx2nbRxpfir52InEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ae), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainCompClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c2), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainCompClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainCompEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c2), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainCompEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainPhaseDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c2), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainPhaseDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c2), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainPhaseDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c2), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGainPhaseDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGroup1184En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgGroup1184En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgMagcompBbdcClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c1), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgMagcompBbdcClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgMagcompBbdcEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c1), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgMagcompBbdcEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDPinFIFODontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDPinFIFODontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDPinFIFOSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDPinFIFOSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDpDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDpDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDpSwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemDpSwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemRxpfir52DontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c6), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemRxpfir52DontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemRxpfir52SwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c6), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbdemRxpfir52SwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficCorrClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficCorrClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicMClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicMClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicMRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b9), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicMRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b9), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicNClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ba), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicNClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ba), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicNRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ba), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicNRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ba), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicOClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1bb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicOClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1bb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicORatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1bb), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgNbficObsScicORatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1bb), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgRfirAfterRxqecRoutEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c4), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgRfirAfterRxqecRoutEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgScic1Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgScic1Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgScic2Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgScic2Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgScicClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgScicClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgSlicerRssiEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c1), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgSlicerRssiEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgTxGainDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1bf), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgTxGainDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1bf), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgTxGainDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3AlgTxGainDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3ClkgenCssiDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb), (value >> 0));

    return status;
}

/**
 * (B0 New) Extended to 16 bits
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3ClkgenCssiDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3DataCaptureDriveEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x172), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3DataCaptureDriveEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x172), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DdcDataSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1be), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DdcDataSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1be), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * orx3_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (orx3_dp_alg_scic_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpAlgScicDivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b6), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * orx3_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (orx3_dp_alg_scic_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpAlgScicDivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b6), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec225En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec225En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec227En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec227En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec229En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec229En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec231En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec231En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec2331En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b3), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec2331En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec233En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec233En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec235En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec235En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec237En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec237En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec239En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec239En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec241En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec241En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec243En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b3), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec243En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec247En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b3), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec247En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec315En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b1), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec315En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec345En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b3), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpDec345En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3DpGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3DpGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2171En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2171En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2172En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2172En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2191En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2191En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2192En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb2192En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb26En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb26En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb27En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb27En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb28En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpHb28En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * orx3_dp_scic_23_div_factor, set among 1~9, the real div factor is 2~10(orx3_dp_scic_23_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpScic23DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b5), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * orx3_dp_scic_23_div_factor, set among 1~9, the real div factor is 2~10(orx3_dp_scic_23_div_factor+1)
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpScic23DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpScic23En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpScic23En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSinc3En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSinc3En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSinc4En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSinc4En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSinc6En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSinc6En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpinfifoEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xac), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 1: enable DpinFIFO block 0: disable DPinFIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3DpinfifoEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xac), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) LVDS ORX3 div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3LssiRxDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d5), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d4), (value >> 0));

    return status;
}

/**
 * (B0 New) LVDS ORX3 div_value
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3LssiRxDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemARMoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemARMoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemCORRoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemCORRoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemDpoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemDpoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemTEDFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemTEDFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemCounter1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemCounter1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcd), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xcc), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcd), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xcc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemFreqDiscriminatorEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemFreqDiscriminatorEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemNco50Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemNco50Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemPulsePfirEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3NbdemPulsePfirEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3NbwbSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ca), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3NbwbSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ca), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3Nco1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1bd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3Nco1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1bd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3OverloadHb2Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3OverloadHb2Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3Pfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3Pfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3Pfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x38), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x39), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Orx3Pfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x38), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x39), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ORX3 profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3ProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) ORX3 profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3ProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ORX3 profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3ProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c3), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) ORX3 profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3ProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3RxqecClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1bc), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3RxqecClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1bc), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3nbResampEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3nbResampEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3nbRxpfir52InEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_Orx3nbRxpfir52InEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1 => ORX; 0 => RX (default)
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxProfileSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1 => ORX; 0 => RX (default)
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxProfileSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: ORX1, 1: ORX2, 2: ORX3
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd6), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * 0: ORX1, 1: ORX2, 2: ORX3
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd6), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1 => ORX; 0 => RX (default)
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxSsiProfileSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1 => ORX; 0 => RX (default)
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxSsiProfileSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: ORX1, 1: ORX2, 2: ORX3
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxSsiSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd6), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * 0: ORX1, 1: ORX2, 2: ORX3
 */
static inline int32_t adrv9001_NvsRegmapRx_OrxSsiSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd6), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_OrxqecObsCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_OrxqecObsCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flag indicating saturation in the RX ch1 PFIR. Write 1 to clear
 */
static inline int32_t adrv9001_NvsRegmapRx_OverflowRfir_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_OverloadClkEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_OverloadClkEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_OverloadHb2Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_OverloadHb2Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_PdIDist_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ea), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_PdIDist_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ea), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PhaseSyncFtwUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PhaseSyncFtwUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PhaseSyncNcoPhaseAvThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa5), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PhaseSyncNcoPhaseAvThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PhaseSyncNcoSwControl_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PhaseSyncNcoSwControl_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PwrMonRssiEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x175), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_PwrMonRssiEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x175), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Reserved0_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Reserved0_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Reserved1_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17c), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_Reserved1_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcAArmOrGroup1184ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ed), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcAArmOrGroup1184ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ed), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcAForceArmClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ed), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcAForceArmClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ed), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcAForceGroup1ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ed), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcAForceGroup1ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ed), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcBArmOrGroup1184ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ee), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcBArmOrGroup1184ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ee), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcBForceArmClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ee), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcBForceArmClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ee), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcBForceGroup1ClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ee), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RfdcBForceGroup1ClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ee), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RfdcEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x175), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RfdcEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x175), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * WB/NB compensation PFIR input selection: 1: input from RP point, 0: input from NCO 50
 */
static inline int32_t adrv9001_NvsRegmapRx_RpfirInSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * WB/NB compensation PFIR input selection: 1: input from RP point, 0: input from NCO 50
 */
static inline int32_t adrv9001_NvsRegmapRx_RpfirInSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * flash cal data read back
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2Data_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe0), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xde), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Number of samples to accumulate. {//      000 – 1K samples

 *    //         001 – 2K samples

 *    //         010 – 4K samples

 *    //         011 – 8K samples

 *    //         100 – 16K samples

 *    //         101 – 32K samples

 *    //         110 – 64K samples

 *    //         111 – 128K samples}
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2Length_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdd), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * Number of samples to accumulate. {//      000 – 1K samples

 *    //         001 – 2K samples

 *    //         010 – 4K samples

 *    //         011 – 8K samples

 *    //         100 – 16K samples

 *    //         101 – 32K samples

 *    //         110 – 64K samples

 *    //         111 – 128K samples}
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2Length_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdd), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bit 1 is not used.  Bit 0 = {0= select I to read, 1= select Q to read}
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2ReadSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdd), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * Bit 1 is not used.  Bit 0 = {0= select I to read, 1= select Q to read}
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2ReadSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdd), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the RX ADC I and Q accumulators are both cleared and an accumulation period begins. At the end of the period, the enable bit is automatically cleared. The length of the period is defined by the value in [D4:D2].
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2RxEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When this bit is set, the RX ADC I and Q accumulators are both cleared and an accumulation period begins. At the end of the period, the enable bit is automatically cleared. The length of the period is defined by the value in [D4:D2].
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2RxEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 = select sum of squares "power" to read, 1= select sum of samples "dc" to read
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2StartSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdd), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 0 = select sum of squares "power" to read, 1= select sum of samples "dc" to read
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCal2StartSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdd), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_adc_flash_comp_addr
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCompAddr_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf2), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * rx_adc_flash_comp_addr
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashCompAddr_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_adc_flash_read_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashReadSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx_adc_flash_read_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashReadSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_adc_flash_wait
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashWait_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf1), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * rx_adc_flash_wait
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcFlashWait_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf1), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the upper level threshold to be compared with the accumulated samples (set by adc_ovld_duration)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadLowerThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe9), (value >> 0));

    return status;
}

/**
 * This register sets the upper level threshold to be compared with the accumulated samples (set by adc_ovld_duration)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadLowerThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Contains the number of cycles of saturated values (+8 or -8) allowed in a window before an ADC reset is triggered. If programmed greater than the window, a reset will never trigger.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetDuration_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe4), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Contains the number of cycles of saturated values (+8 or -8) allowed in a window before an ADC reset is triggered. If programmed greater than the window, a reset will never trigger.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetDuration_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe4), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Contains the number of cycles (in RFIR IN clocks) that reset is held to the RSSI block after a reset is triggered.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetRfirInDuration_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe5), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Contains the number of cycles (in RFIR IN clocks) that reset is held to the RSSI block after a reset is triggered.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetRfirInDuration_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe5), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Contains the number of cycles (in RFIR OUT clocks) which reset is held to the RSSI block after a reset is triggered.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetRfirOutDuration_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe6), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Contains the number of cycles (in RFIR OUT clocks) which reset is held to the RSSI block after a reset is triggered.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetRfirOutDuration_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe6), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Contains the number of cycles of saturated values (+8 or -8) allowed in a window before an ADC reset is triggered. If programmed greater than the window, a reset will never trigger.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetSize_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe2), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * Contains the number of cycles of saturated values (+8 or -8) allowed in a window before an ADC reset is triggered. If programmed greater than the window, a reset will never trigger.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetSize_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe2), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Contains the number of cycles of saturated values (+8 or -8) allowed in a window before an ADC reset is triggered. If programmed greater than the window, a reset will never trigger.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe3), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * Contains the number of cycles of saturated values (+8 or -8) allowed in a window before an ADC reset is triggered. If programmed greater than the window, a reset will never trigger.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadResetThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe3), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register sets the upper level threshold to be compared with the accumulated samples (set by adc_overload_config)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadUpperThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe8), (value >> 0));

    return status;
}

/**
 * This register sets the upper level threshold to be compared with the accumulated samples (set by adc_overload_config)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOverloadUpperThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the number of ADC samples to accumulate in the ADC overload detector before comparing to the overload threshold according to the following settings: 

 * 00 --  4 

 * 01 --  8 

 * 10 --  16 

 * 11 --  16
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOvldDuration_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * These bits set the number of ADC samples to accumulate in the ADC overload detector before comparing to the overload threshold according to the following settings: 

 * 00 --  4 

 * 01 --  8 

 * 10 --  16 

 * 11 --  16
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcOvldDuration_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAdcProfile_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x162), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAdcProfile_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x162), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_adc_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf1), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * rx_adc_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf1), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ADC clock sample rate, used for static RX gain compensation block 

 * ►	00: 1.105GHz

 * ►	01: 1.474GHz

 * ►	10: 2.211GHz

 * ►	11: 1.105GHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcSpeedSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xab), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * ADC clock sample rate, used for static RX gain compensation block 

 * ►	00: 1.105GHz

 * ►	01: 1.474GHz

 * ►	10: 2.211GHz

 * ►	11: 1.105GHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAdcSpeedSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xab), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAgcGtSramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAgcGtSramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_agc_rssi_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAgcRssiEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx_agc_rssi_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAgcRssiEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainCompClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfa), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainCompClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainCompEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfa), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainCompEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainPhaseDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfa), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainPhaseDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfa), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainPhaseDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfa), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGainPhaseDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGroup1184En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfa), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgGroup1184En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgMagcompBbdcClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgMagcompBbdcClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgMagcompBbdcDontUseGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgMagcompBbdcDontUseGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgMagcompBbdcEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgMagcompBbdcEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: RB, 1: mag_comp_pfir_21
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux200ASel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: RB, 1: mag_comp_pfir_21
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux200ASel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: RD, 1:RB
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux200Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: RD, 1:RB
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux200Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_200_out, 1: mag_comp_pfir_21
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux201Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mux_200_out, 1: mag_comp_pfir_21
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux201Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_202_out, 1: RD
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux202BRDSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0: mux_202_out, 1: RD
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux202BRDSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0:mux_202B_RD_out, 1: RJ
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux202BRJSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 0:mux_202B_RD_out, 1: RJ
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux202BRJSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_201_out, 1: rx_dig_offset_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux202Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 0: mux_201_out, 1: rx_dig_offset_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux202Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: RY, 1: RH
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux203RHSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: RY, 1: RH
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux203RHSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_202B_out, 1: mux_203_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux204Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf8), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: mux_202B_out, 1: mux_203_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux204Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf8), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0:mux_202B_out, 1: nbfic_corr_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux205NbficSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0:mux_202B_out, 1: nbfic_corr_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux205NbficSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_205_out, 1: rx_rxqec_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux206RxqecRx1CorrSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: mux_205_out, 1: rx_rxqec_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux206RxqecRx1CorrSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mux_206_out, 1: mux_202_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux207Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mux_206_out, 1: mux_202_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux207Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux208Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgMux208Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficCorrClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdb), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficCorrClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15a), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicMClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicMClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicMRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15b), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicMRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15b), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicNClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicNClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicNRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15c), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicNRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15c), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicOClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicOClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicORatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15d), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicORatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15d), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Reset the SCICs
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x159), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Reset the SCICs
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgNbficObsScicReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x159), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgRfirAfterRxqecRoutEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf7), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgRfirAfterRxqecRoutEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgRxqecEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgRxqecEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic1Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic1Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic1Dec8Reset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic1Dec8Reset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic2Dec8En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic2Dec8En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic2Dec8Reset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgScic2Dec8Reset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgScicClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgScicClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgScicReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAlgScicReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgSlicerRssiEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf9), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgSlicerRssiEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgTxGainDelayClkSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgTxGainDelayClkSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgTxGainDelayEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xdc), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxAlgTxGainDelayEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xdc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * rx_averaging_end
 */
static inline int32_t adrv9001_NvsRegmapRx_RxAveragingEnd_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x44), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStateBbdc_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x163), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStateBbdc_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x163), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStateNbfic_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x163), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStateNbfic_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x163), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStateRfdc_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x163), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStateRfdc_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x163), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStates_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x163), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxChanFuncsRadioStates_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x163), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) rx_clkgen_cssi_div_value (Extended to 16 bits)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxClkgenCssiDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5), (value >> 0));

    return status;
}

/**
 * (B0 New) rx_clkgen_cssi_div_value (Extended to 16 bits)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxClkgenCssiDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapRx_RxClkgenCssiLoadDivider_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapRx_RxClkgenCssiLoadDivider_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxClockUseRealign_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cd), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxClockUseRealign_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDatapathForceZero_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDatapathForceZero_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcDataSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Select the input data for DDC:  1: select AGC output as DDC input  0: select QEC output as DDC input
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcDataSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  select algorithm output as DDC din1 input   1’b0: select datapath output as DDC din1 input
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcDin1Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x69), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1’b1:  select algorithm output as DDC din1 input   1’b0: select datapath output as DDC din1 input
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcDin1Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x69), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  select algorithm output as DDC din2 input   1’b0: select datapath output as DDC din2 input
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcDin2Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x69), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1’b1:  select algorithm output as DDC din2 input   1’b0: select datapath output as DDC din2 input
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcDin2Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x69), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1: add zero to RXDDC input I channel,  1’b0: original data comes to RXDDC input I channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcZeroI_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1’b1: add zero to RXDDC input I channel,  1’b0: original data comes to RXDDC input I channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcZeroI_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1'b1: add zero to RXDDC input Q channel,  1’b0: original data comes to RXDDC input Q channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcZeroQ_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xaa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1'b1: add zero to RXDDC input Q channel,  1’b0: original data comes to RXDDC input Q channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDdcZeroQ_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xaa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the window of clock cycles (at the HB2 output rate) to meet the overload count. 

 * Possible settings are (in decimal): 1, 4, 8, 12, 16, 24, and 32.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecOverloadDurationCount_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xea), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * This sets the window of clock cycles (at the HB2 output rate) to meet the overload count. 

 * Possible settings are (in decimal): 1, 4, 8, 12, 16, 24, and 32.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecOverloadDurationCount_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xea), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the dynamic range of the power measurement increases from 40dB to ~60dB (that is, all signal levels from 0dBFS to -60dBFS are accurately detected.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecOverloadPowerMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xeb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set, the dynamic range of the power measurement increases from 40dB to ~60dB (that is, all signal levels from 0dBFS to -60dBFS are accurately detected.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecOverloadPowerMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xeb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the number of actual overloads required to trigger the overload signal.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecOverloadThresholdCount_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xea), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * These bits set the number of actual overloads required to trigger the overload signal.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecOverloadThresholdCount_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xea), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the value from full-scale that the HB2 overload detector thresholds are set (upper and lower) relative to full scale. The threshold should be set such that the resolution is maximized where the signal is present. 

 * The following settings are available: 

 * 00 --   0dB 

 * 01 --  -4dB 

 * 10 --  -5dB 

 * 11 --  -6dB
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecThresholdConfig_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xeb), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits set the value from full-scale that the HB2 overload detector thresholds are set (upper and lower) relative to full scale. The threshold should be set such that the resolution is maximized where the signal is present. 

 * The following settings are available: 

 * 00 --   0dB 

 * 01 --  -4dB 

 * 10 --  -5dB 

 * 11 --  -6dB
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecThresholdConfig_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xeb), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) In multiple time constants in AGC loop mode, this field sets the lower level overload threshold for interval 0 to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. For details on using this field, see description in agc_enable_fast_recovery_loop.

 * This threshold is determined using the following equation:

 * lower threshold=20 * log10(decimated_data_overload_int0_lower_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadInt0LowerThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1dd), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xee), (value >> 0));

    return status;
}

/**
 * (B0 New) In multiple time constants in AGC loop mode, this field sets the lower level overload threshold for interval 0 to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. For details on using this field, see description in agc_enable_fast_recovery_loop.

 * This threshold is determined using the following equation:

 * lower threshold=20 * log10(decimated_data_overload_int0_lower_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadInt0LowerThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1dd), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xee), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) In multiple time constants in AGC loop mode, this field sets the lower level overload threshold for interval 1 to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. For details on using this field, see description in agc_enable_fast_recovery_loop.

 * This threshold is determined using the following equation:

 * lower threshold=20 * log10(decimated_data_overload_int0_lower_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadInt1LowerThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1de), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xef), (value >> 0));

    return status;
}

/**
 * (B0 New) In multiple time constants in AGC loop mode, this field sets the lower level overload threshold for interval 1 to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. For details on using this field, see description in agc_enable_fast_recovery_loop.

 * This threshold is determined using the following equation:

 * lower threshold=20 * log10(decimated_data_overload_int0_lower_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadInt1LowerThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1de), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xef), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) This is a programmable overload threshold that triggers for a lower peak signal level (~-17dBFS). This threshold has a resolution of 1dB starting at 0dBFS up to -40dBFS. See description in agc_enable_ip3_optimization_threshold for details of Two-threshold AGC loop mode of operation.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadIp3UpperThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1db), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf0), (value >> 0));

    return status;
}

/**
 * (B0 New) This is a programmable overload threshold that triggers for a lower peak signal level (~-17dBFS). This threshold has a resolution of 1dB starting at 0dBFS up to -40dBFS. See description in agc_enable_ip3_optimization_threshold for details of Two-threshold AGC loop mode of operation.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadIp3UpperThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1db), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) This register sets the lower level overload threshold to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. 

 * When in The multiple time constants in AGC loop mode, this field sets the lower level overload threshold for interval 2. For details on using this field in multiple time constants in AGC loop mode, see description in agc_enable_fast_recovery_loop.

 * This threshold is determined using the following equation:

 * lower threshold=20 * log10(decimated_data_overload_lower_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadLowerThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1dc), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xed), (value >> 0));

    return status;
}

/**
 * (B0 New) This register sets the lower level overload threshold to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. 

 * When in The multiple time constants in AGC loop mode, this field sets the lower level overload threshold for interval 2. For details on using this field in multiple time constants in AGC loop mode, see description in agc_enable_fast_recovery_loop.

 * This threshold is determined using the following equation:

 * lower threshold=20 * log10(decimated_data_overload_lower_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadLowerThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1dc), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xed), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) This register sets the upper level overload threshold to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. This threshold is determined using the following equation:

 * upper threshold = 20 * log10(decimated_data_overload_upper_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadUpperThreshold_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1da), (value >> 8), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xec), (value >> 0));

    return status;
}

/**
 * (B0 New) This register sets the upper level overload threshold to be compared with samples from the output of the HB2 filter. An offset to this value is always applied and set using dec_threshold_config. This threshold is determined using the following equation:

 * upper threshold = 20 * log10(decimated_data_overload_upper_threshold/256)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDecimatedDataOverloadUpperThreshold_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1da), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xec), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flag indicating saturation in the RX ch1 digital gain. Write 1 to clear
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDigitalGainSaturation_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, this bit prevents an automatic reset from ~RXON or during the 1s after RXON asserts.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDisableAdcStartupReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When set, this bit prevents an automatic reset from ~RXON or during the 1s after RXON asserts.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDisableAdcStartupReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_agc_wb_10_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpAgcWb10En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * rx_dp_agc_wb_10_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpAgcWb10En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (rx_dp_alg_scic_div_factor +1)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpAlgScicDivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * rx_dp_alg_scic_div_factor,  set between 1~9, the real div factor is 2~10 (rx_dp_alg_scic_div_factor +1)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpAlgScicDivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_alg_scic_ripple_sel, 1: select low ripple mode
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpAlgScicRippleSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xda), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx_dp_alg_scic_ripple_sel, 1: select low ripple mode
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpAlgScicRippleSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xda), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec225En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 25, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec225En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec227En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 27, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec227En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec229En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 29, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec229En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec231En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 31, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec231En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec2331En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33.1, decimation by 2.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec2331En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec233En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 33, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec233En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec235En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 35, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec235En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec237En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 37, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec237En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec239En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP filter 39, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec239En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec241En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 41, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec241En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec243En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP filter 43, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec243En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec247En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 47, decimation by 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec247En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec315En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 15, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec315En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec345En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 45, decimation by 3
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDec345En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_dmr_r0_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDmrR0En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx_dp_dmr_r0_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDmrR0En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_dmr_r1_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDmrR1En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx_dp_dmr_r1_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpDmrR1En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_fic_54_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpFic54En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx_dp_fic_54_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpFic54En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_fm_r1_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpFmR1En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx_dp_fm_r1_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpFmR1En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP static gain compensation block
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP static gain compensation block
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI0_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x51), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x50), (value >> 0));

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI0_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x51), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x50), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI1_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x55), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x54), (value >> 0));

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI1_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x55), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x54), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI2_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x59), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x58), (value >> 0));

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI2_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x59), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x58), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI3_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5c), (value >> 0));

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI3_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI4_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x61), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x60), (value >> 0));

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI4_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x61), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x60), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI5_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x65), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x64), (value >> 0));

    return status;
}

/**
 * Gain I  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainI5_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x65), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x64), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ0_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x53), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x52), (value >> 0));

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ0_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x53), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x52), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ1_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x57), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x56), (value >> 0));

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ1_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x57), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x56), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ2_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5a), (value >> 0));

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ2_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ3_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5e), (value >> 0));

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ3_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ4_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x63), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x62), (value >> 0));

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ4_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x63), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x62), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ5_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x67), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x66), (value >> 0));

    return status;
}

/**
 * Gain Q  default ‘d0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9GainQ5_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x67), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x66), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_gain_comp_9_update_single. update RX1 or RX2 gain only
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9UpdateSingle_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx_dp_gain_comp_9_update_single. update RX1 or RX2 gain only
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGainComp9UpdateSingle_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) RX/ORX1/ORX2/ORX3 profiles DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) RX/ORX1/ORX2/ORX3 profiles DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX DP Global Reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * RX DP Global Reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2171En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable RX DP filter 17.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2171En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2172En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable RX DP filter 17.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2172En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2191En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable RX DP filter 19.1, decimation by 2, Fc=20.075MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2191En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2192En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable RX DP filter 19.2, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb2192En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb26En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP filter 6, decimation by 2, Fc=25MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb26En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb27En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 7, decimation by 2, Fc=50MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb27En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb28En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable RX DP filter 8, decimation by 2, Fc=5MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpHb28En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_p25_r1_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpP25R1En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx_dp_p25_r1_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpP25R1En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX DP PFIR_52 reset (NOT USED in DESIGN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpPfir52Reset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * RX DP PFIR_52 reset (NOT USED in DESIGN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpPfir52Reset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDpRssiInSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa3), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDpRssiInSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_fic_54_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpRxqec21En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * rx_dp_fic_54_en
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpRxqec21En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 00: rx_dec_out         01: RXQEC out  10: DDC out, 11: rx_dec_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpRxqecMuxSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x68), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * 00: rx_dec_out         01: RXQEC out  10: DDC out, 11: rx_dec_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpRxqecMuxSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x68), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_scic_23_div_factor, set among 1~9, the real div factor is 2~10 (rx_dp_scic_23_div_factor +1)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23DivFactor_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x31), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * rx_dp_scic_23_div_factor, set among 1~9, the real div factor is 2~10 (rx_dp_scic_23_div_factor +1)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23DivFactor_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x31), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SCIC filter 23, decimation by 2~10
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23Reset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23Reset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX scic debug signal.  Default: 0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23RippleSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * RX scic debug signal.  Default: 0
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpScic23RippleSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * SINC filter gain setting. 0: 0db, 1: 6db, 2: 12db 3: -6db, 4: -12db
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc2Sinc3GainLevelFromSpi_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4d), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * SINC filter gain setting. 0: 0db, 1: 6db, 2: 12db 3: -6db, 4: -12db
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc2Sinc3GainLevelFromSpi_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc3En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable RX DP SINC3 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc3En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc4En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable RX DP SINC4 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc4En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc6En_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable RX DP SINC6 filter
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSinc6En_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDpSpectralInvertI_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDpSpectralInvertI_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDpSpectralInvertQ_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cb), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxDpSpectralInvertQ_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSpiIntfClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * RXDP_SPI_INTF clock enable
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpSpiIntfClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 00: rx_sinc_hb_out, 01: RXQEC out, 10: DDC out, 11: rx_sinc_hb_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpWbagcMuxSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3e), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * 00: rx_sinc_hb_out, 01: RXQEC out, 10: DDC out, 11: rx_sinc_hb_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxDpWbagcMuxSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3e), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If clear, the ADC overload detector is effectively stuck in reset.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxEnableAdcOverload_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * If clear, the ADC overload detector is effectively stuck in reset.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxEnableAdcOverload_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If clear, the HB2 (decimated) overload detector is effectively stuck in reset.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxEnableDecOverload_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xea), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * If clear, the HB2 (decimated) overload detector is effectively stuck in reset.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxEnableDecOverload_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xea), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxEnableGcounterSync_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1df), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxEnableGcounterSync_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1df), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0=coeff_A, 1=coeff_B
 */
static inline int32_t adrv9001_NvsRegmapRx_RxFirSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0=coeff_A, 1=coeff_B
 */
static inline int32_t adrv9001_NvsRegmapRx_RxFirSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the ADC is forced into a reset state. The ADC is also forced into reset when RXON is deasserted, and for 1s immediately after RXON asserts.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxForceAdcOverloadReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When set, the ADC is forced into a reset state. The ADC is also forced into reset when RXON is deasserted, and for 1s immediately after RXON asserts.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxForceAdcOverloadReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxFuncGainCompEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x165), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxFuncGainCompEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x165), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxGcounterSegmentSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1df), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxGcounterSegmentSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1df), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxMagCompPfir21SwReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxMagCompPfir21SwReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pass data directly from MISR input to signature output.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrBypass_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Pass data directly from MISR input to signature output.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrBypass_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Selects how the I and Q samples are hashed into the signature register.  

 * 00 - I[15:0] XOR Q[0:15] (Q is bit reversed.)

 * 01 - I[15:0] only

 * 10 - Q[15:0] only

 * 11 - I[15:0] XOR Q[15:0]
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrDatapathSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf4), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * Selects how the I and Q samples are hashed into the signature register.  

 * 00 - I[15:0] XOR Q[0:15] (Q is bit reversed.)

 * 01 - I[15:0] only

 * 10 - Q[15:0] only

 * 11 - I[15:0] XOR Q[15:0]
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrDatapathSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf4), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set to 1, the RX MISR is enabled.  Before enabling, the datapath should be flushed to zero, and then the first non-zero sample activates the MISR to start recording.  The MISR always records both RX and RX2.  When rx_misr_enable is cleared, the signature is also clear to zero.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When set to 1, the RX MISR is enabled.  Before enabling, the datapath should be flushed to zero, and then the first non-zero sample activates the MISR to start recording.  The MISR always records both RX and RX2.  When rx_misr_enable is cleared, the signature is also clear to zero.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Sets the MISR counter_length (in samples)

 * 00: length = 0x07fff

 * 01: length = 0x0ffff

 * 10: length = 0x3ffff

 * 11: length = 0xfffff
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrLength_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf4), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * Sets the MISR counter_length (in samples)

 * 00: length = 0x07fff

 * 01: length = 0x0ffff

 * 10: length = 0x3ffff

 * 11: length = 0xfffff
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrLength_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf4), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * After the RX datapath MISR has been run, this register contains the output signature.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxMisrSignature_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemARMoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NB demodulation ARM output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemARMoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCORRoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulation CORR output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCORRoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemDpoutFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable NB demodulation datapath output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemDpoutFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemTEDFIFOEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable NB demodulation TED output FIFO
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemTEDFIFOEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation correlator parallel output
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCorrelatorParallelEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Enable NB demodulation correlator parallel output
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCorrelatorParallelEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCounter1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Enable NB demodulation counter 1
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCounter1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulation counter 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCounter2Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Enable NB demodulation counter 2
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemCounter2Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX NB demodulation block divider setting, for the clock generation
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc7), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc6), (value >> 0));

    return status;
}

/**
 * RX NB demodulation block divider setting, for the clock generation
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc7), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemFreqDiscriminatorEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xce), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable NB demodulator frequency discriminator block
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemFreqDiscriminatorEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xce), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemNco50Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enable NCO 50 block
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemNco50Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemPulsePfirEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcf), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enable NB demodulator pulse shaping PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbdemPulsePfirEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1= obs enabled
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1= obs enabled
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rssi compare enable cntr limit
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfEnableCntLimit_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x135), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x134), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x133), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x132), (value >> 0));

    return status;
}

/**
 * rssi compare enable cntr limit
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfEnableCntLimit_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x135), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x134), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x133), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x132), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * nbfic enable thld
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfEnableThld_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13e), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * nbfic enable thld
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfEnableThld_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13e), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCoefDci_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x110), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCoefDcq_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x113), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x112), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x111), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCoefGain_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10d), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCoefPhase_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x109), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x108), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x107), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x106), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * write pulse [phase and di]

 * write pulse [phase and di]

 * write pulse [phase and di]
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCoefWr_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x105), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * write pulse [phase and di]

 * write pulse [phase and di]

 * write pulse [phase and di]
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCoefWr_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x105), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicConfig_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x115), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x114), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicConfig_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x115), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x114), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCtlRdata_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x129), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x128), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x127), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x126), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * write pulse [phase and di]

 * write pulse [phase and di]
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCtrlWr_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11a), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * write pulse [phase and di]

 * write pulse [phase and di]
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicCtrlWr_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * fic_est ctrl after muxing
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicEstCtrl_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1=fic_est forced on/off
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicEstForce_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * 1=fic_est forced on/off
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicEstForce_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicGctl_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x119), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x118), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicGctl_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x119), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x118), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Initial Observed Gain
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicGn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x104), (value >> 24), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x103), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x102), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x101), (value >> 0));

    return status;
}

/**
 * Initial Observed Gain
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicGn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x104), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x103), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x102), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x101), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicGpRdSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x156), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicGpRdSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x156), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicPctl_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x117), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x116), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicPctl_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x117), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x116), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Initial Observed Phase
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicPh_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x100), (value >> 24), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xff), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfe), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xfd), (value >> 0));

    return status;
}

/**
 * Initial Observed Phase
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicPh_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x100), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xff), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfe), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xfd), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicRegConfig_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicRegCount_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicRegDc_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x123), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicRegGain_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x122), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x121), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicRegPhase_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x120), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicState_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x125), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfFicStatus_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x124), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * fir bypass
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFirByp_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * fir bypass
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfFirByp_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rssi compare halt cntr limit
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfHaltCntLimit_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13d), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13c), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13a), (value >> 0));

    return status;
}

/**
 * rssi compare halt cntr limit
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfHaltCntLimit_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * nbfic halt thld
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfHaltThld_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13f), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * nbfic halt thld
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfHaltThld_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13f), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * phase/gain fdata sel 1=nbf_obs 0=ficdp_cdata
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfPgobsDsel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x131), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * phase/gain fdata sel 1=nbf_obs 0=ficdp_cdata
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfPgobsDsel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1=restart nbfic observation
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRestart_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1=restart nbfic observation
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRestart_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * rssi A
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiA_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14f), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * rssi B
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiB_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x153), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x152), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x151), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x150), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1=rssi compare enabled from SPI, 0=disabled
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiCompEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 1=rssi compare enabled from SPI, 0=disabled
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiCompEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * divisor for average
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiDiv_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12f), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12c), (value >> 0));

    return status;
}

/**
 * divisor for average
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiDiv_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * ctrl that turns fic_est on/off
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiFicCtrl_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rssi interval in 1us incr
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiIntvl_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12a), (value >> 0));

    return status;
}

/**
 * rssi interval in 1us incr
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiIntvl_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * rssi_A/rssi_B metric
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssiMetric_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x155), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x154), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * spi readback
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssicompEnableCntr_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x143), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x142), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x141), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x140), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssicompHaltCntr_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x149), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x148), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxNbfRssicompTransCntr_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x147), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x146), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x145), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x144), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1= obs enabled
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfScobsEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x130), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1= obs enabled
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfScobsEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x130), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rssi compare transition cntr limit
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfTransCntLimit_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x139), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x138), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x137), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x136), (value >> 0));

    return status;
}

/**
 * rssi compare transition cntr limit
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbfTransCntLimit_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x139), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x138), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x137), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x136), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b0: bypass, 1’b1: select RN from algorithm
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbgainMuxSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x68), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1’b0: bypass, 1’b1: select RN from algorithm
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNbgainMuxSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x68), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * First NCO enable in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw158_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x21), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw158_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x21), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw2316_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x20), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw2316_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x20), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw3124_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1f), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw3124_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw70_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x22), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco1_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Ftw70_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x22), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * After writing to rx_nco1_ftw, this field should be set to update the NCO FTW from the shadow register into the datapath. The field self clears after the update has completed
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1FtwUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * After writing to rx_nco1_ftw, this field should be set to update the NCO FTW from the shadow register into the datapath. The field self clears after the update has completed
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1FtwUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * rx_nco1_phase
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1Phase_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x44), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX NCO1 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseOffset158_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x23), (value >> 0));

    return status;
}

/**
 * RX NCO1 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseOffset158_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x23), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX NCO1 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseOffset70_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x24), (value >> 0));

    return status;
}

/**
 * RX NCO1 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseOffset70_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSync32bitMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSync32bitMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw158_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2f), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw158_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw2316_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2e), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw2316_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw3124_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1ef), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw3124_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1ef), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw70_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x30), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency when using the TxLO phase accumulator.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtw70_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x30), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtwReadback_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtwReadback_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtwReadbackValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1PhaseSyncFtwRemainderReadback_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * First NCO-Eanble Real IF output in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1RealOutEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * First NCO-Eanble Real IF output in RX channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco1RealOutEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw158_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x27), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw158_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x27), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw2316_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x26), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw2316_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x26), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw3124_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x25), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw3124_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x25), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw70_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x28), (value >> 0));

    return status;
}

/**
 * This sets the NCO tuning word frequency . Note that the 8 LSBs are not currently used (reserved for future use). This field should be used with rx_nco2_ftw_update
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2Ftw70_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x28), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * After writing to rx_nco2_ftw, this field should be set to update the NCO FTW from the shadow register into the datapath. The field self clears after the update has completed
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2FtwUpdate_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * After writing to rx_nco2_ftw, this field should be set to update the NCO FTW from the shadow register into the datapath. The field self clears after the update has completed
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2FtwUpdate_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Second NCO in RX - Enable synchronization through the Multi chip sync. The signal is set on a Multi chip sync. Clearing the bit through register map enables re-synchronization on the next Multi chip sync pulse.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2MultiChipSynced_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Second NCO in RX - Enable synchronization through the Multi chip sync. The signal is set on a Multi chip sync. Clearing the bit through register map enables re-synchronization on the next Multi chip sync pulse.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2MultiChipSynced_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX NCO2 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2PhaseOffset158_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x29), (value >> 0));

    return status;
}

/**
 * RX NCO2 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2PhaseOffset158_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x29), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RX NCO2 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2PhaseOffset70_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2a), (value >> 0));

    return status;
}

/**
 * RX NCO2 phase offset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2PhaseOffset70_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Second NCO-Enable Real IF output
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2RealOutEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Second NCO-Enable Real IF output
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNco2RealOutEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoGcountClkRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e0), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoGcountClkRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * rx_nco_phase_av
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoPhaseAv_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x45), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x46), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoPhaseOffset2Update_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1df), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoPhaseOffset2Update_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1df), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoPhaseOffset2Word_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e2), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e1), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoPhaseOffset2Word_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e2), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * rx_nco_phase_out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoPhaseOut_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x47), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x48), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x49), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * don't use tx LO for NCO1 phase accumulator
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoUseNonTxLOMcsPhaseAccum_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * don't use tx LO for NCO1 phase accumulator
 */
static inline int32_t adrv9001_NvsRegmapRx_RxNcoUseNonTxLOMcsPhaseAccum_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxOverrideNcoGcountClkRatio_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxOverrideNcoGcountClkRatio_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * WB/NB compensation PFIR internal clock speed setting. used in 61.44*4=245.76MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPfir4xDiv4p5_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * WB/NB compensation PFIR internal clock speed setting. used in 61.44*4=245.76MHz
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPfir4xDiv4p5_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * WB/NB compensation PFIR internal clock speed setting
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPfir4xDivValue_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x32), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x33), (value >> 0));

    return status;
}

/**
 * WB/NB compensation PFIR internal clock speed setting
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPfir4xDivValue_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x32), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x33), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * phase_sync_ftw_remainder
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncFtwRemainder_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x42), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x43), (value >> 0));

    return status;
}

/**
 * phase_sync_ftw_remainder
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncFtwRemainder_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x42), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x43), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) phase_sync_ftw_remainder MSB
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncFtwRemainder2316_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1f0), (value >> 0));

    return status;
}

/**
 * (B0 New) phase_sync_ftw_remainder MSB
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncFtwRemainder2316_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * phase_sync_nco_sync_cycles
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncNcoSyncCycles_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * phase_sync_nco_sync_cycles
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncNcoSyncCycles_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * phase_sync_start_sync
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncStartSync_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * phase_sync_start_sync
 */
static inline int32_t adrv9001_NvsRegmapRx_RxPhaseSyncStartSync_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) RX profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxProfileDpGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) RX profile DP Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxProfileDpGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) RX profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxProfileSsiGlobalClkEnableReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) RX profile SSI Clock Enable reset
 */
static inline int32_t adrv9001_NvsRegmapRx_RxProfileSsiGlobalClkEnableReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxRealignClk1105Status_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxRealignClkRestart_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1cc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxRealignClkRestart_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_RxRealignRxCoreClkStatus_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1cc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * pulse capture read regs to spi
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRegLoadShadow_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x131), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * pulse capture read regs to spi
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRegLoadShadow_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x131), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRfdcSram0NapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRfdcSram0NapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRfdcSram1NapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d7), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRfdcSram1NapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRxqecClockSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx_rxqec_clock_sel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxRxqecClockSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: SSI clock are gated by all_rx_enable, 1: SSI clocks are free running
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiFreeRunningClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: SSI clock are gated by all_rx_enable, 1: SSI clocks are free running
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiFreeRunningClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Global reset for the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiGlobalReset_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Global reset for the SSI interface
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiGlobalReset_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiIInvert_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ce), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiIInvert_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ce), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiISwap_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ce), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiISwap_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ce), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiQInvert_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ce), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiQInvert_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ce), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiQSwap_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1ce), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiQSwap_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1ce), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Force zero on I & Q at input of the RX SSI interfaces (LVDS & CMOS) (does not affect loopback TX to RX)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiZeroSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Force zero on I & Q at input of the RX SSI interfaces (LVDS & CMOS) (does not affect loopback TX to RX)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxSsiZeroSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This sets the gain compensation for temperature changes for Rx1. The range for this compensation is from +6.3db (rx1_rx_temp_gain_comp = 7'b1000000) to -6.3db (rx1_rx_temp_gain_comp = 63) in 0.1db steps; this is sign magnitude value with bit 6 representing sign
 */
static inline int32_t adrv9001_NvsRegmapRx_RxTempGainComp_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf3), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * This sets the gain compensation for temperature changes for Rx1. The range for this compensation is from +6.3db (rx1_rx_temp_gain_comp = 7'b1000000) to -6.3db (rx1_rx_temp_gain_comp = 63) in 0.1db steps; this is sign magnitude value with bit 6 representing sign
 */
static inline int32_t adrv9001_NvsRegmapRx_RxTempGainComp_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf3), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1: select pos jwt for RX_DDC RJ output  1’b0: select neg jwt for RX_DDC RJ output
 */
static inline int32_t adrv9001_NvsRegmapRx_RxddcPosEjwtSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1’b1: select pos jwt for RX_DDC RJ output  1’b0: select neg jwt for RX_DDC RJ output
 */
static inline int32_t adrv9001_NvsRegmapRx_RxddcPosEjwtSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * enable for rx gaintable clock
 */
static inline int32_t adrv9001_NvsRegmapRx_RxgtClkEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x160), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * enable for rx gaintable clock
 */
static inline int32_t adrv9001_NvsRegmapRx_RxgtClkEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x160), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbDpinfifoSramNapRetPsd_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d8), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbDpinfifoSramNapRetPsd_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RXNB pulse shaping PFIR gain value
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbPfirGain_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6b), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * RXNB pulse shaping PFIR gain value
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbPfirGain_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6b), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RXNB pulse shaping PFIR coefficients is symmetric or not 1: symmetric, 0: non-symmetric
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbPfirSymmetric_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * RXNB pulse shaping PFIR coefficients is symmetric or not 1: symmetric, 0: non-symmetric
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbPfirSymmetric_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RXNB pulse shaping PFIR coefficients taps
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbPfirTaps_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6c), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * RXNB pulse shaping PFIR coefficients taps
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbPfirTaps_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbResampEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: enable resampler block. 0: disable resampler block.
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbResampEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * resample phase for I channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbResampPhaseI_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc2), (value >> 0));

    return status;
}

/**
 * resample phase for I channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbResampPhaseI_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * resample phase for Q channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbResampPhaseQ_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc5), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc4), (value >> 0));

    return status;
}

/**
 * resample phase for Q channel
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbResampPhaseQ_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbRxpfir52InEn_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xcf), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enable WB/NB compensation PFIR
 */
static inline int32_t adrv9001_NvsRegmapRx_RxnbRxpfir52InEn_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xcf), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 2'b10: select pulPFIR out, 2'b01: select FM demodulation out, 2'b00: select IQ out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxoutSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xba), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * 2'b10: select pulPFIR out, 2'b01: select FM demodulation out, 2'b00: select IQ out
 */
static inline int32_t adrv9001_NvsRegmapRx_RxoutSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xba), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxqecObsCaptEnable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x174), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_RxqecObsCaptEnable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x174), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapRx_SecondNcoPhaseAv_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * sign magnitude
 */
static inline int32_t adrv9001_NvsRegmapRx_SlicerGainDisableOffsetWord_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16e), (value >> 0));

    return status;
}

/**
 * sign magnitude
 */
static inline int32_t adrv9001_NvsRegmapRx_SlicerGainDisableOffsetWord_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the external pin control mode so the BBP can control the slicer setting. Clearing this bit switches the control to an internal gain control block.
 */
static inline int32_t adrv9001_NvsRegmapRx_SlicerPinControlMode_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x168), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit enables the external pin control mode so the BBP can control the slicer setting. Clearing this bit switches the control to an internal gain control block.
 */
static inline int32_t adrv9001_NvsRegmapRx_SlicerPinControlMode_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x168), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits configure the step size of the slicer when external pin contol mode is enabled (slicer_pin_control_mode). Slicer gain in this mode is determined by multiplying the step size by the input bit code from the BBP. Step sizes are as follows: 

 * 00      1dB

 * 01      2dB

 * 10      3dB

 * 11      4dB

 * 100 6 db

 * 101, 110, 111 - 8 db
 */
static inline int32_t adrv9001_NvsRegmapRx_SlicerPinControlStep_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x169), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * These bits configure the step size of the slicer when external pin contol mode is enabled (slicer_pin_control_mode). Slicer gain in this mode is determined by multiplying the step size by the input bit code from the BBP. Step sizes are as follows: 

 * 00      1dB

 * 01      2dB

 * 10      3dB

 * 11      4dB

 * 100 6 db

 * 101, 110, 111 - 8 db
 */
static inline int32_t adrv9001_NvsRegmapRx_SlicerPinControlStep_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x169), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SwStatus0_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x179), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SwStatus0_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x179), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SwStatus1_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SwStatus1_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SysArm0Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x177), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SysArm0Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x177), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SysArm1Enable_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x177), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapRx_SysArm1Enable_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x177), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Clear the internal count value in ted block.
 */
static inline int32_t adrv9001_NvsRegmapRx_TedCntClear_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Clear the internal count value in ted block.
 */
static inline int32_t adrv9001_NvsRegmapRx_TedCntClear_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select channel I or Q data for TED.      1'b0: I channel  1'b1: Q channel
 */
static inline int32_t adrv9001_NvsRegmapRx_TedDataSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Select channel I or Q data for TED.      1'b0: I channel  1'b1: Q channel
 */
static inline int32_t adrv9001_NvsRegmapRx_TedDataSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: RK, 1: RL, 2: NBOBS_0, 3: NBOBS_1, 4: NBOBS_2, others: 0
 */
static inline int32_t adrv9001_NvsRegmapRx_TxAlgRxmux301ObsSourceSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfb), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * 0: RK, 1: RL, 2: NBOBS_0, 3: NBOBS_1, 4: NBOBS_2, others: 0
 */
static inline int32_t adrv9001_NvsRegmapRx_TxAlgRxmux301ObsSourceSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfb), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (in B0 only) 0: RK, 1: RL, 2: NBOBS_0, 3: NBOBS_1, 4: NBOBS_2, others: 0
 */
static inline int32_t adrv9001_NvsRegmapRx_TxAlgRxmux302ObsSourceSel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xfb), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (in B0 only) 0: RK, 1: RL, 2: NBOBS_0, 3: NBOBS_1, 4: NBOBS_2, others: 0
 */
static inline int32_t adrv9001_NvsRegmapRx_TxAlgRxmux302ObsSourceSel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xfb), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Correlator vectors
 */
static inline int32_t adrv9001_NvsRegmapRx_Vcorrsig_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t regInstance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8d + 0x0 + (regInstance * 0x1)), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7d + 0x0 + (regInstance * 0x1)), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6d + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Correlator vectors
 */
static inline int32_t adrv9001_NvsRegmapRx_Vcorrsig_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint32_t regInstance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8d + 0x0 + (regInstance * 0x1)), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7d + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6d + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1'b0: x5 mode  1'b1:x4 mode. Used for timing error detection block
 */
static inline int32_t adrv9001_NvsRegmapRx_X4x5Sel_Set(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1'b0: x5 mode  1'b1:x4 mode. Used for timing error detection block
 */
static inline int32_t adrv9001_NvsRegmapRx_X4x5Sel_Get(void *device,
    adrv9001_BfNvsRegmapRx_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_RX_H__