/**
 * \file
 * \brief BitField accessors for nvs_regmap_core_3
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_CORE_3_H__
 #define __ADRV9001_BF_NVS_REGMAP_CORE_3_H__

#include "adrv9001_bf_hal.h"



/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa1RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa1RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa2RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa2RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa1RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa1RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa2RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa2RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa1RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa1RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa2RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa2RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa1RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa1RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa2RampDelayEnMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa2RampDelayEnMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbAuxPllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbAuxPllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllLpClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllLpClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore1ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore1ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore2ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore2ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore3ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore3ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force hready even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHready_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) force hready even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHready_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) generate a response error from regmap if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHresp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) generate a response error from regmap if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHresp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Bypass the hresp error generator even if AHB or REG clk are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHrespBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Bypass the hresp error generator even if AHB or REG clk are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHrespBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force hready on SP even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHready_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) force hready on SP even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHready_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) generate a response error from SP if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHresp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) generate a response error from SP if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHresp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf1PllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf1PllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf2PllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf2PllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcIClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcIClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcLpClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcLpClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcQClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcQClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcIClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcIClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcLpClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcLpClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcQClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcQClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1DacClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1DacClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2DacClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2DacClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd0_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x0), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x0), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x0), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd10_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd10_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd11_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd11_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd12_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd12_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd13_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x6), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd13_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd14_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd14_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd15_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd15_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd16_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x8), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd16_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd17_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x8), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd17_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd18_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x9), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd18_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd19_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x9), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd19_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x9), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd20_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd20_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd21_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd21_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd22_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xb), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd22_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xb), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd23_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xb), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd23_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xb), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd24_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd24_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd25_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd25_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd26_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd26_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd27_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd27_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd28_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd28_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd29_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd29_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd3_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd30_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd30_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd31_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd31_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd32_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd32_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd33_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd33_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd34_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd34_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd35_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd35_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd4_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x2), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd4_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd5_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x2), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd5_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x2), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd6_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd6_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd7_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd7_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd8_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd8_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd9_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd9_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of NAP input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideNap_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of NAP input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideNap_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of PSD input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverridePsd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of PSD input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverridePsd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of RET input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideRet_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of RET input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideRet_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0DecLinearDataCapture_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0DecLinearDataCapture_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Linearity_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x6a), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x69), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Linearity_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x69), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0MsbFlip_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0MsbFlip_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Offset_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x68), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x67), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Offset_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x68), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x67), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0ReadData_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x80), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x80), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1DecLinearDataCapture_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1DecLinearDataCapture_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Linearity_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x70), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x6f), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Linearity_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x70), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1MsbFlip_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1MsbFlip_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Offset_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x6e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x6d), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Offset_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1ReadData_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x72), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x71), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x81), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x81), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2DecLinearDataCapture_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2DecLinearDataCapture_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Linearity_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x76), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x75), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Linearity_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x76), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x75), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2MsbFlip_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2MsbFlip_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Offset_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x74), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x73), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Offset_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x74), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x73), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2ReadData_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x78), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x77), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x82), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x82), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3DecLinearDataCapture_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3DecLinearDataCapture_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Linearity_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7c), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x7b), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Linearity_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x7b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3MsbFlip_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3MsbFlip_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Offset_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x7a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x79), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Offset_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x7a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x79), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3ReadData_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x7d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x83), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x83), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcDecClkInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcDecClkInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of cycles@184MHz of the reset generated by PA_RAMP delay enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcPaResetClkExtend_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x65), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of cycles@184MHz of the reset generated by PA_RAMP delay enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcPaResetClkExtend_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x65), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0Bypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0Bypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC0 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0FlipMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Flip AUXADC0 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0FlipMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0LinearCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd1), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd0), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0LinearCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0OffsetCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd8), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0OffsetCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1Bypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1Bypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC1 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1FlipMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Flip AUXADC1 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1FlipMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1LinearCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd3), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd2), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1LinearCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1OffsetCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xda), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1OffsetCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xda), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2Bypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2Bypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC2 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2FlipMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Flip AUXADC2 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2FlipMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2LinearCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd5), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd4), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2LinearCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2OffsetCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdc), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2OffsetCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3Bypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3Bypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC3 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3FlipMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Flip AUXADC3 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3FlipMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3LinearCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd7), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd6), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3LinearCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3OffsetCorr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xde), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3OffsetCorr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xde), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxgenDivRatio_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfc), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xfb), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxgenDivRatio_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xfb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Code Fabric reported an error on ARM master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x127), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x128), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x128), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on ARM master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x131), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x130), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on ARM master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x132), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on ARM master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x132), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Code Fabric reported an error on SPI-to-AHB master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x127), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x128), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x128), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on SPI master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x129), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on SPI master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on SPI master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoGmBoost_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xef), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoGmBoost_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xef), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoResLoad_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xef), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoResLoad_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xef), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x57), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x57), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Receive status for {arm_clk, clk368, clk184, golden}Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x58), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Start realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x57), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Start realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x57), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Use realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x57), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Use realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x57), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoGmBoost_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf0), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoGmBoost_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf0), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoResLoad_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf0), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoResLoad_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf0), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoDisThermalShutdown_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoDisThermalShutdown_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoFilterBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoFilterBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoGmBoost_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoGmBoost_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoIlimitInc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoIlimitInc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoResLoad_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoResLoad_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf5), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoThermalShutdown0c_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoThermalShutdown0c_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf4), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf4), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutTrim_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf4), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutTrim_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf4), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigSramSupplyOk_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleValue_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11a), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleValue_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0MaxNumberOfWordMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0MaxNumberOfWordMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleValue_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11b), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleValue_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1MaxNumberOfWordMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1MaxNumberOfWordMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleValue_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11c), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleValue_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2MaxNumberOfWordMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2MaxNumberOfWordMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleValue_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11d), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleValue_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3MaxNumberOfWordMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3MaxNumberOfWordMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleValue_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x119), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleValue_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x119), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainMaxNumberOfWordMsb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainMaxNumberOfWordMsb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcCrc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcCrc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcEcc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcEcc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select the clock of the efuse : 0=ref_clk_out, 1=ref_clk_system_tick
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Select the clock of the efuse : 0=ref_clk_out, 1=ref_clk_system_tick
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcChecksum_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x3b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x3a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcDone_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcSpareData_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x35), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x34), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x33), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1e), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1f), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x20), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x21), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccComplete_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccDoubleBitErr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x22), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccSingleBitErr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x22), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseExportWithoutEcc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseExportWithoutEcc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseExternalReadState_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemAddr_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x17), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemAddr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemDataIn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x18), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemDataIn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x18), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemDataOut_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x19), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemRd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemRd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemWr_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemWr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseInternalReadState_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseLoadEccDataIntoIntMem_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseLoadEccDataIntoIntMem_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseMrEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseMrEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: mse/ms/wmse/wms control from EFUSE,  mse/ms/wmse/wms control from SPI bits
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x37), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) 0: mse/ms/wmse/wms control from EFUSE,  mse/ms/wmse/wms control from SPI bits
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x37), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x36), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) ms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x36), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) mse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMse_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x37), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) mse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMse_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x37), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) wms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWms_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x36), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) wms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWms_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x36), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) wmse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWmse_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x37), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) wmse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWmse_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x37), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x38), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x38), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbsUseFuse_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x38), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbsUseFuse_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x38), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempco_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x39), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempco_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x39), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempcoUseFuse_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x39), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempcoUseFuse_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x39), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Priority defined (SPI first, ARM second), 1: Round Robin mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricArbScheme_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x126), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Priority defined (SPI first, ARM second), 1: Round Robin mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricArbScheme_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x126), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clock gating on AHB Fabric Crossbar
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricClkEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x126), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Clock gating on AHB Fabric Crossbar
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricClkEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x126), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Crossbar disabled for AHB bus, 1: Crossbar enabled for AHB bus
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x126), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Crossbar disabled for AHB bus, 1: Crossbar enabled for AHB bus
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x126), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma0ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma0ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma1ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma1ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma2ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma2ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma3ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma3ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp0ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp0ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp1ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp1ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp2ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp2ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp3ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp3ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA MAIN
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainDmaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA MAIN
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainDmaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for MAIN Stream Processor
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainSpClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for MAIN Stream Processor
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainSpClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf1), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf1), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf1), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf1), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapAuxPll_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapAuxPll_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPll_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPll_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPllLp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPllLp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf1Pll_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf1Pll_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf2Pll_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf2Pll_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Adc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Adc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcI_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcI_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcLp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcLp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcQ_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcQ_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Ana_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Ana_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1bAna_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1bAna_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Adc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Adc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcI_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcI_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcLp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcLp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcQ_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcQ_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Ana_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Ana_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Ana_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Ana_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Dac_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Dac_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Ana_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Ana_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Dac_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Dac_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MBIST clock division ratio. (Default is Div1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkDiv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x104), (value >> 0));

    return status;
}

/**
 * (B0 New) MBIST clock division ratio. (Default is Div1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkDiv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x104), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: REF_CLK, 1: HS_DIG_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x105), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: REF_CLK, 1: HS_DIG_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x105), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) 0: PA RAMP TX1 HIGH THRESHOLD interrupt flag, 1: PA RAMP TX1 MID THRESHOLD interrupt flag, 2: PA RAMP TX2 HIGH THRESHOLD interrupt flag, 3: PA RAMP TX2 MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampOrStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xce), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x14), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x14), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode0_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8a), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode0_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode1_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8c), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode1_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacInit_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa1), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacInit_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacOutMax_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9e), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacOutMax_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacValidCntTh_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacValidCntTh_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualUpdate_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualUpdate_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualValue_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x89), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x88), (value >> 0));

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualValue_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x89), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x88), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1DiffZeroEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1DiffZeroEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1InSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa0), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1InSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa0), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Interval_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x87), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Interval_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x87), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki0_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x91), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x90), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8f), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki0_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x91), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x90), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki1_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x94), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x93), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x92), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki1_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x94), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x93), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x92), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1KipSwitchEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x8e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1KipSwitchEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x8e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp0_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x97), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x96), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x95), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp0_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x97), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x96), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x95), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp1_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x99), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x98), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp1_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x99), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x98), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OnstateLock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OnstateLock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OpenLoopDisable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OpenLoopDisable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9). Set this value to 16'h7FFF to disable the high threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrHighTh_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa5), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa4), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9). Set this value to 16'h7FFF to disable the high threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrHighTh_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidCntTh_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa9), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidCntTh_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidStlTh_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa9), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidStlTh_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa9), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75), Set this value to 16'h7FFF to disable the mid threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidTh_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa6), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75), Set this value to 16'h7FFF to disable the mid threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidTh_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPreset_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9c), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPreset_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPresetEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x9b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPresetEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x9b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RefinSwCtrl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RefinSwCtrl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode0_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xaf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xae), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode0_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xaf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xae), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode1_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb0), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode1_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacInit_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc5), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacInit_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacOutMax_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc2), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacOutMax_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacValidCntTh_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacValidCntTh_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualUpdate_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualUpdate_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualValue_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xad), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xac), (value >> 0));

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualValue_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xad), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xac), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2DiffZeroEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2DiffZeroEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2InSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc4), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2InSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc4), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Interval_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xab), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Interval_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xab), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki0_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb5), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb3), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki0_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki1_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb8), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb6), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki1_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2KipSwitchEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xb2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2KipSwitchEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xb2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp0_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbb), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xba), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb9), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp0_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xba), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp1_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbe), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbc), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp1_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbd), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OnstateLock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OnstateLock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OpenLoopDisable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OpenLoopDisable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrHighTh_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc8), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrHighTh_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidCntTh_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcd), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidCntTh_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcd), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidStlTh_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcd), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidStlTh_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcd), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidTh_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xcb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xca), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidTh_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xcb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xca), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPreset_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc0), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPreset_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPresetEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xbf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPresetEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xbf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RefinSwCtrl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RefinSwCtrl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkInt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkInt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkIntActiveShield_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkIntActiveShield_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntClkBufferEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntClkBufferEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDivideRatio_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDivideRatio_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDividerMcsResetb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDividerMcsResetb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntMcsSampleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntMcsSampleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegAuxPllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegAuxPllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllLpClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllLpClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore1ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore1ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore2ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore2ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore3ClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore3ClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf1PllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf1PllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf2PllClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf2PllClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcIClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcIClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcLpClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcLpClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcQClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcQClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcIClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcIClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcLpClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcLpClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcQClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcQClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1DacClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1DacClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2AnaClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2AnaClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2DacClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2DacClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb1CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb1CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb2CoreClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb2CoreClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrConfig0_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xfe), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrConfig0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xfe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfd), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrConfig0_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x100), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrConfig0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x100), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xff), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xff), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xff), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xff), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x108), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x108), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x108), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x108), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x109), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x109), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x109), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x109), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ArmClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ArmClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x106), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x106), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x106), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x106), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x53), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x53), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Receive status for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x54), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Start realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x53), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Start realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x53), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Use realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x53), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Use realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x53), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1CssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1CssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1CssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1LssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1LssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1LssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2CssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2CssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2CssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2LssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2LssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2LssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3CssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3CssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3CssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3LssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3LssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3LssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x59), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x59), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x59), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x59), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5a), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5b), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for RX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PfirCoeffData_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x120), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PfirCoeffWrEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PfirCoeffWrEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxCssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxCssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxCssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxLssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxLssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxLssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x107), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x107), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x107), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x107), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10c), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10c), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10c), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10c), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10d), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10d), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10d), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ArmClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ArmClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10a), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10a), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10a), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x55), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x55), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Receive status for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x56), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Start realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x55), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Start realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x55), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Use realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x55), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Use realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x55), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1CssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1CssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1CssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1LssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1LssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1LssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2CssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2CssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2CssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2LssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2LssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2LssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3CssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3CssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3CssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3LssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3LssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3LssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5c), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5d), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5d), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5e), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for RX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PfirCoeffData_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x121), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PfirCoeffWrEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PfirCoeffWrEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxCssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxCssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxCssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxLssiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxLssiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxLssiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10b), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10b), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10b), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10b), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate AHB clock on rxqec_top (0:clock disabled, 1: clock enabled)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RxqecAhbClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xee), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate AHB clock on rxqec_top (0:clock disabled, 1: clock enabled)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RxqecAhbClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xee), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select Scan Clock before entering scan_mode : 0=PLL_clock, 1=REF_clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ScanClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x103), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Select Scan Clock before entering scan_mode : 0=PLL_clock, 1=REF_clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ScanClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x103), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp0SramNapRetPsd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x12), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp0SramNapRetPsd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp1SramNapRetPsd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x12), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp1SramNapRetPsd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp2SramNapRetPsd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x13), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp2SramNapRetPsd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp3SramNapRetPsd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x13), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp3SramNapRetPsd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Set the 16 MSB bits of the address of the system RAM for Stream Proc Main. Default is 0x20040000
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpMainBaseAddrOffsetMsb_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x102), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x101), (value >> 0));

    return status;
}

/**
 * (B0 New) Set the 16 MSB bits of the address of the system RAM for Stream Proc Main. Default is 0x20040000
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpMainBaseAddrOffsetMsb_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x102), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x101), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Legacy Mode (SPI read_data might have a contention when 2 masters access 2 registers of different regmap at the same time), 1: No contention possible on SPI read data
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiReadDataLegacyDisable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x125), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Legacy Mode (SPI read_data might have a contention when 2 masters access 2 registers of different regmap at the same time), 1: No contention possible on SPI read data
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiReadDataLegacyDisable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x125), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on ARM master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on ARM master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x15b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x15a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x159), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x158), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on ARM master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15c), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on ARM master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 0 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA0 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA0 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 0 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x147), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x146), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x145), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x144), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 0 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x148), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 0 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x148), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 1 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA1 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA1 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 1 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x149), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 1 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 1 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 2 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA2 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA2 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 2 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x151), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x150), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 2 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x152), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 2 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x152), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 3 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA3 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA3 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 3 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x156), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x155), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x154), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x153), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 3 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x157), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 3 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x157), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA Main master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA Main master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x142), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x141), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x140), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA Main master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x143), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA Main master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x143), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on SP Main master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SP_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SP_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SP Main master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SP Main master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SP Main master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on SPI-to-AHB master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSignal_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSignalClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSignalClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SPI master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSlaveHaddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x138), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x137), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x136), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x135), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SPI master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSlaveHsize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x139), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SPI master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSlaveHwrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x139), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysrefRefClkIntForcePd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysrefRefClkIntForcePd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_TestDateAndTime_Get(void *device,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x29), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x28), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x27), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_TestLotDeviceSerialNum_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x26), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x25), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x111), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x111), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x111), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x111), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x112), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x112), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x112), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x112), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ArmClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ArmClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10e), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10e), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10e), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1FromCoreClk184En_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x85), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1FromCoreClk184En_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x85), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampAuxAdcClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampAuxAdcClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x63), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x63), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for TX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PfirCoeffData_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x123), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PfirCoeffWrEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x122), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PfirCoeffWrEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x122), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10f), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10f), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10f), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10f), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x110), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x110), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x110), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x110), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x116), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x116), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x116), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x116), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x117), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x117), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x117), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x117), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ArmClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ArmClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x113), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x113), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x113), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x113), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2FromCoreClk184En_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x85), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2FromCoreClk184En_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x85), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampAuxAdcClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampAuxAdcClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x63), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x63), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for TX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PfirCoeffData_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x124), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PfirCoeffWrEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x122), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PfirCoeffWrEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x122), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x114), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x114), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x114), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x114), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosNDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x115), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosNDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x115), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosPDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x115), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosPDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x115), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiClkAlignReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiClkAlignReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiCoreClkEnAlignReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiStartClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiStartClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiUseClkAlign_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiUseClkAlign_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_UltraflexTesterId_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_WaferLotId_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x32), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x31), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x30), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_WaferNum_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_WaferXyCoord_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_CORE_3_H__