/**
 * \file
 * \brief BitField accessors for nvs_regmap_core
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_CORE_H__
 #define __ADRV9001_BF_NVS_REGMAP_CORE_H__

#include "adrv9001_bf_hal.h"



/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc1Clk1105Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x196), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc1Clk1105Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x196), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: HS_dig_clk selected, 1: HS_dig_clk/2 selected
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc1ClkDiv2Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: HS_dig_clk selected, 1: HS_dig_clk/2 selected
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc1ClkDiv2Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc1DataClk1105Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18e), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc1DataClk1105Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc1DataClkDiv2Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc1DataClkDiv2Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_adc1_lp_hpb_sel: 0: select High power ADC, 1: select Low power ADC
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc1LpHpbSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x194), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * spi_adc1_lp_hpb_sel: 0: select High power ADC, 1: select Low power ADC
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc1LpHpbSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x194), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc2Clk1105Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x196), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc2Clk1105Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x196), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc2ClkDiv2Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc2ClkDiv2Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc2DataClk1105Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18f), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc2DataClk1105Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc2DataClkDiv2Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Adc2DataClkDiv2Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_adc2_lp_hpb_sel: 0: select High power ADC, 1: select Low power ADC
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc2LpHpbSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x194), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * spi_adc2_lp_hpb_sel: 0: select High power ADC, 1: select Low power ADC
 */
static inline int32_t adrv9001_NvsRegmapCore_Adc2LpHpbSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x194), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting 1 turns on div by 2 on HS dig clock when generating adc_tuner clock, otherwise divide by 4 is used.  In system operation set to 1 when HS_dig_clk = 737MHz otherwise leave a 0 for HS_dig_clk= 1105MHz.
 */
static inline int32_t adrv9001_NvsRegmapCore_AdcTunerRCCalClkDiv2Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x161), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting 1 turns on div by 2 on HS dig clock when generating adc_tuner clock, otherwise divide by 4 is used.  In system operation set to 1 when HS_dig_clk = 737MHz otherwise leave a 0 for HS_dig_clk= 1105MHz.
 */
static inline int32_t adrv9001_NvsRegmapCore_AdcTunerRCCalClkDiv2Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x161), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Turns on adc_tuner RC cal clk
 */
static inline int32_t adrv9001_NvsRegmapCore_AdcTunerRCCalClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x161), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Turns on adc_tuner RC cal clk
 */
static inline int32_t adrv9001_NvsRegmapCore_AdcTunerRCCalClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x161), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * For use in streaming mode. When clear, the address is decremented after each byte. When set, the addresses increments after each byte.
 */
static inline int32_t adrv9001_NvsRegmapCore_AddrAscension2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * For use in streaming mode. When clear, the address is decremented after each byte. When set, the addresses increments after each byte.
 */
static inline int32_t adrv9001_NvsRegmapCore_AddrAscension2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * For use in streaming mode. When clear, the address is decremented after each byte. When set, the addresses increments after each byte.
 */
static inline int32_t adrv9001_NvsRegmapCore_AddrAscension5_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * For use in streaming mode. When clear, the address is decremented after each byte. When set, the addresses increments after each byte.
 */
static inline int32_t adrv9001_NvsRegmapCore_AddrAscension5_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_AdiCommonSpiReserved0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Reserved for future use, see ADI SPI documentation
 */
static inline int32_t adrv9001_NvsRegmapCore_AdiCommonSpiReserved1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This enables access for the stream processor, HSCI, and ARM to

 * access to the register map along with the SPI. It will also switch the clock

 * to the chip control registers over to the synchronous free-running reg_clk.
 */
static inline int32_t adrv9001_NvsRegmapCore_AhbSpiBridgeEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This enables access for the stream processor, HSCI, and ARM to

 * access to the register map along with the SPI. It will also switch the clock

 * to the chip control registers over to the synchronous free-running reg_clk.
 */
static inline int32_t adrv9001_NvsRegmapCore_AhbSpiBridgeEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaAuxPllSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dd), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaAuxPllSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaClkPllLpSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dd), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaClkPllLpSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dd), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaClkPllSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dd), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaClkPllSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx1ClkPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b9), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx1ClkPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx1McsCount_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1c0), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1bf), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx1McsCount_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1c0), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1bf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx1McsCounterActive_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1bd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx1McsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1c3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx1McsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1c3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx2ClkPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ba), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx2ClkPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ba), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx2McsCount_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1c2), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1c1), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx2McsCount_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1c2), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1c1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx2McsCounterActive_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1be), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx2McsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1c4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiRx2McsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1c4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiTx1ClkPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1bb), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiTx1ClkPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1bb), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiTx2ClkPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1bc), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaLssiTx2ClkPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1bc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRf1PllSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dd), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRf1PllSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRf2PllSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dd), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRf2PllSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1Adc1SwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1Adc1SwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1Adc2ISwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1Adc2ISwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1Adc2QSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1Adc2QSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1AdcLpSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1de), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1AdcLpSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1de), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1AnalogSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx1AnalogSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2Adc1SwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2Adc1SwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2Adc2ISwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2Adc2ISwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2Adc2QSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2Adc2QSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2AdcLpSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1de), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2AdcLpSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1de), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2AnalogSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1db), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaRx2AnalogSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1db), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx1AnalogSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx1AnalogSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx1DacSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dc), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx1DacSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx2AnalogSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dc), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx2AnalogSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx2DacSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1dc), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AnaTx2DacSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1dc), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogHsDigClockSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x196), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogHsDigClockSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x196), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsRx1ClockSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x196), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsRx1ClockSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x196), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsRx2ClockSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x196), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsRx2ClockSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x196), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsTx1ClockSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x196), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsTx1ClockSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x196), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsTx2ClockSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x196), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogLvdsTx2ClockSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x196), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Spare o2a bits
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogSpare_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1df), (value >> 0));

    return status;
}

/**
 * Spare o2a bits
 */
static inline int32_t adrv9001_NvsRegmapCore_AnalogSpare_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1df), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Disable bus response for all interfaces to the SPI arbiter
 */
static inline int32_t adrv9001_NvsRegmapCore_ArbDisableResp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Disable bus response for all interfaces to the SPI arbiter
 */
static inline int32_t adrv9001_NvsRegmapCore_ArbDisableResp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Number of reg_clk cycles to wait while reading (facilitates

 * multicycle path). The read mux is timed to a 10ns max delay.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArbRdCount_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xdb), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Number of reg_clk cycles to wait while reading (facilitates

 * multicycle path). The read mux is timed to a 10ns max delay.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArbRdCount_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xdb), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Number of reg_clk cycles to wait while reading (facilitates

 * multicycle path). The read mux is timed to a 10ns max delay.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArbRdCountAnalog_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xdc), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Number of reg_clk cycles to wait while reading (facilitates

 * multicycle path). The read mux is timed to a 10ns max delay.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArbRdCountAnalog_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xdc), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pointer for address in memory to start execution on boot
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmBootAddr_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xd6), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xd5), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xd4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xd3), (value >> 0));

    return status;
}

/**
 * Pointer for address in memory to start execution on boot
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmBootAddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd5), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will force the chip general purpose interrupt. Intended to indicate any calibration error.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmCalibrationError_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit will force the chip general purpose interrupt. Intended to indicate any calibration error.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmCalibrationError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ARM Clock Select: 00 = Not Enabled, 01 => Divide by 4 of HS_CLK, 10 => Divide by 6 of HS_CLK, 11 => Not enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x192), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * ARM Clock Select: 00 = Not Enabled, 01 => Divide by 4 of HS_CLK, 10 => Divide by 6 of HS_CLK, 11 => Not enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x192), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Reset the arm_clk_sel divider
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClkSelReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x192), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Reset the arm_clk_sel divider
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClkSelReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x192), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Gater control for the AHB and ARM subsystem clock
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClockEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Gater control for the AHB and ARM subsystem clock
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClockEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Sets the frequency of the AHB and ARM subsystem clock as follows:

 * 00 : HS_dig_clk / 4

 * 01 : HS_dig_clk / 8

 * 10 : HS_dig_clk / 16

 * 11 : HS_dig_clk / 32

 * Maximum 250 MHz
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClockRate_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd1), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * Sets the frequency of the AHB and ARM subsystem clock as follows:

 * 00 : HS_dig_clk / 4

 * 01 : HS_dig_clk / 8

 * 10 : HS_dig_clk / 16

 * 11 : HS_dig_clk / 32

 * Maximum 250 MHz
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmClockRate_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd1), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Status and error bits for commands 36 to 39.

 *  Arm Cmd Status
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmCmdStatus_Get(void *device,
    uint8_t (*value)[16])
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x115), &register_value);
    (*value)[0] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x114), &register_value);
    (*value)[1] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x113), &register_value);
    (*value)[2] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x112), &register_value);
    (*value)[3] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x111), &register_value);
    (*value)[4] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x110), &register_value);
    (*value)[5] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x10f), &register_value);
    (*value)[6] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x10e), &register_value);
    (*value)[7] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x10d), &register_value);
    (*value)[8] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x10c), &register_value);
    (*value)[9] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x10b), &register_value);
    (*value)[10] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x10a), &register_value);
    (*value)[11] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x109), &register_value);
    (*value)[12] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x108), &register_value);
    (*value)[13] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x107), &register_value);
    (*value)[14] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x106), &register_value);
    (*value)[15] = register_value;

    return status;
}

/**
 * Read only bit; This bit indicates that the ARM is busy (either it has not read an outstanding arm command, or it is loading up initial code). This bit clears when the ARM reads the command and payload, and when it is ready to accept a new ARM command.  A new command should be written to register 0xD30 only after checking that this bit is 0.

 *  Arm Command
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmCommand_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x100), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Read only bit; This bit indicates that the ARM is busy (either it has not read an outstanding arm command, or it is loading up initial code). This bit clears when the ARM reads the command and payload, and when it is ready to accept a new ARM command.  A new command should be written to register 0xD30 only after checking that this bit is 0.

 *  Arm Command
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmCommand_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x100), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Read only bit; This bit indicates that the ARM is busy (either it has not read an outstanding arm command, or it is loading up initial code). This bit clears when the ARM reads the command and payload, and when it is ready to accept a new ARM command.  A new command should be written to register 0xD30 only after checking that this bit is 0.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmCommandBusy_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x100), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the ARM debug mode.  (This is in addition to setting the appropriate GPIO pins for ARM debug mode '- GPIO 3:0  = 0101)
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDebugEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xcf), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit enables the ARM debug mode.  (This is in addition to setting the appropriate GPIO pins for ARM debug mode '- GPIO 3:0  = 0101)
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDebugEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xcf), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This enables the capture of digital data to the SRAM in the following ways: 

 * a) Switches the SRAM clock from the AHB subsystem clock (arm_clk) to the trx_mem_clk

 * b) Switches the SRAM inputs to continually write according to the controller

 * c) Activates the controller in DP capture mode

 * The memories affected will be the last two data memories in the memory map. 

 * This mode must not be enabled at the same time as the driver mode.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpCaptureEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This enables the capture of digital data to the SRAM in the following ways: 

 * a) Switches the SRAM clock from the AHB subsystem clock (arm_clk) to the trx_mem_clk

 * b) Switches the SRAM inputs to continually write according to the controller

 * c) Activates the controller in DP capture mode

 * The memories affected will be the last two data memories in the memory map. 

 * This mode must not be enabled at the same time as the driver mode.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpCaptureEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This causes the DP capture state machine to start the capture sequence regardless of the trigger mechanism
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpCaptureForce_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * This causes the DP capture state machine to start the capture sequence regardless of the trigger mechanism
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpCaptureForce_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This selects the data to feed to the SRAM according to the following selection:

 * 00 = The 16 bit RX ch1 samples (I and Q) which are also sent to the framer, not triggered automatically

 * 01 = The 14 bit TX samples (I and Q) which are also sent to the TXQEC engine, not triggered automatically

 * 10 = link 0 deframer deskewed lane data, triggered on the rise edge of SYNC~ 

 * 11 = reserved

 * Note: On Talise first tapeout (2/2015) only setting 10 is available due to physical design restrictions.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpCaptureSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf2), (value >> 0), 0x6, 0x1);

    return status;
}

/**
 * This selects the data to feed to the SRAM according to the following selection:

 * 00 = The 16 bit RX ch1 samples (I and Q) which are also sent to the framer, not triggered automatically

 * 01 = The 14 bit TX samples (I and Q) which are also sent to the TXQEC engine, not triggered automatically

 * 10 = link 0 deframer deskewed lane data, triggered on the rise edge of SYNC~ 

 * 11 = reserved

 * Note: On Talise first tapeout (2/2015) only setting 10 is available due to physical design restrictions.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpCaptureSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf2), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Status bits indicates that drive/capture is done. (cleared when arm_dp_capture_enable and arm_dp_drv_enable are set to 0)
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDriveCaptureDone_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ArmDpDriveCaptureSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf5), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ArmDpDriveCaptureSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf5), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Capture mode: Sets the final SRAM location index to write to before stopping

 * the data capture. A value of 0 will cause the counter to continuously wrap 

 * through all SRAM locations available for capturing data without stopping.

 * Driver mode: Sets the final SRAM location index to read from before resetting.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvCounterLimit_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf1), (value >> 8), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xf0), (value >> 0));

    return status;
}

/**
 * Capture mode: Sets the final SRAM location index to write to before stopping

 * the data capture. A value of 0 will cause the counter to continuously wrap 

 * through all SRAM locations available for capturing data without stopping.

 * Driver mode: Sets the final SRAM location index to read from before resetting.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvCounterLimit_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf1), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xf0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This will reset the counter value in the DP driver state machine.

 * This is useful in capture mode after the counter stops at the final value.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvCounterReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * This will reset the counter value in the DP driver state machine.

 * This is useful in capture mode after the counter stops at the final value.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvCounterReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This will set the SRAM index to start driving or capturing from.

 * When the counter is manually reset, the controller will take it back to this value.

 * In driver mode, when the counter reaches its final value, it will reset to

 * this value.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvCounterStart_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf4), (value >> 8), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xf3), (value >> 0));

    return status;
}

/**
 * This will set the SRAM index to start driving or capturing from.

 * When the counter is manually reset, the controller will take it back to this value.

 * In driver mode, when the counter reaches its final value, it will reset to

 * this value.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvCounterStart_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf4), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xf3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set to 1, the DP driver will be activated in DAC driving mode (TX data).

 * When set to 0, the DP driver will be activated in ADC driving mode (RX data).

 * In ADC driving mode, I data comes from one SRAM while Q data comes from another.

 * In DAC driving mode, the output of the SRAMs will be used one at a time.

 * In DAC driving mode, the 32 bit SRAM output will be split into 16 bits for I

 * and Q and then used instead of the JESD deframer output.

 * in ADC driving mode, the first 20 bits of the 32 bit SRAM output will be used as 4 interleaved ADC codes
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvDacAdcbSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * When set to 1, the DP driver will be activated in DAC driving mode (TX data).

 * When set to 0, the DP driver will be activated in ADC driving mode (RX data).

 * In ADC driving mode, I data comes from one SRAM while Q data comes from another.

 * In DAC driving mode, the output of the SRAMs will be used one at a time.

 * In DAC driving mode, the 32 bit SRAM output will be split into 16 bits for I

 * and Q and then used instead of the JESD deframer output.

 * in ADC driving mode, the first 20 bits of the 32 bit SRAM output will be used as 4 interleaved ADC codes
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvDacAdcbSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This enables the driving of data from the SRAM to the datapath in the following ways:

 * a) Switches the SRAM clock from the AHB subsystem clock (arm_clk) to the trx_mem_clk

 * b) Switches the SRAM inputs to continually read according to the controller

 * c) Activates the controller in DP driving mode

 * The memories affected will be the last two data memories in the memory map.

 * This mode must not be enabled at the same time as the capture mode.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This enables the driving of data from the SRAM to the datapath in the following ways:

 * a) Switches the SRAM clock from the AHB subsystem clock (arm_clk) to the trx_mem_clk

 * b) Switches the SRAM inputs to continually read according to the controller

 * c) Activates the controller in DP driving mode

 * The memories affected will be the last two data memories in the memory map.

 * This mode must not be enabled at the same time as the capture mode.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmDpDrvEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit goes high when a watchdog timeout occurs. It remains high until a 1 is written to it . Thus is it write-1-to-clear.

 *  Watchdog timeout
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmError_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xcf), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * This bit goes high when a watchdog timeout occurs. It remains high until a 1 is written to it . Thus is it write-1-to-clear.

 *  Watchdog timeout
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xcf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 1
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x101), (value >> 0));

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 1
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x101), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 2
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x102), (value >> 0));

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 2
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x102), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 3
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte3_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x103), (value >> 0));

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 3
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x103), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 4
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte4_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x104), (value >> 0));

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 4
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte4_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x104), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 5
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte5_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x105), (value >> 0));

    return status;
}

/**
 * ARM command payload 2. All payloads should be written to before writing the ARM register 0xD30.

 *  Arm Ext Cmd Byte 5
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmExtCmdByte5_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x105), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit holds the ARM and all QEC related logic in reset.

 *  Arm Force Reset
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmForceReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd1), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Setting this bit holds the ARM and all QEC related logic in reset.

 *  Arm Force Reset
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmForceReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Slave index causing code bus fault
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmHrespCodeSlave_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xdd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Slave index causing system bus fault
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmHrespSysSlave_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xde), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Controls JTAG port destination. 0=ARM, 1=MBIST
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmJtagSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Controls JTAG port destination. 0=ARM, 1=MBIST
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmJtagSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Once the ARM image is loaded into the instruction memory, setting this bit kickstarts the ARM to start reading and executing from the instruction memory.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmM3Run_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xcf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Once the ARM image is loaded into the instruction memory, setting this bit kickstarts the ARM to start reading and executing from the instruction memory.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmM3Run_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xcf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ArmMonitorInterrupt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd0), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ArmMonitorInterrupt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, only rx_enable_by_arm, tx_enable_by_arm, and orx_enable_by_arm are valid to trigger stream. When this bit is clear, regular bbic triggers are valid
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmOverrideControl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When this bit is set, only rx_enable_by_arm, tx_enable_by_arm, and orx_enable_by_arm are valid to trigger stream. When this bit is clear, regular bbic triggers are valid
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmOverrideControl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stack pointer location
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmStackPtr_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xda), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xd9), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xd8), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xd7), (value >> 0));

    return status;
}

/**
 * Stack pointer location
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmStackPtr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xda), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd9), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd8), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xd7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will force the chip general purpose interrupt. Intended to indicate any ARM based system error.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmSystemError_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting this bit will force the chip general purpose interrupt. Intended to indicate any ARM based system error.
 */
static inline int32_t adrv9001_NvsRegmapCore_ArmSystemError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Auto increment for bus address. Incremented by the size specified in bus_size on every transaction (read or write).
 */
static inline int32_t adrv9001_NvsRegmapCore_AutoIncr_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Auto increment for bus address. Incremented by the size specified in bus_size on every transaction (read or write).
 */
static inline int32_t adrv9001_NvsRegmapCore_AutoIncr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc0DecimationCtl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cf), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc0DecimationCtl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cf), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc0Pd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc0Pd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Aux ADC read bus, via SPI
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc0Read_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1d0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc0Reset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cf), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc0Reset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc1DecimationCtl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d2), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc1DecimationCtl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d2), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc1Pd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc1Pd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Aux ADC read bus, via SPI
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc1Read_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1d3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc1Reset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc1Reset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc2DecimationCtl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d5), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc2DecimationCtl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d5), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc2Pd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc2Pd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Aux ADC read bus, via SPI
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc2Read_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1d6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc2Reset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d5), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc2Reset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc3DecimationCtl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d8), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc3DecimationCtl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc3Pd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc3Pd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Aux ADC read bus, via SPI
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc3Read_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1da), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1d9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc3Reset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1d8), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdc3Reset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSenseDecimationCtl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b5), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * Aux ADC decimation control
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSenseDecimationCtl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b5), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC temp sense digital active low reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSenseDigResetb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Aux ADC temp sense digital active low reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSenseDigResetb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSensePd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Aux ADC active high power down
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSensePd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSenseReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b5), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Aux ADC active high reset
 */
static inline int32_t adrv9001_NvsRegmapCore_AuxAdcTempSenseReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a8), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a8), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoFilterBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a9), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoFilterBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a8), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoVoutSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a8), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoVoutSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a8), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoVoutTrim_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a9), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_AuxSynthLdoVoutTrim_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a9), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register contains the number of SPI clock cycles to hold a

 * read blockout which will prevent conflict from the HSCI accessing the first 

 * large read mux simultaneously with the SPI. This number will include the cycle 

 * which the SPI takes over the read address bus, which means a setting of 2 will 

 * provide one sclk cycle of blockout time before the SPI needs the read mux.

 * Note: The ARM and stream processor use a separate read mux and will not be

 * affected by this setting.
 */
static inline int32_t adrv9001_NvsRegmapCore_BlockoutWindowSize_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd2), (value >> 0), 0x1e, 0x1);

    return status;
}

/**
 * This register contains the number of SPI clock cycles to hold a

 * read blockout which will prevent conflict from the HSCI accessing the first 

 * large read mux simultaneously with the SPI. This number will include the cycle 

 * which the SPI takes over the read address bus, which means a setting of 2 will 

 * provide one sclk cycle of blockout time before the SPI needs the read mux.

 * Note: The ARM and stream processor use a separate read mux and will not be

 * affected by this setting.
 */
static inline int32_t adrv9001_NvsRegmapCore_BlockoutWindowSize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd2), &register_value, 0x1e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Address input for DMA. Only bits [16:2] are used in legacy mode. On writing this bitfield, a read will be performed for the specified bus_size. Data can then be read back any time.
 */
static inline int32_t adrv9001_NvsRegmapCore_BusAddr_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xfa), (value >> 26), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xf9), (value >> 18));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xf8), (value >> 10));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xf7), (value >> 2));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xff), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Address input for DMA. Only bits [16:2] are used in legacy mode. On writing this bitfield, a read will be performed for the specified bus_size. Data can then be read back any time.
 */
static inline int32_t adrv9001_NvsRegmapCore_BusAddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xfa), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xf9), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xf8), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xf7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xff), &register_value, 0x3, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Flag indicating bus error response. Write to clear.
 */
static inline int32_t adrv9001_NvsRegmapCore_BusResponse_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf6), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Flag indicating bus error response. Write to clear.
 */
static inline int32_t adrv9001_NvsRegmapCore_BusResponse_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Size of read/write. 0 = byte, 1 = half-word, 2 = full-word, 3 = invalid. Legacy mode overrides this to full-word reads and byte writes.
 */
static inline int32_t adrv9001_NvsRegmapCore_BusSize_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf6), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * Size of read/write. 0 = byte, 1 = half-word, 2 = full-word, 3 = invalid. Legacy mode overrides this to full-word reads and byte writes.
 */
static inline int32_t adrv9001_NvsRegmapCore_BusSize_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf6), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flag indicating bus is stalled.
 */
static inline int32_t adrv9001_NvsRegmapCore_BusWaiting_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_ChipGradeLowerNibble_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_ChipGradeUpperNibble_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * RAD Chip Type indicator
 */
static inline int32_t adrv9001_NvsRegmapCore_ChipTypeRAD_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: HS_dig_clk/2, 1: HS_dig_clk
 */
static inline int32_t adrv9001_NvsRegmapCore_Clk1105ClkSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x195), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: HS_dig_clk/2, 1: HS_dig_clk
 */
static inline int32_t adrv9001_NvsRegmapCore_Clk1105ClkSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x195), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkPllLpVcoLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b3), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkPllLpVcoLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkPllVcoLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ab), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkPllVcoLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ab), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1aa), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1aa), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoFilterBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ab), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoFilterBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ab), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1aa), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1aa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1aa), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoVoutSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1aa), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoVoutSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1aa), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoVoutTrim_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ab), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLdoVoutTrim_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ab), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b2), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoFilterBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b3), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoFilterBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b2), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoVoutSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b2), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoVoutSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoVoutTrim_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b3), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ClkSynthLpLdoVoutTrim_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b3), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field displays the number of the last stream that completed execution (even if it failed and errored out). Each time a stream completes, this register field will get

 * reset with the new stream number value that just completed.
 */
static inline int32_t adrv9001_NvsRegmapCore_CompletedStreamNum_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x11a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * spi controller revision employed for this product
 */
static inline int32_t adrv9001_NvsRegmapCore_ControllerDocRevision_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, the chip select signal may be de-asserted during byte

 * boundaries. This only applies to single instruction mode.
 */
static inline int32_t adrv9001_NvsRegmapCore_CsbStall_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * When set, the chip select signal may be de-asserted during byte

 * boundaries. This only applies to single instruction mode.
 */
static inline int32_t adrv9001_NvsRegmapCore_CsbStall_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Mux select for the data from TXDP_SPI_INTF
 */
static inline int32_t adrv9001_NvsRegmapCore_CssiTxdpIntfSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Mux select for the data from TXDP_SPI_INTF
 */
static inline int32_t adrv9001_NvsRegmapCore_CssiTxdpIntfSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_dac_clk_hsclk_div_ratio_sel: 2'b00=>Div2, 2'b01=>Div3, 2'b10=>Div4, 2'b11=>Div6
 */
static inline int32_t adrv9001_NvsRegmapCore_Dac1ClkHsclkDivRatioSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x190), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * spi_dac_clk_hsclk_div_ratio_sel: 2'b00=>Div2, 2'b01=>Div3, 2'b10=>Div4, 2'b11=>Div6
 */
static inline int32_t adrv9001_NvsRegmapCore_Dac1ClkHsclkDivRatioSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x190), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_dac_clk_hsclk_div_ratio_sel: 2'b00=>Div2, 2'b01=>Div3, 2'b10=>Div4, 2'b11=>Div6
 */
static inline int32_t adrv9001_NvsRegmapCore_Dac2ClkHsclkDivRatioSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x191), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * spi_dac_clk_hsclk_div_ratio_sel: 2'b00=>Div2, 2'b01=>Div3, 2'b10=>Div4, 2'b11=>Div6
 */
static inline int32_t adrv9001_NvsRegmapCore_Dac2ClkHsclkDivRatioSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x191), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b0), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoFilterBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b1), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoFilterBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoVoutSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b0), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoVoutSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b0), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoVoutTrim_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b1), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkLdoVoutTrim_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b1), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_DevClkSysrefHoldWord_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1c6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1c5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_DevClkSysrefSetupWord_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1c8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1c7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * device clock input differential pair intentional offset to tilt differential pair when no input signal is present
 */
static inline int32_t adrv9001_NvsRegmapCore_DevClkbufOffsetEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * device clock input differential pair intentional offset to tilt differential pair when no input signal is present
 */
static inline int32_t adrv9001_NvsRegmapCore_DevClkbufOffsetEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkbufTrmIbias_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e1), (value >> 0), 0x18, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkbufTrmIbias_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e1), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkbufTrmVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e1), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DevClkbufTrmVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e1), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Active low reset for device clock divider.
 */
static inline int32_t adrv9001_NvsRegmapCore_DevclkDividerMcsResetb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Active low reset for device clock divider.
 */
static inline int32_t adrv9001_NvsRegmapCore_DevclkDividerMcsResetb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DeviceClkBufferEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DeviceClkBufferEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Divide Ratio selection bits: 000 : 2**0

 * 001 : 2**1

 * 010 : 2**2

 * 011 : 2**3

 * 100 : 2**4

 * 101 : 2**5

 * 110 : 2**6

 * 111:  2**7
 */
static inline int32_t adrv9001_NvsRegmapCore_DeviceClkDivideRatio_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e2), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Divide Ratio selection bits: 000 : 2**0

 * 001 : 2**1

 * 010 : 2**2

 * 011 : 2**3

 * 100 : 2**4

 * 101 : 2**5

 * 110 : 2**6

 * 111:  2**7
 */
static inline int32_t adrv9001_NvsRegmapCore_DeviceClkDivideRatio_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_DeviceConfigCustomOpModes_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x2), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_DeviceConfigOpModes_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x2), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_DeviceConfigStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x2), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DigDeviceClkBufferEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1c9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DigDeviceClkBufferEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1c9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DigSysrefSampleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1c9), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DigSysrefSampleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1c9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiRx1Clk_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b9), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiRx1Clk_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b9), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiRx2Clk_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ba), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiRx2Clk_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ba), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiTx1Clk_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1bb), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiTx1Clk_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1bb), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiTx2Clk_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1bc), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivAnaLssiTx2Clk_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1bc), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivHsDigClk_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b8), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_DivHsDigClk_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b8), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaAbort_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaAbort_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Abort Flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaAbortFlag_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA AHB Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaAhbError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaBlockBaseOffsetAddr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1b), (value >> 0));

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaBlockBaseOffsetAddr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaConfigIndexMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x10), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaConfigIndexMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x10), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaContinuousIndexMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x10), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaContinuousIndexMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x10), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. It indicates the current address being driven by DMA on the AHB Bus.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaCurrIndex_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x2c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x2d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x2e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x2f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Block Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaCurrentBlockAddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x28), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x29), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x2a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x2b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Index Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaCurrentIndexAddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x20), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x21), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x22), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x23), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Profile Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaCurrentProfileAddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x25), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x26), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x27), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA End Of Transfer Flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaEndOfTransferFlag_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Error Flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaErrorFlag_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Field Type Error flags: Bit 0: Profile Pointer fetched either in Index Table or in Block, Bit 1: Index Pointer fetched in Block-Transfer-Mode, or in Profile-Pointer-Table or in Block, Bit 2: Register entry fetched in Index Table, Bit 3: Both - END field and SKIP field flags are set. Bit4: Read-Modify-Write Instruction fetched in Index Table.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaFieldTypeError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA GENBUS Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaGenbusError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaIgnoreTxrxMatch_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x10), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaIgnoreTxrxMatch_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x10), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaMaxNumberOfWord_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1c), (value >> 0));

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaMaxNumberOfWord_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Max Word Count Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaMaxWordCountError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextRx_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x12), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextRx_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x12), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextRx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextRxMismatchError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextSkip_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x12), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextSkip_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x12), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextTx_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x12), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextTx_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x12), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextTx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaNextTxMismatchError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaRegmapOffsetAddr_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x13), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaRegmapOffsetAddr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x13), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaStartTableAddr_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x14), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x15), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x16), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x17), (value >> 0));

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaStartTableAddr_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x14), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x15), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x16), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x17), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. This is the internal state-register of the DMA finite-state-machine.
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaState_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x30), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * 3-bit Encoded Status of DMA. 000: Idle, 100: Done (without Error), 101: Done With Error, 110: Active, 111: Wait for Next
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaStop_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaStop_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Stop Flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaStopFlag_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaTableBaseOffsetAddr_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x19), (value >> 0));

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaTableBaseOffsetAddr_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x19), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextRx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaUnexpectedNextRxError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextSkip Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaUnexpectedNextSkipError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextTx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore_DmaUnexpectedNextTxError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_do_out_drv
 */
static inline int32_t adrv9001_NvsRegmapCore_DoOutDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * spi_do_out_drv
 */
static inline int32_t adrv9001_NvsRegmapCore_DoOutDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Number of parity errors accumulated
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDataParityCount_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xe2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDataParityError_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xe0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDataParityError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Input data of parity calculation (ram read data)
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDataParityIn_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xe7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xe6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xe5), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xe4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Index of bank causing error
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDataParityIndex_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe0), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Output data of parity calculation
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDataParityOut_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe3), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Tag of memory address causing error
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDataParityTag_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe0), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xe1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDisable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xdf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore_EccDisable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xdf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones).

 * Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore_EccIrqSensitivity_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xdf), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones).

 * Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore_EccIrqSensitivity_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xdf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Number of parity errors accumulated
 */
static inline int32_t adrv9001_NvsRegmapCore_EccProgParityCount_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xea), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_EccProgParityError_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xe8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_EccProgParityError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Input data of parity calculation (ram read data)
 */
static inline int32_t adrv9001_NvsRegmapCore_EccProgParityIn_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xef), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xee), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xed), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xec), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Index of bank causing error
 */
static inline int32_t adrv9001_NvsRegmapCore_EccProgParityIndex_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe8), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Output data of parity calculation
 */
static inline int32_t adrv9001_NvsRegmapCore_EccProgParityOut_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xeb), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Tag of memory address causing error
 */
static inline int32_t adrv9001_NvsRegmapCore_EccProgParityTag_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xe9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will force the chip general purpose interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_ForceGpInterrupt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit will force the chip general purpose interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_ForceGpInterrupt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoBypass1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ac), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoBypass1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ac), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoBypass2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ad), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoBypass2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ad), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoFilterBypass1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ae), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoFilterBypass1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ae), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoFilterBypass2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1af), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoFilterBypass2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1af), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoPd1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ac), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoPd1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ac), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoPd2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ad), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoPd2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ad), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_GpLdoStatus1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ac), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_GpLdoStatus2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ad), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutSel1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ac), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutSel1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ac), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutSel2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ad), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutSel2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ad), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutTrim1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ae), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutTrim1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ae), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutTrim2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1af), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_GpLdoVoutTrim2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1af), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1110Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1110Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1110SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5b), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1110SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5b), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1312Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1312Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1312SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5c), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1312SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5c), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1514Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1514Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1514SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5d), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio1514SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5d), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio10Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio10Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio10SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x56), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio10SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x56), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio32Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio32Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio32SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x57), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio32SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x57), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio54Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio54Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio54SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x58), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio54SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x58), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio76Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio76Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio76SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x59), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio76SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x59), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio98Invert_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5e), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio98Invert_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio98SourceSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5a), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Gpio98SourceSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5a), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the GPIO Telemetry mode.  (This is in addition to setting appropriate bit in ARM register)
 */
static inline int32_t adrv9001_NvsRegmapCore_GpioTelemetryEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xcf), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Setting this bit enables the GPIO Telemetry mode.  (This is in addition to setting appropriate bit in ARM register)
 */
static inline int32_t adrv9001_NvsRegmapCore_GpioTelemetryEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xcf), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: HS_clk selected, 1: Ref_clk selected (default)
 */
static inline int32_t adrv9001_NvsRegmapCore_Hs2refClockSwitchEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x193), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: HS_clk selected, 1: Ref_clk selected (default)
 */
static inline int32_t adrv9001_NvsRegmapCore_Hs2refClockSwitchEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x193), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: HS_clk disabled, 1: HS_clk enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_HsDigClkEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x193), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: HS_clk disabled, 1: HS_clk enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_HsDigClkEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x193), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_HsDigClkPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b8), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_HsDigClkPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b8), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.

 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore_LastStreamNum_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x119), (value >> 0));

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.

 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore_LastStreamNum_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x119), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Uses style of DMA access from Mykonos and previous projects. Only SRAM is accessible.
 */
static inline int32_t adrv9001_NvsRegmapCore_LegacyMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf6), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Uses style of DMA access from Mykonos and previous projects. Only SRAM is accessible.
 */
static inline int32_t adrv9001_NvsRegmapCore_LegacyMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Loopback1FilterFlip_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x170), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Loopback1FilterFlip_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x170), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Loopback2FilterFlip_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x170), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Loopback2FilterFlip_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x170), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is the enable override for the LO delay cell in loopback 1. The LO delay cell is always powered up when this bit is set. Note that this does not disable the associated LO delay correction DAC.

 *  ARM uses these bits to enable the loopback mode
 */
static inline int32_t adrv9001_NvsRegmapCore_LpbkEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16f), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * This bit is the enable override for the LO delay cell in loopback 1. The LO delay cell is always powered up when this bit is set. Note that this does not disable the associated LO delay correction DAC.

 *  ARM uses these bits to enable the loopback mode
 */
static inline int32_t adrv9001_NvsRegmapCore_LpbkEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16f), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When clear, the SPI uses an MSB first format. When this bit is set, the SPI uses an LSB first format.
 */
static inline int32_t adrv9001_NvsRegmapCore_LsbFirst1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * When clear, the SPI uses an MSB first format. When this bit is set, the SPI uses an LSB first format.
 */
static inline int32_t adrv9001_NvsRegmapCore_LsbFirst1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When clear, the SPI uses an MSB first format. When this bit is set, the SPI uses an LSB first format.
 */
static inline int32_t adrv9001_NvsRegmapCore_LsbFirst6_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * When clear, the SPI uses an MSB first format. When this bit is set, the SPI uses an LSB first format.
 */
static inline int32_t adrv9001_NvsRegmapCore_LsbFirst6_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Mux select for the data from TXDP_SPI_INTF
 */
static inline int32_t adrv9001_NvsRegmapCore_LssiTxdpIntfSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Mux select for the data from TXDP_SPI_INTF
 */
static inline int32_t adrv9001_NvsRegmapCore_LssiTxdpIntfSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_LvdsIbiasDistPd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb5), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_LvdsIbiasDistPd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb5), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_MainSpBbicStreamErrorToSpi_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x14e), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x14d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x14c), (value >> 0));

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_MainSpBbicStreamErrorToSpi_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x14e), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x14d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x14c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_MainSpBbicStreamStatus_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x14b), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x14a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x149), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * mask revision information for all level tape outs
 */
static inline int32_t adrv9001_NvsRegmapCore_MaskRevisionMajor_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x4), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * mask revision information for less than all level tape outs
 */
static inline int32_t adrv9001_NvsRegmapCore_MaskRevisionMinor_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_MasterSlaveReadbackCtl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_MasterSlaveTransferBit_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_McsAndSsiTx1FifoEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1eb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_McsAndSsiTx2FifoEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1eb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_mcs_capture_enable
 */
static inline int32_t adrv9001_NvsRegmapCore_McsCaptureEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * spi_mcs_capture_enable
 */
static inline int32_t adrv9001_NvsRegmapCore_McsCaptureEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_McsCaptureReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsCaptureReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ec), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsCaptureReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ec), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Status bit of the CLK SYNTH sigma delta modulator sequence synchronization. This bit indicates that the CLK SYNTH SDM has been synchronized.

 *  Mcs Clk Pll Sdm Sync Status
 */
static inline int32_t adrv9001_NvsRegmapCore_McsClkPllSdmSyncStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x198), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Status bit of the CLK SYNTH DEVICE CLOCK DIVIDER synchronization. This bit indicates that the CLK SYNTH DEVICE CLOCK divider has been reset during the same device clock period.

 *  Mcs Device Clk Divder Sync Status
 */
static inline int32_t adrv9001_NvsRegmapCore_McsDeviceClkDividerSyncStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x198), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Status bit of the digital clocks being synchronized. Logic high indicates that he synchronizing pulse for the digital clocks has been received, re-timed to the output of the CLK SYNTH, and sent to the digital clock generation block.

 *  Mcs Digital Clocks Sync Status
 */
static inline int32_t adrv9001_NvsRegmapCore_McsDigitalClocksSyncStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x198), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsInternalGen_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsInternalGen_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsInternalGenSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsInternalGenSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Status bit for the JESD204 MCS. Logic high indicates that the SYSREF pulses are being synchronized to the output of the CLK SYNTH (HSDIGCLK) and are being sent to the JESD204B digital.

 *  Mcs Jesd Sysref Status
 */
static inline int32_t adrv9001_NvsRegmapCore_McsJesdSysrefStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x198), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsRetimeBypass_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e7), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsRetimeBypass_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_McsSecondCaptureReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsSecondCaptureReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ec), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsSecondCaptureReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ec), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsStretchedTestSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_McsStretchedTestSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories.

 *  Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_MemHrespMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xcf), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories.

 *  Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_MemHrespMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xcf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Data input/output for DMA. Writing this register causes a bus write transaction to take place. In legacy mode, any byte written will cause that byte to be written to the bus. In non-legacy mode, only writing byte 0 will cause a write transaction for the size specified in bus_size. Reading byte 3 of this register in legacy mode with rd_wrb set will cause new data to be populated. Reading byte 0 of this register in non-legacy mode with rd_wrb set will cause new data to be populated.
 */
static inline int32_t adrv9001_NvsRegmapCore_MemWriteData_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xfe), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xfd), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xfc), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xfb), (value >> 0));

    return status;
}

/**
 * Data input/output for DMA. Writing this register causes a bus write transaction to take place. In legacy mode, any byte written will cause that byte to be written to the bus. In non-legacy mode, only writing byte 0 will cause a write transaction for the size specified in bus_size. Reading byte 3 of this register in legacy mode with rd_wrb set will cause new data to be populated. Reading byte 0 of this register in non-legacy mode with rd_wrb set will cause new data to be populated.
 */
static inline int32_t adrv9001_NvsRegmapCore_MemWriteData_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xfe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xfd), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xfc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xfb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_mon_alive_time: Alive Time count (unit: Ref Clock period)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerAliveTime_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x3f), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x40), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x41), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x42), (value >> 0));

    return status;
}

/**
 * spi_mon_alive_time: Alive Time count (unit: Ref Clock period)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerAliveTime_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x3f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x40), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x41), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x42), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current value of the mon_timer
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerCurrTime_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x44), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x45), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x46), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x47), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables the mon_timer functionality
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x35), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enables the mon_timer functionality
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x35), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Timer enable is from mon_timer_enable SPI bit; 1: Timer enables is from ( "mon_timer_enable" AND monitor-enable)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerEnableWithMonitor_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x36), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Timer enable is from mon_timer_enable SPI bit; 1: Timer enables is from ( "mon_timer_enable" AND monitor-enable)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerEnableWithMonitor_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x36), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_mon_init_time: INIT Time count (unit: Ref Clock period)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerInitTime_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x37), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x38), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x39), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x3a), (value >> 0));

    return status;
}

/**
 * spi_mon_init_time: INIT Time count (unit: Ref Clock period)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerInitTime_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x37), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x38), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x39), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x3a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * mon_timer_mode: 2'b00 => 'One Time Sleep and Alive', 2'b01 => 'Continuous Sleep-Alive Timer loop', 2'b10 => 'General Purpose (Init) Timer', 2'b11 => 'Init Timer and then continuous Sleep-Alive timer loop'
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x36), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * mon_timer_mode: 2'b00 => 'One Time Sleep and Alive', 2'b01 => 'Continuous Sleep-Alive Timer loop', 2'b10 => 'General Purpose (Init) Timer', 2'b11 => 'Init Timer and then continuous Sleep-Alive timer loop'
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x36), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_mon_sleep_time: SLEEP Time count (unit: Ref Clock period)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerSleepTime_Set(void *device,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x3b), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x3c), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x3d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x3e), (value >> 0));

    return status;
}

/**
 * spi_mon_sleep_time: SLEEP Time count (unit: Ref Clock period)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerSleepTime_Get(void *device,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x3b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x3c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x3d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x3e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Internal timer state for debug: 3'b000 => IDLE, 3'b001 => INIT, 3'b010=>SLEEP, 3'b011=>ALIVE, 3'100=>END
 */
static inline int32_t adrv9001_NvsRegmapCore_MonTimerState_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x43), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorClkDiv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x33), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorClkDiv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x33), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x33), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x33), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables the monitor function
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x31), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Enables the monitor function
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x31), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Selects the source of monitor_enable: 0: Monitor is enabled from PIN, 1: Monitor is enabled from SPI bit
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableFromSpiSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Selects the source of monitor_enable: 0: Monitor is enabled from PIN, 1: Monitor is enabled from SPI bit
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableFromSpiSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableGpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x49), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableGpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x49), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableGpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x48), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableGpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x48), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableHsclkGater_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableHsclkGater_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableSwitchRef2hsclk_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableSwitchRef2hsclk_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables the wakeup from mon_timer sleep-timeout
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableWakeupFromMonTimer_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enables the wakeup from mon_timer sleep-timeout
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableWakeupFromMonTimer_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables the wakeup from PIN
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableWakeupFromPin_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enables the wakeup from PIN
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableWakeupFromPin_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables the wakeup from SPI register bit
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableWakeupFromSpi_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Enables the wakeup from SPI register bit
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorEnableWakeupFromSpi_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Forces the input lock signal (for Debug only)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorForcePllLock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x31), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Forces the input lock signal (for Debug only)
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorForcePllLock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x31), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorInterruptClkExtend_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x49), (value >> 0), 0x7c, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorInterruptClkExtend_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x49), &register_value, 0x7c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Keeps ARM and the PLL running during SLEEP state
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorKeepArmRunning_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Keeps ARM and the PLL running during SLEEP state
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorKeepArmRunning_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Triggers the monitor to go to sleep state
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorSleepEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x31), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Triggers the monitor to go to sleep state
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorSleepEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x31), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Monitor FSM state for debug: 4'b0000=> IDLE_ALIVE, 4'b0001=>WAIT_SLEEP_ENABLE, 4'b0010=>SWITCH_TO_SPI_CLK, 4'b0011=>ARM_CLK_DISABLE, 4'b0100=>WAIT_END_INIT, 4'b0101=>SLEEP, 4'b0110=>WAKEUP, 4'b0111=>WAIT_LOCK, 4'b1000=>ARM_CLK_ENABLE, 4'b1001=>ARM_CLK_READY, 4'b1010=>SWITCH_TO_ARM_CLK, 4'b1011=>ALIVE
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorState_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x34), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Monitor and Timer start with ALIVE state first
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorTimerAliveFirst_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x32), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Monitor and Timer start with ALIVE state first
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorTimerAliveFirst_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x32), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Wakeup using this SPI bit. This bit is ignored if 'monitor_enable_wakeup_from_spi" is 0.
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorWakeupFromSpi_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x31), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Wakeup using this SPI bit. This bit is ignored if 'monitor_enable_wakeup_from_spi" is 0.
 */
static inline int32_t adrv9001_NvsRegmapCore_MonitorWakeupFromSpi_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x31), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorWakeupGpioMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x49), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorWakeupGpioMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x49), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorWakeupGpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x48), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_MonitorWakeupGpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x48), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Each bit of this field is used to configure the corresponding 1.8V GPIO pin as an input or an output. If the bit is set the pin is configured as an output, and if it is clear the pin is configured as an input.
 */
static inline int32_t adrv9001_NvsRegmapCore_NvsGpioDirectionControlOe_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x53), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x52), (value >> 0));

    return status;
}

/**
 * Each bit of this field is used to configure the corresponding 1.8V GPIO pin as an input or an output. If the bit is set the pin is configured as an output, and if it is clear the pin is configured as an input.
 */
static inline int32_t adrv9001_NvsRegmapCore_NvsGpioDirectionControlOe_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x53), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x52), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field shows the input value of the corresponding 1.8V GPIO pins when they are set as inputs (through spi_gpio_direction_control_oe).
 */
static inline int32_t adrv9001_NvsRegmapCore_NvsGpioSpiRead_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x51), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x50), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field sets the output value of the corresponding GPIO pins when SPI memory is selected as the data source for output pins
 */
static inline int32_t adrv9001_NvsRegmapCore_NvsGpioSpiSource_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x55), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x54), (value >> 0));

    return status;
}

/**
 * This field sets the output value of the corresponding GPIO pins when SPI memory is selected as the data source for output pins
 */
static inline int32_t adrv9001_NvsRegmapCore_NvsGpioSpiSource_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x55), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x54), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, if orx goes off and rx goes on at same time, orx goes off stream trigger will not be generated
 */
static inline int32_t adrv9001_NvsRegmapCore_Orx2rxWithoutPowerDown_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * When this bit is set, if orx goes off and rx goes on at same time, orx goes off stream trigger will not be generated
 */
static inline int32_t adrv9001_NvsRegmapCore_Orx2rxWithoutPowerDown_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit enables the second observation receiver as the observation receiver path.

 *  BBIC uses these bits to enable the ORx mode on Talise receivers
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x162), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * This bit enables the second observation receiver as the observation receiver path.

 *  BBIC uses these bits to enable the ORx mode on Talise receivers
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x162), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When ARM override control is set, These bits are valid to trigger orx_enable stream
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxEnableByArm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16f), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * When ARM override control is set, These bits are valid to trigger orx_enable stream
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxEnableByArm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16f), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit enables the second observation receiver as the observation receiver path.

 *  Select from 3 sets of GPIO pin pairs

 * 2'b00 : O_orx_enable         = {I_gpio_data_from_pads[1],I_gpio_data_from_pads[0]};

 * 2'b01 : O_orx_enable         = {I_gpio_data_from_pads[5],I_gpio_data_from_pads[4]};

 * 2'b10 : O_orx_enable         = {I_gpio_data_from_pads[9],I_gpio_data_from_pads[8]};

 * 2'b11 : O_orx_enable       = 2'b0;
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxEnableGpioSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x169), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * This bit enables the second observation receiver as the observation receiver path.

 *  Select from 3 sets of GPIO pin pairs

 * 2'b00 : O_orx_enable         = {I_gpio_data_from_pads[1],I_gpio_data_from_pads[0]};

 * 2'b01 : O_orx_enable         = {I_gpio_data_from_pads[5],I_gpio_data_from_pads[4]};

 * 2'b10 : O_orx_enable         = {I_gpio_data_from_pads[9],I_gpio_data_from_pads[8]};

 * 2'b11 : O_orx_enable       = 2'b0;
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxEnableGpioSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x169), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If 1, ORx signalling is via pins
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxPinMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * If 1, ORx signalling is via pins
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxPinMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 selects ORx1, 1 selects ORx2 in ORx single channel mode via SPI select
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 0 selects ORx1, 1 selects ORx2 in ORx single channel mode via SPI select
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If 1, ORx enable pin[0] to enable single ORx channel
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxSingleChMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * If 1, ORx enable pin[0] to enable single ORx channel
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxSingleChMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is only valid When orx_single_ch_mode is 1.

 * When this bit is 0, orx_select bit is valid

 * When this bit is 1, orx_select bit is invalid, and orx_enable_pin[1] selects which channel is enabled in orx_single_ch_mode. (0 selects ORx1, and 1 selects ORx2)
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxSingleChSelectPinMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * This bit is only valid When orx_single_ch_mode is 1.

 * When this bit is 0, orx_select bit is valid

 * When this bit is 1, orx_select bit is invalid, and orx_enable_pin[1] selects which channel is enabled in orx_single_ch_mode. (0 selects ORx1, and 1 selects ORx2)
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxSingleChSelectPinMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If 1, then the Rx pins are used to indicate ORx mode activation/deactivation instead of Rx mode
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxUsesRxPins_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * If 1, then the Rx pins are used to indicate ORx mode activation/deactivation instead of Rx mode
 */
static inline int32_t adrv9001_NvsRegmapCore_OrxUsesRxPins_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x75), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x75), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntPe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x75), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntPe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x75), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntPs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x75), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntPs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x75), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x75), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpIntSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x75), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5f), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5f), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5f), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5f), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x5f), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p80SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x5f), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x69), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x69), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x69), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x69), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x69), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x69), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x69), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p810SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x69), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6a), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6a), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6a), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6a), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p811SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6a), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x60), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x60), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x60), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x60), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x60), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x60), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x60), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p81SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x60), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x61), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x61), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x61), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x61), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x61), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x61), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x61), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p82SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x61), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x62), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x62), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x62), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x62), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x62), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x62), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x62), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p83SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x62), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x63), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x63), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x63), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x63), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x63), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x63), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x63), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p84SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x63), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x64), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x64), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x64), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x64), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x64), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x64), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x64), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p85SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x64), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x65), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x65), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x65), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x65), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x65), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x65), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x65), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p86SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x65), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x66), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x66), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x66), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x66), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x66), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x66), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x66), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p87SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x66), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x67), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x67), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x67), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x67), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x67), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x67), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x67), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p88SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x67), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89Drv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x68), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89Drv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x68), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89Pe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x68), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89Pe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x68), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89Ps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x68), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89Ps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x68), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89SmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x68), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadGpio1p89SmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x68), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadModeDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6c), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadModeDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadModeSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6c), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadModeSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6c), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x76), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x76), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkPe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x76), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkPe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x76), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkPs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x76), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkPs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x76), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x76), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRefClkSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x76), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadResetNDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6b), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadResetNDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadResetNSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6b), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadResetNSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6b), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7f), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7f), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7f), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7f), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7f), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7f), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7f), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1IdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7f), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x82), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x82), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x82), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x82), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x82), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x82), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x82), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x82), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x82), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x82), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x82), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1QdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x82), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x79), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x79), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x79), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x79), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x79), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x79), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x79), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x79), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x79), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x79), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x79), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1ClkCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x79), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnableDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x73), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnableDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x73), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnablePe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x73), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnablePe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x73), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnablePs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x73), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnablePs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x73), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnableSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x73), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1EnableSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x73), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7c), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7c), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7c), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7c), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7c), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7c), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx1StrobeCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7c), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8b), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8b), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8b), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8b), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8b), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8b), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2IdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8b), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8e), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8e), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8e), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8e), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8e), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8e), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8e), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2QdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8e), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x85), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x85), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x85), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x85), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x85), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x85), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x85), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x85), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x85), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x85), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x85), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2ClkCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x85), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnableDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x74), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnableDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x74), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnablePe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x74), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnablePe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x74), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnablePs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x74), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnablePs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x74), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnableSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x74), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2EnableSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x74), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x88), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x88), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x88), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x88), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x88), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x88), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x88), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x88), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x88), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x88), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x88), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadRx2StrobeCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x88), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6e), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6e), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkPe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6e), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkPe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkPs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6e), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkPs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6e), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiClkSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6e), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6d), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6d), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbPe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6d), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbPe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbPs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6d), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbPs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6d), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiCsbSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6d), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6f), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6f), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiPe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6f), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiPe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiPs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6f), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiPs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x6f), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDiSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x6f), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x70), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x70), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoPe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x70), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoPe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x70), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoPs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x70), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoPs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x70), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x70), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadSpiDoSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x70), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9a), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9a), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9a), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9a), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9a), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9a), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1IdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9a), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9e), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9e), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9e), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9e), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9e), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9e), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9e), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1QdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9e), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x92), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x92), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x92), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x92), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x92), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x92), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x92), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x92), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x92), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x92), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x92), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1ClkCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x92), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnableDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x71), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnableDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x71), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnablePe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x71), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnablePe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x71), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnablePs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x71), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnablePs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x71), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnableSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x71), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1EnableSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x71), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa1), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa1), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa1), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa1), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa1), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa1), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa1), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1RefclkCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa1), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x96), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x96), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x96), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x96), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x96), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x96), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x96), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x96), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x96), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x96), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x96), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx1StrobeCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x96), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xad), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xad), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xad), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xad), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xad), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xad), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xad), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xad), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xad), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xad), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xad), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2IdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xad), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb1), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb1), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb1), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb1), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb1), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb1), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb1), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2QdataCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb1), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa5), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa5), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa5), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa5), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa5), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa5), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa5), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa5), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa5), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2ClkCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa5), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnableDrv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x72), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnableDrv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x72), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnablePe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x72), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnablePe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x72), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnablePs_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x72), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnablePs_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x72), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnableSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x72), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2EnableSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x72), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb4), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb4), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb4), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb4), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb4), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb4), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb4), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2RefclkCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb4), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosDrvSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa9), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosDrvSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa9), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPeN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa9), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPeN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPeP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa9), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPeP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPsN_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa9), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPsN_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPsP_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa9), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosPsP_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosSmittTrig_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa9), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PadTx2StrobeCmosSmittTrig_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa9), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_PagePointerDeviceIndexValue0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * see spi controller doc. Not used on Talise.
 */
static inline int32_t adrv9001_NvsRegmapCore_PagePointerDeviceIndexValue1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PdBbRefclkActiveShield_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1c9), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PdBbRefclkActiveShield_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1c9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PdMasterbias_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b4), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_PdMasterbias_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Byte address of coefficient to write/read
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffAddr70_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x153), (value >> 0));

    return status;
}

/**
 * Byte address of coefficient to write/read
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffAddr70_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x153), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * MSB bit of coefficient address
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffAddr8_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x154), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * MSB bit of coefficient address
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffAddr8_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x154), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Byte of coefficient data
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffData_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x152), (value >> 0));

    return status;
}

/**
 * Byte of coefficient data
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffData_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x152), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select Rx A bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxASel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x151), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Select Rx A bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxASel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x151), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select Rx B bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxBSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x151), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Select Rx B bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxBSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x151), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select Rx C bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxCSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x151), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Select Rx C bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxCSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x151), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select Rx D bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxDSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x151), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Select Rx D bank
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffRxDSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x151), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Write data into specified address of specified bank(s) (self clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffWrEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x151), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Write data into specified address of specified bank(s) (self clear)
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirCoeffWrEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x151), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Selection between Rx coefficient banks. 0=A, 1=B, 2=C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirLoopbackBankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x159), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Selection between Rx coefficient banks. 0=A, 1=B, 2=C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirLoopbackBankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x159), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Selection between Rx coefficient banks. 0=A, 1=B, 2=C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirRx1BankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x199), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Selection between Rx coefficient banks. 0=A, 1=B, 2=C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirRx1BankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x199), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Selection between Rx coefficient banks. 0=A, 1=B, 2=C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirRx2BankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x19a), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Selection between Rx coefficient banks. 0=A, 1=B, 2=C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirRx2BankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x19a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select TX bank A
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxACoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Select TX bank A
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxACoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select TX bank B
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxBCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Select TX bank B
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxBCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select TX bank C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxCCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Select TX bank C
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxCCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select TX bank D
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxDCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Select TX bank D
 */
static inline int32_t adrv9001_NvsRegmapCore_PfirTxDCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_RcalStart_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x161), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_RcalStart_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x161), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1 = read, 0 = write
 */
static inline int32_t adrv9001_NvsRegmapCore_RdWrb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf6), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 1 = read, 0 = write
 */
static inline int32_t adrv9001_NvsRegmapCore_RdWrb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf6), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 0. Reading the register semaphore0 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore0 is shadowed in register semaphore0_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x12b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 1. Reading the register semaphore1 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 1 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x12c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Treadback value for semaphore 10. Reading the register semaphore10 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 10 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore10_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x135), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 11. Reading the register semaphore11 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 11 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore11_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x136), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 12. Reading the register semaphore12 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 12 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore12_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x137), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 13. Reading the register semaphore13 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 13 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore13_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x138), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 14. Reading the register semaphore14 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 14 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore14_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x139), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 15. Reading the register semaphore15 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 15 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore15_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x13a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 2. Reading the register semaphore2 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 2 is shadowed in register semaphore2_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x12d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 3. Reading the register semaphore3 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 3 is shadowed in register semaphore3_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x12e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 4. Reading the register semaphore4 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 4 is shadowed in register semaphore4_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore4_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x12f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 5. Reading the register semaphore5 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 5 is shadowed in register semaphore5_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore5_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x130), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 6. Reading the register semaphore6 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 6 is shadowed in register semaphore6_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore6_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x131), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 7. Reading the register semaphore7 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 7 is shadowed in register semaphore7_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore7_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x132), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 8. Reading the register semaphore8 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 8 is shadowed in register semaphore8_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore8_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x133), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * readback value for semaphore 9. Reading the register semaphore9 from any master, will result in the lock bit within the register getting set. To avoid that , the readback value of sempahore 9 is shadowed in register semaphore9_readback.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReadbackValSemaphore9_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x134), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdAuxPll_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ca), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdAuxPll_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ca), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdClkPll_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ca), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdClkPll_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ca), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdClkPllLp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ca), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdClkPllLp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ca), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdRfpll1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ca), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdRfpll1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ca), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdRfpll2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ca), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefClkGenPdRfpll2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ca), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefPadBypBiasR_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e1), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RefPadBypBiasR_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Many delay settings in the device use a resolution of 1LSB/s. For that to be correct, this register must be programmed with the number of reference clock cycles per s minus 1. Reference clock is device clock divided by dig_dev_clk_divide_ratio.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReferenceClockCycles_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x18d), (value >> 0));

    return status;
}

/**
 * Many delay settings in the device use a resolution of 1LSB/s. For that to be correct, this register must be programmed with the number of reference clock cycles per s minus 1. Reference clock is device clock divided by dig_dev_clk_divide_ratio.
 */
static inline int32_t adrv9001_NvsRegmapCore_ReferenceClockCycles_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x18d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ResampleClkDivRatio_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e4), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ResampleClkDivRatio_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e4), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Reading or writing to this bitfield will cause the polarity of the RW bit in the SPI sequence to be compliant with the spec
 */
static inline int32_t adrv9001_NvsRegmapCore_ResetRwPolarity_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1fd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Reading or writing to this bitfield will cause the polarity of the RW bit in the SPI sequence to be compliant with the spec
 */
static inline int32_t adrv9001_NvsRegmapCore_ResetRwPolarity_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1fd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ResetbTflash_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e0), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_ResetbTflash_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Reading or writing to this bitfield will cause the polarity of the RW bit in the SPI sequence to be reversed from the spec
 */
static inline int32_t adrv9001_NvsRegmapCore_ReverseRwPolarity_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1fe), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Reading or writing to this bitfield will cause the polarity of the RW bit in the SPI sequence to be reversed from the spec
 */
static inline int32_t adrv9001_NvsRegmapCore_ReverseRwPolarity_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1fe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx1 Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx1 Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx1 Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx1 Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7e), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx1 Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7e), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7e), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx1 Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7e), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 Idata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Idata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx1 Idata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1IdataVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x80), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x80), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x80), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x80), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x80), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x80), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x80), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x80), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x81), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x81), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x81), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x81), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x81), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x81), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x80), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x80), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 Qdata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x80), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx1 Qdata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1QdataVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x80), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1AdcDelaySel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b6), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1AdcDelaySel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b6), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x77), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx1 clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x77), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x77), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx1 clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x77), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x77), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx1 clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x77), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x77), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx1 clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x77), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x78), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx1 clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x78), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x78), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx1 clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x78), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x78), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 clock LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x78), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x77), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x77), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 clock LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x77), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx1 clock LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1ClkVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x77), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1DemuxEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1DemuxEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_Rx1LvdsMcsCaptureReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ea), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_Rx1LvdsMcsSecondCaptureReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ea), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1MagBankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e6), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1MagBankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e6), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1McsDelayCnt_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1ee), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1ed), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1McsDelayCnt_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1ee), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1ed), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1McsReadFifoDelayCnt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1f3), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1McsReadFifoDelayCnt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1f3), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1McsSecondCaptureReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ec), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1McsSecondCaptureReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ec), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1NbCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x160), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1NbCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x160), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1RxqecCorrRdyGenOffTime_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x183), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x182), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1RxqecCorrRdyGenOffTime_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x183), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x182), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1RxqecCorrRdyGenOnTime_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x181), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1RxqecCorrRdyGenOnTime_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x181), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1RxqecCorrRdyGenSoftReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx1RxqecCorrRdyGenSoftReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx1 strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx1 strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx1 strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx1 strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7b), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx1 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7b), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7b), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx1 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7b), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 strobe LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1 strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1 strobe LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x7a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx1 strobe LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1StrobeVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x7a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Interface Enable Bit enables the module.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Interface Enable Bit enables the module.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit clears the spi_rx1dp_intf_fifo_data_lost_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoDataLostClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit clears the spi_rx1dp_intf_fifo_data_lost_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoDataLostClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1dp_intf_fifo_data_lost_irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoDataLostIrqEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx1dp_intf_fifo_data_lost_irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoDataLostIrqEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This status bit is set to indicate that the data from the RX1 datapath could not be written to the FIFO because the FIFO was full.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoDataLostStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xca), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * After the Interface is enabled, the read-request is asserted when the FIFO level raises above the value programmed in this register.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoRdStartThreshold_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc7), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * After the Interface is enabled, the read-request is asserted when the FIFO level raises above the value programmed in this register.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoRdStartThreshold_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc7), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit clears the spi_rx1dp_intf_fifo_read_error_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoReadErrorClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit clears the spi_rx1dp_intf_fifo_read_error_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoReadErrorClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1dp_intf_fifo_read_error_irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoReadErrorIrqEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx1dp_intf_fifo_read_error_irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoReadErrorIrqEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This status bit is set when the user attempts to read the FIFO when the FIFO is empty. The data is not read from the FIFO in this case. This is a potential error condition.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfFifoReadErrorStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xca), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Idata.  Reading to the spi_rx1dp_intf_idata[7:0] triggers a read from the FIFO.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfIdata_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xcd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xce), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 => Interrupt output signals are level signals

 * 1 => Interrupt output signals are pulse-signals. Pulse duration is one clock-period of the respective clocks on which the interrupts are generated.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfIrqEdgeTriggered_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0 => Interrupt output signals are level signals

 * 1 => Interrupt output signals are pulse-signals. Pulse duration is one clock-period of the respective clocks on which the interrupts are generated.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfIrqEdgeTriggered_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Qdata
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfQdata_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xcb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xcc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit clears the spi_rx1dp_intf_read_request_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfReadRequestClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit clears the spi_rx1dp_intf_read_request_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfReadRequestClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 => read_request_irq is cleared by explicit write to  'spi_rx1dp_intf_read_request_clear' bit. 1 => read_request_irq is cleared automatically when the spi_rx1dp_intf_idata[7:0] is read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfReadRequestIrqAutoclear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0 => read_request_irq is cleared by explicit write to  'spi_rx1dp_intf_read_request_clear' bit. 1 => read_request_irq is cleared automatically when the spi_rx1dp_intf_idata[7:0] is read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfReadRequestIrqAutoclear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx1dp_intf_read_request irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfReadRequestIrqEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xc8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx1dp_intf_read_request irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfReadRequestIrqEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xc8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This status bit is set to indicate the request for the BBIC to read data from the FIFO.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx1dpIntfReadRequestStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xca), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x89), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx2_Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x89), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x89), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx2_Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x89), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x89), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx2_Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x89), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x89), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx2_Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x89), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8a), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx2_Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8a), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8a), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx2_Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8a), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2_Idata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x89), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2_Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x89), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Idata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x89), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx2_Idata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2IdataVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x89), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8d), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8d), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8d), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8d), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2_Qdata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx2_Qdata LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2QdataVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2AdcDelaySel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b7), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2AdcDelaySel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x83), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx2.clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x83), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x83), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx2.clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x83), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x83), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx2.clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x83), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x83), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx2.clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x83), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x84), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx2.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x84), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x84), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx2.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x84), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x84), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2.clock LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x84), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x83), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2.clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x83), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2.clock LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x83), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx2.clock LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2ClkVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x83), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2DemuxEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1b7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2DemuxEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1b7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_Rx2LvdsMcsCaptureReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ea), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_Rx2LvdsMcsSecondCaptureReceived_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ea), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2MagBankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e6), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2MagBankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e6), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2McsDelayCnt_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1f0), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1ef), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2McsDelayCnt_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1ef), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2McsReadFifoDelayCnt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1f8), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2McsReadFifoDelayCnt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1f8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2McsSecondCaptureReceivedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ec), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2McsSecondCaptureReceivedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ec), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2NbCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x160), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2NbCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x160), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2RxqecCorrRdyGenOffTime_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x186), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x185), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2RxqecCorrRdyGenOffTime_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x186), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x185), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2RxqecCorrRdyGenOnTime_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x184), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2RxqecCorrRdyGenOnTime_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x184), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2RxqecCorrRdyGenSoftReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Rx2RxqecCorrRdyGenSoftReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x86), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * rx2 strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x86), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x86), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * rx2 strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x86), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x86), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * rx2 strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x86), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x86), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * rx2 strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x86), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x87), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * rx2 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x87), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x87), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * rx2 strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x87), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x87), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2 strobe LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x87), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x86), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx2 strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x86), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx2 strobe LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x86), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * rx2 strobe LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2StrobeVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x86), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, if rx goes off and orx goes on at same time, rx goes off stream trigger will not be generated
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2orxWithoutPowerDown_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When this bit is set, if rx goes off and orx goes on at same time, rx goes off stream trigger will not be generated
 */
static inline int32_t adrv9001_NvsRegmapCore_Rx2orxWithoutPowerDown_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_rx_alg_mux301_firA_byp
 */
static inline int32_t adrv9001_NvsRegmapCore_RxAlgMux301FirAByp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x14f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * spi_rx_alg_mux301_firA_byp
 */
static inline int32_t adrv9001_NvsRegmapCore_RxAlgMux301FirAByp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x14f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_rx_alg_mux302_ch1_sel
 */
static inline int32_t adrv9001_NvsRegmapCore_RxAlgMux302Ch1Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x14f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * spi_rx_alg_mux302_ch1_sel
 */
static inline int32_t adrv9001_NvsRegmapCore_RxAlgMux302Ch1Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x14f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_rx_alg_mux303_ch1_sel
 */
static inline int32_t adrv9001_NvsRegmapCore_RxAlgMux303Ch1Sel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x14f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * spi_rx_alg_mux303_ch1_sel
 */
static inline int32_t adrv9001_NvsRegmapCore_RxAlgMux303Ch1Sel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x14f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank A

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in NAVASSA
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankAPfirDecimation_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x155), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank A

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in NAVASSA
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankAPfirDecimation_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x155), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank A

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankAPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x155), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank A

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankAPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x155), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank A

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankAPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x155), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank A

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankAPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x155), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankASymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x155), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankASymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x155), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank B

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in NAVASSA
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBPfirDecimation_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x156), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank B

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in NAVASSA
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBPfirDecimation_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x156), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank B

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x156), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank B

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x156), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank B

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x156), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank B

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x156), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBSymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x156), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankBSymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x156), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank C

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in Navassa
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCPfirDecimation_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x157), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank C

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in Navassa
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCPfirDecimation_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x157), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank C

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x157), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank C

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x157), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank C

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x157), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank C

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x157), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCSymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x157), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankCSymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x157), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank A

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in NAVASSA
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDPfirDecimation_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x158), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * This controls the decimation when the RX PFIR uses coefficient bank A

 * 00 --  Decimate by 1 and bypass filter 

 * 01 --  Decimate by 1 and enable filter 

 * 10 --  Decimate by 2 and enable filter 

 * 11 --  Decimate by 4 and enable filter

 * NOT USED in NAVASSA
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDPfirDecimation_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x158), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank A

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x158), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * This controls the gain when the RX PFIR uses coefficient bank A

 * 111 --   20db (x10) 

 * 110 --   14db (x5)

 * 101 --   12db  (x4)

 * 100 --   9.54dB (x3)

 * 011 --   6db

 * 010 --   0db

 * 001 --   -6db

 * 000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x158), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank D

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x158), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * This controls the number of rows of taps when the RX PFIR uses coefficient bank D

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x158), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDSymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x158), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_RxBankDSymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x158), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rx Channel 1 I Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel1IDataMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Rx Channel 1 I Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel1IDataMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rx Channel 1 Q Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel1QDataMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Rx Channel 1 Q Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel1QDataMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rx Channel 2 I Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel2IDataMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Rx Channel 2 I Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel2IDataMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rx Channel 2 Q Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel2QDataMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Rx Channel 2 Q Data Mask
 */
static inline int32_t adrv9001_NvsRegmapCore_RxChannel2QDataMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * rx_dp_gain_comp_9_update_both
 */
static inline int32_t adrv9001_NvsRegmapCore_RxDpGainComp9UpdateBoth_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x19b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * rx_dp_gain_comp_9_update_both
 */
static inline int32_t adrv9001_NvsRegmapCore_RxDpGainComp9UpdateBoth_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x19b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Force Rx On
 */
static inline int32_t adrv9001_NvsRegmapCore_RxEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x162), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Force Rx On
 */
static inline int32_t adrv9001_NvsRegmapCore_RxEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x162), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When ARM override control is set, These bits are valid to trigger rx_enable stream
 */
static inline int32_t adrv9001_NvsRegmapCore_RxEnableByArm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16f), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * When ARM override control is set, These bits are valid to trigger rx_enable stream
 */
static inline int32_t adrv9001_NvsRegmapCore_RxEnableByArm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16f), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxHpAdcSamplesLsbAligned_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x194), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxHpAdcSamplesLsbAligned_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x194), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagACoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagACoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagBCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagBCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagCCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagCCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagDCoeffSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxMagDCoeffSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit mask RX1 input data to be 0 when it is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rxadc1InputMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This bit mask RX1 input data to be 0 when it is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rxadc1InputMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit mask RX2 input data to be 0 when it is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rxadc2InputMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This bit mask RX2 input data to be 0 when it is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_Rxadc2InputMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Algorithm Select.  Hardware blocks attempts to change the state of this bit while calibration is active (see bit rxqec_calen).  

 * 0 = Tone assisted Calibration (TCAL)

 * This mode is used for offline calibration. IQ imbalance is estimated using internally generated RF test tones which are summed directly to the receive path.  See ARM mapped RxQEC registers with RXQEC_TONE prefix for algorithm specific configuration options.  Calibration results are reported by ARM mapped RxQEC registers RXQEC_STAT_{NEG,POS}{I,R}.  If bit RMODE in ARM mapped RxQEC register RXQEC_TONE_BASELINE is set to 0, calibration results are also reported by ARM mapped RxQEC registers RXQEC_STAT_{A,B,C,D}

 * 		

 * 1 = Calibration Tracking (POLY)

 * This mode is used for online calibration.  IQ imbalance is estimated based on the unexpected correlation between negative and positive frequencies.  Calibration is possible only in subbands where there is receive signal.  See ARM mapped RxQEC registers RXQEC_TRACK_WIND[23:0] and RXQEC_TRACK_CTRL for algorithm specific configuration options.  Calibration results are reported by ARM mapped RxQEC registers RXQEC_STAT_{A,B,C,D}

 * 	

 * Note: While one algorithm is paused using bit rxqec_halt, another algorithm may be executed without effecting the execution state of the paused algorithm.  Shared result reporting registers (RXQEC_STAT_{A,B,C,D}) may however be affected, so these should be saved/restored as required by software.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecAlgr_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Algorithm Select.  Hardware blocks attempts to change the state of this bit while calibration is active (see bit rxqec_calen).  

 * 0 = Tone assisted Calibration (TCAL)

 * This mode is used for offline calibration. IQ imbalance is estimated using internally generated RF test tones which are summed directly to the receive path.  See ARM mapped RxQEC registers with RXQEC_TONE prefix for algorithm specific configuration options.  Calibration results are reported by ARM mapped RxQEC registers RXQEC_STAT_{NEG,POS}{I,R}.  If bit RMODE in ARM mapped RxQEC register RXQEC_TONE_BASELINE is set to 0, calibration results are also reported by ARM mapped RxQEC registers RXQEC_STAT_{A,B,C,D}

 * 		

 * 1 = Calibration Tracking (POLY)

 * This mode is used for online calibration.  IQ imbalance is estimated based on the unexpected correlation between negative and positive frequencies.  Calibration is possible only in subbands where there is receive signal.  See ARM mapped RxQEC registers RXQEC_TRACK_WIND[23:0] and RXQEC_TRACK_CTRL for algorithm specific configuration options.  Calibration results are reported by ARM mapped RxQEC registers RXQEC_STAT_{A,B,C,D}

 * 	

 * Note: While one algorithm is paused using bit rxqec_halt, another algorithm may be executed without effecting the execution state of the paused algorithm.  Shared result reporting registers (RXQEC_STAT_{A,B,C,D}) may however be affected, so these should be saved/restored as required by software.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecAlgr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibrate Enable.  Writing a 1 to this bit commences the gathering of RxQEC calibration statistics for the Rx channel specified by bits rxqec_source[3:0], using the calibration algorithm specified by bit rxqec_algr, with the calibration identifier specified by bits rxqec_cid[1:0].  While calibration is active, attempts to change the states of bits rxqec_source, rxqec_algr, or rxqec_cid are blocked by hardware.  Writing a zero to this bit has no effect.  When read, this bit returns a 1 if gathering of statistics is active, or a 0 if gathering has ended.  To end the gathering of statistics early, the user may clear bit rxqec_rpt to 0 to cause the current iteration to run to completion and be the final.  Alternatively, bit rxqec_halt may asserted to trigger an immediate suspension of the gathering of statistics.  Once an iteration of the gathering of statistics completes, hardware sets bit CUPD (Calibration Update) in ARM mapped RxQEC register RXQEC_FLAG to flag this event.  If calibration completes (bit rxqec_calen falls) without influence from either rxqec_halt or rxqec_clear, bit CDONE (Calibration Done) in ARM mapped RxQEC register RXQEC_FLAG is asserted to indicate a proper completion of calibration.

 * When Written:

 * 0 = No Effect

 * 1 = Start gathering of Calibration Statistics, or Continue a Halted gathering of statistics (see bit rxqec_halt)

 * When Read:

 * 0 = Calibration Idle

 * 1 = Statistics Gathering for Calibration Active
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecCalen_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Calibrate Enable.  Writing a 1 to this bit commences the gathering of RxQEC calibration statistics for the Rx channel specified by bits rxqec_source[3:0], using the calibration algorithm specified by bit rxqec_algr, with the calibration identifier specified by bits rxqec_cid[1:0].  While calibration is active, attempts to change the states of bits rxqec_source, rxqec_algr, or rxqec_cid are blocked by hardware.  Writing a zero to this bit has no effect.  When read, this bit returns a 1 if gathering of statistics is active, or a 0 if gathering has ended.  To end the gathering of statistics early, the user may clear bit rxqec_rpt to 0 to cause the current iteration to run to completion and be the final.  Alternatively, bit rxqec_halt may asserted to trigger an immediate suspension of the gathering of statistics.  Once an iteration of the gathering of statistics completes, hardware sets bit CUPD (Calibration Update) in ARM mapped RxQEC register RXQEC_FLAG to flag this event.  If calibration completes (bit rxqec_calen falls) without influence from either rxqec_halt or rxqec_clear, bit CDONE (Calibration Done) in ARM mapped RxQEC register RXQEC_FLAG is asserted to indicate a proper completion of calibration.

 * When Written:

 * 0 = No Effect

 * 1 = Start gathering of Calibration Statistics, or Continue a Halted gathering of statistics (see bit rxqec_halt)

 * When Read:

 * 0 = Calibration Idle

 * 1 = Statistics Gathering for Calibration Active
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecCalen_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration ID.  Hardware blocks attempts to change the state of these bits while calibration is active (see bit rxqec_calen).  These bits specify which of four RxQEC flag register is affected by calibration events.

 * 00 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG12

 * 01 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG34

 * 10 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG56 

 * 11 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG78
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecCid_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17b), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * Calibration ID.  Hardware blocks attempts to change the state of these bits while calibration is active (see bit rxqec_calen).  These bits specify which of four RxQEC flag register is affected by calibration events.

 * 00 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG12

 * 01 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG34

 * 10 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG56 

 * 11 = RxQEC_PROC_FLAG0 and RxQEC_PROC_FLAG78
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecCid_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17b), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration Clear.  Writing a 1 to this bit triggers an initialization of the algorithm specified by the value simultaneously written to bit rxqec_algr.  Initialization of an algorithm will not influence previously gathered observation statistics (see ARM mapped RxQEC registers RXQEC_STAT*) until a subsequent calibration overwrites them.  For tone based calibration (rxqec_algr = 0), rxqec_clear causes the sequencing of enabled tones to be restarted from the beginning, that is, from the first enabled negative tone closest to DC.  For calibration tracking (rxqec_algr = 1), rxqec_clear causes the current integrator state to be excluded from the next integrator state (next integrator state will be dependent solely on the next accumulator state).  Clear also causes accumulator state preserved from a previously halted calibration to be discarded (see bit rxqec_halt in this registers, and bit RAVG in register RXQEC_TRACK_CTRL).  If an algorithm (tone or tracking) is cleared while it is active, calibration will be immediately restarted from the algorithms reset state.  If an algorithm is cleared while it is not active, preserved execution state from the most recent calibration halt (see bit rxqec_halt) is forgotten.  When this bit is read a 0 is always returned. 

 * When Written:

 * 0 = No effect

 * 1 = Reset sequencing and data gathering for algorithm specified by bits rxqec_algr
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Calibration Clear.  Writing a 1 to this bit triggers an initialization of the algorithm specified by the value simultaneously written to bit rxqec_algr.  Initialization of an algorithm will not influence previously gathered observation statistics (see ARM mapped RxQEC registers RXQEC_STAT*) until a subsequent calibration overwrites them.  For tone based calibration (rxqec_algr = 0), rxqec_clear causes the sequencing of enabled tones to be restarted from the beginning, that is, from the first enabled negative tone closest to DC.  For calibration tracking (rxqec_algr = 1), rxqec_clear causes the current integrator state to be excluded from the next integrator state (next integrator state will be dependent solely on the next accumulator state).  Clear also causes accumulator state preserved from a previously halted calibration to be discarded (see bit rxqec_halt in this registers, and bit RAVG in register RXQEC_TRACK_CTRL).  If an algorithm (tone or tracking) is cleared while it is active, calibration will be immediately restarted from the algorithms reset state.  If an algorithm is cleared while it is not active, preserved execution state from the most recent calibration halt (see bit rxqec_halt) is forgotten.  When this bit is read a 0 is always returned. 

 * When Written:

 * 0 = No effect

 * 1 = Reset sequencing and data gathering for algorithm specified by bits rxqec_algr
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecCommonClkEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecCommonClkEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration Halt.  Writing a 1 to this bit causes a calibration in progress to be immediately suspended.  A suspended calibration will resume from where it was halted when next enabled (bit rxqec_calen of register rxqec_ctrl1) asserted) unless bit rxqec_clear is asserted before or coincident to it being resumed. Bit rxqec_halt applies to whichever algorithm is running.  This differs from rxqec_clear which applies to the algorithm specified by bit rxqec_algr.  Bits rxqec_halt, rxqec_clear and rxqec_calen may be asserted in any combination, including together, which would cause any active calibration to be halted, and the calibration specified by bit rxqec_algr to be initiated with previous calibrate state forgotten.  Note: Hardware delays the internal serving of rxqec_halt if calibration tracking is active (rxqec_algr=1) and calibration statistics (ARM mapped RxQEC registers RXQEC_STAT*) are actively being updated as rxqec_halt is asserted.  This ensures that gathered tracking statistics are always fully associated.  Other than possibly extending the apparent duration of a new calibration initiated immediately after rxqec_halt (due to delaying the actual start time of this new calibration), the effects of delaying internal hardware servicing of rxqec_halt is invisible to the user.  However, immediately after reading calibration statistics, bit SOR in ARM mapped RxQEC register RXQEC_PROC_FLAG should always be read to ensure that hardware was not in the midst of updating these registers.  When this bit is read a 0 is always returned. 

 * When Written:

 * 0 = No effect

 * 1 = Suspend statistics gathering without losing current state, resume when bit rxqec_calen is next asserted, unless reset by rxqec_clear
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecHalt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Calibration Halt.  Writing a 1 to this bit causes a calibration in progress to be immediately suspended.  A suspended calibration will resume from where it was halted when next enabled (bit rxqec_calen of register rxqec_ctrl1) asserted) unless bit rxqec_clear is asserted before or coincident to it being resumed. Bit rxqec_halt applies to whichever algorithm is running.  This differs from rxqec_clear which applies to the algorithm specified by bit rxqec_algr.  Bits rxqec_halt, rxqec_clear and rxqec_calen may be asserted in any combination, including together, which would cause any active calibration to be halted, and the calibration specified by bit rxqec_algr to be initiated with previous calibrate state forgotten.  Note: Hardware delays the internal serving of rxqec_halt if calibration tracking is active (rxqec_algr=1) and calibration statistics (ARM mapped RxQEC registers RXQEC_STAT*) are actively being updated as rxqec_halt is asserted.  This ensures that gathered tracking statistics are always fully associated.  Other than possibly extending the apparent duration of a new calibration initiated immediately after rxqec_halt (due to delaying the actual start time of this new calibration), the effects of delaying internal hardware servicing of rxqec_halt is invisible to the user.  However, immediately after reading calibration statistics, bit SOR in ARM mapped RxQEC register RXQEC_PROC_FLAG should always be read to ensure that hardware was not in the midst of updating these registers.  When this bit is read a 0 is always returned. 

 * When Written:

 * 0 = No effect

 * 1 = Suspend statistics gathering without losing current state, resume when bit rxqec_calen is next asserted, unless reset by rxqec_clear
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecHalt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RxQEC Indirect Register Address (bits 12:8).  These MSBs, together with LSBs specified by register rxqec_iaddr0, form a 12 bit indirect register address.  This address specifies the ARM mapped RxQEC register accessed when either bit rxqec_read or rxqec_write of register rxqec_iaddr1 is asserted.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecIaddr_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17a), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * RxQEC Indirect Register Address (bits 12:8).  These MSBs, together with LSBs specified by register rxqec_iaddr0, form a 12 bit indirect register address.  This address specifies the ARM mapped RxQEC register accessed when either bit rxqec_read or rxqec_write of register rxqec_iaddr1 is asserted.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecIaddr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17a), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RxQEC Indirect Register Address (bits 7:0).  These LSBs, together with MSBs specified by register rxqec_iaddr1, form a 12 bit indirect register address.  This address specifies the ARM mapped RxQEC register accessed when either bit rxqec_read or rxqec_write of register rxqec_iaddr1 is asserted.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecIaddr0_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x179), (value >> 0));

    return status;
}

/**
 * RxQEC Indirect Register Address (bits 7:0).  These LSBs, together with MSBs specified by register rxqec_iaddr1, form a 12 bit indirect register address.  This address specifies the ARM mapped RxQEC register accessed when either bit rxqec_read or rxqec_write of register rxqec_iaddr1 is asserted.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecIaddr0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x179), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsIreadySel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsIreadySel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenOffTime_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x189), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x188), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenOffTime_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x189), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x188), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenOnTime_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x187), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenOnTime_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x187), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenSoftReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17f), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecObsRdyGenSoftReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_rxqec_oclk_rate
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecOclkRate_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x150), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * spi_rxqec_oclk_rate
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecOclkRate_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x150), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * RxQEC Indirect Register Read Return (bits 7:0).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is updated to reflect the state of the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_read in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRdata0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x171), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * RxQEC Indirect Register Read Return (bits 15:8).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is updated to reflect the state of the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_read in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRdata1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x172), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * RxQEC Indirect Register Read Return (bits 23:16).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is updated to reflect the state of the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_read in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRdata2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x173), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * RxQEC Indirect Register Read Return (bits 31:24).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is updated to reflect the state of the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_read in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRdata3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x174), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Read Enable.  Whenever this bit is written from 0 to 1, the contents of the ARM mapped RxQEC register(s) identified by registers rxqec_iaddr1:0 are copied to registers rxqec_rdata3:0.  This occurs just once per assertion of this bit.  Only 32 bit reads are possible.  Therefore, depending on the address specified, either two 16 bit registers or one 32 bit ARM mapped RxQEC register is read.  Once the read operation initiated by this bit completes, hardware will clear this bit to 0.  Writing this bit to any state while it is already 1 has no effect.  This bit may be polled to determine when a read completes.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRead_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Read Enable.  Whenever this bit is written from 0 to 1, the contents of the ARM mapped RxQEC register(s) identified by registers rxqec_iaddr1:0 are copied to registers rxqec_rdata3:0.  This occurs just once per assertion of this bit.  Only 32 bit reads are possible.  Therefore, depending on the address specified, either two 16 bit registers or one 32 bit ARM mapped RxQEC register is read.  Once the read operation initiated by this bit completes, hardware will clear this bit to 0.  Writing this bit to any state while it is already 1 has no effect.  This bit may be polled to determine when a read completes.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRead_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Software RXQEC Reset.  This bit should typically be set to 0. While this bit is set to a 1 RxQEC hardware is in a reset state.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Software RXQEC Reset.  This bit should typically be set to 0. While this bit is set to a 1 RxQEC hardware is in a reset state.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration Repeat.  This bit specifies the duration of RxQEC calibrations initiated by bit rxqec_calen.

 * 0 = Select single execution of calibration

 * 1 = Select endless execution of calibration (till this bit is cleared or halt is asserted)
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRpt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Calibration Repeat.  This bit specifies the duration of RxQEC calibrations initiated by bit rxqec_calen.

 * 0 = Select single execution of calibration

 * 1 = Select endless execution of calibration (till this bit is cleared or halt is asserted)
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecRpt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Receive Channel Calibration Select.  Hardware blocks attempts to change the state of these bits while calibration is active (see bit rxqec_calen).  These bits specify which receive path will have calibration statistics gathered in response to bit rxqec_calen being asserted.  

 * 0000 = Receive Channel 1 at PFIR Output

 * 0001 = Receive Channel 2 at PFIR Output

 * 0010 = Receive Channel 1 at QEC Output (for algorithm self-check)

 * 0011 = Receive Channel 2 at QEC Output (for algorithm self-check)

 * 0100 = Receive Channel 1 I versus Receive Channel 2 Q at PFIR Output

 * 0101 = Receive Channel 1 I versus Receive Channel 2 I at PFIR Output

 * 0110 = Receive Channel 1 Q versus Receive Channel 2 Q at PFIR Output

 * 0111 = Receive Channel 1 then Receive Channel 2 at PFIR Output (Interleaved FFT data segments) 

 * 1000 = Receive Channel 1 I versus Receive Channel 2 Q at FIC Output

 * 1001 = Receive Channel 1 I versus Receive Channel 2 I at FIC Output

 * 1010 = Receive Channel 1 Q versus Receive Channel 2 Q at FIC Output

 * 1011 = LPF DDC output of HD2 hardware (for blocker frequency identification)

 * 1100 = Receive Channel 1 I versus Receive Channel 2 Q at XFIR Output

 * 1101 = Receive Channel 1 I versus Receive Channel 2 I at XFIR Output

 * 1110 = Receive Channel 1 Q versus Receive Channel 2 Q at XFIR Output

 * 1111 = Receive Signal A then Receive Signal B from HD2 hardware (Interleaved FFT data segments)
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecSource_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17c), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Receive Channel Calibration Select.  Hardware blocks attempts to change the state of these bits while calibration is active (see bit rxqec_calen).  These bits specify which receive path will have calibration statistics gathered in response to bit rxqec_calen being asserted.  

 * 0000 = Receive Channel 1 at PFIR Output

 * 0001 = Receive Channel 2 at PFIR Output

 * 0010 = Receive Channel 1 at QEC Output (for algorithm self-check)

 * 0011 = Receive Channel 2 at QEC Output (for algorithm self-check)

 * 0100 = Receive Channel 1 I versus Receive Channel 2 Q at PFIR Output

 * 0101 = Receive Channel 1 I versus Receive Channel 2 I at PFIR Output

 * 0110 = Receive Channel 1 Q versus Receive Channel 2 Q at PFIR Output

 * 0111 = Receive Channel 1 then Receive Channel 2 at PFIR Output (Interleaved FFT data segments) 

 * 1000 = Receive Channel 1 I versus Receive Channel 2 Q at FIC Output

 * 1001 = Receive Channel 1 I versus Receive Channel 2 I at FIC Output

 * 1010 = Receive Channel 1 Q versus Receive Channel 2 Q at FIC Output

 * 1011 = LPF DDC output of HD2 hardware (for blocker frequency identification)

 * 1100 = Receive Channel 1 I versus Receive Channel 2 Q at XFIR Output

 * 1101 = Receive Channel 1 I versus Receive Channel 2 I at XFIR Output

 * 1110 = Receive Channel 1 Q versus Receive Channel 2 Q at XFIR Output

 * 1111 = Receive Signal A then Receive Signal B from HD2 hardware (Interleaved FFT data segments)
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecSource_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Spare Control bits.  These bits do not control any hardware feature.  They may be used for software signaling purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecSpare_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17b), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Spare Control bits.  These bits do not control any hardware feature.  They may be used for software signaling purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecSpare_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecSwReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x18c), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_RxqecSwReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x18c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 7:0).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata0_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x175), (value >> 0));

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 7:0).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x175), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 15:8).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x176), (value >> 0));

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 15:8).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x176), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 23:16).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x177), (value >> 0));

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 23:16).  These bits, together with other bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x177), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 31:24).  These bits, together with others bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata3_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x178), (value >> 0));

    return status;
}

/**
 * RxQEC Indirect Register Write Data (bits 31:24).  These bits, together with others bits in registers rxqec_rdata[3:0], form a 32 bit word which is written to the ARM mapped RxQEC registers indirectly addressed by registers rxqec_iaddr[1:0] each time bit rxqec_write in register rxqec_iaddr1 is asserted (written from 0 to 1).
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWdata3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x178), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Window Enable.  This bit enables a window to be applied to receive data prior to FFT processing during IQ imbalance estimation. Window coefficients are specified by registers RXQEC_TRACK_WIND[23:0].

 * 0 = Window Disabled (Defaults to rectangular)

 * 1 = Window Enabled; Coefficients specified by ARM mapped registers RXQEC_TRACK_WIND[23:0]
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWinden_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17b), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Window Enable.  This bit enables a window to be applied to receive data prior to FFT processing during IQ imbalance estimation. Window coefficients are specified by registers RXQEC_TRACK_WIND[23:0].

 * 0 = Window Disabled (Defaults to rectangular)

 * 1 = Window Enabled; Coefficients specified by ARM mapped registers RXQEC_TRACK_WIND[23:0]
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWinden_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Write Enable.  When this bit is written from 0 to 1, the content of registers rxqec_wdata[3:0] is written to the ARM mapped RxQEC register identified by bits rxqec_iaddr[1:0].  Only 32 bit writes are possible.  Therefore, depending on the address specified, either two 16 bit RxQEC registers or one 32 bit ARM mapped RxQEC register is written.  Once the write operation initiated by this bit completes, hardware will clear this bit to 0.  Writing this bit to any state while it is already 1 has no effect.  This bit may be polled to determine when a write completes.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWrite_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x17a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Write Enable.  When this bit is written from 0 to 1, the content of registers rxqec_wdata[3:0] is written to the ARM mapped RxQEC register identified by bits rxqec_iaddr[1:0].  Only 32 bit writes are possible.  Therefore, depending on the address specified, either two 16 bit RxQEC registers or one 32 bit ARM mapped RxQEC register is written.  Once the write operation initiated by this bit completes, hardware will clear this bit to 0.  Writing this bit to any state while it is already 1 has no effect.  This bit may be polled to determine when a write completes.
 */
static inline int32_t adrv9001_NvsRegmapCore_RxqecWrite_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * read only word located  in upper address space
 */
static inline int32_t adrv9001_NvsRegmapCore_ScratchPadReadOnlyWordUpperAddress_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1fc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * scratch pad read/write byte
 */
static inline int32_t adrv9001_NvsRegmapCore_ScratchPadWord_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x9), (value >> 0));

    return status;
}

/**
 * scratch pad read/write byte
 */
static inline int32_t adrv9001_NvsRegmapCore_ScratchPadWord_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * scratch pad read/write byte - location near upper end of address space
 */
static inline int32_t adrv9001_NvsRegmapCore_ScratchPadWordUpperAddress_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1fb), (value >> 0));

    return status;
}

/**
 * scratch pad read/write byte - location near upper end of address space
 */
static inline int32_t adrv9001_NvsRegmapCore_ScratchPadWordUpperAddress_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1fb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enables the SDO pin for 4-wire mode. In this scenario, the SDIO pin becomes an input-only pin. If this bit is clear, SDO is inactive (high impedance) and all input and output operations occur through SDIO.
 */
static inline int32_t adrv9001_NvsRegmapCore_SdoActive3_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting these bits enables the SDO pin for 4-wire mode. In this scenario, the SDIO pin becomes an input-only pin. If this bit is clear, SDO is inactive (high impedance) and all input and output operations occur through SDIO.
 */
static inline int32_t adrv9001_NvsRegmapCore_SdoActive3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enables the SDO pin for 4-wire mode. In this scenario, the SDIO pin becomes an input-only pin. If this bit is clear, SDO is inactive (high impedance) and all input and output operations occur through SDIO.
 */
static inline int32_t adrv9001_NvsRegmapCore_SdoActive4_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Setting these bits enables the SDO pin for 4-wire mode. In this scenario, the SDIO pin becomes an input-only pin. If this bit is clear, SDO is inactive (high impedance) and all input and output operations occur through SDIO.
 */
static inline int32_t adrv9001_NvsRegmapCore_SdoActive4_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SelClkPllLp_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x197), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SelClkPllLp_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x197), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * lock bit for semaphore 0, when semaphore0 register is read by either the stream processor or the ARM, this bit will get set to 1'b1 atomically. eg: if the ARM is trying to

 * acquire semaphore 0 , reading this register will set semaphore0_lock to 1'b1. When it is done with modifying the associated registers, it should write 1'b0 to this bit, to indicate to

 * the stream processor, that the semaphore has been released.
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore0Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * lock bit for semaphore 0, when semaphore0 register is read by either the stream processor or the ARM, this bit will get set to 1'b1 atomically. eg: if the ARM is trying to

 * acquire semaphore 0 , reading this register will set semaphore0_lock to 1'b1. When it is done with modifying the associated registers, it should write 1'b0 to this bit, to indicate to

 * the stream processor, that the semaphore has been released.
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore0Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * first of 16 semaphore registers to manage register access by ARM and stream processor. When the ARM/stream processor acquire this semaphore, they can write any value (based on protocol) to

 * semaphore0_proc field, which may be helpful for debug purposes, or to indicate which master has acquired the semaphore.
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore0Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11b), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * first of 16 semaphore registers to manage register access by ARM and stream processor. When the ARM/stream processor acquire this semaphore, they can write any value (based on protocol) to

 * semaphore0_proc field, which may be helpful for debug purposes, or to indicate which master has acquired the semaphore.
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore0Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11b), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 10)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore10Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x125), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 10)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore10Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x125), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 10
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore10Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x125), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 10
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore10Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x125), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 11)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore11Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x126), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 11)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore11Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x126), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 11
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore11Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x126), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 11
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore11Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x126), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 12)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore12Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x127), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 12)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore12Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x127), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 12
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore12Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x127), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 12
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore12Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x127), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 13)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore13Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x128), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 13)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore13Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x128), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 13
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore13Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x128), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 13
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore13Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x128), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 14)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore14Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x129), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 14)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore14Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x129), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 14
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore14Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x129), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 14
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore14Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x129), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 15)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore15Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x12a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 15)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore15Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x12a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 15
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore15Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x12a), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 15
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore15Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x12a), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 1)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore1Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 1)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore1Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 1
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore1Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11c), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 1
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore1Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11c), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 2)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore2Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 2)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore2Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 2
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore2Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11d), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 2
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore2Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11d), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 3)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore3Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 3)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore3Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 3
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore3Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11e), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 3
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore3Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11e), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 4)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore4Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 4)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore4Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 4
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore4Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x11f), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 4
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore4Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x11f), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 5)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore5Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x120), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 5)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore5Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x120), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 5
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore5Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x120), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 5
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore5Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x120), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 6)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore6Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x121), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 6)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore6Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x121), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 6
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore6Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x121), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 6
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore6Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x121), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 7)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore7Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x122), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 7)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore7Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x122), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 7
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore7Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x122), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 7
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore7Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x122), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 8)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore8Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x123), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 8)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore8Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x123), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 8
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore8Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x123), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 8
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore8Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x123), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 9)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore9Lock_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x124), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * same as semaphore0_lock (but for semaphore register 9)
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore9Lock_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x124), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * process that acquired semaphore 9
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore9Proc_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x124), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * process that acquired semaphore 9
 */
static inline int32_t adrv9001_NvsRegmapCore_Semaphore9Proc_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x124), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, streaming is disabled and only one read or write operation is performed regardless of the state of the CSB pin. When this bit is clear, streaming is enabled. If this bit is set and the CSB pin remains asserted, the state machine resets after the data byte as if CSB were de-asserted and awaits the next instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore_SingleInstruction_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When set, streaming is disabled and only one read or write operation is performed regardless of the state of the CSB pin. When this bit is clear, streaming is enabled. If this bit is set and the CSB pin remains asserted, the state machine resets after the data byte as if CSB were de-asserted and awaits the next instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore_SingleInstruction_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_SlowInterfaceCtl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit enables the FIFO in the SPI arbiter block which captures write transaction data from the SPI to be read back from the ARM.
 */
static inline int32_t adrv9001_NvsRegmapCore_SnooperEn_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xd2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit enables the FIFO in the SPI arbiter block which captures write transaction data from the SPI to be read back from the ARM.
 */
static inline int32_t adrv9001_NvsRegmapCore_SnooperEn_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xd2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the device register values are asynchronously reset to their default states. All registers reset with the exception of 0x000, 0x009, and 0x00A, which retain their current values. The BBP must clear this bit before it can change any register value other than those of 0x000, 0x009, and 0x00A.
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset0_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When this bit is set, the device register values are asynchronously reset to their default states. All registers reset with the exception of 0x000, 0x009, and 0x00A, which retain their current values. The BBP must clear this bit before it can change any register value other than those of 0x000, 0x009, and 0x00A.
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset0011_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset0011_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset0012_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Not used
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset0012_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the device register values are asynchronously reset to their default states. All registers reset with the exception of 0x000, 0x009, and 0x00A, which retain their current values. The BBP must clear this bit before it can change any register value other than those of 0x000, 0x009, and 0x00A.
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset7_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x0), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When this bit is set, the device register values are asynchronously reset to their default states. All registers reset with the exception of 0x000, 0x009, and 0x00A, which retain their current values. The BBP must clear this bit before it can change any register value other than those of 0x000, 0x009, and 0x00A.
 */
static inline int32_t adrv9001_NvsRegmapCore_SoftReset7_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat0_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat10_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat11_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat12_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat13_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat14_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat15_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat3_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat4_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat5_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat6_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat7_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat8_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Not used, returns 0 when read.
 */
static inline int32_t adrv9001_NvsRegmapCore_Stat9_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x17e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 

 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamBase_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x118), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x117), (value >> 0));

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 

 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamBase_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x118), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x117), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamError_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x148), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamError_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x148), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 

 * r0_addr         4'h0 		16 bit register data.

 * r1_addr         4'h1 		16 bit register data.

 * r2_addr         4'h2 		16 bit register data.

 * r3_addr         4'h3 		16 bit register data.

 * r4_addr      	4'h4 		16 bit register data.

 * r5_addr      	4'h5 		16 bit register data.

 * r6_addr      	4'h6 		16 bit register data.

 * r7_addr      	4'h7 		16 bit register data.

 * error_reg_addr  4'h8 		7 bits output :

 * 				error_data[0] invalid spi address access

 * 				error_data[1] CHECK_INSTR error

 * 				error_data[2] TIMEOUT error

 * 				error_data[3] stack overflow error

 * 				error_data[4] invalid stream number

 * 				error_data[5] invalid ahb address access error

 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 

 * 				

 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcAddr_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x13b), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 

 * r0_addr         4'h0 		16 bit register data.

 * r1_addr         4'h1 		16 bit register data.

 * r2_addr         4'h2 		16 bit register data.

 * r3_addr         4'h3 		16 bit register data.

 * r4_addr      	4'h4 		16 bit register data.

 * r5_addr      	4'h5 		16 bit register data.

 * r6_addr      	4'h6 		16 bit register data.

 * r7_addr      	4'h7 		16 bit register data.

 * error_reg_addr  4'h8 		7 bits output :

 * 				error_data[0] invalid spi address access

 * 				error_data[1] CHECK_INSTR error

 * 				error_data[2] TIMEOUT error

 * 				error_data[3] stack overflow error

 * 				error_data[4] invalid stream number

 * 				error_data[5] invalid ahb address access error

 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 

 * 				

 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcAddr_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x13b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field gets populated with the contents of the register specified by the address in the field stream_proc_addr, when stream_proc_rden is 1'b1.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcData_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x13d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x13c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 0. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio0PinSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x146), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 0. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio0PinSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x146), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 1. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio1PinSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x146), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 1. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio1PinSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x146), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 2. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio2PinSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x147), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 2. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio2PinSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x147), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 3. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio3PinSelect_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x147), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * These bits select which GPIO pin for stream proc gpio trigger pin 3. 4'h0 = gpio[0], 4'h1=gpio[1],..., 4'hf=gpio[15]
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpio3PinSelect_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x147), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * these are mask bits to prevent the gpio transitions from triggering streams automatically.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpioPinMask_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x116), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * these are mask bits to prevent the gpio transitions from triggering streams automatically.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcGpioPinMask_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x116), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcRden_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x13b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamProcRden_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x13b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x116), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x116), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_StreamprocCh2u_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x164), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_StreamprocCh2u_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x164), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocDebugData_Set(void *device,
    uint64_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x145), (value >> 56));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x144), (value >> 48));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x143), (value >> 40));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x142), (value >> 32));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x141), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x140), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x13f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x13e), (value >> 0));

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocDebugData_Get(void *device,
    uint64_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x145), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x144), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x143), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x142), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x141), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x140), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x13f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x13e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that lpbk has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk1Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x163), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that lpbk has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk1Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x163), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk1EnableCg_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x163), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk1EnableCg_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x163), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that lpbk has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk2Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x164), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that lpbk has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk2Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x164), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk2EnableCg_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x164), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocLpbk2EnableCg_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x164), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that ORx path has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocOrx1Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x163), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that ORx path has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocOrx1Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x163), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that ORx path has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocOrx2Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x164), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that ORx path has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocOrx2Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x164), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that rx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRx1Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x163), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that rx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRx1Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x163), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that rx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRx2Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x164), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that rx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRx2Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x164), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that ORx path has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRxPfirModeEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x167), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that ORx path has been enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRxPfirModeEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x167), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRxorx1EnableCg_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x163), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRxorx1EnableCg_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x163), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRxorx2EnableCg_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x164), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocRxorx2EnableCg_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x164), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that tx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx1Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x165), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that tx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx1Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x165), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx1EnableCg_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x165), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx1EnableCg_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x165), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that tx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx2Enable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x166), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Stream processor sets these bits to indicate to digital logic that tx has been enabled
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx2Enable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x166), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx2EnableCg_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x166), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore_StreamprocTx2EnableCg_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x166), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Extended to 12 bits
 */
static inline int32_t adrv9001_NvsRegmapCore_SwInterrupt_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1a1), (value >> 4));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a0), (value >> 3), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x19f), (value >> 2), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x19e), (value >> 1), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x19d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Extended to 12 bits
 */
static inline int32_t adrv9001_NvsRegmapCore_SwInterrupt_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1a1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a0), &register_value, 0x1, 0x0);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x19f), &register_value, 0x1, 0x0);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x19e), &register_value, 0x1, 0x0);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x19d), &register_value, 0x1, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoBypassRf1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cb), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoBypassRf1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cb), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoBypassRf2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cd), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoBypassRf2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cd), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoFilterBypassRf1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cc), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoFilterBypassRf1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoFilterBypassRf2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ce), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoFilterBypassRf2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ce), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoPdRf1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cb), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoPdRf1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoPdRf2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cd), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoPdRf2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_SynthLdoStatusRf1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cb), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_SynthLdoStatusRf2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cd), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutSelRf1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cb), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutSelRf1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cb), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutSelRf2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cd), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutSelRf2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cd), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutTrimRf1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1cc), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutTrimRf1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1cc), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutTrimRf2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1ce), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SynthLdoVoutTrimRf2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1ce), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1 = system bus, 0 = code bus
 */
static inline int32_t adrv9001_NvsRegmapCore_SysCodeb_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf6), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 1 = system bus, 0 = code bus
 */
static inline int32_t adrv9001_NvsRegmapCore_SysCodeb_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf6), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefBufferEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e3), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefBufferEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e3), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefDrvrForcePd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e5), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefDrvrForcePd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefEdgeSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefEdgeSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefRegisterEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e3), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefRegisterEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefSampleEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e3), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefSampleEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefTransitionSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1e3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_SysrefTransitionSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1e3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcDacinRef_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a7), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1a6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcDacinRef_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a7), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1a6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcDacinRefOvd_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcDacinRefOvd_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Indicator the aux ADC temp measurement is done.
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcDone_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Low-to-High transition activates on-chip temperature measurement.
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcInit_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Low-to-High transition activates on-chip temperature measurement.
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcInit_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Debugging tgen measurement circuit.
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcMeasCtrl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a4), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * Debugging tgen measurement circuit.
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcMeasCtrl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a4), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcMeasMuxSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a4), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcMeasMuxSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a4), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * <0> Bypass temperature measurement. .  <1> use temp measurement. This slope will be an empirical constant used to set the initial coarse tune D/A control.
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcPtat_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a5), (value >> 0), 0x3c, 0x2);

    return status;
}

/**
 * <0> Bypass temperature measurement. .  <1> use temp measurement. This slope will be an empirical constant used to set the initial coarse tune D/A control.
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcPtat_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a5), &register_value, 0x3c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * data read back from the aux adc temperature sense result
 */
static inline int32_t adrv9001_NvsRegmapCore_TdegcReadback_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1a3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcWaitCtrl_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1a5), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TdegcWaitCtrl_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1a5), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_test_mcs_enable
 */
static inline int32_t adrv9001_NvsRegmapCore_TestMcsEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x193), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * spi_test_mcs_enable
 */
static inline int32_t adrv9001_NvsRegmapCore_TestMcsEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x193), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * spi_top_clock_divider_reset
 */
static inline int32_t adrv9001_NvsRegmapCore_TopClockDividerReset_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x193), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * spi_top_clock_divider_reset
 */
static inline int32_t adrv9001_NvsRegmapCore_TopClockDividerReset_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x193), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set a hysteresis on toggles of transceiver datapath signals so that they can be observed by the HSCI properly if the HSCI is running slower.

 *  Needed for ARM dp drv and capture, off by default to save power
 */
static inline int32_t adrv9001_NvsRegmapCore_TrxMemClkEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xf2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * These bits set a hysteresis on toggles of transceiver datapath signals so that they can be observed by the HSCI properly if the HSCI is running slower.

 *  Needed for ARM dp drv and capture, off by default to save power
 */
static inline int32_t adrv9001_NvsRegmapCore_TrxMemClkEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xf2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x98), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x98), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x98), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x98), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x98), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x98), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x98), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x98), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x99), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x99), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x99), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x99), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x97), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x97), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x97), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1IdataLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x97), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9d), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9d), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * txQdata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * txQdata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9b), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1QdataLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x90), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x90), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x90), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x90), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x90), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x90), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x90), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x90), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x91), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x91), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x91), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x91), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x8f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1ClkLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x8f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1IBankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15b), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1IBankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1McsDelayCnt_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1f2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1f1), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1McsDelayCnt_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1McsReadFifoDelayCnt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1f3), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1McsReadFifoDelayCnt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1f3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_Tx1McsVsDataValidCnt_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1QBankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15b), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx1QBankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15b), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx refclk LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx refclk LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx refclk LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx refclk LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa0), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa0), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa0), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa0), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx refclk LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx refclk LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x9f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * tx refclk LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1RefclkVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x9f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x94), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x94), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x94), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x94), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x94), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x94), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x94), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x94), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x95), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x95), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x95), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x95), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x93), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x93), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x93), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx1StrobeLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x93), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xab), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Idata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xab), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xab), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Idata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xab), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xab), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.Idata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xab), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xab), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.Idata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xab), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xac), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xac), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xac), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xac), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xaa), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Idata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xaa), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xaa), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Idata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2IdataLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xaa), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xaf), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xaf), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xaf), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Qdata LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xaf), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xaf), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xaf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xaf), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.Qdata LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xaf), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb0), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb0), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * txQdata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * txQdata LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xae), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.Qdata LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xae), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xae), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.Qdata LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2QdataLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xae), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.clock LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa3), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.clock LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa3), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa3), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.clock LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa3), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.clock LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa4), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa4), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.clock LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.clock LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2ClkLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2IBankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15b), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2IBankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15b), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2McsDelayCnt_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1f7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0x1f6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2McsDelayCnt_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2McsReadFifoDelayCnt_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x1f8), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2McsReadFifoDelayCnt_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x1f8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_Tx2McsVsDataValidCnt_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1fa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0x1f9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2QBankSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15b), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_Tx2QBankSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15b), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx refclk LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx refclk LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx refclk LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx refclk LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsCalib_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb3), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsCalib_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb3), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb3), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx refclk LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb3), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx refclk LVDS CMOS enable_lvds_mode
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx refclk LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx refclk LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkVcm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * tx refclk LVDS CMOS VCM
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2RefclkVcm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosNIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa7), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.strobe LVDS CMOS n_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosNIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosNOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa7), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.strobe LVDS CMOS n_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosNOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosPIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa7), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * tx.strobe LVDS CMOS p_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosPIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosPOe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * tx.strobe LVDS CMOS p_oe
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeCmosPOe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa8), (value >> 0), 0xe, 0x1);

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_delay
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa8), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsIe_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_ie
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsIe_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsPnInv_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa6), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * tx.strobe LVDS CMOS PN_INV
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsPnInv_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa6), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsRxOnchipTerm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xa6), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * tx.strobe LVDS CMOS lvds_rx_onchip_term
 */
static inline int32_t adrv9001_NvsRegmapCore_Tx2StrobeLvdsRxOnchipTerm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xa6), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank A

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankAPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15c), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank A

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankAPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankAPfirSymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankAPfirSymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank A

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankAPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15c), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank A

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankAPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15c), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank B

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankBPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15d), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank B

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankBPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15d), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankBPfirSymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankBPfirSymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank B

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankBPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15d), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank B

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankBPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15d), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank C

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankCPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15e), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank C

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankCPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankCPfirSymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankCPfirSymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank C

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankCPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15e), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank C

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankCPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15e), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank D

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankDPfirGain_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15f), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This controls the gain when the TX PFIR uses coefficient bank D

 * 1001 --   26db (x20) 

 * 1000 --   24db (x16)

 * 0111 --   20db (x10) 

 * 0110 --   14db (x5)

 * 0101 --   12db  (x4)

 * 0100 --   9.54dB (x3)

 * 0011 --   6db

 * 0010 --   0db

 * 0001 --   -6db

 * 0000 --   -12db
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankDPfirGain_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15f), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankDPfirSymmetric_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Coefficients in this bank are expected to be symmetric
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankDPfirSymmetric_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank D

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankDPfirTaps_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x15f), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * This controls the number of rows of taps when the TX PFIR uses coefficient bank D

 * 00 --  32 taps

 * 01 --  64 taps

 * 10 --  96 taps

 * 11 --  128 taps
 */
static inline int32_t adrv9001_NvsRegmapCore_TxBankDPfirTaps_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x15f), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TxComplexGainUpdateBoth_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x19c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore_TxComplexGainUpdateBoth_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x19c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes

 *  Mask DAC data
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskCh1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes

 *  Mask DAC data
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskCh1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes

 *  Mask DAC data
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskCh2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes

 *  Mask DAC data
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskCh2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the data going to DAC is masked (zeroed) when RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskOnRfpllUnlockCh1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * When this bit is set, the data going to DAC is masked (zeroed) when RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskOnRfpllUnlockCh1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the data going to DAC is masked (zeroed) when RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskOnRfpllUnlockCh2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * When this bit is set, the data going to DAC is masked (zeroed) when RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataMaskOnRfpllUnlockCh2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the data to DAC is ramped down by the Tx attenuation block when the RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataRampDownOnRfpllUnlockCh1_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set, the data to DAC is ramped down by the Tx attenuation block when the RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataRampDownOnRfpllUnlockCh1_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the data to DAC is ramped down by the Tx attenuation block when the RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataRampDownOnRfpllUnlockCh2_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set, the data to DAC is ramped down by the Tx attenuation block when the RF PLL is unlocked.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxDataRampDownOnRfpllUnlockCh2_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Force Tx On
 */
static inline int32_t adrv9001_NvsRegmapCore_TxEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x162), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * Force Tx On
 */
static inline int32_t adrv9001_NvsRegmapCore_TxEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x162), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When ARM override control is set, These bits are valid to trigger tx_enable stream
 */
static inline int32_t adrv9001_NvsRegmapCore_TxEnableByArm_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x16f), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * When ARM override control is set, These bits are valid to trigger tx_enable stream
 */
static inline int32_t adrv9001_NvsRegmapCore_TxEnableByArm_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x16f), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the default data (from spi_txdp_intf_default_idata and spi_txdp_intf_default_qdata) is transmitted if the FIFO gets empty once the transmission starts.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When this bit is set, the default data (from spi_txdp_intf_default_idata and spi_txdp_intf_default_qdata) is transmitted if the FIFO gets empty once the transmission starts.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit clears the spi_txdp_intf_default_data_used_status field, the spi_txdp_intf_default_data_used_transitions_count and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataUsedClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xbb), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit clears the spi_txdp_intf_default_data_used_status field, the spi_txdp_intf_default_data_used_transitions_count and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataUsedClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xbb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * txdp_intf_default_data_used irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataUsedIrqEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xba), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * txdp_intf_default_data_used irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataUsedIrqEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xba), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This status bit is set to indicate that the default data in spi_txdp_intf_default_idata and spi_txdp_intf_default_qdata was transmitted because the FIFO was empty. This bit will be set only when the spi_txdp_intf_default_data_enable is programmed to 1.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataUsedStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xbc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Count of number of times the 'default data not-used' to 'default data used' condition occurred. This counter is reset when the spi_txdp_intf_Default_data_used_clear field is written.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultDataUsedTransitionsCount_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xb9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Default Qdata
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultIdata_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xc3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xc4), (value >> 0));

    return status;
}

/**
 * Default Qdata
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultIdata_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xc3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xc4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Default Idata
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultQdata_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xc1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xc2), (value >> 0));

    return status;
}

/**
 * Default Idata
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfDefaultQdata_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xc1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xc2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Interface Enable Bit enables the module.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Interface Enable Bit enables the module.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Reading from the FIFO starts after the Interface is enabled; when the FIFO level raises above the value proagrammed in this register.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoRdStartThreshold_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb8), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Reading from the FIFO starts after the Interface is enabled; when the FIFO level raises above the value proagrammed in this register.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoRdStartThreshold_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb8), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Write request is initiated if the FIFO level is equal to or less than the threshold value programmed in this register.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoWrReqThreshold_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb8), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Write request is initiated if the FIFO level is equal to or less than the threshold value programmed in this register.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoWrReqThreshold_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb8), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit clears the spi_txdp_intf_fifo_write_error_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoWriteErrorClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xbb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit clears the spi_txdp_intf_fifo_write_error_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoWriteErrorClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xbb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * txdp_intf_fifo_write_error irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoWriteErrorIrqEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xba), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * txdp_intf_fifo_write_error irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoWriteErrorIrqEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xba), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This status bit is set when the user attempts to write the FIFO when the FIFO is full. The data is not written to the FIFO in this case, and the data may be lost. This is a potential error condition.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfFifoWriteErrorStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xbc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Idata.  Writing to the spi_txdp_intf_idata[7:0] triggers a write to the FIFO.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfIdata_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xbf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xc0), (value >> 0));

    return status;
}

/**
 * Idata.  Writing to the spi_txdp_intf_idata[7:0] triggers a write to the FIFO.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfIdata_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xbf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xc0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 => Interrupt output signals are level signals

 * 1 => Interrupt output signals are pulse-signals. Pulse duration is one clock-period of the respective clocks on which the interrupts are generated.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfIrqEdgeTriggered_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0 => Interrupt output signals are level signals

 * 1 => Interrupt output signals are pulse-signals. Pulse duration is one clock-period of the respective clocks on which the interrupts are generated.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfIrqEdgeTriggered_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Qdata
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfQdata_Set(void *device,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xbd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x0 + 0xbe), (value >> 0));

    return status;
}

/**
 * Qdata
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfQdata_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xbd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xbe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit clears the spi_txdp_intf_write_request_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfWriteRequestClear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xbb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit clears the spi_txdp_intf_write_request_status field and the interrupt.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfWriteRequestClear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xbb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0 => write_request_irq is cleared by explicit write to  'spi_txdp_intf_write_request_clear' bit. 1 => write_request_irq is cleared automatically when the spi_txdp_intf_idata[7:0] is written.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfWriteRequestIrqAutoclear_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xb6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0 => write_request_irq is cleared by explicit write to  'spi_txdp_intf_write_request_clear' bit. 1 => write_request_irq is cleared automatically when the spi_txdp_intf_idata[7:0] is written.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfWriteRequestIrqAutoclear_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xb6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * txdp_intf_write_request irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfWriteRequestIrqEnable_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xba), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * txdp_intf_write_request irq Interrupt signal is asserted only if this bit is set.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfWriteRequestIrqEnable_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xba), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This status bit is set to indicate the request for the BBIC to write data to the FIFO.
 */
static inline int32_t adrv9001_NvsRegmapCore_TxdpIntfWriteRequestStatus_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xbc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If 1, Tx and Rx signalling is via pins
 */
static inline int32_t adrv9001_NvsRegmapCore_TxrxPinMode_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0x168), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * If 1, Tx and Rx signalling is via pins
 */
static inline int32_t adrv9001_NvsRegmapCore_TxrxPinMode_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0x168), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore_VendorId_Get(void *device,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x0 + 0xb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Number of reg_clk cycles to wait while reading (facilitates

 * multicycle path). The read mux is timed to a 10ns max delay.
 */
static inline int32_t adrv9001_NvsRegmapCore_WrEnDelay_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xdc), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Number of reg_clk cycles to wait while reading (facilitates

 * multicycle path). The read mux is timed to a 10ns max delay.
 */
static inline int32_t adrv9001_NvsRegmapCore_WrEnDelay_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xdc), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Reg clock rate selection for use with AHB SPI bridge

 * 00 --  HS_dig_clk / 4

 * 01 --  HS_dig_clk / 8

 * 10 --  HS_dig_clk / 16

 * 11 --  HS_dig_clk / 32

 * Max 250 MHz
 */
static inline int32_t adrv9001_NvsRegmapCore_WriteRegClockSel_Set(void *device,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x0 + 0xdb), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Reg clock rate selection for use with AHB SPI bridge

 * 00 --  HS_dig_clk / 4

 * 01 --  HS_dig_clk / 8

 * 10 --  HS_dig_clk / 16

 * 11 --  HS_dig_clk / 32

 * Max 250 MHz
 */
static inline int32_t adrv9001_NvsRegmapCore_WriteRegClockSel_Get(void *device,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x0 + 0xdb), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_CORE_H__