/**
 * \file
 * \brief BitField accessors for nvs_pll_mem_map
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_PLL_MEM_MAP_H__
 #define __ADRV9001_BF_NVS_PLL_MEM_MAP_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfNvsPllMemMap_e
{
    ADRV9001_BF_AUX_PLL    =   0x1800,
    ADRV9001_BF_CLK_PLL    =   0x1a00,
    ADRV9001_BF_RF1_PLL    =   0x1c00,
    ADRV9001_BF_RF2_PLL    =   0x1e00,
    ADRV9001_BF_CLK_PLL_LP    =   0x3600
} adrv9001_BfNvsPllMemMap_e;


static inline int32_t adrv9001_NvsPllMemMap_AbCounterResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AbCounterResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Abort_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Abort_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_AuxAdcReady_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoBufNorthPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoBufNorthPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoBufSouthPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoBufSouthPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoDriverOffchipLobufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoDriverOffchipLobufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoDriverOffchipPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoDriverOffchipPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoTiaTunerBufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_AuxLoTiaTunerBufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_BypLoadDelay_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_BypLoadDelay_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Calper_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Calper_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Caltyp_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0xe, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Caltyp_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenBackupReset_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenBackupReset_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenDivOrxPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenDivOrxPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenDivRxPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenDivRxPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenDivTxPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenDivTxPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenHsdigclkOutbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenHsdigclkOutbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenHsdigclkSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc3), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenHsdigclkSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc3), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenMcs2digCount_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x48), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x49), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenMcs2digCount_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x48), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x49), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx12OutbufPdOvrd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx12OutbufPdOvrd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx12OutbufPdOvrdSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx12OutbufPdOvrdSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx34OutbufPdOvrd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx34OutbufPdOvrd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx34OutbufPdOvrdSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenOrx34OutbufPdOvrdSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenResetSrcSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenResetSrcSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx12OutbufPdOvrd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx12OutbufPdOvrd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx12OutbufPdOvrdSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx12OutbufPdOvrdSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx34OutbufPdOvrd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx34OutbufPdOvrd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx34OutbufPdOvrdSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenRx34OutbufPdOvrdSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivInitOrx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbf), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbe), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivInitOrx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbf), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivInitRx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xbc), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivInitRx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xbc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivInitTx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc1), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc0), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivInitTx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc1), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivSelOrx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivSelOrx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivSelRx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivSelRx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivSelTx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSampleDivSelTx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSerdesOutbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSerdesOutbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSubRxForOrx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc3), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSubRxForOrx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSyncDivSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSyncDivSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSyncclkOutputEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc3), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenSyncclkOutputEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx12OutbufPdOvrd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx12OutbufPdOvrd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx12OutbufPdOvrdSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx12OutbufPdOvrdSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx34OutbufPdOvrd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx34OutbufPdOvrd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx34OutbufPdOvrdSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenTx34OutbufPdOvrdSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenUseBackupReset_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenUseBackupReset_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenUseSerdesMcs_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenUseSerdesMcs_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenVcoSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc3), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenVcoSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivInitOrx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbf), (value >> 0), 0x7c, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivInitOrx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbf), &register_value, 0x7c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivInitRx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xbd), (value >> 0), 0x7c, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivInitRx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xbd), &register_value, 0x7c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivInitTx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc1), (value >> 0), 0x7c, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivInitTx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc1), &register_value, 0x7c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivSelOrx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivSelOrx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivSelRx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivSelRx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivSelTx_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc2), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ClkgenXfaceDivSelTx_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpBiasRfiltByp_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpBiasRfiltByp_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpCalClkDivide_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0xe0, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpCalClkDivide_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpCalEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpCalEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpCalInit_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpCalInit_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_CpCalValid_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x27), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpFCal_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x27), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpFCal_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x27), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpFCalBits_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x27), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpFCalBits_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x27), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpI_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpI_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpLeveldetPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpLeveldetPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpOffsetLvl_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x25), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpOffsetLvl_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpOffsetOff_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x25), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpOffsetOff_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_CpOverrangeHighFlag_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_CpOverrangeHighTc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_CpOverrangeLowFlag_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_CpOverrangeLowTc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpPumpUpBiasCntrl_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpPumpUpBiasCntrl_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpTest_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpTest_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelHighFlag_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelHighFlag_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelHighTc_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x29), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelHighTc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x29), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelLowFlag_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelLowFlag_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelLowTc_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x29), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_CpVlevelLowTc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x29), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_Cpend_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x56), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Cstep_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x52), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x51), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Cstep_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x52), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x51), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Ctstep_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x50), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Ctstep_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x50), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModAnalogClkdivValue_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe1), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModAnalogClkdivValue_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_DirectModEmpty_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModFifoBypass_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModFifoBypass_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModFifoClr_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe2), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModFifoClr_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModFifoEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModFifoEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_DirectModFull_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModRdFifoEnableDelay_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe2), (value >> 0), 0xe, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DirectModRdFifoEnableDelay_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe2), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl0_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd7), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl0_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd8), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl3_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xda), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl3_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xda), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl4_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdb), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl4_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl5_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdc), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl5_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl6_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdd), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl6_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl7_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xde), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl7_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xde), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl8_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xdf), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Dnl8_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xdf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DnlOffset_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DnlOffset_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB0_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB0_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7c), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7d), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB3_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x7e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_DtapsB3_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_EndvcocalMaxcntEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_EndvcocalMaxcntEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FbClockAdv_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FbClockAdv_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FcalSingleUpdBands_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FcalSingleUpdBands_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Fdovd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5c), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Fdovd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5c), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Fdovdm_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5c), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Fdovdm_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ForceLock_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ForceLock_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ForceVcoInitAlcValue_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ForceVcoInitAlcValue_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FreqCalCntRdsel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FreqCalCntRdsel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FreqCalMaxCnt_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd5), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd3), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FreqCalMaxCnt_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FreqCalSingle_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_FreqCalSingle_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_FreqCalcntRdbck_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Icalwait_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Icalwait_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistBypassResExt_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistBypassResExt_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistBypassResInt_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistBypassResInt_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistExtPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistExtPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistIntPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_IdistIntPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_InvLoI_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_InvLoI_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_InvLoQ_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_InvLoQ_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassC1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2e), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassC1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassC2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassC2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassR1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2f), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassR1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassR3_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x31), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfBypassR3_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x31), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfC1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2e), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfC1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2e), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfC2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfC2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfC3_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x30), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfC3_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x30), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfR1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2f), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfR1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfR3_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x31), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LfR3_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x31), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LgDiv_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x54), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LgDiv_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x54), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo1OffsetLoPhaseDetFilter_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa5), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo1OffsetLoPhaseDetFilter_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa5), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo1OffsetLoPhaseDetPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo1OffsetLoPhaseDetPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo2OffsetLoPhaseDetFilter_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa5), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo2OffsetLoPhaseDetFilter_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa5), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo2OffsetLoPhaseDetPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Lo2OffsetLoPhaseDetPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LoSyncResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LoSyncResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LoSyncSamplerFlopsPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LoSyncSamplerFlopsPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LoSyncSamplerLoInputBufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LoSyncSamplerLoInputBufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LockDetectResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LockDetectResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LockdetCnt_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LockdetCnt_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LockdetMode_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LockdetMode_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenDivideMode_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenDivideMode_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenInbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenInbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenQuadDivPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenQuadDivPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenReset_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenReset_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenVcoBufHighR_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_LogenVcoBufHighR_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsClkgenSyncEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x45), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsClkgenSyncEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x45), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsDeviceClkDividerSyncEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x45), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsDeviceClkDividerSyncEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x45), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsDigitalClockSyncEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x45), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsDigitalClockSyncEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x45), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x45), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x45), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsJesdSysrefEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x45), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsJesdSysrefEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x45), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsPulseDelay_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x46), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsPulseDelay_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x46), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsPulseDelayDigSerdes_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x46), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsPulseDelayDigSerdes_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x46), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsPulseWidthDigSerdes_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x46), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsPulseWidthDigSerdes_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x46), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsSdmSyncEnable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x45), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsSdmSyncEnable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x45), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsSerdesAlign_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x48), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsSerdesAlign_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x48), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_McsSpiStatus_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x47), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsWaitCount_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x46), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_McsWaitCount_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x46), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Mod0_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x74), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x73), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x72), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Mod0_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x74), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x73), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x72), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Mod1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x77), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x76), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x75), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Mod1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x77), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x76), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x75), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Mod2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7a), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x79), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x78), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Mod2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7a), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x79), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x78), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_Mpend_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x56), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_NumDitherBits_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_NumDitherBits_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PfdClockEdge_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x33), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PfdClockEdge_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x33), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PfdResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PfdResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PfdWidth_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x33), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PfdWidth_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x33), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Phadj_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x59), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x58), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x57), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Phadj_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x59), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x58), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x57), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_Phdiff_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe8), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_Poai_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x65), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x64), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x63), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_Poaq_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x68), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x67), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x66), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PrescalerPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PrescalerPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PrscBias_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_PrscBias_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_Psbusy_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x56), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Psen_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Psen_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Qthr_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x52), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Qthr_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x52), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_QuickFreqCalEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_QuickFreqCalEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_QuickFreqCalThreshold_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd2), (value >> 0), 0x7f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_QuickFreqCalThreshold_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd2), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ReadEffectFtw_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_ReadEffectFtw_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RefClkDivideRatio_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd0), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RefClkDivideRatio_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd0), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RefClkDividerPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RefClkDividerPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RefClkDividerResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RefClkDividerResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInAmpBias_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInAmpBias_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInDivideMode_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x99), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInDivideMode_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x99), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInFiltByp_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInFiltByp_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInSwapInputPn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9a), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloInSwapInputPn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutDivReset_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutDivReset_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutDivideMode_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x98), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutDivideMode_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x98), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutInbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutInbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfExtloOutPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfLoBufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_RfLoBufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12Lo1InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12Lo1InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12Lo2InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12Lo2InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12LomuxPdOverride_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12LomuxPdOverride_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12LomuxPdOverrideSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12LomuxPdOverrideSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12SelLo2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx12SelLo2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34Lo1InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34Lo1InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34Lo2InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34Lo2InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34LomuxPdOverride_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34LomuxPdOverride_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34LomuxPdOverrideSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34LomuxPdOverrideSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34SelLo2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Rx34SelLo2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Sda_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7f), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Sda_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmByp_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmByp_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmFrac_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x22), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x21), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmFrac_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x22), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x21), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmInt_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmInt_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SdmResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Spares_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Spares_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_SynLock_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SynthPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_SynthPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcforce_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8a), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcforce_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcforcen_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcforcen_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcidac_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8c), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcidac_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcpol_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8a), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcpol_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcupdinit_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8a), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tcupdinit_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tsprsc_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tsprsc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tszero_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x53), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tszero_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x53), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12Lo1InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12Lo1InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12Lo2InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12Lo2InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12LomuxPdOverride_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12LomuxPdOverride_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12LomuxPdOverrideSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12LomuxPdOverrideSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12SelLo2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx12SelLo2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34Lo1InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34Lo1InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34Lo2InbufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34Lo2InbufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34LomuxPdOverride_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34LomuxPdOverride_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34LomuxPdOverrideSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34LomuxPdOverrideSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34SelLo2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_Tx34SelLo2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoAlcCalEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3c), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoAlcCalEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoAlcPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoAlcPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasDacLvlShift2maPmosEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasDacLvlShift2maPmosEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasRef_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasRef_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasStartup_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x39), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasStartup_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x39), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasTcf_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBiasTcf_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBufPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBufPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBypRfilt1_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x42), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBypRfilt1_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x42), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBypRfilt2_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x42), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBypRfilt2_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x42), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBypassBiasr_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoBypassBiasr_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcClkDiv_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcClkDiv_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcInitWait_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcInitWait_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcStep_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcStep_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcWait_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalAlcWait_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_VcoCalBusy_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalInit_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x33), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalInit_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x33), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalInitDel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalInitDel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalLogicResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalLogicResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalOffset_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3e), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalOffset_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3e), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalRefMonitor_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalRefMonitor_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalRefTcf_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalRefTcf_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalTcfPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCalTcfPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCoarseCalEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCoarseCalEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCompBypBiasr_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCompBypBiasr_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_VcoCompOut_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCompPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCompPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCoreSwDisable_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoCoreSwDisable_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFAlc_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3c), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3b), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFAlc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFAlcEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3c), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFAlcEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFCoarseBand_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3e), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3d), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFCoarseBand_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFCoarseBandEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFCoarseBandEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFFineBand_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3f), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFFineBand_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFFineBandEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3f), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFFineBandEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFFineBandIndexEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3f), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFFineBandIndexEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFineCalEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoFineCalEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoInitAlcValue_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoInitAlcValue_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoBypass_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoBypass_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoDisThermalShutdown_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4b), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoDisThermalShutdown_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoFilterBypass_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4b), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoFilterBypass_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoIlimitInc_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoIlimitInc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_VcoLdoStatus_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoThermalShutdown0c_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4b), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoThermalShutdown0c_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoVoutSel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoVoutSel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoVoutTrim_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4b), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoLdoVoutTrim_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoOutLvl_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x37), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoOutLvl_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x37), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPeakDetLdoLvl_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x37), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPeakDetLdoLvl_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x37), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPeakDetPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPeakDetPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPtatBiasRcal_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPtatBiasRcal_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPtatPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPtatPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPtatStartupLeakb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x39), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoPtatStartupLeakb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x39), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcCalResetb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcCalResetb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcIdacBypBiasFilt_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x42), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcIdacBypBiasFilt_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x42), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcIdacScaleLsb_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcIdacScaleLsb_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcMirrorIout_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x43), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcMirrorIout_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x43), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcPd_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcPd_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcRfilt1Sel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x42), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcRfilt1Sel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x42), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcRfilt2Sel_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x42), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcRfilt2Sel_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x42), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcTrackingEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x43), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcTrackingEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x43), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcWait_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x43), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoTcWait_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x43), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoVar_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoVar_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoVarTc_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x41), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcoVarTc_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x41), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcocalMaxcntbandEn_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd1), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VcocalMaxcntbandEn_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VtForce_Set(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsPllMemMap_VtForce_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsPllMemMap_Wpa_Get(void *device,
    adrv9001_BfNvsPllMemMap_e instance,
    uint32_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x62), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x61), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x60), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_PLL_MEM_MAP_H__