/**
 * \file
 * \brief BitField accessors for analog_tx_mem_map
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_ANALOG_TX_MEM_MAP_H__
 #define __ADRV9001_BF_ANALOG_TX_MEM_MAP_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfAnalogTxMemMap_e
{
    ADRV9001_BF_TX1_ANA    =   0x3800,
    ADRV9001_BF_TX2_ANA    =   0x3a00
} adrv9001_BfAnalogTxMemMap_e;

static const adrv9001_BfAnalogTxMemMap_e analogTxMemMapInstances[] = {
    ADRV9001_BF_TX1_ANA,
    ADRV9001_BF_TX2_ANA
};

static inline int32_t adrv9001_AnalogTxMemMap_AnalogTxMemSpare_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x71), (value >> 0));

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_AnalogTxMemSpare_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x71), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * write this bit high to observe the temp sensor data from the serdes IP on aux dac 0.  Active high in burn-in mode
 */
static inline int32_t adrv9001_AnalogTxMemMap_AuxDacTempSensorObs_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x70), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * write this bit high to observe the temp sensor data from the serdes IP on aux dac 0.  Active high in burn-in mode
 */
static inline int32_t adrv9001_AnalogTxMemMap_AuxDacTempSensorObs_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x70), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_AuxDacTestModeEn_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_AuxDacTestModeEn_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_CalToneDriverAttn_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_CalToneDriverAttn_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_CalToneDriverInbufPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_CalToneDriverInbufPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_CalToneDriverPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_CalToneDriverPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoBypass_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x60), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoBypass_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x60), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoDisThermalShutdown_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoDisThermalShutdown_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoFilterBypass_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoFilterBypass_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoIlimitInc_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x60), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoIlimitInc_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x60), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoStatus_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x60), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoThermalShutdown0c_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoThermalShutdown0c_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoVoutSel_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x60), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoVoutSel_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x60), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoVoutTrim_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_ConverterLdoVoutTrim_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_EnableLoSourceTx_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_EnableLoSourceTx_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_IdistBypassBiasRes_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_IdistBypassBiasRes_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_LoOffsetLoPhaseDetFilter_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0xe, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_LoOffsetLoPhaseDetFilter_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0xe, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_LoOffsetLoPhaseDetFilterAcCoupleEn_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_LoOffsetLoPhaseDetFilterAcCoupleEn_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_LoOffsetLoPhaseDetPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4a), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_LoOffsetLoPhaseDetPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_PdConverterLdo_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_PdConverterLdo_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_PdIDist_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_PdIDist_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the TX mixer LO DELAY BUFFER.
 */
static inline int32_t adrv9001_AnalogTxMemMap_PdTxLoDelayBuffer_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Setting this bit powers down the TX mixer LO DELAY BUFFER.
 */
static inline int32_t adrv9001_AnalogTxMemMap_PdTxLoDelayBuffer_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the TX mixer LO DELAY BUFFER.
 */
static inline int32_t adrv9001_AnalogTxMemMap_PdTxLoDelayBufferOverride_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit powers down the TX mixer LO DELAY BUFFER.
 */
static inline int32_t adrv9001_AnalogTxMemMap_PdTxLoDelayBufferOverride_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the TX mixer LO DELAY BUFFER.
 */
static inline int32_t adrv9001_AnalogTxMemMap_PdTxLoDelayBufferOverrideSelect_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting this bit powers down the TX mixer LO DELAY BUFFER.
 */
static inline int32_t adrv9001_AnalogTxMemMap_PdTxLoDelayBufferOverrideSelect_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits program the cap for the RC filter at the input of the transmit upconverter.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxAbbfCg_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1f), (value >> 2));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits program the cap for the RC filter at the input of the transmit upconverter.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxAbbfCg_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x3, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits control the bias current for the ABBF peak detectors according to the following settings. Increasing this value increases the bias current, decreases the peak detector attack time, and increases peak detector ripple.   000 --   800nA 001 --   400nA 010 --   200nA 011 --   100nA 100 --   50nA 101 --   50nA 110 --   50nA 111 --   50nA
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxAbbfPeakdetDecay_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * These bits control the bias current for the ABBF peak detectors according to the following settings. Increasing this value increases the bias current, decreases the peak detector attack time, and increases peak detector ripple.   000 --   800nA 001 --   400nA 010 --   200nA 011 --   100nA 100 --   50nA 101 --   50nA 110 --   50nA 111 --   50nA
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxAbbfPeakdetDecay_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxAuxLoBufPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxAuxLoBufPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX BBF block poweredows - debug only
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxBbfDebug_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x22), (value >> 8), 0x1f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x21), (value >> 0));

    return status;
}

/**
 * TX BBF block poweredows - debug only
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxBbfDebug_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x22), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x21), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX BBF power control.  When programmed to > 0, reduces the power consumed by the filter amplifiers.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxBbfPowCtrlB_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x22), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * TX BBF power control.  When programmed to > 0, reduces the power consumed by the filter amplifiers.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxBbfPowCtrlB_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x22), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxBbfSpare_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x23), (value >> 0));

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxBbfSpare_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x23), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmCorrPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmCorrPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmCorrPdOverride_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmCorrPdOverride_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmCorrPdOverrideSelect_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmCorrPdOverrideSelect_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the value of Tx1 LO select when in SPI Direct mode.

 *  tx1 cmlo bias
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmloBias_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits set the value of Tx1 LO select when in SPI Direct mode.

 *  tx1 cmlo bias
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmloBias_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the value of Tx1 LO select when in SPI Direct mode.

 *  tx1 cmlo correction dac i
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmloDacI_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3c), (value >> 4));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3d), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * These bits set the value of Tx1 LO select when in SPI Direct mode.

 *  tx1 cmlo correction dac i
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmloDacI_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3d), &register_value, 0xf, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxCmloDacLatchb_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxCmloDacLatchb_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the value of Tx1 LO select when in SPI Direct mode.

 *  tx1 cmlo correction dac q
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmloDacQ_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3e), (value >> 4));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3f), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * These bits set the value of Tx1 LO select when in SPI Direct mode.

 *  tx1 cmlo correction dac q
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxCmloDacQ_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3f), &register_value, 0xf, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxCmloSel2xDiode_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxCmloSel2xDiode_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxCmloSel2xMixer_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x40), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxCmloSel2xMixer_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x40), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the Tx LO common mode voltage according to the following settings: 000 --  Vdd18 '- 0.25V 001 --  Vdd18 '- 0.25V 010 --  Vdd18 '- 0.45V 011 --  Vdd18 '- 0.55V

 *  Tx Lo Cm
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoCm_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * These bits set the Tx LO common mode voltage according to the following settings: 000 --  Vdd18 '- 0.25V 001 --  Vdd18 '- 0.25V 010 --  Vdd18 '- 0.45V 011 --  Vdd18 '- 0.55V

 *  Tx Lo Cm
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoCm_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the Tx1 LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx1 Lo Delay Corr Pd
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayCorrPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit powers down the Tx1 LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx1 Lo Delay Corr Pd
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayCorrPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the Tx1 LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx1 Lo Delay Corr Pd
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayCorrPdOverride_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit powers down the Tx1 LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx1 Lo Delay Corr Pd
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayCorrPdOverride_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the Tx1 LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx1 Lo Delay Corr Pd
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayCorrPdOverrideSelect_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Setting this bit powers down the Tx1 LO delay correction DAC. Note that this does not disable the LO path, it only disables the I/Q LO delay tuning.

 *  Tx1 Lo Delay Corr Pd
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayCorrPdOverrideSelect_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayDacBiasResBypass_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayDacBiasResBypass_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayDacRes_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoDelayDacRes_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoBypass_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6c), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoBypass_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoFilterBypass_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6d), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoFilterBypass_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6c), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoStatus_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoVoutSel_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6c), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoVoutSel_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6c), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoVoutTrim_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6d), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLdoVoutTrim_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6d), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineRTerm_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineRTerm_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineRcvBufPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineRcvBufPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineTermBiasPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineTermBiasPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineTermEnable_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxLoLineTermEnable_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdAmpBiasResCal_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3a), (value >> 0));

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdAmpBiasResCal_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdDmEn_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdDmEn_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdLowNoiseSel_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x6, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdLowNoiseSel_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdProgOtaBias_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x18, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdProgOtaBias_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdRinBoost_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPdRinBoost_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes

 *  Tx Pdbias
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPdbias_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes

 *  Tx Pdbias
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPdbias_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit selects different bias sources for Tx pre-distortion amplifier. 0 selects a local PTAT source which gives a bias current proportional to absolute temperature and is roughly 80A at room temperature. The current also varies with poly resistance. 1 selects external resistor bias which is 100A constant across temperature. This bit is for internal test only.

 *  Tx Predist Amp Bias
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpBias_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * This bit selects different bias sources for Tx pre-distortion amplifier. 0 selects a local PTAT source which gives a bias current proportional to absolute temperature and is roughly 80A at room temperature. The current also varies with poly resistance. 1 selects external resistor bias which is 100A constant across temperature. This bit is for internal test only.

 *  Tx Predist Amp Bias
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpBias_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpBiasManualStartup_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x39), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpBiasManualStartup_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x39), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpBiasPtatStart_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x39), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpBiasPtatStart_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x39), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit selects different bias sources for Tx pre-distortion amplifier. 0 selects a local PTAT source which gives a bias current proportional to absolute temperature and is roughly 80A at room temperature. The current also varies with poly resistance. 1 selects external resistor bias which is 100A constant across temperature. This bit is for internal test only.

 *  Tx Predist Amp Cc
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpCc_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * This bit selects different bias sources for Tx pre-distortion amplifier. 0 selects a local PTAT source which gives a bias current proportional to absolute temperature and is roughly 80A at room temperature. The current also varies with poly resistance. 1 selects external resistor bias which is 100A constant across temperature. This bit is for internal test only.

 *  Tx Predist Amp Cc
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpCc_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits bypasses two huge filtering resistors in the bias circuits of the Tx pre-distortion amplifier. The bits are for internal test only.

 *  Tx Predist Amp Filter Bypass
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpFilterBypass_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x60, 0x5);

    return status;
}

/**
 * Setting these bits bypasses two huge filtering resistors in the bias circuits of the Tx pre-distortion amplifier. The bits are for internal test only.

 *  Tx Predist Amp Filter Bypass
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpFilterBypass_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit selects different bias sources for Tx pre-distortion amplifier. 0 selects a local PTAT source which gives a bias current proportional to absolute temperature and is roughly 80A at room temperature. The current also varies with poly resistance. 1 selects external resistor bias which is 100A constant across temperature. This bit is for internal test only.

 *  Tx Predist Amp Rz
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpRz_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * This bit selects different bias sources for Tx pre-distortion amplifier. 0 selects a local PTAT source which gives a bias current proportional to absolute temperature and is roughly 80A at room temperature. The current also varies with poly resistance. 1 selects external resistor bias which is 100A constant across temperature. This bit is for internal test only.

 *  Tx Predist Amp Rz
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistAmpRz_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set, the Tx synthesizer is forced to power down.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistPdoverride_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * These bits set how many data lanes are enabled for the transmit path according to the following settings: 00 --  1 data lane from transceiver to BBP in CMOS mode, invalid in LVDS mode 01 --  2 data lanes from transceiver to BBP 10 --  4 data lanes from transceiver to BBP 11 --  Invalid configuration in both CMOS and LVDS modes
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxPredistPdoverride_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPredistPdoverrideSelect_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxPredistPdoverrideSelect_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx upconverters. Setting [D1] enables the power down override for the Tx2 upconverter in 0x20A[D1]. Setting [D0] enables the power down override for the Tx1 upconverter in 0x20A[D0].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxUpconvPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx upconverters. Setting [D1] enables the power down override for the Tx2 upconverter in 0x20A[D1]. Setting [D0] enables the power down override for the Tx1 upconverter in 0x20A[D0].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxUpconvPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx upconverters. Setting [D1] enables the power down override for the Tx2 upconverter in 0x20A[D1]. Setting [D0] enables the power down override for the Tx1 upconverter in 0x20A[D0].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxUpconvPdoverride_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx upconverters. Setting [D1] enables the power down override for the Tx2 upconverter in 0x20A[D1]. Setting [D0] enables the power down override for the Tx1 upconverter in 0x20A[D0].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxUpconvPdoverride_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx upconverters. Setting [D1] enables the power down override for the Tx2 upconverter in 0x20A[D1]. Setting [D0] enables the power down override for the Tx1 upconverter in 0x20A[D0].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxUpconvPdoverrideSelect_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx upconverters. Setting [D1] enables the power down override for the Tx2 upconverter in 0x20A[D1]. Setting [D0] enables the power down override for the Tx1 upconverter in 0x20A[D0].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxUpconvPdoverrideSelect_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxVcmCntrl_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0xc0, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxVcmCntrl_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits are the compensation capacitor control word for the input opamp in the BBF biquad (opamp A). Increasing this word increases the compensation capacitor setting, which increases stability at the expense of wideband linearity performance. See the user guide for more details.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxabbfCcCntA_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits are the compensation capacitor control word for the input opamp in the BBF biquad (opamp A). Increasing this word increases the compensation capacitor setting, which increases stability at the expense of wideband linearity performance. See the user guide for more details.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxabbfCcCntA_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits are the compensation capacitor control word for the input opamp in the BBF biquad (opamp A). Increasing this word increases the compensation capacitor setting, which increases stability at the expense of wideband linearity performance. See the user guide for more details.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxabbfCcCntB_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits are the compensation capacitor control word for the input opamp in the BBF biquad (opamp A). Increasing this word increases the compensation capacitor setting, which increases stability at the expense of wideband linearity performance. See the user guide for more details.
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxabbfCcCntB_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx baseband filters. Setting [D5] enables the power down override for the Tx2 BBF in 0x209[D5]. Setting [D4] enables the power down override for the Tx1 BBF in 0x209[D4].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxbbfPd_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx baseband filters. Setting [D5] enables the power down override for the Tx2 BBF in 0x209[D5]. Setting [D4] enables the power down override for the Tx1 BBF in 0x209[D4].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxbbfPd_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx baseband filters. Setting [D5] enables the power down override for the Tx2 BBF in 0x209[D5]. Setting [D4] enables the power down override for the Tx1 BBF in 0x209[D4].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxbbfPdoverride_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx baseband filters. Setting [D5] enables the power down override for the Tx2 BBF in 0x209[D5]. Setting [D4] enables the power down override for the Tx1 BBF in 0x209[D4].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxbbfPdoverride_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx baseband filters. Setting [D5] enables the power down override for the Tx2 BBF in 0x209[D5]. Setting [D4] enables the power down override for the Tx1 BBF in 0x209[D4].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxbbfPdoverrideSelect_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting these bits enable the power down override for the Tx baseband filters. Setting [D5] enables the power down override for the Tx2 BBF in 0x209[D5]. Setting [D4] enables the power down override for the Tx1 BBF in 0x209[D4].
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxbbfPdoverrideSelect_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit sets the Tx output supply voltage being used. Clear this bit for 1.8V, set it for 1.3V

 *  Txuc Lv
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxucLv_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * This bit sets the Tx output supply voltage being used. Clear this bit for 1.8V, set it for 1.3V

 *  Txuc Lv
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxucLv_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxucRfcascLvl_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0x18, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogTxMemMap_TxucRfcascLvl_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the cascode off voltage according to the following equation:

 *  Txuc Vcascctrl
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxucVcascctrl_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x37), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * These bits set the cascode off voltage according to the following equation:

 *  Txuc Vcascctrl
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxucVcascctrl_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x37), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the cascode off voltage according to the following equation:

 *  Txuc Vcascoff
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxucVcascoff_Set(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x37), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * These bits set the cascode off voltage according to the following equation:

 *  Txuc Vcascoff
 */
static inline int32_t adrv9001_AnalogTxMemMap_TxucVcascoff_Get(void *device,
    adrv9001_BfAnalogTxMemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x37), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_ANALOG_TX_MEM_MAP_H__