/**
 * \file
 * \brief BitField accessors for adc2_mem_map
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_ADC2_MEM_MAP_H__
 #define __ADRV9001_BF_ADC2_MEM_MAP_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfAdc2MemMap_e
{
    ADRV9001_BF_RX1_ADC_I    =   0x2200,
    ADRV9001_BF_RX1_ADC_Q    =   0x2400,
    ADRV9001_BF_RX2_ADC_I    =   0x2800,
    ADRV9001_BF_RX2_ADC_Q    =   0x2a00
} adrv9001_BfAdc2MemMap_e;


/**
 * Codes for bias branches
 */
static inline int32_t adrv9001_Adc2MemMap_AdcCascBias_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x19), (value >> 0));

    return status;
}

/**
 * Codes for bias branches
 */
static inline int32_t adrv9001_Adc2MemMap_AdcCascBias_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x19), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal0_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal0_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal1_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal1_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal10_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal10_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal11_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x13), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal11_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x13), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal12_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x14), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal12_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x14), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal13_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x15), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal13_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x15), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal14_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x16), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal14_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x16), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal15_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x17), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal15_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x17), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal2_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xa), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal2_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal3_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal3_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal4_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xc), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal4_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal5_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xd), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal5_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal6_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xe), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal6_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal7_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xf), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal7_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal8_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal8_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal9_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac1Cal9_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal0_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1c), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal0_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal1_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal1_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal10_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x26), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal10_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x26), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal11_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x27), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal11_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x27), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal12_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x28), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal12_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x28), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal13_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x29), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal13_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x29), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal14_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2a), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal14_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal15_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2b), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal15_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal2_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1e), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal2_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal3_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1f), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal3_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal4_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x20), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal4_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x20), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal5_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x21), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal5_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x21), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal6_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x22), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal6_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x22), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal7_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x23), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal7_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x23), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal8_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x24), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal8_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal9_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x25), (value >> 0));

    return status;
}

/**
 * Calibration codes for each element in DAC1 and DAC2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDac2Cal9_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x25), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Codes for bias branches
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDiodeBias_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x18), (value >> 0));

    return status;
}

/**
 * Codes for bias branches
 */
static inline int32_t adrv9001_Adc2MemMap_AdcDiodeBias_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x18), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 0 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount00_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x40), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 0 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount01_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x41), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 0 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount02_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x42), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 10 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount100_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x68), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 10 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount101_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x69), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 10 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount102_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 11 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount110_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 11 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount111_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 11 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount112_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 12 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount120_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x70), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 12 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount121_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x71), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 12 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount122_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x72), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 13 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount130_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x74), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 13 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount131_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x75), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 13 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount132_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x76), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 14 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount140_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x78), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 14 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount141_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x79), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 14 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount142_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 15 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount150_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 15 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount151_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 15 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount152_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x7e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 1 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount10_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x44), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 1 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount11_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x45), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 1 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount12_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x46), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 2 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount20_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x48), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 2 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount21_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x49), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 2 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount22_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 3 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount30_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 3 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount31_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 3 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount32_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 4 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount40_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x50), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 4 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount41_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x51), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 4 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount42_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x52), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 5 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount50_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x54), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 5 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount51_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x55), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 5 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount52_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x56), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 6 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount60_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x58), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 6 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount61_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x59), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 6 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount62_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 7 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount70_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 7 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount71_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 7 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount72_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 8 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount80_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x60), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 8 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount81_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x61), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 8 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount82_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x62), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 9 Byte 0
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount90_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x64), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 9 Byte 1
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount91_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x65), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flash Cal counter 9 Byte 2
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashCalCount92_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x66), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 0 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp0_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 0 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp0_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 1 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp1_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 1 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp1_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 10 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp10_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 10 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp10_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 11 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp11_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 11 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp11_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 12 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp12_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 12 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp12_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 13 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp13_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 13 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp13_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 14 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp14_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 14 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp14_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 15 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp15_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 15 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp15_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 2 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp2_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 2 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp2_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 3 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp3_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 3 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp3_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 4 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp4_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 4 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp4_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 5 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp5_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 5 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp5_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 6 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp6_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 6 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp6_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 7 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp7_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 7 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp7_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 8 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp8_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Comparator 8 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp8_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Comparator 9 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp9_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Comparator 9 Offset Calibration
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashComp9_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Coarse Flash-DAC clock delay control
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashFckDelayCtrl_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Coarse Flash-DAC clock delay control
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashFckDelayCtrl_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * ADC FlashCal Counting done
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashcalCntDone_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ADC FlashCal Counter enable
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashcalCnten_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * ADC FlashCal Counter enable
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashcalCnten_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ADC FlashCal Counter Size
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashcalCntsize_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x3e, 0x1);

    return status;
}

/**
 * ADC FlashCal Counter Size
 */
static inline int32_t adrv9001_Adc2MemMap_AdcFlashcalCntsize_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x3e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Fine Flash-DAC clock delay control
 */
static inline int32_t adrv9001_Adc2MemMap_AdcIbiasFlashFckDelay_Set(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Fine Flash-DAC clock delay control
 */
static inline int32_t adrv9001_Adc2MemMap_AdcIbiasFlashFckDelay_Get(void *device,
    adrv9001_BfAdc2MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_ADC2_MEM_MAP_H__