/**
 * \file
 * \brief BitField accessors for adc1_mem_map
 *
 * Autogenerated with yoda-gen 1.1.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_ADC1_MEM_MAP_H__
 #define __ADRV9001_BF_ADC1_MEM_MAP_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfAdc1MemMap_e
{
    ADRV9001_BF_RX1_ADC    =   0x2000,
    ADRV9001_BF_RX2_ADC    =   0x2600
} adrv9001_BfAdc1MemMap_e;

static const adrv9001_BfAdc1MemMap_e adc1MemMapInstances[] = {
    ADRV9001_BF_RX1_ADC,
    ADRV9001_BF_RX2_ADC
};

/**
 * Compensation capacitor on ADC Amplifier 1 4th/5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp1Cap1_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Compensation capacitor on ADC Amplifier 1 4th/5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp1Cap1_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16 + 0x0 + (regInstance * 0x1)), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Compensation capacitor on ADC Amplifier 1 5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp1Cap2_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Compensation capacitor on ADC Amplifier 1 5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp1Cap2_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14 + 0x0 + (regInstance * 0x1)), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable ADC Amplifier 1
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp1En_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2d), (value >> 0));

    return status;
}

/**
 * Enable ADC Amplifier 1
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp1En_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcAmp1Spare_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcAmp1Spare_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Compensation capacitor on ADC Amplifier 2 4th/5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp2Cap1_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Compensation capacitor on ADC Amplifier 2 4th/5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp2Cap1_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17 + 0x0 + (regInstance * 0x1)), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Compensation capacitor on ADC Amplifier 2 5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp2Cap2_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Compensation capacitor on ADC Amplifier 2 5th-order path, from 160f to 1280f by 160f
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp2Cap2_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18 + 0x0 + (regInstance * 0x1)), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable ADC Amplifier 2
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp2En_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2e), (value >> 0));

    return status;
}

/**
 * Enable ADC Amplifier 2
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp2En_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcAmp2Spare_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcAmp2Spare_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable ADC Amplifier 3
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp3En_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2f), (value >> 0));

    return status;
}

/**
 * Enable ADC Amplifier 3
 */
static inline int32_t adrv9001_Adc1MemMap_AdcAmp3En_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcAmp3Spare_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcAmp3Spare_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 1, input GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 1, input GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 1, input GM stage on 1.8V, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1a1p8_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 1, input GM stage on 1.8V, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1a1p8_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20 + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 1, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1b_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 1, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1b_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 1, high speed GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1d_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 1, high speed GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm1d_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 1, high gain GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm2a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 1, high gain GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm2a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 1, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm4a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 1, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp1Gm4a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 2, input GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x22 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 2, input GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x22 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 2, input GM stage on 1.8V, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1a1p8_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 2, input GM stage on 1.8V, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1a1p8_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23 + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 2, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1b_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 2, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1b_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 2, high speed GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1d_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 2, high speed GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm1d_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21 + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 2, high gain GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm2a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x22 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 2, high gain GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm2a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x22 + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 2, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm4a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 2, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp2Gm4a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 3, input GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm1a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x25 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 3, input GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm1a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x25 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 3, input GM stage on 1.8V, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm1a1p8_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 3, input GM stage on 1.8V, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm1a1p8_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26 + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 3, high speed GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm1d_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for ADC Amplifier 3, high speed GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm1d_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for ADC Amplifier 3, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm4a_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias current for ADC Amplifier 3, midband GM stage, from 5uA to 42.5uA
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasAmp3Gm4a_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26 + 0x0 + (regInstance * 0x1)), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * No longer used
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacAmp_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x39), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * No longer used
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacAmp_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x39), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for op-amp controlling DAC N-current sink in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacAmpNcurr_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * Bias current for op-amp controlling DAC N-current sink in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacAmpNcurr_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for op-amp controlling DAC P-current source in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacAmpPcurr_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x34), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for op-amp controlling DAC P-current source in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacAmpPcurr_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x34), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current controlling DAC cascode transistor voltage in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacBiasPply_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current controlling DAC cascode transistor voltage in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacBiasPply_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias control to set DAC calibration current
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacIcalPply_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x35), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * Bias control to set DAC calibration current
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacIcalPply_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x35), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias control to set DAC LSB current in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacIlsb_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x36), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias control to set DAC LSB current in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasDacIlsb_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x36), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for FLASH in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasFlashBias_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for FLASH in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasFlashBias_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for FLASH reference voltage generator in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasFlashRefgen_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x33), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Bias current for FLASH reference voltage generator in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasFlashRefgen_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x33), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable 1k reference resistor in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasRcal_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x1d + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable 1k reference resistor in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasRcal_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x1d + 0x0 + (regInstance * 0x1)), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for op-amp controlling the common-mode voltage in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasVcmAmp_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * Bias current for op-amp controlling the common-mode voltage in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasVcmAmp_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current to set the on-voltage of switch transistors of programmable R&C in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasVon_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x37), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Bias current to set the on-voltage of switch transistors of programmable R&C in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasVon_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x37), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bias current for op-amp controlling VON voltage generation in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasVonAmp_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x37), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * Bias current for op-amp controlling VON voltage generation in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcBiasVonAmp_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x37), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable capacitor in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcC1_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa + 0x0 + (regInstance * 0x1)), (value >> 8), 0x7, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x9 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable capacitor in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcC1_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa + 0x0 + (regInstance * 0x1)), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x9 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable capacitor in ADC 2nd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcC2_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc + 0x0 + (regInstance * 0x1)), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0xb + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable capacitor in ADC 2nd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcC2_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0xb + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable capacitor in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcC3_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd + 0x0 + (regInstance * 0x1)), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * Programmable capacitor in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcC3_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd + 0x0 + (regInstance * 0x1)), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable capacitor for capacitively-coupled feedback in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcCdfb_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf + 0x0 + (regInstance * 0x1)), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x10 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable capacitor for capacitively-coupled feedback in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcCdfb_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x10 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Bypass DAC filter resistors in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcDacsBypassRf_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Bypass DAC filter resistors in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcDacsBypassRf_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Flash Cal Reference Voltage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashCalBiasRefCtrl_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Flash Cal Reference Voltage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashCalBiasRefCtrl_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Flash Reference Shuffler Control. [2:0] control mode, [7:3] is the override state
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashEslCtrl_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x12 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Flash Reference Shuffler Control. [2:0] control mode, [7:3] is the override state
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashEslCtrl_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x12 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Flash-DAC Clock Delay Mode
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashFckDelayMode_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Flash-DAC Clock Delay Mode
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashFckDelayMode_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Sets a comparator's output to 0.
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashR_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x29), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x28), (value >> 0));

    return status;
}

/**
 * Sets a comparator's output to 0.
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashR_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x29), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x28), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Controls the flash LSB.
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashRefCtrl_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Controls the flash LSB.
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashRefCtrl_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13 + 0x0 + (regInstance * 0x1)), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Determines which comparators are set to 1 and which are set to 0. This is to balacing out aging effects from reset.
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashResetMode_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Determines which comparators are set to 1 and which are set to 0. This is to balacing out aging effects from reset.
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashResetMode_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set a comparator's output to 1. Superceded by adc_flash_r/
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashS_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2a), (value >> 0));

    return status;
}

/**
 * Set a comparator's output to 1. Superceded by adc_flash_r/
 */
static inline int32_t adrv9001_Adc1MemMap_AdcFlashS_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ILSB current setting in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcI3_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * ILSB current setting in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcI3_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe + 0x0 + (regInstance * 0x1)), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ADC input resistor selection for gain step
 */
static inline int32_t adrv9001_Adc1MemMap_AdcInputAlt_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * ADC input resistor selection for gain step
 */
static inline int32_t adrv9001_Adc1MemMap_AdcInputAlt_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Open-circuits ADC input
 */
static inline int32_t adrv9001_Adc1MemMap_AdcInputzero_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Open-circuits ADC input
 */
static inline int32_t adrv9001_Adc1MemMap_AdcInputzero_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Powerdown of master bias circuit in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdBias_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Powerdown of master bias circuit in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdBias_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DAC powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdDacs_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * DAC powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdDacs_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * DAC delayed powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdDacsDelay_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * DAC delayed powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdDacsDelay_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * FLASH powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdFlash_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * FLASH powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdFlash_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Loopfilter powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdLf_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Loopfilter powerdown in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcPdLf_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable input resistor in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR1_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1 + 0x0 + (regInstance * 0x1)), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x0 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable input resistor in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR1_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1 + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x0 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable alternate setting of input resistor in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR1Alt_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3 + 0x0 + (regInstance * 0x1)), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x2 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable alternate setting of input resistor in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR1Alt_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3 + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x2 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable resistor in ADC 2nd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR2_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5 + 0x0 + (regInstance * 0x1)), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x4 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable resistor in ADC 2nd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR2_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5 + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x4 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable resistor in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR3_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7 + 0x0 + (regInstance * 0x1)), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x6 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable resistor in ADC 3rd stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR3_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint16_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7 + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x6 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable feedback resistor in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR4_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * Programmable feedback resistor in ADC
 */
static inline int32_t adrv9001_Adc1MemMap_AdcR4_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8 + 0x0 + (regInstance * 0x1)), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable resistor that sinks ADC input common-mode current
 */
static inline int32_t adrv9001_Adc1MemMap_AdcRcm_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x11 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Programmable resistor that sinks ADC input common-mode current
 */
static inline int32_t adrv9001_Adc1MemMap_AdcRcm_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint32_t regInstance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x11 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Reset for integrator in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcResetInt1_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Reset for integrator in ADC 1st stage
 */
static inline int32_t adrv9001_Adc1MemMap_AdcResetInt1_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * ADC digital reset
 */
static inline int32_t adrv9001_Adc1MemMap_AdcRstDig_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * ADC digital reset
 */
static inline int32_t adrv9001_Adc1MemMap_AdcRstDig_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcSpare_Set(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x3c), (value >> 0));

    return status;
}

static inline int32_t adrv9001_Adc1MemMap_AdcSpare_Get(void *device,
    adrv9001_BfAdc1MemMap_e instance,
    uint8_t *value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x3c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_ADC1_MEM_MAP_H__