/**
* \file
* \brief Contains ADRV9001 API miscellaneous macro definitions 
* Use these register addresses only for initialize and before MCS. 
* Should use Bitfield function after MCS.
*
* ADRV9001 API Version: $ADI_ADRV9001_API_VERSION$
*/

 /**
 * Copyright 2015 - 2018 Analog Devices Inc.
 * Released under the ADRV9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADRV9001_REG_ADDR_MACROS_H
#define _ADRV9001_REG_ADDR_MACROS_H

#ifdef __cplusplus
extern "C" {
#endif

#define ADRV9001_BF_ENCODE(value, mask, shift) (((value) << (shift)) & (mask))
#define ADRV9001_BF_DECODE(value, mask, shift) (((value) & (mask)) >> (shift))
#define ADRV9001_BF_CLEAR(result, mask)  (result = ((result) & ~(mask))
#define ADRV9001_BF_UPDATE(result, value, mask, shift)  (result = ((result) & ~(mask)) | ( ((value) << (shift)) & (mask))) 
#define ADRV9001_BF_EQUAL(value, mask) ((mask) == ((value) & (mask)))

#define ADRV9001_ADDR_SPI_INTERFACE_CONFIG_A     0x0000
#define ADRV9001_CONFIG_A_SPI_LSB_FIRST          0x42
#define ADRV9001_CONFIG_A_SPI_ADDR_ASCENSION     0x24
#define ADRV9001_CONFIG_A_SPI_SDO_ACTIVE         0x18

#define ADRV9001_ADDR_SPI_INTERFACE_CONFIG_B     0x0001
#define ADRV9001_CONFIG_B_SINGLE_INSTRUCTION     0x80

#define ADRV9001_ADDR_PRODUCT_ID_1               0x0004
#define ADRV9001_ADDR_SCRATCH_PAD                0x0009
#define ADRV9001_ADDR_VENDOR_ID_0                0x000B
#define ADRV9001_ADDR_VENDOR_ID_1                0x000C

#define ADRV9001_ADDR_SCRATCH_PAD_UPPER_ADDRESS_SPACE			0x01FB
#define ADRV9001_ADDR_SCRATCH_PAD_READ_ONLY_UPPER_ADDRESS_SPACE	0x01FC
	
#define ADRV9001_ADDR_REF_CLK_PAD_CONFIG         0x0076
	
#define ADRV9001_ADDR_ARM_CTL_1                  0x00CF
#define ADRV9001_AC1_ARM_DEBUG_ENABLE            0x80
#define ADRV9001_AC1_ARM_MEM_HRESP_MASK          0x08
#define ADRV9001_AC1_ARM_ERROR                   0x02
#define ADRV9001_AC1_ARM_M3_RUN                  0x01
#define ADRV9001_ADDR_ARM_CLOCK_CONTROL          0x00D1
#define ADRV9001_ADDR_AHB_SPI_BRIDGE             0x00D2
#define ADRV9001_AHB_SPI_BRIDGE_ENABLE           0x01
#define ADRV9001_AHB_SPI_BRIDGE_RESET            0x0E
	
#define ADRV9001_ADDR_ARM_BOOT_ADDR_BYTE0        0x00D3
#define ADRV9001_ADDR_ARM_BOOT_ADDR_BYTE1        0x00D4
#define ADRV9001_ADDR_ARM_BOOT_ADDR_BYTE2        0x00D5
#define ADRV9001_ADDR_ARM_BOOT_ADDR_BYTE3        0x00D6
#define ADRV9001_ADDR_ARM_STACK_PTR_BYTE0        0x00D7
#define ADRV9001_ADDR_ARM_STACK_PTR_BYTE1        0x00D8
#define ADRV9001_ADDR_ARM_STACK_PTR_BYTE2        0x00D9
#define ADRV9001_ADDR_ARM_STACK_PTR_BYTE3        0x00DA

#define ADRV9001_ADDR_ARM_DMA_CTL                0x00F6
#define ADRV9001_DMA_CTL_RD_WRB                  0x80
#define ADRV9001_DMA_CTL_SYS_CODEB               0x40
#define ADRV9001_DMA_CTL_LEGACY_MODE             0x20
#define ADRV9001_DMA_CTL_BUS_RESPONSE            0x10
#define ADRV9001_DMA_CTL_BUS_SIZE_MASK           0x0C
#define ADRV9001_DMA_CTL_BUS_SIZE_SHIFT          0x2
#define ADRV9001_DMA_CTL_AUTO_INCR               0x02
#define ADRV9001_DMA_CTL_BUS_WAITING             0x01

#define ADRV9001_ADDR_ARM_DMA_ADDR0              0x00F7  /* BUS_ADDR */
#define ADRV9001_ADDR_ARM_DMA_ADDR1              0x00F8
#define ADRV9001_ADDR_ARM_DMA_ADDR2              0x00F9
#define ADRV9001_ADDR_ARM_DMA_ADDR3              0x00FA
#define ADRV9001_ADDR_ARM_DMA_DATA0              0x00FB /* MEM_WRITE_DATA */
#define ADRV9001_ADDR_ARM_DMA_DATA1              0x00FC
#define ADRV9001_ADDR_ARM_DMA_DATA2              0x00FD
#define ADRV9001_ADDR_ARM_DMA_DATA3              0x00FE
#define ADRV9001_ADDR_ARM_DMA_BYTE_SEL           0x00FF
	
#define ADRV9001_ADDR_ARM_COMMAND                0x0100
#define ADRV9001_ARM_COMMAND_BUSY                0x80
#define ADRV9001_ADDR_ARM_EXT_CMD_BYTE_1         0x0101
#define ADRV9001_ADDR_ARM_CMD_STATUS_0           0x0106
#define ADRV9001_ADDR_ARM_CMD_STATUS_1           0x0107
#define ADRV9001_ADDR_ARM_CMD_STATUS_8           0x010E
#define ADRV9001_ADDR_ARM_CMD_STATUS_9           0x010F
#define ADRV9001_ADDR_ARM_CMD_STATUS_10          0x0110
#define ADRV9001_ADDR_ARM_CMD_STATUS_12          0x0112
#define ADRV9001_ADDR_ARM_CMD_STATUS_13          0x0113
#define ADRV9001_ADDR_ENSM_CALIBRATION_CONTROL   0x0161
#define ADRV9001_ADDR_BBIC_ENABLES               0x0162
#define ADRV9001_ADDR_ADC1_CLK_DIV2_SEL          0x018E	
#define ADRV9001_ADDR_ADC2_CLK_DIV2_SEL          0x018F
#define ADRV9001_ADDR_DAC1_CLOCK_CTRL            0x0190	
#define ADRV9001_ADDR_DAC2_CLOCK_CTRL            0x0191
#define ADRV9001_ADDR_ARM_CLOCK_CTRL             0x0192
#define ADRV9001_ADDR_TOP_CLOCK_CTRL             0x0193
#define ADRV9001_ADDR_HS_CLK_DIV                 0x0195
#define ADRV9001_ADDR_CLOCK_CONTROL_2            0x0197
#define ADRV9001_ADDR_SW_INTERRUPT_2             0x019F
#define ADRV9001_ADDR_SW_INTERRUPT_4             0x01A1
#define ADRV9001_ADDR_CORE_TDEGC_DONE            0x01A2
#define ADRV9001_ADDR_CORE_MSB_TDEGC_READBACK    0x01A2
#define ADRV9001_ADDR_CORE_LSB_TDEGC_READBACK    0x01A3
#define ADRV9001_ADDR_TEMP_SENSE_CTL_0           0x01A4
#define ADRV9001_ADDR_TEMP_SENSE_CTL_1           0x01A5
#define ADRV9001_ADDR_TEMP_SENSE_CTL_2           0x01A6
#define ADRV9001_ADDR_TEMP_SENSE_CTL_3           0x01A7
#define ADRV9001_ADDR_CLK_SYNTH_LDO_BYTE1        0x01AA
#define ADRV9001_ADDR_CLK_SYNTH_LDO_BYTE2        0x01AB
#define ADRV9001_ADDR_DEV_CLK_LDO_BYTE1          0x01B0    
#define ADRV9001_ADDR_CLK_SYNTH_LP_LDO_BYTE1     0x01B2
#define ADRV9001_ADDR_CLK_SYNTH_LP_LDO_BYTE2     0x01B3
#define ADRV9001_ADDR_MASTERBIAS_CONFIG_0        0x01B4
#define ADRV9001_ADDR_AUX_ADC_TEMP_SENSE_CONTROL 0x01B5
#define ADRV9001_ADDR_ANALOG_CONTROL_1           0x01B8
#define ADRV9001_ADDR_ANALOG_CONTROL_2           0x01B9
#define ADRV9001_ADDR_ANALOG_CONTROL_3           0x01BA
#define ADRV9001_ADDR_ANALOG_CONTROL_4           0x01BB
#define ADRV9001_ADDR_ANALOG_CONTROL_5           0x01BC

#define ADRV9001_ADDR_ANALOG_CONTROL_18          0x01C9
#define ANALOG_CONTROL_18_RESET                  0x05
#define DIG_SYSREF_SAMPLE_ENABLE                 0x02
#define DIG_DEVICE_CLK_BUFFER_ENABLE             0x01
	
#define ADRV9001_ADDR_REF_CLK_GEN_OUT_CLKS_PD    0x01CA
			
#define ADRV9001_ADDR_DEVICE_CLK_CONTROL_1       0x01E0
#define ADRV9001_ADDR_DEVICE_CLK_CONTROL_2       0x01E1
#define ADRV9001_ADDR_DEVICE_CLK_CONTROL_3       0x01E2
#define ADRV9001_ADDR_SYSREF_CONTROL_1           0x01E3
#define ADRV9001_ADDR_SYSREF_CONTROL_3           0x01E4
#define ADRV9001_ADDR_MCS_CONTROL_0              0x01E7	
#define ADRV9001_ADDR_MCS_CONTROL_1              0x01E8
#define ADRV9001_ADDR_MCS_STATUS_0               0x01E9
#define ADRV9001_ADDR_MCS_CLEAR_0                0x01EC

#define ADRV9001_ADDR_RXADC_PD                   0x0200
#define ADRV9001_ADDR_RXADC_G_MEASURED_BYTE0     0x0206
#define ADRV9001_ADDR_RXADC_G_MEASURED_BYTE1     0x0207
#define ADRV9001_ADDR_TEMP_SENSE_CLOCK_DIVIDE    0x020D
#define ADRV9001_ADDR_TEMP_SENSE_CLOCK           0x020C

#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_CTL        0x0231
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_ADDR0      0x0232  /* FLEX_SP SPI-to-AHB BUS_ADDR */
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_ADDR1      0x0233
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_ADDR2      0x0234
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_ADDR3      0x0235
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_DATA0      0x0236 /* MEM_WRITE_DATA */
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_DATA1      0x0237
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_DATA2      0x0238
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_DATA3      0x0239
#define ADRV9001_ADDR_FLEX_SP_ARM_DMA_BYTE_SEL   0x023A
#define ADRV9001_ADDR_FLEX_SP_SELECT             0x023B

#define ADRV9001_ADDR_MCS_REG0                   0x035E
#define ADRV9001_ADDR_MODE_ADC_REG_0             0x0393
#define ADRV9001_ADDR_ANALOG_REF_CLK_REG_1       0x0395
#define ADRV9001_ADDR_ANALOG_SPARE_6             0x039D
	
#define ADRV9001_ADDR_DAC1_CLOCK_ENABLE          0x06C4
#define ADRV9001_ADDR_DAC2_CLOCK_ENABLE          0x0AC4

#define ADRV9001_ADDR_CLK_PLL                    0x1800

#define ADRV9001_ADDR_CLK_PLL_SYNTH_RESETB_OFFSET        0x00
#define ADRV9001_ADDR_CLK_PLL_SYNTH_LOGEN_RESET_OFFSET   0x01
#define ADRV9001_ADDR_CLK_PLL_VCO_CORE_BUF_PD_OFFSET     0x02
#define ADRV9001_ADDR_CLK_PLL_VCO_CORE_SW_DISABLE_OFFSET 0x03
#define ADRV9001_ADDR_CLK_PLL_SYNTH_VCO_PD_OFFSET        0x04
#define ADRV9001_ADDR_CLK_PLL_LO_SYNC_DET_VCO_PD_OFFSET  0x05
#define ADRV9001_ADDR_CLKGEN_RESET_OFFSET                0x0A

#define ADRV9001_ADDR_CP_CAL_BYTE5_OFFSET                0x26

#define ADRV9001_ADDR_CLK_PLL_VCO_PTAT_BIAS_RCAL_OFFSET  0x3A

#define ADRV9001_ADDR_CLK_PLL_VCO_LDO_BYTE1_OFFSET       0x4A

#define ADRV9001_ADDR_MCS_CONTROL_OFFSET                 0x45
#define ADRV9001_ADDR_MCS_CONTROL_2_OFFSET               0x46
#define ADRV9001_ADDR_MCS_CONTROL_3_OFFSET               0x47
#define ADRV9001_ADDR_MCS_CONTROL_4_OFFSET               0x48
#define ADRV9001_ADDR_MCS_CONTROL_5_OFFSET               0x49

#define ADRV9001_ADDR_CLK_PLL_REF_CLK_BYTE0_OFFSET       0xD0	

//FIXME: In Tokelau RX and TX start with 0 i.e. RX0, RX1, TX0, TX1 needs to keep consistent.

#define ADRV9001_ADDR_CLK_PLL_DIVIDER_INT_BYTE0_OFFSET    0x001F
#define ADRV9001_ADDR_CLK_PLL_DIVIDER_INT_BYTE1_OFFSET    0x0020	
#define ADRV9001_ADDR_CLK_PLL_DIVIDER_FRAC_BYTE0_OFFSET   0x0021
#define ADRV9001_ADDR_CLK_PLL_DIVIDER_FRAC_BYTE1_OFFSET   0x0022
#define ADRV9001_ADDR_CLK_PLL_DIVIDER_FRAC_BYTE2_OFFSET   0x0023
#define ADRV9001_ADDR_CLK_PLL_BYTE3_OFFSET                0x0024
		
//#define ADRV9001_ADDR_CLK_PLL_SYN_LOCK_OFFSET             0x002B
#define ADRV9001_ADDR_CLK_PLL_VCO_BAND_BYTE1_OFFSET       0x002B
#define ADRV9001_ADDR_CLK_PLL_LOCKDET_CONFIG_OFFSET       0x002C
#define ADRV9001_ADDR_CLK_PLL_LF_C2_OFFSET                0x002D
#define ADRV9001_ADDR_CLK_PLL_LF_C1_OFFSET                0x002E
#define ADRV9001_ADDR_CLK_PLL_LF_R1_OFFSET                0x002F
#define ADRV9001_ADDR_CLK_PLL_LF_C3_OFFSET                0x0030
#define ADRV9001_ADDR_CLK_PLL_LF_R3_OFFSET                0x0031
#define ADRV9001_ADDR_CLK_PLL_BYTE10_OFFSET               0x0032
	
#define ADRV9001_ADDR_CLK_PLL_BYTE0_OFFSET                0x0033
#define ADRV9001_ADDR_CLK_PLL_VCO_ALC_FREQ_CAL_BYTE0_OFFSET       0x0034
#define ADRV9001_ADDR_CLK_PLL_VCO_ALC_FREQ_CAL_BYTE1_OFFSET       0x0035
#define ADRV9001_ADDR_CLK_PLL_BYTE1_OFFSET                0x0036
#define ADRV9001_ADDR_CLK_PLL_BYTE2_OFFSET                0x0037
#define ADRV9001_ADDR_CLK_PLL_BYTE9_OFFSET                0x0038

#define ADRV9001_ADDR_CLK_PLL_ALC_BYTE0                   0x003B
#define ADRV9001_ADDR_CLK_PLL_ALC_BYTE1                   0x003C

#define ADRV9001_ADDR_CLK_PLL_VCO_F_COARSE_BAND_EN_OFFSET 0x003E
#define ADRV9001_ADDR_CLK_PLL_VCO_F_FINE_BAND_EN_OFFSET   0x003F
#define ADRV9001_ADDR_CLK_PLL_VCO_F_FINE_BAND_OFFSET      0x003F
	
#define ADRV9001_ADDR_CLK_PLL_VCO_TC_BYTE1_OFFSET         0x0041
#define ADRV9001_ADDR_CLK_PLL_VCO_TC_BYTE3_OFFSET         0x0043
#define ADRV9001_ADDR_CLK_PLL_VCO_LDO_BYTE2_OFFSET        0x004B

#define ADRV9001_ADDR_CLK_PLL_SDM_MODE0_BYTE0             0x0072
#define ADRV9001_ADDR_CLK_PLL_SDM_MODE0_BYTE1             0x0073
#define ADRV9001_ADDR_CLK_PLL_SDM_MODE0_BYTE2             0x0074

#define ADRV9001_ADDR_CLK_PLL_SDM_MODE1_BYTE0             0x0075
#define ADRV9001_ADDR_CLK_PLL_SDM_MODE1_BYTE1             0x0076
#define ADRV9001_ADDR_CLK_PLL_SDM_MODE1_BYTE2             0x0077

#define ADRV9001_ADDR_CLK_PLL_SDM_MODE2_BYTE0             0x0078
#define ADRV9001_ADDR_CLK_PLL_SDM_MODE2_BYTE1             0x0079
#define ADRV9001_ADDR_CLK_PLL_SDM_MODE2_BYTE2             0x007A

#define ADRV9001_ADDR_CLK_PLL_TCCTL_OFFSET                0x008A
#define ADRV9001_ADDR_CLK_PLL_TCIDAC_0_OFFSET             0x008B
#define ADRV9001_ADDR_CLK_PLL_TCIDAC_1_OFFSET             0x008C
	
#define ADRV9001_ADDR_CLK_PLL_LOGEN_DIVIDE_MODE_OFFSET    0x0097

#define ADRV9001_ADDR_CLK_PLL_MOD_VCO_CAL_CTL_PLUS_SPARES_OFFSET 0x00D1
#define ADRV9001_ADDR_CLK_PLL_QUICK_FREQ_CAL_CTL_OFFSET   0x00D2
#define ADRV9001_ADDR_CLK_PLL_FREQ_CAL_MAX_CNT0_OFFSET    0x00D3
#define ADRV9001_ADDR_CLK_PLL_FREQ_CAL_MAX_CNT1_OFFSET    0x00D4
#define ADRV9001_ADDR_CLK_PLL_FREQ_CAL_MAX_CNT2_OFFSET    0x00D5

#define ADRV9001_ADDR_CH1_TX                     0x0600
#define ADRV9001_ADDR_CH1_TXB                    0x0800
#define ADRV9001_ADDR_CH2_TX                     0x0A00
#define ADRV9001_ADDR_CH2_TXB                    0x0C00
#define ADRV9001_ADDR_CH1_RX                     0x0E00
#define ADRV9001_ADDR_CH1_RXB                    0x1000
#define ADRV9001_ADDR_CH2_RX                     0x1200
#define ADRV9001_ADDR_CH2_RXB                    0x1400
#define ADRV9001_ADDR_AUX_PLL                    0x1600
#define ADRV9001_ADDR_CLK_PLL                    0x1800
#define ADRV9001_ADDR_RF1_PLL                    0x1A00
#define ADRV9001_ADDR_RF2_PLL                    0x1C00

#define ADRV9001_ADDR_MAIN_STREAM_CTL_OFFSET     0x0116
#define ADRV9001_ADDR_FLEX_SP0_STREAM_CTL_OFFSET 0x023C
#define ADRV9001_ADDR_FLEX_SP1_STREAM_CTL_OFFSET 0x0254
#define ADRV9001_ADDR_FLEX_SP2_STREAM_CTL_OFFSET 0x026C
#define ADRV9001_ADDR_FLEX_SP3_STREAM_CTL_OFFSET 0x0284

#define ADRV9001_STREAM_RESET                    0x01
#define ADRV9001_STREAM_BASE_BYTE0_OFFSET        1
#define ADRV9001_STREAM_BASE_BYTE1_OFFSET        2
#define ADRV9001_LAST_STREAM_NUMBER_OFFSET       3
// End PTN FIXME

#define ADRV9001_ADDR_RX_DECIMATED_PWR_OFFSET         0x03

#define ADRV9001_ADDR_RXB_DEC_POWER_CONFIG1_OFFSET    0x0012
#define ADRV9001_ADDR_RX_DIGITAL_GAIN_CONFIG2_OFFSET  0x0167
	
#ifdef __cplusplus
}
#endif

#endif
