# Changelog

All notable changes to this project will be documented in this file. See standard-version for commit guidelines.

### [20.9.2]


### Bug Fixes

* roundoff error in hsDigClk_Hz

### [20.9.1]


### Bug Fixes

* **client:** only write Tx attenuation table if Tx channels are initialized
* **sps:** Rx1 does not need to be enabled for system power saving, but does for monitor mode
* read/write fpga sysid gpios (pushbuttons and LEDs)

## [20.9.0]


### Features

* clkPllVcoFreq_kHz to clkPllVcoFreq_daHz


### Bug Fixes

* updated smoke test

### [20.8.3]


### Bug Fixes

* correct casting to uint for current measurement

### [20.8.2]


### Bug Fixes

* do not assume PCB revs begin with '0'

### [20.8.1]


### Bug Fixes

* do not attempt to access customer board if no connection exists

## [20.8.0]


### Features

* adjusted power monitoring for customer board; EVB Rf info

### [20.7.2]


### Bug Fixes

* explicitly initialize Adrv9001Ee01 board pointer

### [20.7.1]

## [20.7.0]


### Features

* **client:** call board create from client Initialize

### [20.6.1]


### Bug Fixes

* **client:** close and reopen file descriptors in client switch bin

## [20.6.0]


### Features

* remove reference to board functions in client Initialize

### [20.5.2]

### [20.5.1]

## [20.5.0]


### Features

* expand RF signal bandwidth support to 41 MHz

### [20.4.1]

## [20.4.0]


### Features

* implement ssi power down modes


### Bug Fixes

* fix bug where incorrect source was being assigned to analog gpios. add debug nunit test

## [20.3.0]


### Features

* update carrier_configure to support intermediate frequency


### Bug Fixes

* **powermonitor:** use correct scaled equation to calculate voltage and current
* error should be reported if ARM fails to boot

### [20.2.1]


### Bug Fixes

* AuxDac_Configure initialize gpio struct match designator order to declaration order
* define ADI_RANGE_CHECK_X when ADI_COMMON_VERBOSE is not defined

## [20.2.0]


### Features

* fpga driver support for zc706 reference clock selection

## [20.1.0]


### Features

* consume Rosetta 14.0 and erpcgen 5.2.1

### [20.0.2]

### [20.0.1]


### Bug Fixes

* make generated code namespaces consistent with device module namespaces

## [20.0.0]


### ⚠ BREAKING CHANGES

* rename DLLs and namespaces - replace "Adi.Tpg" with "AnalogDevices"
* remove "erpc" namespace and remove "[Aa]di_" prefixes

### Features

* remove "erpc" namespace and remove "[Aa]di_" prefixes
* rename DLLs and namespaces - replace "Adi.Tpg" with "AnalogDevices"

## [19.1.0]


### Features

* support external LO divisor of 1

## [19.0.0]


### ⚠ BREAKING CHANGES

* requires FW 0.11.1.0+

### Features

* breaking change update to FW


### Bug Fixes

* add table load to hop table set unit test

### [18.9.5]

### [18.9.4]


### Bug Fixes

* remove float usage

### [18.9.3]

### [18.9.2]


### Bug Fixes

* undo conditional based fpga binary switch changes

### [18.9.1]


### Bug Fixes

* dpd configure off by 1byte

## [18.9.0]


### Features

* add Frequency Hopping

### [18.8.13]


### Bug Fixes

* get current gpio config for adc switch inspect function

### [18.8.12]


### Bug Fixes

* included adi_adrv9001_defines.h to adi_adrv9001_cal_types.h

### [18.8.11]


### Bug Fixes

* perform fpga binary load only when the ssi type is changed


### [18.8.10]


### Bug Fixes

* add dpd nunit debug test, add lte10m waveform
* bugfix fpga mc function, 0 means 1 in fpga bitfield
* clean up ahead of pull request
* clean up elb test
* update resources, improve elb, cps and cps and mm nunit debug tests

### [18.8.9]


### Bug Fixes

* **make:** makefile updated to build on platform

### [18.8.8]


### Bug Fixes

* remove 1s delay before and after arm system config mailbox command

### [18.8.7]


### Bug Fixes

* bugfix for powermonitor read, improve power monitor reads on sps and mm nunit debug tests
* disable auto increment for external path delay get function

### [18.8.6]

### [18.8.5]


### Bug Fixes

* bugfix for fpga driver range check corrupting device struct, orx and monitormode nunit tests updated
* comment out ignore of signaltests
* modify validation changes to just orx, add ignore for debug tests
* update orx test


### [18.8.4]


### Bug Fixes

* add 1 sec delay after powersavingpin toggles
* add ability to run all usecases in debug tests
* add adcswitch test
* add extra enum to monitormode state for testing, clean up systempowersaving, add systempowersaving gpio config to init
* add fpga register reads and placeholder for disabling rx2 dma_mode to loopback debug nunit test
* add nunit initcalstatus read test
* add radioctrlinit gpio set
* add rx gain control spi and pin nunit test
* add txattenpincontrol nunit test
* add txssi to rxssi loopback nunit debug test
* add use case inittransmitrx tests to debug nunit
* clean up ahead of pull request
* clean up ahead of pull request
* clean up ahead of pull request
* clean up ahead of pull request
* clean up ahead of pull request
* clean up ahead of pull request
* clean up ahead of pull request
* correction to adcswitch nunit test and addmode set to txatten
* enable txoutputpowerboost and adcswitch, remove reliance on data_get_16i16q for rx capture
* fix bug in order of write to tx atten register lsb last, improve txatten nunit test
* improve txssi to rxssi nunit debug loopback test
* move initcal status read to calibrated state
* test fix for autotdd to keep pins low until programmedenable true. add debug reads to autotdd nunit test
* update fw, remove merge comments, set powersaving nunit test delay to 50 ms
* update profiles, add usecase22 as option
* update resources, add monitor mode test, add power monitor output to inittxrx test
* update resources, improve rx gain test, change mm radioctrlinit values
* updated resources, update debug tests

### [18.8.3]


### Bug Fixes

* apply fpga delays at init time and special delay value for SSI DDR

### [18.8.2]


### Bug Fixes

* review comments and add more validation
* update tx attenuation state transition diagram

### [18.8.1]


### Bug Fixes

* write auxdac_n bitfields LSB first

## [18.8.0]


### Features

* clean up PLL enums
* remove adi_fpga9001_Mmcm_Configure and _Lock_Get


## [18.7.1]


### Bug Fixes

* quietly modify device clock within 250mhz

## [18.7.0]


### Features

* add a new function to allow rssi be configured at initialization

### [18.6.4]


### Bug Fixes

* **power saving:** ChannelPowerSaving_Inspect - only check channel state if channel is initialized
* **tdd:** in manual mode, enable tdd dma
* aux adc number scheme fix to be consistent with aux dac

### [18.6.3]


### Bug Fixes

* use port 0 for all aux adc
* write all bitfields MSB first

### [18.6.2]

### [18.6.1]


### Bug Fixes

* remove tdd_start from frame_set. update auto tdd nunit test

## [18.6.0]


### Features

* add capability to configure on-board LDOs for additional power saving


### Bug Fixes

* disable auto increment for temperature get function
* disable auto increment to avoid out of bounds access in various functions
* return error if byte count is not multiple of 4
* txoutputpowerboost pass as value instead of reference

## [18.5.0]


### Features

* add ADI_ADRV9001_ARM_MONITORMODE_UNDEFINED

## [18.4.0]


### Features

* **tdd:** add SMA output controls


### Bug Fixes

* add fpga tdd status read, add manual set of enables to low
* add ignore for debug tests
* add radiostate get and reads from fpga registers to auto tdd
* driver to use tdd enables. nunit update tdd jsons
* fix conflicts with master merge. handle enable_set and enable_get. update tdd json files with sma info
* modify tdd jsons. add use cases for auto tdd
* update profile and fw version, update testsettings accordingly
* update profiles and add nunit tdd manual and auto tests
* update to fpga 0.6.5. edit tdd json file

## [18.3.0]


### Features

* program dpfifo and correlator patterns

### [18.2.4]


### Bug Fixes

* correctly set mmcm ssi clock frequency

### [18.2.3]

### [18.2.2]


### Bug Fixes

* added axi ref clock gen drivers
* axi adrv9001 tdd typo fix
* enable tdd auto and start during frame config

### [18.2.1]


### Bug Fixes

* array length issue in internal path delay get function

## [18.2.0]


### Features

* upgrade init struct for power savings

### [18.1.1]

## [18.1.0]


### Features

* **auxdac:** inform firmware of gpio usage
* **cals:** rename `adi_adrv9001_InitCalMode_e` values to be more descriptive
* **fpga:** update to fpga 0.6.4
* **tx:** configure just tx output power boost instead of attenuation in Initialize

## [18.0.0]


### ⚠ BREAKING CHANGES

* **auxadc:** removed "adi_adrv9001_AuxAdc_Range_e"
* renamed `adi_adrv9001_Radio_CarrierFrequency_Set` -> `adi_adrv9001_Radio_Carrier_Configure` and added config struct for BPN/BPS

### Features

* add function to expose rx gain index on dgpio to customer
* add function to read path delay for the given port and channel
* **auxadc:** modify code to remove voltage range enum
* **power saving:** add LDO power down mode
* support carrier configuration of BPN vs BPS


### Bug Fixes

* **gain control:** inspect returns gpio assignments

## [17.1.0]


### Features

* **tx freqcorrection:** tx frequency correction functionality

### [17.0.1]


### Bug Fixes

* **fpga:** gpio and tdd changes to update to FPGA 0.6.3

## [17.0.0]


### ⚠ BREAKING CHANGES

* **fpga:** requires update to FPGA v0.6.2
* **auxdac:** rename `adi_adrv9001_AuxDacs_e` -> `adi_adrv9001_AuxDac_e`

### Features

* **auxadc:** add AuxAdc functionality
* **auxdac:** rename `adi_adrv9001_AuxDacs_e` -> `adi_adrv9001_AuxDac_e`
* **fpga:** axi driver support

### [16.0.1]

## [16.0.0]


### ⚠ BREAKING CHANGES

* **version:** remove `adi_common_ApiVersion_t.build`
* **fpga:** remove `adi_fpga9001_FpgaBinDirectorySet`

### Features

* **fpga:** remove FpgaBinDirectorySet
* **version:** remove `adi_common_ApiVersion_t.build`

### [15.0.2]

### [15.0.1]


### Bug Fixes

* **agc:** limit range of resetOnRxonGainIndex

## [15.0.0]


### ⚠ BREAKING CHANGES

* rename dacFullScaleBoostEnable -> txOutputPowerBoostEnable

### Features

* rename dacFullScaleBoostEnable -> txOutputPowerBoostEnable

### [14.3.9]


### Bug Fixes

* **makefile:** incorrect syntax

### [14.3.8]


### Bug Fixes

* **makefile:** tabbing incorrect

### 14.3.7


### Bug Fixes

* **make:** c code builds on platform


### 14.3.6


### Bug Fixes

* **examples:** use default install directory for example code
* workaround for dma read with auto increment

### 14.3.5


### Bug Fixes

* remove need for calling FpgaBinDirectorySet
* **rosetta:** ensure device contexts are calloc'ed in multiple log case
* ensure standard bool is correctly included


### 14.3.4


### Bug Fixes

* offset armPowerSavingClkDiv by 1 so customer sees literal divisor
* rearrange tx ssi configuration for fixed pattern check


### 14.3.3


### Bug Fixes

* support single channel configuration w/PG actually setting ssiType

### 14.3.2


### Bug Fixes

* **agc:** update agc secondary threshold calculation

### 14.3.1


### Bug Fixes

* **powermonitor:** use the correct current scale factor for VDD_1P0
* allow only fixed pattern test for non 16 bit ssi data format
* support all ssi data formats in inspect function

## 14.3.0


### Features

* **fpga:** support ssi delay configuration for fpga


### Bug Fixes

* **fpga ssi:** add delay and clear Rx test mode error bits
* **ssi:** read correct bitfield for test mode status
* enforce state constraints for setting attenuation mode
* force lvds to use ddr

## 14.2.0


### Features

* **fpga:** support CMOS DDR modes


### Bug Fixes

* **power saving:** only check channel state if channel is initialized
* profile verification failed with ilb2 enabled and elb2 disabled
* return error instead of warning if disabling rf fails
* validate that channel enable mode is SPI for enableRf
* **ssi:** can now repeatedly write ssi delays
* tx2 ref clk cmos delay was written to wrong address

## 14.1.0


### Features

* add capability to dynamically switch adc
* **agc:** update threshold calculation for b0


### Bug Fixes

* **agc:** use larger integer type so entire bitfield is written
* **gpio:** unassigned enum value was handled incorrectly

## 14.0.0


### ⚠ BREAKING CHANGES

* **gpio:** adi_adrv9001_gpio_Configure now takes a signal argument
* **mcs:** a0 no longer supported

### Features

* add system power saving mode functions
* **dpd:** allow compander size 512
* support reset of DPD
* **mcs:** clean up mcs interface, drop support for a0, no polling
* add hal functions for ssi reset and mcs pulse


### Bug Fixes

* bbdc enable set function was returning an error for orx
* include lvdsTxClkDelay values in default radioCtrlInit_t
* only configure power saving gpio if pin is assigned
* support full range of external path delay and enforce maximum


* **gpio:** configure function takes a signal to clean up interface

## 13.0.0


### ⚠ BREAKING CHANGES

* removed adi_adrv9001_RadioCtrlInit_t.adrv9001ReferenceClockDivisor and renamed .adrv9001DeviceClockDivisor to .adrv9001DeviceClockOutputDivisor
* radioCtrlInit dpd field is now an array
* AnalogDevices.Adrv9001.ProfileTypes.dll is now required

### Features

* functions to measure, read and set the elb path delay
* functions to measure, read and set the elb path delay
* functions to measure, read and set the elb path delay
* functions to measure, read and set the elb path delay


### Bug Fixes

* **rosetta:** matlab grafeas points to b0
* add mailbox command set elb path delay during initialization
* code changes based on review comments
* convert elb path delay in picosecond based on review comments
* correctly set max gain index for no fs gain table load
* don't clobber current log level when disabling spi logging
* enable gain/atten table clock in write and read functions
* fix issues due to rebase
* missing last index write for tx attenuation table
* modify comments and variable names
* profile parse function should be conditionally compiled
* protect against divide by 0
* rebase related errors
* rephrase doxygen comments to be more helpful to understand
* revert wrong evalclient submodule
* revert wrong evalclient submodule
* revert wrong evalclient submodule
* revert wrong evalclient submodule
* review comments
* unwanted changes due to rebase


* consume profile types via nuget package
* radioCtrlInit dpd field is now an array to be consistent
* remove ref clock divisor and modify device clock out logic

## 12.0.0


### ⚠ BREAKING CHANGES

* Removed ssiConfigSettings parameter from adrv9001Ee01_internal_InitializeFromProfile

### Features

* add ssi calibration feature for cmos and lvds interfaces
* allow larger atten table and update for b0
* allow monitor mode in any of the channel states
* api to support tx attenuation control through gpio pin
* support dynamic update of tdd timing parameters


### Bug Fixes

* allow new fpga versions
* code change based on review comments
* code changes based on review comments
* disallow bbdc rejection enable set in standby state
* rephrase the comment to be more precise

## 11.1.0


### Features

* add getter method for individual channel state

### 11.0.3


### Bug Fixes

* **make:** runs without segfault on platform

## 11.0.2


### Bug Fixes

* can configure gain control pin mode for channel 2

## 11.0.0


### ⚠ BREAKING CHANGES

* removed old fpga gpio functions

### Features

* add ability to pass stream binary as byte array
* add power saving monitor mode configuration functions
* add support for offline code generation


### Bug Fixes

* can now set fpga pins high and low
* change min allowed rx bandwidth from 12khz to 6.25khz
* remove mcs callback as no longer needed in b0 and fix bug in init
* update grafois so connection is made correctly
* remove redundant fpga gpio functions

## 10.0.0


### ⚠ BREAKING CHANGES

* renamed gain control mode functions

### Features

* add functions for configuring pin control of rx gain
* **b0:** added device initialization sequence for b0 silicon
* modify internal utilities debug mailbox cmd to enable rx ssi


### Bug Fixes

* **fpga:** could not toggle pin repeatedly high and low
* **gpio:** input level get did not return enum value
* add doxygen option to generate erpc for b0
* build errors in a0 due to changes in b0
* remove old parameters in struct added during merge
* rename and move gain control mode set get functions

## 9.0.0

### ⚠ BREAKING CHANGES

* renamed various rx and rx gain control types
* renamed functions and types related to gain control

### Features

* **gainindex capture:**  add test to capture gain index over gpio
* **nunit framework:** add tetra profiles to profileNameGet
* **orx/elb/ilb:** add nunit test to configure and
* **orx/elb/ilb:** remove on/off_lo information from tests
* dpd configuration


### Bug Fixes

* **error:** non-verbose error handling
* added conditional platform timeout
* fix failing mmcm gtest
* fix gtest failure
* fix lcmInterfaceSampleRate calculation for mmcm calculation
* increase wait time for disabling rf
* load rx/orx tables also for the selected tx channel
* mmcm to use lcm of interface rate, extend tdd_clk range to 200mhz
* modify parameter name in mmcm configure func to more relevant name
* **error:** adi error report macro when verbose off
* nss-794, tx1 only failed
* swap order of gpio crumbs for gain control feedback signals
* update profilegen to 0.9.12
* **agc config:** update agc config values to latest from gui
* **nunit framework:** add description to rxgainindexget nunit test
* **nunit framework:** update pac to fw 0.7.1.1 and profiles 7.0.0.6
* added conditional platform timeout
* nss-730 resolved
* nss-730 resolved
* protect against divide by zero - occurred in single channel profile
* rxclkrate set to 0 for day 7
* rxclkrate set to 0 for day 7
* shift bitfield back down so an actual GpioPinLevel_e is returned


* change references of agc to gain control
* rename rx and gain control types


## 8.4.0


### Features

* **gainindex capture:**  add test to capture gain index over gpio
* **nunit framework:** add tetra profiles to profileNameGet
* **orx/elb/ilb:** add nunit test to configure and
* **orx/elb/ilb:** remove on/off_lo information from tests
* dpd configuration


### Bug Fixes

* **error:** non-verbose error handling
* added conditional platform timeout
* fix failing mmcm gtest
* fix gtest failure
* fix lcmInterfaceSampleRate calculation for mmcm calculation
* increase wait time for disabling rf
* load rx/orx tables also for the selected tx channel
* mmcm to use lcm of interface rate, extend tdd_clk range to 200mhz
* modify parameter name in mmcm configure func to more relevant name
* **error:** adi error report macro when verbose off
* nss-794, tx1 only failed
* swap order of gpio crumbs for gain control feedback signals
* update profilegen to 0.9.12
* **agc config:** update agc config values to latest from gui
* **nunit framework:** add description to rxgainindexget nunit test
* **nunit framework:** update pac to fw 0.7.1.1 and profiles 7.0.0.6
* added conditional platform timeout
* nss-730 resolved
* nss-730 resolved
* protect against divide by zero - occurred in single channel profile
* rxclkrate set to 0 for day 7
* rxclkrate set to 0 for day 7
* shift bitfield back down so an actual GpioPinLevel_e is returned

## 8.3.0


### Features

* **gainindex capture:**  add test to capture gain index over gpio
* **nunit framework:** add tetra profiles to profileNameGet
* **orx/elb/ilb:** add nunit test to configure and
* **orx/elb/ilb:** remove on/off_lo information from tests
* dpd configuration


### Bug Fixes

* added conditional platform timeout
* fix failing mmcm gtest
* fix gtest failure
* fix lcmInterfaceSampleRate calculation for mmcm calculation
* increase wait time for disabling rf
* load rx/orx tables also for the selected tx channel
* mmcm to use lcm of interface rate, extend tdd_clk range to 200mhz
* modify parameter name in mmcm configure func to more relevant name
* **error:** adi error report macro when verbose off
* nss-730 resolved
* nss-794, tx1 only failed
* update profilegen to 0.9.12
* **agc config:** update agc config values to latest from gui
* **nunit framework:** add description to rxgainindexget nunit test
* **nunit framework:** update pac to fw 0.7.1.1 and profiles 7.0.0.6
* added conditional platform timeout
* nss-730 resolved
* protect against divide by zero - occurred in single channel profile
* rxclkrate set to 0 for day 7
* rxclkrate set to 0 for day 7
* shift bitfield back down so an actual GpioPinLevel_e is returned
* swap order of gpio crumbs for gain control feedback signals

## 8.2.0


### Features

* **gainindex capture:**  add test to capture gain index over gpio
* **nunit framework:** add tetra profiles to profileNameGet
* **orx/elb/ilb:** add nunit test to configure and
* **orx/elb/ilb:** remove on/off_lo information from tests
* dpd configuration


### Bug Fixes

* increase wait time for disabling rf
* nss-794, tx1 only failed
* **agc config:** update agc config values to latest from gui
* **nunit framework:** add description to rxgainindexget nunit test
* **nunit framework:** update pac to fw 0.7.1.1 and profiles 7.0.0.6
* added conditional platform timeout
* added conditional platform timeout
* nss-730 resolved
* nss-730 resolved
* protect against divide by zero - occurred in single channel profile
* rxclkrate set to 0 for day 7
* rxclkrate set to 0 for day 7
* shift bitfield back down so an actual GpioPinLevel_e is returned
* swap order of gpio crumbs for gain control feedback signals

## 8.1.0


### Features

* **gainindex capture:**  add test to capture gain index over gpio
* **nunit framework:** add tetra profiles to profileNameGet
* **orx/elb/ilb:** add nunit test to configure and
* **orx/elb/ilb:** remove on/off_lo information from tests
* dpd configuration


### Bug Fixes

* increase wait time for disabling rf
* **agc config:** update agc config values to latest from gui
* **nunit framework:** add description to rxgainindexget nunit test
* **nunit framework:** update pac to fw 0.7.1.1 and profiles 7.0.0.6
* added conditional platform timeout
* added conditional platform timeout
* nss-730 resolved
* nss-730 resolved
* protect against divide by zero - occurred in single channel profile
* rxclkrate set to 0 for day 7
* rxclkrate set to 0 for day 7
* shift bitfield back down so an actual GpioPinLevel_e is returned
* swap order of gpio crumbs for gain control feedback signals

## 8.0.0 - 2019-11-01
### Added
- Added driver to support manual and automated ORX Capture
    - Added `adi_adrv9001_radio_GpioConfig_Set` to inform the ADRV9001 which GPIO pins are used
    - Added `adi_fpga9001_gpio_pin_SourceMode_Configure` to inform the FPGA which GPIO pins to route the ORX Enable signals to

### Changed
- Modified 'adi_adrv9001_Init_t' struct to include additional values needed for B0
- ORx maximum gain index is now 14 rather than 10
- Modified the following functions to support ORx
    - `adi_fpga9001_DataChain_Configure`
    - `adi_fpga9001_DataChain_RxCapture_Wait`
- Modified FPGA RAM offsets in adi_fpga9001_datachain.h to accommodate ORX data be captured in RAM
- Modified `adi_adrv9001_Rx_InterfaceGain_Inspect` and `adi_adrv9001_Rx_InterfaceGain_Get` to not allow in STANDBY state

### Fixed
- Profile validation no longer couples ORx and Loopback channels
- 'rxClkRate_Hz' calculation to fix Rx data capture issue
- Fixed mask bits to get SSI mode in `adi_fpga9001_ssi_Mode_Get`
- `adi_adrv9001_Tx_Attenuation_Configure` and `adi_adrv9001_Tx_Attenuation_Set` weren't getting called during initialization

## 7.0.0 - 2019-10-16
### Added
- Added `interFrameControlSignal1/2` to `adi_fpga9001_TddConfig_t`
- Added `adi_adrv9001_ORx_Gain_Set` and `adi_adrv9001_ORx_Gain_Get` functions to set/get gain index for ORx channels
- Added `adi_adrv9001_TrackingCals_Set` and `adi_adrv9001_TrackingCals_Get` functions to set/get tracking calibrations

#### INTERNAL ONLY
- Add ability to configure the observationGpio data path control, control the tollgate trigger and capture gainIndex data to RAM

### Changed
- Updated NUnit tests to use the new profile filenames
- Updated 'adrv9001_FeatureID_e' enum to support the following features:
    - ORX_ENABLE
    - RX_EXT_FRONTEND_CONTROL
    - TX_EXT_FRONTEND_CONTROL
    - TX_PA_RAMP_CTRL
- Renamed `adrv9001_RxInterfaceGain_e` -> `adi_adrv9001_RxInterfaceGain_e` and added values down to -36 dB
- Renamed `adrv9001_RxInterfaceGainCtrlType_e` -> `adi_adrv9001_RxInterfaceGainCtrlMode_e`
- Renamed `adrv9001_RxInterfaceGainCtrl_t` -> `adi_adrv9001_RxInterfaceGainCtrl_t`
- Changed `adi_adrv9001_RxInterfaceGainCtrl_t`:
    - `updateInstance` -> `bool updateImmediate`
    - `gainControlMode` -> `controlMode`
- Modified `adi_fpga9001_TddFraming_t` to support FPGA 0.4.14:
    - `frameSwitchTime` is now `uint32_t` instead of `uint8_t`
    - Added `frameSwitchTimeChannel`
- Increased streamImageFile array length to 256 characters
- Modified `adi_adrv9001_Rx_InterfaceGain_Configure/Inspect` and `adi_adrv9001_Rx_InterfaceGain_Set/Get` APIs as per updated interface
    - Removed 'sigPar_dB' from adi_adrv9001_RxInterfaceGainCtrl_t
    - Added a new enum type 'adi_adrv9001_RxGainTableType_e' to determine the type of gain table loaded during ADRV9001 initialization
    - Added a detailed range check for 'gain'

### Fixed
- Bitfield value for FPGA internal tone selection fixed
- Fixed the upper threshold limits for the following AGC configuration bit fields
    - 'underRangeLowPowerThreshold' -> From 31 to 15
    - 'overRangeHighPowerThreshold' -> From 127 to 15
    - 'overRangeLowPowerThreshold'  -> From 15 to 127
- Fixed a bug in 'SWTxPaRampConfigureInspect' gtest
- Fixed the byte order of "signalPar_dB" and "gain" in 'adi_adrv9001_Rx_InterfaceGain_Configure' and 'adi_adrv9001_Rx_InterfaceGain_Inspect' functions
- When not `ADI_COMMON_VERBOSE`, `ADI_ERROR_REPORT` macro now saves values to the common error struct so functions still return error values correctly using the `ADI_API_RETURN` macro
- Fixed broken GTests `SWPllLoopFilterSetGetTest` and `SWSrlCfgSetGetTest` by disabling auto increment in adi_adrv9001_arm_Memory_Read
- Fixed 'adi_adrv9001_cals_Tracking_Set/Get' bug by starting ERPC service for 'cals' interface


## 0.6.0 - 2019-08-19
### Added
- `adi_fpga9001_McsEdge_e` to select MCS pulse device clock edge alignment
- Functions to convert `adi_common_Port_e` and `adi_common_ChannelNumber_e` to/from numeric indexes:
    - `adi_common_port_to_index` and `adi_common_index_to_port`
    - `adi_common_channel_to_index` and `adi_common_index_to_channel`
    - NOTE: Not currently available in client due to limitations in eRPC
- Function to convert from a set of `adi_common_Port_e`/`adi_common_ChannelNumber_e` combinations to a FW compatible bitmask: `adi_adrv9001_Radio_MailboxChannelMask_Get`
- Functions to PRIME or ENABLE RF for multiple channels in a single call:
    - `adi_adrv9001_Radio_Channels_Prime`
    - `adi_adrv9001_Radio_Channels_EnableRf`
- Functions to power down/up channels:
    - `adi_adrv9001_Radio_Channel_PowerDown` and `adi_adrv9001_Radio_Channels_PowerDown`
    - `adi_adrv9001_Radio_Channel_PowerUp` and `adi_adrv9001_Radio_Channels_PowerUp`

### Changed
- Renamed `adi_fpga9001_DataChain_DmaRunStop_Set` -> `adi_fpga9001_DataChain_DmaRun_Set`
- Renamed `adi_adrv9001_InitCalibrations_e` values:
    - `ADI_ADRV9001_TX_QEC` -> `ADI_ADRV9001_INIT_CAL_TX_QEC`
    - `ADI_ADRV9001_TX_LOL` -> `ADI_ADRV9001_INIT_CAL_TX_LO_LEAKAGE`
    - `ADI_ADRV9001_TX_LBPD` -> `ADI_ADRV9001_INIT_CAL_TX_LB_PD`
    - `ADI_ADRV9001_TX_DCC` -> `ADI_ADRV9001_INIT_CAL_TX_DCC`
    - `ADI_ADRV9001_TX_BBAF` -> `ADI_ADRV9001_INIT_CAL_TX_BBAF`
    - `ADI_ADRV9001_TX_BBAF_GD` -> `ADI_ADRV9001_INIT_CAL_TX_BBAF_GD`
    - `ADI_ADRV9001_TX_ATTD` -> `ADI_ADRV9001_INIT_CAL_TX_ATTEN_DELAY`
    - `ADI_ADRV9001_TX_DAC` -> `ADI_ADRV9001_INIT_CAL_TX_DAC`
    - `ADI_ADRV9001_TX_PD` -> `ADI_ADRV9001_INIT_CAL_TX_PATH_DELAY`
    - `ADI_ADRV9001_RX_HPADC_RC` -> `ADI_ADRV9001_INIT_CAL_RX_HPADC_RC`
    - `ADI_ADRV9001_RX_HPADC_FLASH` -> `ADI_ADRV9001_INIT_CAL_RX_HPADC_FLASH`
    - `ADI_ADRV9001_RX_HPADC_DAC` -> `ADI_ADRV9001_INIT_CAL_RX_HPADC_DAC`
    - `ADI_ADRV9001_RX_DCC` -> `ADI_ADRV9001_INIT_CAL_RX_DCC`
    - `ADI_ADRV9001_RX_LPADC` -> `ADI_ADRV9001_INIT_CAL_RX_LPADC`
    - `ADI_ADRV9001_RX_TIA_CUTOFF` -> `ADI_ADRV9001_INIT_CAL_RX_TIA_CUTOFF`
    - `ADI_ADRV9001_RX_TIA_FINE` -> `ADI_ADRV9001_INIT_CAL_RX_GROUP_DELAY`
    - `ADI_ADRV9001_RX_TCAL` -> `ADI_ADRV9001_INIT_CAL_RX_QEC_TCAL`
    - `ADI_ADRV9001_RX_FIIC` -> `ADI_ADRV9001_INIT_CAL_RX_QEC_FIC`
    - `ADI_ADRV9001_RX_ILB_LOD` -> `ADI_ADRV9001_INIT_CAL_RX_QEC_ILB_LO_DELAY`
    - `ADI_ADRV9001_RX_RFDC_OFFSET` -> `ADI_ADRV9001_INIT_CAL_RX_RF_DC_OFFSET`
    - `ADI_ADRV9001_RX_GPD` -> `ADI_ADRV9001_INIT_CAL_RX_GAIN_PATH_DELAY`
    - `ADI_ADRV9001_PLL` -> `ADI_ADRV9001_INIT_CAL_PLL`
    - `ADI_ADRV9001_AUXPLL` -> `ADI_ADRV9001_INIT_CAL_AUX_PLL`
    - `ADI_ADRV9001_TX_ALL` -> `ADI_ADRV9001_INIT_CAL_TX_ALL`
    - `ADI_ADRV9001_RX_ALL` -> `ADI_ADRV9001_INIT_CAL_RX_ALL`
    - `ADI_ADRV9001_RX_TX_ALL` -> `ADI_ADRV9001_INIT_CAL_RX_TX_ALL`
    - `ADI_ADRV9001_SYSTEM_ALL` -> `ADI_ADRV9001_INIT_CAL_SYSTEM_ALL`
- `adi_fpga9001_Mcs_Start` now takes pulse width and edge selection parameters
- `adi_adrv9001_Radio_Channel_Prime` and `adi_adrv9001_Radio_Channel_EnableRf` now take a boolean parameter instead of having a separate function for the inverse state transition
- `adi_adrv9001_RadioState_t.channelStates` is now a 2x2 instead of 2x3 matrix; the port-index and channel-index conversion functions should now be used for accessing the individual channel states
- Channel bitmasks are now interpreted consistently with both the profile generator and the firmware
- Review and implement customer enablement team recommendations
- Renamed `adi_adrv9001_InitCalMode_e` values:
    - `ADI_ADRV9001_INITCAL_RUN_ALL_ALGO_MODE` -> `ADI_ADRV9001_INIT_CAL_MODE_ALL`
    - `ADI_ADRV9001_INITCAL_RUN_RX_ALGO_MODE` -> `ADI_ADRV9001_INIT_CAL_MODE_RX`
    - `ADI_ADRV9001_INITCAL_RUN_LB_ALGO_MODE` -> `ADI_ADRV9001_INIT_CAL_MODE_TX`
- Change "TDD_CLK_MAX = 245760;" to "TDD_CLK_MAX = 200000;" in adi_fpga9001_mmcm.c so that it does not exceed the FPGA timing constraint limit of 200 MHz
- Modify `adi_adrv9001_Rx_Rssi_Read` to avoid floating point usage

### Removed
- Removed radio functions in favor of combined versions - `adi_adrv9001_Radio_Channel_UnPrime` and `adi_adrv9001_Radio_Channel_DisableRf`
- Removed `adi_adrv9001_RxChannels_e` because it duplicated the same concept as other enums
- Removed previously deprecated function `adi_adrv9001_MailboxChannelMask`
- Remove floating point usage in DDAPI
- Use special divide primitives for compatibility across various 32/64 bit platforms
- Protect against `libc` includes
- Use strict function prototypes to avoid compiler warnings

### Fixed
- Fixed bug that resulted in corrupted FPGA data if RAM was modified between PerformTx calls
- Fixed `SWTxAttenSetGet` GTest


## 0.5.4 - 2019-08-01
### Added
- Added `adi_adrv9001_Rx_Agc_Feedback_Configure` API to route AGC signals to digital GPIO
- `adi_adrv9001_PlatformFiles_t.orxGainTableFile` for specifying ORx gain table
- `adi_adrv9001Ee01_InitCals_Run` so client can call without passing function pointer
#### INTERNAL ONLY
- Functions to provide the internal ADI user access to firmware debug functions:
    - `adi_adrv9001_internal_utilities_Firmware_Debug_Rx_Ssi_Enable`
    - `adi_adrv9001_internal_utilities_Firmware_Debug_Rx_Datapath_Configure`
    - `adi_adrv9001_internal_utilities_Firmware_Debug_Ilb_Calibration_Tone_Configure`
    - `adi_adrv9001_internal_utilities_Firmware_Debug_Generic_Configure`

### Changed
- Tailor the voltage and current ranges of each supply domain to more precisely monitor power
- Renamed `adi_adrv9001Ce01_PowerMonitor_e` enums to reflect power domains:
    - `ADI_ADRV9001CE01_POWERMONITOR_0` -> `ADI_ADRV9001CE01_POWERMONITOR_VDD_1P0`,
    - `ADI_ADRV9001CE01_POWERMONITOR_1` -> `ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P0`,
    - `ADI_ADRV9001CE01_POWERMONITOR_2` -> `ADI_ADRV9001CE01_POWERMONITOR_VDD_1P8`,
    - `ADI_ADRV9001CE01_POWERMONITOR_3` -> `ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P8`,
    - `ADI_ADRV9001CE01_POWERMONITOR_4` -> `ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P3`
- Modified 'peakThreshGainControlMode' to 'agcControlMode' and the type from 'bool' to 'adi_adrv9001_rxGainControlType_e' in adi_adrv9001_AgcCfg_t
- Modified `adi_adrv9001_Utilities_InitRadio_Load` to always write ORx gain table
- Modified `adi_adrv9001_Rx_GainCtrlMode_Set` to set gc_use_counters_for_mgc bit to '1' in MGC mode to reset gain peak and power signal counters exceeded counters
- Renamed `adi_adrv9001_InitCalsRun` -> `adi_adrv9001_InitCals_Run`
- All forms of Initialize no longer call `adi_adrv9001_InitCals_Run`
- All instances of `adi_adrv9001_RadioConfig_t` have been replaced with `adi_adrv9001_RadioCtrlInit_t` to reduce nesting
- Modified 'decimated_data_overload_secondary_upper_threshold'
- Renamed `adi_adrv9001_InitCalibrations_e` values:
    - `ADI_ADRV9001_TX_LOD` -> `ADI_ADRV9001_TX_DCC`
    - `ADI_ADRV9001_RX_HPADC_STABILITY` -> `ADI_ADRV9001_RX_DCC`

### Removed
- `adi_adrv9001_RadioConfig_t` because it only contained `adi_adrv9001_RadioCtrlInit_t` and `adi_adrv9001_InitCals_t`
- `adi_adrv9001_Day1ExecPhase_e`: `ADI_ADRV9001_DAY1_EXEC_PHASE_INIT_CALIBRATIONS` and `ADI_ADRV9001_DAY1_EXEC_PHASE_INIT_RX_GAIN_PARAMETERS`
- `adi_adrv9001_RadioCtrlInit_t.gainIndexes` as it is not required

### Fixed
- `zc706sd20_eeprom_FmcFru_Read` now handles EEPROM not being present
- Fixed the values of 'peak_detect' and 'peak_and_power_detect' modes in `adi_adrv9001_RxAgcDetectMode_e`


## 0.5.3 - 2019-07-22
### Changed
- Renamed various functions to follow naming conventions:
    - `adi_channel_to_index` -> `adi_common_channel_to_index`
    - `adi_adrv9001_ApiVersionGet` -> `adi_adrv9001_ApiVersion_Get`
    - `adi_adrv9001_DeviceRevGet` -> `adi_adrv9001_DeviceRev_Get`
    - `adi_adrv9001_ProductIdGet` -> `adi_adrv9001_ProductId_Get`
    - Moved `adi_adrv9001_Temperature_Get` to from adi_adrv9001_gpio interface adi_adrv9001 interface
    - `adi_adrv9001_GpIntHandler` -> `adi_adrv9001_gpio_GpIntHandler`
    - `adi_adrv9001_GpIntMaskSet/Get` -> `adi_adrv9001_gpio_GpIntMask_Set/Get`
    - `adi_adrv9001_GpIntStatusGet` -> `adi_adrv9001_gpio_GpIntStatus_Get`
    - `adi_adrv9001_GpioOutEnGet` -> `adi_adrv9001_gpio_Outputs_Get`
    - `adi_adrv9001_GpioInputDirSet` -> `adi_adrv9001_gpio_Inputs_Set`
    - `adi_adrv9001_GpioOutputDirSet` -> `adi_adrv9001_gpio_Outputs_Set`
    - `adi_adrv9001_GpioAnalogInput/OutputDirSet` -> `adi_adrv9001_gpio_AnalogInputs/Outputs_Set`
    - `adi_adrv9001_GpioOutSourceCtrlSet/Get` -> `adi_adrv9001_gpio_OutputSourceCtrl_Set/Get`
    - `adi_adrv9001_GpioOutPinLevelSet/Get` -> `adi_adrv9001_gpio_OutputPinLevel_Set/Get`
    - `adi_adrv9001_GpioInputPinLevelGet` -> `adi_adrv9001_gpio_InputPinLevel_Get`
    - `adi_adrv9001_GpioMonitorOutputSourceSet/Get` -> `adi_adrv9001_gpio_MonitorOutputSource_Set/Get`
    - `adi_adrv9001_InitDigitalLoad` -> `adi_adrv9001_Utilities_InitDigital_Load`
    - `adi_adrv9001_InitRadioLoad` -> `adi_adrv9001_Utilities_InitRadio_Load`
    - `FpgaBinDirectorySet` -> `adi_fpga9001_FpgaBinDirectorySet`
    - `adi_fpga9001_AxiAdvSpiCfgSet` -> `adi_fpga9001_AxiAdvSpi_Configure`
    - `adi_fpga9001_AxiAdvSpiChipSelectAll` -> `adi_fpga9001_AxiAdvSpi_SelectAllChips`
    - `adi_fpga9001_GpioModeSet/Get` -> `adi_fpga9001_gpio_Mode_Set/Get`
    - `adi_fpga9001_GpioDirSet/Get` -> `adi_fpga9001_gpio_Direction_Set/Get`
    - `adi_fpga9001_GpioWrite/Read` -> `adi_fpga9001_gpio_Write/Read`
    - `adi_fpga9001_RegisterRead/Write` -> `adi_fpga9001_hal_Register_Read/Write`
    - `adi_fpga9001_RegisterFieldRead/Write` -> `adi_fpga9001_hal_Field_Read/Write`
    - `adi_fpga9001_RamRead/Write` -> `adi_fpga9001_hal_Ram_Read/Write`
- Added adi_adrv9001_Day1ExecPhase_e.ADI_ADRV9001_DAY1_EXEC_PHASE_INIT_RX_GAIN_PARAMETERS
- Renamed `adi_fpga9001_CmosSsiLaneSel_e` -> `adi_fpga9001_SsiLaneSel_e`:


## 0.5.2 - 2019-07-17
### Added
- Enabled loading of stream binary
- `adi_adrv9001_Stream_Version` to get stream binary version information
- ADRV9001CE board-specific functions to interact with onboard power monitoring chips:
    - `adi_adrv9001Ce01_PowerMonitor_Configure`
    - `adi_adrv9001Ce01_PowerMonitor_Read`
- Create separate ORX interface
- `adi_adrv9001_ORx_BbdcRejectionEnable_Set/Get` to allow user to disable BBDC on the ORX channel if needed
- `adi_adrv9001_Rx_FrequencyCorrection_Set` to set NCO frequency to correct for small deviations in Rx LO frequency

### Changed
- Modify MMCM Calculation logic to ensure TDD clock is an integer multiple of Navassa Rx interface Sample rate
- MCS:
    - Hack for ARM requesting specific type of MCS removed
    - FPGA SSI reset after issuing MCS
    - Check for GPINT sticky flag
- Renamed `adi_fpga9001_SsiChannelReset` -> `adi_fpga9001_ssi_Reset`

### Removed
- Temporary i2c functions:
    - ```zc706sd20_i2cOpen/Close```
    - ```zc706sd20_i2cWrite/Read```

### Fixed
- Bug fix in error reporting in 'ADI_EXPECT' macro


## 0.5.1 - 2019-06-18
### Added
- Initial customer release
