# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Each version will have its own section containing a possible subset of the following subsections:
- Added: for new features.
- Changed: for changes in existing functionality.
- Deprecated: for soon-to-be removed features.
- Removed: for now removed features.
- Fixed: for any bug fixes.
- Security: in case of vulnerabilities.
- Errata: for known issues.

## 0.11.0
### Added
- View Menu -> Driver Debugger
    - Added live view of API commands that being executed while using TES.
- View Menu -> Power Monitoring
    - Improve accuracy of current and power readbacks.
- Configure tab -> Device Configuration
    - Add Setup ->  Custom mode. When this mode is selected, allow user to enter
        - Data Sample Rate
        - RF Channel Bandwidth
        - For Channel SSI:
            - SSI Type
            - Number of lanes
            - Data Rate
    - “Traffic lights” indicator informing user if selected configuration is valid

### Changed
- Minimum gain index raised from 187 to 195
- In TDD tab, enter TDD timing parameters in # of Samples
- Sample Code initialize code
    - Serializes data objects instead of using paths
    - Invokes initialization sequence explicitly (whereas previous versions called `adi_adrv9001Ee01_Initialize`)
- TES components
    - FPGA image from 0.6.7 to 0.6.7
    - Device Driver API from 18.8.10 to 20.9.2
    - Device Driver Client from 18.8.10 to 20.9.2
    - Firmware from 0.10.1.22 to 0.11.3.2
    - Profile Generator from 0.19.5.0 to 0.22.17
    - Stream Generator from 0.3.8.0 to 0.4.4.0
    - Transceiver Evaluation Software from 0.10.0 to 0.11.0
    - ADRV9001 Plugin from 0.10.0 to 0.11.0

### Errata
1. For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2. For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
3. Frame Boundary mode is not supported in Rx frequency offset correction.
4. Tx Baseband Analog Filter-Group Delay initialization calibration is not enabled by default.
5. Limitation with external delay measurement utilized by DPD.
    a. Measurement with LTE10 profiles is recommended to obtain the highest possible measurement accuracy
    b. Customer should only make the measurement upon Navassa entering CALIBRATED state for the first time
6. SPI control mode disabled; only Pin mode available
7. Power consumption level observed when in Calibrated State is not preserved when moving to Primed state and then back to Calibrated state. Issue is due to states of internal blocks that needs to be restored to exact settings. Issue will be addressed in following releases.
8. The Device Driver source contains APIs for frequency hopping; however, the firmware included does not enable this feature


## 0.10.0
### Added
- In File Menu
    - Button to over-write resources directory (File --> Force Update Platform) on SD card installed on ZYNQ FPGA platform
- View Menu -> Monitor Mode
    - Added Monitor Mode View
- Configure tab -> Device Configuration
    - Independent port operation in wide-band modes
    - Custom configuration #3
        - 42.666 MSPS, RF Bandwidth: 20 MHz
    - LTE profiles
        - 30.72 MSPS RF Bandwidth: 20 MHz
        - 7.68 MSPS RF Bandwidth: 5 MHz
        - 3.84 MSPS RF Bandwidth: 3 MHz
        - 1.92 MSPS RF Bandwidth: 1.4 MHz
- Configure tab -> Initialization
    - Add ability to provide arbitrary DEV_CLK (range from 10MHz to 300MHz).
        - Feature tested with frequencies available in 0.9.1 TES release. Other frequencies untested and should be treated as experimental.
    - Control of Processor Clock Divisor for Power Saving (no tracking cals with lower processor clock)
    - Explicit formula for computing Device Clock Output Frequency
    - Choice of Diversity (checked) or Independent (unchecked) LO configuration in Dual-Channel modes
    - Choice between Best Phase Noise or Best Power Consumption optimization for internal LO sources
    - Ability to disable/enable Rx Frequency Offset Correction
    - Ability to disable/enable Tx Frequency Offset Correction
    - Ability to enable optional 3 dB DAC full-scale power boost on Tx outputs
    - Initial settings for Monitor Mode
- Configure tab -> Filters
    - Capacity to upload custom channel filter coefficients
    - Scale factor is 2^23
- Transmit tab
    - Ability to control Tx Frequency Offset Correction
- Receive tab
    - Ability to control Baseband DC correction calibration
- GPIO tab
    - Rx Gain Index readout via GPIO pins
    - Add option for GPIO to control ARM power down mode
- Gain control tab
    - Re-enable Peak-and-Power detection mode for Gain Control
- System Power Savings and Monitor Mode tab
    - Add option for GPIO to control ARM power down mode (deep sleep)
    - Add interface to configure Monitor Mode operation
    - Add Monitor Mode Wakeup Pin
        - Assigned this Pin, will work in Monitor Mode ( periodical detection and sleep)
        - Unassigned this Pin, will work in System Power Saving mode (sleep only)
    - Add "Primed" state controls on System Power Savings and Monitor Mode tab
- TDD Enablement delays
    - Add measurement of internal path delay
- TDD tab
    - Add ability to load TDD configurations from drop-down selector
    - User can save and reload custom TDD timings
- Tracking Cals tab
    - Add FDD tracking calibrations (Rx/ORx QEC and Rx HD2)
- Auxiliary tab
    - Add interface to control Auxiliary ADCs / Auxiliary DACs


### Changed
- FPGA architecture implementation
- Custom1, Custom2 setups renamed to Configuration #1, Configuration #2
- Configuration #2 switched from SDR to DDR
- GPIO configurations moved to top bar
    - Can assign and reassign GPIO pins after programming
    - Can change Rx gain index control mode, Tx attenuation control mode, System Power Savings and Channel Power Savings configurations after programming
- Dual-channel profiles can now
    - Toggle all four channels' states independently (e.g. Rx1 in Calibrated, Rx2 in Primed, etc.)
    - Set all four channels' carrier frequencies independently except with FDD duplex
- DPD can now be enabled in LTE configurations (up to LTE20)
    - External loopback path delay information needs to be provided in the Board Configuration tab.
    - API ExternalPathDelay_Calibrate, and ExternalPathDelay_Get need to be called to get the external loopback path delay number in ns.
    - This is not required for Tetra DPD, but required for LTE DPD.
- Update display of Analog Power-Up and PLL Power-Up delays scaled with System Clock Frequency
- Enable Low Power Clock PLL to support most of available profiles (with exception of LTE40, 61.44MSPS).
- Fix issue with saving Rx files in Configuration #2 profile.
- TES components
    - FPGA image from 0.5.29 to 0.6.7
    - Device Driver API from 14.3.9 to 18.8.10
    - Device Driver Client from 14.3.9 to 18.8.10
    - Firmware from 0.9.2.16 to 0.10.1.22
    - Profile Generator from 0.18.4.0 to 0.19.5.0
    - Stream Generator from 0.3.6.0 to 0.3.8.0
    - Transceiver Evaluation Software from 0.9.1 to 0.10.0
    - ADRV9001 Plugin from 0.9.1 to 0.9.1


### Errata
1. For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2. For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
3. Frame Boundary mode is not supported in Rx frequency offset correction.
4. Tx Baseband Analog Filter-Group Delay initialization calibration is not enabled by default.
5. The Tx attenuation delay calibration is not yet supported
6. Limitation with external delay measurement utilized by DPD.
    - Measurement with LTE10 profiles is recommended to obtain the highest possible measurement accuracy
    - Customer should only make the measurement upon Navassa entering CALIBRATED state for the first time
7. Power savings mode transitions
8. Auto-generated MATLAB and Python code needs to be modified to work correctly.  See READMEs.
9. SPI control mode disabled; only Pin mode available

## 0.9.1
### Fixed
- TES MATLAB sample code correctly passes a .NET array to `fpga9001.dataChain.Data_Get`
- TES dependency management

### Changed:
- TES components:
    - Transceiver Evaluation Software from 0.9.0 to 0.9.1
    - ADRV9001 Plugin from 0.9.0 to 0.9.1


## 0.9.0
### Added
- In Board Configuration section of Configure tab, add External Path Delay option
- In Initialization section of Configure tab, change Compandor Size information to LUT Size and Pre-LUT Scale input parameters in Digital Pre-Distortion section.
- In GPIO Configuration section of Configure tab add
	- System Power Savings
	- Tx Attenuation Control
	- Channel Power Savings Control
- In Transmit and Receive tables add option to control DGPIO pin that can power down selected channel.
- New “Hibernated” state in the “View” -> “Radio State” window when operating in Single Channel mode.
- New tab called Attenuation Control enabling access to set and control Tx attenuations for each Tx channel
- New tab called TDD Enablement Delays to allow user interact with proposed power saving features per channel.
- Enable tone init calibration in wideband mode

### Changed
- Support only second revision of ADRV9002 silicon. SDK release SDK Release 0.8.1 is the last one that supports first ADRV9002 silicon revision.
- For Custom2 profile enable:
	- supports 40MHz DEV_CLK
	- support of CMOS 4-Lane SDR data port SSI mode
- In drop down menu code generation relocate from “File” menu to dedicated “Sample Code” menu.
- Update defaults for gain control minima and maxima values for Overload and Underload Thresholds.
- Update minimum gain index value from 183 to 187.  Default value from 255 to 247.
- TES components:
	- FPGA image from 0.4.15 to 0.4.29
	- Device Driver API from 11.0.2 to 14.3.7
	- Device Driver Client from 11.0.2 to 14.3.7
	- Firmware from 0.8.0.12 to 0.9.2.15
	- Profile Generator from 0.10.4.0 to 0.18.4.0
	- Stream Generator from 0.2.11.0 to 0.3.6.0
	- Transceiver Evaluation Software from 0.8.1 to 0.9.0
	- ADRV9001 Plugin from 0.8.4 to 0.9.0

### Errata
1.  For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2.  For TDD LTE and Custom1 profiles all Rx and Tx channels are enabled by default.
3.  When Automated TDD State Machine is chosen in the TDD tab, user can only choose either “TDD Enabled for Rx1” or “TDD Enabled for Tx1” as the predefined TDD structure. TX-Only or RX-Only framing is supported for DMR standard.
4.  For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
5.  Frame Boundary mode is not supported in Rx frequency offset correction.
6.	The Tx attenuation delay calibration is not yet supported
7.	The Peak-and-Power detection mode is not yet supported


## 0.8.0
### Added
- Radio State bidirectional user control under View menu
- 300Mhz Reference clock for DMR/Analog FM/Tetra profiles (only with High Performance Clock PLL)
- FDD support for
    - LTE Profile
    - Custom2 Profile
        - Rx I/Q, sample rate 936kSPS, bandwidth 7.813/31.25/62.5/156.25/312.5kHz
        - Tx I/Q, sample rate 936kSPS, bandwidth 7.813/31.25/62.5/156.25/312.5kHz
- Single Channel / Dual Channel user control (toggleable in FDD duplex LTE and Custom2 setups)
- Manual Control of Rx gain via selectable GPIO Pin
- Stream Generator version number displayed in dependency list

### Changed
- GPIO configuration tab
- Rename Custom setup to Custom1
- Setup control relocated from channel group to new Device group on Device Configuration pane
- AnalogFM setup in FDD duplex now has diagonal channels enabled (Rx2 and Tx1)
- IronPython editor and Power Monitoring view relocated to View menu
- Narrow-band setups default Clock PLL to Low Power and ADC Rate to Low; wide-band setups default to High for both Clock PLL and ADC Rate.
- Rx Capture Number of Samples now editable even while Transmit/Receiving
- Tx Attenuation does not change during Transmit until pressing Enter or losing focus on the input field
- Tracking calibration names improved for accuracy
- TES components:
    - FPGA image from 0.4.15 to 0.4.15
    - Device Driver API from 9.0.0 to 11.0.2
    - Device Driver Client from 9.0.0 to 11.0.2
    - Firmware from 0.7.1.9 to 0.8.0.11
    - Profile Generator from 0.9.14.0 to 0.10.4.0
    - Stream Generator from 0.2.8 to 0.2.11.0
    - Transceiver Evaluation Software from 0.7.0 to 0.8.1
    - ADRV9001 Plugin from 0.7.0 to 0.8.3

### Errata
1.  For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2.  For TDD LTE and Custom1 profiles all Rx and Tx channels are enabled by default.
3.  When Automated TDD State Machine is chosen in the TDD tab, user can only choose either “TDD Enabled for Rx1” or “TDD Enabled for Tx1” as the predefined TDD structure. TX-Only or RX-Only framing is supported for DMR standard.
4.  For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
5.  Frame Boundary mode is not supported in Rx frequency offset correction.


## 0.7.0
### Added
-   Digital Pre-Distortion
    - Dedicated page with DPD configuration details,
    - Board Configuration page with External Loopback configuration options
    - DPD polynomial terms selection in Initialization page
-   Tracking Calibrations page including:
    - Rx:
        - AGC,
        - Baseband DC offset,
        - 2nd Harmonic Distortion,
        - QEC Narrow Band
        - QEC Wideband
    - Tx:
        - DPD
        - LO Leakage
        - QEC
-   For DMR and Analog FM setups enable reception of Frequency Deviation signal type for Rx.
-   For DMR, TETRA  and Analog FM setups allow Single-channel operation (Rx-only or Tx-only).
-   Interface Gain:
    - Automatic Gain Control for Interface Gain
    - Expand Update modes to Now vs. Update Next Frame
    - Depending on profiles, allow Rx Gain + Interface Gain values from -36 dB to +18 dB
-   Include new sample data files for transmit in \Example folder
-   GPIO Configuration page with ability to map Gain Control Feedback signals to DGPIO pins
-   Allow MED and LOW ADC Rate for Rx Low Power ADCs
-   Ability to dynamically switch pFIR filter coefficients.

### Changed
-   Signal type for Tx1 and Tx2 (I/Q, I/Q FM/FSK, and Direct FM/FSK) relocated on Device Configuration pane
-   Programmable Intermediate Frequency (IF) now set for correct profiles
-   In Rx Gain Control pane change threshold levels to correct values.
-   Update internal configuring to correctly handle external LO at frequencies in range between 400MHz to 420MHz.
-   Modify stream binary generation and delivery when autogenerating C, MATLAB, or Python initialization codes.
-   Improve power consumption numbers for Rx and Tx active states.
-   Enhancements on Tx and Rx data path enable stages to avoid glitches and attenuated data section on Tx and Rx outputs.
-   In TDD pane change parameters values from clock cycles to micro/mili seconds
-   TES components:
    - FPGA image from 0.4.12 to 0.4.15
    - Device Driver API from 0.6.3 to 9.0.0
    - Device Driver Client from 0.6.3 to 9.0.0
    - Firmware from 0.6.1.3 to 0.7.1.9
    - Profile Generator from 0.7.8 to 0.9.14.0
    - Stream Generator from 0.2.3 to 0.2.8
    - Transceiver Evaluation Software from 0.6.1 to 0.7.0
    - ADRV9001 Plugin from 0.6.1 to 0.7.0

### Known issues and limitations with 0.7.0 TES release
1.  For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
2.  For LTE and Custom profiles all Rx and Tx channels are enabled by default.
3.  When Automated TDD State Machine is chosen in the TDD tab, user can only choose either “TDD Enabled for Rx1” or “TDD Enabled for Tx1” as the predefined TDD structure. TX-Only or RX-Only framing is supported for DMR standard.
4.  For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
5.  Frame Boundary mode is not supported in Rx frequency offset correction.
6.  "Manual SPI Control " Mode is not supported in this GUI release


## 0.6.1
### Added
-   Enable TDD interface
    - Provide pre-set configurations and control over frame duration.
    - Display information about frame, pin and data timing.
-   User-defined Intermediate Frequency for Rx in TETRA, DMR and AnalogFM systems.
    - Recommend range from 490K to 20M
-   Enable Clock PLL selection:
    - High performance
    - Low power (does not support LTE 61.44MSPS).
-   Duty Cycle Correction calibration (external LO only)
-   Enable selection of Rx ADC characteristics (rate and optimization mode)
    - Low power mode is only supported on ADC HIGH sample rate.
-   Peak and Power AGC mode.
-   Selection between Gain Compensation or Gain Correction mode.
-   Enable PLL re-tuning control
    - Provide capability to run Rx init cals, retune LO, then run Tx init cals

### Changed
-   Expand Rx Gain Control tab with diagrams and extra controls.
-   Enhancements to various init calibrations.
-   Increase capture duration limit on Rx to allow for collecting more samples in narrow-band profiles
-   Fix bug that would cause crash on PCs that never installed Microsoft's English language pack
-   Improve accuracy of power supply monitoring readouts.
-   TES components:
    - FPGA image from 0.4.6 to 0.4.12
    - Device Driver API from 0.5.3 to 0.6.5
    - Device Driver Client from 0.5.3 to 0.6.5
    - Firmware from 0.5.1.5 to 0.6.1.3
    - Profile Generator 0.7.8
    - Stream Generator 0.2.4
    - Transceiver Evaluation Software from 0.5.2 to 0.6.1
    - ADRV9001 Plugin from 0.5.2 to 0.6.2

### Errata
1.  For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
2.  For LTE and Custom profiles all Rx and Tx channels are enabled.
3.  In DMR and analogFM profiles, when the Rx sample rate is set as 48kSPS, 25kHz bandwidth is not supported.
4.  Frame Boundary mode is not supported in Rx frequency offset correction.
5.  DMR TDD framing supports only TX or RX but not both, user should not play RX while TX is enabled or vice versa
6.  TDD long capture length may cause GUI exception
7.  Code generation for MATLAB to initilize the part from a reset state doesn't work.  It can with a few modifications.


## 0.5.2
### Added
- Enable TDD interface
    - Provide pre-set configurations and control over frame duration.
    - Display information about frame, pin and data timing.
- User-defined Intermediate Frequency for Rx in TETRA, DMR and AnalogFM systems.
    - Recommend range from 490K to 20M
- Enable Clock PLL selection:
    - High performance
    - Low power (does not support LTE 61.44MSPS).
- Duty Cycle Correction calibration (external LO only)
- Enable selection of Rx ADC characteristics (rate and optimization mode)
    - Low power mode is only supported on ADC HIGH sample rate.
- Peak and Power AGC mode.
- Selection between Gain Compensation or Gain Correction mode.
- Enable PLL re-tuning control
    - Provide capability to run Rx init cals, retune LO, then run Tx init cals

### Changed
- Expand Rx Gain Control tab with diagrams and extra controls.
- Enhancements to various init calibrations.
- Increase capture duration limit on Rx to allow for collecting more samples in narrow-band profiles
- Fix bug that would cause crash on PCs that never installed Microsoft's English language pack
- Improve accuracy of power supply monitoring readouts.
- TES components:
    - FPGA image from 0.4.6 to 0.4.12
    - Device Driver API from 0.5.3 to 0.6.3
    - Device Driver Client from 0.5.3 to 0.6.3
    - Firmware from 0.5.1.5 to 0.6.1.3
    - Profile Generator 0.7.8
    - Stream Generator 0.2.3
    - Transceiver Evaluation Software from 0.5.2 to 0.6.1
    - ADRV9001 Plugin from 0.5.2 to 0.6.2

### Errata
1.  For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
2.  For LTE and Custom profiles all Rx and Tx channels are enabled.
3.  In DMR and analogFM profiles, when the Rx sample rate is set as 48kSPS, 25kHz bandwidth is not supported.
4.  Frame Boundary mode is not supported in Rx frequency offset correction.
5.  DMR TDD framing supports only TX or RX but not both, user should not play RX while TX is enabled or vice versa
6.  TDD long capture length may cause GUI exception


## 0.5.2
### Added
- FDD system setup
    - AnalogFM profile with configurable frequency deviation
    - Rx I/Q
        - 24kSPS, 12.5kHz RF BW
        - 48kSPS, 12.5kHz RF BW
    - Tx DM FM/FSK
        - 96kSPS, 12.5kHz RF BW
- TDM-FDD system setup with Tetra device setup
    - Rx I/Q
        - 144kSPS, 25kHz or 50kHz RF BW
    - Tx I/Q
        - 144kSPS, 25kHz or 50kHz RF BW
- Capability of tone generation in Transmit tab
    - Support both single tone and dual tone generation
    - Configurable tone amplitude, tone frequency and sample length
- Capability of transmitting all zeros in Transmit tab
- Live swap of Tx data while transmitting
- Rx frequency offset correction
    - Configurable correction mode (only immediate mode is supported in this release)
    - Configurable correction value (Hz)
- Power Monitoring table view in Transmit and Receive tabs

### Changed
- Minimal external LO divider is changed to 2x (instead 4x in the release V0.4.3)
- Removed the limitation of disabling Tx QEC initial calibration when LO<350MHz
- Continuous capture mode allows persistence of zoom
- Scroll bars are enabled in configuration panes even after part has been programmed
- Roll-your-own up-down arrows on Rx gain index in Receive pane
- TES components:
    - Device Driver API from 0.5.1 to 0.5.3
    - Device Driver Client from 0.5.1 to 0.5.3
    - Firmware from 0.4.4.4 to 0.5.1.5
    - Transceiver Evaluation Software from 0.4.3 to 0.5.2
    - ADRV9001 Plugin from 0.4.3 to 0.5.2

### Errata
- For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
- For LTE and Custom profiles all Rx and Tx channels are enabled.
- In DMR and analogFM profiles, when the Rx sample rate is set as 48kSPS, 25kHz bandwidth is not supported.
- Frame Boundary mode is not supported in Rx frequency offset correction.


## 0.4.1
### Added
- Analog FM profile:
    - Rx I/Q,
        - 24kSPS, 12.5kHz RF BW
        - 48kSPS, 12.5kHz or 25kHz RF BW
    - Tx I/Q FM/FSK or Direct FM/FSK
        - 96kSPS, 12.5kHz RF BW
    - Custom frequency deviation
- DMR profile:
    - Rx I/Q,
        - 48kSPS, 12.5kHz or 25kHz RF BW
    - Tx I/Q,
        - 48kSPS, 12.5kHz RF BW
    - Frequency deviation display for Tx I/Q FM/FSK and Tx Direct FM/FSK
    - Enable Tx External LO in DMR I/Q and DMR I/Q FM/FSK profiles.
- Custom profile:
    - Rx I/Q,
        - 20MSPS, 5.4 or 7.3 or 9.2MHz RF BW
    - Tx I/Q,
        - 40MSPS, 9.2MHz RF BW
- Device clock frequency:
    - 40MHz,
    - 49.152MHz
- Rx ADC configurability
    - Enable selection of High Performance or Low Power ADC used by Rx data path.
- Tx QEC init calibration
- Gain Compensation selection
    - Select between gain correction or gain compensation options
- Rx overview tab
    - Display main information related to selected profile
- Tx overview tab
    - Display main information related to selected profile
- Tx QEC init calibration
- Read back and display information on configuration of connected EVB hardware
    - Add warning messages when user attempts to operate hardware outside its bounds
- Generation of
    - JSON profile file
    - Initialization sequence in ANSI C that brings part into programmed state (experimental)
    - Initialization sequence in Python that brings part into programmed state (experimental)
    - Initialization sequence in MATLAB that brings part into programmed state (experimental)

### Changed
- General:
    - Introduce first take on power consumption optimization (disable unused blocks in analog section of ADRV9002). More power saving optimization is planned for future software releases.
    - Fix bug related to PC geographical settings (comma vs dot)
- In Receive tab,
    - Rearrange displayed information
- In Transmit tab,
    - Rearrange displayed information
- Enhance logging capabilities.
- TES components:
    - FPGA image from 0.3.8 to 0.4.6
    - Device Driver API from 0.3.7 to 0.5.1
    - Device Driver Client from 0.3.7 to 0.5.1
    - Firmware from 0.3.0.6 to 0.4.4.4
    - Transceiver Evaluation Software from 0.3.16 to 0.4.3
    - ADRV9001 Plugin from 0.3.20 to 0.4.3


### Errata
- The Tx QEC init calibration is automatically disabled when LO<350MHz.
- Minimal external LO divider set to 4x (instead 2x).
- For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
- For LTE and Custom profiles all Rx and Tx channels are enabled.
