# README.md
## ADRV9001 SDK Overview
This document is an overview of the structure and content of this SDK.
It is meant as a guide to help you find what you are looking for quickly and efficiently
so that you are successful evaluating, prototyping, and going to production with the ADRV9001
transceiver.  **ADRV9001** is a family name that is meant to represent all generic part numbers
in the family (e.g. _ADRV9002_, _ADRV9003_, etc.) and will be used throughout the documentation.

## Structure
The SDK is broken into the following folders:

### ./
- CHANGELOG.md - A general changelog for all versions of the SDK.
- LICENSE.md - Analog Devices' evaluation license.
- MANIFEST.md - A list of the key resources in the ADRV9001 software stack with their version.
- README.md - Overview of the SDK's structure and content.

### evaluation/
- adrv9002_transceiver_evaluation_software_setup.exe - The evaluation GUI is used to configure and evaluate
the ADRV9001 transceiver.  The GUI has the ability to initialize the part based on your configuration,
transmit and receive data vectors, and produce example C code used to help you transition from
evaluation to prototyping or production.
- CHANGELOG.md - A detailed changelog for the GUI.

### production/
- .git/ - This folder makes production/ a Git repo which will help manage device driver API source code updates over time.
- c_src/ - The device driver API source code for the ADRV9001.
- ADRV9001_API.chm - The device driver API doxygen documentation.
- compile_on_platform.py - A script to compile the device driver API source code on the ZC706SD20 platform.
- memory_profile.py - A script to profile the memory usage of the device driver API
- README.md - A detailed production/ document covering topics like versioning, Git, and building the source code.

### prototype/
- DLLs/ - Binaries used to configure and control the ADRV901 from the client host.
- platform/ - Platform HDL example projects and code to serve as a launching point for your own FPGA development
- matlab/ - M files you can use to initialize, and transmit/receive vectors within the MATLAB environment.
- python/ - Python files you can use to initialize, and transmit/receive vectors within an Python 2.7 environment.
- resources/ - Digital assets required for the proper operation of the ADRV9001 including firmware, FPGA images,
gain tables, and a device driver server.
- packages.adrv9001.config - A detailed list of every resource used in the ADRV9001 software stack.
- README.md - A detailed prototype/ document covering topics like workflows and the software stack.
