# Changelog
All notable changes to the SDK will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Each version will have its own section containing a possible subset of the following subsections:
- Added: for new features.
- Changed: for changes in existing functionality.
- Deprecated: for soon-to-be removed features.
- Removed: for now removed features.
- Fixed: for any bug fixes.
- Security: in case of vulnerabilities.
- Errata: for known issues.

## 0.11.0
### Added
- New features for TES 0.10.0
    - Driver Debugger
    - Improved accuracy of current and power readbacks.
    - Device Configuration -> Add Setup ->  Custom mode

### Changed
- TDD interface improvements


## 0.10.0
### Added
- New features for TES 0.10.0
    - New profiles
    - Monitor mode for DMR
    - Aribitrary device clock input
    - Ability to supply custom channel filters
    - Auxilary DAC and ADC control
    - DPD in wideband operation

### Changed
- prototype/fpga/ changed to prototype/platform/
    - platform/ includes the entire HDL project, along with the ADRV9001 interface IP core. You
    may now regenerate the FPGA binaries using these sources for use with the GUI application.
    The build requires appropriate vendor tools and licensing.

### Removed
- Example code for MATLAB and Python


## 0.9.1
### Fixed
- TES MATLAB sample code correctly passes a .NET array to `fpga9001.dataChain.Data_Get`
    - Added snippet code to MATLAB `README.md`
- TES dependency management

### Errata
- Example Python and MATLAB code does not work as packaged


## 0.9.0
### Added
- New features for TES 0.9.0
    -   Power savings capabilities
        -   System
        -   Channel
        -   Hibernation
    -   New TDD channel enablement timing control
    -   New Digital pre-distortion settings
    -   Improved code generation


## 0.8.0
### Added
- New features for TES 0.8.1
    -   FDD support for LTE and Custom2 setups
    -   Single Channel / Dual Channel user control
    -   Manual Control of Rx gain via GPIO Pin
    -   Radio State bidirectional user control


## 0.7.1
### Fixed
- Device driver code compiles


## 0.7.0
### Added
- New features for TES 0.7.0
    - DPD and External Loopback
    - Tracking calibrations
    - Frequency deviation for narrowband receive
    - Independent channel operation (to highlight power savings)
    - AGC GPIO
    - Low and Medium speed ADC support


## 0.6.2
### Added
- New features for TES 0.6.1
    - Basic TDD demonstration capabilities
    - Automated sandwich maker
- New memory_profile.py script to profile Device Driver API memory usage.
- FPGA HDL code to demonstrate an implementation of the Synchronous Serial Interface (SSI)
- Stream processor operation

### Changed
- License agreement updated
- Device Driver API memory improvements
    - Compiled size is around 62 kB
    - No more heap allocations
    - No more usage of floats
    - Compiles with stricter compiler settings


## 0.5.0
### Added
- New features for TES 0.5.2
    - New systems (e.g. TDM-FDD, FDD)
    - New setups (e.g. Tetra)
    - Tone generation
    - Power monitoring
- Minor usability improvements for Python and MATLAB code


## 0.4.0 - Initial SDK Release
### Added
- New configuration options with TES 0.4.3 (e.g. DMR 48k, Analog FM, Custom)
- Device Driver source code
- Workflow ability to create C code from TES and build with device driver source
- Workflow ability to create Python and MATLAB code


