Attribute VB_Name = "modSound"
'*******************************************************
'* Sound Module                                        *
'*******************************************************
'* Purpose:                                            *
'* Allows the user to play wave files.                 *
'*                                                     *
'* Functions:                                          *
'* sndSoundCardInstalled - Returns true or false       *
'* sndWAVLoop - Loops a wave file seamlessly until     *
'*               sndWaveStop is called.                *
'* sndWAVPlay - Plays a wave file                      *
'* sndWAVStop - Stops playing a wave file              *
'* sndPlaySysSnd - Plays wave files or system sounds   *
'*                 use Constants for system sounds     *
'* sndInitSound - Initializes the module, must be      *
'*                called first.                        *
'*******************************************************
'* Revision 1.1                                        *
'*******************************************************

Private Declare Function mciExecute Lib "winmm.dll" (ByVal lpstrCommand As String) As Long

Public Const SND_SYNC = &H0

Public Const SND_ASYNC = &H1
Public Const SND_NODEFAULT = &H2
Public Const SND_MEMORY = &H4
Public Const SND_LOOP = &H8
Public Const SND_NOSTOP = &H10

Public Declare Function sndPlaySound Lib "winmm.dll" Alias "sndPlaySoundA" (ByVal lpszSoundName As String, ByVal uFlags As Long) As Long
Public Declare Function PlaySound Lib "winmm.dll" Alias "PlaySoundA" (ByVal lpszName As String, ByVal hModule As Long, ByVal dwFlags As Long) As Long
Public Declare Function waveOutGetNumDevs Lib "winmm.dll" () As Long

Public Const sndSysAsterisk = "SystemAsterisk"
Public Const sndSysDefaultBeep = "Default"
Public Const sndSysExclamation = "SystemExclamation"
Public Const sndSysEmptyRecycleBin = "EmptyRecycleBin"
Public Const sndSysSystemExit = "SystemExit"
Public Const sndSysMaximize = "Maximize"
Public Const sndSysMenuCommand = "MenuCommand"
Public Const sndSysMenuPopup = "MenuPopup"
Public Const sndSysMinimize = "Minimize"
Public Const sndSysMailBeep = "MailBeep"
Public Const sndSysOpenApp = "Open"
Public Const sndSysCriticalStop = "SystemHand"
Public Const sndSysAppGPFault = "AppGPFault"
Public Const sndSysQuestion = "SystemQuestion"
Public Const sndSysRestoreDn = "RestoreDown"
Public Const sndSysRestoreUp = "RestoreUp"
Public Const sndSysSystemStart = "SystemStart"
Public Const sndSysCloseApp = "Close"
Public Const sndSysSendFax = "RingOut"
Public Const sndSysIncomingFax = "RingIn"

Public sndSoundCardFound As Boolean

Sub sndWAVStop()

    Call sndWAVPlay(" ")
End Sub


Sub sndWAVLoop(file)

    Dim SoundName As String
    SoundName$ = file
    wFlags% = SND_ASYNC Or SND_LOOP
    x = sndPlaySound(SoundName$, wFlags%)
End Sub


Sub sndWAVPlay(file)

    Dim SoundName As String
    SoundName$ = file
    wFlags% = SND_ASYNC Or SND_NODEFAULT
    x = sndPlaySound(SoundName$, wFlags%)
End Sub

Public Function sndSoundCardInstalled() As Boolean

    Dim lng As Long
    lng = waveOutGetNumDevs()
     

    If lng > 0 Then
        sndSoundCardInstalled = True
        Exit Function
    Else
        sndSoundCardInstalled = False
        Exit Function
    End If

End Function

'Public Sub sndPlayAudioFile(ByVal Filename As String)
'    Dim a As String
'    a = "play " & Filename
'    mciExecute a
'End Sub
'
'Public Sub sndStopAudioFile(ByVal Filename As String)
'    Dim a As String
'    a = "stop " & Filename
'    mciExecute a
'End Sub
'
'Public Sub sndPauseAudioFile(ByVal Filename As String)
'    Dim a As String
'    a = "pause " & Filename
'    mciExecute a
'End Sub
Public Sub sndPlaySysSound(ByVal SysSound As String)
    PlaySound SysSound, 0&, SND_ASYNC
End Sub

Public Sub sndInitSound()
    'Initialize the sound card found global variable
    sndSoundCardFound = sndSoundCardInstalled()
End Sub
