Attribute VB_Name = "modNumBase"
Option Explicit
'Converts a Decimal number to a binary string
'Note - Converts floating point numbers to integer values
'Handles negative numbers by creating a 2's Compliment
'binary  string
Public Function cbaseDec2Bin(ByVal Number As Variant, ByVal numbits As Integer) As String
    Dim cntr As Integer
    Dim TempVal As Variant
    Dim Remainder As Variant
    Dim NumNeg As Boolean
    TempVal = CDec(Number)
    Remainder = CDec(0)
       
    If Number < 0 Then
        NumNeg = True
        'Make positive
        TempVal = Abs(TempVal)
        'Add one to make it 2's compliment
        TempVal = TempVal - 1
    Else
        NumNeg = False
    End If
                    
    For cntr = 0 To 95
        Remainder = DecMod(TempVal, 2)
        TempVal = TempVal / 2
        TempVal = DecFix(TempVal)
        If Remainder = 1 Then
            'If the number was negative then insert a "0" else insert a "1"
            If NumNeg = True Then
                cbaseDec2Bin = "0" & cbaseDec2Bin
            Else
                cbaseDec2Bin = "1" & cbaseDec2Bin
            End If
        Else
            'If the number was negative then insert a "1" else insert a "0"
            If NumNeg = True Then
                cbaseDec2Bin = "1" & cbaseDec2Bin
            Else
                cbaseDec2Bin = "0" & cbaseDec2Bin
            End If
        End If
    Next
    
    'Trim the output string  to the number of bits specified
    cbaseDec2Bin = Right(cbaseDec2Bin, numbits)
    
End Function
Function cbaseDec2Hex(ByVal Number As Variant, ByVal NumDigits As Integer) As String
    Dim cntr As Integer
    Dim TempVal As Variant
    Dim Remainder As Variant
    Dim NumNeg As Boolean

    Remainder = CDec(0)
    TempVal = CDec(Number)
    
    For cntr = 0 To 24
        'Divide and get the remainder
        Remainder = DecMod(TempVal, 16)
        'Truncate the remainder
        TempVal = DecFix(TempVal / 16)
        
        'Add in the hex remainder to the return string
        cbaseDec2Hex = Hex(Remainder) & cbaseDec2Hex
    Next cntr
    
    'Make sure you return the right number of digits
    If NumDigits <= Len(cbaseDec2Hex) Then
        cbaseDec2Hex = Right(cbaseDec2Hex, NumDigits)
    Else
        cbaseDec2Hex = String(NumDigits - Len(cbaseDec2Hex), "0") & cbaseDec2Hex
    End If
End Function

'Converts a Decimal number to a binary string
'Note - Converts floating point numbers to integer values
'Public Function cbaseDec2Bin1(ByVal Number As Variant, ByVal numbits As Integer) As String
'    Dim cntr As Integer
'    Dim TempDec As Variant
'    Dim iBitVal As Integer
'    TempDec = CDec(0)
'
'    If Not IsNumeric(Number) Then
'        'Raise an error
'        Err.Raise 5, "cbaseDec2Bin()", "Invalid Parameter: Number can only be a whole number no fractional numbers."
'    Else
'        'Truncate the fractional part of number off
'        TempDec = DecFix(Number)
'
'        'Convert the value to a binary string
'        For cntr = numbits - 1 To 0 Step -1
'            'Get the first bit value
'            iBitVal = DecFix(TempDec / 2 ^ cntr)
'            'Check the string value of the bit to the output string
'            If iBitVal = 1 Then
'                cbaseDec2Bin = cbaseDec2Bin & "1"
'                'Trim off the bit checked
'                TempDec = TempDec - (2 ^ cntr)
'            Else
'                cbaseDec2Bin = cbaseDec2Bin & "0"
'            End If
'        Next cntr
'        'The return string has been assembled
'    End If
'End Function
'02/08/00 - Replaced "." with "GetDecSeperator(False)" for internationalization
'Truncates the fractional portion off of a decimal value
Public Function DecFix(ByVal Number As Variant) As Variant
    Dim ConvertStr As String
    Dim DecSepLoc As Integer
    Dim StrVal As String
    
    'Get the string value of the number
    StrVal = CStr(Number)
    
    'Get the decimal
    DecSepLoc = InStr(1, StrVal, GetDecSeparator(False))
    
    If DecSepLoc And (DecSepLoc <> Len(StrVal)) And DecSepLoc <> 1 Then
        'Truncate the fractional part of the number
        ConvertStr = Left(StrVal, DecSepLoc - 1)
    Else
        If DecSepLoc = 1 Then
            ConvertStr = "0"
        Else
            ConvertStr = CStr(Number)
        End If
    End If
    
    'If for some odd reason convertstr is "" then return 0
    If ConvertStr = "" Then
        ConvertStr = "0"
    End If
    
    'Return the truncated value
    DecFix = CDec(ConvertStr)
End Function
'Converts a binary string into a decimal value
Public Function cbaseBinS2Dec(ByVal BinStr As String) As Variant
    Dim BSLen As Integer
    Dim retval As Variant
    Dim cntr As Integer
    Dim ChrPtr As Integer
    
    If Len(BinStr) > 111 And IsNumeric(BinStr) Then
        'Error
        Err.Raise 5, "cbaseBinS2Dec()", "To many bits: Can only convert 111 bit string!!!"
    Else
        'Get the length of the string
        BSLen = Len(BinStr)
        
        'Initailize retval as a decimal value
        retval = CDec(0)
        
        'Inirialize the charater ptr
        ChrPtr = BSLen
        
        'Convert then string
        For cntr = 0 To BSLen - 1
            
            'If the character is a "1" then add the bit
            If Mid(BinStr, ChrPtr, 1) = "1" Then
                retval = retval + 2 ^ cntr
            End If
            
            'Decrement the character pointer
            ChrPtr = ChrPtr - 1
        Next cntr
        
        cbaseBinS2Dec = CDec(retval)
    End If
End Function
'Converts a binary string into a decimal value
Public Function cbaseSignedBinS2Dec(ByVal BinStr As String) As Variant
    Dim BSLen As Integer
    Dim retval As Variant
    Dim cntr As Integer
    Dim ChrPtr As Integer
    Dim isNeg As Boolean
    
    If Len(BinStr) > 111 And IsNumeric(BinStr) Then
        'Error
        Err.Raise 5, "cbaseBinS2Dec()", "To many bits: Can only convert 111 bit string!!!"
    Else
        'Check to see if it is negative
        If Left(BinStr, 1) = "1" Then
            isNeg = True
        End If
    
        If isNeg = False Then
            'If it wasn't negative then convert normaly
            retval = cbaseBinS2Dec(BinStr)
        Else
            'Compliment the binary string and convert normaly
            BinStr = ComplBinStr(BinStr)
            retval = cbaseBinS2Dec(BinStr)
            'Subtract 1 to get the correct answer
            retval = (retval + 1) * -1
        End If
        
        'Return the calculated value
        cbaseSignedBinS2Dec = retval
    End If
End Function

'Converts a decimal value to a hex string
'Inputs
'   Num - Number to be converted
'   DigitsToDisplay - Number of digits to display
Public Function cbaseHex(ByVal num As Variant, Optional ByVal DigitsToDisplay As Integer = 0) As String
    Dim Digits2Add As Integer
    Const MaxLongVal = 2147483647
'    Dim iCntr As Integer
'    Dim iNibble As Integer
'    Dim sNibble As Integer
    Dim dCNum As Variant
    dCNum = CDec(0)
    
    If IsNumeric(num) Then
        'Convert the value to hex
'        cbaseHex = Hex(DecFix(Num))
        dCNum = num
        Do
            'Convert the first nibble to hex
            cbaseHex = Hex(DecMod(dCNum, 16)) & cbaseHex
            'Remove the first nibble from the value
            dCNum = DecFix(dCNum / 16)
        Loop While dCNum <> 0
        
        
        'Add on any leading 0's that are needed
        If DigitsToDisplay > Len(cbaseHex) Then
            'Calculate the digits to add
            Digits2Add = DigitsToDisplay - Len(cbaseHex)
            'Add the missing digits to the output string
            cbaseHex = String(Digits2Add, 48) & cbaseHex
        End If
    Else
        'Error
        Err.Raise 5, "cbaseHex()", "Num can only be a numeric value."
        Exit Function
    End If
End Function

'Converts a hex string into a decimal value properly
Public Function cbaseHexStr2Dec(ByVal HexStr As String) As Variant
    Dim cntr As Integer
    Dim sNibble As String
    Dim iNibble As Integer
    Dim retval As Variant
    
    retval = CDec(0)
    
    'Initialize nibble as a decimal value
'    Nibble = 0
    
    'Loop through all of the nibbles
    For cntr = 0 To Len(HexStr) - 1
        'Get the first nibble
        sNibble = Right(HexStr, 1)
        'Trimm off the LSN
        HexStr = Left(HexStr, Len(HexStr) - 1)
        
        'Check the current character to see if it is a valid character
        Select Case Asc(sNibble)
            Case 48 To 57
            Case 65 To 70
            Case 97 To 102
            Case Else
                'If not raise an error and exit the function
                Err.Raise 13, "cbaseHexStr2Dec()", "Type mismatch - Invalid input string."
                Exit Function
        End Select
        
        'Convert the nibble to an integer
        iNibble = CInt("&h" & sNibble)
        If cntr = 0 Then
            'Add the LSN
            retval = iNibble
        Else
            'Add up the nibbles
            retval = retval + (iNibble * (16 ^ cntr))
        End If
    Next cntr
    
    'Return the calcualted integer value
    cbaseHexStr2Dec = retval
End Function
'Performs the modulos function on Decimal values
'divides Num by Divisor and returns the remainder
Public Function DecMod(ByVal num As Variant, ByVal Divisor As Variant) As Variant
    Dim TempVal As Variant
    'Initialize as a decimal value
    TempVal = CDec(0)
    
    'Do the division
    TempVal = num / Divisor
    
    'Calculate the remainder
    DecMod = (TempVal - DecFix(TempVal)) * Divisor
End Function

'Returns the decimal seperator in either ascii code or
'the character
Private Function GetDecSeparator(ByVal RetAsciiCode As Boolean) As Variant
    If RetAsciiCode Then
        GetDecSeparator = Asc(Mid(Format(0, "Fixed"), 2, 1))
    Else
        GetDecSeparator = Mid(Format(0, "Fixed"), 2, 1)
    End If
End Function

'Compliments a binary string
'Used to display the Frequency Step Word in 2's Compliment
Public Function ComplBinStr(ByVal BinStr) As String
    Dim cntr As Integer
    Dim NewStr As String
    
    For cntr = 1 To Len(BinStr)
        If Mid(BinStr, cntr, 1) = "1" Then
            NewStr = NewStr & "0"
        Else
            NewStr = NewStr & "1"
        End If
    Next
    
    ComplBinStr = NewStr
End Function
'Converts decimal values to hexstring and properly handles negative values
Public Function cbaseSignedDec2Hex(ByVal num As Variant, Optional ByVal DigitsToDisplay As Integer = 0) As String
    Dim cntr As Integer
    Dim HexStr As String
    Dim BinStr As String
    Dim LookUP(0 To 16) As String
    Dim cntr1 As Integer
    Dim BinDigitStr As String
    
    'Initialize the lookup table
    LookUP(0) = "0000"
    LookUP(1) = "0001"
    LookUP(2) = "0010"
    LookUP(3) = "0011"
    LookUP(4) = "0100"
    LookUP(5) = "0101"
    LookUP(6) = "0110"
    LookUP(7) = "0111"
    LookUP(8) = "1000"
    LookUP(9) = "1001"
    LookUP(10) = "1010"
    LookUP(11) = "1011"
    LookUP(12) = "1100"
    LookUP(13) = "1101"
    LookUP(14) = "1110"
    LookUP(15) = "1111"
    LookUP(16) = "ERRR"
    
    'First convert the decimal number to a binary string
    BinStr = cbaseDec2Bin(num, DigitsToDisplay * 4)
    
    'Loop through the binary string and convert it digit by digit
    For cntr = 1 To DigitsToDisplay
        'Get the binary value for the first digit
        BinDigitStr = Right(BinStr, 4)
        'Trim off the bits
        BinStr = Left(BinStr, (DigitsToDisplay - cntr) * 4)
        'Scan through the lookup table and find the matching value
        For cntr1 = 0 To 16
            If LookUP(cntr1) = BinDigitStr Then
                'Found it
                Exit For
            End If
        Next cntr1
        'Check and make sure that the digit was found in the lookup table
        If cntr1 <> 16 Then
            'Build the hex string
            HexStr = Hex(cntr1) & HexStr
        Else
            MsgBox "Error: Couldn't find digit in lookup table.", vbCritical, "Function cbaseDec2HexNegs()"
        End If
    Next cntr
    'Return the value found
    cbaseSignedDec2Hex = HexStr
End Function
'Converts a hex string into a decimal value properly
Public Function cbaseSignedHex2Dec(ByVal HexStr As String) As Variant
    Dim cntr As Integer
    Dim sNibble As String
    Dim iNibble As Integer
    Dim retval As Variant
    Dim BinStr As String
    
    retval = CDec(0)
    
    'Loop through all of the nibbles and build a binary string
    For cntr = 0 To Len(HexStr) - 1
        'Get the first nibble
        sNibble = Right(HexStr, 1)
        'Trimm off the LSN
        HexStr = Left(HexStr, Len(HexStr) - 1)
        
        'Check the current character to see if it is a valid character
        Select Case Asc(sNibble)
            Case 48 To 57
            Case 65 To 70
            Case 97 To 102
            Case Else
                'If not raise an error and exit the function
                Err.Raise 13, "cbaseHexStr2Dec()", "Type mismatch - Invalid input string."
                Exit Function
        End Select
        
        'Convert the nibble to an integer
        iNibble = CInt("&h" & sNibble)
        
        'Convert the nibble to a binary string
        BinStr = cbaseDec2Bin(iNibble, 4) & BinStr
        
    Next cntr
    
    'Convert the binary string to a decimal value
    retval = cbaseSignedBinS2Dec(BinStr)
    
    'Return the calcualted integer value
    cbaseSignedHex2Dec = retval
End Function

'Pass it a binary string and it will return a hex string
Public Function cbaseBinStr2Hex(ByVal BinStr As String, ByVal HexLen As Integer) As String
    Dim RetStr As String
    Dim BinaryString As String
    Dim cntr As Integer
    Dim NumOfNibbles As Integer
    Dim BinStrLen As Integer
    Dim CurNibble As String
    
    'Get the length of the input string
    BinStrLen = Len(BinStr)
    
    'Check to see if the number of nibles are
    If BinStrLen Mod 4 <> 0 Then
        'Get the number of nibbles
        NumOfNibbles = Fix(BinStrLen / 4)
        'Add in leading 0's until the string is
        BinStr = String(((NumOfNibbles + 1) * 4) - BinStrLen, "0") & BinStr
        NumOfNibbles = NumOfNibbles + 1
    Else
        NumOfNibbles = BinStrLen / 4
    End If
    
    For cntr = 0 To NumOfNibbles - 1
        'Get the current Nibble
        CurNibble = Mid(BinStr, ((cntr * 4) + 1), 4)
        Select Case CurNibble
            Case "0000"
                RetStr = RetStr & "0"
            Case "0001"
                RetStr = RetStr & "1"
            Case "0010"
                RetStr = RetStr & "2"
            Case "0011"
                RetStr = RetStr & "3"
            Case "0100"
                RetStr = RetStr & "4"
            Case "0101"
                RetStr = RetStr & "5"
            Case "0110"
                RetStr = RetStr & "6"
            Case "0111"
                RetStr = RetStr & "7"
            Case "1000"
                RetStr = RetStr & "8"
            Case "1001"
                RetStr = RetStr & "9"
            Case "1010"
                RetStr = RetStr & "A"
            Case "1011"
                RetStr = RetStr & "B"
            Case "1100"
                RetStr = RetStr & "C"
            Case "1101"
                RetStr = RetStr & "D"
            Case "1110"
                RetStr = RetStr & "E"
            Case "1111"
                RetStr = RetStr & "F"
            Case Else
                'Error has occured
                MsgBox "Error: and invalid value was passed. Only binary strings can be passed to this function.", vbCritical + vbOKOnly, "cbaseBinStr2Hex: Type Missmatch"
        End Select
    Next cntr
    
    'Fix the output string to be the correct number of digits
    RetStr = String(HexLen - Len(RetStr), "0") & RetStr
    
    cbaseBinStr2Hex = RetStr
End Function
'Converts a decimal value to a hex string
'Inputs
'   Num - Number to be converted
'   DigitsToDisplay - Number of digits to display
Public Function cbaseHexStr(ByVal num As Variant, Optional ByVal DigitsToDisplay As Integer = 0) As String
    Dim Digits2Add As Integer
    Const MaxLongVal = 2147483647
'    Dim iCntr As Integer
'    Dim iNibble As Integer
'    Dim sNibble As Integer
    Dim dCNum As Variant
    dCNum = CDec(0)
    
    If IsNumeric(num) Then
        'Convert the value to hex
'        cbaseHex = Hex(DecFix(Num))
        dCNum = num
        Do
            'Convert the first nibble to hex
            cbaseHexStr = Hex(DecMod(dCNum, 16)) & cbaseHexStr
            'Remove the first nibble from the value
            dCNum = DecFix(dCNum / 16)
        Loop While dCNum <> 0
        
        
        'Add on any leading 0's that are needed
        If DigitsToDisplay > Len(cbaseHexStr) Then
            'Calculate the digits to add
            Digits2Add = DigitsToDisplay - Len(cbaseHexStr)
            'Add the missing digits to the output string
            cbaseHexStr = String(Digits2Add, 48) & cbaseHexStr
        End If
    Else
        'Error
        Err.Raise 5, "cbaseHexStr()", "Num can only be a numeric value."
        Exit Function
    End If
End Function

