Attribute VB_Name = "modEZUSB"
'Define constants
Public Const MAX_PIPES = 16

Public Const EZUSB_DevName = "Ezusb"
Public Const EZSSP_DevName = "Ezssp"

Public Enum EZUSB_PipeEnum
    eUsbdPipeTypeControl = 0
    eUsbdPipeTypeIsochronous
    eUsbdPipeTypeBulk
    eUsbdPipeTypeInterrupt
End Enum

Public Type GetStringDescriptorIn
    Index As Byte
    LanguageId As Integer
End Type

Public Type VENDOR_OR_CLASS_REQUEST_CONTROL
'   // transfer direction (0=host to device, 1=device to host)
   bDirection As Byte
'   // request type (1=class, 2=vendor)
   bRequestType As Byte
'   // recipient (0=device,1=interface,2=endpoint,3=other)
   bRecepient As Byte
'   //
'   // see the USB Specification for an explanation of the
'   // following paramaters.
'   //
   bRequestTypeReservedBits As Byte
   bRequest As Byte
   fill As Byte
   uiValue As Integer
   uiIndex As Integer
End Type

Public Type EZUSB_DeviceDescriptorType
    bDescriptorLength As Byte
    bDescriptor As Byte
    iSpecRelease As Integer
    bDeviceClass As Byte
    bDeviceSubClass As Byte
    bDeviceProtocol As Byte
    bMaxPacketSize As Byte
    iVendorID As Integer
    iProductID As Integer
    iDeviceRelease As Integer
    bManufacturer As Byte
    bProduct As Byte
    bSerialNumber As Byte
    bNumberConfigurations As Byte
    fill(128) As Byte
End Type

Public Type EZUSB_BulkTransferControlType
    lPipeNum As Long
End Type

Public Type EZUSB_PipeInformationType
    ' OUTPUT
    ' These fields are filled in by USBD
    '
    iMaximumPacketSize As Integer 'Maximum packet size for this pipe
    bEndpointAddress As Byte      ' 8 bit USB endpoint address (includes direction)
                                  ' taken from endpoint descriptor
    bInterval As Byte             ' Polling interval in ms if interrupt pipe
    
    PipeType As EZUSB_PipeEnum     ' PipeType identifies type of transfer valid for this pipe
    lPipeHandle As Long
    
    '
    ' INPUT
    ' These fields are filled in by the client driver
    '
    lMaximumTransferSize As Long  ' Maximum size for a single request
                                 ' in bytes.
    lPipeFlags As Long
End Type

Public Type EZUSB_InterfaceInformationType
    iLength As Integer   ' Length of this structure, including
                         ' all pipe information structures that
                         ' follow.
    '
    ' INPUT
    '
    ' Interface number and Alternate setting this
    ' structure is associated with
    '
    bInterfaceNumber As Byte
    bAlternateSetting As Byte
    
    '
    ' OUTPUT
    ' These fields are filled in by USBD
    
    bClass As Byte
    bSubClass As Byte
    bProtocol As Byte
    bReserved As Byte
    
    lInterfaceHandle As Long
    lNumberOfPipes As Long

    Pipes(MAX_PIPES) As EZUSB_PipeInformationType
End Type

