VERSION 5.00
Begin VB.MDIForm mdiMain 
   BackColor       =   &H8000000C&
   Caption         =   "AD9911 Evaluation Software"
   ClientHeight    =   6885
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   9750
   Icon            =   "mdiMain.frx":0000
   LinkTopic       =   "MDIForm1"
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.PictureBox pbxToolBar 
      Align           =   1  'Align Top
      BorderStyle     =   0  'None
      Height          =   615
      Left            =   0
      ScaleHeight     =   41
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   650
      TabIndex        =   1
      Top             =   0
      Width           =   9750
      Begin VB.CommandButton cmdManualIOUpdate 
         Caption         =   "Manual I/O Update"
         Height          =   285
         Left            =   2130
         Style           =   1  'Graphical
         TabIndex        =   13
         ToolTipText     =   "Send I/O Update"
         Top             =   300
         Width           =   1575
      End
      Begin VB.CheckBox chkAutoIOUpdate 
         Caption         =   "Auto I/O Update"
         Height          =   255
         Left            =   2130
         TabIndex        =   12
         ToolTipText     =   "Enable/Disable - Auto IO Update"
         Top             =   30
         Width           =   1575
      End
      Begin VB.CommandButton Command4 
         Height          =   495
         Left            =   5010
         Picture         =   "mdiMain.frx":0442
         Style           =   1  'Graphical
         TabIndex        =   11
         ToolTipText     =   "Channel Output Config Window"
         Top             =   60
         Width           =   495
      End
      Begin VB.CommandButton cmdChannelControl 
         Height          =   495
         Left            =   4470
         Picture         =   "mdiMain.frx":058C
         Style           =   1  'Graphical
         TabIndex        =   10
         ToolTipText     =   "Channel Control Window"
         Top             =   60
         Width           =   495
      End
      Begin VB.CommandButton cmdControlWindow 
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   6
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   3930
         Picture         =   "mdiMain.frx":06D6
         Style           =   1  'Graphical
         TabIndex        =   9
         ToolTipText     =   "Chip Level Control Window"
         Top             =   60
         Width           =   495
      End
      Begin VB.CommandButton cmdReset 
         DownPicture     =   "mdiMain.frx":0820
         Height          =   530
         Left            =   1275
         Picture         =   "mdiMain.frx":0BA2
         Style           =   1  'Graphical
         TabIndex        =   8
         ToolTipText     =   "Master Reset"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   780
      End
      Begin VB.CommandButton cmdSaveSetup 
         Height          =   495
         Left            =   600
         Picture         =   "mdiMain.frx":0F24
         Style           =   1  'Graphical
         TabIndex        =   3
         ToolTipText     =   "Save Setup File"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   495
      End
      Begin VB.CommandButton cmdOpenSetup 
         Height          =   495
         Left            =   60
         Picture         =   "mdiMain.frx":158E
         Style           =   1  'Graphical
         TabIndex        =   2
         ToolTipText     =   "Load Setup File"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   495
      End
      Begin VB.Line lneToolBarSepHi 
         BorderColor     =   &H80000014&
         Index           =   1
         X1              =   254
         X2              =   254
         Y1              =   2
         Y2              =   41
      End
      Begin VB.Line lneToolBarSepHi 
         BorderColor     =   &H80000014&
         Index           =   0
         X1              =   80
         X2              =   80
         Y1              =   1
         Y2              =   41
      End
      Begin VB.Line lneToolBarSepSh 
         BorderColor     =   &H80000010&
         BorderWidth     =   2
         Index           =   0
         X1              =   80
         X2              =   80
         Y1              =   2
         Y2              =   40
      End
      Begin VB.Line lneMainMenuSep 
         BorderColor     =   &H80000014&
         Index           =   1
         X1              =   0
         X2              =   592
         Y1              =   1
         Y2              =   1
      End
      Begin VB.Line lneMainMenuSep 
         BorderColor     =   &H80000010&
         Index           =   0
         X1              =   0
         X2              =   592
         Y1              =   0
         Y2              =   0
      End
      Begin VB.Line lneToolBarSepSh 
         BorderColor     =   &H80000010&
         BorderWidth     =   2
         Index           =   1
         X1              =   254
         X2              =   254
         Y1              =   2
         Y2              =   40
      End
   End
   Begin VB.Timer tmrLoadFlash 
      Enabled         =   0   'False
      Interval        =   300
      Left            =   120
      Top             =   720
   End
   Begin VB.PictureBox pbxStatusBar 
      Align           =   2  'Align Bottom
      BorderStyle     =   0  'None
      Height          =   315
      Left            =   0
      ScaleHeight     =   315
      ScaleWidth      =   9750
      TabIndex        =   0
      Top             =   6570
      Width           =   9750
      Begin VB.PictureBox pbxProgress 
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   6480
         ScaleHeight     =   285
         ScaleWidth      =   3135
         TabIndex        =   14
         Top             =   15
         Width           =   3135
      End
      Begin VB.Image imgResizer 
         Height          =   240
         Left            =   10800
         MousePointer    =   8  'Size NW SE
         Picture         =   "mdiMain.frx":1BF8
         Stretch         =   -1  'True
         Top             =   0
         Width           =   240
      End
      Begin VB.Label lblDUTID 
         Alignment       =   2  'Center
         BackColor       =   &H00004000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "NONE"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FF00&
         Height          =   285
         Left            =   3720
         TabIndex        =   7
         Top             =   15
         Width           =   1335
      End
      Begin VB.Label lblDID 
         Caption         =   "DUT Type:"
         Height          =   255
         Left            =   2880
         TabIndex        =   6
         Top             =   60
         Width           =   975
      End
      Begin VB.Line lneStatSepHilight 
         BorderColor     =   &H80000014&
         Index           =   0
         X1              =   2760
         X2              =   2760
         Y1              =   -90
         Y2              =   360
      End
      Begin VB.Line lneStatSepSdw 
         BorderColor     =   &H80000010&
         BorderWidth     =   2
         Index           =   0
         X1              =   2760
         X2              =   2760
         Y1              =   -90
         Y2              =   360
      End
      Begin VB.Label lblUSBStat 
         Alignment       =   2  'Center
         BackColor       =   &H00004000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Not Connected!"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FF00&
         Height          =   285
         Left            =   1080
         TabIndex        =   5
         Top             =   15
         Width           =   1575
      End
      Begin VB.Label lblUSBStatus 
         Alignment       =   1  'Right Justify
         Caption         =   "USB Status:"
         Height          =   255
         Left            =   0
         TabIndex        =   4
         Top             =   60
         Width           =   975
      End
      Begin VB.Line lneStatSepHilight 
         BorderColor     =   &H80000014&
         Index           =   1
         Visible         =   0   'False
         X1              =   5160
         X2              =   5160
         Y1              =   0
         Y2              =   450
      End
      Begin VB.Line lneStatSepSdw 
         BorderColor     =   &H80000010&
         BorderWidth     =   2
         Index           =   1
         Visible         =   0   'False
         X1              =   5160
         X2              =   5160
         Y1              =   0
         Y2              =   450
      End
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileLoad 
         Caption         =   "&Load Setup..."
      End
      Begin VB.Menu mnuFileSaveSetup 
         Caption         =   "&Save Setup..."
      End
      Begin VB.Menu mnuFileSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
         Shortcut        =   ^Q
      End
   End
   Begin VB.Menu mnuIO 
      Caption         =   "&I/O"
      Begin VB.Menu mnuIOSelEvalBd 
         Caption         =   "Select Eval Board..."
      End
      Begin VB.Menu mnuIOSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuIODUTIO 
         Caption         =   "DUT I/O"
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuViewCtrlwnd 
         Caption         =   "Control Window..."
      End
      Begin VB.Menu mnuViewChnlCtrlWnd 
         Caption         =   "Channel Control Window..."
      End
      Begin VB.Menu mnuViewChnlFreqWnd 
         Caption         =   "Channel Output Config Window..."
      End
      Begin VB.Menu mnuViewSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewArrange 
         Caption         =   "Arrange Windows"
         Begin VB.Menu mnuViewArrangeCascade 
            Caption         =   "Cascade"
         End
         Begin VB.Menu mnuViewArrangeTile 
            Caption         =   "Tile"
         End
      End
      Begin VB.Menu mnuViewSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewDebugWindow 
         Caption         =   "Debug Window..."
      End
      Begin VB.Menu mnuViewRegDebug 
         Caption         =   "Register Debug Window..."
      End
      Begin VB.Menu mnuViewSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewOptions 
         Caption         =   "Options..."
      End
      Begin VB.Menu mnuViewSep3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewTWCalc 
         Caption         =   "Tuning Word Calc..."
      End
      Begin VB.Menu mnuViewRegMapVals 
         Caption         =   "RegMapVals"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpEvbdInstruct 
         Caption         =   "AD9911 Evaluation Board Instructions..."
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About"
         Shortcut        =   +{F1}
      End
   End
   Begin VB.Menu mnuDebug 
      Caption         =   "       <Dev Debug> "
      Begin VB.Menu mnuSetGUIMode 
         Caption         =   "Set EngMode"
         Begin VB.Menu mnuSetNormalMode 
            Caption         =   "Normal"
         End
         Begin VB.Menu mnuSetDebugMode 
            Caption         =   "Debug Mode"
         End
         Begin VB.Menu mnuSetEngMode 
            Caption         =   "Engineering Mode"
         End
         Begin VB.Menu mnuSetExtEngMode 
            Caption         =   "Ext Engineering Mode"
         End
      End
   End
End
Attribute VB_Name = "mdiMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Dim USBCnctedFore As Long
'Dim USBCnctedBack As Long
'Dim USBDCnctedFore As Long
'Dim USBDCnctedBack As Long

Dim lStatDispFore As Long
Dim lStatDispBack As Long
Dim lStatDispErrFore As Long
Dim lStatDispErrBack As Long

'Setup the main evalboard class
Public WithEvents EvalBd As cAD9911EvalBd
Attribute EvalBd.VB_VarHelpID = -1
Dim sgOldX As Single
Dim sgOldY As Single

'Used to store answer to message box about using newly attached boards
'Dim iUseNewEvbd As Integer

Private Sub chkAutoIOUpdate_Click()
    If chkAutoIOUpdate.value = 0 Then
        EvalBd.AutoIOUpdate = False
    Else
        EvalBd.AutoIOUpdate = True
    End If
End Sub

Private Sub cmdChannelControl_Click()
    frmChannelControl.Show       'Show the form
    frmChannelControl.ZOrder (0) 'Move it to the top
    frmChannelControl.WindowState = 0 'Unminimize if minimized
End Sub

Private Sub cmdControlWindow_Click()
    frmControl.Show       'Show the form
    frmControl.ZOrder (0) 'Move it to the top
    frmControl.WindowState = 0 'Unminimize if minimized
End Sub

Private Sub cmdManualIOUpdate_Click()
    'Take the IO Update signal High
    EvBd.IOUpdate = abvHigh
    EvBd.USBWritePortBuffVal fx2_PortD

    'Take the IO Update signal Low
    EvBd.IOUpdate = abvLow
    EvBd.USBWritePortBuffVal fx2_PortD
End Sub

Private Sub cmdOpenSetup_Click()
    mnuFileLoad_Click
End Sub

Private Sub cmdReset_Click()
    EvBd.ResetDUT
End Sub

Private Sub cmdSaveSetup_Click()
    'Save the current setup
    mnuFileSaveSetup_Click
End Sub

Private Sub cmdWizard_Click()
    'frmSetupWizard.Show
    frmChipConfig.Show
End Sub

Private Sub Command4_Click()
    frmChannelFreqs.Show       'Show the form
    frmChannelFreqs.ZOrder (0) 'Move it to the top
    frmChannelFreqs.WindowState = 0 'Unminimize if minimized
End Sub

Private Sub EvalBd_AfterReset()
        
    'If they want to do an IOUpdate after reset then do it
    If frmOptions.chkAutoIOUpdateAfterReset.value = 1 Then
        
        'Toggle the IO Update Pin
'        EvBd.IOUpdate = abvLow
'        EvBd.USBWritePortBuffVal fx2_PortD
'        EvBd.IOUpdate = abvHigh
'        EvBd.USBWritePortBuffVal fx2_PortD
'        EvBd.IOUpdate = abvLow
'        EvBd.USBWritePortBuffVal fx2_PortD
        EvBd.StrobeIOUpdate
        
        'Update the Register maps to reflect the
        EvBd.SetRegMapBitValue 2, 3, 1, abvLow, "1111"
    End If
    
    'Only do the events if enabled
    If EnableEvents = True Then
        
        'Update the debug window if it is loaded
        If IsLoaded("frmDebug") Then
            frmDebug.UpdateFormVals
        End If
        
        'Update the regdebug window if it is loaded
        If IsLoaded("frmRegDebug") Then
            frmRegDebug.UpdateFormVals
        End If
    
        If IsLoaded("frmControl") Then
            frmControl.UpdateFormVals
        End If
    
        If IsLoaded("frmMultichipSync") Then
            frmMultichipSync.UpdateFormVals
        End If
    
        If IsLoaded("frmChannelControl") Then
            frmChannelControl.UpdateFormVals
        End If
        
        If IsLoaded("frmChannelFreqs") Then
            frmChannelFreqs.UpdateFormVals
        End If
    End If
End Sub

Private Sub EvalBd_RegmapChanged(ByVal eRegMap As evb9911_RegMaps)
    'Only do the events if enabled
    If EnableEvents = True Then
        
        If IsLoaded("frmDebug") Then
            frmDebug.UpdateFormVals
        End If
        If IsLoaded("frmRegDebug") Then
            frmRegDebug.UpdateFormVals
        End If
    
    End If
End Sub

Private Sub imgResizer_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Button = 1 Then
        sgOldX = x
        sgOldY = y
    End If
End Sub

Private Sub imgResizer_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    On Error Resume Next
        
    If Button = 1 And Me.WindowState = 0 Then
        Me.Move Me.Left, Me.Top, Me.Width + (x - sgOldX), Me.Height + (y - sgOldY)
        pbxStatusBar.Refresh
    End If
End Sub

Private Sub MDIForm_Load()
    'Create a new instance of the eval board class
    Set EvalBd = New cAD9911EvalBd

    'Setup the vbAccelorator progress bar on the main window
    Set cMainProgress = New cProgressBar
    cMainProgress.DrawObject = mdiMain.pbxProgress
    cMainProgress.Min = 0
    cMainProgress.Max = 80
    cMainProgress.Tag = 5
    cMainProgress.ShowText = True
    cMainProgress.BackColor = vbButtonFace
    cMainProgress.BarColor = vbHighlight
    'cProgress.Segments = True
    cMainProgress.value = 0

    'GUI Defualt Colors
    lStatDispFore = &HFF00&
    lStatDispBack = &H4000&
    lStatDispErrFore = &HFF&
    lStatDispErrBack = &H40&

    'Setup the default as disconnected
    lblUSBStat.BackColor = lStatDispErrBack
    lblUSBStat.ForeColor = lStatDispErrFore
    lblUSBStat.Caption = "Not Connected"
    
    lblDUTID.BackColor = lStatDispErrBack
    lblDUTID.ForeColor = lStatDispErrFore
    lblDUTID.Caption = "NONE"
    
    'Initialize the iEvalbdsCncted
    'iEvbdsCncted = -5
    'Setup the Auto I\O Update
    If EvalBd.AutoIOUpdate Then
        chkAutoIOUpdate.value = 1
    Else
        chkAutoIOUpdate.value = 0
    End If
    
    'Set the debug mode
    SetDebugMode
    
    'Check to see if the eval board instructions are installed
    If FileExists(App.path & "\Instructions\AD9911EvalBdInstructs.pdf") Then
        mnuHelpEvbdInstruct.Visible = True
    Else
        mnuHelpEvbdInstruct.Visible = False
    End If
End Sub

Private Sub MDIForm_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Unload the evalboard class
    Set EvalBd = Nothing
    
    'Exit the program gracefully
    ExitGracefully
End Sub

Private Sub MDIForm_Resize()
    'Make sure that the status bar gets redrawn.
    pbxStatusBar_Paint
End Sub

Private Sub mnuAbout_Click()

End Sub

Private Sub mnuFileExit_Click()
    'Exit the program
    ExitGracefully
End Sub

Private Sub mnuFileLoad_Click()
    'Show the common dialog box
    Dim cdgFileDialog As New cCommonDialog
    Dim bDlgReturn As Boolean
    Dim sFileName As String
    Dim sFFilter As String
    
    sFFilter = "Setup Files (*.stp)|*.stp|Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
    'Show the open dialog
    bDlgReturn = cdgFileDialog.VBGetOpenFileName(sFileName, , , , , , sFFilter, , App.path, "Load Setup File", "STP", Me.hWnd, OFN_PATHMUSTEXIST)
    
    'Process events
    DoEvents
    DoEvents
    
    If bDlgReturn Then
        'Load the file
        LoadSetup sFileName
    End If
    
    'Add file to MRU list in the file menu
    
    'Destroy instance of common dialog class
    Set cdgFileDialog = Nothing
End Sub

Private Sub mnuFileSaveSetup_Click()
    'Show the common dialog box
    Dim cdgFileDialog As New cCommonDialog
    Dim bDlgReturn As Boolean
    Dim sFileName As String
    Dim sFFilter As String
    
    sFFilter = "Setup Files (*.stp)|*.stp|Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
    'Show the open dialog
    bDlgReturn = cdgFileDialog.VBGetSaveFileName(sFileName, , , sFFilter, , App.path, "Save Setup File", "STP", Me.hWnd, OFN_OVERWRITEPROMPT)
    
    'Process events
    DoEvents
    DoEvents
    
    If bDlgReturn Then
        'Save setup to the file
        SaveSetup sFileName, EvbdAttached
        
        'Add file to MRU list in the file menu
    End If
    
    'Destroy instance of common dialog class
    Set cdgFileDialog = Nothing
End Sub

Private Sub mnuHelpAbout_Click()
    'Show the about box
    frmAbout.Show 1
End Sub

Private Sub mnuHelpEvbdInstruct_Click()
    Dim sPDFReader As String
    'Get the path to the associated reader
    sPDFReader = GetAssociatedEXE("pdf")
    If sPDFReader = "" Then
        MsgBox "This document requires a PDF file viewer." & vbCrLf & "Adobe Acrobat Reader is a free program that can be used to view this file." & vbclrlf & "Please download and install a PDF viewer to enable this feature.", vbInformation, "PDF Viewer Reqired"
    Else
       Shell sPDFReader & " " & App.path & "\Instructions\AD9911EvalBdInstructs.pdf", vbNormalFocus
    End If
End Sub


Private Sub mnuIODUTIO_Click()
    frmIOInterface.Show
End Sub

Private Sub mnuIOSelEvalBd_Click()
    Dim sDrvrName As String
    Dim sCurDrvrName As String
    
    'Get the current driver name
    sCurDrvrName = clsEZUSBDev01.DriverName

    '
    sDrvrName = frmUSBSelect.ShowDialog("Select Evaluation Board", "Select the evaluation board to use from the list.")
    
    'Update the main windows usb status box in the status bar
    If sDrvrName <> "" Then
        mdiMain.lblUSBStat.Caption = sDrvrName
    Else
        'The user pressed the cancel button
    End If
    
    If (sDrvrName <> "" And EvBd.DUTType = "None") Or (sCurDrvrName <> sDrvrName And sDrvrName <> "") Then
        'Detect the DUT
        EvBd.DetectDUT
        'Initialize the IO Buffers
        EvBd.InitIOBuffs
        'Update the display with the new dut
        UpdateDUTType
        
        'Update the debug window if it is visible
        If IsLoaded("frmDebug") Then
            frmDebug.UpdateFormVals
        End If
    End If
    
End Sub

Private Sub mnuSetDebugMode_Click()
    iEngMode = 1
    SetEngMode
    mnuDebug.Visible = True
End Sub

Private Sub mnuSetEngMode_Click()
    iEngMode = 2
    SetEngMode
    mnuDebug.Visible = True
End Sub

Private Sub mnuSetExtEngMode_Click()
    iEngMode = 3
    SetEngMode
    mnuDebug.Visible = True
End Sub

Private Sub mnuSetNormalMode_Click()
    iEngMode = 0
    SetEngMode
    mnuDebug.Visible = True
End Sub

Private Sub mnuViewArrangeCascade_Click()
    mdiMain.ArrangeWindows 0
End Sub

Private Sub mnuViewArrangeTile_Click()
    mdiMain.ArrangeWindows 1
End Sub

Private Sub mnuViewTWCalc_Click()
    frmTWCalc.Show
    frmTWCalc.ZOrder 0
End Sub

Private Sub mnuViewChnlCtrlWnd_Click()
    frmChannelControl.Show       'Show the form
    frmChannelControl.ZOrder (0) 'Move it to the top
    frmChannelControl.WindowState = 0 'Unminimize if minimized
End Sub

Private Sub mnuViewChnlFreqWnd_Click()
    frmChannelFreqs.Show       'Show the form
    frmChannelFreqs.ZOrder (0) 'Move it to the top
    frmChannelFreqs.WindowState = 0 'Unminimize if minimized
End Sub

Private Sub mnuViewCtrlwnd_Click()
    frmControl.Show       'Show the form
    frmControl.ZOrder (0) 'Move it to the top
    frmControl.WindowState = 0 'Unminimize if minimized
End Sub

Private Sub mnuViewDebugWindow_Click()
    frmDebug.Show       'Show the form
    frmDebug.ZOrder 0   'Move it to the top
    frmDebug.WindowState = 0 'Unminimize if minimized
End Sub

Private Sub mnuViewOptions_Click()
    'frmRegisterMap.
    frmOptions.Show 1, mdiMain
End Sub

Private Sub mnuViewRegDebug_Click()
    'frmRegisterMap.
    frmRegDebug.Show
    frmRegDebug.ZOrder 0
End Sub

Private Sub mnuViewRegMapVals_Click()
    frmRegMapVals.Show
End Sub

Private Sub pbxStatusBar_Paint()
    'Make sure that the resizer is in the lower right
    imgResizer.Move pbxStatusBar.Width - imgResizer.Width, pbxStatusBar.Height - imgResizer.Height

    If Me.WindowState <> 0 Then
        imgResizer.Visible = False
    Else
        imgResizer.Visible = True
    End If
    
    'Position the progresss bar to the lower right of the status bar
    If imgResizer.Visible = False Then
        pbxProgress.Left = pbxStatusBar.Width - pbxProgress.Width - 15
        cMainProgress.Draw
    Else
        pbxProgress.Left = pbxStatusBar.Width - pbxProgress.Width - imgResizer.Width
        cMainProgress.Draw
    End If
End Sub

Private Sub pbxToolBar_Resize()
    'Resize the
    lneMainMenuSep(0).X2 = pbxToolBar.Width
    lneMainMenuSep(1).X2 = pbxToolBar.Width
End Sub

Private Sub tmrLoadFlash_Timer()
    Dim iDevsFnd As Integer
    Dim iCntr As Integer
    Dim sNVal As String
    Dim sCVal As String
'    Dim iYesNo As Integer
    
'    Dim bRegNeedsLoading
    
'    'If the software was connected without an evalboard connected
'    If clsEZUSBDev01.DriverName = "" Then
'        'Check for avaialble evalboards
'        clsEZUSBDev01.GetDevices
'        If clsEZUSBDev01.DeviceCount <> 0 And iUseNewEvbd <> vbNo Then
'            'If one is available then notify the user
'            iYesNo = MsgBox("An evaluation board has been attached." & vbCrLf & "Would you like to use it?", vbQuestion + vbYesNo + vbDefaultButton1, "Evaluation Board Detected")
'            If iYesNo = vbYes Then
'                mnuIOSelEvalBd_Click
'            End If
'            iUseNewEvbd = iYesNo
'        End If
'    End If
        
    'Get the current state
    EvbdAttached = clsEZUSBDev01.IsConnected
    'Try and detect the eval board being attached
    If EvbdAttached = True Then 'and clsEZUSBDev01.GetDriverName =
        If lblUSBStat.ForeColor <> lStatDispFore Then
            lblUSBStat.ForeColor = lStatDispFore
            lblUSBStat.BackColor = lStatDispBack
            lblUSBStat.Caption = clsEZUSBDev01.DriverName
        End If
    Else
        If lblUSBStat.ForeColor <> lStatDispErrFore Then
            lblUSBStat.ForeColor = lStatDispErrFore
            lblUSBStat.BackColor = lStatDispErrBack
            lblUSBStat.Caption = "Not Connected!"
        End If
    End If
    
    'Detect the eval board being attached
    If EvbdAttached = True And oldEvbdAttached = False Then
        'Detect the dut type and display its value
        EvBd.GetProductType
        If IsLoaded("frmChannelControl") Then
            frmChannelControl.SetupforDUTType
        End If
        If IsLoaded("frmChannelFreqs") Then
            frmChannelFreqs.SetupforDUTType
        End If
        
        UpdateDUTType
        'Trigger the EvalBoardAttached event
        EvbdAtched
    End If
    If EvbdAttached = False And oldEvbdAttached = True Then
        EvbdDtched
    End If
    
    'Set the two flags equal
    oldEvbdAttached = EvbdAttached
    
    'Test to see how
'    iDevsFnd = clsEZUSBDev01.GetDevices()
'    If iDevsFnd <> iEvbdsCncted Then
'    End If
'    iEvbdsCncted = iDevsFnd
    
'    'Loop through all of the registers
'    For iCntr = 0 To 3
'        'Get the new value
'        sNVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, iCntr)
'        'Get the current value
'        sCVal = EvBd.GetRegMapValue(rm9911_CurRegMapVals, iCntr)
'
'        'Compare the values
'        If sNVal <> sCVal Then
'            Select Case iCntr
'                Case 0: 'CSR
'                    'If form is loaded then flasch the load button
'                    If IsLoaded("frmIOInterface") Then
'                        If frmIOInterface.lblLoadFlash.Visible = True Then
'                            frmIOInterface.lblLoadFlash.Visible = False
'                        Else
'                            frmIOInterface.lblLoadFlash.Visible = True
'                        End If
'                    End If
'                Case 1: 'MFR1 Control Window
'                    If Right(sNVal, 2) <> Right(sCVal, 2) Then
'                        If IsLoaded("frmMultichipSync") Then
'                            frmMultichipSync.lblLoadFlash.Tag = "1" 'Flag that it is allready updated
'                            If frmMultichipSync.lblLoadFlash.Visible = True Then
'                                frmMultichipSync.lblLoadFlash.Visible = False
'                            Else
'                                frmMultichipSync.lblLoadFlash.Visible = True
'                            End If
'                        End If
'                    End If
'
'                    If Left(sNVal, 22) <> Left(sCVal, 22) Then
'                        'If form is loaded then flash the load button
'                        If IsLoaded("frmControl") Then
'                            If frmControl.lblLoadFlash.Visible = True Then
'                                frmControl.lblLoadFlash.Visible = False
'                            Else
'                                frmControl.lblLoadFlash.Visible = True
'                            End If
'                            frmControl.lblLoadFlash.Tag = "1" 'Flag that it is allready updated
'                        End If
'                    End If
'                Case 2: 'MFR2 Sync Window
'                    If Right(sNVal, 8) <> Right(sCVal, 8) Then
'                        'If form is loaded then flash the load button
'                        If IsLoaded("frmMultichipSync") Then
'                            If frmMultichipSync.lblLoadFlash.Visible = True And frmMultichipSync.lblLoadFlash.Tag <> "1" Then
'                                frmMultichipSync.lblLoadFlash.Visible = False
'                            Else
'                                frmMultichipSync.lblLoadFlash.Visible = True
'                            End If
'                        End If
'                    End If
'
'                    If Left(sNVal, 4) <> Right(sCVal, 4) Then
'                        'If form is loaded then flash the load button
'                        If IsLoaded("frmControl") Then
'                            If frmControl.lblLoadFlash.Visible = True Then
'                                frmControl.lblLoadFlash.Visible = False
'                            Else
'                                frmControl.lblLoadFlash.Visible = True
'                            End If
'                        End If
'                    End If
'            End Select
'        Else
'            Select Case iCntr
'                Case 0: 'CSR
'                    'If form is loaded then flash the load button
'                    If IsLoaded("frmIOInterface") Then
'                        frmIOInterface.lblLoadFlash.Visible = False
'                    End If
'                Case 1: 'MFR1
'                    'If form is loaded then flash the load button
'                    If IsLoaded("frmControl") Then
'                        If frmControl.lblLoadFlash.Tag = "" Then
'                            frmControl.lblLoadFlash.Visible = False
'                        End If
'                    End If
'                Case 2: 'MFR2
'                    'If form is loaded then flash the load button
'                    If IsLoaded("frmMultichipSync") Then
'                        If frmMultichipSync.lblLoadFlash.Tag = "" Then
'                            frmMultichipSync.lblLoadFlash.Visible = False
'                        End If
'                    End If
'            End Select
'        End If
'    Next iCntr
'    If IsLoaded("frmMultichipSync") Then
'        frmMultichipSync.lblLoadFlash.Tag = ""
'    End If
'    If IsLoaded("frmControl") Then
'        frmControl.lblLoadFlash.Tag = ""
'    End If
End Sub
'Updates the display for the DUTType
Public Sub UpdateDUTType()
    Select Case EvBd.DUTType
'        Case "AD9959E":  'AD9959E - Evaluation Product
'            lblDUTID.Caption = EvBd.DUTType
'            lblDUTID.ForeColor = lStatDispFore
'            lblDUTID.BackColor = lStatDispBack
'        Case "AD9959":  'AD9959
'            lblDUTID.Caption = EvBd.DUTType
'            lblDUTID.ForeColor = lStatDispFore
'            lblDUTID.BackColor = lStatDispBack
'        Case "AD9958 CH03":  'AD9958 - Channel 0 and 1
'            lblDUTID.Caption = "AD9958"
'            lblDUTID.ForeColor = lStatDispFore
'            lblDUTID.BackColor = lStatDispBack
'        Case "AD9958 CH23":  'AD9958 - Channel 2 and 3
'            lblDUTID.Caption = "AD9958"
'            lblDUTID.ForeColor = lStatDispFore
'            lblDUTID.BackColor = lStatDispBack
        Case "AD9911":  'Concept Product
            lblDUTID.Caption = EvBd.DUTType
            lblDUTID.ForeColor = lStatDispFore
            lblDUTID.BackColor = lStatDispBack
        Case Else
            lblDUTID.Caption = "NONE"
            lblDUTID.ForeColor = lStatDispErrFore
            lblDUTID.BackColor = lStatDispErrBack
            
    End Select
End Sub
'Arranges the child windows to their default positions
Public Sub ArrangeWindows(ByVal iType As Integer)
    Select Case iType
        Case 0:
            mdiMain.Arrange vbCascade
        Case 1:
            frmControl.Move 0, 0
            frmChannelControl.Move frmControl.Width + 100, 0
            frmChannelFreqs.Move frmControl.Width + 100, frmChannelControl.Height + 100
        Case 3:
            mdiMain.Arrange vbCascade
            frmChannelControl.Move frmControl.Width + 100, 0
    End Select
End Sub
'This sub changes the GUI depending on the engineering mode which is set by the
'global variable iEngMode
Public Sub SetDebugMode()
    Select Case iEngMode
        Case 1: 'Debug Mode
            mnuViewSep1.Visible = True
            mnuViewDebugWindow.Visible = True
            mnuViewRegDebug.Visible = False
            mnuViewSep2.Visible = False
            mnuViewOptions.Visible = False
            mnuViewSep3.Visible = False
            mnuViewTWCalc.Visible = False
            mnuViewRegMapVals.Visible = False
            mnuDebug.Visible = False
        Case 2: 'Engineering Mode
            mnuViewSep1.Visible = True
            mnuViewDebugWindow.Visible = True
            mnuViewRegDebug.Visible = True
            mnuViewSep2.Visible = False
            'mnuViewOptions.Visible = False
            mnuViewSep3.Visible = False
            mnuViewTWCalc.Visible = False
            mnuViewRegMapVals.Visible = False
            mnuDebug.Visible = False
        Case 3: 'Extended Engineering Mode
            mnuViewSep1.Visible = True
            mnuViewDebugWindow.Visible = True
            mnuViewRegDebug.Visible = True
            mnuViewSep2.Visible = True
            mnuViewOptions.Visible = True
            mnuViewSep3.Visible = True
            mnuViewTWCalc.Visible = True
            mnuViewRegMapVals.Visible = True
            mnuDebug.Visible = True
        Case Else 'Normal Mode
            'mnuViewSep1.Visible = False
            'mnuViewDebugWindow.Visible = False
            mnuViewRegDebug.Visible = False
            'mnuViewSep2.Visible = False
            'mnuViewOptions.Visible = False
            mnuViewSep3.Visible = False
            mnuViewTWCalc.Visible = False
            mnuViewRegMapVals.Visible = False
            mnuDebug.Visible = False
    End Select
End Sub

'Updates the form values
Public Sub UpdateFormVals()
    '
    chkAutoIOUpdate.value = Abs(EvBd.AutoIOUpdate)
End Sub
