Attribute VB_Name = "mMain"
'**************************************************************
'* Main Module                                                *
'**************************************************************

'Locale info variables
Public sDecSep As String
Public iDecSep As Integer
Public sNegSign As String
Public iNegSign As Integer

'Just trash variables for use in the imediate pane
Public lTrash As Long
Public iTrash As Integer
Public sTrash As String
Public dTrash As Double

'A globaly accessible usb class for the EZ-USB FX2
Public clsEZUSBDev01 As clsEZUSB
'A globaly accessible evaluation board class
Public EvBd As cAD9911EvalBd

'Globaly variable that contains the Software Mode
Public iEngMode As Integer

'Stores the command line string
Public CmdLine As String

'Global Flags
Public ManifestFile As String

Public EnableEvents As Boolean

'Define the progress bar class
Public cMainProgress As cProgressBar

'Define public constants for the tuning word sizes
Public Const OFTWBits = 32 'Output frequency tuning word

'**************************************************************
'* Main Module                                                *
'**************************************************************
'* Command Line Switches                                      *
'* -CYDEV - Use the cypress development board                 *
'* -DEVMOD - Use the EZ-USB Driver but use the product and    *
'*           and Vendor IDs for the AD9911                    *
'*                                                            *
'**************************************************************
Sub Main()
    Dim sDmyStr1 As String
    Dim sDmyStr2 As String
    Dim bFreeDev As Boolean
    Dim lUSBDevHostId As Long
     
    'Initialize modules
    sndInitSound 'Sound module
    
    'Get the commandline string
    CmdLine = UCase(Command())
    
    'Define a manifest file path
    ManifestFile = App.path & "\" & App.EXEName & ".exe.MANIFEST"
    
    'Get registry settings
    'GetAppSettings
    
    If FileExists(ManifestFile) Then
        'Enable Windows XP Themes
        EnableXPThemes
    End If
    
    'Setup the internationalization class
    Dim LocaleInfo As adiLocaleInfo
    Set LocaleInfo = New adiLocaleInfo

    'Get Locale Infomation
    sDecSep = LocaleInfo.GetLocaleInfo(adiDecimalSep)
    iDecSep = Asc(sDecSep)
    sNegSign = LocaleInfo.GetLocaleInfo(adiNegativeSign)
    iNegSign = Asc(sDecSep)
    Set LocaleInfo = Nothing
    
    'Create a new instance of the usb class
    Set clsEZUSBDev01 = New clsEZUSB
    
    'Show the splash screen
    frmSplash.Show
    frmSplash.Refresh
    
    'Initailize the USB Class and check for available devices
    frmSplash.AddStatLine "Initializing USB I/0 Interface..."
    
    'Check for development mode command line switch
    If InStr(1, CmdLine, "-CYDEV") <> 0 Then
        'clsEZUSBDev01.VendorID = &H4B4     'Cypress Semiconductor
        'clsEZUSBDev01.ProductID = &H8613  'Cypress default device
        
        clsEZUSBDev01.VendorID = &H547     'Cypress Semiconductor
        clsEZUSBDev01.ProductID = &H1002  'Cypress Sample Device
        
        'Use the EZUSB Driver
        clsEZUSBDev01.UseEZUSBDriver
        clsEZUSBDev01.USBDriverInstalled
        
        CmdLine = Replace(CmdLine, "-CYDEV", "")
        CmdLine = Replace(CmdLine, " ", "")
    Else
        clsEZUSBDev01.VendorID = &H456    'Analog Devices Inc.
        clsEZUSBDev01.ProductID = &HEE0F  'AD9911 Evaluation Board
    End If
    
    'Check for development mode command line switch
    If InStr(1, CmdLine, "-DEVMODE") <> 0 Then
        'Use the EZUSB Driver
        clsEZUSBDev01.UseEZUSBDriver
        clsEZUSBDev01.USBDriverInstalled
        CmdLine = Replace(CmdLine, "-DEVMOD", "")
        CmdLine = Replace(CmdLine, " ", "")
    End If
    
    'Check for engineering mode command line switch
    If InStr(1, CmdLine, "-ADIFULLENGMODE") <> 0 Then
        'Setup enginering mode
'        CmdLine = Replace(CmdLine, "-ADIFULLENGMODE", "")
'        CmdLine = Replace(CmdLine, " ", "")
        iEngMode = 3
    ElseIf InStr(1, CmdLine, "-ENGMODE") <> 0 Then
        'Setup Full Engineering Mode
'        CmdLine = Replace(CmdLine, "-ENGMODE", "")
'        CmdLine = Replace(CmdLine, " ", "")
        iEngMode = 2
    ElseIf InStr(1, CmdLine, "-DEBUGMODE") <> 0 Then
        'Setup Debug Mode
'        CmdLine = Replace(CmdLine, "-DEBUGMODE", "")
'        CmdLine = Replace(CmdLine, " ", "")
        iEngMode = 1
    Else
        'Setup normal mode
        iEngMode = 0
    End If
        
    'Check to see if the USB Driver is installed
    frmSplash.AddStatLine "   Checking for USB Drivers..."
    If clsEZUSBDev01.USBDriverIsInstalled() Then
        frmSplash.AddStatLine "   USB Driver Found."
        
        'Initialize the device list
        clsEZUSBDev01.GetDevices
                                        
        'Search the USB Devices to find a free Device
        If clsEZUSBDev01.DeviceCount > 1 Then
            For iUSBDevCntr = 0 To clsEZUSBDev01.DeviceCount - 1
                Call clsEZUSBDev01.GetHostID(iUSBDevCntr, lUSBDevHostId)
                If lUSBDevHostId = 0 Then
                    Call clsEZUSBDev01.SelectDevice(iUSBDevCntr, mdiMain.hWnd, True)
                    bFreeDev = True 'Indicate that a free device was found
'                    sOldEvBdName = clsEZUSBDev01.DriverName
'                    sEvBdName = sOldEvBdName 'Store the one being used
                    Exit For
                End If
            Next iUSBDevCntr
            
            'If a free device wasn't found then display the selection menu
            If bFreeDev = False Then
                If frmUSBSelect.ShowDialog("Select USB Device", "Select an evalution board.") = "" Then
                    'If the user doesn't select a device then exit
                    ExitGracefully
                End If
            End If
        Else
            If clsEZUSBDev01.DeviceCount = 1 Then
                'Display the status on the splash screen
                Call clsEZUSBDev01.SelectDevice(0, mdiMain.hWnd, True)
                frmSplash.AddStatLine "      Using Evaluation Board - " & clsEZUSBDev01.DriverName & "."
            Else
                'Display an error message on the splash screen
                frmSplash.SetStatusTextColor vbRed
                Call clsEZUSBDev01.SelectDevice(0, mdiMain.hWnd, True)
                frmSplash.AddStatLine "*     Error: Evaluation Board Not Found!!!"
            End If
        End If
    Else
        'Display an error message on the splash screen
        frmSplash.SetStatusTextColor vbRed
        frmSplash.AddStatLine "*  Error: USB Driver Not Found."
    End If
    
    'Detect if an evaluation board is attached to the computer
'    frmSplash.AddStatLine "   Searching for Evaluation Board..."
'    If clsEZUSBDev01.GetDevices = 0 Then
'        frmSplash.AddStatLine "      No Evaluation Boards Attached."
'        frmSplash.txtStatus.ForeColor = vbRed
'    Else
'        frmSplash.AddStatLine "      Found Evaluation Board..."
'        If clsEZUSBDev01.SelectDevice(0) = 1 Then
'            frmSplash.AddStatLine "      Using Evaluation Board - " & clsEZUSBDev01.DriverName & "."
'        Else
'            frmSplash.AddStatLine "      Error: Couldn't connect to an evaluation board."
'        End If
'    End If
    frmSplash.AddStatLine ""
    
    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Loading Main Window..."
    'Show the main form
    Load mdiMain
    mdiMain.Show
    Set EvBd = mdiMain.EvalBd
    
    'Load the options window
    Load frmOptions
    
    'Add a blank line to the splash screen
    frmSplash.AddStatLine ""
    
    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Initializing the Evaluation Board..."
    'Initialize the evaluation board
    EvBd.InitIOBuffs
    'Initialize the I/O lines make sure that the RURD_2 line
    'is low because if they have it jumpered over to the dut
    'and it is high you may not be able to comunicate with the
    'DUT because it comes up as I/O Reset by default
    If EvBd.RURD_2 = abvHigh Then
        EvBd.RURD_2 = abvLow
        EvBd.USBWritePortBuffVal fx2_PortD
    End If
    
    'If an eval board was detected and selected then detect the DUT
    If clsEZUSBDev01.DriverName <> "" Then
        sChipID = EvBd.DetectDUT()
        Select Case sChipID
'            Case "AD9959E":  'AD9959E - Evaluation Product
'                frmSplash.AddStatLine "   AD9959E Detected..."
'            Case "AD9959":  'AD9959
'                frmSplash.AddStatLine "   AD9959 Detected..."
'            Case "AD9958 CH01":  'AD9958 - Channel 0 and 1
'                frmSplash.AddStatLine "   AD9958 Detected..."
'            Case "AD9958 CH23":  'AD9958 - Channel 2 and 3
'                frmSplash.AddStatLine "   AD9958 Detected..."
            Case "AD9911":  'Concept Product
                frmSplash.AddStatLine "   AD9911 Detected..."
            Case Else
                'Display an error message on the splash screen
                frmSplash.SetStatusTextColor vbRed
                frmSplash.AddStatLine "*  Error: DUT Not Detected..."
        End Select
    End If
    
    'Uppdate the dut type
    mdiMain.UpdateDUTType

    'Display a message box indicating that no ref clock was found
    'This will once again reset the evaluation board
    If clsEZUSBDev01.IsConnected Then
        If sChipID <> "None" Then
            If CheckCLK() = False Then
                sDmyStr1 = "The evaluation board doesn't seem to have a RefClk!" & vbCrLf & vbCrLf _
                           & "Without a RefClk the software can not program the AD9911." & vbCrLf & vbCrLf _
                           & "Please check your connections!"
                MsgBox sDmyStr1, vbInformation + vbOKOnly, "RefClk Missing!"
                frmSplash.AddStatLine "   RefClk Check Failed!"
            Else
                frmSplash.AddStatLine "   RefClk Check Passed!"
            End If
        Else
            frmSplash.AddStatLine "   RefClk Check Skipped! - DUT Missing!"
        End If
    Else
        frmSplash.AddStatLine "   RefClk Check Skipped! - EvalBd Missing!"
    End If
    
    'Enable usb checking
    mdiMain.tmrLoadFlash.Enabled = True
    
    'Add Blank Line
    frmSplash.AddStatLine ""
    
    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Resetting the Eval Board and Software..."
    'Enable the evalboard software events to process
    EnableEvents = True
'    If clsEZUSBDev01.IsConnected Then
        'Reset the Evaluation board
        EvBd.ResetDUT
'    End If
    
    'Add Blank Line
    frmSplash.AddStatLine ""
    
    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Loading GUI Graphics..."
    'Show the debug window
    Load frmGraphics
    
    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Loading Control Window..."
    'Show the debug window
    frmControl.Show
    
    'Update the splash screen with the latest info
    'frmSplash.AddStatLine "Loading Debug Window..."
    'Show the debug window
    'frmDebug.Show
    
    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Loading Channel Control Window..."
    'Show the debug window
    frmChannelControl.Show

    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Loading Channel Frequency Window..."
    'Show the debug window
    frmChannelFreqs.Show
    
    'Set the engineering mode
    SetEngMode
    'Arrange the windows
    mdiMain.ArrangeWindows 3
    
    'Add a blank line to the splash screen
    frmSplash.AddStatLine ""
    'Update the splash screen with the latest info
    frmSplash.AddStatLine "Software is up and running..."
    
    'Change the refclk value to default to 500 Mhz
    frmControl.ZOrder (0) 'Move to the front of the ZOrder to
    frmControl.txtRefClk.Text = Format(500, "0.000")
    
    'Enable the unload feature of the splash screen
    frmSplash.AutoUnloadEnable
    
'    'Set the VCOGain bit because our default value for sysclk is 500 MHz
'    frmControl.chkVCOGain.value = 1
    frmChannelFreqs.sstChannel.Tab = 1
    frmChannelControl.sstChannel.Tab = 1
End Sub

'**************************************************************
'* ExitGracefully()                                           *
'**************************************************************
'* Cleans up all loose ends before closing the program        *
'**************************************************************
Public Sub ExitGracefully()
    'The Evaluation Board
    If clsEZUSBDev01.IsConnected() Then
        'Free up the device currently using
        clsEZUSBDev01.SetHostID clsEZUSBDev01.GetDeviceIndex(clsEZUSBDev01.DriverName), 0
    End If
    
    'Free up used memory
    Set EvBd = Nothing
    If IsLoaded("frmDebug") Then
        Unload frmDebug
    End If
    If IsLoaded("frmRegmap") Then
        Unload frmRegmap
    End If
    If IsLoaded("frmSplash") Then
        Unload frmSplash
    End If
        
    'Exit the program
    End
End Sub

'This sub changes the GUI depending on the engineering mode which is set by the
'global variable iEngMode
Public Sub SetEngMode()
    If IsLoaded("frmControl") Then
        frmControl.SetDebugMode
    End If

    If IsLoaded("frmChannelControl") Then
        frmChannelControl.SetDebugMode
    End If
    
    If IsLoaded("frmChannelFreqs") Then
        frmChannelFreqs.SetDebugMode
    End If
    
    If IsLoaded("frmDebug") Then
        frmDebug.SetDebugMode
    End If
    
    If IsLoaded("frmRegDebug") Then
        frmRegDebug.SetDebugMode
    End If

    If IsLoaded("mdiMain") Then
        mdiMain.SetDebugMode
    End If
End Sub

'Loads either an AD9958 or AD9911 file into the current device
Public Sub LoadSetup(ByVal FilePath As String)
    Dim FileHandle As Integer 'Handle to the file opened
    Dim cntr As Integer
    Dim iLoopCntr As Integer
    Dim sDummyString As String
    Dim vValue As Variant
    Dim ActForm As Form
    Dim ActControl As Control

    Dim sProduct As String
    Dim sChannelMask As String

    Dim FileType As String
    Dim FileRevNum As Double

    Dim AutoIOUpdate As Boolean
    Dim OldAutoIOUpdate As Boolean

    Dim iprofile As Integer
    Dim lngSPMode As Long

    Dim iChannelCntr As Integer
    Dim StartCnt As Integer
    Dim EndCnt As Integer

    'Update the status bar and mouse pointer while setting are loading
    Screen.MousePointer = 11
    'Setup the main windows progressbar
    cMainProgress.Max = 86
    cMainProgress.Text = "Loading Setup To File..."

    'Store the AutoIOUpdate setting again
    OldAutoIOUpdate = EvBd.AutoIOUpdate

    'Turn autofud off
    If EvBd.AutoIOUpdate = True Then
        EvBd.AutoIOUpdate = False
    End If

    'Setup the errorhandler
    On Error GoTo LoadFileError

    'Get a file handle
    FileHandle = FreeFile

    'Open the file
    Open FilePath For Input As #FileHandle

    'Readback the first line which is the header
    Input #FileHandle, FileType, FileRevNum
    
    'Get the product
    Input #FileHandle, sDummyString, sProduct
    
    'Get blank line
    Input #FileHandle, sDummyString

    'Check the file version
    If FileType = "AD9958/59 Eval Software Settings File" Then
        If FileRevNum = 1 Then
            'Get the control windows settings
            With frmControl
                'Get the reference clock value
                Input #FileHandle, sDummyString, vValue
                .txtRefClk.Text = CStr(vValue)
                .txtRefClk_KeyPress 13
'                If DutCntr = 1 Then
'                    'Get the reference clock value
'                    Input #FileHandle, sDummyString, vValue
'                    .chkUseDUT1RefClk.value = vValue
'                End If

                'Get the AutoIOUpdate Setting
                Input #FileHandle, sDummyString, vValue
                AutoIOUpdate = vValue
            End With

            'Get one empty line
            Input #FileHandle, sDummyString
            'Get the register map header
            Input #FileHandle, sDummyString
            
            With EvBd
                'Loop through all of the non-channel registers
                For cntr = 0 To &H2
                    Input #FileHandle, sDummyString, vValue
                    .SetRegMapValue rm9911_NewRegMapVals, cntr, vValue
                    .SetRegMapValue rm9911_CurRegMapVals, cntr, vValue
                    'if an eval board is attached then load the data
                    If EvbdAttached Then
                        .USBSerialLoad cntr, .GetRegMapValue(rm9911_NewRegMapVals, cntr)
                    End If
                    'Update the main progress
                    cMainProgress.value = cMainProgress.value + 1
                Next cntr

                'Get the channel mask
                Select Case sProduct
                    Case "AD9958 CH01":
                        'Do nothing
                        iChannelCntr = 0
                        StartCnt = 0
                        EndCnt = 1
                    Case "AD9958 CH23":
                        iChannelCntr = 2
                        StartCnt = 2
                        EndCnt = 3
                    Case Else:
                        'Do nothing
                        iChannelCntr = 0
                        StartCnt = 0
                        EndCnt = 3
                End Select
                
                'Load all channels
                For iLoopCntr = StartCnt To EndCnt
                    sChannelMask = .GetChMaskVal(iLoopCntr)
                    'if an eval board is attached, select the channel
                    If EvbdAttached Then
                        .SelectChannel iLoopCntr
                    End If
                    
                    'Get blank line
                    Input #FileHandle, sDummyString
                    If sDummyString <> "" Then
                        'Exit the for loop
                        Exit For
                    End If
                    
                    'Get Channel Header Line
                    Input #FileHandle, sDummyString
                    If sDummyString = "Data and Power Down Pins" Then
                        'Exit the for loop
                        Exit For  'This may happen if they load a AD9958 Setup into a AD9911
                    End If
                                        
                    'Load each of the channel registers
                    For cntr = &H3 To &H18
                        Input #FileHandle, sDummyString, vValue
                        .SetRegMapValue rm9911_NewRegMapVals, cntr, vValue, sChannelMask
                        .SetRegMapValue rm9911_CurRegMapVals, cntr, vValue, sChannelMask
                        'If an eval board is attached then load the data
                        If EvbdAttached Then
                            .USBSerialLoad cntr, .GetRegMapValue(rm9911_NewRegMapVals, cntr, iLoopCntr)
                        End If
                        
                        'Update the main progress
                        cMainProgress.value = cMainProgress.value + 1
                    Next cntr
                    
                    'Increment the channel cntr
                    iChannelCntr = iChannelCntr + 1
                Next iLoopCntr
            
                'All of the registers have been loaded so do an IO_Update
                .StrobeIOUpdate
            
                'Turn autofud back on
                EvBd.AutoIOUpdate = AutoIOUpdate
'                EvBd.USBWritePortBuffVal fx2_PortD
                
                'Get blank line
                Input #FileHandle, sDummyString
                'Get Channel Header Line
                Input #FileHandle, sDummyString
                
                If sDummyString <> "Data and Power Down Pins" Then
                    'This may be needed if the modifies a AD9911 file to load on a AD9958
                    'Loop until we have found the correct spot in the file
                    Do
                        'Input the next line
                        Input #FileHandle, sDummyString
                    Loop Until sDummyString = "Data and Power Down Pins" Or EOF(FileHandle)
                End If
                
                'Read in the pin settings
                Input #FileHandle, sDummyString, vValue
                EvBd.P1 = vValue
                Input #FileHandle, sDummyString, vValue
                EvBd.P2 = vValue
                Input #FileHandle, sDummyString, vValue
                EvBd.P3 = vValue
                Input #FileHandle, sDummyString, vValue
                EvBd.P4 = vValue
                Input #FileHandle, sDummyString, vValue
                EvBd.RURD_0 = vValue
                Input #FileHandle, sDummyString, vValue
                EvBd.RURD_1 = vValue
                Input #FileHandle, sDummyString, vValue
                EvBd.RURD_2 = vValue
                Input #FileHandle, sDummyString, vValue
                EvBd.PwrDwn = vValue
                
                'Update the evalboard pinvalues
                EvBd.USBWritePortBuffVal fx2_PortD
                'Update the evalboard pinvalues
                EvBd.USBWritePortBuffVal fx2_PortA
            End With
            
            'Refresh the forms
            If IsLoaded("frmControl") Then
                frmControl.UpdateFormVals
            End If
            If IsLoaded("frmIOInterface") Then
                frmIOInterface.RefreshControls
            End If
            If IsLoaded("frmChannelFreqs") Then
                frmChannelFreqs.UpdateFormVals
            End If
            If IsLoaded("frmChannelControl") Then
                frmChannelControl.UpdateFormVals
            End If

            If IsLoaded("frmDebug") Then
                frmDebug.UpdateFormVals
            End If
            
            'Update the main form Values
            mdiMain.UpdateFormVals

            'Update the main progress to the finished position
            cMainProgress.value = cMainProgress.Max
                                
            'Update the main progress
            cMainProgress.Text = "File Loaded..."
            Delay 0.5
            'Update the main progress
            cMainProgress.Text = ""
            cMainProgress.value = 0
            'Update the status bar and mouse pointer back to normal
            Screen.MousePointer = 0
        End If
    Else
        Screen.MousePointer = 0
        'Show setup file error
        MsgBox "Invalid setup file!", vbApplicationModal + vbExclamation + vbOKOnly, "Error Loading Setup File!"
    End If

    'Close file before exiting
    Close #FileHandle

    'Exit the subroutine before errorhandler
    Exit Sub

'Define the error handler
LoadFileError:
    'Update the main progress
    cMainProgress.Text = "Error Loading File!!!"
    Delay 2
    cMainProgress.Text = ""
    cMainProgress.value = 0
    
    Screen.MousePointer = 0
    'Display an error message
    MsgBox "Error Number: " & Err.Number & vbCrLf & Err.Description, vbApplicationModal + vbCritical + vbOKOnly, "Load File Error"

    'Close file before exiting
    Close #FileHandle
End Sub

'Saves the current setup to a file
'Inputs
'FilePath - Full path to the file to save the current settings to.
'DumpRegs - If true then it reads and saves the actual register data from the DUT
'           If false then it saves the current software buffer values for the registers
'Saves all registers for AD9911 product which includes AD9958
Public Sub SaveSetup(ByVal FilePath As String, Optional DumpRegs)
    Dim FileHandle As Integer 'Handle to the file opened
    Dim cntr As Integer
    Dim ChnlCntr As Integer
    Dim RegNames(0 To 25) As String
    Dim StartCnt As Integer
    Dim EndCnt As Integer
    Dim bDumpRegs As Boolean
    
'    Dim sCSRVal As String 'Stores the CSR register value
'    Dim sCHAddr(0 To 3) As String 'Look-up table for addressing each channel
    
    'Initialize the register names
    RegNames(0) = "CSR"
    RegNames(1) = "FR1"
    RegNames(2) = "FR2"
    RegNames(3) = "CFR"
    RegNames(4) = "CTW0"
    RegNames(5) = "CPOW"
    RegNames(6) = "ACR"
    RegNames(7) = "LSR"
    RegNames(8) = "RDW"
    RegNames(9) = "FDW"
    RegNames(10) = "CTW1"
    RegNames(11) = "CTW2"
    RegNames(12) = "CTW3"
    RegNames(13) = "CTW4"
    RegNames(14) = "CTW5"
    RegNames(15) = "CTW6"
    RegNames(16) = "CTW7"
    RegNames(17) = "CTW8"
    RegNames(18) = "CTW9"
    RegNames(19) = "CTW10"
    RegNames(20) = "CTW11"
    RegNames(21) = "CTW12"
    RegNames(22) = "CTW13"
    RegNames(23) = "CTW14"
    RegNames(24) = "CTW15"
    
    'Setup the dump registers flag from user input
    If IsMissing(DumpRegs) Then
        bDumpRegs = False
    Else
    '    bDumpRegs = True
        bDumpRegs = DumpRegs
    End If
    
    'Show hourglass mouse pointer until finished
    Screen.MousePointer = 11
    
    'Setup an errorhandler
    On Error GoTo FileError
    
    'Get a file handle
    FileHandle = FreeFile(1)
    
    'Open the file
    Open FilePath For Output As #FileHandle
    
    'Setup the main windows progressbar
    cMainProgress.Max = 86
    cMainProgress.Text = "Saving Setup To File..."
    
    'Write the Header
    Write #FileHandle, "AD9958/59 Eval Software Settings File", 1#
    Write #FileHandle, "Product:", EvBd.DUTType
    Write #FileHandle, ""
    
    'Store any non register related info
    With frmControl
        'Store the external frequency
        Write #FileHandle, "External Frequency(MHz)", CDbl(.txtRefClk.Text)
        Write #FileHandle, "AutoIOUpdate", EvBd.AutoIOUpdate
    End With
    
    'Write a blank line
    Write #FileHandle, ""
    'Store the register map
    Write #FileHandle, "Register Map Values (Binary)"
        
    'Readback and write to file the Chip-Level Control registers
    For cntr = 0 To 2
        If bDumpRegs = True Then
            'If dumping the regval then read directly from the DUT
            Write #FileHandle, RegNames(cntr), EvBd.USBSerialRead(cntr)
        Else
            'Otherwize read from the registermap software buffer
            Write #FileHandle, RegNames(cntr), EvBd.GetRegMapValue(rm9911_CurRegMapVals, cntr)
        End If
        'Update the main progress
        cMainProgress.value = cMainProgress.value + 1
    Next cntr
    
    'Get the channel mask
    Select Case EvBd.DUTType
        Case "AD9958 CH01":  'Concept product
            StartCnt = 0 'Start at 0
            EndCnt = 1   'End at 1
        Case "AD9958 CH23":
            StartCnt = 2 'Start at 0
            EndCnt = 3   'End at 1
        Case Else:
            'Do nothing
            StartCnt = 0 'Start at 0
            EndCnt = 3   'End at 1
    End Select
    
    'Loop through each channel
    For ChnlCntr = StartCnt To EndCnt
        'Write a Blank Line
        Write #FileHandle, ""
        If EvBd.DUTType = "AD9958 CH23" Then
            'Write a header first
            Write #FileHandle, "CH" & ChnlCntr - 2 & " Register Values"
        Else 'Handle AD9911 Product
            'Write a header first
            Write #FileHandle, "CH" & ChnlCntr & " Register Values"
        End If
        'Loop through and write each channel register
        For cntr = 3 To 24
            If bDumpRegs = True Then
                'Select the channel to read from
                EvBd.SelectChannel ChnlCntr
                'If dumping the regval then read directly from the DUT
                Write #FileHandle, RegNames(cntr), EvBd.USBSerialRead(cntr)
            Else
                'Otherwize read from the registermap software buffer
                Write #FileHandle, RegNames(cntr), EvBd.GetRegMapValue(rm9911_CurRegMapVals, cntr, ChnlCntr)
            End If
            'Update the main progress
            cMainProgress.value = cMainProgress.value + 1
        Next cntr
    Next ChnlCntr
    
    'Store the current pin values
    'Write a Blank Line
    Write #FileHandle, ""
    'Write a header first
    Write #FileHandle, "Data and Power Down Pins"
    'Store the data pin values
    Write #FileHandle, "P0", EvBd.P1
    Write #FileHandle, "P1", EvBd.P2
    Write #FileHandle, "P2", EvBd.P3
    Write #FileHandle, "P3", EvBd.P4
    Write #FileHandle, "RURD0", EvBd.RURD_0
    Write #FileHandle, "RURD1", EvBd.RURD_1
    Write #FileHandle, "RURD2", EvBd.RURD_2
    Write #FileHandle, "Power Down", EvBd.PwrDwn
    
    'Close file before exiting
    Close #FileHandle
        
    'Update the main progress bar to the finished position
    cMainProgress.value = cMainProgress.Max

    'Update the main progress
    cMainProgress.Text = "File Saved..."
    Delay 0.5
    'Update the main progress
    cMainProgress.Text = ""
    cMainProgress.value = 0
    'Show default mouse pointer when finished
    Screen.MousePointer = 0

    'Exit the subroutine before the error handler
    Exit Sub
    
'Define error handler
FileError:
    'Update the main progress
    cMainProgress.Text = "Error Saving File!!!"
    Delay 2
    cMainProgress.Text = ""
    cMainProgress.value = 0
    'Show default mouse pointer when finished
    Screen.MousePointer = 0
    
    'Display an error message
    MsgBox "Error: " & Err.Number & vbCrLf & Err.Description, vbApplicationModal + vbCritical + vbOKOnly, "File Error:"
    Close #FileHandle
    
    'Hide and Unload  the RAM Loading Status Window
    MakeTopMost frmRAMLoadStatus, False
    frmRAMLoadStatus.Hide
    Unload frmRAMLoadStatus
End Sub

'Grays out a frame and all controls on the frame
'Doesn't disable the frame just sets all controls on it to grayed text color
Public Sub GrayFrame(ByVal fraMyFrame As Frame, ByVal GrayIt As Boolean)
    Dim iCntr As Integer
    On Error GoTo ErrorHandler
    For iCntr = 0 To fraMyFrame.Parent.Controls.Count - 1
        If fraMyFrame.Parent.Controls(iCntr).Container Is fraMyFrame Then
            If GrayIt = True Then
                fraMyFrame.Parent.Controls(iCntr).ForeColor = vbGrayText
            Else
                fraMyFrame.Parent.Controls(iCntr).ForeColor = vbWindowText
            End If
        End If
    Next iCntr
    
    If GrayIt = True Then
        fraMyFrame.ForeColor = vbGrayText
    Else
        fraMyFrame.ForeColor = vbWindowText
    End If

ErrorHandler:
    Resume Next
End Sub

