Attribute VB_Name = "mEvalBoard"
Public EvbdAttached As Boolean
Public oldEvbdAttached As Boolean
Public iEvbdsCncted As Integer
'Public sEvBdName As String
'Public sOldEvBdName As String

Public Function SetBitVal(ByVal EditByte As Byte, ByVal Bit As Integer, ByVal value As Integer) As Byte
    Dim BitVals(0 To 7) As Byte
        
    BitVals(0) = 1
    BitVals(1) = 2
    BitVals(2) = 4
    BitVals(3) = 8
    BitVals(4) = 16
    BitVals(5) = 32
    BitVals(6) = 64
    BitVals(7) = 128
    
    If value <> 0 Then
        'Set the bit
        SetBitVal = EditByte Or BitVals(Bit)
    Else
        'Clear the bit
        SetBitVal = EditByte And Not BitVals(Bit)
    End If
End Function

'Converts a binary string to a byte
Public Function BinS2Byte(ByVal sVal As String) As Byte
    Dim iCntr As Integer
    Dim retval As Byte
    Dim bBitCntr As Byte
    Dim iLenSVal As Integer
    
    iLenSVal = Len(sVal)
    
    For iCntr = iLenSVal To 1 Step -1
        If Mid(sVal, iCntr, 1) = "1" Then
            BinS2Byte = BinS2Byte + 2 ^ bBitCntr
        End If
        
        'Increment the bit cntr
        bBitCntr = bBitCntr + 1
    Next iCntr
End Function

'Converts a byte to a binary string
Public Function Byte2BinS(ByVal bVal As Byte) As String
    Dim iCntr As Integer
    Dim bTempVal As Byte
    
    'Use standard decimal to binary conversion
    For iCntr = 0 To 7
        'If the remainder is 1 then store a 1 else store a 0
        If (bVal Mod 2) = 1 Then
            Byte2BinS = "1" & Byte2BinS
        Else
            Byte2BinS = "0" & Byte2BinS
        End If
        'Do the divide and truncate the remainder
        bVal = Fix(bVal / 2)
    Next iCntr
End Function
'Detect the ref clk clock
Public Function CheckCLK() As Boolean
    Dim sChipID As String
    Dim sRegVal As String
    Dim bAIOUpd As Boolean
    Dim iCh2Check As Integer
    
    'Get the current value of ioupdate
    bAIOUpd = EvBd.AutoIOUpdate
    
    'Turn off Auto IO Update
    EvBd.AutoIOUpdate = False
    
    'Reset the evalboard
    EvBd.ResetDUT
        
    'Make sure we check a valid register
    If EvBd.DUTType = "AD9958 CH23" Then
        EvBd.SelectChannel 2
        iCh2Check = 2
    Else
        EvBd.SelectChannel 0
        iCh2Check = 0
    End If
    
    'Toggle the IO Update Pin
    EvBd.IOUpdate = abvLow
    EvBd.USBWritePortBuffVal fx2_PortD
    
    EvBd.IOUpdate = abvHigh
    EvBd.USBWritePortBuffVal fx2_PortD
    
    EvBd.IOUpdate = abvLow
    EvBd.USBWritePortBuffVal fx2_PortD
    
    If EvBd.DUTType = "AD9958 CH01" Then
        EvBd.SelectChannel 0
    ElseIf EvBd.DUTType = "AD9958 CH23" Then
        EvBd.SelectChannel 2
    End If
    
    'Read the value of register 3
    sRegVal = EvBd.USBSerialRead(3)
    'Test the value returned with the value
    If EvBd.GetRegMapBitValue(rm9911_CurRegMapVals, 3, 1, iCh2Check) = abvLow Then
        CheckCLK = True
    Else
        CheckCLK = False
    End If

    'Restore the AutoIOUpdate feature
    EvBd.AutoIOUpdate = bAIOUpd
End Function

'This routine gets called when the software detects
'an eval board attachment
Public Sub EvbdAtched()
'    MsgBox "Eval Board Attached"
End Sub

'This routine gets called when the currently slected
'eval board is detached
Public Sub EvbdDtched()
'    MsgBox "Eval Board Detached"
    

End Sub

'Calculates the harmonic
'iHarmonic can be 2 to 14
'vFTW is a decimal value for the frequency tuning word
Public Function CalcHarmonic(ByVal vFTW As Variant, ByVal iHarmonic As Integer) As Variant
    Dim iShfts As Integer
    Dim vNthTWVal As Variant 'Second harmonic tuning word
    Dim vCalcTWVal As Variant 'Calculated Tuning Word
    Dim sCalcTWVal As String
    
    'Go ahead and get the fundamentals tuning word value
    vFundTWVal = vFTW
    
    If iHarmonic < 2 Or iHarmonic > 14 Then
        'Return error
        CalcHarmonic = -1
        
        'Exit function
        Exit Function
    End If
    
    'Check to see if they picked a even or odd
    If iHarmonic Mod 2 = 0 Then
        'Even Harmonic
        iShfts = iHarmonic / 2
                
        'Perform a left bit shift on the fundamental by multiplying by 2
        sCalcTWVal = cbaseDec2Bin(vFundTWVal, OFTWBits) 'Get the binary version of the FTW
        sCalcTWVal = Right(sCalcTWVal, Len(sCalcTWVal) - iShfts) & String(iShfts, "0") 'Perform
        vCalcTWVal = cbaseBinS2Dec(sCalcTWVal)
    Else
        'Odd Harmonic
        iShfts = Fix(iHarmonic / 2)
        
        'Perform a left bit shift on the fundamental by multiplying by 2
        sCalcTWVal = cbaseDec2Bin(vFundTWVal, OFTWBits)
        sCalcTWVal = Right(sCalcTWVal, Len(sCalcTWVal) - iShfts) & String(iShfts, "0")
        vNthTWVal = cbaseBinS2Dec(sCalcTWVal)
        sCalcTWVal = cbaseDec2Bin(vFundTWVal + vNthTWVal, OFTWBits)
        vCalcTWVal = cbaseBinS2Dec(sCalcTWVal)
    End If
    
    'Return the calculated value
    CalcHarmonic = vCalcTWVal
End Function
