VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmUSBSelect 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Select USB Device"
   ClientHeight    =   2775
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4455
   Icon            =   "frmUSBSelect.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2775
   ScaleWidth      =   4455
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.Timer tmrRefresh 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   120
      Top             =   2280
   End
   Begin VB.Frame fraUSBList 
      BorderStyle     =   0  'None
      Caption         =   "USB Devices Detected"
      Height          =   2055
      Left            =   240
      TabIndex        =   4
      Top             =   3480
      Width           =   3615
      Begin VB.ListBox lstUSBDevices 
         Height          =   1260
         IntegralHeight  =   0   'False
         ItemData        =   "frmUSBSelect.frx":000C
         Left            =   120
         List            =   "frmUSBSelect.frx":000E
         TabIndex        =   5
         Top             =   600
         Width           =   2655
      End
      Begin VB.Label lblUSBDeviceName 
         Alignment       =   2  'Center
         Caption         =   "Device Name"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   3240
      TabIndex        =   2
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&Ok"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   375
      Left            =   2040
      TabIndex        =   1
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton cmdRefresh 
      Caption         =   "Refresh List"
      Height          =   375
      Left            =   840
      TabIndex        =   0
      Top             =   2280
      Width           =   1095
   End
   Begin MSComctlLib.ListView lvuUSBDevices 
      Height          =   1335
      Left            =   120
      TabIndex        =   8
      Top             =   840
      Width           =   4215
      _ExtentX        =   7435
      _ExtentY        =   2355
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      FullRowSelect   =   -1  'True
      GridLines       =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      MousePointer    =   1
      NumItems        =   3
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "Device"
         Object.Width           =   2540
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Alignment       =   2
         SubItemIndex    =   1
         Text            =   "Firmware Rev."
         Object.Width           =   2540
      EndProperty
      BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Alignment       =   2
         SubItemIndex    =   2
         Text            =   " HostID "
         Object.Width           =   2540
      EndProperty
   End
   Begin VB.Label lblAutoSize 
      AutoSize        =   -1  'True
      Caption         =   "Label1"
      Height          =   195
      Left            =   120
      TabIndex        =   7
      Top             =   3480
      Visible         =   0   'False
      Width           =   480
   End
   Begin VB.Label lblMessage 
      Caption         =   "Select the evaluation board to use."
      Height          =   615
      Left            =   1200
      TabIndex        =   3
      Top             =   120
      Width           =   3135
      WordWrap        =   -1  'True
   End
   Begin VB.Image imgIcon 
      Height          =   525
      Left            =   120
      Picture         =   "frmUSBSelect.frx":0010
      Top             =   120
      Width           =   1035
   End
End
Attribute VB_Name = "frmUSBSelect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private OldDeviceCnt As Integer

Private Declare Function FlashWindow Lib "user32" (ByVal hWnd As Long, ByVal bInvert As Long) As Long
Private Declare Function SetFocusAPI& Lib "user32" Alias "SetFocus" (ByVal hWnd As Long)
Private Declare Function GetActiveWindow Lib "user32" () As Long
'Tests a window handle to determine if it is a valid handle
Private Declare Function IsWindow Lib "user32" (ByVal hWnd As Long) As Long

Dim bCancelHit As Boolean

Private Sub cmdCancel_Click()
    bCancelHit = True
    'Just hide the form.
    Me.Hide
End Sub

Private Sub cmdOK_Click()
    'Use the device selected from the list
    If clsEZUSBDev01.SelectDevice(lvuUSBDevices.SelectedItem.Index - 1, mdiMain.hWnd) = 1 Then 'lstUSBDevices.ListIndex
        Me.Hide
    Else
        MsgBox "Error: Selecting device" & vbCrLf & vbCrLf & "Try the clicking the Refresh button and reselecting" & vbCrLf & "the evaluation board."
    End If
    
End Sub

Private Sub cmdRefresh_Click()
    Dim cntr As Integer
    Dim sTemp1 As String
    Dim lTemp1 As Long
    
    'Clear the list
    lstUSBDevices.Clear
    lvuUSBDevices.ListItems.Clear
    cmdOK.Enabled = False
    
    'Rescan the USB devices open
    clsEZUSBDev01.GetDevices
    
    'Refresh the device list
    RefreshDeviceList
    
'    'Populate the listbox with all of the USB Devices
'    For cntr = 0 To clsEZUSBDev01.DeviceCount - 1
'        lstUSBDevices.AddItem clsEZUSBDev01.GetDriverName(cntr)
'
'        'Add the device to the list
'        lvuUSBDevices.ListItems.Add cntr + 1, "EZUSB-" & cntr, clsEZUSBDev01.GetDriverName(cntr)
'
'        'Get and display the firware revision
'        sFirmwareRev = clsEZUSBDev01.GetFirmWareVersion(cntr)
'        'Get and display the firware revision
'        sTemp1 = clsEZUSBDev01.GetFirmWareVersion(cntr)
'        lvuUSBDevices.ListItems(cntr + 1).ListSubItems.Add 1, "FirmwareRev" & cntr, sTemp1
'
'        If CDbl(sTemp1) >= 0.3 Then
'            If clsEZUSBDev01.GetHostID(cntr, lTemp1) = 1 Then
'                If lTemp1 = 0 Then
'                    'The evaluation board is available for use by any application
'                    sTemp1 = "Unused"
'                Else
'                    'The evaluation board has been claimed by an application
'                    sTemp1 = CStr(lTemp1)
'                    If lTemp1 = mdiMain.hWnd Then
'                        sTemp1 = "Using"
'                    End If
'                End If
'            Else
'                'The firmware has had an error returning the HostID
'                sTemp1 = "ENA"
'            End If
'        Else
'            'The firmware doesn't support this feature.
'            sTemp1 = "NA"
'        End If
'        'Add the HostID string to the ListView Control
'        lvuUSBDevices.ListItems(cntr + 1).ListSubItems.Add 2, "HostID" & cntr, sTemp1
'
'        If lstUSBDevices.List(cntr) = clsEZUSBDev01.DriverName Then
'            lstUSBDevices.ListIndex = cntr
'        End If
'    Next cntr

End Sub

Private Sub Form_Load()
    Dim cntr As Integer
    Dim cntr1 As Integer
    Dim cntr2 As Integer
    Dim sTemp1 As String 'Used for retrieving firmware and hostids
    Dim lTemp1 As Long
    
    'Set the cancel hit flag
    bCancelHit = False
    
    For cntr1 = 1 To lvuUSBDevices.ColumnHeaders.Count
        'Use a label to resize the item exactly
        lblAutoSize.FontName = lvuUSBDevices.Font.Name
        lblAutoSize.FontSize = lvuUSBDevices.Font.Size
        lblAutoSize.Caption = lvuUSBDevices.ColumnHeaders(cntr1).Text
        lvuUSBDevices.ColumnHeaders(cntr1).Width = lblAutoSize.Width + 350
    Next cntr1
     
    'Make the first column width takeup the xtra
    lvuUSBDevices.ColumnHeaders(1).Width = lvuUSBDevices.Width - (lvuUSBDevices.ColumnHeaders(2).Width + lvuUSBDevices.ColumnHeaders(3).Width + 90)
    
'    'Make sure that the refresh occurs
'    OldDeviceCnt = -1
    
    'Populate the listbox
    RefreshDeviceList
     
'    'Populate the listbox with all of the USB Devices
'    For cntr = 0 To clsEZUSBDev01.DeviceCount - 1
'        lstUSBDevices.AddItem clsEZUSBDev01.GetDriverName(cntr)
'
'        'Add the device to the list
'        lvuUSBDevices.ListItems.Add cntr + 1, "EZUSB-" & cntr, clsEZUSBDev01.GetDriverName(cntr)
'
'        'Get and display the firware revision
'        sTemp1 = clsEZUSBDev01.GetFirmWareVersion(cntr)
'        lvuUSBDevices.ListItems(cntr + 1).ListSubItems.Add 1, "FirmwareRev" & cntr, sTemp1
'
'        If CDbl(sTemp1) >= 0.3 Then
'            If clsEZUSBDev01.GetHostID(cntr, lTemp1) = 1 Then
'                If lTemp1 = 0 Then
'                    'The evaluation board is available for use by any application
'                    sTemp1 = "Unused"
'                Else
'                    'The evaluation board has been claimed by an application
'                    sTemp1 = CStr(lTemp1)
'                    If lTemp1 = mdiMain.hWnd Then
'                        sTemp1 = "Using"
'                    End If
'                End If
'            Else
'                'The firmware has had an error returning the HostID
'                sTemp1 = "ENA"
'            End If
'        Else
'            'The firmware doesn't support this feature.
'            sTemp1 = "NA"
'        End If
'        'Add the HostID string to the ListView Control
'        lvuUSBDevices.ListItems(cntr + 1).ListSubItems.Add 2, "HostID" & cntr, sTemp1
'
'        'lvuUSBDevices.ListItems(cntr + 1).ListSubItems.Add
'        'If a usbdevice has allready been selected then hilight the selected item
'        If clsEZUSBDev01.DriverName = clsEZUSBDev01.GetDriverName(cntr) Then
'            lstUSBDevices.ListIndex = cntr
'            lvuUSBDevices.ListItems(cntr + 1).Selected = True
'        End If
'    Next cntr
    
    'Set this forms font
    'SetFormFont Me, sFont
End Sub

Private Sub lstUSBDevices_Click()
    'They have made a choice allow them to exit
    cmdOK.Enabled = True
End Sub

Public Function ShowDialog(ByVal sTitle As String, ByVal sMsg As String) As String
    'Show the dialog
    Me.Show 1
    
    If bCancelHit = True Then
        ShowDialog = "" 'If the cancel button was hit then return nothing
    Else
        ShowDialog = clsEZUSBDev01.DriverName 'Return the selected device
    End If
    
    Unload Me
End Function

'Refreshes the list box with the current device list
Public Sub RefreshDeviceList()
    Dim cntr As Integer
    Dim sTemp1 As String
    Dim lTemp1 As Long
    
    'Clear the list
'    lstUSBDevices.Clear
    lvuUSBDevices.ListItems.Clear
    
    'Populate the listbox with all of the USB Devices
    For cntr = 0 To clsEZUSBDev01.DeviceCount - 1
'        lstUSBDevices.AddItem clsEZUSBDev01.GetDriverName(cntr)
        
        'Add the device to the list
        lvuUSBDevices.ListItems.Add cntr + 1, "EZUSB-" & cntr, clsEZUSBDev01.GetDriverName(cntr)
        
        'Get and display the firware revision
        sFirmwareRev = clsEZUSBDev01.GetFirmWareVersion(cntr)
        'Get and display the firware revision
        sTemp1 = clsEZUSBDev01.GetFirmWareVersion(cntr)
        lvuUSBDevices.ListItems(cntr + 1).ListSubItems.Add 1, "FirmwareRev" & cntr, sTemp1
        
        If CDbl(sTemp1) >= 0.3 Then
            If clsEZUSBDev01.GetHostID(cntr, lTemp1) = 1 Then
                If lTemp1 = 0 Then
                    'The evaluation board is available for use by any application
                    sTemp1 = "Unused"
                Else
                    'The evaluation board has been claimed by an application
                    sTemp1 = CStr(lTemp1)
                    If lTemp1 = mdiMain.hWnd Then
                        sTemp1 = "Using"
                    End If
                End If
            Else
                'The firmware has had an error returning the HostID
                sTemp1 = "ENA"
            End If
        Else
            'The firmware doesn't support this feature.
            sTemp1 = "NA"
        End If
        'Add the HostID string to the ListView Control
        lvuUSBDevices.ListItems(cntr + 1).ListSubItems.Add 2, "HostID" & cntr, sTemp1
        
        'Select the currently selected device from the list
        If lvuUSBDevices.ListItems(cntr + 1) = clsEZUSBDev01.DriverName Then
            lvuUSBDevices.ListItems(cntr + 1).Selected = True
            'They have made a choice allow them to exit
            cmdOK.Enabled = True
        End If
        
'        If lstUSBDevices.List(cntr) = clsEZUSBDev01.DriverName Then
'            lstUSBDevices.ListIndex = cntr
'        End If
    Next cntr
End Sub

Private Sub lvuUSBDevices_Click()
    Dim lActiveWin As Long
    If lvuUSBDevices.ListItems.Count <> 0 Then
        'They have made a choice allow them to exit
        cmdOK.Enabled = True
        'See if the device that is selected is being controlled by an application
        If IsNumeric(lvuUSBDevices.SelectedItem.ListSubItems(2).Text) Then
            'Flash the window using the selected item
            FlashWindow CLng(lvuUSBDevices.SelectedItem.ListSubItems(2).Text), 1
            MyDelay 1.1
'            FlashWindow CLng(lvuUSBDevices.SelectedItem.ListSubItems(2).Text), 1
'            MyDelay 0.9
'            FlashWindow CLng(lvuUSBDevices.SelectedItem.ListSubItems(2).Text), 1
            'MyDelay 0.5
        End If
    End If
End Sub
'DelayTime - Number of seconds to delay
Private Sub MyDelay(ByVal DelayTime As Single, Optional NoDoEvents)
    Dim Start As Single
    Dim OldTimerVal As Single
    Dim EndTime As Single
    Dim DelayCntr As Long 'used to make sure that
    
    Start = Timer       'Set start time.
    OldTimerVal = Start 'Set the current timer val
    'Calculate the end time
    EndTime = Start + DelayTime
    
    'Setup the delay cntr
    DelayCntr = 0
    
    Do
        'Check for midnight
        If Timer < OldTimerVal Then
            EndTime = EndTime - OldTimerVal
            DelayCntr = 1000 'It is past midnight so refresh the OldTimerVal
        End If
        
        If DelayCntr >= 1000 Then
            OldTimerVal = Timer 'Get the current timer value
            DelayCntr = 0 'Reset the counter
        End If
           
        'Increment the delay counter
        DelayCntr = DelayCntr + 1
        
        'If the user enters any value for nodoevents
        If IsMissing(NoDoEvents) Then
            DoEvents   ' Yield to other processes.
        Else
        End If
    Loop While Timer < EndTime
End Sub

Private Sub tmrRefresh_Timer()
    cmdRefresh_Click
End Sub
