VERSION 5.00
Begin VB.Form frmTWCalc 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Tuning Word Calculator"
   ClientHeight    =   4455
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6615
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   4455
   ScaleWidth      =   6615
   Begin VB.Frame fraAutoXfer 
      Height          =   1095
      Left            =   120
      TabIndex        =   20
      Top             =   3240
      Width           =   6375
      Begin VB.CheckBox chkSendToDest 
         Caption         =   "Auto Transfer Tuning Word to Destination Field on RegDebug Form"
         Height          =   375
         Left            =   120
         TabIndex        =   23
         Top             =   120
         Value           =   1  'Checked
         Width           =   6135
      End
      Begin VB.ComboBox cmbReg 
         Height          =   315
         ItemData        =   "frmTWCalc.frx":0000
         Left            =   1440
         List            =   "frmTWCalc.frx":003A
         Style           =   2  'Dropdown List
         TabIndex        =   21
         Top             =   600
         Width           =   1095
      End
      Begin VB.Label lblDestReg 
         Caption         =   "Destination Field:"
         Height          =   255
         Left            =   120
         TabIndex        =   22
         Top             =   600
         Width           =   1335
      End
   End
   Begin VB.CommandButton cmdCalcTW 
      Caption         =   "Calculate Tuning Word"
      Height          =   375
      Left            =   120
      TabIndex        =   10
      Top             =   2760
      Width           =   1935
   End
   Begin VB.Frame fraTw 
      Caption         =   "Tuning Word"
      Height          =   1335
      Left            =   120
      TabIndex        =   9
      Top             =   1320
      Width           =   6375
      Begin VB.TextBox txtTWDec 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   120
         Locked          =   -1  'True
         MaxLength       =   15
         MultiLine       =   -1  'True
         TabIndex        =   18
         Text            =   "frmTWCalc.frx":00AE
         ToolTipText     =   "Enter the decimal value of the tuning word you want."
         Top             =   360
         Width           =   1335
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   0
         Left            =   4920
         Locked          =   -1  'True
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   16
         Text            =   "frmTWCalc.frx":00B9
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   1
         Left            =   3960
         Locked          =   -1  'True
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   15
         Text            =   "frmTWCalc.frx":00C2
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   2
         Left            =   3000
         Locked          =   -1  'True
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   14
         Text            =   "frmTWCalc.frx":00CB
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   3
         Left            =   2040
         Locked          =   -1  'True
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   13
         Text            =   "frmTWCalc.frx":00D4
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         Enabled         =   0   'False
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   4
         Left            =   1080
         Locked          =   -1  'True
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   12
         Text            =   "frmTWCalc.frx":00DD
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         Enabled         =   0   'False
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   5
         Left            =   120
         Locked          =   -1  'True
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   11
         Text            =   "frmTWCalc.frx":00E6
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.Label lblDec 
         Caption         =   "Dec"
         Height          =   255
         Left            =   1560
         TabIndex        =   19
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblTWBin 
         Alignment       =   1  'Right Justify
         BackStyle       =   0  'Transparent
         Caption         =   "Bin"
         Height          =   195
         Left            =   5880
         TabIndex        =   17
         Top             =   840
         Width           =   315
      End
   End
   Begin VB.TextBox txtOutputFreq 
      Height          =   285
      Left            =   2040
      TabIndex        =   2
      Text            =   "1.000000000"
      Top             =   840
      Width           =   3255
   End
   Begin VB.TextBox txtTWRes 
      Height          =   285
      Left            =   2040
      MaxLength       =   2
      TabIndex        =   0
      Text            =   "32"
      Top             =   120
      Width           =   495
   End
   Begin VB.TextBox txtSysClk 
      Height          =   285
      Left            =   2040
      MaxLength       =   7
      TabIndex        =   1
      Text            =   "500.000"
      Top             =   480
      Width           =   855
   End
   Begin VB.Label lblMHz 
      Caption         =   "MHz"
      Height          =   255
      Index           =   1
      Left            =   5400
      TabIndex        =   8
      Top             =   840
      Width           =   615
   End
   Begin VB.Label lblOutputFreq 
      Caption         =   "Output Frequency:"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   840
      Width           =   1815
   End
   Begin VB.Label lblBits 
      Caption         =   "Bits"
      Height          =   255
      Left            =   2640
      TabIndex        =   6
      Top             =   120
      Width           =   495
   End
   Begin VB.Label lblTWResolution 
      Caption         =   "Tuning Word Resolution:"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   120
      Width           =   1815
   End
   Begin VB.Label lblMHz 
      Caption         =   "MHz"
      Height          =   255
      Index           =   0
      Left            =   3000
      TabIndex        =   4
      Top             =   480
      Width           =   615
   End
   Begin VB.Label lblSysClk 
      Caption         =   "System Clock:"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   480
      Width           =   1815
   End
End
Attribute VB_Name = "frmTWCalc"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private iTWBits As Integer
Private dSysClkFreq As Double
Private dOutputFreq As Double
Private vDecTunningWord As Variant

Private Sub cmdCalcTW_Click()
    Dim iCntr As Integer
    Dim iTBIndex As Integer
    
    dOutFreq = CDbl(txtOutputFreq.Text)
    dSysClkFreq = CDbl(txtSysClk.Text)
    iTWBits = CInt(txtTWRes.Text)
    
    If CDbl(txtOutputFreq.Text) >= CDbl(txtSysClk.Text) Then
        MsgBox "The output frequency should not exceed the system clock frequency!", vbOKOnly + vbInformation, "Warning!"
    ElseIf CDbl(txtOutputFreq.Text) >= (CDbl(txtSysClk.Text) * 0.4) Then
        MsgBox "The output frequency should not exceed the 40% of the system clock frequency!", vbOKOnly + vbInformation, "Warning!"
    End If
    
    txtTWDec.Text = CalcDecTuningWord(dOutFreq, dSysClkFreq, iTWBits)
    
    If chkSendToDest.Value = 1 And IsLoaded("frmRegDebug") Then
        If cmbReg.ListIndex = 0 Then
            iTBIndex = 9
        Else
            iTBIndex = 20 + ((cmbReg.ListIndex - 1) * 4)
        End If
        
        For iCntr = 0 To 3
            frmRegDebug.txtRegByte(iTBIndex).Text = txtTW(iCntr).Text
            iTBIndex = iTBIndex + 1
        Next iCntr
    End If
End Sub

Private Sub Form_Load()
    cmbReg.ListIndex = 0
End Sub

Private Sub txtOutputFreq_KeyPress(KeyAscii As Integer)
    Dim bCncl As Boolean
    KeyAscii = NumericKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 13: 'Enter key
            KeyAscii = 0
            txtOutputFreq_Validate bCncl
            If bCncl <> True Then
                txtOutputFreq.SetFocus
            End If
        Case 32: 'Space key
            KeyAscii = 0
        Case 43, 45: 'Plus and Minus Sign
            KeyAscii = 0
    End Select
End Sub

Private Sub txtOutputFreq_Validate(Cancel As Boolean)
    Dim sFormatStr As String
    
    If txtOutputFreq.Text = "" Or Not IsNumeric(txtOutputFreq.Text) Then
        txtOutputFreq.Text = "400.000" 'Default value
    End If
    
    sFormatStr = GetFormatStr(CDbl(txtSysClk.Text), CInt(txtTWRes))
    
    'txtOutputFreq.Text = Format(CDbl(txtOutputFreq.Text), "0.000000000000000")  'sFormatStr)
    
    Cancel = False
    
End Sub

Private Sub txtSysClk_KeyPress(KeyAscii As Integer)
    Dim bCncl As Boolean
    KeyAscii = NumericKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 13: 'Enter key
            KeyAscii = 0
            txtSysClk_Validate (bCncl)
            If bCncl <> True Then
                txtOutputFreq.SetFocus
            End If
        Case 32: 'Space Key
            KeyAscii = 0
        Case 43, 45: 'Plus and Minus Keys
            KeyAscii = 0
    End Select
End Sub

Private Sub txtSysClk_Validate(Cancel As Boolean)
    
    If txtSysClk.Text = "" Or Not IsNumeric(txtSysClk.Text) Then
        txtSysClk.Text = "400.000" 'Default value
    End If
    
    If txtSysClk.Text <= 0 Then
        MsgBox "The system clock can not be <= 0.", vbOKOnly + vbInformation
        txtSysClk.Text = "400.000"
    End If
    
    txtSysClk.Text = Format(CDbl(txtSysClk.Text), "0.000")
    
End Sub

Private Sub txtTWDec_Change()
    Dim sTWBin As String
    Dim iCntr As Integer
    Dim iByteCntr As Integer
    Dim iTBIndex As Integer 'Serves as a text box index for splitting the binary
    
    'Convert the text in twdec to a decimal value
    vDecTunningWord = CDec(txtTWDec.Text)
    
    'Convert the decimal value to a binary value
    sTWBin = cbaseDec2Bin(vDecTunningWord, iTWBits)
    
    iTBIndex = (iTWBits / 8) - 1
    iByteCntr = 1
    For iCntr = 0 To (iTWBits / 8) - 1
        txtTW(iTBIndex).Text = Mid(sTWBin, iByteCntr, 8)
        iTBIndex = iTBIndex - 1
        iByteCntr = iByteCntr + 8
    Next iCntr
End Sub

Private Sub txtTWRes_KeyPress(KeyAscii As Integer)
    Dim bCncl As Boolean
    KeyAscii = NumericIntKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 13: 'Enter key
            KeyAscii = 0
            txtTWRes_Validate (bCncl)
            If bCncl <> True Then
                txtSysClk.SetFocus
            End If
        Case 32: 'Space key
            KeyAscii = 0
        Case 43, 45:
            KeyAscii = 0
    End Select
End Sub

Private Sub txtTWRes_Validate(Cancel As Boolean)
    Dim iCntr As Integer
    
    If txtTWRes.Text = "" Or Not IsNumeric(txtTWRes.Text) Then
        txtTWRes.Text = "32" 'Default value
    End If
    
    If txtTWRes.Text > 48 Or txtTWRes.Text < 8 Then
        MsgBox "Tuning word resolution >= 8 and <= 48.", vbOKOnly + vbInformation
        txtTWRes.Text = 32
    End If
    
    'See if the
    If (CInt(txtTWRes.Text) Mod 8) <> 0 Then
        MsgBox "Must be a multiple of 8.", vbOKOnly + vbInformation
        SelectAllTxt txtTWRes
        Cancel = True
    End If

    If Cancel = False Then
        For iCntr = 0 To 5
            txtTW(iCntr).Enabled = True
        Next iCntr
        
        For iCntr = 0 To 5
            If iCntr <= (CInt(txtTWRes.Text) / 8) - 1 Then
                txtTW(iCntr).Enabled = True
            Else
                txtTW(iCntr).Enabled = False
            End If
        Next iCntr
    End If
End Sub
'This function will calculate the decimal value of a tunning word given
'the CarrierFreq, Sysclock and NumberOfBits to generate.
Private Function CalcDecTuningWord(ByVal CarrierFreq As Double, ByVal SysClk As Double, ByVal TWBitRes As Integer) As Variant
    
    Dim TunningWord As Variant
    Dim SysClock As Variant
    Dim NumberOfBits As Variant '114 maximum
    
    'Convert the bit res value to a decimal value
    NumberOfBits = CDec(TWBitRes)
    
    'Convert the sysclk value to a decimal value
    'Use the sysclock passed to the function
    SysClock = CDec(SysClk)
    
    'Calculate the tunning word value
    TunningWord = Round(CDec((CDec(CarrierFreq) / SysClock) * (2 ^ NumberOfBits)))
    CalcDecTuningWord = TunningWord
    
End Function
'Calculates the output frequency given the tunning word
Private Function DecTWToCarrierFreq(ByVal DecTW As Variant, ByVal SysClk As Double, ByVal TWBitRes As Integer) As Variant
    Dim SysClock As Variant
    Dim NumberOfBits As Variant '114 maximum
    
    'Convert to decimal value
    NumberOfBits = CDec(TWBitRes)
        
    'Use the sysclock passed to the function
    SysClock = CDec(SysClk)
    
    'Calculate the carrier frequency
    DecTWToCarrierFreq = CDec((DecTW / (2 ^ NumberOfBits)) * SysClock)
End Function

Private Function GetFormatStr(ByVal SysClk As Double, ByVal TWBitRes As Integer) As String
    Dim iOSLen As Integer
    Dim sOutFreq As String
    
    sTWLSB = cbaseDec2Bin(1, TWBitRes)
    
    sOutFreq = CStr(DecTWToCarrierFreq(1, SysClk, TWBitRes))
    
    iOSLen = Len(sOutFreq)
    
    GetFormatStr = "0." & String(iOSLen - 2, "0")
End Function

