VERSION 5.00
Begin VB.Form frmMultichipSync 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Multi-Device Sync"
   ClientHeight    =   4575
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   3135
   Icon            =   "frmMultichipSync.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   4575
   ScaleWidth      =   3135
   Begin VB.Timer tmrLoadFlash 
      Interval        =   200
      Left            =   2520
      Top             =   3600
   End
   Begin VB.Frame fraAutoSync 
      Caption         =   "Auto Sync"
      Height          =   2775
      Left            =   240
      TabIndex        =   5
      Top             =   840
      Width           =   2655
      Begin VB.CheckBox chkMaskStatus 
         Caption         =   "Sync Status Mask "
         Height          =   255
         Left            =   120
         TabIndex        =   10
         ToolTipText     =   "Prevents the sync status from being updated."
         Top             =   2400
         Width           =   1815
      End
      Begin VB.ListBox lstSysClkOffset 
         Height          =   840
         ItemData        =   "frmMultichipSync.frx":014A
         Left            =   120
         List            =   "frmMultichipSync.frx":014C
         TabIndex        =   9
         ToolTipText     =   "Specifies when you expect to receive the sync pulse from the master."
         Top             =   960
         Width           =   2415
      End
      Begin VB.CheckBox chkAutoSync 
         Caption         =   "Auto Sync Enable "
         Height          =   255
         Left            =   120
         TabIndex        =   6
         ToolTipText     =   "Puts the DUT in Slave Mode"
         Top             =   360
         Width           =   1815
      End
      Begin VB.Label lblSyncStatus 
         Caption         =   "Sync Status"
         Height          =   255
         Left            =   360
         TabIndex        =   8
         Top             =   2040
         Width           =   975
      End
      Begin VB.Image imgSyncStatusLED 
         Height          =   180
         Left            =   120
         Picture         =   "frmMultichipSync.frx":014E
         ToolTipText     =   "Indicates the "
         Top             =   2040
         Width           =   180
      End
      Begin VB.Label lblSysClkOffset 
         Caption         =   "Expected SysClk Period:"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   720
         Width           =   2175
      End
   End
   Begin VB.CommandButton cmdRead 
      Caption         =   "READ"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1680
      TabIndex        =   4
      Top             =   4080
      Width           =   1335
   End
   Begin VB.CommandButton cmdLoad 
      Caption         =   "LOAD"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   4080
      Width           =   1335
   End
   Begin VB.CheckBox chkSyncDriverEnable 
      Caption         =   "Sync Driver Enable "
      Height          =   255
      Left            =   360
      TabIndex        =   2
      ToolTipText     =   "Puts the DUT in Master Mode"
      Top             =   3720
      Width           =   2175
   End
   Begin VB.CheckBox chkSoftManualSync 
      Caption         =   "Software Manual Sync "
      Height          =   255
      Left            =   360
      TabIndex        =   1
      Top             =   480
      Width           =   2295
   End
   Begin VB.CheckBox chkHardManualSync 
      Caption         =   "Hardware Manual Sync "
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   120
      Width           =   2295
   End
   Begin VB.Label lblLoadFlash 
      BackColor       =   &H000080FF&
      Height          =   435
      Left            =   90
      TabIndex        =   11
      Top             =   4050
      Visible         =   0   'False
      Width           =   1395
   End
End
Attribute VB_Name = "frmMultichipSync"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim IsUpdating As Boolean
Public bNeedsLoading As Boolean


Private Sub chkAutoSync_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 2, 7, chkAutoSync.value
    End If
End Sub

Private Sub chkHardManualSync_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 1, chkHardManualSync.value
    End If
End Sub

Private Sub chkMaskStatus_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 2, 4, chkMaskStatus.value
    End If
End Sub

Private Sub chkSoftManualSync_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 0, chkSoftManualSync.value
    End If
End Sub

Private Sub chkSyncDriverEnable_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 2, 6, chkSyncDriverEnable.value
    End If
End Sub

Private Sub cmdLoad_Click()
    Dim bAIOU As Boolean
    
    'Store the current state of AutoIOUpdate
    bAIOU = EvBd.AutoIOUpdate
    
    'Make adjustments for full form load
    If frmOptions.chkIOUAfterFullFormLoad.value = 1 Then
        EvBd.AutoIOUpdate = False
    End If
    
    'Disable the load button until finished so that the user can't
    'click it again until finished
    Screen.MousePointer = 11
    cmdLoad.Enabled = False
    
    'Load the data into the DUT
    EvBd.USBSerialLoad 1, EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
    
'    'Turn on auto IOUpdate to allow one after the last register wrote
'    EvBd.AutoIOUpdate = True
    
    'Load the last control register and do an IO Update
    EvBd.USBSerialLoad 2, EvBd.GetRegMapValue(rm9911_NewRegMapVals, 2)
    
    
    'Re-Enable the load button
    Screen.MousePointer = 1
    cmdLoad.Enabled = True
    cmdLoad.SetFocus
    
    'Make adjustments for full form load
    If frmOptions.chkIOUAfterFullFormLoad.value = 1 And bAIOU Then
        'Send the IOUpdate
        EvBd.StrobeIOUpdate
        
        'Turn IOUpdates back on
        EvBd.AutoIOUpdate = True
    Else
        'Restore AutoIOUpdate to its origional state
        EvBd.AutoIOUpdate = bAIOU
    End If
    
    'Do a read
    cmdRead_Click
End Sub

Private Sub cmdRead_Click()
    'Read back the values from the DUT
    EvBd.USBSerialRead 1
    EvBd.USBSerialRead 2
    
    'Update the form values
    UpdateFormVals
End Sub

Private Sub Form_Activate()
    Dim dCntr As Double
    Dim dSysClkPeriod As Double
    Dim sOrdinal As String
    
    'Get the sysclk period
    'dSysClkPeriod = 1 / CDbl(frmControl.txtSysClkTxt.Text)
    
    'Populate the sysclk offset listbox
    lstSysClkOffset.Clear
    
    For dCntr = 0 To 15
        Select Case dCntr
            Case 0
                sOrdinal = "st"
            Case 1
                sOrdinal = "nd"
            Case 2
                sOrdinal = "rd"
            Case Else
                sOrdinal = "th"
        End Select
        lstSysClkOffset.AddItem dCntr & " - " & dCntr + 1 & sOrdinal & " SysClk Period"
    Next dCntr
    
    'Update the form values
    Me.UpdateFormVals
End Sub

Private Sub Form_Load()
    'Update the form values
'    UpdateFormVals
End Sub
'Updates the controls with the current register map values
Public Sub UpdateFormVals()
    Dim sRegVal1 As String
    Dim sRegVal2 As String
    Dim sDummyVal As String
    Dim iDummyVal As String
        
    'Get registermap values
    'sRegVal0 = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 0)
    sRegVal1 = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
    sRegVal2 = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 2)
        
    IsUpdating = True
    
    'Update the accumulator control section
    chkHardManualSync.value = CLng(Mid(sRegVal1, 23, 1))
    chkSoftManualSync.value = CLng(Mid(sRegVal1, 24, 1))
    
    'Update the ChargePumpCtrl listbox
    lstSysClkOffset.ListIndex = cbaseBinS2Dec(Mid(sRegVal2, 13, 4))
    
    chkAutoSync.value = CLng(Mid(sRegVal2, 9, 1))
    chkSyncDriverEnable.value = CLng(Mid(sRegVal2, 10, 1))
    chkMaskStatus.value = CLng(Mid(sRegVal2, 12, 1))
    
    'Display the value found
    imgSyncStatusLED.Picture = frmGraphics.imgGreenLed(CLng(Mid(sRegVal2, 11, 1))).Picture
    
    IsUpdating = False
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Do not allow the user to close the window instead
    'just hide it.
    If UnloadMode = vbFormControlMenu Then
        Cancel = 1
    End If
    Me.Hide
    frmControl.chkMultiChipSync.value = 0
    'Check the menu used to show the window
'    mdiMain.mnuViewControlWindow.Checked = False
End Sub
'This sub changes the GUI depending on the engineering mode which is set by the
'global variable iEngMode
Public Sub SetDebugMode()
    Select Case iEngMode
        Case 1: 'Debug Mode
        Case 2: 'Engineering Mode
        Case 3: 'Extended Engineering Mode
        Case Else 'Normal Mode
    End Select
End Sub

Private Sub lstSysClkOffset_Click()
    Dim sRegVal As String
    Dim sBitVal As String
    
    'Get the current register map value
    sRegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, &H2)
    'Generate the bit value for the delay offset
    sBitVal = cbaseDec2Bin(lstSysClkOffset.ListIndex, 4)
    'Build the new register map value
    sRegVal = Left(sRegVal, Len(sRegVal) - 4) & sBitVal
    'Assign the new value
    EvBd.SetRegMapValue rm9911_NewRegMapVals, &H2, sRegVal
End Sub

Private Sub tmrLoadFlash_Timer()
    Dim iAddrCntr As Integer
    Dim sCRegVal As String
    Dim sNRegVal As String
    Dim bNdsLdng As Boolean
    
    'Only address one register
    iAddrCntr = 1 'Register 1
    
    'Initialize the flags value
    bNdsLdng = False
    
    'Loop through each of the channels
    For iAddrCntr = 1 To 2
        'Get the register map values for each register
        sCRegVal = EvBd.GetRegMapValue(rm9911_CurRegMapVals, iAddrCntr)
        sNRegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, iAddrCntr)
                
        'Filter out bits that aren't set by this form
        Select Case iAddrCntr
            Case 1:
                sCRegVal = Right(sCRegVal, 2)
                sNRegVal = Right(sNRegVal, 2)
            Case 2:
                sCRegVal = Mid(sCRegVal, 9, 4) & Right(sCRegVal, 2)
                sNRegVal = Mid(sNRegVal, 9, 4) & Right(sNRegVal, 2)
        End Select
        
        
        'If the values are different then set the needs loading flag
        If sCRegVal <> sNRegVal Then
            bNdsLdng = True
        End If
    Next iAddrCntr
    
    'If the needs loading flag is set then flash the label
    If bNdsLdng Then
        'Flash the label
        If lblLoadFlash.Visible = True Then
            lblLoadFlash.Visible = False
        Else
            lblLoadFlash.Visible = True
        End If
        lblLoadFlash.Refresh
    Else
        'Hide the flash label
        lblLoadFlash.Visible = False
        lblLoadFlash.Refresh
    End If
    
    'Set the forms publicly available variable
    bNeedsLoading = bNdsLdng
End Sub

