VERSION 5.00
Begin VB.Form frmIOInterface 
   BorderStyle     =   3  'Fixed Dialog
   ClientHeight    =   3375
   ClientLeft      =   45
   ClientTop       =   45
   ClientWidth     =   2535
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3375
   ScaleWidth      =   2535
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Visible         =   0   'False
   Begin VB.Frame fraIOPort 
      Caption         =   "I/O Port"
      Height          =   2895
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   2295
      Begin VB.PictureBox pbxXPThemeFix 
         BorderStyle     =   0  'None
         Height          =   2535
         Left            =   120
         ScaleHeight     =   2535
         ScaleWidth      =   2055
         TabIndex        =   4
         Top             =   240
         Width           =   2055
         Begin VB.CommandButton cmdIOReset 
            Caption         =   "I/O Reset"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   375
            Index           =   0
            Left            =   120
            TabIndex        =   10
            ToolTipText     =   "Strobes the I/OReset pin"
            Top             =   120
            Width           =   1815
         End
         Begin VB.Frame fraSerialComm 
            Caption         =   "Serial Comm"
            Height          =   1935
            Left            =   0
            TabIndex        =   5
            Top             =   600
            Width           =   2055
            Begin VB.CommandButton cmdLoad 
               Caption         =   "LOAD"
               BeginProperty Font 
                  Name            =   "MS Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   700
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   375
               Left            =   240
               Style           =   1  'Graphical
               TabIndex        =   8
               Top             =   1440
               Width           =   1575
            End
            Begin VB.ComboBox lsbSerialIOMode 
               Height          =   315
               ItemData        =   "frmIOInterface.frx":0000
               Left            =   120
               List            =   "frmIOInterface.frx":0010
               Style           =   2  'Dropdown List
               TabIndex        =   7
               ToolTipText     =   "Sets the SDIO Input Only bit value in the control register"
               Top             =   960
               Width           =   1815
            End
            Begin VB.CheckBox chkLSBFirst 
               Caption         =   "LSB First"
               Height          =   255
               Left            =   120
               TabIndex        =   6
               ToolTipText     =   "Sets the LSB first bit in the control register"
               Top             =   360
               Width           =   1095
            End
            Begin VB.Label lblLoadFlash 
               BackColor       =   &H000080FF&
               Height          =   435
               Left            =   210
               TabIndex        =   12
               Top             =   1410
               Visible         =   0   'False
               Width           =   1635
            End
            Begin VB.Label lbl2or3Wire 
               Caption         =   "Serial I/O Mode:"
               Height          =   255
               Left            =   120
               TabIndex        =   9
               Top             =   720
               Width           =   1335
            End
         End
      End
   End
   Begin VB.Timer tmrLoadFlash 
      Interval        =   200
      Left            =   0
      Top             =   2880
   End
   Begin VB.PictureBox pbxFakeTitleBar 
      Align           =   1  'Align Top
      BackColor       =   &H80000002&
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   0
      ScaleHeight     =   255
      ScaleWidth      =   2535
      TabIndex        =   2
      Top             =   0
      Width           =   2535
      Begin VB.Image imgFormCloseButton 
         Height          =   240
         Left            =   2280
         Picture         =   "frmIOInterface.frx":005E
         Tag             =   "0"
         Top             =   0
         Width           =   240
      End
      Begin VB.Image imgShade 
         Height          =   240
         Left            =   2040
         Picture         =   "frmIOInterface.frx":01A8
         Tag             =   "0"
         Top             =   0
         Width           =   240
      End
      Begin VB.Label lblFakeTitleBarText 
         BackStyle       =   0  'Transparent
         Caption         =   "DUT I/O"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000009&
         Height          =   255
         Left            =   75
         TabIndex        =   3
         Top             =   30
         Width           =   855
      End
   End
   Begin VB.PictureBox picRollUpDwn 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   2160
      ScaleHeight     =   255
      ScaleWidth      =   2295
      TabIndex        =   0
      Tag             =   "Down"
      Top             =   4080
      Visible         =   0   'False
      Width           =   2295
   End
   Begin VB.Label lblSDMarker 
      Height          =   255
      Left            =   2400
      TabIndex        =   11
      Top             =   3360
      Width           =   255
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   0
      Left            =   120
      Picture         =   "frmIOInterface.frx":02F2
      Top             =   4080
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   1
      Left            =   480
      Picture         =   "frmIOInterface.frx":043C
      Top             =   4080
      Width           =   240
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   2
      Left            =   120
      Picture         =   "frmIOInterface.frx":0586
      Top             =   4320
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   3
      Left            =   480
      Picture         =   "frmIOInterface.frx":06D0
      Top             =   4320
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgFormCloseBtnBfr 
      Height          =   240
      Index           =   0
      Left            =   1080
      Picture         =   "frmIOInterface.frx":081A
      Top             =   4080
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgFormCloseBtnBfr 
      Height          =   240
      Index           =   1
      Left            =   1320
      Picture         =   "frmIOInterface.frx":0964
      Top             =   4080
      Visible         =   0   'False
      Width           =   240
   End
End
Attribute VB_Name = "frmIOInterface"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'private variable to store property values
Private bNeedsLoading As Boolean
'Should be set true before updating control values
Private IsUpdating As Boolean
Private DutsPoweredDown As Integer

Public Sub PowerDownForm(ByVal DUTNum As Integer, ByVal bPowDwn As Boolean)
    Dim cntr As Integer
    Dim Cntrl As Control
    
    'Make sure that dutnum is either 1 or 2
    If DUTNum <> 1 Then
        DUTNum = 2
    End If
    
    chkLSBFirst.Enabled = Not bPowDwn
    lbl2or3Wire.Enabled = Not bPowDwn
    lsbSerialIOMode.Enabled = Not bPowDwn
    cmdLoad.Enabled = Not bPowDwn
    fraSerialComm.Enabled = Not bPowDwn
End Sub

'Refreshes the values in all of the controls to match the values in the
'register map window
'Used to refresh the form after a setup file has been loaded.
Public Sub RefreshControls()
    'Refresh the controls with the current value of the bit
    'Set the isupdating flag to true
    IsUpdating = True
        
    'Control Register 00h
    lsbSerialIOMode.ListIndex = EvBd.SPI_IOMode
    chkLSBFirst.value = EvBd.SPI_LSB_First
    
    'Set the isupdating flag to false
    IsUpdating = False
End Sub

Private Sub chkLSBFirst_Click()
    'Set the bit value in the register map
    'If the form isn't being updated then set the bit in the registermap
'    If Not IsUpdating Then
''        mvarNeedsLoading = True
'        'Only update the regmap value if the UI isn't updating
'        If IsUpdating = False Then
'            EvBd.SetRegMapBitValue sd9956_DUT1, rm9956_NewRegMapVals, RMA9956_CFR1, 15, chkLSBFirst.Value
'            EvBd.SetRegMapBitValue sd9956_DUT2, rm9956_NewRegMapVals, RMA9956_CFR1, 15, chkLSBFirst.Value
'        End If
'    End If
    
    'Set LSB Frist Mode
    If chkLSBFirst.value = 1 Then
        EvBd.SPI_LSB_First = True
    Else
        EvBd.SPI_LSB_First = False
    End If
End Sub



Private Sub chkLSBFirst_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
'This code is just for future reference and is not used
'    If Button = vbLeftButton Then
'        With optIOInterface(Index)
'        If X >= 0 And X <= .Width And Y >= 0 And Y <= .Height Then
'            'This code only runs when the checkbox is clicked
'            EvalBoard.SPMode = Index
'            frmDebug.RefreshStatus
'        End If
'        End With
'    End If
End Sub

Private Sub cmdIOReset_Click(Index As Integer)
    'Send an IOReset
    EvBd.SendIOReset
End Sub


Private Sub cmdLoad_Click()
    Dim sRegVal As String
    'Set the mouse pointer to indicate that the software is busy
    Screen.MousePointer = 11
    
    'Get the new reg map value and load it
    sRegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 0)
    EvBd.USBSerialLoad 0, sRegVal

    'Set the mouse pointer back to default
    Screen.MousePointer = 0
End Sub

Private Sub Form_Activate()
    'Check the menu used to show the window
'    mdiMain.mnuViewIOInterface.Checked = True
End Sub

Private Sub Form_Load()
    'Make this form modeless
    Call MakeFormModeless(Me, mdiMain.hWnd)
    
    RefreshControls
'    'Initialize the window blind button
'    picRollUpDwn_MouseMove vbLeftButton, 0, -1, -1
'
'    'Initialize the controls on the form to
'    'represent the values in the register map
'    Me.RefreshControls
'
'    'Set the needs loading flag to false
'    NeedsLoading = False
    
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Do not allow the user to close the window instead
    'just hide it.
    If UnloadMode = vbFormControlMenu Then
        Cancel = 1
    End If
    Me.Hide
        
'    mdiMain.mnuViewIOInterface.Checked = False

'    frmControl.IsUpdating = True
'    frmControl.chkIOInterfaceWnd.Value = 0
'    frmControl.IsUpdating = False

'    frmControl.chkIOInterface.Value = 0
'    mdiMain.tlbMainToolBar.Buttons("ioconfig").Value = tbrUnpressed
    
    
    'Unpress its toolbar button
    'mdiMain.tbrMain.Buttons("IOToolWindow").value = tbrUnpressed
End Sub

Private Sub optIOInterface_Click()
    'This code makes a MouseUp event like a Click event
    'This is usefull for making a check boxes where you want something to
    'happen when the checkbox is clicked and not when its value changes.
    'Checkboxes have an iritating feature where they fire the click event
    'when the value changes.
'    If optIOInterface(0).value = True Then
        'If they choose to use the serial I/O Interface then
        'enable all of the controls for configuring
        'the serial I/O Interface
'        chkLSBFirst.Enabled = True
'        lbl2or3Wire.Enabled = True
'        lsbIOMode2or3Wire.Enabled = True
'        cmdLoadSerialCommInfo.Enabled = True
'        fraSerialComm.Enabled = True
'        cmdIOReset.Enabled = True
'    Else
        'If they choose to use the parallel I/O Interface then
        'disable all of the controls for configuring
        'the serial I/O Interface
'        chkLSBFirst.Enabled = False
'        lbl2or3Wire.Enabled = False
'        lsbIOMode2or3Wire.Enabled = False
'        cmdLoadSerialCommInfo.Enabled = False
'        fraSerialComm.Enabled = False
'        cmdIOReset.Enabled = False
'    End If
End Sub

Private Sub optIOInterface_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
'    If Button = vbLeftButton Then
'        With optIOInterface(Index)
'        If X >= 0 And X <= .Width And Y >= 0 And Y <= .Height Then
'            'This code only runs when the checkbox is clicked
'            EvalBoard.SPMode = Index
'            frmDebug.RefreshStatus
'        End If
'        End With
'    End If
End Sub

Private Sub imgFormCloseButton_Click()
    Dim Cancel As Integer
    Dim umode As Integer
    Form_QueryUnload Cancel, umode
End Sub

Private Sub imgFormCloseButton_DblClick()
    Dim Cancel As Integer
    Dim umode As Integer
    Form_QueryUnload Cancel, umode
End Sub

Private Sub imgFormCloseButton_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Show the pressed state
        imgFormCloseButton.Tag = 1
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(1).Picture
    End If
End Sub

Private Sub imgFormCloseButton_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Show the pressed state
        imgFormCloseButton.Tag = 1
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(1).Picture
    Else
        'Show the unpressed state
        imgFormCloseButton.Tag = 0
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(0).Picture
    End If
End Sub

Private Sub imgFormCloseButton_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Show the unpressed state
        imgFormCloseButton.Tag = 0
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(0).Picture
    End If
End Sub

Private Sub imgShade_Click()
    'Check the form state if
    If imgShade.Tag = "0" Or imgShade.Tag = "2" Then
        imgShade.Tag = "1"
        imgShade.Picture = imgShadeBfr(1).Picture
        Me.Height = 345
    Else
        imgShade.Tag = "0"
        imgShade.Picture = imgShadeBfr(0).Picture
        Me.Height = lblSDMarker.Top + (8 * Screen.TwipsPerPixelY)
    End If
End Sub

Private Sub imgShade_DblClick()
    imgShade_Click
End Sub

Private Sub imgShade_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Select the proper button pressed picture
        If imgShade.Tag = "0" Then
            imgShade.Tag = "2"
        Else
            imgShade.Tag = "3"
        End If
        'Draw the picture
        imgShade.Picture = imgShadeBfr(imgShade.Tag).Picture
    End If
End Sub

Private Sub imgShade_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Select the proper button pressed picture
        If imgShade.Tag = "2" Then
            imgShade.Tag = "0"
        Else
            imgShade.Tag = "1"
        End If
        'Draw the picture
        imgShade.Picture = imgShadeBfr(imgShade.Tag).Picture
    End If
End Sub

Private Sub lblFakeTitleBarText_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    pbxFakeTitleBar_MouseDown Button, Shift, X, Y
End Sub

Private Sub lsbSerialIOMode_Click()
    'Set the I/O Mode
    EvBd.SPI_IOMode = lsbSerialIOMode.ListIndex
End Sub

Private Sub pbxFakeTitleBar_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    'Move the form based on the user clicking
    If Button = 1 Then
        ReleaseCapture
        SendMessage Me.hWnd, &HA1, 2, 0&
    End If
End Sub

Private Sub picRollUpDwn_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
'    If Button = vbLeftButton Then
'        With picRollUpDwn
'        If X >= 0 And X <= .Width And Y >= 0 And Y <= .Height Then
'            'Draw button hilight
'            .ForeColor = &H80000014
'            picRollUpDwn.Line (.Width - 15, 0)-(.Width - 15, .Height)
'            picRollUpDwn.Line (0, .Height - 15)-(.Width, .Height - 15)
'            'Draw button shadow
'            .ForeColor = &H80000015
'            picRollUpDwn.Line (0, 0)-(.Width, 0)
'            picRollUpDwn.Line (0, 0)-(0, .Height)
'        End If
'
'        'If the form is rolled down then draw the up arrow
'        If .Tag = "Down" Then
'            'Draw the up arrow
'            .ForeColor = &H80000014
'            picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 3)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
'            .ForeColor = &H80000015
'            picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
'            picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 3)
'        Else
'            'Draw the down arrow
'            .ForeColor = &H80000014
'            picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 13)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
'            picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
'            .ForeColor = &H80000015
'            picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 13)
'        End If
'        End With
'    End If
End Sub

Private Sub picRollUpDwn_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'Static CtrMov As Boolean
'With picRollUpDwn 'Change this 'txtCPIsetResValue' to your control name
'    If (X < 0) Or (Y < 0) Or (X > .Width) Or (Y > .Height) Then
'        ReleaseCapture
'        CtrMov = False
'
'        'Put here your code to LostMouseFocus
'        'For example:
'        .BackColor = &H8000000F
'
'        'Draw button outline
'        .ForeColor = &H80000010
'        picRollUpDwn.Line (.Width - 15, 0)-(.Width - 15, .Height)
'        picRollUpDwn.Line (0, .Height - 15)-(.Width, .Height - 15)
'        picRollUpDwn.Line (0, 0)-(.Width, 0)
'        picRollUpDwn.Line (0, 0)-(0, .Height)
'
'        'If the form is rolled down then draw the up arrow
'        If .Tag = "Down" Then
'            'Draw the up arrow outline
'            .ForeColor = &H80000010
'            picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 3)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
'            picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
'            picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 3)
'        Else
'            'Draw the down arrow outline
'            .ForeColor = &H80000010
'            picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 13)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
'            picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
'            picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 13)
'        End If
'    Else
'        SetCapture .hWnd
'        If CtrMov = False Then
'            CtrMov = True
'            'Put here your code to GetMouseFocus
'            'For example:
'
'        End If
'        .BackColor = &HFF00&
'        'Draw button shadow
'        .ForeColor = &H80000015
'        picRollUpDwn.Line (.Width - 15, 0)-(.Width - 15, .Height)
'        picRollUpDwn.Line (0, .Height - 15)-(.Width, .Height - 15)
'        'Draw button hilight
'        .ForeColor = &H80000014
'        picRollUpDwn.Line (0, 0)-(.Width, 0)
'        picRollUpDwn.Line (0, 0)-(0, .Height)
'
'        'If the form is rolled down then draw the up arrow
'        If .Tag = "Down" Then
'            'Draw the up arrow
'            .ForeColor = &H80000015
'            picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 3)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
'            .ForeColor = &H80000014
'            picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
'            picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 3)
'        Else
'            'Draw the down arrow
'            .ForeColor = &H80000015
'            picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 13)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
'            picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
'            .ForeColor = &H80000014
'            picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 13)
'        End If
'    End If
'End With
End Sub

Private Sub picRollUpDwn_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Static firsttime As Boolean
    Static OldHeight As Single
    
    'This code makes a MouseUp event like a Click event
    'This is usefull for making a check boxes where you want something to
    'happen when the checkbox is clicked and not when its value changes.
    'Checkboxes have an iritating feature where they fire the click event
    'when the value changes.
    If Button = vbLeftButton Then
        'Store the old form height
        If firsttime = False Then
            OldHeight = Me.Height
            firsttime = True
            picRollUpDwn.Tag = "Down"
        End If
        
        With picRollUpDwn
        If X >= 0 And X <= .Width And Y >= 0 And Y <= .Height Then
            'This code only runs when the checkbox is clicked
            If .Tag = "Down" Then
                Do While Me.Height > 585
                    'Resize by 4 pixels
                    Me.Move Me.Left, Me.Top, Me.Width, Me.Height - Screen.TwipsPerPixelY * 16
                    Me.Refresh
                    'Allow windows to process events
                    DoEvents
                Loop
                
                'Make sure its the right height
                Me.Move Me.Left, Me.Top, Me.Width, 585
                Me.Refresh
                
                'Set the tag to show the that the for is rolled up
                .Tag = "Up"
            Else
                Do While Me.Height < OldHeight
                    'Resize by 4 pixels
                    Me.Move Me.Left, Me.Top, Me.Width, Me.Height + Screen.TwipsPerPixelY * 16
                    Me.Refresh
                    'Allow windows to process events
                    DoEvents
                Loop
                
                'Make sure its the right height
                Me.Move Me.Left, Me.Top, Me.Width, OldHeight
                Me.Refresh
                
                'Set the tag to show the that the for is rolled down
                .Tag = "Down"
            End If
                
            'Release the mouse capture
            ReleaseCapture
            .BackColor = &H8000000F
            'Draw button outline
            .ForeColor = &H80000010
            picRollUpDwn.Line (.Width - 15, 0)-(.Width - 15, .Height)
            picRollUpDwn.Line (0, .Height - 15)-(.Width, .Height - 15)
            picRollUpDwn.Line (0, 0)-(.Width, 0)
            picRollUpDwn.Line (0, 0)-(0, .Height)
        
            'If the form is rolled down then draw the up arrow
            If .Tag = "Down" Then
                'Draw the up arrow outline
                .ForeColor = &H80000010
                picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 3)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
                picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 13)
                picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 3)
            Else
                'Draw the down arrow outline
                .ForeColor = &H80000010
                picRollUpDwn.Line (.Width / 2, Screen.TwipsPerPixelY * 13)-((.Width / 2) - (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
                picRollUpDwn.Line -((.Width / 2) + (Screen.TwipsPerPixelX * 10), Screen.TwipsPerPixelY * 3)
                picRollUpDwn.Line -(.Width / 2, Screen.TwipsPerPixelY * 13)
            End If
        End If
        End With
        
    End If
End Sub


Public Property Get NeedsLoading() As Boolean
    'Return the current value
    NeedsLoading = mvarNeedsLoading
End Property

Public Property Let NeedsLoading(ByVal vNewValue As Boolean)
    'Set the new value
'    mvarNeedsLoading = vNewValue
'    If mvarNeedsLoading = False Then
'        cmdLoad.BackColor = vb3DFace
'    Else
'        If mvarNeedsLoading = True And frmControl.NeedsLoading = False Then
'            'Set the needsloading flag for the control window
'            'also because it loads the same data
'            frmControl.NeedsLoading = True
'        End If
'    End If
End Property

Public Sub EnableIO(ByVal bVal As Boolean)
    Me.cmdLoad.Enabled = bVal
    cmdIOReset(0).Enabled = bVal
    '    Me.cmdRead.Enabled = bVal
End Sub

Private Sub tmrLoadFlash_Timer()
    Dim iAddrCntr As Integer
    Dim sCRegVal As String
    Dim sNRegVal As String
    Dim bNdsLdng As Boolean
    
    'Only address one register
    iAddrCntr = 1 'Register 1
    
    'Initialize the flags value
    bNdsLdng = False
    
    'Get the register map values for each register
    sCRegVal = EvBd.GetRegMapValue(rm9911_CurRegMapVals, 0)
    sNRegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 0)
    
    sCRegVal = Right(sCRegVal, 3)
    sNRegVal = Right(sNRegVal, 3)
    
    'If the values are different then set the needs loading flag
    If sCRegVal <> sNRegVal Then
        bNdsLdng = True
    End If
    
    'If the needs loading flag is set then flash the label
    If bNdsLdng Then
        'Flash the label
        If lblLoadFlash.Visible = True Then
            lblLoadFlash.Visible = False
        Else
            lblLoadFlash.Visible = True
        End If
        lblLoadFlash.Refresh
    Else
        'Hide the flash label
        lblLoadFlash.Visible = False
        lblLoadFlash.Refresh
    End If
    
    'Set the forms publicly available variable
    bNeedsLoading = bNdsLdng
End Sub
