VERSION 5.00
Begin VB.Form frmEditPhaseOffset1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Edit Phase Offset"
   ClientHeight    =   2415
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4335
   Icon            =   "frmEditPhaseOffset1.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2415
   ScaleWidth      =   4335
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.VScrollBar vscPhaseOffset 
      Height          =   435
      Left            =   240
      Max             =   -1
      Min             =   1
      TabIndex        =   12
      Top             =   360
      Width           =   200
   End
   Begin VB.TextBox txtSearchPhaseOff 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   480
      MaxLength       =   7
      MultiLine       =   -1  'True
      TabIndex        =   11
      Text            =   "frmEditPhaseOffset1.frx":000C
      ToolTipText     =   "Sets the Desired Phase Offset value"
      Top             =   360
      Width           =   1410
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3000
      TabIndex        =   1
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Height          =   375
      Left            =   3000
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
   Begin VB.Frame Frame1 
      Caption         =   "Register Values"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   120
      TabIndex        =   3
      Top             =   960
      Width           =   2775
      Begin VB.TextBox txtBinVal 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   0
         Left            =   1200
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   6
         Text            =   "frmEditPhaseOffset1.frx":0012
         ToolTipText     =   "Sets the phase offset binary register value"
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtHexVal 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   1560
         MaxLength       =   4
         MultiLine       =   -1  'True
         TabIndex        =   5
         Text            =   "frmEditPhaseOffset1.frx":001D
         ToolTipText     =   "Sets the phase offset hexadecimal register value"
         Top             =   360
         Width           =   615
      End
      Begin VB.TextBox txtDecVal 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   240
         MaxLength       =   5
         MultiLine       =   -1  'True
         TabIndex        =   4
         Text            =   "frmEditPhaseOffset1.frx":0022
         ToolTipText     =   "Sets the phase offset decimal register value"
         Top             =   360
         Width           =   735
      End
      Begin VB.TextBox txtBinVal 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   1
         Left            =   240
         MaxLength       =   6
         MultiLine       =   -1  'True
         TabIndex        =   13
         Text            =   "frmEditPhaseOffset1.frx":0028
         ToolTipText     =   "Sets the phase offset binary register value"
         Top             =   840
         Width           =   975
      End
      Begin VB.Label lblBin 
         Caption         =   "Bin"
         Height          =   255
         Left            =   2280
         TabIndex        =   9
         Top             =   840
         Width           =   375
      End
      Begin VB.Label lblHex 
         Caption         =   "Hex"
         Height          =   255
         Left            =   2280
         TabIndex        =   8
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblDec 
         Caption         =   "Dec"
         Height          =   255
         Left            =   1080
         TabIndex        =   7
         Top             =   360
         Width           =   375
      End
   End
   Begin VB.Label lblActualPhaseDelay 
      Caption         =   "Phase Offset:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   10
      Top             =   120
      Width           =   1335
   End
   Begin VB.Label lblPhaseDelDeg 
      Caption         =   "Deg"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1920
      TabIndex        =   2
      Top             =   405
      Width           =   495
   End
End
Attribute VB_Name = "frmEditPhaseOffset1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim PhaseOffArray() As Double
Dim EditBox As TextBox
Dim NumPhaseVals As Integer

'Flag that signals to the lstPhaseOffBox_click event that the text box is
'just updating the list index to match its contents
Dim ListUpdateFlag As Boolean 'Flag the lets the

Private Sub UpdatePO(ByVal value As Variant)
    Dim POBin As String
    Dim OutFreqval As Variant
        
    'Output frequency textbox
    If Not (ActiveControl Is txtSearchPhaseOff) Then
        'Update this box because it is not currently active
        txtSearchPhaseOff.Text = Format(CalcPO(value), "0.000")
        txtSearchPhaseOff.Tag = value
    End If
    
    'Decimal value textbox
    If Not (ActiveControl Is txtDecVal) Then
        txtDecVal.Text = Format(value, "00000")
        txtDecVal.Text = String(5 - Len(txtDecVal.Text), "0") & txtDecVal.Text
        txtDecVal.Refresh
    End If
    
    'Hex textbox
    If Not (ActiveControl Is txtHexVal) Then
        'Update this box because it is not currently active
        txtHexVal.Text = cbaseHex(value, 4)
        txtHexVal.Text = String(4 - Len(txtHexVal.Text), "0") & txtHexVal.Text
        txtHexVal.Refresh
    End If
    
    'Generate a binary string representing the phase offset value
    POBin = cbaseDec2Bin(value, NumPhaseBits)
    
    'Binary TextBoxes
    If Not (ActiveControl Is txtBinVal) Then
        txtBinVal(0).Text = Right(POBin, 8)
        txtBinVal(1).Text = Left(POBin, 6)
        txtBinVal(0).Refresh
        txtBinVal(1).Refresh
    End If
    
End Sub




Private Sub cmdCancel_Click()
    'Release the pointer to the edit box
    Set EditBox = Nothing
    
    'Unload the form
    Unload Me
End Sub

Private Sub cmdOK_Click()
    'Return the value to the textbox
    EditBox.Tag = txtDecVal.Text
    EditBox.Text = txtSearchPhaseOff.Text
    
    'Release the pointer to the edit box
    Set EditBox = Nothing
    
    'Unload the form
    Unload Me
    
End Sub

Private Sub Form_Activate()
    'Make sure that the tag property has some value
    If EditBox.Tag = "" Then
        EditBox.Tag = "0"
    End If
    
    'Copy the text box value to the search box
    txtSearchPhaseOff.Text = Format(CalcPO(EditBox.Tag), "0.000")
    'Set the decimal value
    txtDecVal.Text = EditBox.Tag
    
    txtSearchPhaseOff.SetFocus
    
    'Update all other displays
    UpdatePO txtDecVal.Text
End Sub

Private Sub Form_Load()
'    fraDDL.Move (txtSearchPhaseOff.Left + 120), (txtSearchPhaseOff.Top + txtSearchPhaseOff.Height + 30)
End Sub

'Function that edits the dialog box
Public Sub ShowEditDialog(tBox As TextBox, ByVal SysClk As Variant)
    Dim cntr As Integer
    Dim lsb As Double
        
    'Calculate the number of phase values
    NumPhaseVals = 2 ^ NumPhaseBits
    
    'Dim the array for the number of phase values
    'ReDim PhaseOffArray(0 To NumPhaseVals - 1)
    
    'Calculate the phase values
    lsb = 360 / NumPhaseVals
    
    'Clear the list box
    'lstPhaseOffBox.Clear
    
    'Build the phase value array and list for the list box
'    For cntr = 0 To NumPhaseVals - 1
        'PhaseOffArray(cntr) = cntr * lsb
        'lstPhaseOffBox.AddItem Format(PhaseOffArray(cntr), "0.000")
        'lstPhaseOffBox.ItemData(cntr) = cntr
'    Next cntr
    'Set the sysclk to so all functions will work.
    EditDialogSysClk9956 = CDec(SysClk)
    
    Set EditBox = tBox
    
    Me.Show 1
End Sub

Private Sub txtBinVal_GotFocus(Index As Integer)
    'Select all of the text in the textbox
    SelectAllTxt txtBinVal(Index)
End Sub

Private Sub txtBinVal_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    
    'Filter out all keys but for the 0 and 1 keys
    KeyAscii = BinKeysFilter(KeyAscii)
    
    Select Case KeyAscii
        Case 13:
            KeyAscii = 0
            txtBinVal_Validate Index, cncl
    End Select
End Sub

Private Sub txtBinVal_Validate(Index As Integer, Cancel As Boolean)
    Dim POBinVal As Variant
    Dim sTWBinVal As String
    
    'Fill any missing digits in with Zeros
    If Index = 0 Then
        txtBinVal(Index).Text = String(8 - Len(txtBinVal(Index).Text), "0") & txtBinVal(Index).Text
    ElseIf Index = 1 Then
        txtBinVal(Index).Text = String(6 - Len(txtBinVal(Index).Text), "0") & txtBinVal(Index).Text
    End If
    
        
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtBinVal(Index).Text) Then
        If Index = 0 Then
            txtBinVal(Index).Text = String(8, "0")
        ElseIf Index = 1 Then
            txtBinVal(Index).Text = String(6, "0")
        End If
    End If
    
    'Get the value of the textbox
    POBinVal = cbaseBinS2Dec(txtBinVal(1).Text & txtBinVal(0).Text)
        
    'Update the other textboxes
    UpdatePO (POBinVal)
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub

Private Sub txtDecVal_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtDecVal
End Sub

Private Sub txtDecVal_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    'Filter out keys that arn't needed
    KeyAscii = iNumericKeysFilter(KeyAscii)
    
    Select Case KeyAscii
        Case 13:
            KeyAscii = 0
            txtDecVal_Validate cncl
    End Select
End Sub

Private Sub txtDecVal_Validate(Cancel As Boolean)
    Dim PODecVal As Long
    
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtDecVal.Text) Then
        txtDecVal.Text = Format(0, "00000")
    End If
    
    'Get the value of the textbox
    PODecVal = CInt(txtDecVal.Text)
    
    If PODecVal <= (NumPhaseVals - 1) Then
        'Display the new value
        txtDecVal.Text = Format(PODecVal, "00000")
    Else
        MsgBox "The decimal value of the Phase Offset should not exceed " & (NumPhaseVals - 1)
        PODecVal = 0
        txtDecVal.Text = Format(PODecVal, "00000")
        Cancel = True
    End If
    
    'Record the proper output frequency value
    'OutputFreqVal = DecTW2CarrierFreq(TWDecVal, TWBits, CLng(frmMain.txtIntClockFreq.Text))
    
    'Update the other textboxes
    UpdatePO txtDecVal.Text
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub

Private Sub txtHexVal_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtHexVal
End Sub

Private Sub txtHexVal_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
        
    'Filter out all unwanted keys
    KeyAscii = HexKeysFilter(KeyAscii)
    
    If KeyAscii = 13 Then
        'Throw the key away
        KeyAscii = 0
        
        'Validate the textbox
        txtHexVal_Validate cncl
    End If
End Sub

Private Sub txtHexVal_Validate(Cancel As Boolean)
    Dim POHexVal As Variant
        
    POHexVal = CDec(0)
    'If something non numeric is entered then zero the control
'    If Not IsNumeric(txtTWHex.Text) Then
'        txtTWHex.Text = cbaseHex(0, 8)
'    End If
    
    'Get the decimal value of the hex text box
    POHexVal = cbaseHexStr2Dec(txtHexVal.Text)
    
    If POHexVal <= (NumPhaseVals - 1) Then
        'Display the new value
        txtHexVal.Text = cbaseHex(POHexVal, 4)
    Else
        MsgBox "The hex value of the Phase Offset should not exceed " & cbaseHex(NumPhaseVals - 1, 2)
        POHexVal = 0
        txtHexVal.Text = cbaseHex(POHexVal, 4)
        Cancel = True
    End If
    
    'Update the other textboxes
    UpdatePO (POHexVal)
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub

Private Sub txtSearchPhaseOff_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtSearchPhaseOff
End Sub

Private Sub txtSearchPhaseOff_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    'Trash all unwanted keys
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    If KeyAscii = GetDecSeparator(True) Then
        If InStr(1, txtSearchPhaseOff.Text, sDecSep) And InStr(1, txtSearchPhaseOff.SelText, sDecSep) = 0 Then
            KeyAscii = 0
        End If
    End If
    
    If KeyAscii = 13 Then
        KeyAscii = 0
        
        txtSearchPhaseOff_Validate cncl
    End If
End Sub

Private Sub txtSearchPhaseOff_Validate(Cancel As Boolean)
    Dim dblval As Double
    Dim DecVal As Long
    Dim MaxVal As Double
    
    MaxVal = CalcPO(16383)
    
    'Make sure that the value entered is numeric
    If Not IsNumeric(txtSearchPhaseOff.Text) Then
        txtSearchPhaseOff.Text = Format("0.000", 0)
    End If
        
    'Make sure that the value typed isn't greater than the maximum value
    If CDbl(txtSearchPhaseOff.Text) > MaxVal Then
        'Set it to the max
        txtSearchPhaseOff.Text = Format("0.000", CalcPO(16383))
    End If
    
    'Calculate the decimal value of the phase offset
    DecVal = CalcPODecVal(txtSearchPhaseOff.Text)
    
    'Calculate the actual phase offset that the part can do and display it.
    txtSearchPhaseOff.Text = CalcPO(DecVal)
    
    'Format the text
    txtSearchPhaseOff.Text = Format(txtSearchPhaseOff.Text, "0.000")
    
    'Update other controls
    UpdatePO DecVal
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub


Private Sub vscPhaseOffset_Change()
    Dim NewVal As Double
    
    '
    NewVal = txtDecVal.Text + vscPhaseOffset.value
    If NewVal >= 0 And NewVal <= 16383 Then
        'Update the new values
        UpdatePO NewVal
    End If
    vscPhaseOffset.value = 0
End Sub
