VERSION 5.00
Begin VB.Form frmEditOSF 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Edit Output Scale Factor"
   ClientHeight    =   2415
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4335
   Icon            =   "frmEditOSF.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2415
   ScaleWidth      =   4335
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.VScrollBar vscValue 
      Height          =   435
      Left            =   240
      Max             =   -1
      Min             =   1
      TabIndex        =   11
      Top             =   360
      Width           =   200
   End
   Begin VB.TextBox txtValue 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   480
      MaxLength       =   7
      MultiLine       =   -1  'True
      TabIndex        =   10
      Tag             =   "0"
      Text            =   "frmEditOSF.frx":000C
      ToolTipText     =   "Sets the Output Scale Factor value"
      Top             =   360
      Width           =   1890
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3000
      TabIndex        =   1
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Height          =   375
      Left            =   3000
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
   Begin VB.Frame Frame1 
      Caption         =   "Register Values"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   120
      TabIndex        =   2
      Top             =   960
      Width           =   2775
      Begin VB.TextBox txtBinVal 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   0
         Left            =   1200
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   5
         Text            =   "frmEditOSF.frx":0016
         ToolTipText     =   "Sets the output scale factor binary register value"
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtHexVal 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   1560
         MaxLength       =   3
         MultiLine       =   -1  'True
         TabIndex        =   4
         Text            =   "frmEditOSF.frx":0021
         ToolTipText     =   "Sets the output scale factor hexadecimal register value"
         Top             =   360
         Width           =   615
      End
      Begin VB.TextBox txtDecVal 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   240
         MaxLength       =   5
         MultiLine       =   -1  'True
         TabIndex        =   3
         Text            =   "frmEditOSF.frx":0027
         ToolTipText     =   "Sets the output scale factor decimal register value"
         Top             =   360
         Width           =   735
      End
      Begin VB.TextBox txtBinVal 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   1
         Left            =   240
         MaxLength       =   2
         MultiLine       =   -1  'True
         TabIndex        =   12
         Text            =   "frmEditOSF.frx":002D
         ToolTipText     =   "Sets the output scale factor binary register value"
         Top             =   840
         Width           =   975
      End
      Begin VB.Label lblBin 
         Caption         =   "Bin"
         Height          =   255
         Left            =   2280
         TabIndex        =   8
         Top             =   840
         Width           =   375
      End
      Begin VB.Label lblHex 
         Caption         =   "Hex"
         Height          =   255
         Left            =   2280
         TabIndex        =   7
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblDec 
         Caption         =   "Dec"
         Height          =   255
         Left            =   1080
         TabIndex        =   6
         Top             =   360
         Width           =   375
      End
   End
   Begin VB.Label lblActualPhaseDelay 
      Caption         =   "Output Scale Factor:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   9
      Top             =   120
      Width           =   1815
   End
End
Attribute VB_Name = "frmEditOSF"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Fixed - When user enters 0.1 as an osf the osf value would read
'9.9998 instead of 0.09998

Dim EditBox As TextBox
Dim NumOSFVals As Integer

'Flag that signals to the lstPhaseOffBox_click event that the text box is
'just updating the list index to match its contents
Dim ListUpdateFlag As Boolean 'Flag the lets the

'Returns the decimal seperator in either ascii code or
'the character
Private Function GetDecSeparator(ByVal RetAsciiCode As Boolean) As Variant
    If RetAsciiCode Then
        GetDecSeparator = Asc(Mid(Format(0, "Fixed"), 2, 1))
    Else
        GetDecSeparator = Mid(Format(0, "Fixed"), 2, 1)
    End If
End Function
Private Sub UpdateVals(ByVal value As Variant)
    Dim OSFBin As String
    Dim OutFreqval As Variant
        
    'Output frequency textbox
    If Not (ActiveControl Is txtValue) Then
        'Update this box because it is not currently active
        txtValue.Text = Format(CalculateOSF(value), "0.00000")
        txtValue.Tag = value
    End If
    
    'Decimal value textbox
    If Not (ActiveControl Is txtDecVal) Then
        txtDecVal.Text = Format(value, "00000")
        txtDecVal.Text = String(5 - Len(txtDecVal.Text), "0") & txtDecVal.Text
        txtDecVal.Refresh
    End If
    
    'Hex textbox
    If Not (ActiveControl Is txtHexVal) Then
        'Update this box because it is not currently active
        txtHexVal.Text = cbaseHex(value, 3)
        txtHexVal.Text = String(3 - Len(txtHexVal.Text), "0") & txtHexVal.Text
        txtHexVal.Refresh
    End If
    
    'Generate a binary string representing the phase offset value
    OSFBin = cbaseDec2Bin(value, NumOSFBits)
    
    'Binary TextBoxes
    If Not (ActiveControl Is txtBinVal) Then
        txtBinVal(0).Text = Right(OSFBin, 8)
        txtBinVal(1).Text = Left(OSFBin, 2)
        txtBinVal(0).Refresh
        txtBinVal(1).Refresh
    End If
    
End Sub

Private Sub cmdCancel_Click()
    'Release the pointer to the edit box
    Set EditBox = Nothing
    
    'Unload the form
    Unload Me
End Sub

Private Sub cmdOK_Click()
    'Return the value to the textbox
    EditBox.Tag = txtDecVal.Text
    EditBox.Text = txtValue.Text
    
    'Release the pointer to the edit box
    Set EditBox = Nothing
    
    'Unload the form
    Unload Me
    
End Sub

Private Sub Form_Activate()
    'Check to see if the tag property has been initialized
    If EditBox.Tag = "" Then
        EditBox.Tag = "0"
    End If
    
    'Copy the text box value to the search box
    txtValue.Text = Format(CalculateOSF(EditBox.Tag), "0.00000")
    'Set the decimal value
    txtDecVal.Text = EditBox.Tag
    
    txtValue.SetFocus
    
    'Update all other displays
    UpdateVals txtDecVal.Text
End Sub

Private Sub Form_Load()
'    fraDDL.Move (txtValue.Left + 120), (txtValue.Top + txtValue.Height + 30)
End Sub

'Function that edits the dialog box
Public Sub ShowEditDialog(tBox As TextBox)
    Dim cntr As Integer
        
    'Calculate the number of phase values
    NumOSFVals = 2 ^ NumOSFBits
    
    Set EditBox = tBox
    
    Me.Show 1
End Sub


Private Sub txtBinVal_GotFocus(Index As Integer)
    'Select all of the text in the textbox
    SelectAllTxt txtBinVal(Index)
End Sub

Private Sub txtBinVal_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    
    'Filter out all keys but for the 0 and 1 keys
    KeyAscii = BinKeysFilter(KeyAscii)
    
    Select Case KeyAscii
        Case 13:
            KeyAscii = 0
            txtBinVal_Validate Index, cncl
    End Select
End Sub

Private Sub txtBinVal_Validate(Index As Integer, Cancel As Boolean)
    Dim POBinVal As Variant
    Dim sTWBinVal As String
    
    'Fill any missing digits in with Zeros
    If Index = 0 Then
        txtBinVal(Index).Text = String(8 - Len(txtBinVal(Index).Text), "0") & txtBinVal(Index).Text
    ElseIf Index = 1 Then
        txtBinVal(Index).Text = String(2 - Len(txtBinVal(Index).Text), "0") & txtBinVal(Index).Text
    End If
    
        
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtBinVal(Index).Text) Then
        If Index = 0 Then
            txtBinVal(Index).Text = String(8, "0")
        ElseIf Index = 1 Then
            txtBinVal(Index).Text = String(2, "0")
        End If
    End If
    
    'Get the value of the textbox
    POBinVal = cbaseBinS2Dec(txtBinVal(1).Text & txtBinVal(0).Text)
        
    'Update the other textboxes
    UpdateVals (POBinVal)
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub

Private Sub txtDecVal_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtDecVal
End Sub

Private Sub txtDecVal_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    'Filter out keys that arn't needed
    KeyAscii = iNumericKeysFilter(KeyAscii)
    
    Select Case KeyAscii
        Case 13:
            KeyAscii = 0
            txtDecVal_Validate cncl
    End Select
End Sub

Private Sub txtDecVal_Validate(Cancel As Boolean)
    Dim PODecVal As Long
    
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtDecVal.Text) Then
        txtDecVal.Text = Format(0, "00000")
    End If
    
    'Get the value of the textbox
    PODecVal = CInt(txtDecVal.Text)
    
    If PODecVal <= (NumOSFVals - 1) Then
        'Display the new value
        txtDecVal.Text = Format(PODecVal, "00000")
    Else
        MsgBox "The decimal value of the Phase Offset should not exceed " & (NumOSFVals - 1)
        PODecVal = 0
        txtDecVal.Text = Format(PODecVal, "00000")
        Cancel = True
    End If
    
    'Record the proper output frequency value
    'OutputFreqVal = DecTW2CarrierFreq(TWDecVal, TWBits, CLng(frmMain.txtIntClockFreq.Text))
    
    'Update the other textboxes
    UpdateVals txtDecVal.Text
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub

Private Sub txtHexVal_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtHexVal
End Sub

Private Sub txtHexVal_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
        
    'Filter out all unwanted keys
    KeyAscii = HexKeysFilter(KeyAscii)
    
    If KeyAscii = 13 Then
        'Throw the key away
        KeyAscii = 0
        
        'Validate the textbox
        txtHexVal_Validate cncl
    End If
End Sub

Private Sub txtHexVal_Validate(Cancel As Boolean)
    Dim POHexVal As Variant
        
    POHexVal = CDec(0)
    'If something non numeric is entered then zero the control
'    If Not IsNumeric(txtTWHex.Text) Then
'        txtTWHex.Text = cbaseHex(0, 8)
'    End If
    
    'Get the decimal value of the hex text box
    POHexVal = cbaseHexStr2Dec(txtHexVal.Text)
    
    If POHexVal <= (NumOSFVals - 1) Then
        'Display the new value
        txtHexVal.Text = cbaseHex(POHexVal, 3)
    Else
        MsgBox "The hex value of the Phase Offset should not exceed " & cbaseHex(NumOSFVals - 1, 2)
        POHexVal = 0
        txtHexVal.Text = cbaseHex(POHexVal, 3)
        Cancel = True
    End If
    
    'Update the other textboxes
    UpdateVals (POHexVal)
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub

Private Sub txtValue_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtValue
End Sub

Private Sub txtValue_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    'Trash all unwanted keys
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    If KeyAscii = GetDecSeparator(True) Then
        If InStr(1, txtValue.Text, sDecSep) And InStr(1, txtValue.SelText, sDecSep) = 0 Then
            KeyAscii = 0
        End If
    End If
    
    If KeyAscii = 13 Then
        KeyAscii = 0
        
        txtValue_Validate cncl
    End If
End Sub

Private Sub txtValue_Validate(Cancel As Boolean)
    Dim dblval As Double
    Dim DecVal As Long
    Dim MaxVal As Double
    
    MaxVal = CalculateOSF((2 ^ NumOSFBits) - 1)
    
    'Make sure that the value entered is numeric
    If Not IsNumeric(txtValue.Text) Then
        txtValue.Text = Format("0.00000", 0)
    End If
        
    'Make sure that the value typed isn't greater than the maximum value
    If CDbl(txtValue.Text) > MaxVal Then
        'Set it to the max
        txtValue.Text = Format("0.00000", MaxVal)
    End If
    
    'Calculate the decimal value of the phase offset
    DecVal = CalculateOSFWord(txtValue.Text)
    
    'Calculate the actual phase offset that the part can do and display it.
     dblval = CalculateOSF(DecVal)
    
    'Format the text
    txtValue.Text = Format(dblval, "0.00000")
    
    'Update other controls
    UpdateVals DecVal
    
    'Set the focus back to the ok button
    cmdOK.SetFocus
End Sub


Private Sub vscvalue_Change()
    Dim NewVal As Double
    
    'Calculate the new value
    NewVal = txtDecVal.Text + vscValue.value
    If NewVal >= 0 And NewVal <= (NumOSFVals - 1) Then
        'Update the new values
        UpdateVals NewVal
    End If
    vscValue.value = 0
End Sub
