VERSION 5.00
Begin VB.Form frmDebug 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Debug"
   ClientHeight    =   6000
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   9375
   Icon            =   "frmDebug.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   6000
   ScaleWidth      =   9375
   ShowInTaskbar   =   0   'False
   Begin VB.Frame Frame1 
      Height          =   5775
      Left            =   7560
      TabIndex        =   69
      Top             =   120
      Width           =   1695
      Begin VB.CommandButton cmdReadDebug 
         Caption         =   "ReadD"
         Height          =   375
         Left            =   120
         TabIndex        =   71
         Top             =   240
         Width           =   1455
      End
      Begin VB.CommandButton cmdDone 
         Caption         =   "Finished"
         Height          =   375
         Left            =   120
         TabIndex        =   70
         Top             =   720
         Width           =   1455
      End
      Begin VB.Label Label1 
         Caption         =   $"frmDebug.frx":0442
         Height          =   4455
         Left            =   120
         TabIndex        =   72
         Top             =   1200
         Width           =   1455
      End
   End
   Begin VB.Frame fraSerialIO 
      Caption         =   "Serial I/O"
      Height          =   2055
      Left            =   120
      TabIndex        =   34
      Top             =   3840
      Width           =   6615
      Begin VB.TextBox txtSerialData 
         Height          =   285
         Left            =   2280
         TabIndex        =   42
         Text            =   "10101010"
         Top             =   2280
         Visible         =   0   'False
         Width           =   3495
      End
      Begin VB.PictureBox pbxSerialIO 
         BorderStyle     =   0  'None
         Height          =   1695
         Left            =   120
         ScaleHeight     =   1695
         ScaleWidth      =   6375
         TabIndex        =   35
         Top             =   240
         Width           =   6375
         Begin VB.ListBox lstChannel 
            Height          =   840
            ItemData        =   "frmDebug.frx":0546
            Left            =   1320
            List            =   "frmDebug.frx":0556
            TabIndex        =   67
            ToolTipText     =   "When a channel register is selected, you must select the channel you want to view."
            Top             =   840
            Width           =   975
         End
         Begin VB.TextBox txtSData 
            Alignment       =   2  'Center
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   3
            Left            =   2400
            MaxLength       =   8
            TabIndex        =   46
            Text            =   "00000000"
            Top             =   240
            Width           =   975
         End
         Begin VB.TextBox txtSData 
            Alignment       =   2  'Center
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   2
            Left            =   3360
            MaxLength       =   8
            TabIndex        =   45
            Text            =   "00000000"
            Top             =   240
            Width           =   975
         End
         Begin VB.TextBox txtSData 
            Alignment       =   2  'Center
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   1
            Left            =   4320
            MaxLength       =   8
            TabIndex        =   44
            Text            =   "00000000"
            Top             =   240
            Width           =   975
         End
         Begin VB.TextBox txtSData 
            Alignment       =   2  'Center
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   0
            Left            =   5280
            MaxLength       =   8
            TabIndex        =   43
            Text            =   "00000000"
            Top             =   240
            Width           =   975
         End
         Begin VB.CheckBox chkUpRegVal 
            Caption         =   "Update Register Map Value"
            Height          =   195
            Left            =   2520
            TabIndex        =   40
            ToolTipText     =   "Updates the software register map buffer."
            Top             =   840
            Value           =   1  'Checked
            Width           =   2655
         End
         Begin VB.CheckBox chkAutoUpdate 
            Caption         =   "Auto I/O Update"
            Height          =   255
            Left            =   2520
            TabIndex        =   41
            ToolTipText     =   "Pulses the I/O Update pin after each serial load."
            Top             =   600
            Width           =   2655
         End
         Begin VB.CommandButton cmdRead 
            Caption         =   "READ"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   375
            Left            =   0
            Style           =   1  'Graphical
            TabIndex        =   38
            Top             =   720
            Width           =   1095
         End
         Begin VB.CommandButton cmdLoad 
            Caption         =   "LOAD"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   375
            Left            =   0
            Style           =   1  'Graphical
            TabIndex        =   37
            Top             =   240
            Width           =   1095
         End
         Begin VB.ComboBox cmbRegAddress 
            Height          =   315
            ItemData        =   "frmDebug.frx":0566
            Left            =   1320
            List            =   "frmDebug.frx":05BE
            Style           =   2  'Dropdown List
            TabIndex        =   36
            Top             =   240
            Width           =   975
         End
         Begin VB.Label lblChannel 
            Caption         =   "View Channel:"
            Height          =   255
            Left            =   1320
            TabIndex        =   68
            Top             =   600
            Width           =   1215
         End
         Begin VB.Label lblBitRange 
            Alignment       =   2  'Center
            Caption         =   "<31:24>"
            Height          =   255
            Index           =   3
            Left            =   2400
            TabIndex        =   50
            Top             =   0
            Width           =   975
         End
         Begin VB.Label lblBitRange 
            Alignment       =   2  'Center
            Caption         =   "<23:16>"
            Height          =   255
            Index           =   2
            Left            =   3360
            TabIndex        =   49
            Top             =   0
            Width           =   975
         End
         Begin VB.Label lblBitRange 
            Alignment       =   2  'Center
            Caption         =   "<15:8>"
            Height          =   255
            Index           =   1
            Left            =   4320
            TabIndex        =   48
            Top             =   0
            Width           =   975
         End
         Begin VB.Label lblBitRange 
            Alignment       =   2  'Center
            Caption         =   "<7:0>"
            Height          =   255
            Index           =   0
            Left            =   5280
            TabIndex        =   47
            Top             =   0
            Width           =   975
         End
         Begin VB.Label lblRegAddr 
            Caption         =   "RegAddr:"
            Height          =   255
            Left            =   1320
            TabIndex        =   39
            Top             =   0
            Width           =   855
         End
      End
   End
   Begin VB.ListBox lsbSerialIOMode 
      Height          =   1035
      ItemData        =   "frmDebug.frx":06A2
      Left            =   120
      List            =   "frmDebug.frx":06B2
      TabIndex        =   58
      Top             =   6000
      Width           =   1575
   End
   Begin VB.CheckBox chkLSBFirstMode 
      Caption         =   "LSB First Mode"
      Height          =   255
      Left            =   120
      TabIndex        =   57
      Top             =   5640
      Width           =   1935
   End
   Begin VB.Timer tmrLoadFlash 
      Interval        =   200
      Left            =   6840
      Top             =   4920
   End
   Begin VB.CommandButton cmdRegDebug 
      Caption         =   "Reg Map Debug..."
      Height          =   375
      Left            =   5520
      TabIndex        =   51
      Top             =   2760
      Width           =   1695
   End
   Begin VB.Frame fraSerialIOStatus 
      Caption         =   "Serial Port Status"
      Height          =   2535
      Left            =   5400
      TabIndex        =   30
      Top             =   120
      Width           =   1935
      Begin VB.PictureBox pbxBtnCntnr 
         BorderStyle     =   0  'None
         Height          =   375
         Left            =   120
         ScaleHeight     =   375
         ScaleWidth      =   1695
         TabIndex        =   65
         Top             =   2040
         Width           =   1695
         Begin VB.CommandButton cmdSendIOReset 
            Caption         =   "Send I/O Reset"
            Height          =   375
            Left            =   0
            TabIndex        =   66
            Top             =   0
            Width           =   1695
         End
      End
      Begin VB.Label lblIOMode 
         Caption         =   "4 - Bit Serial"
         Height          =   255
         Index           =   3
         Left            =   360
         TabIndex        =   64
         Top             =   1680
         Width           =   1455
      End
      Begin VB.Label lblIOMode 
         Caption         =   "2 - Bit Serial"
         Height          =   255
         Index           =   2
         Left            =   360
         TabIndex        =   63
         Top             =   1440
         Width           =   1455
      End
      Begin VB.Label lblIOMode 
         Caption         =   "Single Bit - 3 Wire"
         Height          =   255
         Index           =   1
         Left            =   360
         TabIndex        =   62
         Top             =   1200
         Width           =   1455
      End
      Begin VB.Label lblIOMode 
         Caption         =   "Single Bit - 2 Wire"
         Height          =   255
         Index           =   0
         Left            =   360
         TabIndex        =   61
         Top             =   960
         Width           =   1455
      End
      Begin VB.Image imgIOMode 
         Height          =   180
         Index           =   3
         Left            =   120
         Picture         =   "frmDebug.frx":0700
         Stretch         =   -1  'True
         Top             =   1680
         Width           =   180
      End
      Begin VB.Image imgIOMode 
         Height          =   180
         Index           =   2
         Left            =   120
         Picture         =   "frmDebug.frx":0789
         Stretch         =   -1  'True
         Top             =   1440
         Width           =   180
      End
      Begin VB.Image imgIOMode 
         Height          =   180
         Index           =   1
         Left            =   120
         Picture         =   "frmDebug.frx":0812
         Stretch         =   -1  'True
         Top             =   1200
         Width           =   180
      End
      Begin VB.Image imgIOMode 
         Height          =   180
         Index           =   0
         Left            =   120
         Picture         =   "frmDebug.frx":089B
         Stretch         =   -1  'True
         Top             =   960
         Width           =   180
      End
      Begin VB.Label lblIOMd 
         AutoSize        =   -1  'True
         Caption         =   "Serial I/O Mode:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   120
         TabIndex        =   60
         Top             =   660
         Width           =   1545
      End
      Begin VB.Image imgLSBFirstMode 
         Height          =   180
         Left            =   120
         Picture         =   "frmDebug.frx":0924
         Stretch         =   -1  'True
         Top             =   360
         Width           =   180
      End
      Begin VB.Label lblLSBFirst 
         Caption         =   "LSB First"
         Height          =   255
         Left            =   360
         TabIndex        =   59
         Top             =   360
         Width           =   975
      End
   End
   Begin VB.Frame fraIOPins 
      Caption         =   "DUT Signals (CTL)"
      Height          =   1575
      Index           =   3
      Left            =   3600
      TabIndex        =   25
      Top             =   2160
      Width           =   1695
      Begin VB.PictureBox pbxIOPins 
         BorderStyle     =   0  'None
         Height          =   1215
         Index           =   3
         Left            =   120
         ScaleHeight     =   1215
         ScaleWidth      =   1455
         TabIndex        =   26
         Top             =   240
         Width           =   1455
         Begin VB.CheckBox chkCTLAutoUpdate 
            Caption         =   "Auto Update"
            Height          =   255
            Left            =   120
            TabIndex        =   27
            Top             =   540
            Value           =   1  'Checked
            Width           =   1215
         End
         Begin VB.CommandButton cmdApplyCTL 
            Caption         =   "Update"
            Height          =   375
            Left            =   0
            Style           =   1  'Graphical
            TabIndex        =   28
            Top             =   840
            Width           =   1455
         End
         Begin VB.CheckBox chkCTLIO 
            Caption         =   "SCLK"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   29
            Top             =   120
            Width           =   855
         End
      End
   End
   Begin VB.Frame fraIOPins 
      Caption         =   "DUT Signals (PD)"
      Height          =   3615
      Index           =   2
      Left            =   120
      TabIndex        =   16
      Top             =   120
      Width           =   1575
      Begin VB.PictureBox pbxIOPins 
         BorderStyle     =   0  'None
         Height          =   3255
         Index           =   2
         Left            =   120
         ScaleHeight     =   3255
         ScaleWidth      =   1335
         TabIndex        =   17
         Top             =   240
         Width           =   1335
         Begin VB.CheckBox chkPDIO 
            Caption         =   "P1"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   18
            Top             =   1800
            Width           =   615
         End
         Begin VB.CheckBox chkPDIO 
            Caption         =   "P2"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   19
            Top             =   1560
            Width           =   735
         End
         Begin VB.CheckBox chkPDIO 
            Caption         =   "P3"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   20
            Top             =   1320
            Width           =   735
         End
         Begin VB.CheckBox chkPDIO 
            Caption         =   "P4"
            Height          =   255
            Index           =   3
            Left            =   120
            TabIndex        =   21
            Top             =   1080
            Width           =   735
         End
         Begin VB.CheckBox chkPDIO 
            Caption         =   "I/OUpdate"
            Height          =   255
            Index           =   4
            Left            =   120
            TabIndex        =   24
            Top             =   840
            Width           =   1215
         End
         Begin VB.CheckBox chkPDIO 
            Caption         =   "RURD0"
            Height          =   255
            Index           =   5
            Left            =   120
            TabIndex        =   31
            Top             =   600
            Width           =   975
         End
         Begin VB.CheckBox chkPDIO 
            Caption         =   "RURD1"
            Height          =   255
            Index           =   6
            Left            =   120
            TabIndex        =   32
            Top             =   360
            Width           =   975
         End
         Begin VB.CheckBox chkPDAutoUpdate 
            Caption         =   "Auto Update"
            Height          =   255
            Left            =   0
            TabIndex        =   23
            Top             =   2520
            Value           =   1  'Checked
            Width           =   1215
         End
         Begin VB.CommandButton cmdApplyPD 
            Caption         =   "Update"
            Height          =   375
            Left            =   0
            Style           =   1  'Graphical
            TabIndex        =   22
            Top             =   2880
            Width           =   1335
         End
         Begin VB.CheckBox chkPDIO 
            Caption         =   "RURD2"
            Height          =   255
            Index           =   7
            Left            =   120
            TabIndex        =   33
            Top             =   120
            Width           =   975
         End
      End
   End
   Begin VB.Frame fraIOPins 
      Caption         =   "DUT Signals (PB)"
      Height          =   1935
      Index           =   1
      Left            =   3600
      TabIndex        =   10
      Top             =   120
      Width           =   1695
      Begin VB.PictureBox pbxIOPins 
         BorderStyle     =   0  'None
         Height          =   375
         Index           =   4
         Left            =   120
         ScaleHeight     =   375
         ScaleWidth      =   1455
         TabIndex        =   52
         Top             =   1440
         Width           =   1455
         Begin VB.CommandButton cmdRdSDIOs 
            Caption         =   "READ"
            Height          =   375
            Left            =   0
            Style           =   1  'Graphical
            TabIndex        =   55
            Top             =   0
            Width           =   1455
         End
         Begin VB.CheckBox chkPBAutoUpdate 
            Caption         =   "Auto Update"
            Height          =   255
            Left            =   1920
            TabIndex        =   54
            Top             =   120
            Value           =   1  'Checked
            Width           =   1215
         End
         Begin VB.CommandButton cmdApplyPB 
            Caption         =   "Update"
            Height          =   375
            Left            =   1920
            TabIndex        =   53
            Top             =   420
            Width           =   1215
         End
      End
      Begin VB.PictureBox pbxIOPins 
         BorderStyle     =   0  'None
         Enabled         =   0   'False
         Height          =   1215
         Index           =   1
         Left            =   120
         ScaleHeight     =   1215
         ScaleWidth      =   1335
         TabIndex        =   11
         Top             =   240
         Width           =   1335
         Begin VB.CheckBox chkPBIO 
            Caption         =   "SDIO_0"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   15
            Top             =   840
            Width           =   1095
         End
         Begin VB.CheckBox chkPBIO 
            Caption         =   "SDIO_1"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   14
            Top             =   600
            Width           =   1095
         End
         Begin VB.CheckBox chkPBIO 
            Caption         =   "SDIO_2"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   13
            Top             =   360
            Width           =   1095
         End
         Begin VB.CheckBox chkPBIO 
            Caption         =   "SDIO_3"
            Height          =   255
            Index           =   3
            Left            =   120
            TabIndex        =   12
            Top             =   120
            Width           =   1095
         End
      End
   End
   Begin VB.Frame fraIOPins 
      Caption         =   "DUT Signals (PA)"
      Height          =   3615
      Index           =   0
      Left            =   1800
      TabIndex        =   0
      Top             =   120
      Width           =   1695
      Begin VB.PictureBox pbxIOPins 
         BorderStyle     =   0  'None
         Height          =   3255
         Index           =   0
         Left            =   120
         ScaleHeight     =   3255
         ScaleWidth      =   1455
         TabIndex        =   1
         Top             =   240
         Width           =   1455
         Begin VB.CheckBox chkAutoCSBMode 
            Caption         =   "Auto CSB"
            Height          =   255
            Left            =   120
            TabIndex        =   56
            Top             =   1320
            Value           =   1  'Checked
            Width           =   1095
         End
         Begin VB.CheckBox chklFlashUSBStatus 
            Caption         =   "Flash"
            Height          =   255
            Left            =   120
            TabIndex        =   9
            Top             =   1740
            Width           =   1095
         End
         Begin VB.CommandButton cmdApplyPA 
            Caption         =   "Update"
            Height          =   375
            Left            =   0
            Style           =   1  'Graphical
            TabIndex        =   7
            Top             =   2880
            Width           =   1455
         End
         Begin VB.CheckBox chkPAIO 
            Caption         =   "ClkModeSel"
            Height          =   255
            Index           =   4
            Left            =   120
            TabIndex        =   6
            Top             =   120
            Width           =   1215
         End
         Begin VB.CheckBox chkPAIO 
            Caption         =   "Power Down"
            Height          =   255
            Index           =   3
            Left            =   120
            TabIndex        =   5
            Top             =   360
            Width           =   1215
         End
         Begin VB.CheckBox chkPAIO 
            Caption         =   "Reset"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   4
            Top             =   600
            Width           =   975
         End
         Begin VB.CheckBox chkPAIO 
            Caption         =   "CSB"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   3
            Top             =   1080
            Width           =   735
         End
         Begin VB.CheckBox chkPAIO 
            Caption         =   "USB_Status"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   2
            Top             =   2040
            Width           =   1215
         End
         Begin VB.CheckBox chkPAAutoUpdate 
            Caption         =   "Auto Update"
            Height          =   255
            Left            =   0
            TabIndex        =   8
            Top             =   2520
            Value           =   1  'Checked
            Width           =   1215
         End
      End
   End
End
Attribute VB_Name = "frmDebug"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private bUpdating As Boolean
Private PortAVal As Byte
Private PortDVal As Byte
Private PortBVal As Byte
Private CtlVal As Byte

Public lLoadFlashColor As Long
Public lLoadIndColor As Long

Private Sub chkAutoCSBMode_Click()
    If chkAutoCSBMode.value = 1 Then
        EvBd.AutoCSBMode = True
    Else
        EvBd.AutoCSBMode = False
    End If
End Sub

Private Sub chkAutoUpdate_Click()
    If bUpdating = False Then
        EvBd.AutoIOUpdate = CBool(chkAutoUpdate.value)
        mdiMain.UpdateFormVals
    End If
End Sub

Private Sub chkCTLIO_Click(Index As Integer)
    If bUpdating = False Then
        'Set the bit value in the software buffer
        'EvBd.USBSetPortBitVal fx2_CTLLines, Index, chkCTLIO(Index).Value
        CtlVal = SetBitVal(CtlVal, Index, chkCTLIO(Index).value)
        'Check to see if the auto apply button is checked
        If chkCTLAutoUpdate.value Then
            cmdApplyCTL_Click
        End If
    End If
End Sub

Private Sub chklFlashUSBStatus_Click()
    'Turn LED Flashing on or off
    EvBd.SetLEDBlink chklFlashUSBStatus.value
    
    If chklFlashUSBStatus.value = 1 Then
        chkPAIO(0).Enabled = False
    Else
        chkPAIO(0).Enabled = True
    End If
End Sub

Private Sub chkPAIO_Click(Index As Integer)
    If bUpdating = False Then
        'Set the bit value in the software buffer
        'EvBd.USBSetPortBitVal fx2_PortA, Index, chkPAIO(Index).Value
        PortAVal = SetBitVal(PortAVal, Index, chkPAIO(Index).value)
        'Check to see if the auto apply button is checked
        If chkPAAutoUpdate.value Then
            cmdApplyPA_Click
        End If
    End If
End Sub

Private Sub chkPBIO_Click(Index As Integer)
    If bUpdating = False Then
        'Set the bit value in the software buffer
        EvBd.USBSetPortBitVal fx2_PortB, Index, chkPBIO(Index).value
        'Check to see if the auto apply button is checked
        If chkPBAutoUpdate.value Then
            cmdApplyPB_Click
        End If
    End If
End Sub

Private Sub chkPDIO_Click(Index As Integer)
    If bUpdating = False Then
        'Set the bit value in the software buffer
        'EvBd.USBSetPortBitVal fx2_PortD, Index, chkPDIO(Index).Value
        PortDVal = SetBitVal(PortDVal, Index, chkPDIO(Index).value)
        'Check to see if the auto apply button is checked
        If chkPDAutoUpdate.value Then
            cmdApplyPD_Click
        End If
    End If
End Sub

Private Sub cmbRegAddress_Click()
    Dim sRegVal As String
    Dim iCntr As Integer
    Dim iNumBytes As Integer
    
    'Clear the restriction on the length of the textbox
    txtSerialData.MaxLength = 0
        
    'Get the registermap value
    sRegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, cmbRegAddress.ListIndex, lstChannel.ListIndex)
    
    'Get the number of bytes needed to edit
    iNumBytes = Len(sRegVal) / 8
    
    'Disable the bytes that aren't used
    For iCntr = 0 To 3
        If iCntr > iNumBytes - 1 Then
            txtSData(iCntr).Enabled = False
            lblBitRange(iCntr).Enabled = False
            txtSData(iCntr).Text = "++++++++"
        Else
            'Insert the data into the proper textbox
            txtSData(iCntr).Text = Mid(sRegVal, ((iNumBytes - iCntr) * 8) - 7, 8)
            txtSData(iCntr).Enabled = True
            lblBitRange(iCntr).Enabled = True
        End If
        'Reset the colors
        txtSData(iCntr).ForeColor = vbWindowText
    Next iCntr
    
    'Make the tag property equal the listindex property
    cmbRegAddress.Tag = CStr(cmbRegAddress.ListIndex)
    
    '((BytesInReg - cntr) * 8) - 7
'    'Insert spaces every 8 characters
'    txtSerialData.Text = InsertChars(sRegVal, " ", 8)
'
'    'Check to see if the last character is a space
'    If Right(txtSerialData.Text, 1) = " " Then
'        'Trim off the space
'        txtSerialData.Text = Left(txtSerialData.Text, Len(txtSerialData.Text) - 1)
'    End If
'
'    'Set the length of the textbox
'    txtSerialData.MaxLength = Len(txtSerialData.Text)
End Sub

Private Sub cmdApplyCTL_Click()
    'Send the new value to the EZUSB-FX2 chip
    EvBd.USBSetPortBuffVal fx2_CTLLines, CtlVal
    EvBd.USBWritePortBuffVal fx2_CTLLines

    'Indicate the button was pressed
    cmdApplyCTL.BackColor = lLoadIndColor
    cmdApplyCTL.Refresh
    Delay 0.06, 1
    
    'Make the background color normal
    cmdApplyCTL.BackColor = vb3DFace
End Sub

Private Sub cmdApplyPA_Click()
    'Send the new value to the EZUSB-FX2 chip
    EvBd.USBSetPortBuffVal fx2_PortA, PortAVal
    EvBd.USBWritePortBuffVal fx2_PortA

    'Indicate the button was pressed
    cmdApplyPA.BackColor = lLoadIndColor
    cmdApplyPA.Refresh
    Delay 0.06, 1
    
    'Make the background color normal
    cmdApplyPA.BackColor = vb3DFace
End Sub

Private Sub cmdApplyPB_Click()
    'Send the new value to the EZUSB-FX2 chip
    EvBd.USBWritePortBuffVal fx2_PortB

End Sub

Private Sub cmdApplyPD_Click()
    'Send the new value to the EZUSB-FX2 chip
    EvBd.USBSetPortBuffVal fx2_PortD, PortDVal
    EvBd.USBWritePortBuffVal fx2_PortD
    
    'Indicate the button was pressed
    cmdApplyPD.BackColor = lLoadIndColor
    cmdApplyPD.Refresh
    Delay 0.06, 1
    
    'Make the background color normal
    cmdApplyPD.BackColor = vb3DFace
    
    'Update related forms
    If IsLoaded("frmChannelFreqs") Then
        frmChannelFreqs.UpdateDisplays
    End If
End Sub

Private Sub cmdDone_Click()
    chkAutoCSBMode.value = 1
End Sub

Private Sub cmdLoad_Click()
    Dim SData As String
    Dim iRegLen As Integer
    Dim iCntr As Integer
    
'    'Get the register length
    iRegLen = EvBd.GetRegLength(cmbRegAddress.ListIndex)
'    'Fix the length of the serial data text
'    txtSerialData.Text = String((iRegLen - Len(Replace(txtSerialData.Text, " ", ""))), "0") & Replace(txtSerialData.Text, " ", "")
'    'Remove the spaces
'    SData = Replace(txtSerialData.Text, " ", "")
    
    'Build up the data
    For iCntr = 0 To iRegLen / 8 - 1
        SData = txtSData(iCntr).Text & SData
        'Reset the foreground color
        txtSData(iCntr).ForeColor = vbWindowText
    Next iCntr
    
    If chkUpRegVal.value = 1 Then
        'Send the data
        EvBd.USBSerialLoad cmbRegAddress.ListIndex, SData
    Else
        'Send the data
        EvBd.USBSerialLoad cmbRegAddress.ListIndex, SData, 1
    End If
    
    'Update the form values
    UpdateFormVals
    If IsLoaded("frmRegDebug") Then
        frmRegDebug.UpdateFormVals
    End If
    
    'Make the background color normal
    cmdLoad.BackColor = vb3DFace
End Sub

Private Sub cmdRdSDIOs_Click()
    Dim iCntr As Integer
        
    'Read port b's value
    PortBVal = EvBd.GetPortBValue()
    
    bUpdating = True
    'Update the display
    EvBd.USBSetPortBuffVal fx2_PortB, PortBVal
    
    'Loop through each bit and update the checkboxes
    For iCntr = 0 To 3
        chkPBIO(iCntr).value = EvBd.USBGetPortBitVal(fx2_PortB, iCntr)
    Next iCntr
    
    bUpdating = False
End Sub

Private Sub cmdRead_Click()
    Dim SData As String
    Dim iCntr As Integer
    Dim iNumOfBytes As Integer
    
    If chkUpRegVal.value = 1 Then
        'Read the data from the usb
        SData = EvBd.USBSerialRead(cmbRegAddress.ListIndex)
    Else
        'Read the data from the usb
        SData = EvBd.USBSerialRead(cmbRegAddress.ListIndex, 1)
    End If
    
    'Get the number of bytes in the data read back
    iNumOfBytes = Len(SData) / 8
    'Split the binary string into 8 bit chunks so that it is easier to read
    For iCntr = iNumOfBytes To 1 Step -1
        txtSData(iNumOfBytes - iCntr).Text = Mid(SData, iCntr * 8 - 7, 8)
        txtSData(iNumOfBytes - iCntr).ForeColor = vbBlue
    Next iCntr

    'Update the form values
    UpdateFormVals
    If IsLoaded("frmRegDebug") Then
        frmRegDebug.UpdateFormVals
    End If
    
    'Make the read back data blue to indicate that it was read back
    For iCntr = iNumOfBytes To 1 Step -1
        txtSData(iNumOfBytes - iCntr).ForeColor = vbBlue
    Next iCntr
End Sub

Private Sub cmdReadDebug_Click()
    Dim SData As String
    Dim iCntr As Integer
    Dim iNumOfBytes As Integer
    
    chkAutoCSBMode.value = 0
    
    'Read the data from the usb
    SData = EvBd.USBSerialRead4BitDaveB(cmbRegAddress.ListIndex)
    Me.UpdateFormVals
    
End Sub

Private Sub cmdRegDebug_Click()
    'If it is not loaded then load it
    If IsLoaded("frmRegDebug") <> False Then
        Load frmRegDebug
    End If
    
    'If hidden then make visible
    If frmRegDebug.Visible = False Then
        frmRegDebug.Show
    End If
    
    'Restore if minimized
    If frmRegDebug.WindowState = vbMinimized Then
        frmRegDebug.WindowState = vbNormal
    End If
    
    'Bring to the top
    frmRegDebug.ZOrder 0
End Sub

Private Sub Command1_Click()

End Sub

Private Sub cmdSendIOReset_Click()
    EvBd.SendIOReset
End Sub

Private Sub Form_Activate()
    'Update the form values
    UpdateFormVals
    'Disable the load flash
    tmrLoadFlash.Enabled = True
End Sub

Private Sub Form_Deactivate()
    'Disable the load flash
    tmrLoadFlash.Enabled = False
End Sub

Private Sub Form_Load()
    lLoadFlashColor = vbGreen
    lLoadIndColor = vb3DHighlight
    
    'Setup the form for the current mode
    SetDebugMode
    
    'Set the address to 0
    cmbRegAddress.ListIndex = 0
    lstChannel.ListIndex = 0
End Sub

Private Sub lsbSerialIOMode_Click()
    If lsbSerialIOMode.ListIndex = 3 Then
        cmdSendIOReset.Enabled = False
    Else
        cmdSendIOReset.Enabled = True
    End If
End Sub

Private Sub lstChannel_Click()
    cmbRegAddress_Click
End Sub

Private Sub tmrLoadFlash_Timer()
    Dim SData As String
    Dim iRegLen As Integer
    Dim iCntr As Integer
    
    'Flash the PortD Load button
    If PortDVal <> EvBd.USBGetPortBuffVal(fx2_PortD) Then
        If cmdApplyPD.BackColor <> vb3DFace Then
            cmdApplyPD.BackColor = vb3DFace
        Else
            cmdApplyPD.BackColor = lLoadFlashColor
        End If
    Else
        If cmdApplyPD.BackColor <> vb3DFace Then
            cmdApplyPD.BackColor = vb3DFace
        End If
    End If

    'Flash the PortA Load button
    If PortAVal <> EvBd.USBGetPortBuffVal(fx2_PortA) Then
        If cmdApplyPA.BackColor <> vb3DFace Then
            cmdApplyPA.BackColor = vb3DFace
        Else
            cmdApplyPA.BackColor = lLoadFlashColor
        End If
    Else
        If cmdApplyPA.BackColor <> vb3DFace Then
            cmdApplyPA.BackColor = vb3DFace
        End If
    End If

    'Flash the CTL Load button
    If CtlVal <> EvBd.USBGetPortBuffVal(fx2_CTLLines) Then
        If cmdApplyCTL.BackColor <> vb3DFace Then
            cmdApplyCTL.BackColor = vb3DFace
        Else
            cmdApplyCTL.BackColor = lLoadFlashColor
        End If
    Else
        If cmdApplyCTL.BackColor <> vb3DFace Then
            cmdApplyCTL.BackColor = vb3DFace
        End If
    End If
    
    'Get the register length
    iRegLen = EvBd.GetRegLength(CInt(cmbRegAddress.Tag))
    'Build up the data
    For iCntr = 0 To iRegLen / 8 - 1
        SData = txtSData(iCntr).Text & SData
    Next iCntr
    'Flash the load button
    If EvBd.GetRegMapValue(rm9911_CurRegMapVals, CInt(cmbRegAddress.Tag), lstChannel.ListIndex) <> SData Then
        If cmdLoad.BackColor <> vb3DFace Then
            cmdLoad.BackColor = vb3DFace
        Else
            cmdLoad.BackColor = lLoadFlashColor
        End If
    Else
        If cmdLoad.BackColor <> vb3DFace Then
            cmdLoad.BackColor = vb3DFace
        End If
    End If

End Sub

Private Sub txtSData_Validate(Index As Integer, Cancel As Boolean)
    txtSData(Index).Text = Replace(txtSData(Index).Text, " ", "")
    
    'If the user didn't enter enough digits then do so for them
    If Len(txtSData(Index).Text) <> 8 Then
        txtSData(Index).Text = String(8 - Len(txtSData(Index).Text), "0") & txtSData(Index).Text
    End If
End Sub

Private Sub txtSerialData_Change()
    Dim iLenNoSpaces As Integer
    Dim sTextNoSpaces As String
    Dim iNumOfSeps As Integer
    Dim iCntr As Integer
    Dim sString1 As String
    Dim sString2 As String
    Dim sNewText As String
    Dim iCurPos As Integer
    
    'Remove all spaces from the string
    sTextNoSpaces = Replace(txtSerialData.Text, " ", "")

    'Get the length of the string
    iLenNoSpaces = Len(sTextNoSpaces)

    'Calculate the number of bytes in the string
    iNumOfSeps = Fix(CDbl(iLenNoSpaces) / 8)

    'Add the spaces back in
    sString2 = SepBytes(sTextNoSpaces) 'InsertChars(sTextNoSpaces, " ", 8)
    If Left(sString2, 1) = " " Then
        sString2 = Right(sString2, Len(sString2) - 1)
    End If

    'Back the cursor up 1
    If txtSerialData.Tag = "BKSP" Then
        txtSerialData.SelStart = txtSerialData.SelStart + 1
        txtSerialData.Tag = ""
    End If
    
    'Get the current cursor pos
    iCurPos = txtSerialData.SelStart

    'Set the textbox value
    txtSerialData.Text = sString2
    
    If iCurPos = 0 Then
        txtSerialData.SelStart = iCurPos
    Else
        txtSerialData.SelStart = iCurPos - 1
    End If

'    If Left(txtSerialData.Text, 1) = " " Then
'        txtSerialData.Text = Right(txtSerialData.Text, Len(txtSerialData.Text) - 1)
'    End If
    
'    If Left(txtSerialData.Text, 8) <> " " Then
'        txtSerialData.Text = " " & txtSerialData.Text
'    End If
End Sub
'Inserts spaces every eight characters
'str   - Input string
Function SepBytes(ByVal Str As String)
    Dim cntr As Integer
    Dim sCharCntr As Integer
    Dim sOutString As String
    Dim N As Integer
    Dim sChar As String
    
    N = 8         'Every 8 Characters
    sChar = " "   'Insert a Space
    
    sCharCntr = 1
    For cntr = Len(Str) To 1 Step -1
        sOutString = Mid(Str, cntr, 1) & sOutString
        If sCharCntr = N Then
            sOutString = sChar & sOutString
            sCharCntr = 1
        Else
            sCharCntr = sCharCntr + 1
        End If
    Next cntr
    'Return the output string
    SepBytes = sOutString
End Function

Private Sub txtSerialData_KeyPress(KeyAscii As Integer)
    'Filter out all keys but binary
    KeyAscii = BinKeysFilter(KeyAscii)
    
    If KeyAscii = 8 Then
        'txtSerialData.SelStart = txtSerialData.SelStart + 1
        txtSerialData.SelLength = 1
        If txtSerialData.SelText = " " Then
            txtSerialData.SelLength = 2
        End If
        txtSerialData.Tag = "BKSP"
    End If
End Sub

'Updates the form values with the current values
Public Sub UpdateFormVals()
    Dim iCntr As Integer
        
    'Update the PortA controls
    bUpdating = True
    
    'Update the I/O Signals
    For iCntr = 0 To 7
        If iCntr >= 0 And iCntr <= 3 Then
            chkPAIO(iCntr).value = EvBd.USBGetPortBitVal(fx2_PortA, iCntr)
            chkPBIO(iCntr).value = EvBd.USBGetPortBitVal(fx2_PortB, iCntr)
        End If
        If iCntr = 0 Then
            chkCTLIO(iCntr).value = EvBd.USBGetPortBitVal(fx2_CTLLines, iCntr)
        End If
        chkPDIO(iCntr).value = EvBd.USBGetPortBitVal(fx2_PortD, iCntr)
    Next iCntr
            
    PortAVal = EvBd.USBGetPortBuffVal(fx2_PortA)
    PortDVal = EvBd.USBGetPortBuffVal(fx2_PortD)
    CtlVal = EvBd.USBGetPortBuffVal(fx2_CTLLines)
        
    'Update the LSB First Indicator
    If EvBd.SPI_LSB_First Then
        'chkLSBFirstMode.Value = 1
        imgLSBFirstMode.Picture = frmGraphics.imgGreenLed(1)
    Else
        'chkLSBFirstMode.Value = 0
        imgLSBFirstMode.Picture = frmGraphics.imgGreenLed(0)
    End If
    
    'Update the Serial I/O Mode Display
    'lsbSerialIOMode.ListIndex = EvBd.SPI_IOMode
    Select Case EvBd.SPI_IOMode
        Case spi3Wire:
            imgIOMode(0).Picture = frmGraphics.imgGreenLed(1)
            imgIOMode(1).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(2).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(3).Picture = frmGraphics.imgGreenLed(0)
        Case spi4Wire:
            imgIOMode(0).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(1).Picture = frmGraphics.imgGreenLed(1)
            imgIOMode(2).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(3).Picture = frmGraphics.imgGreenLed(0)
        Case spi2BitSerial:
            imgIOMode(0).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(1).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(2).Picture = frmGraphics.imgGreenLed(1)
            imgIOMode(3).Picture = frmGraphics.imgGreenLed(0)
        Case spi4BitSerial:
            imgIOMode(0).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(1).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(2).Picture = frmGraphics.imgGreenLed(0)
            imgIOMode(3).Picture = frmGraphics.imgGreenLed(1)
    End Select
    
    'Update the AutoIOUpdate
    If EvBd.AutoIOUpdate Then
        chkAutoUpdate.value = 1
    Else
        chkAutoUpdate.value = 0
    End If
        
    If EvBd.SetLEDBlink(2) Then
        chklFlashUSBStatus.value = 1
    Else
        chklFlashUSBStatus.value = 0
    End If
        
    'Click the register address
    cmbRegAddress_Click
    
    bUpdating = False
End Sub

'This sub changes the GUI depending on the engineering mode which is set by the
'global variable iEngMode
Public Sub SetDebugMode()
    Dim iCntr As Integer
    Dim iIdx As Integer
    
    'Get the index
    iIdx = cmbRegAddress.ListIndex
    
    Select Case iEngMode
        Case 1: 'Debug Mode
            cmbRegAddress.Clear
            For iCntr = 0 To &H18
                cmbRegAddress.AddItem cbaseHex(iCntr, 2) & "   Hex"
            Next iCntr
            Me.Width = 7545
        Case 2: 'Engineering Mode
            cmbRegAddress.Clear
            For iCntr = 0 To &H1B
                cmbRegAddress.AddItem cbaseHex(iCntr, 2) & "   Hex"
            Next iCntr
            Me.Width = 7545
        Case 3: 'Extended Engineering Mode
            cmbRegAddress.Clear
            For iCntr = 0 To &H1B
                cmbRegAddress.AddItem cbaseHex(iCntr, 2) & "   Hex"
            Next iCntr
            Me.Width = 9465
        Case Else 'Normal Mode
            cmbRegAddress.Clear
            For iCntr = 0 To &H18
                cmbRegAddress.AddItem cbaseHex(iCntr, 2) & "   Hex"
            Next iCntr
            Me.Width = 7545
    End Select
    
    'Test to see if the selected listindex is avaliable
    If iIdx <= cmbRegAddress.ListCount - 1 Then
        cmbRegAddress.ListIndex = iIdx
    Else
        cmbRegAddress.ListIndex = 0
    End If
End Sub

