VERSION 5.00
Begin VB.Form frmDDEServ 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "DDE Server"
   ClientHeight    =   5895
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6135
   Icon            =   "frmDDEServ.frx":0000
   LinkMode        =   1  'Source
   LinkTopic       =   "frmDDEServ"
   MaxButton       =   0   'False
   ScaleHeight     =   5895
   ScaleWidth      =   6135
   Begin VB.TextBox txtDDELinkTopic 
      BackColor       =   &H80000018&
      Height          =   285
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   12
      ToolTipText     =   "Use the text in this textbox as the link topic to link to this application."
      Top             =   4920
      Width           =   5895
   End
   Begin VB.TextBox txtDDELinkItem 
      BackColor       =   &H80000018&
      Height          =   285
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   11
      ToolTipText     =   "Use the text in this textbox as the link item to link to this application."
      Top             =   5520
      Width           =   2175
   End
   Begin VB.CommandButton cmdClearDDEConversation 
      Caption         =   "Clear DDE Data"
      Height          =   375
      Left            =   3600
      TabIndex        =   10
      Top             =   120
      Width           =   1455
   End
   Begin VB.CheckBox chkLogDDEData 
      Caption         =   "Log DDE Conversation"
      Height          =   255
      Left            =   1440
      TabIndex        =   9
      Top             =   120
      Width           =   2055
   End
   Begin VB.Frame fraConfigPgTab 
      Height          =   495
      Index           =   0
      Left            =   120
      TabIndex        =   5
      Top             =   480
      Width           =   2295
      Begin VB.Label lblBlank 
         Height          =   135
         Left            =   25
         TabIndex        =   8
         Top             =   360
         Width           =   2220
      End
      Begin VB.Label lblConfigTabCaption 
         Caption         =   "Client Commands Received"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   6
         Top             =   120
         Width           =   2055
      End
   End
   Begin VB.Frame fraConfigure 
      Height          =   3135
      Index           =   0
      Left            =   120
      TabIndex        =   4
      Top             =   840
      Width           =   5895
      Begin VB.TextBox txtDDEConversation 
         BackColor       =   &H00FFFFFF&
         BeginProperty Font 
            Name            =   "Terminal"
            Size            =   9
            Charset         =   255
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   2775
         IMEMode         =   3  'DISABLE
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   7
         Text            =   "frmDDEServ.frx":0442
         Top             =   240
         Width           =   5655
      End
   End
   Begin VB.TextBox txtDDE 
      Height          =   285
      Left            =   120
      TabIndex        =   1
      Text            =   "txtDDE - This text box is where the DDE link is made."
      Top             =   4320
      Width           =   5895
   End
   Begin VB.Label lblDDELinkTopic 
      Caption         =   "DDE Link Topic:"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   14
      Top             =   4680
      Width           =   1575
   End
   Begin VB.Label lblDDELinkItem 
      Caption         =   "DDE Link Item:"
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   5280
      Width           =   2175
   End
   Begin VB.Label lblNumClients 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      Height          =   255
      Left            =   720
      TabIndex        =   3
      Top             =   120
      Width           =   375
   End
   Begin VB.Label lblServerText 
      Caption         =   "Server Response String:"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   4080
      Width           =   1935
   End
   Begin VB.Label lblDDEConv 
      Caption         =   "Clients:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   615
   End
End
Attribute VB_Name = "frmDDEServ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'************************************************************************
'* frmDDEServ.frm - Drop-in DDE (Dynamic Data Exchange) Server          *
'* Developed by:                                                        *
'* Shane Lambeth - 2/6/2004                                             *
'************************************************************************
'* PURPOSE:                                                             *
'* This form was desgned to be a drop-in solution for DDE automation of *
'* software.  Once this form has been added to a project the programmer *
'* can add DDE server capability to a project easily.                   *
'*                                                                      *
'* Client communication with the server:                                *
'* The client application's command strings are received through the    *
'* forms LinkExecute event. This is where all DDE command strings       *
'* should be processed.                                                 *
'*                                                                      *
'* Server communication with the client app:                            *
'* The server communicates with the client app by puting response data  *
'* in the txtDDE textbox which the client app is linked to, it is up to *
'* the client app to handle response strings.                           *
'*                                                                      *
'************************************************************************
'* ROUTINES TO MODIFY                                                   *
'* Form_LinkExecute() - This is the main DDE command processor routine. *
'*                      This is where you add your DDE command strings. *
'*                                                                      *
'************************************************************************
'* IMPORTANT NOTES:                                                     *
'* The form name should remain frmDDEServ and the DDE connection        *
'* control's name should remain txtDDE, because this is how the client  *
'* application connects to the server.                                  *
'*                                                                      *
'************************************************************************
'* Revision history                                                     *
'* 0.01 - 2/6/2004 - Initaial beta version for deveolpment.             *
'* 0.02 - 04/20/2004 - Added DDE Link Information                       *
'************************************************************************

Public DDEClients As Integer
Private Const DDEServerRev = "0.02"
Private Const sInvalidCmdStr = "Invalid Command String!"

Private Sub Form_Load()
    'Clear the default text from the window.
    txtDDEConversation.Text = ""
    txtDDE.Text = ""

    'Set the DDE Link information textboxes
    txtDDELinkTopic.Text = App.Title & "|" & Me.Name
    txtDDELinkItem.Text = txtDDE.Name
End Sub

Private Sub cmdClearDDEConversation_Click()
    'Clear the DDE Conversation Text
    txtDDEConversation.Text = ""
End Sub

Private Sub Form_LinkClose()
    'Decrement the number of clients counter.
    DDEClients = DDEClients - 1
        
    'Add conversation text line
    LogDDEConversation "DDE Connection Ended by Client"
    
    'Update the label
    lblNumClients.Caption = DDEClients
    lblNumClients.Refresh
End Sub

'*************************************************************************
'* This event acts as the main command processor.                        *
'*************************************************************************
Private Sub Form_LinkExecute(CmdStr As String, Cancel As Integer)
    Dim SData As String
    Dim sCmd As String
    Dim iCmdSepLoc As Integer  'Command delimiter
    
    'Clear the textbox, this causes a change event to fire for the textbox
    'which in turn causes a LinkNotify event to fire on the client, which
    'signals to the client that the command was received and is about to
    'be processed.
    txtDDE.Text = ""
    
    'Test to see if the command is a request string
    If Right(CmdStr, 1) = "?" Then
        'The client is requesting data
        Select Case CmdStr
            Case "Server.Rev?"
                txtDDE.Text = DDEServerRev
                'Log to DDEConversation Textbox
                LogDDEConversation CmdStr & " = " & txtDDE.Text
                Cancel = 0
            Case "Server.HostApp.Name?"
                txtDDE.Text = App.ProductName
                'Log to DDEConversation Textbox
                LogDDEConversation CmdStr & " = " & txtDDE.Text
                Cancel = 0
            Case "Server.HostApp.Rev?"
                txtDDE.Text = App.Major & "." & App.Minor
                'Log to DDEConversation Textbox
                LogDDEConversation CmdStr & " = " & txtDDE.Text
                Cancel = 0
            Case "Server.HostApp.Visible?"
                '****** Modify this code for your app ************
                txtDDE.Text = mdiMain.Visible
                'Log to DDEConversation Textbox
                LogDDEConversation CmdStr & " = " & txtDDE.Text
                Cancel = 0
            Case Else
                'Respond with the standard bad command string
                txtDDE.Text = sInvalidCmdStr
                'Add conversation text line
                LogDDEConversation txtDDE.Text
                Cancel = 0
        End Select
    Else
        'The client is sending a command with data
        'separate the command from the data
        iCmdSepLoc = InStr(1, CmdStr, "=")
        
        If iCmdSepLoc = 0 Then
            'The command has no data sent with it.
            Select Case CmdStr
                Case "Server.Terminate"
                    txtDDE.Text = "Bonzai!"
                    Cancel = 0
                    'Add your code here to properly terminate your app.
                    ExitGracefully
                Case Else
                    'Respond with the standard bad command string
                    txtDDE.Text = sInvalidCmdStr
                    'Add conversation text line
                    LogDDEConversation txtDDE.Text
                    Cancel = 0
            End Select
        Else
            sCmd = Left(CmdStr, iCmdSepLoc - 1)
            SData = Mid(CmdStr, iCmdSepLoc + 1, Len(CmdStr) - iCmdSepLoc)
                    
            Select Case sCmd
                Case "Server.HostApp.Visible"
                '****** Modify this code for your app ************
                    mdiMain.Visible = CBool(SData)
                    txtDDE.Text = sCmd & "=" & CBool(SData)
                    Cancel = 0
                Case Else
                    'Respond with the standard bad command string
                    txtDDE.Text = sInvalidCmdStr
                    'Add conversation text line
                    LogDDEConversation txtDDE.Text
                    Cancel = 0
            End Select
        End If
    End If
End Sub

Private Sub Form_LinkOpen(Cancel As Integer)
    'Increment the number of clients counter.
    DDEClients = DDEClients + 1
    
    'Add conversation text line
    LogDDEConversation "DDE Connection Established..."
    
    'Respond back to the client
    txtDDE.Text = "Connection Accepted!"
    
    'Update the label
    lblNumClients.Caption = DDEClients
    lblNumClients.Refresh
End Sub

'Adds a line to the status window
Public Sub AddLine(ByVal tBox As TextBox, ByVal strLine As String)
    With tBox
        If .Text = "" Then
            .Text = strLine
        Else
            .SelStart = Len(.Text)
            .SelText = vbNewLine & strLine
        End If
        'Refresh the textbox
        .Refresh
    End With
End Sub

'Logs the DDEText passed to the text box.
Public Sub LogDDEConversation(ByVal sDDEText As String)
    If chkLogDDEData.Value Then
        AddLine txtDDEConversation, sDDEText
    End If
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Do not allow the user to close the window instead
    'just hide it.
    If UnloadMode = vbFormControlMenu Then
        Cancel = 1
    End If
    Me.Hide
    'Check the menu used to show the window
'    mdiMain.mnuViewControlWindow.Checked = False
End Sub

