VERSION 5.00
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmDDEClient 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "DDE Client"
   ClientHeight    =   3855
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5415
   Icon            =   "frmDDEClient.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3855
   ScaleWidth      =   5415
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Get Server Rev."
      Height          =   375
      Left            =   120
      TabIndex        =   23
      Top             =   3960
      Width           =   1335
   End
   Begin MSComDlg.CommonDialog cdgBrowse 
      Left            =   4800
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin TabDlg.SSTab sstSettings 
      Height          =   3615
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   5175
      _ExtentX        =   9128
      _ExtentY        =   6376
      _Version        =   393216
      Style           =   1
      TabsPerRow      =   4
      TabHeight       =   520
      TabCaption(0)   =   "DDE Connection"
      TabPicture(0)   =   "frmDDEClient.frx":0442
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "Label1"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).Control(1)=   "lblDDE"
      Tab(0).Control(1).Enabled=   0   'False
      Tab(0).Control(2)=   "lblServerCommand"
      Tab(0).Control(2).Enabled=   0   'False
      Tab(0).Control(3)=   "fraDDELinkSettings"
      Tab(0).Control(3).Enabled=   0   'False
      Tab(0).Control(4)=   "cmdOpenDDE"
      Tab(0).Control(4).Enabled=   0   'False
      Tab(0).Control(5)=   "cmdShowServerMessage"
      Tab(0).Control(5).Enabled=   0   'False
      Tab(0).Control(6)=   "cmdCloseDDE"
      Tab(0).Control(6).Enabled=   0   'False
      Tab(0).Control(7)=   "txtServerCmd"
      Tab(0).Control(7).Enabled=   0   'False
      Tab(0).ControlCount=   8
      TabCaption(1)   =   "Server Settings"
      TabPicture(1)   =   "frmDDEClient.frx":045E
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "fraSrvrLoc"
      Tab(1).Control(1)=   "cmdLaunchServer"
      Tab(1).Control(2)=   "lblServerTaskID"
      Tab(1).Control(3)=   "lblSvrTaskID"
      Tab(1).ControlCount=   4
      TabCaption(2)   =   "DDE Conversation"
      TabPicture(2)   =   "frmDDEClient.frx":047A
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "cmdClearDDEData"
      Tab(2).Control(1)=   "chkLogDDEConversation"
      Tab(2).Control(2)=   "txtDDEConversation"
      Tab(2).ControlCount=   3
      Begin VB.CommandButton cmdClearDDEData 
         Caption         =   "Clear DDE Data"
         Height          =   375
         Left            =   -72480
         TabIndex        =   22
         Top             =   3000
         Width           =   1335
      End
      Begin VB.CheckBox chkLogDDEConversation 
         Caption         =   "Log DDE Conversation"
         Height          =   255
         Left            =   -74880
         TabIndex        =   21
         Top             =   3000
         Value           =   1  'Checked
         Width           =   2175
      End
      Begin VB.TextBox txtServerCmd 
         Height          =   285
         Left            =   1560
         TabIndex        =   19
         Text            =   "Server.Rev?"
         Top             =   3240
         Width           =   3495
      End
      Begin VB.TextBox txtDDEConversation 
         BeginProperty Font 
            Name            =   "Terminal"
            Size            =   9
            Charset         =   255
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   2415
         Left            =   -74880
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   18
         Top             =   480
         Width           =   4935
      End
      Begin VB.CommandButton cmdCloseDDE 
         Caption         =   "Close DDE Session"
         Height          =   375
         Left            =   3360
         TabIndex        =   15
         Top             =   2400
         Width           =   1695
      End
      Begin VB.CommandButton cmdShowServerMessage 
         Caption         =   "Send Server Command"
         Height          =   495
         Left            =   120
         TabIndex        =   14
         Top             =   3000
         Width           =   1335
      End
      Begin VB.CommandButton cmdOpenDDE 
         Caption         =   "Open DDE Session"
         Height          =   375
         Left            =   120
         TabIndex        =   13
         Top             =   2400
         Width           =   1695
      End
      Begin VB.Frame fraDDELinkSettings 
         Caption         =   "DDE Link Settings"
         Height          =   1095
         Left            =   120
         TabIndex        =   8
         Top             =   480
         Width           =   4935
         Begin VB.TextBox txtLinkItem 
            Height          =   285
            Left            =   960
            Locked          =   -1  'True
            TabIndex        =   10
            Text            =   "txtDDE"
            Top             =   360
            Width           =   2415
         End
         Begin VB.TextBox txtLinkTopic 
            Height          =   285
            Left            =   960
            TabIndex        =   9
            Text            =   "MyServer|frmDDEServ"
            Top             =   720
            Width           =   3735
         End
         Begin VB.Label lblDataNotSet 
            BackColor       =   &H00FF0000&
            Height          =   345
            Index           =   0
            Left            =   915
            TabIndex        =   27
            Top             =   330
            Visible         =   0   'False
            Width           =   2505
         End
         Begin VB.Label lblDataNotSet 
            BackColor       =   &H00FF0000&
            Height          =   340
            Index           =   1
            Left            =   920
            TabIndex        =   26
            Top             =   690
            Visible         =   0   'False
            Width           =   3825
         End
         Begin VB.Label lblLinkItem 
            Caption         =   "Link Item:"
            Height          =   255
            Left            =   120
            TabIndex        =   12
            Top             =   360
            Width           =   855
         End
         Begin VB.Label lblLinkTopic 
            Caption         =   "Link Topic:"
            Height          =   255
            Left            =   120
            TabIndex        =   11
            Top             =   720
            Width           =   855
         End
      End
      Begin VB.Frame fraSrvrLoc 
         Caption         =   "Location"
         Height          =   1215
         Left            =   -74880
         TabIndex        =   2
         Top             =   480
         Width           =   4935
         Begin VB.CommandButton cmdServerBrowse 
            Caption         =   "..."
            Height          =   285
            Left            =   90
            TabIndex        =   4
            Top             =   720
            Width           =   295
         End
         Begin VB.TextBox txtServerPath 
            Height          =   285
            Left            =   390
            TabIndex        =   3
            Top             =   720
            Width           =   4455
         End
         Begin VB.Label lblMsg1 
            Caption         =   "Locate the server and enter the path in the textbox below."
            ForeColor       =   &H00FF0000&
            Height          =   375
            Left            =   120
            TabIndex        =   5
            Top             =   360
            Width           =   4695
         End
      End
      Begin VB.CommandButton cmdLaunchServer 
         Caption         =   "Launch Server"
         Enabled         =   0   'False
         Height          =   375
         Left            =   -74880
         TabIndex        =   1
         Top             =   1800
         Width           =   1455
      End
      Begin VB.Label lblServerCommand 
         Caption         =   "Server Command:"
         Height          =   255
         Left            =   1560
         TabIndex        =   20
         Top             =   3000
         Width           =   1335
      End
      Begin VB.Label lblDDE 
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "This label is the main DDE link between the apps."
         ForeColor       =   &H00000000&
         Height          =   285
         Left            =   120
         LinkItem        =   "txtDDE"
         LinkTopic       =   "AD9956 Evaluation Software|frmDDEServ"
         TabIndex        =   16
         Top             =   1920
         Width           =   4935
      End
      Begin VB.Label Label1 
         Caption         =   "Server Response:"
         Height          =   255
         Left            =   120
         TabIndex        =   17
         Top             =   1680
         Width           =   1335
      End
      Begin VB.Label lblServerTaskID 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Enabled         =   0   'False
         Height          =   255
         Left            =   -72000
         TabIndex        =   7
         Top             =   1800
         Width           =   1455
      End
      Begin VB.Label lblSvrTaskID 
         Caption         =   "Server TaskID:"
         Enabled         =   0   'False
         Height          =   255
         Left            =   -73200
         TabIndex        =   6
         Top             =   1800
         Width           =   1095
      End
   End
   Begin VB.Label Label3 
      Height          =   255
      Left            =   2880
      TabIndex        =   25
      Top             =   3960
      Width           =   1815
   End
   Begin VB.Label Label2 
      Caption         =   "Server Revision = "
      Height          =   255
      Left            =   1560
      TabIndex        =   24
      Top             =   3960
      Width           =   1335
   End
End
Attribute VB_Name = "frmDDEClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'************************************************************************
'* frmDDEServ.frm - Drop-in DDE (Dynamic Data Exchange) Client Form     *
'* Developed by:                                                        *
'* Shane Lambeth - 2/6/2004                                             *
'************************************************************************
'* PURPOSE:                                                             *
'* This form was desgned to be a drop-in solution for DDE automation of *
'* software.  Once this form has been added to a project the programmer *
'* can add DDE client capability to a project easily.                   *
'*                                                                      *
'* Client communication with the server:                                *
'* The client application's command strings are received through the    *
'* forms LinkExecute event. This is where all DDE command strings       *
'* should be processed.                                                 *
'*                                                                      *
'* Server communication with the client app:                            *
'* The server communicates with the client app by puting response data  *
'* in the txtDDE textbox which the client app is linked to, it is up to *
'* the client app to handle response strings.                           *
'*                                                                      *
'************************************************************************
'* ROUTINES TO MODIFY                                                   *
'* Form_LinkExecute() - This is the main DDE command processor routine. *
'*                      This is where you add your DDE command strings. *
'*                                                                      *
'************************************************************************
'* IMPORTANT NOTES:                                                     *
'* The form name should remain frmDDEServ and the DDE connection        *
'* control's name should remain txtDDE, because this is how the client  *
'* application connects to the server.                                  *
'*                                                                      *
'************************************************************************
'* Revision history                                                     *
'* 0.01 - 02/06/2004 - Initial beta version for development.            *
'* 0.02 - 04/20/2004 - Added datanotset indicators around the linktopic *
'*                     and linkitem textboxes.                          *
'************************************************************************
Dim m_ServerTaskID As Double

'API Commands
Private Declare Function OpenProcess Lib "kernel32" (ByVal dwDesiredAccess As Long, _
    ByVal bInheritHandle As Long, ByVal dwProcessId As Long) As Long

Private Declare Function GetExitCodeProcess Lib "kernel32" _
       (ByVal hProcess As Long, lpExitCode As Long) As Long

Const PROCESS_QUERY_INFORMATION = &H400
Private Sub Form_Load()
'    sstSettings.TabVisible(2) = False
    txtLinkItem.Text = lblDDE.LinkItem
    txtLinkTopic.Text = lblDDE.LinkTopic
End Sub


Private Sub cmdClearDDEData_Click()
    'Clear the text field
    txtDDEConversation.Text = ""
End Sub

Private Sub cmdCloseDDE_Click()
    'Close DDE Session
    lblDDE.LinkMode = 0
    '
End Sub

Private Sub cmdLaunchServer_Click()
    Dim retval As Variant
    retval = Shell(txtServerPath.Text, vbNormalNoFocus)
    
    If retval = 0 Then
        'Clear the server task ID
        ServerTaskID = "0"
        
        'Disable the Displays to signafy that the launch failed
        lblSvrTaskID.Enabled = False
        lblServerTaskID.Enabled = False
        
        'Display an error message
        MsgBox "Error launching the server.", vbCritical, "Error!"
    Else
        'Set the ServerTaskID property
        ServerTaskID = CDbl(retval)
        
        'Enable the TaskID displays
        lblSvrTaskID.Enabled = True
        lblServerTaskID.Enabled = True
    End If
End Sub

Private Sub cmdOpenDDE_Click()
    On Error GoTo ErrorHandler
    'Enable DDE session, beleive it or not this is all it takes
    lblDDE.LinkMode = 3
    
    'Exit the subroutine before the errorhandler
    Exit Sub
    
ErrorHandler:
    Select Case Err.Number
        Case 282: 'No Server Running
            MsgBox "No server was found!"
        Case Else
            MsgBox "Error number " & Err.Number & "!" & vbCrLf & Err.Description, vbCritical & vbApplicationModal, "Error Opening DDE Connection"
    End Select
End Sub

Private Sub cmdServerBrowse_Click()
    'Setup an error handler
    On Error GoTo ErrorHandler
    
    'Setup the common dialog for opening files
    cdgBrowse.flags = cdlOFNFileMustExist + cdlOFNHideReadOnly + cdlOFNLongNames + cdlOFNNoChangeDir
    cdgBrowse.DialogTitle = "Browse for Server Application"
    cdgBrowse.CancelError = True
    cdgBrowse.Filter = "Executable Files (*.exe)|*.exe|All Files (*.*)|*.*"
    cdgBrowse.FilterIndex = 0
    cdgBrowse.InitDir = App.path

    'Show the open dialog
    cdgBrowse.ShowOpen
    
    'Load the current setup file in to the program and DUT
    txtServerPath.Text = cdgBrowse.Filename
    txtServerPath.ToolTipText = cdgBrowse.Filename
    
    'Exit the subroutine before the errorhandler
    Exit Sub

'Define an error handler
ErrorHandler:
    'Check for the cancel button hit error
    If Err.Number = cdlCancel Then
        'Exit the subroutine if the cancel button was hit
        Exit Sub
    End If
End Sub

Private Sub cmdShowServerMessage_Click()
    Dim sMsg As String
        
    On Error GoTo ErrorHandler
    lblDDE.LinkExecute txtServerCmd.Text
        
    'Exit the subroutine before the error handler
    Exit Sub

ErrorHandler:
    Select Case Err.Number
        Case 293: 'DDE Session not yet open
            'Open the dde session by clicking the open session button
            MsgBox "Error: No DDE Session Open!", vbCritical
        Case Else
            MsgBox "Error number " & Err.Number & "!" & vbCrLf & Err.Description, vbCritical, "Error Opening DDE Connection"
    End Select
End Sub


Private Sub Command1_Click()
    Label3.Caption = ""
    Label3.Caption = frmClient.SendDDEQuery("Server.Rev?")
End Sub


Private Sub Form_Unload(Cancel As Integer)
    cmdCloseDDE_Click
End Sub

'Occurs when the link is closed
Private Sub lblDDE_LinkClose()
'    Dim ProcRun As Long
'
'    ProcRun = GetProcessExitCode(m_ServerTaskID)
'
'    If ProcRun Then
'        ServerTaskID = 0
'    End If
    
    LogConversationText "DDE Connection Terminated..."
End Sub

Private Sub lblDDE_LinkError(LinkErr As Integer)
'    Debug.Print LinkErr
End Sub

'*********** This is the main DDE command processor ********************
Private Sub lblDDE_LinkNotify()
    'Occurs when the server requests an update
    'server data is returned in the caption property of this label
    
    'Get the new data
    lblDDE.LinkRequest

    'Log Conversation Data
    
    'This is the dde command processor for the form
    Select Case lblDDE.Caption
        Case Else
    End Select

End Sub

Private Sub lblDDE_LinkOpen(Cancel As Integer)
    'Occurs when the link is established
    LogConversationText "DDE Connection Established..."
End Sub

Private Sub txtLinkTopic_Change()
    If txtLinkTopic.Text = frmDDEClient.lblDDE.LinkTopic Then
        lblDataNotSet(1).Visible = False
    Else
        lblDataNotSet(1).Visible = True
    End If
End Sub

Private Sub txtLinkTopic_KeyPress(KeyAscii As Integer)
    'Modify the linktopic
    If KeyAscii = 13 Then
        lblDDE.LinkTopic = txtLinkTopic.Text
        KeyAscii = 0
        'Hide the DataNotSet indicator
        If txtLinkTopic.Text = frmDDEClient.lblDDE.LinkTopic Then
            lblDataNotSet(1).Visible = False
        Else
            lblDataNotSet(1).Visible = True
        End If
    End If
End Sub

Private Sub txtServerPath_Change()
    On Error GoTo ErrorHandler
    
    'If the path in the server path textbox points to a file then enable the launch button
    If txtServerPath.Text <> "" And UCase(Right(txtServerPath.Text, 3)) = UCase("exe") Then
        cmdLaunchServer.Enabled = FileExists(txtServerPath.Text)
    Else
        cmdLaunchServer.Enabled = False
    End If

    Exit Sub
    
ErrorHandler:
    cmdLaunchServer.Enabled = False
End Sub

Public Property Get ServerTaskID() As Double
    'Set the server TaskID
    ServerTaskID = m_ServerTaskID
End Property

Private Property Let ServerTaskID(ByVal vNewValue As Double)
    'Set the new server TaskID
    m_ServerTaskID = vNewValue
    lblServerTaskID.Caption = Format(vNewValue, "0")
End Property
'This function will return True if the file exists and False if it doesn't
Private Function FileExists(File As String) As Boolean
    If Dir(File) = "" Then
        FileExists = False
    Else
        FileExists = True
    End If
End Function

'Gets the process exit code.
Public Function GetProcessExitCode(ByVal lPID As Long) As Long
        Dim lProcessHndle As Long
        Dim lExitCode As Long
        
        'Get a handle to the process so that we can check to see if it has terminated
        lProcessHndle = OpenProcess(PROCESS_QUERY_INFORMATION, False, lPID)
        
        'Get the exit code
        Call GetExitCodeProcess(lProcessHndle, lExitCode)
        
        'Return the value
        GetProcessExitCode = lExitCode
End Function

'Adds a line to the status window
Public Sub AddLine(ByVal tBox As TextBox, ByVal strLine As String)
    With tBox
        If .Text = "" Then
            .Text = strLine
        Else
            .SelStart = Len(.Text)
            .SelText = vbNewLine & strLine
        End If
        'Refresh the textbox
        .Refresh
    End With
End Sub

'Logs DDE Conversation Text to the DDE Conversation Data textbox
Public Sub LogConversationText(ByVal sDDEText As String)
'    On Error Resume Next
        
    If chkLogDDEConversation.value Then
        AddLine txtDDEConversation, sDDEText
    End If
End Sub
'Sends a dde command string to the server
Public Function SendDDECommand(ByVal sCmd As String) As Boolean
    'Set the command in the textbox
    txtServerCmd.Text = sCmd
    
    'Click the command button
    cmdShowServerMessage_Click
    
    'Let the server respond
    DoEvents
    
    'Return the
    If lblDDE.Caption <> "" Then
        SendDDECommand = False
    Else
        SendDDECommand = True
    End If
    
End Function
'Posts a dde query string to the server
Public Function SendDDEQuery(ByVal sQry As String) As String
    'Set the command in the textbox
    txtServerCmd.Text = sQry
    
    'Click the command button
    cmdShowServerMessage_Click
    
    'Let the server respond
    DoEvents
    
    'Return the
    SendDDEQuery = lblDDE.Caption
End Function
