VERSION 5.00
Begin VB.Form frmControl 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Chip Level Control"
   ClientHeight    =   5895
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7695
   Icon            =   "frmControl.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   5895
   ScaleWidth      =   7695
   Begin VB.Timer tmrLoadFlash 
      Interval        =   200
      Left            =   7200
      Top             =   4320
   End
   Begin VB.Frame fraEngModeStuff 
      Caption         =   "Operational Mode"
      Height          =   1095
      Left            =   5640
      TabIndex        =   40
      Top             =   960
      Width           =   1935
      Begin VB.ListBox lstComMode 
         Height          =   645
         ItemData        =   "frmControl.frx":014A
         Left            =   120
         List            =   "frmControl.frx":0154
         TabIndex        =   41
         Top             =   360
         Width           =   1695
      End
   End
   Begin VB.CheckBox chkMultiChipSync 
      Caption         =   " Multi Device   Sync..."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   5640
      Style           =   1  'Graphical
      TabIndex        =   12
      ToolTipText     =   "Displays the multi-device sync window"
      Top             =   240
      Width           =   1935
   End
   Begin VB.Frame fraAcummControl 
      Caption         =   "All Channel Accumulator Control"
      Height          =   1455
      Left            =   120
      TabIndex        =   26
      Top             =   2400
      Width           =   3015
      Begin VB.CheckBox chkMasterAClrPhaseAcc 
         Caption         =   "Auto Clear Phase Accumulator"
         Height          =   255
         Left            =   120
         TabIndex        =   8
         Top             =   360
         Width           =   2655
      End
      Begin VB.CheckBox chkMasterClrPhaseAcc 
         Caption         =   "Clear Phase Accumulator"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   600
         Width           =   2655
      End
      Begin VB.CheckBox chkMastClrFreqAcc 
         Caption         =   "Clear Sweep Accumulator"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   1080
         Width           =   2655
      End
      Begin VB.CheckBox chkMastAClrFreqAccum 
         Caption         =   "Auto Clear Sweep Accumulator"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   840
         Width           =   2655
      End
   End
   Begin VB.Frame fraPowerDown 
      Caption         =   "All Channel Power Down"
      Height          =   3255
      Left            =   3240
      TabIndex        =   24
      Top             =   120
      Width           =   2295
      Begin VB.CheckBox chkSyncClkOutDisable 
         Caption         =   "Disable SyncCLK Out"
         Height          =   255
         Left            =   240
         TabIndex        =   43
         ToolTipText     =   "Disables the Sync Clock Output Pin"
         Top             =   960
         Width           =   1935
      End
      Begin VB.Frame fraPwrDwnPin 
         Caption         =   "External PD Control"
         Height          =   1815
         Left            =   120
         TabIndex        =   27
         Top             =   1320
         Width           =   2055
         Begin VB.PictureBox pbxPwrDwnBtnWrpr 
            BorderStyle     =   0  'None
            Height          =   1335
            Left            =   120
            ScaleHeight     =   1335
            ScaleWidth      =   1815
            TabIndex        =   28
            Top             =   360
            Width           =   1815
            Begin VB.CheckBox chkPwrDwnPin 
               BackColor       =   &H00FFFFC0&
               Caption         =   "Power Down Pin"
               BeginProperty Font 
                  Name            =   "MS Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   700
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   375
               Left            =   0
               Style           =   1  'Graphical
               TabIndex        =   7
               ToolTipText     =   "When pressed the ""PWR_DWN_CTL"" pin is a logic High, When pressed the ""PWR_DWN_CTL"" pin is a logic Low "
               Top             =   960
               Width           =   1815
            End
            Begin VB.ListBox lstExtPwrDwnMode 
               Height          =   645
               ItemData        =   "frmControl.frx":017E
               Left            =   0
               List            =   "frmControl.frx":0188
               TabIndex        =   6
               Top             =   240
               Width           =   1815
            End
            Begin VB.Label lblPDPMode 
               Caption         =   "Power Down Pin Mode:"
               Height          =   255
               Left            =   0
               TabIndex        =   29
               Top             =   0
               Width           =   1815
            End
         End
      End
      Begin VB.CheckBox chkDacRefPwDwn 
         Caption         =   "DAC Ref"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   600
         Width           =   1215
      End
      Begin VB.CheckBox chkClkInpPwDwn 
         Caption         =   "Clock Input"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdRead 
      Caption         =   "READ"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6000
      TabIndex        =   14
      Top             =   5400
      Width           =   1575
   End
   Begin VB.CommandButton cmdLoad 
      Caption         =   "LOAD"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6000
      TabIndex        =   13
      Top             =   4920
      Width           =   1575
   End
   Begin VB.Frame fraClock 
      Caption         =   "Clock"
      Height          =   2175
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3015
      Begin VB.ComboBox lstChargePumpCtrl 
         Height          =   315
         ItemData        =   "frmControl.frx":01AD
         Left            =   1200
         List            =   "frmControl.frx":01BD
         Style           =   2  'Dropdown List
         TabIndex        =   44
         Top             =   1080
         Width           =   1095
      End
      Begin VB.CheckBox chkVCOGain 
         Caption         =   "VCO Gain"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   1800
         Width           =   1095
      End
      Begin VB.ComboBox cmbRFDividerRatio 
         Height          =   315
         ItemData        =   "frmControl.frx":01E0
         Left            =   1200
         List            =   "frmControl.frx":021A
         Style           =   2  'Dropdown List
         TabIndex        =   2
         ToolTipText     =   "Multiplies ref clock to get a higher sytem clock."
         Top             =   675
         Width           =   1095
      End
      Begin VB.TextBox txtRefClk 
         Height          =   285
         Left            =   1200
         TabIndex        =   1
         Text            =   "100"
         ToolTipText     =   "Reference Frequency -  Should not exceed 500 MHz."
         Top             =   360
         Width           =   1095
      End
      Begin VB.TextBox txtSysClkTxt 
         Height          =   285
         Left            =   1200
         Locked          =   -1  'True
         TabIndex        =   15
         Text            =   "100"
         ToolTipText     =   "System Clock - Should not exceed 500 MHz."
         Top             =   1440
         Width           =   1095
      End
      Begin VB.Label lblCPControl 
         Caption         =   "CP Current:"
         Height          =   255
         Left            =   120
         TabIndex        =   42
         Top             =   1080
         Width           =   975
      End
      Begin VB.Label lblErr 
         BackColor       =   &H000000FF&
         Height          =   345
         Index           =   1
         Left            =   1170
         TabIndex        =   22
         Top             =   1410
         Visible         =   0   'False
         Width           =   1155
      End
      Begin VB.Label lblErr 
         BackColor       =   &H000000FF&
         Height          =   345
         Index           =   0
         Left            =   1170
         TabIndex        =   21
         Top             =   330
         Visible         =   0   'False
         Width           =   1155
      End
      Begin VB.Label lblRFDividerRatio 
         Caption         =   "Multiplier:"
         Height          =   255
         Left            =   120
         TabIndex        =   20
         Top             =   720
         Width           =   1095
      End
      Begin VB.Label lblRefClk 
         Alignment       =   2  'Center
         Caption         =   "Ref Clock:"
         Height          =   255
         Left            =   120
         TabIndex        =   19
         ToolTipText     =   "External Reference Clock Frequency"
         Top             =   360
         Width           =   750
      End
      Begin VB.Label lblMHz 
         Caption         =   "MHz"
         Height          =   255
         Index           =   0
         Left            =   2400
         TabIndex        =   18
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblSystemClkFreq 
         Caption         =   "System Clock:"
         Height          =   255
         Left            =   120
         TabIndex        =   17
         Top             =   1440
         Width           =   1095
      End
      Begin VB.Label lblMHz 
         Caption         =   "MHz"
         Height          =   255
         Index           =   1
         Left            =   2400
         TabIndex        =   16
         Top             =   1440
         Width           =   375
      End
   End
   Begin VB.Frame fraMisc 
      Height          =   615
      Left            =   7920
      TabIndex        =   25
      Top             =   5640
      Width           =   2175
      Begin VB.ListBox lstSpurR_ComMod 
         Height          =   645
         ItemData        =   "frmControl.frx":0266
         Left            =   120
         List            =   "frmControl.frx":0270
         TabIndex        =   30
         Top             =   720
         Width           =   1935
      End
   End
   Begin VB.Frame fraModulation 
      Caption         =   "Modulation Configuration"
      Height          =   1815
      Left            =   120
      TabIndex        =   31
      Top             =   3960
      Width           =   5295
      Begin VB.ListBox lstLevelConfig 
         Height          =   1035
         ItemData        =   "frmControl.frx":0298
         Left            =   3840
         List            =   "frmControl.frx":02A8
         TabIndex        =   37
         Top             =   600
         Width           =   1335
      End
      Begin VB.ListBox lstRURDConfig 
         Height          =   1035
         ItemData        =   "frmControl.frx":02E5
         Left            =   1800
         List            =   "frmControl.frx":02F5
         TabIndex        =   36
         Top             =   600
         Width           =   1935
      End
      Begin VB.Frame fraProfilePinConfig 
         Caption         =   "Profile Pin Config "
         Height          =   1335
         Left            =   120
         TabIndex        =   32
         Top             =   360
         Width           =   1575
         Begin VB.CheckBox chkPPCBit 
            Caption         =   "PPC Bit 0"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   35
            Top             =   360
            Width           =   1215
         End
         Begin VB.CheckBox chkPPCBit 
            Caption         =   "PPC Bit 1"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   34
            Top             =   600
            Width           =   1215
         End
         Begin VB.CheckBox chkPPCBit 
            Caption         =   "PPC Bit 2"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   33
            Top             =   840
            Width           =   1215
         End
      End
      Begin VB.Label lblLevelCtrl 
         Caption         =   "Level :"
         Height          =   255
         Left            =   3840
         TabIndex        =   39
         Top             =   360
         Width           =   1335
      End
      Begin VB.Label lblRURDCtrl 
         Caption         =   "RU\RD:"
         Height          =   255
         Left            =   1800
         TabIndex        =   38
         Top             =   360
         Width           =   1695
      End
   End
   Begin VB.Label lblLoadFlash 
      BackColor       =   &H000080FF&
      Height          =   435
      Left            =   5970
      TabIndex        =   23
      Top             =   4890
      Visible         =   0   'False
      Width           =   1635
   End
End
Attribute VB_Name = "frmControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim IsUpdating As Boolean
Public bNeedsLoading As Boolean

Private Sub chkClkInpPwDwn_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 7, chkClkInpPwDwn.value
    End If
End Sub


Private Sub chkDacRefPwDwn_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 4, chkDacRefPwDwn.value
    End If
End Sub




Private Sub chkMastAClrFreqAccum_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 2, 15, chkMastAClrFreqAccum.value
    End If
End Sub

Private Sub chkMastClrFreqAcc_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 2, 14, chkMastClrFreqAcc.value
    End If
End Sub

Private Sub chkMasterAClrPhaseAcc_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 2, 13, chkMasterAClrPhaseAcc.value
    End If
End Sub

Private Sub chkMasterClrPhaseAcc_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 2, 12, chkMasterClrPhaseAcc.value
    End If
End Sub

Private Sub chkMultiChipSync_Click()
    If chkMultiChipSync.value = 1 Then
        frmMultichipSync.Show
    Else
        frmMultichipSync.Hide
    End If
End Sub

Private Sub chkPPCBit_Click(Index As Integer)
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 12 + Index, chkPPCBit(Index).value
    End If
End Sub

Private Sub chkPwrDwnPin_Click()
    If IsUpdating = False Then
        'Set the powerdown pin value
        EvBd.PwrDwn = chkPwrDwnPin.value
        EvBd.USBWritePortBuffVal fx2_PortA
    End If
End Sub


Private Sub chkSyncClkOutDisable_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 5, chkSyncClkOutDisable.value
    End If
End Sub


Private Sub chkVCOGain_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 23, chkVCOGain.value
    End If
End Sub

Private Sub cmbRFDividerRatio_Click()
    Dim sRegVal As String
    
    'Update the system clock value
    CalcSystemClk

    If IsUpdating = False Then
        'Get the current registermap value
        sRegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
        If cmbRFDividerRatio.ListIndex = 0 Then
            'Insert the new value into the new registermap value
            sRegVal = Left(sRegVal, 1) & "00000" & Right(sRegVal, 18)
        Else
            'Insert the new value into the new registermap value
            sRegVal = Left(sRegVal, 1) & cbaseDec2Bin(cmbRFDividerRatio.ListIndex + 3, 5) & Right(sRegVal, 18)
        End If
        'Set the new regmap bit value
        EvBd.SetRegMapValue rm9911_NewRegMapVals, 1, sRegVal
    End If
End Sub

Private Sub cmdLoad_Click()
    Dim bAIOU As Boolean
    
    'Store the current state of AutoIOUpdate
    bAIOU = EvBd.AutoIOUpdate
    
    'Make adjustments for full form load
    If frmOptions.chkIOUAfterFullFormLoad.value = 1 Then
        EvBd.AutoIOUpdate = False
    End If
    
    'Disable the load button until finished so that the user can't
    'click it again until finished
    Screen.MousePointer = 11
    cmdLoad.Enabled = False
    
    'Load the data into the DUT
    EvBd.USBSerialLoad 0, EvBd.GetRegMapValue(rm9911_NewRegMapVals, 0), 1
    
    'Load the data into the DUT
    EvBd.USBSerialLoad 1, EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
    
    'Load the last control register and do an IO Update
    EvBd.USBSerialLoad 2, EvBd.GetRegMapValue(rm9911_NewRegMapVals, 2)
    
    'Process any events
    DoEvents 'Process any clicks on the load button while it is disabled
        
    'Re-Enable the load button
    cmdLoad.Enabled = True
    Screen.MousePointer = 1
    cmdLoad.SetFocus
    
    'Make adjustments for full form load
    If frmOptions.chkIOUAfterFullFormLoad.value = 1 And bAIOU Then
        'Send the IOUpdate
        EvBd.StrobeIOUpdate
        
        'Turn IOUpdates back on
        EvBd.AutoIOUpdate = True
    Else
        'Restore AutoIOUpdate to its origional state
        EvBd.AutoIOUpdate = bAIOU
    End If
End Sub

Private Sub cmdRead_Click()
    
    'Disable the read button until finished so that the user can't
    'click it again until finished
    Screen.MousePointer = 11
    cmdRead.Enabled = False
    
    'Read back the values from the DUT
    EvBd.USBSerialRead 1
    EvBd.USBSerialRead 2
    
    'Process any events
    DoEvents 'Process any clicks on the load button while it is disabled
        
    'Re-Enable the read button
    cmdRead.Enabled = True
    Screen.MousePointer = 1
    cmdRead.SetFocus
    
    'Update the form values
    UpdateFormVals
End Sub

Private Sub Form_Activate()
    'Update the form values
    Me.UpdateFormVals

End Sub

Private Sub lstComMode_Click()
    Dim RegVal As String
    Dim RegBits As String
    If IsUpdating = False Then
        'Get the current register map value
        RegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
        
        'Convert to binary string
        RegBits = cbaseDec2Bin(lstComMode.ListIndex, 1)
        
        'Insert the new bit values into the word
        RegVal = Left(RegVal, 21) & RegBits & Right(RegVal, 2)
        
        'Set the register map bit value
        EvBd.SetRegMapValue rm9911_NewRegMapVals, 1, RegVal
    End If
    
    'Update the channel frequencys window to reflect the change
    If IsLoaded("frmChannelFreqs") Then
        frmChannelFreqs.SetOppMode
    End If
    
    'Update the channel control window to reflect the change
    If IsLoaded("frmChannelControl") Then
        frmChannelControl.SetOppMode
    End If
End Sub

Private Sub lstRURDConfig_Click()
    Dim RegVal As String
    Dim RegBits As String
    If IsUpdating = False Then
        'Get the current register map value
        RegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
        
        'Convert to binary string
        RegBits = cbaseDec2Bin(lstRURDConfig.ListIndex, 2)
        
        'Insert the new bit values into the word
        RegVal = Left(RegVal, 12) & RegBits & Right(RegVal, 10)
        
        'Set the register map bit value
        EvBd.SetRegMapValue rm9911_NewRegMapVals, 1, RegVal
    End If
End Sub

Private Sub lstChargePumpCtrl_Click()
    Dim RegVal As String
    Dim RegBits As String
    If IsUpdating = False Then
        'Get the current register map value
        RegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
        
        'Convert to binary string
        RegBits = cbaseDec2Bin(lstChargePumpCtrl.ListIndex, 2)
        
        'Insert the new bit values into the word
        RegVal = Left(RegVal, 6) & RegBits & Right(RegVal, 16)
        
        'Set the register map bit value
        EvBd.SetRegMapValue rm9911_NewRegMapVals, 1, RegVal
    End If
End Sub

Private Sub lstExtPwrDwnMode_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 6, lstExtPwrDwnMode.ListIndex
    End If
End Sub


Private Sub lstLevelConfig_Click()
    Dim RegVal As String
    Dim RegBits As String
    If IsUpdating = False Then
        'Get the current register map value
        RegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
        
        'Convert to binary string
        RegBits = cbaseDec2Bin(lstLevelConfig.ListIndex, 2)
        
        'Insert the new bit values into the word
        RegVal = Left(RegVal, 14) & RegBits & Right(RegVal, 8)
        
        'Set the register map bit value
        EvBd.SetRegMapValue rm9911_NewRegMapVals, 1, RegVal
    End If
End Sub

Private Sub lstSpurR_ComMod_Click()
    If IsUpdating = False Then
        'Set the register map bit
        EvBd.SetRegMapBitValue rm9911_NewRegMapVals, 1, 2, lstSpurR.ListIndex
    End If
End Sub

Private Sub tmrLoadFlash_Timer()
    Dim iAddrCntr As Integer
    Dim sCRegVal As String
    Dim sNRegVal As String
    Dim bNdsLdng As Boolean
    
    'Only address one register
    iAddrCntr = 1 'Register 1
    
    'Initialize the flags value
    bNdsLdng = False
    
    'Loop through each of the channels
    For iAddrCntr = 0 To 2
        'Get the register map values for each register
        sCRegVal = EvBd.GetRegMapValue(rm9911_CurRegMapVals, iAddrCntr)
        sNRegVal = EvBd.GetRegMapValue(rm9911_NewRegMapVals, iAddrCntr)
                
        'Filter out bits that aren't set by this form
        Select Case iAddrCntr
            Case 0:
                sCRegVal = Mid(sCRegVal, 5, 1)
                sNRegVal = Mid(sNRegVal, 5, 1)
            Case 1:
                sCRegVal = Left(sCRegVal, 8) & Mid(sCRegVal, 10, 11) & Mid(sCRegVal, 22, 1)
                sNRegVal = Left(sNRegVal, 8) & Mid(sNRegVal, 10, 11) & Mid(sNRegVal, 22, 1)
            Case 2:
                sCRegVal = Left(sCRegVal, 4)
                sNRegVal = Left(sNRegVal, 4)
        End Select
        
        'If the values are different then set the needs loading flag
        If sCRegVal <> sNRegVal Then
            bNdsLdng = True
        End If
    Next iAddrCntr
    
    'If the needs loading flag is set then flash the label
    If bNdsLdng Then
        'Flash the label
        If lblLoadFlash.Visible = True Then
            lblLoadFlash.Visible = False
        Else
            lblLoadFlash.Visible = True
        End If
        lblLoadFlash.Refresh
    Else
        'Hide the flash label
        lblLoadFlash.Visible = False
        lblLoadFlash.Refresh
    End If
    
    'Set the forms publicly available variable
    bNeedsLoading = bNdsLdng
End Sub

Private Sub txtRefClk_Change()
    'Validate text
    If IsNumeric(txtRefClk.Text) Then
        If CDbl(txtRefClk.Text) > 0 And CDbl(txtRefClk.Text) <= 500 Then
            'Calculate the system clock
            CalcSystemClk
            lblErr(0).Visible = False
        Else
            'Assgn a default value
            'txtRefClk.Text = "500.000"
            lblErr(0).Visible = True
        End If
    Else
        'Assgn a default value
        'txtRefClk.Text = "500.000"
        lblErr(0).Visible = True
    End If
End Sub

Public Sub txtRefClk_KeyPress(KeyAscii As Integer)
    Dim Cancel As Boolean
    Dim DecSepLoc As Integer
    
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    
    Select Case KeyAscii
        Case 13:
            KeyAscii = 0
            'Validate the text
            txtRefClk_Validate Cancel
        Case iDecSep
            DecSepLoc = InStr(1, txtRefClk.Text, sDecSep)
            'if the decimal seperator was pressed
            If DecSepLoc > 0 Then
                If InStr(1, txtRefClk.SelText, sDecSep) Then
                    'Do nothing allowing the key to pass
                Else
                    'And it isn't in a selection string then trash the key
                    KeyAscii = 0
                End If
            End If
    End Select
End Sub

Private Sub txtRefClk_Validate(Cancel As Boolean)
    Dim MsgString As String
    Dim dblMaxFreq As Double
    Dim cvdte As Boolean
    
    'Validate text
    If IsNumeric(txtRefClk.Text) Then
        txtRefClk.Text = Format(txtRefClk.Text, "0.000")
        If CDbl(txtSysClkTxt.Text) <= 0 Or CDbl(txtRefClk.Text) <= 0 Then
'            MsgString = "The system clock frequency cannot go below 0 MHz."
'            MsgBox MsgString, vbApplicationModal + vbExclamation + vbOKOnly, "Invalid Clock Frequency!"
''            txtRefClk.Text = Format(txtRefClk, "0.000")
            Cancel = True
        Else
            CalcSystemClk
        End If
        
        'If they are sending
'        If chkRFDivRefClkMux.Value Then
'            txtSysClkTxt.Text = txtRefClk.Text
'        Else
'            'Divide the refclk value by the divider ratio
'            txtSysClkTxt.Text = Format(CDbl(txtRefClk.Text) / (2 ^ cmbRFDividerRatio.ListIndex), "0.000")
'        End If
        'Calculate the system clock
    Else
        'Assgn a default value
        txtRefClk.Text = Format(500#, "0.000")
    End If
    
End Sub

Private Sub txtSysClkTxt_Change()
    Dim sMsg As String
    Dim sTBVal As String
    Dim sMsg1 As String
    
    sMsg1 = "It is recommended that the VCO Gain Bit be set when using the Clock Multiplier" & vbCrLf & _
       "to generate a system clock frequency >= 255 MHz." & vbCrLf & vbCrLf & _
       "The VCO Gain Bit has been set for you, please click the Load button" & vbCrLf & _
       "to apply the changes to the DUT."
    sMsg = "The system clock should not exceed 500 MHz!"
    
    If IsUpdating = False Then
        'Update the values displayed on the profiles window
'        frmProfiles.RefreshOutFreqDisplays
'        frmLinSweepSetup.RefreshDisplays
        
        sTBVal = txtSysClkTxt.Text
        If IsNumeric(sTBVal) Then
            If CDbl(sTBVal) >= 255 And EvBd.GetRegMapBitValue(rm9911_NewRegMapVals, 1, 23) = abvLow And cmbRFDividerRatio.ListIndex <> 0 Then
                'Set the VCO Gain bit
                chkVCOGain.value = 1
                MsgBox sMsg1, vbExclamation + vbApplicationModal + vbOKOnly, "Enable VCO Gain!"
            End If
            
            If CDbl(sTBVal) > 500 Or CDbl(sTBVal) <= 0 Then
                'Show the error hilight
                lblErr(1).Visible = True
                'Display the error message
                'MsgBox sMsg, vbExclamation + vbApplicationModal + vbOKOnly, "Invalid System Clock Value"
            Else
                'Hide the error hilight
                lblErr(1).Visible = False
            End If
            
            If IsLoaded("frmChannelFreqs") And CDbl(sTBVal) > 0 Then
                frmChannelFreqs.UpdateFormVals
            End If
        Else
            'Show the error hilight
            lblErr(1).Visible = True
        End If
    End If
End Sub
Private Sub Form_Load()
    IsUpdating = True
    
    'OldTab
    OldSelTab = 1
    
    'Setup the Ref Clock and the divider
    'txtRefClk.Text = Format(500, "0.000")
    cmbRFDividerRatio.ListIndex = 0
    
'    cmbRFDividerRatio.ListIndex = 3
'
'
'    'Setup the image list box
'    icbSineCosine(0).ComboItems.Add 1, , "Cosine", 1
'    icbSineCosine(0).ComboItems.Add 2, , "Sine", 2
''    icbSineCosine(0).ComboItems(1).Selected = True
'    icbSineCosine(1).ComboItems.Add 1, , "Cosine", 1
'    icbSineCosine(1).ComboItems.Add 2, , "Sine", 2
''    icbSineCosine(1).ComboItems(1).Selected = True
    
    'By default have Dut2 use dut1's refclk
    
    
    IsUpdating = False
    
    UpdateFormVals
'    RefreshControls
    
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Do not allow the user to close the window instead
    'just hide it.
    If UnloadMode = vbFormControlMenu Then
        Cancel = 1
    End If
    
    If lblErr(0).Visible = False And lblErr(1).Visible = False Then
        Me.Hide
    Else
        'Play the system astrisk sound
        sndPlaySysSound sndSysAsterisk
    End If
    'Check the menu used to show the window
'    mdiMain.mnuViewControlWindow.Checked = False
End Sub


Public Sub CalcSystemClk()
    If cmbRFDividerRatio.ListIndex = 0 Or cmbRFDividerRatio.ListIndex = -1 Then
        txtSysClkTxt.Text = Format(CDbl(txtRefClk.Text), "0.000")
    Else
        txtSysClkTxt.Text = Format(CDbl(txtRefClk.Text) * (cmbRFDividerRatio.ListIndex + 3), "0.000")
    End If
End Sub
'Updates the controls with the current register map values
Public Sub UpdateFormVals()
    Dim sRegVal0 As String
    Dim sRegVal1 As String
    Dim sRegVal2 As String
    Dim sRegVal3 As String
    Dim sDummyVal As String
    Dim iDummyVal As String
    
    'Get registermap values
    'sRegVal0 = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 0)
    sRegVal0 = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 0)
    sRegVal1 = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 1)
    sRegVal2 = EvBd.GetRegMapValue(rm9911_NewRegMapVals, 2)
        
    IsUpdating = True
    
    'Update the RFDivider
    iDummyVal = cbaseBinS2Dec(Mid(sRegVal1, 2, 5))
    If iDummyVal >= 4 And iDummyVal <= 20 Then
        cmbRFDividerRatio.ListIndex = iDummyVal - 3
    Else
        cmbRFDividerRatio.ListIndex = 0
    End If
    
    'Update powerdown stuff
    chkClkInpPwDwn.value = CLng(Mid(sRegVal1, 17, 1))
    chkDacRefPwDwn.value = CLng(Mid(sRegVal1, 20, 1))
    lstExtPwrDwnMode.ListIndex = CLng(Mid(sRegVal1, 18, 1))
    
    'Update power down pin value
    chkPwrDwnPin.value = EvBd.PwrDwn
    
    'Update the VCO Gain bit
    chkVCOGain.value = CLng(Mid(sRegVal1, 1, 1))
    
    chkSyncClkOutDisable.value = CLng(Mid(sRegVal1, 19, 1))
    
    'Update the ChargePumpCtrl listbox
    lstChargePumpCtrl.ListIndex = cbaseBinS2Dec(Mid(sRegVal1, 7, 2))
    
    'Update the RURDConfig listbox
    lstRURDConfig.ListIndex = cbaseBinS2Dec(Mid(sRegVal1, 13, 2))
    'Update the LevelConfig listbox
    lstLevelConfig.ListIndex = cbaseBinS2Dec(Mid(sRegVal1, 15, 2))
    'Update the LevelConfig listbox
    lstComMode.ListIndex = cbaseBinS2Dec(Mid(sRegVal1, 22, 1))
    
    'Update PPC Bits
    chkPPCBit(0).value = CLng(Mid(sRegVal1, 12, 1))
    chkPPCBit(1).value = CLng(Mid(sRegVal1, 11, 1))
    chkPPCBit(2).value = CLng(Mid(sRegVal1, 10, 1))
    
    'Update the accumulator control section
    chkMastAClrFreqAccum.value = CLng(Mid(sRegVal2, 1, 1))
    chkMastClrFreqAcc.value = CLng(Mid(sRegVal2, 2, 1))
    chkMasterAClrPhaseAcc.value = CLng(Mid(sRegVal2, 3, 1))
    chkMasterClrPhaseAcc.value = CLng(Mid(sRegVal2, 4, 1))
    
    IsUpdating = False
End Sub

'This sub changes the GUI depending on the engineering mode which is set by the
'global variable iEngMode
Public Sub SetDebugMode()
    Select Case iEngMode
        Case 1: 'Debug Mode
            'fraEngModeStuff.Visible = False
        Case 2: 'Engineering Mode
            'fraEngModeStuff.Visible = False
        Case 3: 'Extended Engineering Mode
            'fraEngModeStuff.Visible = True
        Case Else 'Normal Mode
            'fraEngModeStuff.Visible = False
    End Select
End Sub

