VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cAdiEZSSP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "General purpose usb class containing the standard set of functions."
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'Returns the byte indexed by iByteIndex from lValue
'Ex GetByteFromLong(&hFFABE1,1) would return &hAB
'Ex GetByteFromLong(&hFFABE1,4) would return 00
Private Function GetByteFromLong(ByVal lValue As Double, ByVal iByteIndex) As Byte
    If iByteIndex >= 0 And iByteIndex <= 3 Then
        GetByteFromLong = CByte(&HFF And Int(lValue / (256 ^ iByteIndex)))
    Else
        GetByteFromLong = &H0
    End If
End Function
'Returns the merged value of a
Private Function MergeBytes2Long(ByVal bByte3 As Byte, ByVal bByte2 As Byte, ByVal bByte1 As Byte, ByVal bByte0 As Byte) As Long
    Dim sTempVal As String
    
    'Build a hex string - seems to be the easiest way
    sTempVal = Format(Hex(bByte3), "00") & Format(Hex(bByte2), "00") & Format(Hex(bByte1), "00") & Format(Hex(bByte0), "00")
        
    'Result = (bbyte3 * 256^3) + (bbyte2 * 256^2) + (bbyte1 * 256^1) + (bbyte0 * 256^0)
    'MergeBytes2Long = (bByte3 * 16777216) + (bByte2 * 65536) + (bByte1 * 256) + bByte0
    'Convert that to a long value
    MergeBytes2Long = CLng("&h" & sTempVal)
End Function


Public Sub SetRdBackMode(ByVal Value As Boolean)
    'This subroutine sets the readback mode of the firmware
    'Value = true  - Single byte read mode enabled
    'Value = false - Single byte read mode disabled
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H4 'Command value for setting single read byte count mode.
    If Value = True Then
        buf(1) = 1
    Else
        buf(1) = 0
    End If
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting single readback mode."
        Exit Sub
    End If
End Sub

'This gives the user control over the USB Status LED on the evaluation board
' Value = 0 - Stops the firware controled LED Flashing and gives control
'             to the software.
' Value = 1 - Resumes the firmware controled LED Flashing.
' Value = 2 - Returns 1 if firmware flashing is on and 0 if it is off.
Public Function SetLEDBlink(ByVal Value As Byte) As Boolean
    'This subroutine sets the readback mode of the firmware
    'Value = true  - Single byte read mode enabled
    'Value = false - Single byte read mode disabled
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    buf(0) = &HF   'Command value for setting single read byte count mode.0
    buf(1) = Value 'Set the value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        ''MsgBox "Error setting single readback mode."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        'MsgBox "Error reading device."
        Exit Function
    Else
        SetLEDBlink = CBool(Data(0))
    End If
End Function

Public Function SetPortBValue(ByVal Value As Byte) As Boolean
    'This routine sets the value applied to PortA's pins on the EZUSB FX2 chip
    'Returns - True if successfull, False if unsuccessfull
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HA  'Comand value for Writing PortA Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting PortB value."
        SetPortBValue = False
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortB value."
        SetPortBValue = False
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortBValue = True
    Else
        SetPortBValue = False
    End If
End Function

Public Function GetPortBValue() As Byte
    'This routine returns the value of PortB
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H9
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error writing device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading device.."
        Exit Function
    End If

    'Return the value.
    GetPortBValue = Data(0)
End Function

Public Sub ResetFirmware()
    'Resets the firmware

    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H8 'Command value to reset the firmware and evaluation board.
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 Then
        'MsgBox "Error writing device."
        Exit Sub
    End If
End Sub

Public Function SetPortDValue(ByVal Value As Byte) As Boolean
    'This routine sets the value of port D to the value of "Value"
    'Input - Value: the value to be applied to the port d pins
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HC  'Comand value for Writing PortD Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        'MsgBox "Error setting PortD value."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortD value."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortDValue = True
    Else
        SetPortDValue = False
    End If
End Function

Public Function GetPortDValue() As Byte
    'This routine returns the value of PortA
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &HB
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        'MsgBox "Error writing device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading device."
        Exit Function
    End If

    'Return PortD's value
    GetPortDValue = Data(0)
End Function

Public Function GetFirmWareVersion() As String
    'This routine returns 2 bytes.  The first contains version Major
    'the second contains version minor.
    'Example = VerMajor.VerMinor = 1.9
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    Driver = clsEZUSBDev01.DriverName
    buf(0) = &H0
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1) 'DoBulkXfer(Driver, 0, buf, 1)
    
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 2) 'DoBulkXfer(Driver, 1, Data, 2)
    If result <> 1 Then
        MsgBox "Error reading to device."
        Exit Function
    End If

    'Return the firmware version
    GetFirmWareVersion = CStr(Data(0)) & "." & CStr(Data(1))
End Function

Public Function SetPortAValue(ByVal Value As Byte) As Boolean
    'This routine sets the value applied to PortA's pins on the EZUSB FX2 chip
    'Returns - True if successfull, False if unsuccessfull
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H1 'Comand value for Writing PortA Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        SetPortAValue = False
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
'    result = DoBulkXfer(Driver, 1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        SetPortAValue = False
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortAValue = True
    Else
        SetPortAValue = False
    End If
End Function

Public Function GetPortAValue() As Byte
    'This routine returns the value of PortA from the EZUSB-FX2 chip
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H2
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading to device."
        Exit Function
    End If

    'Return the firmware version
    GetPortAValue = Data(0)
End Function

Public Function GetCtlValues()
    'This routine returns 1 byte.  Which represents the current
    'state of the GPIF Ctl lines
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H6
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading from device."
        Exit Function
    End If

    'Return the value
    GetCtlValues = Data(0)
End Function


Public Function SetCtlValues(ByVal Value As Byte) As Boolean
    'This routine sets the value of the control lines
    'Value = Value to be set to the GPIFIDLECTL register on the EzUSB FX2 chip.
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H5 'Comand value for Writing CTL Values
    buf(1) = Value
       
    'send 2 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error writing device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading device."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetCtlValues = True
    Else
        SetCtlValues = False
    End If
End Function

Public Sub SetRdBackByteCnt(ByVal Value As Integer)
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H7 'Command value for setting single read byte count mode.
    buf(1) = MSB(Value)
    buf(2) = LSB(Value)
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 3)
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Sub
    End If

End Sub
Public Function SetHostID(ByVal lHostID As Long) As Long
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim buf(5) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    buf(0) = &HD  'Command value
    buf(1) = GetByteFromLong(lHostID, 3)
    buf(2) = GetByteFromLong(lHostID, 2)
    buf(3) = GetByteFromLong(lHostID, 1)
    buf(4) = GetByteFromLong(lHostID, 0)
    
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 5)
    
    'Return the result
    SetHostID = result
'    If result <> 1 Then
'        'MsgBox "Error writing to device."
'        'Exit Function
'    End If
End Function
'Gets the most significant byte from iVal and returns it
Private Function MSB(ByVal iVal As Integer) As Byte
    MSB = CByte(Fix(iVal / 256))
End Function
'Gets the lease significant byte from iVal and returns it
Private Function LSB(ByVal iVal As Integer) As Byte
    LSB = CByte(Fix(iVal And &HFF))
End Function

'Returns the byte indexed by iByteIndex from lValue
'Ex GetByteFromLong(&hFFABE1,1) would return &hAB
'Ex GetByteFromLong(&hFFABE1,4) would return 00

'Public Function GetHostID(ByRef lValue As Long) As Integer
'    'This subroutine sets the number of bytes that will be read back through
'    'the GPIF interface in single byte Read Mode
'    Dim buf(1) As Byte
'    Dim result As Long
'    Dim Data(4) As Byte
'
'    buf(0) = &HE 'Command value for setting single read byte count mode.
'
'    'send 1 byte of data out on EP1OUT
'    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
'    'If no errors then continue
'    If result = 1 Then
'        result = clsEZUSBDev01.BulkXfer(1, Data, 4)
'    End If
'
'    If result = 1 Then
'        'Now that the data has been recieved convert to a long
'        lValue = MergeBytes2Long(Data(0), Data(1), Data(2), Data(3))
'    End If
'
''    If result <> 1 Then
''        MsgBox "Error writing to device."
''        Exit Function
''    End If
'
'    GetHostID = result
'
'End Function

'Public Function GetHostID(ByRef lValue As Long) As Integer
'    'This subroutine sets the number of bytes that will be read back through
'    'the GPIF interface in single byte Read Mode
'    Dim buf(1) As Byte
'    Dim result As Long
'    Dim Data(4) As Byte
'
'    buf(0) = &HE 'Command value for setting single read byte count mode.
'
'    'send 1 byte of data out on EP1OUT
'    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
'    'If no errors then continue
'    If result = 1 Then
'        result = clsEZUSBDev01.BulkXfer(1, Data, 4)
'    End If
'
'    If result = 1 Then
'        'Now that the data has been recieved convert to a long
'        lValue = MergeBytes2Long(Data(0), Data(1), Data(2), Data(3))
'    End If
'
''    If result <> 1 Then
''        MsgBox "Error writing to device."
''        Exit Function
''    End If
'
'    GetHostID = result
'
'End Function

