VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cAD9911EvalBd"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Public Enum evbBits
    evbBit0 = 0
    evbBit1 = 1
    evbBit2 = 2
    evbBit3 = 3
    evbBit4 = 4
    evbBit5 = 5
    evbBit6 = 6
    evbBit7 = 7
End Enum

'Binary Values
Public Enum adiBitValues
    abvHigh = 1
    abvLow = 0
End Enum

'EZUSB-FX2 Port Enum
Public Enum fx2GPIO
    fx2_PortD = 0
    fx2_PortA = 1
    fx2_CTLLines = 2
    fx2_PortB = 3
    fx2_PortC = 4
    fx2_PortE = 5
End Enum

'Registermaps - Used to specify which register map is being
'accessed by sSetRegMapVal and sGetRegMapVal
Public Enum evb9911_RegMaps
    rm9911_NewRegMapVals = 0
    rm9911_CurRegMapVals = 1
End Enum

'Bit Number Constants for the signals on the
'FX2s PortA's Pin
Const bnUSB_USB_Status = 0
Const bnUSB_CSB = 1
Const bnUSB_RESET = 2
Const bnUSB_PWRDWN = 3
Const bnUSB_CLKMDSEL = 4
Const bnUSB_PA5 = 5
Const bnUSB_PA6 = 6
Const bnUSB_PA7 = 7

'Bit Number Constants for the signals on the
'FX2s PortB's Pin
Const bnUSB_SDIO_0 = 0 'SDI in 1-Bit 3-Wire I/O mode
Const bnUSB_SDIO_1 = 1
Const bnUSB_SDIO_2 = 2 'SDO in 1-Bit 3-Wire I/O Mode
Const bnUSB_SDIO_3 = 3 'SyncIO in 1 and 2 Bit I/O modes
Const bnUSB_PB4 = 4
Const bnUSB_PB5 = 5
Const bnUSB_PB6 = 6
Const bnUSB_PB7 = 7

'Bit Number Constants for the signals on the
'FX2s PortD's Pin
Const bnUSB_P1 = 0
Const bnUSB_P2 = 1
Const bnUSB_P3 = 2
Const bnUSB_P4 = 3
Const bnUSB_IOUpdate = 4
Const bnUSB_RURD0 = 5
Const bnUSB_RURD1 = 6
Const bnUSB_RURD2 = 7

'Bit Number Constants for the signals on the
'FX2s CTL lines
Const bnUSB_SCLK = 0
Const bnUSB_CTL1 = 1
Const bnUSB_CTL2 = 2

'Define the register map
'These variables store the values last sent or recieved from
'the fx2's general purpose I/O registers.
Private fx2PortVals(0 To 5) As Integer
Private evbBitVals(0 To 7) As Integer

'Buffer to store new and current register map values
'Syntax: Buffer(RegAddr: 0 - X) = Value
Private sRegMapValsNew(0 To 27) As String
Private sRegMapVals(0 To 27) As String
Private sDefaultRegMapVals(0 To 27) As String
Private RegLength(0 To 27) As Integer
Private sDefChnlRegVals(0 To 3, 0 To 21) As String
Private sChnlRegVals(0 To 3, 0 To 21) As String
Private sChnlRegValsNew(0 To 3, 0 To 21) As String
Private mEventsEnabled As Boolean

Public Enum spiIOMode
    spi3Wire = 0
    spi4Wire = 1
    spi2BitSerial = 2
    spi4BitSerial = 3
End Enum

'Public Enum spiInstrLen
'    spi8Bit = 0
'    spi16Bit = 1
'End Enum
'
'local variable(s) to hold property value(s)
Private mvarEnabled As Boolean 'local copy
'local variable(s) to hold property value(s)
Private mvarVerboseErrors As Boolean 'local copy
'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent RegmapChanged[(arg1, arg2, ... , argn)]
Public Event RegmapChanged(ByVal eRegMap As evb9911_RegMaps)
'local variable(s) to hold property value(s)
Private mvarRURDBitVal As Integer 'local copy
Private mvarSPI_IOMode As spiIOMode 'local copy
Private mvarSPI_LSB_First As Boolean 'local copy
Private mvarSCLK As adiBitValues 'local copy
Private mvarCSB As adiBitValues 'local copy
Private mvarP1 As adiBitValues 'local copy
Private mvarP2 As adiBitValues 'local copy
Private mvarP3 As adiBitValues 'local copy
Private mvarP4 As adiBitValues 'local copy
Private mvarIOUpdate As adiBitValues 'local copy
Private mvarRURD_0 As adiBitValues 'local copy
Private mvarRURD_1 As adiBitValues 'local copy
Private mvarRURD_2 As adiBitValues 'local copy
Private mvarCLKModeSel As adiBitValues 'local copy
Private mvarPwrDwn As adiBitValues 'local copy
Private mvarReset As adiBitValues 'local copy
Private mvarUSB_Status As adiBitValues 'local copy
Private mvarUSBStatusCtrl As adiBitValues 'local copy
Private mvarSDIO_0 As adiBitValues 'local copy
Private mvarSDIO_1 As adiBitValues 'local copy
Private mvarSDIO_2 As adiBitValues 'local copy
Private mvarSDIO_3 As adiBitValues 'local copy
'local variable(s) to hold property value(s)
Private mvarAutoIOUpdate As Boolean 'local copy
'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent AfterReset[(arg1, arg2, ... , argn)]
Public Event AfterReset()
'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent BeforeReset[(arg1, arg2, ... , argn)]
Public Event BeforeReset()

'Stores the value of the Reset Pin before it was changed with USBWritePortBuffVal
Private OldReset As adiBitValues
'local variable(s) to hold property value(s)
Private mvarAutoCSBMode As Boolean 'local copy
'local variable(s) to hold property value(s)
Private mvarDUTType As String 'local copy
'local variable(s) to hold property value(s)
'Private mvarCh0_IOEn As adiBitValues 'local copy
'Private mvarCh1_IOEn As adiBitValues 'local copy
'Private mvarCh2_IOEn As adiBitValues 'local copy
'Private mvarCh3_IOEn As adiBitValues 'local copy
''local variable(s) to hold property value(s)
'Private mvarChIOEn_Mask As String 'local copy
Public Sub StrobeIOUpdate()
    'Toggle the IO Update Pin
    EvBd.IOUpdate = abvLow
    EvBd.USBWritePortBuffVal fx2_PortD
    EvBd.IOUpdate = abvHigh
    EvBd.USBWritePortBuffVal fx2_PortD
    EvBd.IOUpdate = abvLow
    EvBd.USBWritePortBuffVal fx2_PortD
End Sub


Public Function GetChMaskVal(ByVal iChnl As Integer) As String
    Dim sChnlMask(0 To 3) As String
    
    'If they specified an invalid channel then exit and do nothing
    If iChnl > 3 Then
        MsgBox "Error: Invalid Channel!", vbApplicationModal + vbCritical, "Error: GetChMaskVal()!"
        Exit Function
    End If
    
    'Setup the channel mask values
    sChnlMask(0) = "0001"
    sChnlMask(1) = "0010"
    sChnlMask(2) = "0100"
    sChnlMask(3) = "1000"

    'Return the value requested
    GetChMaskVal = sChnlMask(iChnl)
End Function


'Sets the proper bits in the CSR
'and loads them into the DUT
'Note: This subroutine only allows you to select one channel at a time
Public Sub SelectChannel(ByVal iChnl As Integer)
    Dim sChnlMask(0 To 3) As String
    Dim sRegVal As String
    Dim bAutoIOUD As Boolean
    
    'Get the current state of AutoIOUpdate
    bAutoIOUD = AutoIOUpdate
    
    'Setup the channel mask values
    sChnlMask(0) = "0001"
    sChnlMask(1) = "0010"
    sChnlMask(2) = "0100"
    sChnlMask(3) = "1000"
    
    'If they specified an invalid channel then exit and do nothing
    If iChnl > 3 Then
        MsgBox "Error: Invalid Channel!", vbApplicationModal + vbCritical, "Error: SelectChannel()!"
        Exit Sub
    End If
    
    'Get the current value
    sRegVal = EvBd.GetRegMapValue(rm9911_CurRegMapVals, 0)
    sRegVal = sChnlMask(iChnl) & Right(sRegVal, 4)
    
    'Turn auto I/O Update off because you don't need it for the Channel I/O Enable bits
    AutoIOUpdate = False
    
    'Send the new value
    USBSerialLoad 0, sRegVal
    
    If bAutoIOUD Then
        'Turn auto I/O Update on
        AutoIOUpdate = True
    End If
End Sub


'Retrieves the bit value from the specified software register map
'Inputs:
'RegMap - 0 - New Values.
'         1 - Current Values.
'RegAddr - Address of the register you want to retrieve a value for. 3 - 24
'BitNum - Number of the bit you want the value of. 0-XX
'iChnl - Channel which you want to read register data from.
'
'
'Outputs:
'Returns the bit value of the bit addressed.
Public Function GetChRegBitValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddr As Integer, ByVal BitNum As Integer, ByVal iChnl As Integer) As adiBitValues
    Dim BitValue As String
    Dim cntr As Integer
'    Dim iChnl As Integer   'Channel to set the bit in
    
    'Check all bits in the channel mask
'    For cntr = 4 To 1 Step -1
'        'If you find a 1 then exit the loop
'        If Mid(CHMask, cntr, 1) = "1" Then
'            Exit For
'        End If
'    Next cntr
'
'    If cntr = 0 Then
'        cntr = 4
'    End If
    
    'Calculate the channel number to return the value from
'    iChnl = 4 - cntr
    
    If RegLength(RegAddr) > BitNum Then
        If RegMap = rm9911_NewRegMapVals Then
            'Return the bit value
            BitValue = Mid(sChnlRegValsNew(iChnl, RegAddr - 3), RegLength(RegAddr) - BitNum, 1)
        Else
            'Return the bit value
            BitValue = Mid(sChnlRegValsNew(iChnl, RegAddr - 3), RegLength(RegAddr) - BitNum, 1)
        End If
        
        'Return the value that was retrieved
        If BitValue = "1" Then
            GetChRegBitValue = abvHigh
        Else
            GetChRegBitValue = abvLow
        End If
    Else
        MsgBox "The BIT being addressed does not exist in the addressed register location!", vbCritical, "clsAD9956EvBd.GetRegMapBitVal - Ivalid Parameter: BitNum"
    End If
End Function

'Retrieves the channel retister map value from the specified software register map
'Inputs:
'RegMap  - 0 - New Values.
'          1 - Current Values.
'RegAddr - Address of the register you want to retrieve a value for. 3 - 24
'BitNum  - Number of the bit you want the value of. 0-XX
'CHMask  - Binary string that represents the value of the Channel IO Enable bits.
'         If more than one channel register value is requested then the function
'         only returns the value of the lowest channel number.  This mimics the
'         behavior of the DUT.
'
'Outputs:
'Returns the bit value of the bit addressed.
Public Function GetChRegValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddr As Integer, ByVal iChnl As Integer) As String
    Dim cntr As Integer
    'Check all bits in the channel mask
'    For cntr = 4 To 1 Step -1
'        'If you find a 1 then exit the loop
'        If Mid(CHMask, cntr, 1) = "1" Then
'            Exit For
'        End If
'    Next cntr
'
'    If cntr = 0 Then
'        cntr = 4
'    End If
    
    'Return the value from the specified registermap buffer
    If RegMap = rm9911_NewRegMapVals Then
        GetChRegValue = sChnlRegValsNew(iChnl, RegAddr - 3)
    ElseIf RegMap = rm9911_CurRegMapVals Then
        GetChRegValue = sChnlRegVals(iChnl, RegAddr - 3)
    End If
End Function
'Retrieves the bit value from the specified software register map
'Inputs:
'RegMap - 0 - New Values.
'         1 - Current Values.
'RegAddr - Address of the register you want to set a value for. 3 - 24
'BitNum - Number of the bit you want the value of. 0-XX
'CHMask - Binary string that represents the value of the Channel IO Enable bits.
'BitVal - Binary value of the bit.
'
'Outputs:
'   None.
Public Sub SetChRegBitValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddr As Integer, ByVal BitNum As Integer, ByVal BitValue As adiBitValues, ByVal CHMask As String)
    Dim RegVal As String
    Dim BitVal As String
    Dim RegLen As Integer
    Dim cntr As Integer
    'Check to see if they are addressing a valid bit position
    If RegLength(RegAddr) > BitNum Then
        'Check all bits in the channel mask
        For cntr = 1 To 4
            'If you find a 1 then exit the loop
            If Mid(CHMask, cntr, 1) = "1" Then
                'Set the value
                If RegMap = rm9911_NewRegMapVals Then
                    'Get the current value of the channel register
                    RegVal = sChnlRegValsNew(4 - cntr, RegAddr - 3)
                    BitVal = CStr(BitValue)
                    RegLen = RegLength(RegAddr)
                    'Set the new bit value
                    sChnlRegValsNew(4 - cntr, RegAddr - 3) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
                ElseIf RegMap = rm9911_CurRegMapVals Then
                    'Get the current value of the channel register
                    RegVal = sChnlRegVals(4 - cntr, RegAddr - 3)
                    BitVal = CStr(BitValue)
                    RegLen = RegLength(RegAddr)
                    'Set the new the bit value
                    sChnlRegVals(4 - cntr, RegAddr - 3) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
                Else
                    'Get the current value of the channel register
                    RegVal = sChnlRegValsNew(4 - cntr, RegAddr - 3)
                    BitVal = CStr(BitValue)
                    RegLen = RegLength(RegAddr)
                    'Set the new bit value
                    sChnlRegValsNew(4 - cntr, RegAddr - 3) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
                    sChnlRegVals(4 - cntr, RegAddr - 3) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
                End If
            End If
        Next cntr
    Else
        MsgBox "The BIT being addressed does not exist in the addressed register location!", vbCritical, "clsAD9956EvBd.SetRegMapBitVal - Ivalid Parameter: BitNum"
    End If
    'Add 1 the bit number
'    BitNum = BitNum
End Sub
'Retrieves the channel retister map value from the specified software register map
'Inputs:
'RegMap - 0 - New Values.
'         1 - Current Values.
'RegAddr - Address of the register you want to retrieve a value for. 3 - 24
'CHMask - Binary string that represents the value of the Channel IO Enable bits.
'Value - Binary string of the registermap value.
'
'Outputs:
'   None.
Public Sub SetChRegValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddr As Integer, ByVal sValue As String, ByVal CHMask As String)
    Dim cntr As Integer
    'Check all bits in the channel mask
    For cntr = 4 To 1 Step -1
        'If you find a 1 then exit the loop
        If Mid(CHMask, cntr, 1) = "1" Then
            'Set the value
            If RegMap = rm9911_NewRegMapVals Then
                sChnlRegValsNew(4 - cntr, RegAddr - 3) = sValue
            ElseIf RegMap = rm9911_CurRegMapVals Then
                sChnlRegVals(4 - cntr, RegAddr - 3) = sValue
            Else
                sChnlRegValsNew(4 - cntr, RegAddr - 3) = sValue
                sChnlRegVals(4 - cntr, RegAddr - 3) = sValue
            End If
        End If
    Next cntr
End Sub

Public Property Let ChIOEn_Mask(ByVal vData As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.ChIOEn_Mask = 5
'    mvarChIOEn_Mask = vData
    Dim sRegVal As String
    
    If Len(vData) <> 4 Then
        'Display an error message
        MsgBox "CHIOEn_Mask Property Let: Invalid Data!", vbCritical
    Else
        'Get the current new value
        sRegVal = GetRegMapValue(rm9911_NewRegMapVals, 0)
        'Add in the new data
        sRegVal = vData & Right(vData, 4) 'Build the new values for CSR
        'Set the new regval but only in newregmapvals
        SetRegMapValue rm9911_NewRegMapVals, 0, sRegVal
    End If
End Property


Public Property Get ChIOEn_Mask() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.ChIOEn_Mask
    'ChIOEn_Mask = mvarChIOEn_Mask
    Dim sRegVal As String
    
    'Get the current value
    sRegVal = GetRegMapValue(rm9911_CurRegMapVals, 0)
    'Return the mask value
    ChIOEn_Mask = Left(sRegVal, 4)
End Property



Public Property Let Ch3_IOEn(ByVal vData As adiBitValues)
'used when assigning an Object to the property, on the left side of a Set statement.
'Syntax: Set x.Ch3_IOEn = Form1
    SetRegMapBitValue rm9911_NewRegMapVals, 0, 7, vData
End Property


Public Property Get Ch3_IOEn() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Ch3_IOEn
    'Set Ch3_IOEn = mvarCh3_IOEn
    Ch3_IOEn = GetRegMapBitValue(rm9911_CurRegMapVals, 0, 7)
End Property



Public Property Let Ch2_IOEn(ByVal vData As adiBitValues)
'used when assigning an Object to the property, on the left side of a Set statement.
'Syntax: Set x.Ch2_IOEn = Form1
    SetRegMapBitValue rm9911_NewRegMapVals, 0, 6, vData
End Property


Public Property Get Ch2_IOEn() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Ch2_IOEn
'    Set Ch2_IOEn = mvarCh2_IOEn
    Ch2_IOEn = GetRegMapBitValue(rm9911_CurRegMapVals, 0, 6)
End Property



Public Property Let Ch1_IOEn(ByVal vData As adiBitValues)
'used when assigning an Object to the property, on the left side of a Set statement.
'Syntax: Set x.Ch1_IOEn = Form1
    SetRegMapBitValue rm9911_NewRegMapVals, 0, 5, vData
End Property


Public Property Get Ch1_IOEn() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Ch1_IOEn
    'Set Ch1_IOEn = mvarCh1_IOEn
    Ch1_IOEn = GetRegMapBitValue(rm9911_CurRegMapVals, 0, 5)
End Property
Public Property Let Ch0_IOEn(ByVal vData As adiBitValues)
'used when assigning an Object to the property, on the left side of a Set statement.
'Syntax: Set x.Ch0_IOEn = Form1
    SetRegMapBitValue rm9911_NewRegMapVals, 0, 4, vData
End Property


Public Property Get Ch0_IOEn() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Ch0_IOEn
'    Set Ch0_IOEn = mvarCh0_IOEn
    Ch0_IOEn = GetRegMapBitValue(rm9911_CurRegMapVals, 0, 4)
End Property



'Read only property
Public Property Let DUTType(ByVal vData As String)
Attribute DUTType.VB_Description = "This property returns a string that specifies the DUT that was detected on the evaluation board."
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.DUTType = 5
'    mvarDUTType = vData
End Property

'Read only property
Public Property Get DUTType() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.DUTType
    DUTType = mvarDUTType
End Property



'Detects the DUT and returns the DUT Type
'You should note that the DUT gets reset during this process
Public Function DetectDUT() As String
    Dim sRegVal As String
    Const sTestVal = "000000000000001100000010"
    
    'Turn off all event fireing
    mEventsEnabled = False
    
    'Reset the DUT
    ResetDUT
    
    'Read the value of register 3
    sRegVal = USBSerialRead(3, 1)
    
    'Test the value returned with the value
    If sRegVal <> sTestVal Then
        DetectDUT = "None"
        mvarDUTType = "None"
        Exit Function
    End If
    
    'Get the chip ID
    DetectDUT = GetProductType()
    
    'Turn off all event fireing
    mEventsEnabled = True

End Function

Private Sub USBSerialLoad1Bit(ByVal RegAddress As Integer, ByVal Data As String, Optional NoUpRegMap As Variant)
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim lDatalen As Long
    Dim SData As String
    Dim NumBytes As Integer
    
    Dim sInstructByte As String
    
    'If the data is not the proper size
    If Len(Data) > RegLength(RegAddress) Or Len(Data) < RegLength(RegAddress) Then
        'If VerboseIO is true then show an error message
        If VerboseErrors Then
            MsgBox "Error: Data is improperly sized for the addressed register.", vbApplicationModal, "USBSerialLoad() Error"
        End If
        
        'Exit the subroutine
        Exit Sub
    End If
    
    'Only work if the object is enabled
    If mvarEnabled = True Then
    
        'Redim the buffer to be sent over the USB bus
        ReDim buffer(0 To Len(Data) + 7) As Byte
        
        'Make sure that sclk is high before starting the transfer
        If EvBd.SCLK = abvLow Then
            'Make it high again
            EvBd.SCLK = abvHigh
            EvBd.USBWritePortBuffVal fx2_CTLLines
        End If
        
        'Build the instruction byte string
        'Get the number of bytes sent
        NumBytes = Len(Data) / 8
        
        'If the number of bytes to send is not a multiple of 8 or an invalid reg
        'address is being used then exit and do nothing
        If (Len(Data) Mod 8) = 0 And RegAddress <= 27 Then
            
            'Build the instruction byte
            sInstructByte = BuildInstruct(0, RegAddress)
            
            'Copy the data into a buffer where it can be manipulated preserving the origional data
            SData = Data
            
            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sInstructByte = FlipString(sInstructByte)
                'Rearrange the data into LSB First format
                SData = FlipString(SData)
            End If
            
            If AutoCSBMode = False Then
                'Set CSB low in the software buffer
                CSB = abvLow
                'Take CSB line low
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Build the serial stream
            SData = sInstructByte & SData
            
            'Convert to a byte buffer
            For i = 0 To Len(SData) - 1
                buffer(i) = CByte(Mid(SData, i + 1, 1))
            Next
            
            'Get the length of the data to be sent
            lDatalen = Len(SData)
            
            'Do the serial transfer
            result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, lDatalen)
            If mvarVerboseErrors = True Then
                If result <> 1 Then: MsgBox "Error Writing to Board", vbOKOnly, "Error - USBSerialLoad()": Exit Sub
            End If
            
            If AutoCSBMode = False Then
                'Now return the CSB line high
                CSB = abvHigh
                'Take CSB line high
                USBWritePortBuffVal fx2_PortA
            End If
            
            'If AutoIOUpdate is true then perform an IO Update
            If mvarAutoIOUpdate Then
                EvBd.IOUpdate = abvHigh
                EvBd.USBWritePortBuffVal fx2_PortD
                EvBd.IOUpdate = abvLow
                EvBd.USBWritePortBuffVal fx2_PortD
            End If
            
            'Store the value written to the register in a buffer
            If IsMissing(NoUpRegMap) Then
                SetRegMapValue 2, RegAddress, Data
            End If
            
            'Now check to see if we are writing to the spi port control register
            If RegAddress = 0 Then
            End If
        Else
            'The data isn't valid or the address isn't valid
            If mvarVerboseErrors Then
                If RegAddress < 0 Or RegAddress > &H1B Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
    
                If NumBytes = (Len(Data) / 8) Then
                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
            End If
        End If
    End If
End Sub
Private Sub USBSerialLoad2Bit(ByVal RegAddress As Integer, ByVal Data As String, Optional NoUpRegMap As Variant)
    Dim buffer() As Byte
    Dim sbuffer() As String
    Dim result As Long
    Dim i As Integer
    Dim lDatalen As Long
    Dim SData As String
    Dim NumBytes As Integer
    
    Dim sInstructByte As String
    
    'If the data is not the proper size
    If Len(Data) > RegLength(RegAddress) Or Len(Data) < RegLength(RegAddress) Then
        'If VerboseIO is true then show an error message
        If VerboseErrors Then
            MsgBox "Error: Data is improperly sized for the addressed register.", vbApplicationModal, "USBSerialLoad() Error"
        End If
        
        'Exit the subroutine
        Exit Sub
    End If
    
    'Only work if the object is enabled
    If mvarEnabled = True Then
    
        'Redim the buffer to be sent over the USB bus
        ReDim buffer(0 To Len(Data) / 2 + 3) As Byte
        ReDim sbuffer(0 To Len(Data) / 2 + 3) As String
        
        'Make sure that sclk is high before starting the transfer
        If EvBd.SCLK = abvLow Then
            'Make it high again
            EvBd.SCLK = abvHigh
            EvBd.USBWritePortBuffVal fx2_CTLLines
        End If
        
        'Build the instruction byte string
        'Get the number of bytes sent
        NumBytes = Len(Data) / 8
        
        'If the number of bytes to send is not a multiple of 8 or an invalid reg
        'address is being used then exit and do nothing
        If (Len(Data) Mod 8) = 0 And RegAddress <= 27 Then
            
            'Build the instruction byte
            sInstructByte = BuildInstruct(0, RegAddress)
            
            'Copy the data into a buffer where it can be manipulated preserving the origional data
            SData = Data
            
'            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sInstructByte = FlipBinStr2(sInstructByte)
                'Rearrange the data into LSB First format
                SData = FlipBinStr2(SData)
            End If
            
            If AutoCSBMode = False Then
                'Set CSB low in the software buffer
                CSB = abvLow
                'Take CSB line low
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Build the serial stream
            SData = sInstructByte & SData
            
            'Convert to a byte buffer
            For i = 0 To Len(SData) / 2 - 1 Step 1
                buffer(i) = BinS2Byte(Mid(SData, (i * 2) + 1, 2))
            Next
            
            'Get the length of the data to be sent
            lDatalen = Len(SData) / 2
            
            'Do the serial transfer
            result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, lDatalen)
            If mvarVerboseErrors = True Then
                If result <> 1 Then: MsgBox "Error Writing to Board", vbOKOnly, "Error - USBSerialLoad()": Exit Sub
            End If
            
            If AutoCSBMode = False Then
                'Now return the CSB line high
                CSB = abvHigh
                'Take CSB line high
                USBWritePortBuffVal fx2_PortA
            End If
            
            'If AutoIOUpdate is true then perform an IO Update
            If mvarAutoIOUpdate Then
                EvBd.IOUpdate = abvHigh
                EvBd.USBWritePortBuffVal fx2_PortD
                EvBd.IOUpdate = abvLow
                EvBd.USBWritePortBuffVal fx2_PortD
            End If
            
            'Store the value written to the register in a buffer
            If IsMissing(NoUpRegMap) Then
                SetRegMapValue 2, RegAddress, Data
            End If
            
            'Now check to see if we are writing to the spi port control register
            If RegAddress = 0 Then
            End If
        Else
            'The data isn't valid or the address isn't valid
            If mvarVerboseErrors Then
                If RegAddress < 0 Or RegAddress > &H1B Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
    
                If NumBytes = (Len(Data) / 8) Then
                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
            End If
        End If
    End If
End Sub
Private Sub USBSerialLoad4Bit(ByVal RegAddress As Integer, ByVal Data As String, Optional NoUpRegMap As Variant)
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim lDatalen As Long
    Dim SData As String
    Dim NumBytes As Integer
    
    Dim sInstructByte As String
    
    'If the data is not the proper size
    If Len(Data) > RegLength(RegAddress) Or Len(Data) < RegLength(RegAddress) Then
        'If VerboseIO is true then show an error message
        If VerboseErrors Then
            MsgBox "Error: Data is improperly sized for the addressed register.", vbApplicationModal, "USBSerialLoad() Error"
        End If
        
        'Exit the subroutine
        Exit Sub
    End If
    
    'Only work if the object is enabled
    If mvarEnabled = True Then
    
        'Redim the buffer to be sent over the USB bus
        ReDim buffer(0 To Len(Data) / 4 + 1) As Byte
        
        'Make sure that sclk is high before starting the transfer
        If EvBd.SCLK = abvLow Then
            'Make it high again
            EvBd.SCLK = abvHigh
            EvBd.USBWritePortBuffVal fx2_CTLLines
        End If
        
        'Build the instruction byte string
        'Get the number of bytes sent
        NumBytes = Len(Data) / 8
        
        'If the number of bytes to send is not a multiple of 8 or an invalid reg
        'address is being used then exit and do nothing
        If (Len(Data) Mod 8) = 0 And RegAddress <= 27 Then
            
            'Build the instruction byte
            sInstructByte = BuildInstruct(0, RegAddress)
            
            'Copy the data into a buffer where it can be manipulated preserving the origional data
            SData = Data
            
            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sInstructByte = FlipBinStr4(sInstructByte)
                'Rearrange the data into LSB First format
                SData = FlipBinStr4(SData)
            End If
            
            If AutoCSBMode = False Then
                'Set CSB low in the software buffer
                CSB = abvLow
                'Take CSB line low
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Build the serial stream
            SData = sInstructByte & SData
            
            'Convert to a byte buffer
            For i = 0 To Len(SData) / 4 - 1 Step 1
                buffer(i) = BinS2Byte(Mid(SData, (i * 4) + 1, 4))
            Next
            
            'Get the length of the data to be sent
            lDatalen = Len(SData) / 4
            
            'Do the serial transfer
            result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, lDatalen)
            If mvarVerboseErrors = True Then
                If result <> 1 Then: MsgBox "Error Writing to Board", vbOKOnly, "Error - USBSerialLoad()": Exit Sub
            End If
            
            If AutoCSBMode = False Then
                'Now return the CSB line high
                CSB = abvHigh
                'Take CSB line high
                USBWritePortBuffVal fx2_PortA
            End If
            
            'If AutoIOUpdate is true then perform an IO Update
            If mvarAutoIOUpdate Then
                EvBd.IOUpdate = abvHigh
                EvBd.USBWritePortBuffVal fx2_PortD
                EvBd.IOUpdate = abvLow
                EvBd.USBWritePortBuffVal fx2_PortD
            End If
            
            'Store the value written to the register in a buffer
            If IsMissing(NoUpRegMap) Then
                SetRegMapValue 2, RegAddress, Data
            End If
            
            'Now check to see if we are writing to the spi port control register
            If RegAddress = 0 Then
            End If
        Else
            'The data isn't valid or the address isn't valid
            If mvarVerboseErrors Then
                If RegAddress < 0 Or RegAddress > &H1B Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
    
                If NumBytes = (Len(Data) / 8) Then
                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
            End If
        End If
    End If
End Sub

Public Property Let AutoCSBMode(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.AutoCSBMode = 5
    mvarAutoCSBMode = vData
    If mvarAutoCSBMode = True Then
        SetAutoCSBMode 1
    Else
        SetAutoCSBMode 0
    End If
End Property


Public Property Get AutoCSBMode() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.AutoCSBMode
    AutoCSBMode = mvarAutoCSBMode
End Property





Public Sub ResetDUT()
    'Take the reset pin high the evaluation board
    Reset = abvHigh
    USBWritePortBuffVal fx2_PortA
    'Take the reset pin low the evaluation board
    Reset = abvLow
    USBWritePortBuffVal fx2_PortA
End Sub


'Sets the CSB Mask Value which specifies to the firmware which IO PortA Pin to use
'as CSB on the FX2 Chip
Public Function SetAutoCSBMaskVal(ByVal value As Byte) As Boolean
    'This subroutine sets the readback mode of the firmware
    'Value = 4  - CSB = Bit 3 of IO Port A
    'Value = 1  - CSB = Bit 1 of IO Port A
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    buf(0) = &H11  'Command value for setting auto CSB Mode.
    buf(1) = value 'Set the value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Setting AutoCSBMask Value."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 And mvarVerboseErrors Then
        If mvarVerboseErrors Then
            MsgBox "Error: Setting AutoCSBMask Value."
        End If
        Exit Function
    Else
        SetAutoCSBMaskVal = CBool(Data(0))
    End If
End Function
'Sets the state of the AutoCSB Flag
'AutoCSB is turned ON when Value=1
'AutoCSB is turned OFF when Value=0
Public Function SetAutoCSBMode(ByVal value As Byte) As Boolean
    'This subroutine sets the readback mode of the firmware
    'Value = 1  - Auto CSB = On
    'Value = 0  - Auto CSB = Off
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    buf(0) = &H10  'Command value for setting auto CSB Mode.
    buf(1) = value 'Set the value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Setting AutoCSBMode."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 And mvarVerboseErrors Then
        If mvarVerboseErrors Then
            MsgBox "Error: Setting AutoCSBMode."
        End If
        Exit Function
    Else
        SetAutoCSBMode = CBool(Data(0))
    End If
End Function

Public Sub SendIOReset()
    Dim buffer(0 To 1) As Byte
    
    buffer(0) = 8
    buffer(1) = 0
    
    'Turn off Auto CSB
    SetAutoCSBMode 0
    
    'Do the serial transfer
    result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, 2)
    If mvarVerboseErrors = True Then
        If result <> 1 Then: MsgBox "Error Writing to Board", vbOKOnly, "Error - USBSerialLoad()": Exit Sub
    End If

    'Turn Auto CSB Mode back on
    SetAutoCSBMode 1

End Sub

Public Property Let AutoIOUpdate(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.AutoIOUpdate = 5
    mvarAutoIOUpdate = vData
End Property


Public Property Get AutoIOUpdate() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.AutoIOUpdate
    AutoIOUpdate = mvarAutoIOUpdate
End Property



Public Property Let SDIO_3(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SDIO_3 = 5
'    mvarSDIO_3 = vData
    USBSetPortBitVal fx2_PortB, bnUSB_SDIO_3, vData
End Property


Public Property Get SDIO_3() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SDIO_3
'    Set SDIO_3 = mvarSDIO_3
    SDIO_3 = USBGetPortBitVal(fx2_PortB, bnUSB_SDIO_3)
End Property



Public Property Let SDIO_2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SDIO_2 = 5
'    mvarSDIO_2 = vData
    USBSetPortBitVal fx2_PortB, bnUSB_SDIO_2, vData
End Property


Public Property Get SDIO_2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SDIO_2
'    Set SDIO_2 = mvarSDIO_2
    SDIO_2 = USBGetPortBitVal(fx2_PortB, bnUSB_SDIO_2)
End Property



Public Property Let SDIO_1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SDIO_1 = 5
'    mvarSDIO_1 = vData
    USBSetPortBitVal fx2_PortB, bnUSB_SDIO_1, vData
End Property


Public Property Get SDIO_1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SDIO_1
'    Set SDIO_1 = mvarSDIO_1
    SDIO_1 = USBGetPortBitVal(fx2_PortB, bnUSB_SDIO_1)
End Property



Public Property Let SDIO_0(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SDIO = 5
'    mvarSDIO_0 = vData
    USBSetPortBitVal fx2_PortB, bnUSB_SDIO_0, vData
End Property


Public Property Get SDIO_0() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SDIO
'    Set SDIO_0 = mvarSDIO
    SDIO_0 = USBGetPortBitVal(fx2_PortB, bnUSB_SDIO_0)
End Property



Public Property Let USBStatusCtrl(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.USBStatusCtrl = 5
'    mvarUSBStatusCtrl = vData
    Dim bRetval As Boolean
    bRetval = SetLEDBlink(CByte(vData))
End Property


Public Property Get USBStatusCtrl() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.USBStatusCtrl
'    Set USBStatusCtrl = mvarUSBStatusCtrl
    Dim bRetval As Boolean
    bRetval = SetLEDBlink(2)
    If bRetval Then
        USBStatusCtrl = abvHigh
    Else
        USBStatusCtrl = abvLow
    End If
End Property



Public Property Let USB_Status(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.USB_Status = 5
'    mvarUSB_Status = vData
    USBSetPortBitVal fx2_PortA, bnUSB_USB_Status, vData
End Property


Public Property Get USB_Status() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.USB_Status
'    Set USB_Status = mvarUSB_Status
    USB_Status = USBGetPortBitVal(fx2_PortA, bnUSB_USB_Status)
End Property



Public Property Let Reset(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Reset = 5
'    mvarReset = vData
    USBSetPortBitVal fx2_PortA, bnUSB_RESET, vData
End Property


Public Property Get Reset() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Reset
'    Set Reset = mvarReset
    Reset = USBGetPortBitVal(fx2_PortA, bnUSB_RESET)
End Property



Public Property Let PwrDwn(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.PwrDwn = 5
'    mvarPwrDwn = vData
    USBSetPortBitVal fx2_PortA, bnUSB_PWRDWN, vData
End Property


Public Property Get PwrDwn() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.PwrDwn
'    Set PwrDwn = mvarPwrDwn
    PwrDwn = USBGetPortBitVal(fx2_PortA, bnUSB_PWRDWN)
End Property



Public Property Let CLKModeSel(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.CLKModeSel = 5
'    mvarCLKModeSel = vData
    USBSetPortBitVal fx2_PortA, bnUSB_CLKMDSEL, vData
End Property


Public Property Get CLKModeSel() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.CLKModeSel
'    Set CLKModeSel = mvarCLKModeSel
    CLKModeSel = USBGetPortBitVal(fx2_PortA, bnUSB_CLKMDSEL)
End Property



Public Property Let RURD_2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.RURD_2 = 5
'    mvarRURD_2 = vData
    USBSetPortBitVal fx2_PortD, bnUSB_RURD2, vData
End Property


Public Property Get RURD_2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RURD_2
'    Set RURD_2 = mvarRURD_2
    RURD_2 = USBGetPortBitVal(fx2_PortD, bnUSB_RURD2)
End Property



Public Property Let RURD_1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.RURD_1 = 5
'    mvarRURD_1 = vData
    USBSetPortBitVal fx2_PortD, bnUSB_RURD1, vData
End Property


Public Property Get RURD_1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RURD_1
'    Set RURD_1 = mvarRURD_1
    RURD_1 = USBGetPortBitVal(fx2_PortD, bnUSB_RURD1)
End Property



Public Property Let RURD_0(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.RURD_0 = 5
'    mvarRURD_0 = vData
    USBSetPortBitVal fx2_PortD, bnUSB_RURD0, vData
End Property


Public Property Get RURD_0() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RURD_0
'    Set RURD_0 = mvarRURD_0
    RURD_0 = USBGetPortBitVal(fx2_PortD, bnUSB_RURD0)
End Property



Public Property Let IOUpdate(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.IOUpdate = 5
'    mvarIOUpdate = vData
    USBSetPortBitVal fx2_PortD, bnUSB_IOUpdate, vData
End Property


Public Property Get IOUpdate() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.IOUpdate
'    Set IOUpdate = mvarIOUpdate
    IOUpdate = USBGetPortBitVal(fx2_PortD, bnUSB_IOUpdate)
End Property



Public Property Let P4(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.P4 = 5
'    mvarP4 = vData
    USBSetPortBitVal fx2_PortD, bnUSB_P4, vData
End Property


Public Property Get P4() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.P4
'    Set P4 = mvarP4
    P4 = USBGetPortBitVal(fx2_PortD, bnUSB_P4)
End Property



Public Property Let P3(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.P3 = 5
'    mvarP3 = vData
    USBSetPortBitVal fx2_PortD, bnUSB_P3, vData
End Property


Public Property Get P3() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.P3
'    Set P3 = mvarP3
    P3 = USBGetPortBitVal(fx2_PortD, bnUSB_P3)
End Property



Public Property Let P2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.P2 = 5
'    mvarP2 = vData
    USBSetPortBitVal fx2_PortD, bnUSB_P2, vData
End Property


Public Property Get P2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.P2
'    Set P2 = mvarP2
    P2 = USBGetPortBitVal(fx2_PortD, bnUSB_P2)
End Property



Public Property Let P1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.P1 = 5
'    mvarP1 = vData
    USBSetPortBitVal fx2_PortD, bnUSB_P1, vData
End Property


Public Property Get P1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.P1
'    Set P1 = mvarP1
    P1 = USBGetPortBitVal(fx2_PortD, bnUSB_P1)
End Property



Public Property Let CSB(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.CSB = 5
'    mvarCSB = vData
    'Set the bitvalue for port in the software buffer
    USBSetPortBitVal fx2_PortA, bnUSB_CSB, vData
End Property


Public Property Get CSB() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.CSB
    'Set CSB = mvarCSB
    CSB = USBGetPortBitVal(fx2_PortA, bnUSB_CSB)
End Property



Public Property Let SCLK(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SCLK = 5
'    mvarSCLK = vData
    USBSetPortBitVal fx2_CTLLines, bnUSB_SCLK, vData
End Property


Public Property Get SCLK() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SCLK
'    Set SCLK = mvarSCLK
    SCLK = USBGetPortBitVal(fx2_CTLLines, bnUSB_SCLK)
End Property



Public Property Let SPI_LSB_First(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SPI_LSB_First = 5
    'mvarSPI_LSB_First = vData
    'Set the value in the register map , note that you must perform a serial load
    'with that new register data for it to take effect
    If vData Then
        SetRegMapBitValue rm9911_NewRegMapVals, 0, 0, abvHigh
    Else
        SetRegMapBitValue rm9911_NewRegMapVals, 0, 0, abvLow
    End If
End Property


Public Property Get SPI_LSB_First() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SPI_LSB_First
    Dim lSPILSBFirst As Long
    lSPILSBFirst = GetRegMapBitValue(rm9911_CurRegMapVals, 0, 0)
    If lSPILSBFirst = 1 Then
        mvarSPI_LSB_First = True
    Else
        mvarSPI_LSB_First = False
    End If
    SPI_LSB_First = mvarSPI_LSB_First
End Property



Public Property Let SPI_IOMode(ByVal vData As spiIOMode)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SPI_IOMode = 5
'    mvarSPI_IOMode = vData
    Dim sRegVal As String
    'Get the current CSR register value
    sRegVal = GetRegMapValue(rm9911_CurRegMapVals, 0)
    'Set the new bit value
    sRegVal = Left(sRegVal, 5) & cbaseDec2Bin(vData, 2) & Right(sRegVal, 1)
    'Set the modified register map value
    SetRegMapValue rm9911_NewRegMapVals, 0, sRegVal
End Property


Public Property Get SPI_IOMode() As spiIOMode
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SPI_IOMode
    Dim sRegVal As String
    
    'Get the current CSR register value
    sRegVal = GetRegMapValue(rm9911_CurRegMapVals, 0)
    'Extract and return the value from the register map value
    mvarSPI_IOMode = cbaseBinS2Dec(Mid(sRegVal, 6, 2))
    SPI_IOMode = mvarSPI_IOMode
End Property



Public Property Let RURDBitVal(ByVal vData As Integer)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.RURDBitVal = 5
    'Store the current value in the local variable
    'mvarRURDBitVal = vData
    Dim sRegVal As String
    'Get the current CSR register value
    sRegVal = GetRegMapValue(rm9911_CurRegMapVals, 1)
    'Set the new bit value
    sRegVal = Left(sRegVal, 12) & cbaseDec2Bin(vData, 2) & Right(sRegVal, 10)
    'Set the modified register map value
    SetRegMapValue rm9911_NewRegMapVals, 1, sRegVal
End Property


Public Property Get RURDBitVal() As Integer
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RURDBitVal
    Dim sRegVal As String
    
    'Get the current CSR register value
    sRegVal = GetRegMapValue(rm9911_CurRegMapVals, 1)
    'Extract and return the value from the register map value
    mvarRURDBitVal = cbaseBinS2Dec(Mid(sRegVal, 13, 2))
    
    RURDBitVal = mvarRURDBitVal
End Property




Public Property Let VerboseErrors(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.VerboseErrors = 5
    mvarVerboseErrors = vData
End Property


Public Property Get VerboseErrors() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.VerboseErrors
    VerboseErrors = mvarVerboseErrors
End Property



Public Property Let Enabled(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Enabled = 5
    mvarEnabled = vData
End Property


Public Property Get Enabled() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Enabled
    Enabled = mvarEnabled
End Property



'Returns the byte indexed by iByteIndex from lValue
'Ex GetByteFromLong(&hFFABE1,1) would return &hAB
'Ex GetByteFromLong(&hFFABE1,4) would return 00
Private Function GetByteFromLong(ByVal lValue As Double, ByVal iByteIndex) As Byte
    If iByteIndex >= 0 And iByteIndex <= 3 Then
        GetByteFromLong = CByte(&HFF And Int(lValue / (256 ^ iByteIndex)))
    Else
        GetByteFromLong = &H0
    End If
End Function
'Returns the merged value of a
Private Function MergeBytes2Long(ByVal bByte3 As Byte, ByVal bByte2 As Byte, ByVal bByte1 As Byte, ByVal bByte0 As Byte) As Long
    Dim sTempVal As String
    
    'Build a hex string - seems to be the easiest way
    sTempVal = Format(Hex(bByte3), "00") & Format(Hex(bByte2), "00") & Format(Hex(bByte1), "00") & Format(Hex(bByte0), "00")
        
    'Result = (bbyte3 * 256^3) + (bbyte2 * 256^2) + (bbyte1 * 256^1) + (bbyte0 * 256^0)
    'MergeBytes2Long = (bByte3 * 16777216) + (bByte2 * 65536) + (bByte1 * 256) + bByte0
    'Convert that to a long value
    MergeBytes2Long = CLng("&h" & sTempVal)
End Function


Public Sub SetRdBackMode(ByVal value As Boolean)
    'This subroutine sets the readback mode of the firmware
    'Value = true  - Single byte read mode enabled
    'Value = false - Single byte read mode disabled
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H4 'Command value for setting single read byte count mode.
    If value = True Then
        buf(1) = 1
    Else
        buf(1) = 0
    End If
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 And mvarVerboseErrors Then
        MsgBox "Error: Setting single readback mode."
        Exit Sub
    End If
End Sub

'This gives the user control over the USB Status LED on the evaluation board
' Value = 0 - Stops the firware controled LED Flashing and gives control
'             to the software.
' Value = 1 - Resumes the firmware controled LED Flashing.
' Value = 2 - Returns 1 if firmware flashing is on and 0 if it is off.
Public Function SetLEDBlink(ByVal value As Byte) As Boolean
    'This subroutine sets the readback mode of the firmware
    'Value = true  - Single byte read mode enabled
    'Value = false - Single byte read mode disabled
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    buf(0) = &HF   'Command value for setting single read byte count mode.0
    buf(1) = value 'Set the value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Could not set LED Blink value."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 And mvarVerboseErrors Then
        If mvarVerboseErrors Then
            MsgBox "Error: Could not set LED Blink value."
        End If
        Exit Function
    Else
        SetLEDBlink = CBool(Data(0))
    End If
End Function

Public Function SetPortBValue(ByVal value As Byte) As Boolean
    'This routine sets the value applied to PortA's pins on the EZUSB FX2 chip
    'Returns - True if successfull, False if unsuccessfull
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HA  'Comand value for Writing PortA Value
    buf(1) = value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error setting PortB value."
        End If
        SetPortBValue = False
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error setting PortB value."
        End If
        SetPortBValue = False
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortBValue = True
    Else
        SetPortBValue = False
    End If
End Function

Public Function GetPortBValue() As Byte
    'This routine returns the value of PortB
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H9
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get PortB value."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get PortB value."
        End If
        Exit Function
    End If

    'Return the value.
    GetPortBValue = Data(0)
End Function

Public Sub ResetFirmware()
    'Resets the firmware

    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H8 'Command value to reset the firmware and evaluation board.
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 And mvarVerboseErrors Then
        MsgBox "Error: Resetting evaluation board."
        Exit Sub
    End If
End Sub

Public Function SetPortDValue(ByVal value As Byte) As Boolean
    'This routine sets the value of port D to the value of "Value"
    'Input - Value: the value to be applied to the port d pins
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HC  'Comand value for Writing PortD Value
    buf(1) = value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set PortD value."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set PortD value."
        End If
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortDValue = True
    Else
        SetPortDValue = False
    End If
End Function

Public Function GetPortDValue() As Byte
    'This routine returns the value of PortA
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &HB
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get PortD value."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get PortD value."
        End If
        Exit Function
    End If

    'Return PortD's value
    GetPortDValue = Data(0)
End Function

Public Function GetFirmWareVersion() As String
    'This routine returns 2 bytes.  The first contains version Major
    'the second contains version minor.
    'Example = VerMajor.VerMinor = 1.9
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    Driver = clsEZUSBDev01.DriverName
    buf(0) = &H0
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1) 'DoBulkXfer(Driver, 0, buf, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get firmware revision."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 2) 'DoBulkXfer(Driver, 1, Data, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get firmware revision."
        End If
        Exit Function
    End If

    'Return the firmware version
    GetFirmWareVersion = CStr(Data(0)) & "." & CStr(Data(1))
End Function

Public Function SetPortAValue(ByVal value As Byte) As Boolean
    'This routine sets the value applied to PortA's pins on the EZUSB FX2 chip
    'Returns - True if successfull, False if unsuccessfull
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H1 'Comand value for Writing PortA Value
    buf(1) = value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set PortA value."
        End If
        SetPortAValue = False
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
'    result = DoBulkXfer(Driver, 1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set PortA value."
        End If
        SetPortAValue = False
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortAValue = True
    Else
        SetPortAValue = False
    End If
End Function

Public Function GetPortAValue() As Byte
    'This routine returns the value of PortA from the EZUSB-FX2 chip
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H2
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get PortA value."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get PortA value."
        End If
        Exit Function
    End If

    'Return the firmware version
    GetPortAValue = Data(0)
End Function

Public Function GetCtlValues()
    'This routine returns 1 byte.  Which represents the current
    'state of the GPIF Ctl lines
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H6
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get CTL Line values."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to get CTL Line values."
        End If
        Exit Function
    End If

    'Return the value
    GetCtlValues = Data(0)
End Function


Public Function SetCtlValues(ByVal value As Byte) As Boolean
    'This routine sets the value of the control lines
    'Value = Value to be set to the GPIFIDLECTL register on the EzUSB FX2 chip.
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H5 'Comand value for Writing CTL Values
    buf(1) = value
       
    'send 2 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set CTL Line values."
        End If
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set CTL Line values."
        End If
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetCtlValues = True
    Else
        SetCtlValues = False
    End If
End Function

Public Sub SetRdBackByteCnt(ByVal value As Integer)
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H7 'Command value for setting single read byte count mode.
    buf(1) = MSB(value)
    buf(2) = lsb(value)
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 3)
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set Read Back Count."
        End If
        Exit Sub
    End If

End Sub
Public Function SetHostID(ByVal lHostID As Long) As Long
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim buf(5) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    buf(0) = &HD  'Command value
    buf(1) = GetByteFromLong(lHostID, 3)
    buf(2) = GetByteFromLong(lHostID, 2)
    buf(3) = GetByteFromLong(lHostID, 1)
    buf(4) = GetByteFromLong(lHostID, 0)
    
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 5)
    
    'Return the result
    SetHostID = result
    If result <> 1 Then
        If mvarVerboseErrors Then
            MsgBox "Error: Unable to set the HostID."
        End If
        'Exit Function
    End If
End Function
'Gets the most significant byte from iVal and returns it
Private Function MSB(ByVal iVal As Integer) As Byte
    MSB = CByte(Fix(iVal / 256))
End Function
'Gets the lease significant byte from iVal and returns it
Private Function lsb(ByVal iVal As Integer) As Byte
    lsb = CByte(Fix(iVal And &HFF))
End Function


Private Sub Class_Initialize()
    Dim cntr As Integer
    Dim sDummy As String
        
    'Set the initial value of events enabed flag
    mEventsEnabled = True
        
    'Initialize the bitvals array
    For cntr = 0 To 7
        evbBitVals(cntr) = 2 ^ cntr
    Next cntr
    
    'Setup the evaluation board buffers values, but call InitIOBuffs once
    'the device has been selected
    fx2PortVals(0) = &H0
    fx2PortVals(1) = &H0
    fx2PortVals(2) = &H0
    fx2PortVals(3) = &H0
    fx2PortVals(4) = &H0
    fx2PortVals(5) = &H0
    
    'Setup the register lengths
    RegLength(0) = 8
    RegLength(1) = 24
    RegLength(2) = 16
    RegLength(3) = 24
    RegLength(4) = 32
    RegLength(5) = 16
    RegLength(6) = 24
    RegLength(7) = 16
    RegLength(8) = 32
    RegLength(9) = 32
    RegLength(10) = 32
    RegLength(11) = 32
    RegLength(12) = 32
    RegLength(13) = 32
    RegLength(14) = 32
    RegLength(15) = 32
    RegLength(16) = 32
    RegLength(17) = 32
    RegLength(18) = 32
    RegLength(19) = 32
    RegLength(20) = 32
    RegLength(21) = 32
    RegLength(22) = 32
    RegLength(23) = 32
    RegLength(24) = 32
    RegLength(25) = 16
    RegLength(26) = 32
    RegLength(27) = 32
    
    'Loop through all of the registers and assign 0 value to them
    For cntr = 0 To UBound(sRegMapVals())
        'Create a binary string with a value of 0
        sDummy = String(RegLength(cntr), "0")
        sDefaultRegMapVals(cntr) = sDummy
        
        'Initialize the channel register values
        If cntr >= 3 And cntr <= 24 Then
            sDefChnlRegVals(0, cntr - 3) = sDummy
            sDefChnlRegVals(1, cntr - 3) = sDummy
            sDefChnlRegVals(2, cntr - 3) = sDummy
            sDefChnlRegVals(3, cntr - 3) = sDummy
        End If
    Next cntr
    
    'Set the default values for registers that don't
    'have all zeros in them
    sDefaultRegMapVals(0) = cbaseDec2Bin(&HF0, 8)
    sDefaultRegMapVals(3) = cbaseDec2Bin(&H302, 24)
    sDefChnlRegVals(0, 0) = cbaseDec2Bin(&H302, 24)
    sDefChnlRegVals(1, 0) = cbaseDec2Bin(&H302, 24)
    sDefChnlRegVals(2, 0) = cbaseDec2Bin(&H302, 24)
    sDefChnlRegVals(3, 0) = cbaseDec2Bin(&H302, 24)
    
    'Initialize the register map buffers
    InitRegMap
    
    'Initialize the enabled property
    mvarEnabled = True
    mvarAutoIOUpdate = True
    mvarAutoCSBMode = True
End Sub

Public Sub InitIOBuffs()
    'Get the current port values and store them in the IO buffers
    fx2PortVals(0) = GetPortDValue()
    fx2PortVals(1) = GetPortAValue()
    fx2PortVals(2) = GetCtlValues()
    fx2PortVals(3) = GetPortBValue()
    fx2PortVals(4) = &H0
    fx2PortVals(5) = &H0
End Sub

'Initializes the register map buffers
Public Sub InitRegMap()
    Dim cntr As Integer
    Dim cntr1 As Integer
    
    'Loop through all of the registers and assign 0 value to them
    For cntr = 0 To UBound(sRegMapVals())
        sRegMapValsNew(cntr) = sDefaultRegMapVals(cntr)
        sRegMapVals(cntr) = sDefaultRegMapVals(cntr)
    Next cntr

    'Initialize the channel registers
    For cntr = 0 To UBound(sChnlRegVals, 1)
        For cntr1 = 0 To UBound(sChnlRegVals, 2)
            'Initialize the channel register current values
            sChnlRegVals(cntr, cntr1) = sDefChnlRegVals(cntr, cntr1)
            'Initialize the channel register new values
            sChnlRegValsNew(cntr, cntr1) = sDefChnlRegVals(cntr, cntr1)
        Next cntr1
    Next cntr
End Sub

Public Sub ResetRegMap(ByVal RegMap As evb9911_RegMaps)
    Dim cntr As Integer
    
    For cntr = 0 To UBound(sDefaultRegMapVals())
        If cntr < 7 Or cntr > &H18 Then
            Select Case RegMap
                Case 0
                    'Set the default value
                    sRegMapVals(cntr) = sDefaultRegMapVals(cntr)
                    If cntr >= 3 And cntr <= 24 Then
                        sChnlRegVals(0, cntr - 3) = sDefChnlRegVals(0, cntr - 3)
                        sChnlRegVals(1, cntr - 3) = sDefChnlRegVals(1, cntr - 3)
                        sChnlRegVals(2, cntr - 3) = sDefChnlRegVals(2, cntr - 3)
                        sChnlRegVals(3, cntr - 3) = sDefChnlRegVals(3, cntr - 3)
                    End If
                Case 1
                    'Set the default value
                    sRegMapValsNew(cntr) = sDefaultRegMapVals(cntr)
                    If cntr >= 3 And cntr <= 24 Then
                        sChnlRegValsNew(0, cntr - 3) = sDefChnlRegVals(0, cntr - 3)
                        sChnlRegValsNew(1, cntr - 3) = sDefChnlRegVals(1, cntr - 3)
                        sChnlRegValsNew(2, cntr - 3) = sDefChnlRegVals(2, cntr - 3)
                        sChnlRegValsNew(3, cntr - 3) = sDefChnlRegVals(3, cntr - 3)
                    End If
                Case 2
                    'Set the default value
                    sRegMapValsNew(cntr) = sDefaultRegMapVals(cntr)
                    sRegMapVals(cntr) = sDefaultRegMapVals(cntr)
                    If cntr >= 3 And cntr <= 24 Then
                        sChnlRegValsNew(0, cntr - 3) = sDefChnlRegVals(0, cntr - 3)
                        sChnlRegValsNew(1, cntr - 3) = sDefChnlRegVals(1, cntr - 3)
                        sChnlRegValsNew(2, cntr - 3) = sDefChnlRegVals(2, cntr - 3)
                        sChnlRegValsNew(3, cntr - 3) = sDefChnlRegVals(3, cntr - 3)
                        
                        sChnlRegVals(0, cntr - 3) = sDefChnlRegVals(0, cntr - 3)
                        sChnlRegVals(1, cntr - 3) = sDefChnlRegVals(1, cntr - 3)
                        sChnlRegVals(2, cntr - 3) = sDefChnlRegVals(2, cntr - 3)
                        sChnlRegVals(3, cntr - 3) = sDefChnlRegVals(3, cntr - 3)
                    End If
            End Select
        End If
    Next cntr
    
    'Raise the regmap changed event
    If mEventsEnabled Then RaiseEvent RegmapChanged(RegMap)
End Sub

Public Sub SetRegMapBitValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddress As Integer, ByVal BitNum As Integer, ByVal value As adiBitValues, Optional CHMask = "None")
    Dim RegVal As String
    Dim BitVal As String
    Dim RegLen As Integer
    
    'Add 1 the bit number
    BitNum = BitNum
    
    If RegLength(RegAddress) > BitNum Then
        'Test to see if they are setting a channel register or not
        If RegAddress >= 0 And RegAddress <= 2 Or RegAddress >= &H19 And RegAddress <= &H1B Then
            If RegMap = rm9911_NewRegMapVals Then
                'Get the current value of the register
                RegVal = sRegMapValsNew(RegAddress)
                BitVal = CStr(value)
                RegLen = RegLength(RegAddress)
                'Set the new bit value
                sRegMapValsNew(RegAddress) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
            ElseIf RegMap = rm9911_CurRegMapVals Then
                'Get the current value of the register
                RegVal = sRegMapVals(RegAddress)
                BitVal = CStr(value)
                RegLen = RegLength(RegAddress)
                'Set the new the bit value
                sRegMapVals(RegAddress) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
            Else
                'Get the current value of the register
                RegVal = sRegMapValsNew(RegAddress)
                BitVal = CStr(value)
                RegLen = RegLength(RegAddress)
                'Set the new the bit value
                sRegMapVals(RegAddress) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
                sRegMapValsNew(RegAddress) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
            End If
        Else
            'See if they passed a channel mask value
            If CHMask <> "None" Then
                'Set the channel register
                SetChRegBitValue RegMap, RegAddress, BitNum, value, CHMask
            Else
                'Set the channel register
                SetChRegBitValue RegMap, RegAddress, BitNum, value, ChIOEn_Mask
            End If
        End If
    Else
        MsgBox "The BIT being addressed does not exist in the addressed register location!", vbCritical, "clsAD9956EvBd.SetRegMapBitVal - Ivalid Parameter: BitNum"
    End If
End Sub
'Returns a single bit value from the register map
Public Function GetRegMapBitValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddress As Integer, ByVal BitNum As Integer, Optional iChnl As Integer) As adiBitValues
    Dim BitValue As String
    If RegLength(RegAddress) > BitNum Then
        If RegAddress >= 0 And RegAddress <= 2 Or RegAddress >= &H19 And RegAddress <= &H1B Then
            If RegMap = rm9911_NewRegMapVals Then
                'Return the bit value
                BitValue = Mid(sRegMapValsNew(RegAddress), RegLength(RegAddress) - BitNum, 1)
            Else
                'Return the bit value
                BitValue = Mid(sRegMapVals(RegAddress), RegLength(RegAddress) - BitNum, 1)
            End If
            
            'Return the value that was retrieved
            If BitValue = "1" Then
                GetRegMapBitValue = abvHigh
            Else
                GetRegMapBitValue = abvLow
            End If
        Else
            GetRegMapBitValue = GetChRegBitValue(RegMap, RegAddress, BitNum, iChnl)
        End If
    Else
        MsgBox "The BIT being addressed does not exist in the addressed register location!", vbCritical, "clsAD9956EvBd.GetRegMapBitVal - Ivalid Parameter: BitNum"
    End If
End Function

'If the user select's both duts they will only get dut1
Public Function GetRegMapValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddr As Integer, Optional iChnl As Integer) As String
    'Test to see which type of register it is
    If RegAddr >= 0 And RegAddr <= 2 Or RegAddr >= &H19 And RegAddr <= &H1B Then
        If RegMap = rm9911_NewRegMapVals Then
            GetRegMapValue = sRegMapValsNew(RegAddr)
        Else
            GetRegMapValue = sRegMapVals(RegAddr)
        End If
    Else
        If RegMap = rm9911_NewRegMapVals Then
            GetRegMapValue = sChnlRegValsNew(iChnl, RegAddr - 3) ' sRegMapValsNew(RegAddr)
        Else
            GetRegMapValue = sChnlRegVals(iChnl, RegAddr - 3)
        End If
    End If
End Function

'Sets a new regmap value in the softwares copy of the register map
Public Sub SetRegMapValue(ByVal RegMap As evb9911_RegMaps, ByVal RegAddress As Integer, ByVal strValue As String, Optional CHMask = "None")
        
    Select Case RegAddress
        Case 5:
            strValue = "00" & Right(strValue, 14)
    End Select
    
    'Test to see which type of register it is
    If RegAddress >= 0 And RegAddress <= 2 Or RegAddress >= &H19 And RegAddress <= &H1B Then
        'Non channel register
        Select Case RegMap
            Case rm9911_NewRegMapVals
                sRegMapValsNew(RegAddress) = strValue
            Case rm9911_CurRegMapVals
                sRegMapVals(RegAddress) = strValue
            Case 2
                sRegMapValsNew(RegAddress) = strValue
                sRegMapVals(RegAddress) = strValue
            Case Else
                sRegMapValsNew(RegAddress) = strValue
                sRegMapVals(RegAddress) = strValue
        End Select
    Else
        'See if they passed a channel mask value
        If CHMask <> "None" Then
            'This is a channel register
            SetChRegValue RegMap, RegAddress, strValue, CHMask
        Else
            'This is a channel register
            SetChRegValue RegMap, RegAddress, strValue, ChIOEn_Mask
        End If
    End If
End Sub

'USBSerialLoad
'Sends data over the SPI port lines to the DUT
Public Sub USBSerialLoad(ByVal RegAddress As Integer, ByVal Data As String, Optional NoUpRegMap)
    Select Case SPI_IOMode
        Case spi4Wire, spi3Wire
            If IsMissing(NoUpRegMap) Then
                USBSerialLoad1Bit RegAddress, Data
            Else
                USBSerialLoad1Bit RegAddress, Data, 1
            End If
        Case spi2BitSerial
            If IsMissing(NoUpRegMap) Then
                USBSerialLoad2Bit RegAddress, Data
            Else
                USBSerialLoad2Bit RegAddress, Data, 1
            End If
        Case spi4BitSerial
            If IsMissing(NoUpRegMap) Then
                USBSerialLoad4Bit RegAddress, Data
            Else
                USBSerialLoad4Bit RegAddress, Data, 1
            End If
    End Select
End Sub
Public Function USBSerialRead(ByVal RegAddress As Integer, Optional NoUpRegMap) As String
    Select Case SPI_IOMode
        Case spi4Wire, spi3Wire
            If IsMissing(NoUpRegMap) Then
                USBSerialRead = USBSerialRead1Bit(RegAddress)
            Else
                USBSerialRead = USBSerialRead1Bit(RegAddress, 1)
            End If
        Case spi2BitSerial
            If IsMissing(NoUpRegMap) Then
                USBSerialRead = USBSerialRead2Bit(RegAddress)
            Else
                USBSerialRead = USBSerialRead2Bit(RegAddress, 1)
            End If
        Case spi4BitSerial
            If IsMissing(NoUpRegMap) Then
                USBSerialRead = USBSerialRead4Bit(RegAddress)
            Else
                USBSerialRead = USBSerialRead4Bit(RegAddress, 1)
            End If
    End Select
End Function
'Do not try to read back more than 8 bytes of data because of a firmware limitation
Private Function USBSerialRead1Bit(ByVal RegAddress As Integer, Optional NoUpRegMap) As String
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim IDataLen As Long
    Dim sDriverName As String
    Dim ReturnBuff() As Byte
    Dim sRetStr As String
    Dim MaskVal As Byte 'Used to mask out either SDO or SDIO from the returned data
    
    Dim lBytes2Rd As Long
    
    Dim sInstructByte As String
                
    'Only work if the object is enabled
    If mvarEnabled = True Then
        'Validate the register address
        If RegAddress >= 0 And RegAddress <= 27 Then
            'Build the instruction byte string
            sInstructByte = BuildInstruct(1, RegAddress)
            'Number of bytes to write instruction byte
            IDataLen = Len(sInstructByte)
            
            'Get the bytes to read
            lBytes2Rd = GetRegLength(RegAddress)
            
            'Setup a buffer to receive data into
            ReDim ReturnBuff(0 To lBytes2Rd - 1) As Byte
            
            'Set number of bytes to read
            SetRdBackByteCnt lBytes2Rd
            
            'Make sure that SCLK is High
            If SCLK = abvLow Then
                SCLK = abvHigh
                USBWritePortBuffVal fx2_CTLLines
            End If

            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sInstructByte = FlipString(sInstructByte)
            End If
                
            'Convert the binary string into a bytearray for sending via the USB
            buffer() = Str2ByteArray(sInstructByte)
            
            If AutoCSBMode = False Then
                'Now take the CSB line Low
                CSB = abvLow
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Write the instruction byte
            result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, IDataLen)
            If result <> 1 Then
                If mvarVerboseErrors Then
                    MsgBox "Error Writing to Board", vbOKOnly, "Error"
                End If
                Exit Function
            End If
            
            '*** Note - This is now done automatically as long as you set the
            'rdBackCount before the sending the instruction byte
            'This line actually reads back the data into the EP8 Fifo and readys
            'it for readback by the PC using the Bulk Transfer below
            'Set the firmware in readback mode
            'SetRdBackMode True
            
            'Readback the register value
            result = clsEZUSBDev01.BulkXfer(ezRead, ReturnBuff, lBytes2Rd)
            If result <> 1 Then
                If mvarVerboseErrors Then
                    MsgBox "Error Reading From Board", vbOKOnly, "Error"
                End If
                Exit Function
            End If
            
            'Disable readback mode
            SetRdBackMode False
            
            'Now return the CSB line high
            If AutoCSBMode = False Then
                CSB = abvHigh
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Setup the bitmask for the returned data
            If SPI_IOMode = spi3Wire Then
                MaskVal = evbBitVals(bnUSB_SDIO_0)
            Else
                MaskVal = evbBitVals(bnUSB_SDIO_2)
            End If
            
            'Mask out the proper bit Bit0 = SDIO, Bit1 = SDO-ThreeWireMode
            For i = 0 To lBytes2Rd - 1
                If ReturnBuff(i) And MaskVal Then
                    ReturnBuff(i) = 1
                Else
                    ReturnBuff(i) = 0
                End If
            Next i
            
            'Convert the byte array "ReturnBuff" to a binary string
            sRetStr = ByteArray2Str(ReturnBuff)
            
            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sRetStr = FlipString(sRetStr)
            End If
            
            'Store the value read from the register in the register map
            If IsMissing(NoUpRegMap) Then
                'sSetRegVals 2, RegAddress, sRetStr
                SetRegMapValue 2, RegAddress, sRetStr
            End If
            
            'Return the cleaned up data to the user
            USBSerialRead1Bit = sRetStr
        Else
            'Display an error message
            'The data isn't valid or the address isn't valid
            If mvarVerboseErrors Then
                If RegAddress < 0 Or RegAddress > &H1B Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
'
'                If NumBytes = (Len(Data) / 8) Then
'                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub SerialLoad"
'                End If
            End If
        End If
    End If
End Function
'Do not try to read back more than 8 bytes of data because of a firmware limitation
Private Function USBSerialRead2Bit(ByVal RegAddress As Integer, Optional NoUpRegMap) As String
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim IDataLen As Long
    Dim sDriverName As String
    Dim ReturnBuff() As Byte
    Dim sRetStr As String
    Dim MaskVal As Byte 'Used to mask out either SDO or SDIO from the returned data
    
    Dim lBytes2Rd As Long
    
    Dim sInstructByte As String
                
    'Only work if the object is enabled
    If mvarEnabled = True Then
        'Validate the register address
        If RegAddress >= 0 And RegAddress <= 27 Then
            'Build the instruction byte string
            sInstructByte = BuildInstruct(1, RegAddress)
            'Number of bytes to write instruction byte
            IDataLen = Len(sInstructByte) / 2
            
            'Get the bytes to read
            lBytes2Rd = GetRegLength(RegAddress) / 2
            
            'Setup a buffer to receive data into
            ReDim ReturnBuff(0 To lBytes2Rd - 1) As Byte
            ReDim buffer(0 To IDataLen - 1)
            
            'Set number of bytes to read
            SetRdBackByteCnt lBytes2Rd
            
            'Make sure that SCLK is High
            If SCLK = abvLow Then
                SCLK = abvHigh
                USBWritePortBuffVal fx2_CTLLines
            End If

            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sInstructByte = FlipBinStr2(sInstructByte)
            End If
                
            'Convert to a byte buffer
            For i = 0 To Len(sInstructByte) / 2 - 1 Step 1
                buffer(i) = BinS2Byte(Mid(sInstructByte, (i * 2) + 1, 2))
            Next
            
            If AutoCSBMode = False Then
                'Now take the CSB line Low
                CSB = abvLow
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Write the instruction byte
            result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, IDataLen)
            If result <> 1 Then
                If mvarVerboseErrors Then
                    MsgBox "Error Writing to Board", vbOKOnly, "Error"
                End If
                Exit Function
            End If
            
            '*** Note - This is now done automatically as long as you set the
            'rdBackCount before the sending the instruction byte
            'This line actually reads back the data into the EP8 Fifo and readys
            'it for readback by the PC using the Bulk Transfer below
            'Set the firmware in readback mode
            'SetRdBackMode True
            
            'Readback the register value
            result = clsEZUSBDev01.BulkXfer(ezRead, ReturnBuff, lBytes2Rd)
            If result <> 1 Then
                If mvarVerboseErrors Then
                    MsgBox "Error Reading From Board", vbOKOnly, "Error"
                End If
                Exit Function
            End If
            
            'Disable readback mode
            SetRdBackMode False
            
            'Now return the CSB line high
            If AutoCSBMode = False Then
                CSB = abvHigh
                USBWritePortBuffVal fx2_PortA
            End If
            
'            'Setup the bitmask for the returned data
''            If SPI_IOMode = spi3Wire Then
''                MaskVal = evbBitVals(bnUSB_SDIO_0)
''            Else
''                MaskVal = evbBitVals(bnUSB_SDIO_2)
''            End If
'
'            MaskVal = 3 'Last two bits
'
'            'Mask out the proper bit Bit0 = SDIO, Bit1 = SDO-ThreeWireMode
'            For i = 0 To lBytes2Rd - 1
'                If ReturnBuff(i) And MaskVal Then
'                    ReturnBuff(i) = 1
'                Else
'                    ReturnBuff(i) = 0
'                End If
'            Next i
'
            'Convert the byte array "ReturnBuff" to a binary string
            'sRetStr = ByteArray2Str(ReturnBuff)
            For i = 0 To lBytes2Rd - 1
                sRetStr = sRetStr & Right(Byte2BinS(ReturnBuff(i)), 2)
            Next i
            
            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sRetStr = FlipBinStr2(sRetStr)
            End If
            
            'Store the value read from the register in the register map
            If IsMissing(NoUpRegMap) Then
                'sSetRegVals 2, RegAddress, sRetStr
                SetRegMapValue 2, RegAddress, sRetStr
            End If
            
            'Return the cleaned up data to the user
            USBSerialRead2Bit = sRetStr
        Else
            'Display an error message
            'The data isn't valid or the address isn't valid
            If mvarVerboseErrors Then
                If RegAddress < 0 Or RegAddress > &H1B Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
'
'                If NumBytes = (Len(Data) / 8) Then
'                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub SerialLoad"
'                End If
            End If
        End If
    End If
End Function
'Do not try to read back more than 8 bytes of data because of a firmware limitation
Private Function USBSerialRead4Bit(ByVal RegAddress As Integer, Optional NoUpRegMap) As String
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim IDataLen As Long
    Dim sDriverName As String
    Dim ReturnBuff() As Byte
    Dim sRetStr As String
    Dim MaskVal As Byte 'Used to mask out either SDO or SDIO from the returned data
    
    Dim lBytes2Rd As Long
    
    Dim sInstructByte As String
                
    'Only work if the object is enabled
    If mvarEnabled = True Then
        'Validate the register address
        If RegAddress >= 0 And RegAddress <= 27 Then
            'Build the instruction byte string
            sInstructByte = BuildInstruct(1, RegAddress)
            'Number of bytes to write instruction byte
            IDataLen = Len(sInstructByte) / 4
            
            'Get the bytes to read
            lBytes2Rd = GetRegLength(RegAddress) / 4
            
            'Setup a buffer to receive data into
            ReDim ReturnBuff(0 To lBytes2Rd - 1) As Byte
            ReDim buffer(0 To IDataLen - 1)
            
            'Set number of bytes to read
            SetRdBackByteCnt lBytes2Rd
            
            'Make sure that SCLK is High
            If SCLK = abvLow Then
                SCLK = abvHigh
                USBWritePortBuffVal fx2_CTLLines
            End If

            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sInstructByte = FlipBinStr4(sInstructByte)
            End If
                
            'Convert to a byte buffer
            For i = 0 To Len(sInstructByte) / 4 - 1 Step 1
                buffer(i) = BinS2Byte(Mid(sInstructByte, (i * 4) + 1, 4))
            Next
            
            If AutoCSBMode = False Then
                'Now take the CSB line Low
                CSB = abvLow
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Write the instruction byte
            result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, IDataLen)
            If result <> 1 Then
                If mvarVerboseErrors Then
                    MsgBox "Error Writing to Board", vbOKOnly, "Error"
                End If
                Exit Function
            End If
            
            '*** Note - This is now done automatically as long as you set the
            'rdBackCount before the sending the instruction byte
            'This line actually reads back the data into the EP8 Fifo and readys
            'it for readback by the PC using the Bulk Transfer below
            'Set the firmware in readback mode
            'SetRdBackMode True
            
            'Readback the register value
            result = clsEZUSBDev01.BulkXfer(ezRead, ReturnBuff, lBytes2Rd)
            If result <> 1 Then
                If mvarVerboseErrors Then
                    MsgBox "Error Reading From Board", vbOKOnly, "Error"
                End If
                Exit Function
            End If
            
            'Disable readback mode
            SetRdBackMode False
            
            'Now return the CSB line high
            If AutoCSBMode = False Then
                CSB = abvHigh
                USBWritePortBuffVal fx2_PortA
            End If
            
'            'Setup the bitmask for the returned data
''            If SPI_IOMode = spi3Wire Then
''                MaskVal = evbBitVals(bnUSB_SDIO_0)
''            Else
''                MaskVal = evbBitVals(bnUSB_SDIO_2)
''            End If
'
'            MaskVal = 3 'Last two bits
'
'            'Mask out the proper bit Bit0 = SDIO, Bit1 = SDO-ThreeWireMode
'            For i = 0 To lBytes2Rd - 1
'                If ReturnBuff(i) And MaskVal Then
'                    ReturnBuff(i) = 1
'                Else
'                    ReturnBuff(i) = 0
'                End If
'            Next i
'
            'Convert the byte array "ReturnBuff" to a binary string
            'sRetStr = ByteArray2Str(ReturnBuff)
            For i = 0 To lBytes2Rd - 1
                sRetStr = sRetStr & Right(Byte2BinS(ReturnBuff(i)), 4)
            Next i
            
            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sRetStr = FlipBinStr4(sRetStr)
            End If
            
            'Store the value read from the register in the register map
            If IsMissing(NoUpRegMap) Then
                'sSetRegVals 2, RegAddress, sRetStr
                SetRegMapValue 2, RegAddress, sRetStr
            End If
            
            'Return the cleaned up data to the user
            USBSerialRead4Bit = sRetStr
        Else
            'Display an error message
            'The data isn't valid or the address isn't valid
            If mvarVerboseErrors Then
                If RegAddress < 0 Or RegAddress > &H1B Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
'
'                If NumBytes = (Len(Data) / 8) Then
'                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub SerialLoad"
'                End If
            End If
        End If
    End If
End Function

'Sets the specified bit value to the specified software buffer
Public Sub USBSetPortBitVal(ByVal IOPort As fx2GPIO, ByVal Bit As evbBits, ByVal value As adiBitValues)
    If value <> 0 Then
        'Set the bit
        fx2PortVals(IOPort) = fx2PortVals(IOPort) Or evbBitVals(Bit)
    Else
        'Clear the bit
        fx2PortVals(IOPort) = fx2PortVals(IOPort) And Not evbBitVals(Bit)
    End If
End Sub
'Sets the software buffer value specifed by RegVal
'To write the value from the software buffer to the hardware buffer call
'WriteEvbBuffVal()
Public Sub USBSetPortBuffVal(ByVal IOPort As fx2GPIO, ByVal BuffVal As Integer)
    'Set the register value
    fx2PortVals(IOPort) = BuffVal
End Sub
'Gets the software buffer value specifed by RegVal
'Returns the current bit value from the specified software buffer
Public Function USBGetPortBitVal(ByVal IOPort As fx2GPIO, ByVal Bit As evbBits) As adiBitValues
    'Test the bit
    If fx2PortVals(IOPort) And evbBitVals(Bit) Then
        'If a one the return 1
        USBGetPortBitVal = 1
    Else
        'If a zero then return 0
        USBGetPortBitVal = 0
    End If
End Function


'Returns the current value of the specified software buffer which should be the
'current hardware buffer value if SetBitVal,SetEvbBuffVal
'are used exclusively
Public Function USBGetPortBuffVal(ByVal IOPort As fx2GPIO) As Integer
    'Return the requested information
    USBGetPortBuffVal = fx2PortVals(IOPort)
End Function

'Writes the value specified by IOPort to the software buffer and the EZ-USB IO Port
'specifed by fx2PortVals.  If IOPortVal is not passed then it writes the value currently
'in the software buffer array "fx2PortVals()".
Public Sub USBWritePortBuffVal(ByVal IOPort As fx2GPIO, Optional IOPortVal As Variant)
    
    If Not IsMissing(IOPortVal) Then
        'Set the register value
        fx2PortVals(IOPort) = IOPortVal
    End If
    
    Select Case IOPort
        Case fx2_PortA:
            'Fire events here
            If OldReset = abvLow And USBGetPortBitVal(fx2_PortA, bnUSB_RESET) = abvHigh Then
                If mEventsEnabled Then RaiseEvent BeforeReset
                'Clear out the registermap
                ResetRegMap 2
            End If
            
            'Write the data to the EZUSB-FX2 PortA
            SetPortAValue fx2PortVals(IOPort)
            
'            If FunctionPin = abvLow And FunctionPinMode = eResetB Then
'                fResetting = True
'            End If
'
'            If fResetting And OldFunctionPinVal = abvLow And FunctionPinMode = eResetB And USBGetPortBitVal(fx2_PortA, evbBit2) = abvHigh Then
'                ResetRegMap 2, True
'                'The reset is over
'                RaiseEvent AfterReset
'                fResetting = False
'            End If
            
'            OldFunctionPinVal = USBGetPortBitVal(fx2_PortA, evbBit2)
            
            If OldReset = abvHigh And USBGetPortBitVal(fx2_PortA, bnUSB_RESET) = abvLow Then
                'Reset the serial IO flags
'                mvarSerialIOMode_DUT1 = evbd56_TwoWire
'                mvarSerialIOMode_DUT2 = evbd56_TwoWire
'                mvarLSBFirst_DUT1 = False
'                mvarLSBFirst_DUT2 = False
                If mEventsEnabled Then RaiseEvent AfterReset
            End If

'            'If the user is issuing an I/O Sync then set CFR2[7] is set to a 0
'            If OldIOSyncDUT1 = abvLow And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT1) = abvHigh Then
'                SetRegMapBitValue sd9956_DUT1, rm9956_NewRegMapVals, RMA9956_CFR2, 7, abvLow
'                SetRegMapBitValue sd9956_DUT1, rm9956_CurRegMapVals, RMA9956_CFR2, 7, abvLow
'            End If
'
'            'If the user is issuing an I/O Sync then set CFR2[7] is set to a 0
'            If OldIOSyncDUT2 = abvLow And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT2) = abvHigh Then
'                SetRegMapBitValue sd9956_DUT2, rm9956_NewRegMapVals, RMA9956_CFR2, 7, abvLow
'                SetRegMapBitValue sd9956_DUT2, rm9956_CurRegMapVals, RMA9956_CFR2, 7, abvLow
'            End If
'
'            'Set the old values
            OldReset = USBGetPortBitVal(fx2_PortA, bnUSB_RESET)
'            OldReset_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT2)
'
'            'Get the value of the IOSync pin for each DUT
'            OldIOSyncDUT1 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT1)
'            OldIOSyncDUT2 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT2)
        Case fx2_PortD:
            'Write the data to the EZUSB-FX2 PortD
            SetPortDValue fx2PortVals(IOPort)
        Case fx2_CTLLines:
            'Write the value to the EZ-USB FX2 Chip
            SetCtlValues fx2PortVals(IOPort)
    End Select
End Sub

'Builds the instruction byte
'bWR = 0-Write, 1-Read
'RegAddr = Valid Register Address
Public Function BuildInstruct(ByVal bWR As Integer, ByVal RegAddr As Integer) As String
        
    'Make sure that bWR is 0 or 1
    If bWR <> 0 Then
        bWR = 1
    Else
        bWR = 0
    End If
    
    BuildInstruct = CStr(bWR) & cbaseDec2Bin(RegAddr, 7)
End Function


'Returns the specified registers length
'retruns 0 if invalid address is passed
Public Function GetRegLength(ByVal RegAddr As Integer) As Integer
    If RegAddr >= 0 And RegAddr <= 27 Then
        GetRegLength = RegLength(RegAddr)
    Else
        GetRegLength = 0
    End If
End Function

'Converts sStr into a byte array
Private Function Str2ByteArray(ByVal sStr As String) As Byte()
    Dim i As Integer
    Dim barray() As Byte

    ReDim barray(0 To Len(sStr) - 1)

    'Convert to a byte buffer
    For i = 0 To Len(sStr) - 1
        barray(i) = CByte(Mid(sStr, i + 1, 1))
    Next

    Str2ByteArray = barray
End Function

'Converts sStr into a byte array
Private Function ByteArray2Str(barray() As Byte) As String
    Dim i As Integer
    Dim sStr As String

    'Convert to a string
    For i = 0 To UBound(barray)
        sStr = sStr & CStr(barray(i))
    Next

    ByteArray2Str = sStr
End Function

'Converts a byte to a binary string
Private Function Byte2BinS(ByVal bVal As Byte) As String
    Dim iCntr As Integer
    Dim bTempVal As Byte
    
    'Use standard decimal to binary conversion
    For iCntr = 0 To 7
        'If the remainder is 1 then store a 1 else store a 0
        If (bVal Mod 2) = 1 Then
            Byte2BinS = "1" & Byte2BinS
        Else
            Byte2BinS = "0" & Byte2BinS
        End If
        'Do the divide and truncate the remainder
        bVal = Fix(bVal / 2)
    Next iCntr
End Function
'Converts a binary string to a byte
Private Function BinS2Byte(ByVal sVal As String) As Byte
    Dim iCntr As Integer
    Dim retval As Byte
    Dim bBitCntr As Byte
    Dim iLenSVal As Integer
    
    iLenSVal = Len(sVal)
    
    For iCntr = iLenSVal To 1 Step -1
        If Mid(sVal, iCntr, 1) = "1" Then
            BinS2Byte = BinS2Byte + 2 ^ bBitCntr
        End If
        
        'Increment the bit cntr
        bBitCntr = bBitCntr + 1
    Next iCntr
End Function

'Flips a binary string 2 bits at a time
Private Function FlipBinStr2(ByVal MyStr As String) As String
    Dim cntr As Integer
    For cntr = Len(MyStr) - 1 To 1 Step -2
        FlipBinStr2 = FlipBinStr2 & Mid(MyStr, cntr, 2)
    Next cntr
End Function
'Flips a binary string 4 bits at a time
Private Function FlipBinStr4(ByVal MyStr As String) As String
    Dim cntr As Integer
    For cntr = Len(MyStr) - 3 To 1 Step -4
        FlipBinStr4 = FlipBinStr4 & Mid(MyStr, cntr, 4)
    Next cntr
End Function

'Reads from Register 19H which contains the Product ID Code
Public Function GetProductType() As String
    Dim sChipID As String 'Variable to store the Product ID
    
    sChipID = EvBd.USBSerialRead(&H19, 1) 'Read the Product ID Register
    sChipID = Left(sChipID, 5) 'Trim the data down to the Product ID
    Select Case sChipID
        Case "11010":  'AD9959E - Evaluation Product
            sChipID = "AD9959E"
            mvarDUTType = sChipID
        Case "11011":  'AD9959
            sChipID = "AD9959"
            mvarDUTType = sChipID
        Case "10011":  'AD9958 - Channel 0 and 3, Channel 0 and 1 New Silicon
            sChipID = "AD9958 CH01"
            mvarDUTType = sChipID
        Case "11001":  'AD9958 - Channel 1 and 2, Channel 2 and 3 New Silicon
            sChipID = "AD9958 CH23"
            mvarDUTType = sChipID
        Case "01011":  'Spur reduction capable Concept Product
            sChipID = "AD9911"
            mvarDUTType = sChipID
        Case Else
            sChipID = "None"
            mvarDUTType = "None"
    End Select
    'Return the ChipID
    GetProductType = sChipID
End Function
'Do not try to read back more than 8 bytes of data because of a firmware limitation
Public Function USBSerialRead4BitDaveB(ByVal RegAddress As Integer, Optional NoUpRegMap) As String
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim IDataLen As Long
    Dim sDriverName As String
    Dim ReturnBuff() As Byte
    Dim sRetStr As String
    Dim MaskVal As Byte 'Used to mask out either SDO or SDIO from the returned data
    
    Dim lBytes2Rd As Long
    
    Dim sInstructByte As String
                
    'Only work if the object is enabled
    If mvarEnabled = True Then
        'Validate the register address
        If RegAddress >= 0 And RegAddress <= 27 Then
            'Build the instruction byte string
            sInstructByte = BuildInstruct(1, RegAddress)
            'Number of bytes to write instruction byte
            IDataLen = Len(sInstructByte) / 4
            
            'Get the bytes to read
            lBytes2Rd = GetRegLength(RegAddress) / 4
            
            'Setup a buffer to receive data into
            ReDim ReturnBuff(0 To lBytes2Rd - 1) As Byte
            ReDim buffer(0 To IDataLen - 1)
            
            'Set number of bytes to read
            'SetRdBackByteCnt lBytes2Rd
            
            'Make sure that SCLK is High
            If SCLK = abvLow Then
                SCLK = abvHigh
                USBWritePortBuffVal fx2_CTLLines
            End If

            'Check to see if the part is currently in LSB First Mode
            If SPI_LSB_First Then
                'Rearrange the instruction byte into LSB First format
                sInstructByte = FlipBinStr4(sInstructByte)
            End If
                
            'Convert to a byte buffer
            For i = 0 To Len(sInstructByte) / 4 - 1 Step 1
                buffer(i) = BinS2Byte(Mid(sInstructByte, (i * 4) + 1, 4))
            Next
            
            If AutoCSBMode = False Then
                'Now take the CSB line Low
                CSB = abvLow
                USBWritePortBuffVal fx2_PortA
            End If
            
            'Write the instruction byte
            result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, IDataLen)
            If result <> 1 Then
                If mvarVerboseErrors Then
                    MsgBox "Error Writing to Board", vbOKOnly, "Error"
                End If
                Exit Function
            End If
            
            '*** Note - This is now done automatically as long as you set the
            'rdBackCount before the sending the instruction byte
            'This line actually reads back the data into the EP8 Fifo and readys
            'it for readback by the PC using the Bulk Transfer below
            'Set the firmware in readback mode
            'SetRdBackMode True
            
            'Readback the register value
'            result = clsEZUSBDev01.BulkXfer(ezRead, ReturnBuff, lBytes2Rd)
'            If result <> 1 Then
'                If mvarVerboseErrors Then
'                    MsgBox "Error Reading From Board", vbOKOnly, "Error"
'                End If
'                Exit Function
'            End If
'
'            'Disable readback mode
'            SetRdBackMode False
'
'            'Now return the CSB line high
'            If AutoCSBMode = False Then
'                CSB = abvHigh
'                USBWritePortBuffVal fx2_PortA
'            End If
'
''            'Setup the bitmask for the returned data
'''            If SPI_IOMode = spi3Wire Then
'''                MaskVal = evbBitVals(bnUSB_SDIO_0)
'''            Else
'''                MaskVal = evbBitVals(bnUSB_SDIO_2)
'''            End If
''
''            MaskVal = 3 'Last two bits
''
''            'Mask out the proper bit Bit0 = SDIO, Bit1 = SDO-ThreeWireMode
''            For i = 0 To lBytes2Rd - 1
''                If ReturnBuff(i) And MaskVal Then
''                    ReturnBuff(i) = 1
''                Else
''                    ReturnBuff(i) = 0
''                End If
''            Next i
''
'            'Convert the byte array "ReturnBuff" to a binary string
'            'sRetStr = ByteArray2Str(ReturnBuff)
'            For i = 0 To lBytes2Rd - 1
'                sRetStr = sRetStr & Right(Byte2BinS(ReturnBuff(i)), 4)
'            Next i
'
'            'Check to see if the part is currently in LSB First Mode
'            If SPI_LSB_First Then
'                'Rearrange the instruction byte into LSB First format
'                sRetStr = FlipBinStr4(sRetStr)
'            End If
'
'            'Store the value read from the register in the register map
'            If IsMissing(NoUpRegMap) Then
'                'sSetRegVals 2, RegAddress, sRetStr
'                SetRegMapValue 2, RegAddress, sRetStr
'            End If
'
'            'Return the cleaned up data to the user
'            USBSerialRead4Bit = sRetStr
'        Else
'            'Display an error message
'            'The data isn't valid or the address isn't valid
'            If mvarVerboseErrors Then
'                If RegAddress < 0 Or RegAddress > &H1B Then
'                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub SerialLoad"
'                End If
''
''                If NumBytes = (Len(Data) / 8) Then
''                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub SerialLoad"
''                End If
'            End If
        End If
    End If
End Function

