Attribute VB_Name = "USBCom"
'Private USBDriverList(0 To MAX_USB_DEV_NUMBER - 1) As String
Public USBDrvName As String
Private sRegSize(0 To 12) As Integer

'Sends data to EndPoint
'Public Sub SendSomeData()
'
'    Dim buffer(63) As Byte
'    Dim result As Long
'    Dim i As Integer
'    Dim lDataLen As Long
'    Dim sDriverName As String
'    Dim Checker As String
'
'    For i = 0 To 63 Step 4
'        buffer(i) = &H1
'        buffer(i + 1) = &H0
'        buffer(i + 2) = &H2
'        buffer(i + 3) = &H0
'    Next
'
'    sDriverName = USBDrvName
'
'    lDataLen = 64
'
'    result = DoBulkXfer(sDriverName, eWrite, buffer, lDataLen)
'
'    If result <> 1 Then: MsgBox "Error Writing to Board", vbOKOnly, "Error": Exit Sub
'
'    lDataLen = 64
'
'    result = DoBulkXfer(sDriverName, eRead, buffer, lDataLen)
'
'    If result <> 1 Then: MsgBox "Error Reading from Board", vbOKOnly, "Error": Exit Sub
'
'End Sub
Public Function GetFirmWareVersion() As String
    'This routine returns 2 bytes.  The first contains version Major
    'the second contains version minor.
    'Example = VerMajor.VerMinor = 1.9
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    Driver = clsEZUSBDevice.DriverName
    buf(0) = &H0
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1) 'DoBulkXfer(Driver, 0, buf, 1)
    
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 2) 'DoBulkXfer(Driver, 1, Data, 2)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If

    'Return the firmware version
    GetFirmWareVersion = CStr(Data(0)) & "." & CStr(Data(1))
End Function
Public Function SetPortAValue(ByVal Value As Byte) As Boolean
    'This routine returns 2 bytes.  The first contains version Major
    'the second contains version minor.
    'Example = VerMajor.VerMinor = 1.9
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H1 'Comand value for Writing PortA Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 2)
    'result = DoBulkXfer(Driver, 0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
'    result = DoBulkXfer(Driver, 1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortAValue = True
    Else
        SetPortAValue = False
    End If
End Function
Public Function GetPortAValue() As Byte
    'This routine returns the value of PortA
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H2
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If

    'Return the firmware version
    GetPortAValue = Data(0)
End Function

'Gets the Driver Name
'Compiles a list of available EZ-USB devices and allows you to get the name
'of one from the list
'Public Function GetDriverName(ByVal Indx As Integer) As String
'    Dim Index As Integer
'    Dim sDriverName As String
'    Dim hDriver As Long
'    Dim I2 As Integer
'
'    'Initialize I2
'    I2 = 0
'
'    For Index = 0 To MAX_USB_DEV_NUMBER - 1
'        sDriverName = "Ezusb-" & Index
'        hDriver = OpenDriver(sDriverName)
'        If hDriver > 0 Then
'            'Add the driver name to the list
'            USBDriverList(I2) = sDriverName
'            'Increment I2
'            I2 = I2 + 1
'            'Close the driver
'            CloseHandle hDriver
'        End If
'    Next
'
'    If I2 < 1 Then
'        'Return a message that says no EZUSB Devices Found
'        GetDriverName = "No EZUSB Devices Available"
'    Else
'        If Indx > I2 - 1 Then
'            'The user specified an invalid driver
'            GetDriverName = "Invalid Driver Specified"
'        Else
'            'Return the driver name requested
'            GetDriverName = USBDriverList(Indx)
'        End If
'    End If
'
'End Function

Public Function GetCtlValues()
    'This routine returns 1 byte.  Which represents the current
    'state of the GPIF Ctl lines
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H6
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading from device."
        Exit Function
    End If

    'Return the firmware version
    GetCtlValues = Data(0)
End Function


Public Function SetCtlValues(ByVal Value As Byte) As Boolean
    'This routine sets the value of the control lines
    'Value = Value to be set to the GPIFIDLECTL register on the Easy USB FX2 chip.
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H5 'Comand value for Writing CTL Values
    buf(1) = Value
       
    'send 2 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error writting device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error writting device."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetCtlValues = True
    Else
        SetCtlValues = False
    End If

End Function


Public Sub SetRdBackByteCnt(ByVal Value As Integer)
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H7 'Command value for setting single read byte count mode.
    buf(1) = MSB(Value)
    buf(2) = LSB(Value)
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 3)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Sub
    End If

End Sub
Public Sub SetRdBackMode(ByVal Value As Boolean)
    'This subroutine sets the readback mode of the firmware
    'Value = true  - Single byte read mode enabled
    'Value = false - Single byte read mode disabled
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H4 'Command value for setting single read byte count mode.
    If Value = True Then
        buf(1) = 1
    Else
        buf(1) = 0
    End If
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting single readback mode."
        Exit Sub
    End If
End Sub
Public Function SetPortBValue(ByVal Value As Byte) As Boolean
    'This routine returns 2 bytes.  The first contains version Major
    'the second contains version minor.
    'Example = VerMajor.VerMinor = 1.9
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HA  'Comand value for Writing PortA Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 2)
    'result = DoBulkXfer(Driver, 0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
'    result = DoBulkXfer(Driver, 1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortBValue = True
    Else
        SetPortBValue = False
    End If
End Function
Public Function GetPortBValue() As Byte
    'This routine returns the value of PortA
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H9
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If

    'Return the firmware version
    GetPortBValue = Data(0)
End Function
Public Sub ResetFirmware()
    'Resets the firmware and the evaluation board

    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H8 'Command value to reset the firmware and evaluation board.
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Sub
    End If
End Sub

Public Sub SendUSBData(ByVal Address As Integer, ByVal Data As String)
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim lDataLen As Long
    Dim sDriverName As String
    Dim Checker As String
    Dim SData As String
    
    Dim InstrByte As String
    
    ReDim buffer(0 To Len(Data) + 7) As Byte
    
    'Build the instruction byte string
    InstrByte = "000" & cbaseDec2Bin(Address, 5)
    
    'Build the serial stream
    SData = InstrByte & Data
    
    'Convert to a byte buffer
    For i = 0 To Len(SData) - 1
        buffer(i) = CByte(Mid(SData, i + 1, 1))
    Next
    
    'sDriverName = USBDrvName
    
    lDataLen = Len(SData)
    
    'Set CSB low
    SetPortAValue Not (BitLoc(6)) And PortAVal
    
    result = clsEZUSBDevice.BulkXfer(eWrite, buffer, lDataLen)
    
    'Set CSB High
    SetPortAValue BitLoc(6) Or PortAVal
    
    'Send a FUD
    SetPortDValue BitLoc(3) Or PortDVal
    SetPortDValue Not (BitLoc(3)) And PortDVal
    
    If result <> 1 Then: MsgBox "Error Writing to Board", vbOKOnly, "Error": Exit Sub
    
    lDataLen = Len(SData)

'    result = DoBulkXfer(sDriverName, eRead, buffer, lDataLen)
'
'    If result <> 1 Then: MsgBox "Error Reading from Board", vbOKOnly, "Error": Exit Sub
End Sub


Public Function USBSerialRead(ByVal Address As Integer) As String
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim IDataLen As Long
    Dim RDataLen As Long
    Dim sDriverName As String
    Dim ReturnBuff() As Byte
    
    Dim InstrByte As String
    
    'Build the instruction byte string
    InstrByte = "100" & cbaseDec2Bin(Address, 5)
    
    buffer() = Str2ByteArray(InstrByte)
        
    'sDriverName = USBDrvName
    
    IDataLen = Len(InstrByte)        'Number of bytes to write
    RDataLen = sRegSize(Address) * 8 'Number of bytes to readback
    
    ReDim ReturnBuff(0 To RDataLen - 1) As Byte
    
    'Set number of bytes to read
    SetRdBackByteCnt RDataLen
    
    'Set CSB low
    SetPortAValue Not (BitLoc(6)) And PortAVal
    
    'Write the instruction byte
    result = clsEZUSBDevice.BulkXfer(eWrite, buffer, IDataLen)
    If result <> 1 Then
        MsgBox "Error Writing to Board", vbOKOnly, "Error"
        Exit Function
    End If
    
    'This line actually reads back the data into the EP8 Fifo and readys
    'it for readback by the PC using the Bulk Transfer below
    'Set the firmware in readback mode
    SetRdBackMode True
    
    'Readback the register value
    result = clsEZUSBDevice.BulkXfer(eRead, ReturnBuff, RDataLen)
    If result <> 1 Then
        MsgBox "Error Reading From Board", vbOKOnly, "Error"
        Exit Function
    End If
    
    'Set CSB High
    SetPortAValue BitLoc(6) Or PortAVal
    
    'Disable readback mode
    SetRdBackMode False
    
    'Mask out the LSB which is where the Data Resides in TwoWireMode
    For i = 0 To RDataLen - 1
        ReturnBuff(i) = ReturnBuff(i) And CByte(&H1)
    Next i
    
    'Convert the byte array "ReturnBuff" to a binary string
    USBSerialRead = ByteArray2Str(ReturnBuff)
End Function


'Converts sStr into a byte array
Public Function Str2ByteArray(ByVal sStr As String) As Byte()
    Dim i As Integer
    Dim barray() As Byte

    ReDim barray(0 To Len(sStr) - 1)

    'Convert to a byte buffer
    For i = 0 To Len(sStr) - 1
        barray(i) = CByte(Mid(sStr, i + 1, 1))
    Next

    Str2ByteArray = barray
End Function
'Converts sStr into a byte array
Public Function ByteArray2Str(barray() As Byte) As String
    Dim i As Integer
    Dim sStr As String

    'Convert to a string
    For i = 0 To UBound(barray)
        sStr = sStr & CStr(barray(i))
    Next

    ByteArray2Str = sStr
End Function


Public Sub InitUSB()
    'Initialize the serial mode register size lookup table,
    'sizes are in number of bytes
    sRegSize(0) = 4
    sRegSize(1) = 3
    sRegSize(2) = 2
    sRegSize(3) = 1
    sRegSize(4) = 4
    sRegSize(5) = 2
    sRegSize(6) = 4
    sRegSize(7) = 5
    sRegSize(8) = 5
    sRegSize(9) = 5
    sRegSize(10) = 5
    sRegSize(11) = 4
    sRegSize(12) = 4
End Sub

Private Function MSB(ByVal iVal As Integer) As Byte
    MSB = CByte(Fix(iVal / 256))
End Function

Private Function LSB(ByVal iVal As Integer) As Byte
    LSB = CByte(Fix(iVal And &HFF))
End Function

Public Function SetPortDValue(ByVal Value As Byte) As Boolean
    'This routine sets the value of port D to the value of "Value"
    'Input - Value: the value to be applied to the port d pins
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HC  'Comand value for Writing PortD Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 2)
    'result = DoBulkXfer(Driver, 0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting PortD value."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
'    result = DoBulkXfer(Driver, 1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortD value."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortDValue = True
    Else
        SetPortDValue = False
    End If
End Function

Public Function GetPortDValue() As Byte
    'This routine returns the value of PortA
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &HB
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDevice.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error Checking FIFO Status Flags."
        Exit Function
    End If

    'Return PortD's value
    GetPortDValue = Data(0)
End Function

