Attribute VB_Name = "modSound"
'*******************************************************
'* Sound Module                                        *
'*******************************************************
'* Purpose:                                            *
'* Allows the user to play wave files.                 *
'*                                                     *
'* Functions:                                          *
'* sndSoundCardInstalled - Returns true or false       *
'* sndWAVLoop - Loops a wave file seamlessly until     *
'*               sndWaveStop is called.                *
'* sndWAVPlay - Plays a wave file                      *
'* sndWAVStop - Stops playing a wave file              *
'*******************************************************
'* Revision 1.0                                        *
'*******************************************************

Private Declare Function mciExecute Lib "winmm.dll" (ByVal lpstrCommand As String) As Long

Public Const SND_SYNC = &H0

Public Const SND_ASYNC = &H1
Public Const SND_NODEFAULT = &H2
Public Const SND_MEMORY = &H4
Public Const SND_LOOP = &H8
Public Const SND_NOSTOP = &H10

Public Declare Function sndPlaySound Lib "winmm.dll" Alias "sndPlaySoundA" (ByVal lpszSoundName As String, ByVal uFlags As Long) As Long

Public Declare Function waveOutGetNumDevs Lib "winmm.dll" () As Long

Sub sndWAVStop()

    Call sndWAVPlay(" ")
End Sub


Sub sndWAVLoop(file)

    Dim SoundName As String
    SoundName$ = file
    wFlags% = SND_ASYNC Or SND_LOOP
    x = sndPlaySound(SoundName$, wFlags%)
End Sub


Sub sndWAVPlay(file)

    Dim SoundName As String
    SoundName$ = file
    wFlags% = SND_ASYNC Or SND_NODEFAULT
    x = sndPlaySound(SoundName$, wFlags%)
End Sub

Public Function sndSoundCardInstalled() As Boolean

    Dim lng As Long
    lng = waveOutGetNumDevs()
     

    If lng > 0 Then
        sndSoundCardInstalled = True
        Exit Function
    Else
        sndSoundCardInstalled = False
        Exit Function
    End If

End Function

'Public Sub sndPlayAudioFile(ByVal Filename As String)
'    Dim a As String
'    a = "play " & Filename
'    mciExecute a
'End Sub
'
'Public Sub sndStopAudioFile(ByVal Filename As String)
'    Dim a As String
'    a = "stop " & Filename
'    mciExecute a
'End Sub
'
'Public Sub sndPauseAudioFile(ByVal Filename As String)
'    Dim a As String
'    a = "pause " & Filename
'    mciExecute a
'End Sub

