Attribute VB_Name = "modMain"
'Define public constants for the tuning word sizes
Public Const OFTWBits = 48 'Output frequency tuning word
Public Const DFTWBits = 24 'Delta Frequency Tuning Word

Public Const FlashColorOn = &HFF00&
Public Const FlashColorOff = &H8000000F

'Colors for the usb status label
Public Const StatForeColorOk = &HFFFFFF
Public Const StatBackColorOk = &H8000&
Public Const StatForeColorNoOk = &HFFFF&
Public Const StatBackColorNoOk = &HFF&

Public EvBd As clsAD9956EvBd
Public AppTitle As String
Public sDecSep As String
Public iDecSep As Integer
Public sNegSign As String
Public iNegSign As Integer

Public clsEZUSBDev01 As clsEZUSB

'Just trash variables for use in the imediate pane
Public lTrash As Long
Public iTrash As Integer
Public sTrash As String
Public dTrash As Double

'Global flags that indicate if the corresponding DUT was deteced
Public Dut1Detected As Boolean
Public Dut2Detected As Boolean

Public CmdLine As String
Public SoundCardInstalled As Boolean

Public Sub Main()
    Dim LPTBaseAddr As Integer
    Dim iUSBDevCntr As Integer
    Dim lUSBDevHostId As Long
    Dim bFreeDev As Boolean 'Used to indicate if a free device was found for use
    
    'Use WindowsXP Styles
    'EnableXPThemes
    
    'Get and store the command line arguments passed to the prog
    CmdLine = Command$
    
    'Determine if a sound card is installed
    SoundCardInstalled = sndSoundCardInstalled()
    
    'Initialize the EZUSB Class
    Set clsEZUSBDev01 = New clsEZUSB
    clsEZUSBDev01.VendorID = &H456   'ADI's VendorID    Cypress Semiconductor &H547
    clsEZUSBDev01.ProductID = &HEE01 'AD9956 Evaluation Board    Cypress Sample Device &H1002
    
    If InStr(1, CmdLine, "EZUSBMODE") <> 0 Then
        'Use the EZUSB Driver
        clsEZUSBDev01.UseEZUSBDriver
        clsEZUSBDev01.USBDriverInstalled
        CmdLine = Replace(CmdLine, "EZUSBMODE", "")
        CmdLine = Replace(CmdLine, " ", "")
    End If
    
    'Setup the internationalization class
    Dim LocaleInfo As adiLocaleInfo
    Set LocaleInfo = New adiLocaleInfo

    'Get Locale Infomation
    sDecSep = LocaleInfo.GetLocaleInfo(adiDecimalSep)
    iDecSep = Asc(sDecSep)
    sNegSign = LocaleInfo.GetLocaleInfo(adiNegativeSign)
    iNegSign = Asc(sDecSep)
    Set LocaleInfo = Nothing
    
    'Show the splash screen
    frmSplash.Show
    frmSplash.Refresh
    'Start updating the status window
    frmSplash.AddStatLine "AD9956 Evaluation Software Rev. " & CStr(App.Major) & "." & CStr(App.Minor) & CStr(App.Revision)

    'Set up the title
    AppTitle = "AD9956 Evaluation Software" & " Rev. " & App.Major & "." & App.Minor & "." & App.Revision
    mdiMain.Caption = AppTitle
    'Show the main form
    mdiMain.Show
    
    'Set global reference to the evalbd class
    Set EvBd = mdiMain.AD9956BD
    
'    If LPTBaseAddr > 0 Then
'        frmSplash.AddStatLine "Found " & frmLPTSelect.LPTGetPortCount & " LPT port(s),"
'        frmSplash.AddStatLine "using LPT1 at address: " & Hex(LPTBaseAddr) & " Hex..."
'    Else
'        frmSplash.txtStatus.ForeColor = &HFF
'        frmSplash.AddStatLine "Error:  Couldn't find any LPT Ports!"
'    End If

    'Enable serial transfers
    EvBd.Enabled = True
    'Initialize the evalboard
'    EvBd.InitEvalBd
    'Finding the evalboard
    frmSplash.AddStatLine "Finding Eval Board..."
    frmSplash.AddStatLine "Checking for presence of USB Driver..."
    
    If clsEZUSBDev01.USBDriverIsInstalled Then
        frmSplash.AddStatLine "USB Driver appears to be installed..."
        frmSplash.AddStatLine "Checking the USB Bus..."
        
        If EvBd.USBFindEvalBD() >= 1 Then
            frmSplash.AddStatLine "Found " & CStr(clsEZUSBDev01.DeviceCount) & " Eval Boards on USB Bus"
            'If a Valid USB device was found then select USB
            EvBd.PCInterface = 0

            'Search the USB Devices to find a free Device
            If clsEZUSBDev01.DeviceCount > 1 Then
                For iUSBDevCntr = 0 To clsEZUSBDev01.DeviceCount - 1
                    Call clsEZUSBDev01.GetHostID(iUSBDevCntr, lUSBDevHostId)
                    If lUSBDevHostId = 0 Then
                        Call clsEZUSBDev01.SelectDevice(iUSBDevCntr, mdiMain.hWnd, True)
                        bFreeDev = True 'Indicate that a free device was found
                        Exit For
                    End If
                Next iUSBDevCntr
                
                'If a free device wasn't found then display the selection menu
                If bFreeDev = False Then
                    If frmUSBSelect.ShowDialog("Select USB Device", "Select an evalution board.") = "" Then
                        'If the user doesn't select a device then exit
                        ExitGracefully
                    End If
                End If
            Else
                Call clsEZUSBDev01.SelectDevice(0, mdiMain.hWnd, True)
            End If
            
            'Update the status bar
            mdiMain.pbxStatus.Visible = True
            mdiMain.lblPCIOStatusDisplay.Visible = True
            mdiMain.lblPCIOStatus.Visible = True
            mdiMain.lblPCIOStatusDisplay.Caption = " Connected "
            mdiMain.lblPCIOStatusDisplay.ForeColor = StatForeColorOk
            mdiMain.lblPCIOStatusDisplay.BackColor = StatBackColorOk
            mdiMain.lblPCIOStatusDisplay.Refresh
            
            'Notify the device being used
            frmSplash.AddStatLine "Using " & CStr(clsEZUSBDev01.DriverName) & "..."
            
            'Change the menu that brings up the USB Dialog
            mdiMain.mnuPCIOSelectLPTPort.Caption = "Select Eval Board..."
            
        Else
            frmSplash.AddStatLine "No Eval Boards Found on USB Bus..."
        End If
    End If
    
    If DriverXInstalled() Then  'Test to make sure that DriverX is installed
        If EvBd.PCInterface <> 0 Then
            'Manualy force into Parallel Port Mode
            EvBd.PCInterface = 1
            'Detect the LPT ports
            LPTBaseAddr = frmLPTSelect.LPTSelectDialog("Select an LPT Port", "Select the LPT Port that the Evaluation Board is connected to.", False, 1)
            If EvBd.PPFindEvalBD Then
                frmSplash.AddStatLine "Found Eval Board on LPT" & frmLPTSelect.lstLPTPorts.ListIndex + 1 & "..."
            
                'Update the status bar
'                mdiMain.lblPCIOStatusDisplay.Caption = " Connected "
'                mdiMain.lblPCIOStatus.Caption = "Eval Board:"
            Else
                frmSplash.AddStatLine "Eval Board was not found using parallel port..."
                EvBd.PCInterface = -1
            End If
        End If
    End If
    
    'No Evalboard was found attached to the system
    If EvBd.PCInterface = -1 Then
        frmSplash.AddStatLine ""
        frmSplash.txtStatus.ForeColor = &HFF
        frmSplash.AddStatLine "No AD9956 Evaluation Board found..."
        frmSplash.AddStatLine ""
    Else
        'Update the status window
        frmSplash.AddStatLine "Initializing the Evaluation Board..."
        'Re initialize the eval board
        EvBd.InitEvalBd
    End If

'    frmSplash.AddStatLine "Loading Debug Window..."
'    Load frmDebug  '.Show
'
    frmSplash.AddStatLine "Loading Control Window..."
    frmControl.Show
    
    frmSplash.AddStatLine "Loading Profile Window..."
    frmProfiles.Show
    
    frmSplash.AddStatLine "Loading Charge Pump \ Clock Drv Window..."
    Load frmCP_ClkDrv_Ctrl
    
    frmSplash.AddStatLine "I/O Interface Toolbox Window..."
    Load frmIOInterface
    
    frmSplash.AddStatLine "Loading Linear Sweep Setup Window..."
    Load frmLinSweepSetup
    
    frmSplash.AddStatLine "Loading DUT Signals Toolbox Window..."
    'Check the menu item
    mdiMain.mnuViewDUTSignals.Checked = True
    frmControl.IsUpdating = True
    frmControl.chkDutSignals.Value = 1
    frmControl.IsUpdating = False
    frmDUTSignals.Move mdiMain.Left + mdiMain.Width - frmDUTSignals.Width - 90, 1170
    frmDUTSignals.Show
    
    'Load the DDE Server form
    Load frmDDEServ
    
    If EvBd.PCInterface <> -1 Then
        frmSplash.AddStatLine ""
        'Update the status window
        frmSplash.AddStatLine "Resetting the Evaluation Board &"
        'Update the status window
        frmSplash.AddStatLine "Detecting DUTs..."
        'Reset the DUTs
        EvBd.DetectDUTs Dut1Detected, Dut2Detected
        If Dut1Detected Then
            'Update the status window
            frmSplash.AddStatLine "Master DUT detected..."
            mdiMain.lblDUTStatus(0).BackColor = StatBackColorOk
            mdiMain.lblDUTStatus(0).ForeColor = StatForeColorOk
        Else
            'Update the status window
            frmSplash.AddStatLine "Master DUT not detected..."
            mdiMain.lblDUTStatus(0).BackColor = vb3DFace
            mdiMain.lblDUTStatus(0).ForeColor = vb3DShadow
        End If
    
        If Dut2Detected Then
            'Update the status window
            frmSplash.AddStatLine "Slave DUT detected..."
            mdiMain.lblDUTStatus(1).BackColor = StatBackColorOk
            mdiMain.lblDUTStatus(1).ForeColor = StatForeColorOk
        Else
            'Update the status window
            frmSplash.AddStatLine "Slave DUT not detected..."

            'Indicate that no Slave was detected
            frmControl.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmControl.tspDUTSel.Enabled = False
            frmControl.chkLoadDUT2.Enabled = False
            frmCP_ClkDrv_Ctrl.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmCP_ClkDrv_Ctrl.tspDUTSel.Enabled = False
            frmCP_ClkDrv_Ctrl.chkLoadDUT2.Enabled = False
            frmProfiles.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmProfiles.tspDUTSel.Enabled = False
            frmProfiles.chkLoadDUT2.Enabled = False
            frmLinSweepSetup.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmLinSweepSetup.tspDUTSel.Enabled = False
            frmLinSweepSetup.chkLoadDUT2.Enabled = False
            mdiMain.lblDUTStatus(1).BackColor = vb3DFace
            mdiMain.lblDUTStatus(1).ForeColor = vb3DShadow
        End If
    
        If Dut2Detected = False And Dut1Detected = False Then
            frmSplash.AddStatLine ""
            frmSplash.txtStatus.ForeColor = &HFF
            frmSplash.AddStatLine "DUT Missing!!!"
            frmSplash.AddStatLine ""
        End If
    End If
    
    If EvBd.PCInterface = 0 Then
        'Enable USB Device Polling
        mdiMain.tmrPollEvalBd.Enabled = True
        'Logit on the splash screen
        frmSplash.AddStatLine "Enabling USB Evalbd Polling..."
    End If
    
    frmSplash.AddStatLine ""
    'Software up and running
    frmSplash.AddStatLine "Software is up and running!!!"

    'Bring the control window to the front
    frmControl.ZOrder

    'Process events 1/2 second and let everything settle down.
    Delay 0.5
    
    'Enable the auto unload feature of the splash screen
    If IsLoaded("frmSplash") Then
        frmSplash.Visible = True
        frmSplash.SetFocus
        frmSplash.AutoUnloadEnable
    End If

    'Set the mode
    SetDebugMode CmdLine
    
End Sub

Public Sub ExitGracefully()
    Dim cntr As Integer
        
    'Release the hook on the main window
'    FreeWindow mdiMain.hWnd
    
    'Unload frmLPTSelect first
    Unload frmLPTSelect
    
    'Unload each form
    For cntr = (Forms.Count - 1) To 0 Step -1
        If Forms(cntr).Name <> "mdiMain" And Forms(cntr).Name <> "frmDDEServ" Then
            Unload Forms(cntr)
        End If
    Next cntr
    
    'Clean up the eval board class
    Set EvBd = Nothing
    Set mdiMain.AD9956BD = Nothing
    Set clsEZUSBDev01 = Nothing

    'Unload the DDEServer Window
    Unload frmDDEServ
    
    'Unload the main form
    Unload mdiMain
    
    End
End Sub

'This function tries to determine if DriverX is installed
'Returns
'True if driverx.vxd or driverx.sys exists in the drivers directory
'False if driverx.vxd or driverx.sys exists in the drivers directory
Public Function DriverXInstalled() As Boolean
    Dim sDriverName As String
    
    'Build the driver path
    If IsWinNT() = False Then
        sDriverName = GetWindowsDir() & "\System\Driverx.vxd"
    Else
        sDriverName = GetWindowsDir() & "\System32\Drivers\Driverx.sys"
    End If
    
    'Return true or false
    DriverXInstalled = FileExists(sDriverName)
End Function


'Saves the current setup to a file
'Inputs
'FilePath - Full path to the file to save the current settings to.
'DumpRegs - If true then it reads and saves the actual register data from the DUT
'           If false then it saves the current software buffer values for the registers
Public Sub SaveSetup(ByVal FilePath As String, Optional DumpRegs)
    Dim FileHandle As Integer 'Handle to the file opened
    Dim cntr As Integer
    Dim DutCntr As Integer
    Dim RegNames(0 To 14) As String
    Dim EndCnt As Integer
    Dim bDumpRegs As Boolean
    
    'Initialize the register names
    RegNames(0) = "CFR1"
    RegNames(1) = "CFR2"
    RegNames(2) = "RDFTW"
    RegNames(3) = "FDFTW"
    RegNames(4) = "RSRR"
    RegNames(5) = "FSRR"
    RegNames(6) = "PCR0"
    RegNames(7) = "PCR1"
    RegNames(8) = "PCR2"
    RegNames(9) = "PCR3"
    RegNames(10) = "PCR4"
    RegNames(11) = "PCR5"
    RegNames(12) = "PCR6"
    RegNames(13) = "PCR7"
    RegNames(14) = "TR"
    
    'Setup the dump registers flag from user input
    If IsMissing(DumpRegs) Then
        bDumpRegs = False
    Else
        bDumpRegs = True
    End If
    
    'Setup an errorhandler
    On Error GoTo FileError
    
    'Show the RAM Loading Status Window
'    frmRAMLoadStatus.lblMsg.Caption = "Saving DUT Settings"
'    frmRAMLoadStatus.Show
'    MakeTopMost frmRAMLoadStatus, True
'    frmRAMLoadStatus.Refresh
    
    'Setup the status bar
'    With frmRAMLoadStatus
'        .pbrProgress.Min = 1
'        .pbrProgress.Max = 11
'        .pbrProgress.Value = .pbrProgress.Min
'        .Refresh
'    End With
    
    'Get a file handle
    FileHandle = FreeFile(1)
    
    'Open the file
    Open FilePath For Output As #FileHandle
    
    'Write the Header
    Write #FileHandle, "AD9956 Eval Software Settings File", 1#
    Write #FileHandle, ""
    
    'If the slave board isn't installed then only save the master
    If EvBd.Dut2Detected = True Then
        EndCnt = 1
    Else
        EndCnt = 0
    End If
    
    For DutCntr = 0 To EndCnt
        Write #FileHandle, "DUT" & DutCntr + 1 & " Settings"
        
        'Store any non register related info
        With frmControl
            'Store the external frequency
            Write #FileHandle, "External Frequency", .txtRefClk(DutCntr).Text
            If DutCntr = 1 Then
                Write #FileHandle, "Use DUT1's RefClk", .chkUseDUT1RefClk.Value
            End If
            'Store the Currently selected profile
            Write #FileHandle, "Profile DUT", EvBd.GetActiveProfile(DutCntr + 1)
            If DutCntr = 0 Then
                Write #FileHandle, "AutoIOUpdateDut1", EvBd.AutoIOUpdate_DUT1
            Else
                Write #FileHandle, "AutoIOUpdateDut2", EvBd.AutoIOUpdate_DUT2
            End If
        End With
        
        'Store the register map
        Write #FileHandle, "Register Map for DUT" & DutCntr
        For cntr = 0 To UBound(RegNames)
            'Only write the test register value if in ADIFULLENGMODE
            If (UCase(CmdLine) = "-ADIFULLENGMODE" Or UCase(CmdLine) = "ADIFULLENGMODE") Or cntr < UBound(RegNames) Then
                If bDumpRegs Then
                    Write #FileHandle, RegNames(cntr), EvBd.SerialRead(DutCntr + 1, cntr)
                Else
                    Write #FileHandle, RegNames(cntr), EvBd.GetRegMapValue(DutCntr + 1, rm9956_CurRegMapVals, cntr) 'EvBd.SerialRead(DutCntr + 1, cntr)
                End If
            End If
            'Update the status window
            'frmRAMLoadStatus.pbrProgress.Value = cntr + 1
        Next cntr
    Next DutCntr
    
    'If the slave board isn't installed then only save the master
    If EvBd.Dut2Detected = False Then
        Write #FileHandle, "Slave Not Detected"
    End If
        
    'Close file before exiting
    Close #FileHandle

    'Hide and Unload  the RAM Loading Status Window
'    MakeTopMost frmRAMLoadStatus, False
'    frmRAMLoadStatus.Hide
'    Unload frmRAMLoadStatus
        
    'Exit the subroutine before the error handler
    Exit Sub
    
'Define error handler
FileError:
    'Display an error message
    MsgBox "Error: " & Err.Number & vbCrLf & Err.Description, vbApplicationModal + vbCritical + vbOKOnly, "File Error:"
    Close #FileHandle
    
    'Hide and Unload  the RAM Loading Status Window
    MakeTopMost frmRAMLoadStatus, False
    frmRAMLoadStatus.Hide
    Unload frmRAMLoadStatus
End Sub

Public Sub LoadSetup(ByVal FilePath As String)
    Dim FileHandle As Integer 'Handle to the file opened
    Dim cntr As Integer
    Dim sDummyString As String
    Dim vValue As Variant
    Dim ActForm As Form
    Dim ActControl As Control
    
    Dim FileType As String
    Dim FileRevNum As Double
    
    Dim AutoIOupdate(0 To 1) As Boolean
    
    Dim iprofile As Integer
    Dim lngSPMode As Long
    
    Dim DutCntr As Integer
    Dim StopCnt As Integer
    
    Dim TRInDut1 As Boolean
    
    TRInDut1 = True
    
    'Update the status bar and mouse pointer while setting are loading
    Screen.MousePointer = 11
    
    'Show the RAM Loading Status Window
'    frmRAMLoadStatus.lblMsg.Caption = "Loading DUT Settings"
'    frmRAMLoadStatus.Show
'    MakeTopMost frmRAMLoadStatus, True
'    frmRAMLoadStatus.Refresh
'
'    'Setup the status bar
'    With frmRAMLoadStatus
'        .pbrProgress.Min = 1
'        .pbrProgress.Max = 11
'        .pbrProgress.Value = .pbrProgress.Min
'        .Refresh
'    End With
    
    'Turn autofud off
    'EvalBd.AutoFUD_DUT1 = False
    'EvalBd.AutoFUD_DUT2 = False
    EvBd.AutoIOUpdate_DUT1 = False
    EvBd.AutoIOUpdate_DUT2 = False
    
    'Setup the errorhandler
    On Error GoTo LoadFileError
    
    'Get a file handle
    FileHandle = FreeFile
    
    'Open the file
    Open FilePath For Input As #FileHandle
    
    'Readback the first line which is the header
    Input #FileHandle, FileType, FileRevNum
    
    'Get blank line
    Input #FileHandle, sDummyString
    
    'Check the file version
    If FileType = "AD9956 Eval Software Settings File" Then
        'If the Slave was detected then setup to load it
        If EvBd.Dut2Detected = True Then
            StopCnt = 1
        Else
            StopCnt = 0
        End If
        
        'Get blank line
        Input #FileHandle, sDummyString
        
        For DutCntr = 0 To StopCnt
            'Check to see if there are any settings for the slave
            If sDummyString = "Slave Not Detected" Then
                'If not then exit the for loop
                Exit For
            End If
            
            'Get the control windows settings
            With frmControl
                'Get the reference clock value
                Input #FileHandle, sDummyString, vValue
                .txtRefClk(DutCntr).Text = vValue
                .txtRefClk_KeyPress DutCntr, 13
                If DutCntr = 1 Then
                    'Get the reference clock value
                    Input #FileHandle, sDummyString, vValue
                    .chkUseDUT1RefClk.Value = vValue
                End If
                
                'Get the profile to select
                Input #FileHandle, sDummyString, iprofile
                
                'Get the AutoIOUpdate Setting
                Input #FileHandle, sDummyString, vValue
                AutoIOupdate(DutCntr) = vValue
                
'                If DutCntr = 0 Then
'                    'Get the OSK Pin Value
'                    Input #FileHandle, sDummyString, vValue
'                    EvalBd.OSK_DUT1 = vValue
'                    EvalBd.WriteEvbBuffVal evb59Buff1
'                    'Get the Clock Mode Select Pin Value
'                    Input #FileHandle, sDummyString, vValue
'                    EvalBd.ClkMdSel_DUT1 = vValue
'                    EvalBd.WriteEvbBuffVal evb59Buff2
'                Else
'                    'Get the OSK Pin Value
'                    Input #FileHandle, sDummyString, vValue
'                    EvalBd.OSK_DUT2 = vValue
'                    EvalBd.WriteEvbBuffVal evb59Buff1
'                    'Get the Clock Mode Select Pin Value
'                    Input #FileHandle, sDummyString, vValue
'                    EvalBd.ClkMdSel_DUT2 = vValue
'                    EvalBd.WriteEvbBuffVal evb59Buff2
'                End If
                'Get one line
                Input #FileHandle, sDummyString
            End With
            
            With EvBd
                'Loop through all of the registers in the register map
                cntr = 0
                
                'Do
                For cntr = 0 To &HD
                    Input #FileHandle, sDummyString, vValue
                    .SetRegMapValue DutCntr + 1, rm9956_NewRegMapVals, cntr, vValue
                    .SetRegMapValue DutCntr + 1, rm9956_CurRegMapVals, cntr, vValue
                    '.sSetNewRegMapVal DutCntr + 1, cntr, vValue
                    '.sSetRegMapVal DutCntr + 1, cntr, vValue
                Next cntr
                
                If DutCntr = 0 Or (DutCntr = 1 And TRInDut1) Then
                    Input #FileHandle, sDummyString
                End If
                
                'Check to see if the test register is saved or not
                If sDummyString = "TR" Then
                    Input #FileHandle, vValue
                    .SetRegMapValue DutCntr + 1, rm9956_NewRegMapVals, &HE, vValue
                    .SetRegMapValue DutCntr + 1, rm9956_CurRegMapVals, &HE, vValue
                    If DutCntr = 0 Then
                        'Input the first record in the next set of data
                        Input #FileHandle, sDummyString
                    End If
                Else
                    TRInDut1 = False
                End If
                
                'Loop through all of the registers and load each
                For cntr = &HE To 0 Step -1
                    .SerialLoad DutCntr + 1, cntr, .GetRegMapValue(DutCntr + 1, rm9956_NewRegMapVals, cntr)
'                    If cntr = 2 Then
'                '        'Send a FUD
'                        EvBd.IOUpdate_DUT1 = abvHigh
'                        EvBd.IOUpdate_DUT2 = abvHigh
'                        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
'                        EvBd.IOUpdate_DUT1 = abvLow
'                        EvBd.IOUpdate_DUT2 = abvLow
'                        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
'                    End If
                        
                    'Update the status window
'                    frmRAMLoadStatus.pbrProgress.Value = cntr + 1
                Next cntr
                '.SerialLoad DutCntr + 1, 0, .sGetNewRegMapVal(DutCntr + 1, 0)
           End With
            
            'Set the profile that was saved
            EvBd.SetActiveProfile DutCntr + 1, iprofile
        Next DutCntr
        
'        'Send a FUD
        EvBd.IOUpdate_DUT1 = abvHigh
        EvBd.IOUpdate_DUT2 = abvHigh
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        EvBd.IOUpdate_DUT1 = abvLow
        EvBd.IOUpdate_DUT2 = abvLow
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        
        'Refresh the forms
        frmControl.RefreshControls
        frmIOInterface.RefreshControls
        frmCP_ClkDrv_Ctrl.RefreshControls
        frmProfiles.RefreshControls
        frmLinSweepSetup.RefreshControls
        
        If IsLoaded("frmTestRegister") Then
            frmTestRegister.RefreshControls
        End If
        
        If IsLoaded("frmDebug") Then
            frmDebug.RefreshControls
        End If
        
'        EvalBoard.FUD = abvLow
'
        'Turn autofud back on
        EvBd.AutoIOUpdate_DUT1 = AutoIOupdate(0)
        EvBd.AutoIOUpdate_DUT2 = AutoIOupdate(1)
        frmDUTSignals.RefreshControls
        
        'Hide and Unload  the RAM Loading Status Window
'        MakeTopMost frmRAMLoadStatus, False
'        frmRAMLoadStatus.Hide
'        Unload frmRAMLoadStatus
        
        'Update the status bar and mouse pointer back to normal
'        mdiMain.StatusText = ""
        Screen.MousePointer = 0
    Else
        Screen.MousePointer = 0
        'Show setup file error
        MsgBox "Invalid setup file!", vbApplicationModal + vbExclamation + vbOKOnly, "Error Loading Setup File!"
    End If
    
    'Close file before exiting
    Close #FileHandle

    'Exit the subroutine before errorhandler
    Exit Sub

'Define the error handler
LoadFileError:
    
    Screen.MousePointer = 0
    'Display an error message
    MsgBox "Error Number: " & Err.Number & vbCrLf & Err.Description, vbApplicationModal + vbCritical + vbOKOnly, "Load File Error"
    
    'Close file before exiting
    Close #FileHandle

    'Hide and Unload  the RAM Loading Status Window
'    MakeTopMost frmRAMLoadStatus, False
'    frmRAMLoadStatus.Hide
'    Unload frmRAMLoadStatus
End Sub

'Changes the GUI interface to match the usermode
Public Sub SetDebugMode(ByVal sMode As String)
    Select Case UCase(sMode)
        Case "DEBUGMODE", "-DEBUGMODE"
            'Hide control window items
            frmControl.chkDACPrimeDataDisable(0).Visible = False
            frmControl.chkDACPrimeDataDisable(1).Visible = False
            frmControl.chkSyncDacNMux(0).Visible = False
            frmControl.chkSyncDacNMux(1).Visible = False
            frmControl.fraDithering(0).Visible = False
            frmControl.fraDithering(1).Visible = False
                        
            'Hide charge pump window items
            frmCP_ClkDrv_Ctrl.optClkDrvInputSel0(0).Visible = False
            frmCP_ClkDrv_Ctrl.optClkDrvInputSel0(1).Visible = False
            
            'Hide Dut Signals Window
            frmDUTSignals.cmdPLLLockSlave.Visible = False
            
            'Hide menus
            mdiMain.mnuViewTestRegWindow.Visible = False
            mdiMain.mnuViewSep1.Visible = False
            mdiMain.mnuView640x480.Visible = False
            mdiMain.mnuView800x600.Visible = False
            mdiMain.mnuTools.Visible = False
            mdiMain.mnuPCIOSep1.Visible = False
            mdiMain.mnuPCIOFindEvalBd.Visible = False
                
            'Show menus
            mdiMain.mnuViewSep0.Visible = True
            mdiMain.mnuViewDebugWindow.Visible = True
            mdiMain.mnuViewDDEServer.Visible = True
    
        Case "ADIFULLENGMODE", "-ADIFULLENGMODE"
            'Show control window items
            frmControl.chkDACPrimeDataDisable(0).Visible = True
            frmControl.chkDACPrimeDataDisable(1).Visible = True
            frmControl.chkSyncDacNMux(0).Visible = True
            frmControl.chkSyncDacNMux(1).Visible = True
            frmControl.fraMisc(0).Visible = True
            frmControl.fraMisc(1).Visible = True
            frmControl.fraDithering(0).Visible = True
            frmControl.fraDithering(1).Visible = True
                        
            'Show charge pump window items
            frmCP_ClkDrv_Ctrl.optClkDrvInputSel0(0).Visible = True
            frmCP_ClkDrv_Ctrl.optClkDrvInputSel0(1).Visible = True
            
            'Show Dut Signals Window
            frmDUTSignals.cmdPLLLockSlave.Visible = True
            
            'Hide menus
            mdiMain.mnuViewSep1.Visible = False
            mdiMain.mnuView640x480.Visible = False
            mdiMain.mnuView800x600.Visible = False
            mdiMain.mnuTools.Visible = False
        
            'Show menus
            mdiMain.mnuViewSep0.Visible = True
            mdiMain.mnuViewTestRegWindow.Visible = True
            mdiMain.mnuViewDebugWindow.Visible = True
            mdiMain.mnuPCIOSep1.Visible = True
            mdiMain.mnuPCIOFindEvalBd.Visible = True
            mdiMain.mnuViewDDEServer.Visible = True
        
        Case Else 'Setup for normal mode
            'Hide control window items
            frmControl.chkDACPrimeDataDisable(0).Visible = False
            frmControl.chkDACPrimeDataDisable(1).Visible = False
            frmControl.chkSyncDacNMux(0).Visible = False
            frmControl.chkSyncDacNMux(1).Visible = False
            frmControl.fraDithering(0).Visible = False
            frmControl.fraDithering(1).Visible = False
                        
            'Hide charge pump window items
            frmCP_ClkDrv_Ctrl.optClkDrvInputSel0(0).Visible = False
            frmCP_ClkDrv_Ctrl.optClkDrvInputSel0(1).Visible = False
            
            'Hide Dut Signals Window
            frmDUTSignals.cmdPLLLockSlave.Visible = False
            
            'Hide menus
            'mdiMain.mnuViewSep0.Visible = False
            mdiMain.mnuViewTestRegWindow.Visible = False
            'mdiMain.mnuViewDebugWindow.Visible = False
            mdiMain.mnuViewSep1.Visible = False
            mdiMain.mnuView640x480.Visible = False
            mdiMain.mnuView800x600.Visible = False
            mdiMain.mnuPCIOSep1.Visible = True
            mdiMain.mnuPCIOFindEvalBd.Visible = True
            
            mdiMain.mnuTools.Visible = False
            
            mdiMain.mnuHelpContents.Enabled = False
            mdiMain.mnuViewDDEServer.Visible = False
'            mdiMain.mnuPCIOSep1.Visible = False
'            mdiMain.mnuPCIOFindEvalBd.Visible = False
    End Select
    
    'Check to see if the help file exists and enable or disable the menu
    'and toolbar selections.
    If FileExists(App.path & "\" & "AD9956HELP.HLP") Then
        mdiMain.mnuHelpContents.Enabled = True
        mdiMain.tlbMainToolBar.Buttons(8).Enabled = True
    Else
        mdiMain.mnuHelpContents.Enabled = False
        mdiMain.tlbMainToolBar.Buttons(8).Enabled = False
    End If
End Sub

Public Sub DetectEvalBoard()
    Dim LPTBaseAddr As Integer
    
    'Show the status form
    frmFindEvalBoard.Show
    frmFindEvalBoard.AddStatLine "*** Notice ***"
    frmFindEvalBoard.AddStatLine "This operation will reset the evaluation board."
        
    'Indicate that there is no current PCInterface
    EvBd.PCInterface = -1
    If clsEZUSBDev01.USBDriverIsInstalled Then
        If IsLoaded("frmFindEvalBoard") Then
            frmFindEvalBoard.AddStatLine "USB Driver appears to be installed..."
            frmFindEvalBoard.AddStatLine "Checking the USB Bus..."
        End If
        
        If EvBd.USBFindEvalBD() >= 1 Then
            If IsLoaded("frmFindEvalBoard") Then
                frmFindEvalBoard.AddStatLine "Found " & CStr(clsEZUSBDev01.DeviceCount) & " Eval Boards on USB Bus"
            End If
            
            'If a Valid USB device was found then select USB
            EvBd.PCInterface = 0
            clsEZUSBDev01.SelectDevice (0)
            
            'Update the status bar
            mdiMain.pbxStatus.Visible = True
            mdiMain.lblPCIOStatusDisplay.Visible = True
            mdiMain.lblPCIOStatus.Visible = True
            mdiMain.lblPCIOStatusDisplay.Caption = " Connected "
            mdiMain.lblPCIOStatusDisplay.ForeColor = StatForeColorOk
            mdiMain.lblPCIOStatusDisplay.BackColor = StatBackColorOk
            mdiMain.lblPCIOStatusDisplay.Refresh
            
            If IsLoaded("frmFindEvalBoard") Then
                'Notify the device being used
                frmFindEvalBoard.AddStatLine "Using " & CStr(clsEZUSBDev01.DriverName) & "..."
            End If
            
            'Change the menu that brings up the USB Dialog
            mdiMain.mnuPCIOSelectLPTPort.Caption = "Select Eval Board..."
        Else
            If IsLoaded("frmFindEvalBoard") Then
                frmFindEvalBoard.AddStatLine "No Eval Boards Found on USB Bus..."
            End If
        End If
    End If
    
    If EvBd.PCInterface <> 0 Then
        If DriverXInstalled() Then  'Test to make sure that DriverX is installed
            'Manualy force into Parallel Port Mode
            EvBd.PCInterface = 1
            'Detect the LPT ports
            LPTBaseAddr = frmLPTSelect.LPTSelectDialog("Select an LPT Port", "Select the LPT Port that the Evaluation Board is connected to.", False, 1)
            If EvBd.PPFindEvalBD Then
                If IsLoaded("frmFindEvalBoard") Then
                    frmFindEvalBoard.AddStatLine "Found Eval Board on LPT" & frmLPTSelect.lstLPTPorts.ListIndex + 1 & "..."
                End If
            Else
                If IsLoaded("frmFindEvalBoard") Then
                    frmFindEvalBoard.AddStatLine "Eval Board was not found using parallel port..."
                End If
                EvBd.PCInterface = -1
            End If
        End If
    End If
    
    'No Evalboard was found attached to the system
    If EvBd.PCInterface = -1 Then
        If IsLoaded("frmFindEvalBoard") Then
            frmFindEvalBoard.AddStatLine ""
            frmFindEvalBoard.txtStatus.ForeColor = &HFF
            frmFindEvalBoard.AddStatLine "No AD9956 Evaluation Board found..."
            frmFindEvalBoard.AddStatLine ""
        End If
    Else
        If IsLoaded("frmFindEvalBoard") Then
            'Update the status window
            frmFindEvalBoard.AddStatLine "Initializing the Evaluation Board..."
        End If
        'Re initialize the eval board
        EvBd.InitEvalBd
    End If

    If EvBd.PCInterface <> -1 Then
        If IsLoaded("frmFindEvalBoard") Then
            frmFindEvalBoard.AddStatLine ""
            'Update the status window
            frmFindEvalBoard.AddStatLine "Resetting the Eval Board & Detecting DUTs..."
        End If
        'Reset the DUTs
        EvBd.DetectDUTs Dut1Detected, Dut2Detected
        If Dut1Detected Then
            If IsLoaded("frmFindEvalBoard") Then
                'Update the status window
                frmFindEvalBoard.AddStatLine "Master DUT detected..."
                mdiMain.lblDUTStatus(0).BackColor = StatBackColorOk
                mdiMain.lblDUTStatus(0).ForeColor = StatForeColorOk
            End If
        Else
            If IsLoaded("frmFindEvalBoard") Then
                'Update the status window
                frmFindEvalBoard.AddStatLine "Master DUT not detected..."
                mdiMain.lblDUTStatus(0).BackColor = vb3DFace
                mdiMain.lblDUTStatus(0).ForeColor = vb3DShadow
            End If
        End If
    
        If Dut2Detected Then
            If IsLoaded("frmFindEvalBoard") Then
                'Update the status window
                frmFindEvalBoard.AddStatLine "Slave DUT detected..."
            End If
            
            'Indicate that Slave was detected
            frmControl.tspDUTSel.Tabs(2).Caption = "Slave"
            frmControl.tspDUTSel.Enabled = True
            frmControl.chkLoadDUT2.Enabled = True
            frmCP_ClkDrv_Ctrl.tspDUTSel.Tabs(2).Caption = "Slave"
            frmCP_ClkDrv_Ctrl.tspDUTSel.Enabled = True
            frmCP_ClkDrv_Ctrl.chkLoadDUT2.Enabled = True
            frmProfiles.tspDUTSel.Tabs(2).Caption = "Slave"
            frmProfiles.tspDUTSel.Enabled = True
            frmProfiles.chkLoadDUT2.Enabled = True
            frmLinSweepSetup.tspDUTSel.Tabs(2).Caption = "Slave"
            frmLinSweepSetup.tspDUTSel.Enabled = True
            frmLinSweepSetup.chkLoadDUT2.Enabled = True
        
            mdiMain.lblDUTStatus(1).BackColor = StatBackColorOk
            mdiMain.lblDUTStatus(1).ForeColor = StatForeColorOk
        
        Else
            If IsLoaded("frmFindEvalBoard") Then
                'Update the status window
                frmFindEvalBoard.AddStatLine "Slave DUT not detected..."
            End If

            'Indicate that no Slave was detected
            frmControl.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmControl.tspDUTSel.Enabled = False
            frmControl.chkLoadDUT2.Enabled = False
            frmCP_ClkDrv_Ctrl.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmCP_ClkDrv_Ctrl.tspDUTSel.Enabled = False
            frmCP_ClkDrv_Ctrl.chkLoadDUT2.Enabled = False
            frmProfiles.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmProfiles.tspDUTSel.Enabled = False
            frmProfiles.chkLoadDUT2.Enabled = False
            frmLinSweepSetup.tspDUTSel.Tabs(2).Caption = "Slave - Not Detected"
            frmLinSweepSetup.tspDUTSel.Enabled = False
            frmLinSweepSetup.chkLoadDUT2.Enabled = False
        
            mdiMain.lblDUTStatus(1).BackColor = vb3DFace
            mdiMain.lblDUTStatus(1).ForeColor = vb3DShadow
        End If
    
        If Dut2Detected = False And Dut1Detected = False And IsLoaded("frmFindEvalBoard") Then
            frmFindEvalBoard.AddStatLine ""
            frmFindEvalBoard.txtStatus.ForeColor = &HFF
            frmFindEvalBoard.AddStatLine "DUT Missing!!!"
            frmFindEvalBoard.AddStatLine ""
        End If
    End If
    
    If EvBd.PCInterface = 0 Then
        'EvalBoard found on USB Bus
        'Update all forms to reflect the change
        Enable_GUI_IO True
        'Enable USB Device Polling
        mdiMain.tmrPollEvalBd.Enabled = True
        If IsLoaded("frmFindEvalBoard") Then
            'Logit on the splash screen
            frmFindEvalBoard.AddStatLine "Enabling USB Evalbd Polling..."
        End If
    ElseIf EvBd.PCInterface = 1 Then
        'EvalBoard Found on Parallel Port
        mdiMain.tmrPollEvalBd.Enabled = False
        mdiMain.pbxStatus.Visible = False
        
        'Update all forms to reflect the change
        Enable_GUI_IO True
    ElseIf EvBd.PCInterface = -1 Then
        'No evalboard found
        'EvalBoard Found on Parallel Port
        mdiMain.tmrPollEvalBd.Enabled = False
        mdiMain.pbxStatus.Visible = False
        'Update all forms to reflect the change
        Enable_GUI_IO False
    End If

    
End Sub

Public Sub Enable_GUI_IO(ByVal mDevConnected As Boolean)
    'Update all forms to reflect the change
    mdiMain.mnuFileLoadSetup.Enabled = mDevConnected
    mdiMain.mnuFileDumpToSetupFile.Enabled = mDevConnected
    mdiMain.tlbMainToolBar.Buttons(1).Enabled = mDevConnected
    
    If IsLoaded("frmControl") Then
        frmControl.EnableIO mDevConnected
    End If
    If IsLoaded("frmProfiles") Then
        frmProfiles.EnableIO mDevConnected
    End If
    If IsLoaded("frmLinSweepSetup") Then
        frmLinSweepSetup.EnableIO mDevConnected
    End If
    If IsLoaded("frmCP_ClkDrv_Ctrl") Then
        frmCP_ClkDrv_Ctrl.EnableIO mDevConnected
    End If
    If IsLoaded("frmDUTSignals") Then
        frmDUTSignals.EnableIO mDevConnected
    End If
    If IsLoaded("frmIOInterface") Then
        frmIOInterface.EnableIO mDevConnected
    End If
End Sub
