Attribute VB_Name = "modHook"

    '***************************************************************
    'Windows API/Global Declarations for :Message Hooking in VB w/o a
    '     custom control
    '***************************************************************
    Public Const WM_SIZE = &H5
    Public Const WM_MOVE = &H3
    Public Const WM_WINDOWPOSCHANGED = &H47
    Public Const WM_MOUSEMOVE = &H200
    Public Const WM_ENTERSIZEMOVE = &H231
    Public Const WM_EXITSIZEMOVE = &H232
    Public Const WM_SIZING = &H214
    Public Const WM_MOVING = &H216
    
    'Message and events for Device Added and Removed
    Public Const WM_DEVICECHANGE = &H219
    Public Const DBT_DEVNODES_CHANGED = &H7
    Public Const DBT_DEVICEARRIVAL = &H8000
    Public Const DBT_DEVICEQUERYREMOVE = &H8001
    Public Const DBT_DEVICEQUERYREMOVEFAILED = &H8002
    Public Const DBT_DEVICEREMOVEPENDING = &H8003
    Public Const DBT_DEVICEREMOVECOMPLETE = &H8004
    
    Public Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
    Public Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    
    Public Const GWL_WNDPROC = (-4)
    Public OriginalWndProc As Long

    '***************************************************************
    ' Name: Message Hooking in VB w/o a custom control
    ' Description:Hook messages from the system and other
    '             applications in VB6.
    '
    ' Inputs:None
    '
    ' Returns:None
    '
    'Assumes:None
    '
    'Side Effects:None
    '
    '***************************************************************

    Public Sub HookWindow(hWnd As Long)

        OriginalWndProc = SetWindowLong(hWnd, GWL_WNDPROC, AddressOf MessageSpy)
    End Sub
    'Restores origional opperation
    Public Sub FreeWindow(hWnd As Long)

        SetWindowLong hWnd, GWL_WNDPROC, OriginalWndProc
    End Sub

    Public Function MessageSpy(ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, _
        ByVal lParam As Long) As Long
'        Static SizingFlag As Boolean
'        Static ClipRect As RECT
'        Static MousePos As POINTAPI
'        Static FormCenter As POINTAPI
        Dim RunOrigionalProc As Boolean
        
        'Set the RunOrigionalProc flag to true
        RunOrigionalProc = True
                
        'Test the message received...
        Select Case Msg
            Case WM_DEVICECHANGE:
                Select Case wParam
                    Case DBT_DEVICEARRIVAL:
                        Debug.Print "Device Added To System."
                    Case DBT_DEVICEQUERYREMOVE:
                        Debug.Print "DBT_DEVICEQUERYREMOVE"
                    Case DBT_DEVICEQUERYREMOVEFAILED:
                        Debug.Print "DBT_DEVICEQUERYREMOVEFAILED"
                    Case DBT_DEVICEREMOVECOMPLETE:
                        Debug.Print "DBT_DEVICEREMOVECOMPLETE"
                    Case DBT_DEVICEREMOVEPENDING:
                        Debug.Print "DBT_DEVICEREMOVEPENDING"
                    'The only message event that gets fired in Windows 2k/Xp
                    'when a USB device is added or removed
                    Case DBT_DEVNODES_CHANGED:
                        Debug.Print "USB Device Change!"
                End Select
            Case WM_SIZE:
                'Debug.Print "WM_Size message."
            Case WM_MOVE:
'                Debug.Print "WM_Move message."
            Case WM_WINDOWPOSCHANGED:
'                Debug.Print "WM_WINDOWPOSCHANGED message."
            Case WM_MOUSEMOVE:
'                Debug.Print "WM_MOUSEMOVE message."
            Case WM_ENTERSIZEMOVE:
'                Debug.Print "WM_ENTERSIZEMOVE message."
'                'Get the windows size
'                ClipRect = GetWindowPixelRect(frmHookWindow)
''                ClipRect.Right = ClipRect.Right
''                ClipRect.Bottom = ClipRect.Bottom
'
'                'Calculate the forms center
'                FormCenter.X = CInt((ClipRect.Left + (ClipRect.Right - ClipRect.Left)) / 2)
'                FormCenter.Y = CInt((ClipRect.Top + (ClipRect.Top - ClipRect.Bottom)) / 2)
'                Call GetCursorPos(MousePos)
'
''                If MousePos.x < FormCenter.x and mousepos.x < Then
'
''                End If
            Case WM_EXITSIZEMOVE:
                'Remove the cliping region
'                ClipMouseCursorPos ClipRect, True
                'Debug.Print "WM_EXITSIZEMOVE message."
            Case WM_MOVING:
                'Debug.Print "WM_MOVING message."
                
            Case WM_SIZING:
                'Dont run the origional proc
                'RunOrigionalProc = False
                'Debug.Print "WM_SIZEING message."
                'Clip the mouse cursor to a certian window size
'                ClipMouseCursorPos ClipRect
'                SizingFlag = True
            Case Else: 'Debug.Print "Unknown Message = " & Hex(Msg) & " Hex."
        End Select
        If RunOrigionalProc Then
            'Pass it on to the normal window processor.
            MessageSpy = CallWindowProc(OriginalWndProc, hWnd, Msg, wParam, lParam)
        End If
    End Function



