Attribute VB_Name = "modEditOutFreq"
Option Explicit
'Define the number of bits in the tunning word
'Public TWBits = 24

'Gets the format string for the Output frequency
'if EOFSysClk isn't supplied then the format string is calculated at a 1MHz system clock
Public Function GetOutFreqFormatStr(ByVal TWBitRes As Integer, Optional EOFSysClk) As String
    Dim OutFreqval As Double
    Dim sOutFreqVal As String
    Dim cntr As Integer
    
    If Not IsMissing(EOFSysClk) Then
        If Not IsNumeric(EOFSysClk) Then
            EOFSysClk = 0
        End If
    End If
    
    If IsMissing(EOFSysClk) Then
        'First calculate the output frequency
        OutFreqval = DecTW2CarrierFreq(1, 1, TWBitRes)
    Else
        'First calculate the output frequency
        OutFreqval = DecTW2CarrierFreq(1, EOFSysClk, TWBitRes)
    End If
    
    'Get a string version formated with plenty of digits
    sOutFreqVal = Format(OutFreqval, "0.00000000000000000000000000000000000000")
    
    For cntr = 1 To 40
        If Mid(sOutFreqVal, cntr, 1) <> "0" And Mid(sOutFreqVal, cntr, 1) <> GetDecSeparator(False) Then
            Exit For
        End If
    Next cntr
    
    GetOutFreqFormatStr = "0." & String(cntr - 1, "0")
End Function


'Formats the output frequency for display in the output frequency textbox
Public Function FormatOutFreq(ByVal OutFreqval As Double, ByVal TWBitRes As Integer, Optional EOFSysClk) As String
    Dim NumberOfBits As Variant '114 maximum
    Dim OutFFStr As String
    
    'Set the number of tunning word bits
    NumberOfBits = CDec(TWBitRes)
    
    If IsMissing(EOFSysClk) Then
        OutFFStr = GetOutFreqFormatStr(TWBitRes)
    Else
        OutFFStr = GetOutFreqFormatStr(TWBitRes, EOFSysClk)
    End If
    '
'    If OutFreqval >= 100 Then
'        FormatOutFreq = Format(OutFreqval, "000.0000000000000")
'    ElseIf OutFreqval >= 10 Then
'        FormatOutFreq = Format(OutFreqval, "00.0000000000000")
'    Else
        FormatOutFreq = Format(OutFreqval, OutFFStr) '"0.0000000000000")
'    End If
End Function

'This function will calculate the decimal value of a tunning word given
'the CarrierFreq, Sysclock and NumberOfBits to generate.
Public Function CalculateDecTuningWord(ByVal CarrierFreq As Double, ByVal SysClk As Double, ByVal TWBitRes As Integer) As Variant
    
    Dim TunningWord As Variant
    Dim SysClock As Variant
    Dim NumberOfBits As Variant '114 maximum
    
    'Convert the bit res value to a decimal value
    NumberOfBits = CDec(TWBitRes)
    
    'Convert the sysclk value to a decimal value
    'Use the sysclock passed to the function
    SysClock = CDec(SysClk)
    
    'Calculate the tunning word value
    TunningWord = Round(CDec((CDec(CarrierFreq) / SysClock) * (2 ^ NumberOfBits)))
    CalculateDecTuningWord = TunningWord
    
End Function
'Calculates the output frequency given the tunning word
Public Function DecTW2CarrierFreq(ByVal DecTW As Variant, ByVal SysClk As Double, ByVal TWBitRes As Integer) As Variant
    Dim SysClock As Variant
    Dim NumberOfBits As Variant '114 maximum
    
    'Convert to decimal value
    NumberOfBits = CDec(TWBitRes)
        
    'Use the sysclock passed to the function
    SysClock = CDec(SysClk)
    
    'Calculate the carrier frequency
    DecTW2CarrierFreq = CDec((DecTW / (2 ^ NumberOfBits)) * SysClock)
End Function


'Returns the decimal seperator in either ascii code or
'the character
Private Function GetDecSeparator(ByVal RetAsciiCode As Boolean) As Variant
    If RetAsciiCode Then
        GetDecSeparator = Asc(Mid(Format(0, "Fixed"), 2, 1))
    Else
        GetDecSeparator = Mid(Format(0, "Fixed"), 2, 1)
    End If
End Function

