Attribute VB_Name = "modEditDialogSubs"
'Contains publicly used functions for the
'EditFreqRampRate dialog and EditPhaseOffset dialogs
Global Const NumPhaseBits = 14
Global Const NumOSFBits = 14
Public EditDialogSysClk9956 As Variant

'*****************************************************************************
'* EditFreqRampRate Function                                                 *
'*****************************************************************************
'Calculates the RampRate time
Public Function CalculateRRTime(ByVal RRWord As Long, Optional SysClk) As Double
    If IsMissing(SysClk) Then
        'Calculate the ramp rate time
        CalculateRRTime = CDbl(4 * RRWord / CDbl(EditDialogSysClk9956))
    Else
        If IsNumeric(SysClk) Then
            'Calculate the ramp rate time
            CalculateRRTime = CDbl(4 * RRWord / CDbl(SysClk))
        Else
            MsgBox "Error: CalculateRRTime()" & vbCrLf & "Invalid system clock value.", vbCritical + vbOKOnly, "Invalid Parameter Passed"
        End If
    End If
End Function
'*****************************************************************************
'* EditFreqRampRate Function                                                 *
'*****************************************************************************
'Calculates the RampRate word
Public Function CalculateRRWord(ByVal RRTime As String, Optional SysClk) As Long
    'Calculate the ramp rate word to be programmed into the AD9858
'    CalculateRRWord = DecFix((CDbl(RRTime) * CDbl(frmControl.txtIntClockFreq.Text)) / 8)
    If IsMissing(SysClk) Then
        CalculateRRWord = CLng(RRTime * (EditDialogSysClk9956 / 4))
    Else
        If IsNumeric(SysClk) Then
            CalculateRRWord = CLng(RRTime * (SysClk / 4))
        Else
            MsgBox "Error: CalculateRRWord()" & vbCrLf & "Invalid system clock value.", vbCritical + vbOKOnly, "Invalid Parameter Passed"
        End If
    End If
End Function

'*****************************************************************************
'* EditFreqRampRate Function                                                 *
'*****************************************************************************
'Formats the Ramp Rate Time for display in a textbox
Public Function FormatRRT(ByVal RampRateTime As Double) As String
'    If RampRateTime >= 100 Then
'        FormatRRT = Format(RampRateTime, "000.0000")
'    ElseIf RampRateTime >= 10 Then
'        FormatRRT = Format(RampRateTime, "00.0000")
'    Else
        FormatRRT = Format(RampRateTime, "0.0000")
'    End If
End Function

'*****************************************************************************
'* EditPhaseOffset Function                                                  *
'*****************************************************************************
Public Function CalcPO(ByVal DecVal As Double)
    CalcPO = DecVal * (360 / 2 ^ NumPhaseBits)
End Function

'*****************************************************************************
'* EditPhaseOffset Function                                                  *
'*****************************************************************************
'Public Function CalcNearestPO(ByVal PO As Double)
'    Dim DecVal As Double
'
'    DecVal = CalcPODecVal(PO)
'    CalcNearestPO = CalcPO(DecVal)
'End Function

'*****************************************************************************
'* EditRAMRampRate Function                                                 *
'*****************************************************************************
'Calculates the RampRate time
Public Function CalculateRAMRRTime(ByVal RRWord As Long, Optional SysClk) As Double
    If IsMissing(SysClk) Then
        'Calculate the ramp rate time
        CalculateRAMRRTime = CDbl(RRWord * 4 / CDbl(EditDialogSysClk9956))
    Else
        If IsNumeric(SysClk) Then
            'Calculate the ramp rate time
            CalculateRAMRRTime = CDbl(RRWord * 4 / CDbl(SysClk))
        Else
            MsgBox "Error: CalculateRAMRRTime()" & vbCrLf & "Invalid system clock value.", vbCritical + vbOKOnly, "Invalid Parameter Passed"
        End If
    End If
End Function
'*****************************************************************************
'* EditRAMRampRate Function                                                 *
'*****************************************************************************
'Calculates the RampRate word
Public Function CalculateRAMRRWord(ByVal RRTime As String, Optional SysClk) As Long
    'Calculate the ramp rate word to be programmed into the AD9858
'    CalculateRRWord = DecFix((CDbl(RRTime) * CDbl(frmControl.txtIntClockFreq.Text)) / 8)
    If IsMissing(SysClk) Then
        CalculateRAMRRWord = CLng(RRTime * EditDialogSysClk9956 / (4))
    Else
        If IsNumeric(SysClk) Then
            CalculateRAMRRWord = CLng(RRTime * SysClk / (4))
        Else
            MsgBox "Error: CalculateRAMRRWord()" & vbCrLf & "Invalid system clock value.", vbCritical + vbOKOnly, "Invalid Parameter Passed"
        End If
    End If
End Function

'Formats the Ramp Rate Time for display in a textbox
Public Function FormatRAMRRT(ByVal RampRateTime As Double) As String
'    If RampRateTime >= 100 Then
'        FormatRAMRRT = Format(RampRateTime, "000.00")
'    ElseIf RampRateTime >= 10 Then
'        FormatRAMRRT = Format(RampRateTime, "00.00")
'    Else
        FormatRAMRRT = Format(RampRateTime, "0.0000")
'    End If
End Function

'Caluclates the OSF word for an OSF value
Public Function CalculateOSFWord(ByVal dOSF As Double) As Long
    'Calucate the OSF word
    CalculateOSFWord = dOSF * ((2 ^ NumOSFBits) - 1)
End Function

'Caluclates the OSF word for an OSF value
Public Function CalculateOSF(ByVal lOSFWord As Long) As Double
    'Calucate the OSF value
    CalculateOSF = lOSFWord / ((2 ^ NumOSFBits) - 1)
End Function

Public Function CalcPODecVal(ByVal PO As Double) As Long
    CalcPODecVal = CLng((PO * 2 ^ NumPhaseBits) / 360)
End Function

'Returns the decimal seperator in either ascii code or
'the character
Public Function GetDecSeparator(ByVal RetAsciiCode As Boolean) As Variant
    If RetAsciiCode Then
        GetDecSeparator = Asc(Mid(Format(0, "Fixed"), 2, 1))
    Else
        GetDecSeparator = Mid(Format(0, "Fixed"), 2, 1)
    End If
End Function

